package com.ejie.y41b.model;

import java.util.Date;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;

/**
 * BandejaAlerta  
 * 
 *  
 */

public class BandejaAlerta implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String v5codigo;
	private String alcodigo;
	private String crcodigo;
	private String crcoor;
	private String crcodigodistribuidor;
	private Date crfechacomunicacion;
	private Integer crcnactu;
	private Alerta alerta;
	private Intervinientes intervinientes;

	private Integer numInspeccionesRealizadas;
	private Integer numInspeccionesEnCurso;
	private Integer numProductosDestruidos;
	private Integer numProductosDevueltosOrigen;
	private Integer numProductosInmovilizados;
	private Integer numProductosLibreComercializacion;
	private Integer numProductosOtros;
	private Integer numProductosTomaMuestras;
	private Integer numProductosRecuperados;
	private Integer numProductosPendientes;
	private String alproducto;
	private Date crfechaplazo;

	/**
	 * Method 'BandejaAlerta'.
	 */
	public BandejaAlerta() {
	}

	/**
	 * Method 'BandejaAlerta'.
	 * 
	 * @param v5codigo
	 *            String
	 * @param alcodigo
	 *            String
	 * @param crcodigo
	 *            String
	 * @param crcoor
	 *            String
	 * @param crcodigodistribuidor
	 *            String
	 * @param crfechacomunicacion
	 *            Date
	 * @param crcnactu
	 *            Integer
	 * @param alerta
	 *            Alerta
	 * @param intervinientes
	 *            Intervinientes
	 * @param crfechaplazo
	 *            Date
	 */
	public BandejaAlerta(String v5codigo, String alcodigo, String crcodigo, String crcoor, String crcodigodistribuidor,
			Date crfechacomunicacion, Integer crcnactu, Alerta alerta, Intervinientes intervinientes,
			Date crfechaplazo) {

		this.v5codigo = v5codigo;
		this.alcodigo = alcodigo;
		this.crcodigo = crcodigo;
		this.crcoor = crcoor;
		this.crcodigodistribuidor = crcodigodistribuidor;
		this.crfechacomunicacion = crfechacomunicacion;
		this.crcnactu = crcnactu;
		this.alerta = alerta;
		this.intervinientes = intervinientes;
		this.crfechaplazo = crfechaplazo;
	}

	/**
	 * Method 'getV5codigo'.
	 * 
	 * @return String
	 */

	public String getV5codigo() {
		return this.v5codigo;
	}

	/**
	 * Method 'setV5codigo'.
	 * 
	 * @param v5codigo
	 *            String
	 * @return
	 */

	public void setV5codigo(String v5codigo) {
		this.v5codigo = v5codigo;
	}

	/**
	 * Method 'getAlcodigo'.
	 * 
	 * @return String
	 */

	public String getAlcodigo() {
		return this.alcodigo;
	}

	/**
	 * Method 'setAlcodigo'.
	 * 
	 * @param alcodigo
	 *            String
	 * @return
	 */

	public void setAlcodigo(String alcodigo) {
		this.alcodigo = alcodigo;
	}

	/**
	 * Method 'getCrcodigo'.
	 * 
	 * @return String
	 */

	public String getCrcodigo() {
		return this.crcodigo;
	}

	/**
	 * Method 'setCrcodigo'.
	 * 
	 * @param crcodigo
	 *            String
	 * @return
	 */

	public void setCrcodigo(String crcodigo) {
		this.crcodigo = crcodigo;
	}

	/**
	 * Method 'getCrcoor'.
	 * 
	 * @return String
	 */

	public String getCrcoor() {
		return this.crcoor;
	}

	/**
	 * Method 'setCrcoor'.
	 * 
	 * @param crcoor
	 *            String
	 * @return
	 */

	public void setCrcoor(String crcoor) {
		this.crcoor = crcoor;
	}

	/**
	 * Method 'getCrcodigodistribuidor'.
	 * 
	 * @return String
	 */

	public String getCrcodigodistribuidor() {
		return this.crcodigodistribuidor;
	}

	/**
	 * Method 'setCrcodigodistribuidor'.
	 * 
	 * @param crcodigodistribuidor
	 *            String
	 * @return
	 */

	public void setCrcodigodistribuidor(String crcodigodistribuidor) {
		this.crcodigodistribuidor = crcodigodistribuidor;
	}

	/**
	 * Method 'getCrfechacomunicacion'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getCrfechacomunicacion() {
		return this.crfechacomunicacion;
	}

	/**
	 * Method 'setCrfechacomunicacion'.
	 * 
	 * @param crfechacomunicacion
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setCrfechacomunicacion(Date crfechacomunicacion) {
		this.crfechacomunicacion = crfechacomunicacion;
	}

	/**
	 * Method 'getCrcnactu'.
	 * 
	 * @return Integer
	 */

	public Integer getCrcnactu() {
		return this.crcnactu;
	}

	/**
	 * Method 'setCrcnactu'.
	 * 
	 * @param crcnactu
	 *            Integer
	 * @return
	 */

	public void setCrcnactu(Integer crcnactu) {
		this.crcnactu = crcnactu;
	}

	/**
	 * @return the alerta
	 */
	public Alerta getAlerta() {
		return alerta;
	}

	/**
	 * @param alerta
	 *            the alerta to set
	 */
	public void setAlerta(Alerta alerta) {
		this.alerta = alerta;
	}

	/**
	 * @return the intervinientes
	 */
	public Intervinientes getIntervinientes() {
		return intervinientes;
	}

	/**
	 * @param intervinientes
	 *            the intervinientes to set
	 */
	public void setIntervinientes(Intervinientes intervinientes) {
		this.intervinientes = intervinientes;
	}

	/**
	 * @return the numInspeccionesRealizadas
	 */
	public Integer getNumInspeccionesRealizadas() {
		return numInspeccionesRealizadas;
	}

	/**
	 * @param numInspeccionesRealizadas
	 *            the numInspeccionesRealizadas to set
	 */
	public void setNumInspeccionesRealizadas(Integer numInspeccionesRealizadas) {
		this.numInspeccionesRealizadas = numInspeccionesRealizadas;
	}

	/**
	 * @return the numProductosLibreComercializacion
	 */
	public Integer getNumProductosLibreComercializacion() {
		return numProductosLibreComercializacion;
	}

	/**
	 * @param numProductosLibreComercializacion
	 *            the numProductosLibreComercializacion to set
	 */
	public void setNumProductosLibreComercializacion(Integer numProductosLibreComercializacion) {
		this.numProductosLibreComercializacion = numProductosLibreComercializacion;
	}

	/**
	 * @return the numProductosOtros
	 */
	public Integer getNumProductosOtros() {
		return numProductosOtros;
	}

	/**
	 * @param numProductosOtros
	 *            the numProductosOtros to set
	 */
	public void setNumProductosOtros(Integer numProductosOtros) {
		this.numProductosOtros = numProductosOtros;
	}

	/**
	 * @return the numProductosTomaMuestras
	 */
	public Integer getNumProductosTomaMuestras() {
		return numProductosTomaMuestras;
	}

	/**
	 * @param numProductosTomaMuestras
	 *            the numProductosTomaMuestras to set
	 */
	public void setNumProductosTomaMuestras(Integer numProductosTomaMuestras) {
		this.numProductosTomaMuestras = numProductosTomaMuestras;
	}

	/**
	 * @return the numProductosDestruidos
	 */
	public Integer getNumProductosDestruidos() {
		return numProductosDestruidos;
	}

	/**
	 * @param numProductosDestruidos
	 *            the numProductosDestruidos to set
	 */
	public void setNumProductosDestruidos(Integer numProductosDestruidos) {
		this.numProductosDestruidos = numProductosDestruidos;
	}

	/**
	 * @return the numProductosDevueltosOrigen
	 */
	public Integer getNumProductosDevueltosOrigen() {
		return numProductosDevueltosOrigen;
	}

	/**
	 * @param numProductosDevueltosOrigen
	 *            the numProductosDevueltosOrigen to set
	 */
	public void setNumProductosDevueltosOrigen(Integer numProductosDevueltosOrigen) {
		this.numProductosDevueltosOrigen = numProductosDevueltosOrigen;
	}

	/**
	 * @return the numProductosInmovilizados
	 */
	public Integer getNumProductosInmovilizados() {
		return numProductosInmovilizados;
	}

	/**
	 * @param numProductosInmovilizados
	 *            the numProductosInmovilizados to set
	 */
	public void setNumProductosInmovilizados(Integer numProductosInmovilizados) {
		this.numProductosInmovilizados = numProductosInmovilizados;
	}

	/**
	 * @return the alproducto
	 */
	public String getAlproducto() {
		return alproducto;
	}

	/**
	 * @param alproducto
	 *            the alproducto to set
	 */
	public void setAlproducto(String alproducto) {
		this.alproducto = alproducto;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ v5codigo: ").append(this.v5codigo).append(" ]");
		result.append(", [ alcodigo: ").append(this.alcodigo).append(" ]");
		result.append(", [ crcodigo: ").append(this.crcodigo).append(" ]");
		result.append(", [ crcoor: ").append(this.crcoor).append(" ]");
		result.append(", [ crcodigodistribuidor: ").append(this.crcodigodistribuidor).append(" ]");
		result.append(", [ crfechacomunicacion: ").append(this.crfechacomunicacion).append(" ]");
		result.append(", [ crcnactu: ").append(this.crcnactu).append(" ]");
		result.append("}");
		return result.toString();
	}

	/**
	 * @return the crfechaplazo
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getCrfechaplazo() {
		return crfechaplazo;
	}

	/**
	 * @param crfechaplazo
	 *            the crfechaplazo to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setCrfechaplazo(Date crfechaplazo) {
		this.crfechaplazo = crfechaplazo;
	}

	/**
	 * @return the numInspeccionesEnCurso
	 */
	public Integer getNumInspeccionesEnCurso() {
		return numInspeccionesEnCurso;
	}

	/**
	 * @param numInspeccionesEnCurso
	 *            the numInspeccionesEnCurso to set
	 */
	public void setNumInspeccionesEnCurso(Integer numInspeccionesEnCurso) {
		this.numInspeccionesEnCurso = numInspeccionesEnCurso;
	}

	/**
	 * @return the numProductosRecuperados
	 */
	public Integer getNumProductosRecuperados() {
		return numProductosRecuperados;
	}

	/**
	 * @param numProductosRecuperados
	 *            the numProductosRecuperados to set
	 */
	public void setNumProductosRecuperados(Integer numProductosRecuperados) {
		this.numProductosRecuperados = numProductosRecuperados;
	}

	/**
	 * @return the numProductosPendientes
	 */
	public Integer getNumProductosPendientes() {
		return numProductosPendientes;
	}

	/**
	 * @param numProductosPendientes
	 *            the numProductosPendientes to set
	 */
	public void setNumProductosPendientes(Integer numProductosPendientes) {
		this.numProductosPendientes = numProductosPendientes;
	}

}
