package com.ejie.y41b.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.control.Y41bJsonDateTimeSerializer;

/**
 * AsientoRegistral  
 * 
 *  
 */

public class AsientoRegistralDetalle implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String idAsiento;
	private String pcodigo;
	private String idInterviniente;

	// SOL
	private String hdcodigo;

	// INS
	private String atcodigo;

	// SAN
	private String excodigo;

	// ARB
	private String sacodigo;

	private String motivoRechazo;

	/**
	 * Method 'AsientoRegistralDetalle'.
	 */
	public AsientoRegistralDetalle() {
	}

	/**
	 * Method 'AsientoRegistralDetalle'.
	 * 
	 * @param idAsiento
	 */
	public AsientoRegistralDetalle(String idAsiento) {
		super();
		this.idAsiento = idAsiento;
	}

	/**
	 * Method 'AsientoRegistral'.
	 * 
	 * @param idAsiento
	 *            String
	 * @param pcodigo
	 *            String
	 * 
	 * @param fechaRegistro
	 *            Date
	 * @param numRegistro
	 *            String
	 * @param solicitante
	 *            String
	 * @param resumen
	 *            String
	 * 
	 */
	public AsientoRegistralDetalle(String idAsiento, String pcodigo, String idInterviniente, String hdcodigo,
			String atcodigo, String excodigo, String sacodigo, String motivoRechazo) {

		// COMUN
		this.idAsiento = idAsiento;
		this.pcodigo = pcodigo;
		this.idInterviniente = idInterviniente;

		// SOL
		this.hdcodigo = hdcodigo;

		// INS
		this.atcodigo = atcodigo;

		// SAN
		this.excodigo = excodigo;

		// ARB
		this.sacodigo = sacodigo;

		this.motivoRechazo = motivoRechazo;
	}

	/**
	 * @return the idAsiento
	 */
	public String getIdAsiento() {
		return idAsiento;
	}

	/**
	 * @param idAsiento
	 *            the idAsiento to set
	 */
	public void setIdAsiento(String idAsiento) {
		this.idAsiento = idAsiento;
	}

	/**
	 * @return the pcodigo
	 */
	public String getPcodigo() {
		return pcodigo;
	}

	/**
	 * @param pcodigo
	 *            the pcodigo to set
	 */
	public void setPcodigo(String pcodigo) {
		this.pcodigo = pcodigo;
	}

	/**
	 * @return the idInterviniente
	 */
	public String getIdInterviniente() {
		return idInterviniente;
	}

	/**
	 * @param idInterviniente
	 *            the idInterviniente to set
	 */
	public void setIdInterviniente(String idInterviniente) {
		this.idInterviniente = idInterviniente;
	}

	/**
	 * @return the hdcodigo
	 */
	public String getHdcodigo() {
		return hdcodigo;
	}

	/**
	 * @param hdcodigo
	 *            the hdcodigo to set
	 */
	public void setHdcodigo(String hdcodigo) {
		this.hdcodigo = hdcodigo;
	}

	/**
	 * @return the atcodigo
	 */
	public String getAtcodigo() {
		return atcodigo;
	}

	/**
	 * @param atcodigo
	 *            the atcodigo to set
	 */
	public void setAtcodigo(String atcodigo) {
		this.atcodigo = atcodigo;
	}

	/**
	 * @return the excodigo
	 */
	public String getExcodigo() {
		return excodigo;
	}

	/**
	 * @param excodigo
	 *            the excodigo to set
	 */
	public void setExcodigo(String excodigo) {
		this.excodigo = excodigo;
	}

	/**
	 * @return the sacodigo
	 */
	public String getSacodigo() {
		return sacodigo;
	}

	/**
	 * @param sacodigo
	 *            the sacodigo to set
	 */
	public void setSacodigo(String sacodigo) {
		this.sacodigo = sacodigo;
	}

	/**
	 * @return the motivoRechazo
	 */
	public String getMotivoRechazo() {
		return motivoRechazo;
	}

	/**
	 * @param motivoRechazo
	 *            the motivoRechazo to set
	 */
	public void setMotivoRechazo(String motivoRechazo) {
		this.motivoRechazo = motivoRechazo;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idAsiento: ").append(this.idAsiento).append(" ]");
		result.append(", [ pcodigo: ").append(this.pcodigo).append(" ]");
		result.append(", [ idInterviniente: ").append(this.idInterviniente).append(" ]");
		result.append(", [ hdcodigo: ").append(this.hdcodigo).append(" ]");
		result.append(", [ atcodigo: ").append(this.atcodigo).append(" ]");
		result.append(", [ excodigo: ").append(this.excodigo).append(" ]");
		result.append(", [ sacodigo: ").append(this.sacodigo).append(" ]");
		result.append(", [ motivoRechazo: ").append(this.motivoRechazo).append(" ]");

		result.append("}");
		return result.toString();
	}

}
