package com.ejie.y41b.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.x38.serialization.JsonDateTimeDeserializer;
import com.ejie.y41b.control.Y41bJsonDateTimeDeserializer;
import com.ejie.y41b.control.Y41bJsonDateTimeSerializer;
import com.ejie.y41b.control.Y41bJsonDateTimeWithSecsSerializer;

/**
 * AsientoRegistral  
 * 
 *  
 */

public class AsientoRegistral implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String idAsiento;
	private String pcodigo;
	private String pnombre;
	private String pnombree;
	private Date fechaRegistro;
	private String numRegistro;
	private String solicitante;
	private String resumen;
	private String territorioHistorico;
	private String territorioHistoricoNombre;
	private Date fechaRegistroOrigen;
	private String numRegistroOrigen;
	private List<DocumentoAsientoRegistral> documentoAsientoRegistral = new ArrayList<DocumentoAsientoRegistral>();

	/**
	 * Method 'SolicitudTelematicaEventos'.
	 */
	public AsientoRegistral() {
	}

	/**
	 * Method 'AsientoRegistral'.
	 * 
	 * @param idAsiento
	 */
	public AsientoRegistral(String idAsiento) {
		super();
		this.idAsiento = idAsiento;
	}

	/**
	 * Method 'AsientoRegistral'.
	 * 
	 * @param idAsiento
	 *            String
	 * @param pcodigo
	 *            String
	 * @param pnombre
	 *            String
	 * @param pnombree
	 *            String
	 * @param fechaRegistro
	 *            Date
	 * @param numRegistro
	 *            String
	 * @param solicitante
	 *            String
	 * @param resumen
	 *            String
	 * @param territorioHistorico
	 *            String
	 * @param territorioHistoricoNombre
	 *            String
	 * @param fechaRegistroOrigen
	 *            Date
	 * @param numRegistroOrigen
	 *            String
	 */
	public AsientoRegistral(String idAsiento, String pcodigo, String pnombre, String pnombree, Date fechaRegistro,
			String numRegistro, String solicitante, String resumen, String territorioHistorico,
			String territorioHistoricoNombre, Date fechaRegistroOrigen, String numRegistroOrigen) {

		this.idAsiento = idAsiento;
		this.pcodigo = pcodigo;
		this.pnombre = pnombre;
		this.pnombree = pnombree;
		this.fechaRegistro = fechaRegistro;
		this.numRegistro = numRegistro;
		this.solicitante = solicitante;
		this.resumen = resumen;
		this.territorioHistorico = territorioHistorico;
		this.territorioHistoricoNombre = territorioHistoricoNombre;
		this.fechaRegistroOrigen = fechaRegistroOrigen;
		this.numRegistroOrigen = numRegistroOrigen;
	}

	/**
	 * @return the idAsiento
	 */
	public String getIdAsiento() {
		return idAsiento;
	}

	/**
	 * @param idAsiento
	 *            the idAsiento to set
	 */
	public void setIdAsiento(String idAsiento) {
		this.idAsiento = idAsiento;
	}

	/**
	 * @return the pcodigo
	 */
	public String getPcodigo() {
		return pcodigo;
	}

	/**
	 * @param pcodigo
	 *            the pcodigo to set
	 */
	public void setPcodigo(String pcodigo) {
		this.pcodigo = pcodigo;
	}

	/**
	 * @return the pnombre
	 */
	public String getPnombre() {
		return pnombre;
	}

	/**
	 * @param pnombre
	 *            the pnombre to set
	 */
	public void setPnombre(String pnombre) {
		this.pnombre = pnombre;
	}

	/**
	 * @return the pnombree
	 */
	public String getPnombree() {
		return pnombree;
	}

	/**
	 * @param pnombree
	 *            the pnombree to set
	 */
	public void setPnombree(String pnombree) {
		this.pnombree = pnombree;
	}

	/**
	 * @return the fechaRegistro
	 */

	@JsonSerialize(using = Y41bJsonDateTimeWithSecsSerializer.class)
	// @JsonSerialize(using = Y41bJsonDateTimeSerializer.class)
	public Date getFechaRegistro() {
		return fechaRegistro;
	}

	/**
	 * @param fechaRegistro
	 *            the fechaRegistro to set
	 */
	@JsonDeserialize(using = Y41bJsonDateTimeDeserializer.class)
	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	/**
	 * @return the numRegistro
	 */
	public String getNumRegistro() {
		return numRegistro;
	}

	/**
	 * @param numRegistro
	 *            the numRegistro to set
	 */
	public void setNumRegistro(String numRegistro) {
		this.numRegistro = numRegistro;
	}

	/**
	 * @return the solicitante
	 */
	public String getSolicitante() {
		return solicitante;
	}

	/**
	 * @param solicitante
	 *            the solicitante to set
	 */
	public void setSolicitante(String solicitante) {
		this.solicitante = solicitante;
	}

	/**
	 * @return the resumen
	 */
	public String getResumen() {
		return resumen;
	}

	/**
	 * @param resumen
	 *            the resumen to set
	 */
	public void setResumen(String resumen) {
		this.resumen = resumen;
	}

	/**
	 * @return the documentoAsientoRegistral
	 */
	@JsonIgnore
	public List<DocumentoAsientoRegistral> getDocumentoAsientoRegistral() {
		return documentoAsientoRegistral;
	}

	/**
	 * @param documentoAsientoRegistral
	 *            the documentoAsientoRegistral to set
	 */
	public void setDocumentoAsientoRegistral(List<DocumentoAsientoRegistral> documentoAsientoRegistral) {
		this.documentoAsientoRegistral = documentoAsientoRegistral;
	}

	/**
	 * @return the territorioHistorico
	 */
	public String getTerritorioHistorico() {
		return territorioHistorico;
	}

	/**
	 * @param territorioHistorico
	 *            the territorioHistorico to set
	 */
	public void setTerritorioHistorico(String territorioHistorico) {
		this.territorioHistorico = territorioHistorico;
	}

	/**
	 * @return the territorioHistoricoNombre
	 */
	public String getTerritorioHistoricoNombre() {
		return territorioHistoricoNombre;
	}

	/**
	 * @param territorioHistoricoNombre
	 *            the territorioHistoricoNombre to set
	 */
	public void setTerritorioHistoricoNombre(String territorioHistoricoNombre) {
		this.territorioHistoricoNombre = territorioHistoricoNombre;
	}

	/**
	 * @return the fechaRegistroOrigen
	 */
	@JsonSerialize(using = Y41bJsonDateTimeWithSecsSerializer.class)
	// @JsonSerialize(using = Y41bJsonDateTimeSerializer.class)
	public Date getFechaRegistroOrigen() {
		return fechaRegistroOrigen;
	}

	/**
	 * @param fechaRegistroOrigen
	 *            the fechaRegistroOrigen to set
	 */
	@JsonDeserialize(using = Y41bJsonDateTimeDeserializer.class)
	public void setFechaRegistroOrigen(Date fechaRegistroOrigen) {
		this.fechaRegistroOrigen = fechaRegistroOrigen;
	}

	/**
	 * @return the numRegistroOrigen
	 */
	public String getNumRegistroOrigen() {
		return numRegistroOrigen;
	}

	/**
	 * @param numRegistroOrigen
	 *            the numRegistroOrigen to set
	 */
	public void setNumRegistroOrigen(String numRegistroOrigen) {
		this.numRegistroOrigen = numRegistroOrigen;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idAsiento: ").append(this.idAsiento).append(" ]");
		result.append(", [ pcodigo: ").append(this.pcodigo).append(" ]");
		result.append(", [ pnombre: ").append(this.pnombre).append(" ]");
		result.append(", [ pnombree: ").append(this.pnombree).append(" ]");
		result.append(", [ fechaRegistro: ").append(this.fechaRegistro).append(" ]");
		result.append(", [ numRegistro: ").append(this.numRegistro).append(" ]");
		result.append(", [ solicitante: ").append(this.solicitante).append(" ]");
		result.append(", [ resumen: ").append(this.resumen).append(" ]");
		result.append(", [ territorioHistorico: ").append(this.territorioHistorico).append(" ]");
		result.append(", [ territorioHistoricoNombre: ").append(this.territorioHistoricoNombre).append(" ]");
		result.append(", [ fechaRegistroOrigen: ").append(this.fechaRegistroOrigen).append(" ]");
		result.append(", [ numRegistroOrigen: ").append(this.numRegistroOrigen).append(" ]");
		result.append("}");
		return result.toString();
	}

}
