package com.ejie.y41b.model;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.ejie.y41b.model.Arbsoldoctele;

import java.math.BigDecimal;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

/**
 * Arbsoltele  
 * 
 *  
 */

public class Arbsoltele implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private BigDecimal arbsolid;
	private String arbhdcod;
	private Date arbhdfec;
	private String arbhdte;
	private String arbhdcotsr;
	private BigDecimal arbhdcaptso;
	private String arbhdteso;
	private String arbsoltipnotif;
	private String arbsolidioma;
	private String arbsoltelem;
	private String arbsolemail;
	private String arbsolsms;
	private Date arbfecalta;
	private String arbsolregen;
	private Date arbsolfecregen;
	private String arbsolnif;
	private String arbsolnombre;
	private String arbsolcoor;
	private BigDecimal arbsolnran;
	private BigDecimal arbsolnror;
	private List<Arbsoldoctele> arbsoldocteles = new ArrayList<Arbsoldoctele>();

	// datos necesarios para crear el EJGV
	private String strListaDocumentos;

	/**
	 * Method 'Arbsoltele'.
	 */
	public Arbsoltele() {
	}

	/**
	 * Method 'Arbsoltele'.
	 * 
	 * @param arbsolid
	 *            BigDecimal
	 * @param arbhdcod
	 *            String
	 * @param arbhdfec
	 *            Date
	 * @param arbhdte
	 *            String
	 * @param arbhdcotsr
	 *            String
	 * @param arbhdcaptso
	 *            BigDecimal
	 * @param arbhdteso
	 *            String
	 * @param arbsoltipnotif
	 *            String
	 * @param arbsolidioma
	 *            String
	 * @param arbsoltelem
	 *            String
	 * @param arbsolemail
	 *            String
	 * @param arbsolsms
	 *            String
	 * @param arbfecalta
	 *            Date
	 * @param arbsolregen
	 *            String
	 * @param arbsolfecregen
	 *            Date
	 * @param arbsolnif
	 *            String
	 * @param arbsolnombre
	 *            String
	 */
	public Arbsoltele(BigDecimal arbsolid, String arbhdcod, Date arbhdfec,
			String arbhdte, String arbhdcotsr, BigDecimal arbhdcaptso,
			String arbhdteso, String arbsoltipnotif, String arbsolidioma,
			String arbsoltelem, String arbsolemail, String arbsolsms,
			Date arbfecalta, String arbsolregen, Date arbsolfecregen,
			String arbsolnif, String arbsolnombre, String arbsolcoor,
			BigDecimal arbsolnran, BigDecimal arbsolnror) {
		this.arbsolid = arbsolid;
		this.arbhdcod = arbhdcod;
		this.arbhdfec = arbhdfec;
		this.arbhdte = arbhdte;
		this.arbhdcotsr = arbhdcotsr;
		this.arbhdcaptso = arbhdcaptso;
		this.arbhdteso = arbhdteso;
		this.arbsoltipnotif = arbsoltipnotif;
		this.arbsolidioma = arbsolidioma;
		this.arbsoltelem = arbsoltelem;
		this.arbsolemail = arbsolemail;
		this.arbsolsms = arbsolsms;
		this.arbfecalta = arbfecalta;
		this.arbsolregen = arbsolregen;
		this.arbsolfecregen = arbsolfecregen;
		this.arbsolnif = arbsolnif;
		this.arbsolnombre = arbsolnombre;
		this.arbsolcoor = arbsolcoor;
		this.arbsolnran = arbsolnran;
		this.arbsolnror = arbsolnror;
	}

	/**
	 * Method 'Arbsoltele'.
	 * 
	 * @param arbsolid
	 *            BigDecimal
	 * @param arbhdcod
	 *            String
	 * @param arbhdfec
	 *            Date
	 * @param arbhdte
	 *            String
	 * @param arbhdcotsr
	 *            String
	 * @param arbhdcaptso
	 *            BigDecimal
	 * @param arbhdteso
	 *            String
	 * @param arbsoltipnotif
	 *            String
	 * @param arbsolidioma
	 *            String
	 * @param arbsoltelem
	 *            String
	 * @param arbsolemail
	 *            String
	 * @param arbsolsms
	 *            String
	 * @param arbfecalta
	 *            Date
	 * @param arbsolregen
	 *            String
	 * @param arbsolfecregen
	 *            Date
	 * @param arbsolnif
	 *            String
	 * @param arbsolnombre
	 *            String
	 * @param arbsoldocteles
	 *            List<Arbsoldoctele>
	 */
	public Arbsoltele(BigDecimal arbsolid, String arbhdcod, Date arbhdfec,
			String arbhdte, String arbhdcotsr, BigDecimal arbhdcaptso,
			String arbhdteso, String arbsoltipnotif, String arbsolidioma,
			String arbsoltelem, String arbsolemail, String arbsolsms,
			Date arbfecalta, String arbsolregen, Date arbsolfecregen,
			String arbsolnif, String arbsolnombre, String arbsolcoor,
			BigDecimal arbsolnran, BigDecimal arbsolnror,
			List<Arbsoldoctele> arbsoldocteles) {

		this.arbsolid = arbsolid;
		this.arbhdcod = arbhdcod;
		this.arbhdfec = arbhdfec;
		this.arbhdte = arbhdte;
		this.arbhdcotsr = arbhdcotsr;
		this.arbhdcaptso = arbhdcaptso;
		this.arbhdteso = arbhdteso;
		this.arbsoltipnotif = arbsoltipnotif;
		this.arbsolidioma = arbsolidioma;
		this.arbsoltelem = arbsoltelem;
		this.arbsolemail = arbsolemail;
		this.arbsolsms = arbsolsms;
		this.arbfecalta = arbfecalta;
		this.arbsolregen = arbsolregen;
		this.arbsolfecregen = arbsolfecregen;
		this.arbsolnif = arbsolnif;
		this.arbsolnombre = arbsolnombre;
		this.arbsolcoor = arbsolcoor;
		this.arbsolnran = arbsolnran;
		this.arbsolnror = arbsolnror;
		this.arbsoldocteles = arbsoldocteles;
	}

	/**
	 * Method 'getArbsolid'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getArbsolid() {
		return this.arbsolid;
	}

	/**
	 * Method 'setArbsolid'.
	 * 
	 * @param arbsolid
	 *            BigDecimal
	 * @return
	 */

	public void setArbsolid(BigDecimal arbsolid) {
		this.arbsolid = arbsolid;
	}

	/**
	 * Method 'getArbhdcod'.
	 * 
	 * @return String
	 */

	public String getArbhdcod() {
		return this.arbhdcod;
	}

	/**
	 * Method 'setArbhdcod'.
	 * 
	 * @param arbhdcod
	 *            String
	 * @return
	 */

	public void setArbhdcod(String arbhdcod) {
		this.arbhdcod = arbhdcod;
	}

	/**
	 * Method 'getArbhdfec'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getArbhdfec() {
		return this.arbhdfec;
	}

	/**
	 * Method 'setArbhdfec'.
	 * 
	 * @param arbhdfec
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setArbhdfec(Date arbhdfec) {
		this.arbhdfec = arbhdfec;
	}

	/**
	 * Method 'getArbhdte'.
	 * 
	 * @return String
	 */

	public String getArbhdte() {
		return this.arbhdte;
	}

	/**
	 * Method 'setArbhdte'.
	 * 
	 * @param arbhdte
	 *            String
	 * @return
	 */

	public void setArbhdte(String arbhdte) {
		this.arbhdte = arbhdte;
	}

	/**
	 * Method 'getArbhdcotsr'.
	 * 
	 * @return String
	 */

	public String getArbhdcotsr() {
		return this.arbhdcotsr;
	}

	/**
	 * Method 'setArbhdcotsr'.
	 * 
	 * @param arbhdcotsr
	 *            String
	 * @return
	 */

	public void setArbhdcotsr(String arbhdcotsr) {
		this.arbhdcotsr = arbhdcotsr;
	}

	/**
	 * Method 'getArbhdcaptso'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getArbhdcaptso() {
		return this.arbhdcaptso;
	}

	/**
	 * Method 'setArbhdcaptso'.
	 * 
	 * @param arbhdcaptso
	 *            BigDecimal
	 * @return
	 */

	public void setArbhdcaptso(BigDecimal arbhdcaptso) {
		this.arbhdcaptso = arbhdcaptso;
	}

	/**
	 * Method 'getArbhdteso'.
	 * 
	 * @return String
	 */

	public String getArbhdteso() {
		return this.arbhdteso;
	}

	/**
	 * Method 'setArbhdteso'.
	 * 
	 * @param arbhdteso
	 *            String
	 * @return
	 */

	public void setArbhdteso(String arbhdteso) {
		this.arbhdteso = arbhdteso;
	}

	/**
	 * Method 'getArbsoltipnotif'.
	 * 
	 * @return String
	 */

	public String getArbsoltipnotif() {
		return this.arbsoltipnotif;
	}

	/**
	 * Method 'setArbsoltipnotif'.
	 * 
	 * @param arbsoltipnotif
	 *            String
	 * @return
	 */

	public void setArbsoltipnotif(String arbsoltipnotif) {
		this.arbsoltipnotif = arbsoltipnotif;
	}

	/**
	 * Method 'getArbsolidioma'.
	 * 
	 * @return String
	 */

	public String getArbsolidioma() {
		return this.arbsolidioma;
	}

	/**
	 * Method 'setArbsolidioma'.
	 * 
	 * @param arbsolidioma
	 *            String
	 * @return
	 */

	public void setArbsolidioma(String arbsolidioma) {
		this.arbsolidioma = arbsolidioma;
	}

	/**
	 * Method 'getArbsoltelem'.
	 * 
	 * @return String
	 */

	public String getArbsoltelem() {
		return this.arbsoltelem;
	}

	/**
	 * Method 'setArbsoltelem'.
	 * 
	 * @param arbsoltelem
	 *            String
	 * @return
	 */

	public void setArbsoltelem(String arbsoltelem) {
		this.arbsoltelem = arbsoltelem;
	}

	/**
	 * Method 'getArbsolemail'.
	 * 
	 * @return String
	 */

	public String getArbsolemail() {
		return this.arbsolemail;
	}

	/**
	 * Method 'setArbsolemail'.
	 * 
	 * @param arbsolemail
	 *            String
	 * @return
	 */

	public void setArbsolemail(String arbsolemail) {
		this.arbsolemail = arbsolemail;
	}

	/**
	 * Method 'getArbsolsms'.
	 * 
	 * @return String
	 */

	public String getArbsolsms() {
		return this.arbsolsms;
	}

	/**
	 * Method 'setArbsolsms'.
	 * 
	 * @param arbsolsms
	 *            String
	 * @return
	 */

	public void setArbsolsms(String arbsolsms) {
		this.arbsolsms = arbsolsms;
	}

	/**
	 * Method 'getArbfecalta'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getArbfecalta() {
		return this.arbfecalta;
	}

	/**
	 * Method 'setArbfecalta'.
	 * 
	 * @param arbfecalta
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setArbfecalta(Date arbfecalta) {
		this.arbfecalta = arbfecalta;
	}

	/**
	 * Method 'getArbsolregen'.
	 * 
	 * @return String
	 */

	public String getArbsolregen() {
		return this.arbsolregen;
	}

	/**
	 * Method 'setArbsolregen'.
	 * 
	 * @param arbsolregen
	 *            String
	 * @return
	 */

	public void setArbsolregen(String arbsolregen) {
		this.arbsolregen = arbsolregen;
	}

	/**
	 * Method 'getArbsolfecregen'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getArbsolfecregen() {
		return this.arbsolfecregen;
	}

	/**
	 * Method 'setArbsolfecregen'.
	 * 
	 * @param arbsolfecregen
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setArbsolfecregen(Date arbsolfecregen) {
		this.arbsolfecregen = arbsolfecregen;
	}

	/**
	 * Method 'getArbsolnif'.
	 * 
	 * @return String
	 */

	public String getArbsolnif() {
		return this.arbsolnif;
	}

	/**
	 * Method 'setArbsolnif'.
	 * 
	 * @param arbsolnif
	 *            String
	 * @return
	 */

	public void setArbsolnif(String arbsolnif) {
		this.arbsolnif = arbsolnif;
	}

	/**
	 * Method 'getArbsolnombre'.
	 * 
	 * @return String
	 */

	public String getArbsolnombre() {
		return this.arbsolnombre;
	}

	/**
	 * Method 'setArbsolnombre'.
	 * 
	 * @param arbsolnombre
	 *            String
	 * @return
	 */

	public void setArbsolnombre(String arbsolnombre) {
		this.arbsolnombre = arbsolnombre;
	}

	/**
	 * Method 'getArbsoldocteles'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<Arbsoldoctele> getArbsoldocteles() {
		return this.arbsoldocteles;
	}

	/**
	 * Method 'setArbsoldocteles'.
	 * 
	 * @param arbsoldocteles
	 *            List
	 * @return
	 */
	public void setArbsoldocteles(List<Arbsoldoctele> arbsoldocteles) {
		this.arbsoldocteles = arbsoldocteles;
	}

	/**
	 * Method 'setstrListaDocumentos'.
	 * 
	 * @param strListaDocumentos
	 *            String
	 * @return
	 */

	public void setstrListaDocumentos(String strListaDocumentos) {
		this.strListaDocumentos = strListaDocumentos;
	}

	/**
	 * Method 'getstrListaDocumentos'.
	 * 
	 * @return String
	 */

	public String getstrListaDocumentos() {
		return this.strListaDocumentos;
	}

	/**
	 * Method 'getArbsolcoor'.
	 * 
	 * @return String
	 */

	public String getArbsolcoor() {
		return this.arbsolcoor;
	}

	/**
	 * Method 'setArbsolcoor'.
	 * 
	 * @param arbsolcoor
	 *            String
	 * @return
	 */

	public void setArbsolcoor(String arbsolcoor) {
		this.arbsolcoor = arbsolcoor;
	}

	/**
	 * Method 'getArbsolnran'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getArbsolnran() {
		return this.arbsolnran;
	}

	/**
	 * Method 'setArbsolnran'.
	 * 
	 * @param arbsolnran
	 *            BigDecimal
	 * @return
	 */

	public void setArbsolnran(BigDecimal arbsolnran) {
		this.arbsolnran = arbsolnran;
	}

	/**
	 * Method 'getArbsolnror'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getArbsolnror() {
		return this.arbsolnror;
	}

	/**
	 * Method 'setArbsolnror'.
	 * 
	 * @param arbsolnror
	 *            BigDecimal
	 * @return
	 */

	public void setArbsolnror(BigDecimal arbsolnror) {
		this.arbsolnror = arbsolnror;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ arbsolid: ").append(this.arbsolid).append(" ]");
		result.append(", [ arbhdcod: ").append(this.arbhdcod).append(" ]");
		result.append(", [ arbhdfec: ").append(this.arbhdfec).append(" ]");
		result.append(", [ arbhdcotsr: ").append(this.arbhdcotsr).append(" ]");
		result.append(", [ arbhdcaptso: ").append(this.arbhdcaptso)
				.append(" ]");
		result.append(", [ arbhdteso: ").append(this.arbhdteso).append(" ]");
		result.append(", [ arbsoltipnotif: ").append(this.arbsoltipnotif)
				.append(" ]");
		result.append(", [ arbsolidioma: ").append(this.arbsolidioma)
				.append(" ]");
		result.append(", [ arbsoltelem: ").append(this.arbsoltelem)
				.append(" ]");
		result.append(", [ arbsolemail: ").append(this.arbsolemail)
				.append(" ]");
		result.append(", [ arbsolsms: ").append(this.arbsolsms).append(" ]");
		result.append(", [ arbfecalta: ").append(this.arbfecalta).append(" ]");
		result.append(", [ arbsolregen: ").append(this.arbsolregen)
				.append(" ]");
		result.append(", [ arbsolfecregen: ").append(this.arbsolfecregen)
				.append(" ]");
		result.append(", [ arbsolnif: ").append(this.arbsolnif).append(" ]");
		result.append(", [ arbsolnombre: ").append(this.arbsolnombre)
				.append(" ]");
		result.append("}");
		return result.toString();
	}

}
