package com.ejie.y41b.model;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.validation.Y41bNifNieCif;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hibernate.validator.constraints.Email;

/**
 * Arbitro  
 * 
 *  
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class Arbitro implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String arcodigo;
	private String arincoes;
	@Y41bNifNieCif(message = "error01.required.arnif")
	private String arnif;
	private String arnombre;
	private String arnodir;
	private String arcolo;
	private String arnolo;
	private String arnrcopo;
	private String arcopv;
	private String arnopv;
	private String arnrtel;
	private String arnrtel2;
	private String arnrfax;
	@Email(message = "error02.required.email")
	private String arteem;
	private String arteurl;
	private String arnodirc;
	private String arcoloc;
	private String arnoloc;
	private String arnrcopoc;
	private String arcopvc;
	private String arnopvc;
	private String arnrtelc;
	private String arnrtel2c;
	private String arnrfaxc;
	private String arteemc;
	private String arteurlc;
	private String arindico;
	private Date arfeac;
	private Date arfeba;
	private String arteobs;
	private String arcoja;
	private String arcozs;
	private String arfemod;
	private String arnombrec;
	private String arinpf;
	private String arlicenciado;
	private String aridioma;
	private String arprovId;
	private String armunId;
	private String arlocId;
	private String arcalleId;
	private String arportalId;
	private String arprovcId;
	private String armuncId;
	private String arloccId;
	private String arcallecId;
	private String arportalcId;
	private Date arfecalta;
	private String arusualta;
	private List<Arse> arses = new ArrayList<Arse>();
	private List<Arta1> arta1s = new ArrayList<Arta1>();
	private List<Ccar> ccars = new ArrayList<Ccar>();
	private List<Oear> oears = new ArrayList<Oear>();

	private String arThActAraba;
	private String arThActBizkaia;
	private String arThActGipuzkoa;

	private String arcoentidad;
	private String arnoentidad;

	private String arnoentidadEs;
	private String arnoentidadEu;

	private String arcalle;
	private String arcallec;
	private String ardireccionNoCAPV;
	private String ardireccionNoCAPVc;

	private String ardireccionAntigua;

	private String ardireccionAntiguac;

	private String baja;

	private String oecodigo;
	private String secodigo;

	// private BigDecimal numArbitrajes12;
	// private BigDecimal numArbitrajes6;
	// private BigDecimal numArbitrajes3;
	// private BigDecimal numArbitrajes1;
	private BigDecimal numArbitrajesAnyoNatural;

	private String aridiomaC;
	private String aridiomaE;

	private String artercero;

	private String arnombreCp;
	private String arnombrePiso;
	private String arnombrecCp;
	private String arnombrecPiso;

	/**
	 * Method 'Arbitro'.
	 */
	public Arbitro() {
	}

	/**
	 * Method 'Arbitro'.
	 * 
	 * @param arcodigo
	 *            String
	 * @param arincoes
	 *            String
	 * @param arnif
	 *            String
	 * @param arnombre
	 *            String
	 * @param arnodir
	 *            String
	 * @param arcolo
	 *            String
	 * @param arnolo
	 *            String
	 * @param arnrcopo
	 *            String
	 * @param arcopv
	 *            String
	 * @param arnopv
	 *            String
	 * @param arnrtel
	 *            String
	 * @param arnrtel2
	 *            String
	 * @param arnrfax
	 *            String
	 * @param arteem
	 *            String
	 * @param arteurl
	 *            String
	 * @param arnodirc
	 *            String
	 * @param arcoloc
	 *            String
	 * @param arnoloc
	 *            String
	 * @param arnrcopoc
	 *            String
	 * @param arcopvc
	 *            String
	 * @param arnopvc
	 *            String
	 * @param arnrtelc
	 *            String
	 * @param arnrtel2c
	 *            String
	 * @param arnrfaxc
	 *            String
	 * @param arteemc
	 *            String
	 * @param arteurlc
	 *            String
	 * @param arindico
	 *            String
	 * @param arfeac
	 *            Date
	 * @param arfeba
	 *            Date
	 * @param arteobs
	 *            String
	 * @param arcoja
	 *            String
	 * @param arcozs
	 *            String
	 * @param arfemod
	 *            String
	 * @param arnombrec
	 *            String
	 * @param arinpf
	 *            String
	 * @param arlicenciado
	 *            String
	 * @param aridioma
	 *            String
	 * @param arprovId
	 *            String
	 * @param armunId
	 *            String
	 * @param arlocId
	 *            String
	 * @param arcalleId
	 *            String
	 * @param arportalId
	 *            String
	 * @param arprovcId
	 *            String
	 * @param armuncId
	 *            String
	 * @param arloccId
	 *            String
	 * @param arcallecId
	 *            String
	 * @param arportalcId
	 *            String
	 * @param arfecalta
	 *            Date
	 * @param arusualta
	 *            String
	 * @param artercero
	 *            String
	 */
	public Arbitro(String arcodigo, String arincoes, String arnif,
			String arnombre, String arnodir, String arcolo, String arnolo,
			String arnrcopo, String arcopv, String arnopv, String arnrtel,
			String arnrtel2, String arnrfax, String arteem, String arteurl,
			String arnodirc, String arcoloc, String arnoloc, String arnrcopoc,
			String arcopvc, String arnopvc, String arnrtelc, String arnrtel2c,
			String arnrfaxc, String arteemc, String arteurlc, String arindico,
			Date arfeac, Date arfeba, String arteobs, String arcoja,
			String arcozs, String arfemod, String arnombrec, String arinpf,
			String arlicenciado, String aridioma, String arprovId,
			String armunId, String arlocId, String arcalleId,
			String arportalId, String arprovcId, String armuncId,
			String arloccId, String arcallecId, String arportalcId,
			Date arfecalta, String arusualta, String artercero) {
		this.arcodigo = arcodigo;
		this.arincoes = arincoes;
		this.arnif = arnif;
		this.arnombre = arnombre;
		this.arnodir = arnodir;
		this.arcolo = arcolo;
		this.arnolo = arnolo;
		this.arnrcopo = arnrcopo;
		this.arcopv = arcopv;
		this.arnopv = arnopv;
		this.arnrtel = arnrtel;
		this.arnrtel2 = arnrtel2;
		this.arnrfax = arnrfax;
		this.arteem = arteem;
		this.arteurl = arteurl;
		this.arnodirc = arnodirc;
		this.arcoloc = arcoloc;
		this.arnoloc = arnoloc;
		this.arnrcopoc = arnrcopoc;
		this.arcopvc = arcopvc;
		this.arnopvc = arnopvc;
		this.arnrtelc = arnrtelc;
		this.arnrtel2c = arnrtel2c;
		this.arnrfaxc = arnrfaxc;
		this.arteemc = arteemc;
		this.arteurlc = arteurlc;
		this.arindico = arindico;
		this.arfeac = arfeac;
		this.arfeba = arfeba;
		this.arteobs = arteobs;
		this.arcoja = arcoja;
		this.arcozs = arcozs;
		this.arfemod = arfemod;
		this.arnombrec = arnombrec;
		this.arinpf = arinpf;
		this.arlicenciado = arlicenciado;
		this.aridioma = aridioma;
		this.arprovId = arprovId;
		this.armunId = armunId;
		this.arlocId = arlocId;
		this.arcalleId = arcalleId;
		this.arportalId = arportalId;
		this.arprovcId = arprovcId;
		this.armuncId = armuncId;
		this.arloccId = arloccId;
		this.arcallecId = arcallecId;
		this.arportalcId = arportalcId;
		this.arfecalta = arfecalta;
		this.arusualta = arusualta;
		this.artercero = artercero;
	}

	/**
	 * Method 'Arbitro'.
	 * 
	 * @param arcodigo
	 *            String
	 * @param arincoes
	 *            String
	 * @param arnif
	 *            String
	 * @param arnombre
	 *            String
	 * @param arnodir
	 *            String
	 * @param arcolo
	 *            String
	 * @param arnolo
	 *            String
	 * @param arnrcopo
	 *            String
	 * @param arcopv
	 *            String
	 * @param arnopv
	 *            String
	 * @param arnrtel
	 *            String
	 * @param arnrtel2
	 *            String
	 * @param arnrfax
	 *            String
	 * @param arteem
	 *            String
	 * @param arteurl
	 *            String
	 * @param arnodirc
	 *            String
	 * @param arcoloc
	 *            String
	 * @param arnoloc
	 *            String
	 * @param arnrcopoc
	 *            String
	 * @param arcopvc
	 *            String
	 * @param arnopvc
	 *            String
	 * @param arnrtelc
	 *            String
	 * @param arnrtel2c
	 *            String
	 * @param arnrfaxc
	 *            String
	 * @param arteemc
	 *            String
	 * @param arteurlc
	 *            String
	 * @param arindico
	 *            String
	 * @param arfeac
	 *            Date
	 * @param arfeba
	 *            Date
	 * @param arteobs
	 *            String
	 * @param arcoja
	 *            String
	 * @param arcozs
	 *            String
	 * @param arfemod
	 *            String
	 * @param arnombrec
	 *            String
	 * @param arinpf
	 *            String
	 * @param arlicenciado
	 *            String
	 * @param aridioma
	 *            String
	 * @param arprovId
	 *            String
	 * @param armunId
	 *            String
	 * @param arlocId
	 *            String
	 * @param arcalleId
	 *            String
	 * @param arportalId
	 *            String
	 * @param arprovcId
	 *            String
	 * @param armuncId
	 *            String
	 * @param arloccId
	 *            String
	 * @param arcallecId
	 *            String
	 * @param arportalcId
	 *            String
	 * @param arfecalta
	 *            Date
	 * @param arusualta
	 *            String
	 * @param arses
	 *            List<Arse>
	 * @param arta1s
	 *            List<Arta1>
	 * @param ccars
	 *            List<Ccar>
	 * @param oears
	 *            List<Oear>
	 * @param artercero
	 *            String
	 */
	public Arbitro(String arcodigo, String arincoes, String arnif,
			String arnombre, String arnodir, String arcolo, String arnolo,
			String arnrcopo, String arcopv, String arnopv, String arnrtel,
			String arnrtel2, String arnrfax, String arteem, String arteurl,
			String arnodirc, String arcoloc, String arnoloc, String arnrcopoc,
			String arcopvc, String arnopvc, String arnrtelc, String arnrtel2c,
			String arnrfaxc, String arteemc, String arteurlc, String arindico,
			Date arfeac, Date arfeba, String arteobs, String arcoja,
			String arcozs, String arfemod, String arnombrec, String arinpf,
			String arlicenciado, String aridioma, String arprovId,
			String armunId, String arlocId, String arcalleId,
			String arportalId, String arprovcId, String armuncId,
			String arloccId, String arcallecId, String arportalcId,
			Date arfecalta, String arusualta, List<Arse> arses,
			List<Arta1> arta1s, List<Ccar> ccars, List<Oear> oears,
			String artercero) {

		this.arcodigo = arcodigo;
		this.arincoes = arincoes;
		this.arnif = arnif;
		this.arnombre = arnombre;
		this.arnodir = arnodir;
		this.arcolo = arcolo;
		this.arnolo = arnolo;
		this.arnrcopo = arnrcopo;
		this.arcopv = arcopv;
		this.arnopv = arnopv;
		this.arnrtel = arnrtel;
		this.arnrtel2 = arnrtel2;
		this.arnrfax = arnrfax;
		this.arteem = arteem;
		this.arteurl = arteurl;
		this.arnodirc = arnodirc;
		this.arcoloc = arcoloc;
		this.arnoloc = arnoloc;
		this.arnrcopoc = arnrcopoc;
		this.arcopvc = arcopvc;
		this.arnopvc = arnopvc;
		this.arnrtelc = arnrtelc;
		this.arnrtel2c = arnrtel2c;
		this.arnrfaxc = arnrfaxc;
		this.arteemc = arteemc;
		this.arteurlc = arteurlc;
		this.arindico = arindico;
		this.arfeac = arfeac;
		this.arfeba = arfeba;
		this.arteobs = arteobs;
		this.arcoja = arcoja;
		this.arcozs = arcozs;
		this.arfemod = arfemod;
		this.arnombrec = arnombrec;
		this.arinpf = arinpf;
		this.arlicenciado = arlicenciado;
		this.aridioma = aridioma;
		this.arprovId = arprovId;
		this.armunId = armunId;
		this.arlocId = arlocId;
		this.arcalleId = arcalleId;
		this.arportalId = arportalId;
		this.arprovcId = arprovcId;
		this.armuncId = armuncId;
		this.arloccId = arloccId;
		this.arcallecId = arcallecId;
		this.arportalcId = arportalcId;
		this.arfecalta = arfecalta;
		this.arusualta = arusualta;
		this.arses = arses;
		this.arta1s = arta1s;
		this.ccars = ccars;
		this.oears = oears;
		this.artercero = artercero;
	}

	/**
	 * @param arcodigo
	 * @param arnombre
	 */
	public Arbitro(String arcodigo, String arnombre) {
		this.arcodigo = arcodigo;
		this.arnombre = arnombre;
	}

	/**
	 * @param arcodigo
	 * @param arnombre
	 * @param arnif
	 */
	public Arbitro(String arcodigo, String arnombre, String arnif) {
		this.arcodigo = arcodigo;
		this.arnombre = arnombre;
		this.arnif = arnif;
	}

	/**
	 * Method 'getArcodigo'.
	 * 
	 * @return String
	 */

	public String getArcodigo() {
		return this.arcodigo;
	}

	/**
	 * Method 'setArcodigo'.
	 * 
	 * @param arcodigo
	 *            String
	 * @return
	 */

	public void setArcodigo(String arcodigo) {
		this.arcodigo = arcodigo;
	}

	/**
	 * Method 'getArincoes'.
	 * 
	 * @return String
	 */

	public String getArincoes() {
		return this.arincoes;
	}

	/**
	 * Method 'setArincoes'.
	 * 
	 * @param arincoes
	 *            String
	 * @return
	 */

	public void setArincoes(String arincoes) {
		this.arincoes = arincoes;
	}

	/**
	 * Method 'getArnif'.
	 * 
	 * @return String
	 */

	public String getArnif() {
		return Y41bUtils.upperCase(this.arnif);
	}

	/**
	 * Method 'setArnif'.
	 * 
	 * @param arnif
	 *            String
	 * @return
	 */

	public void setArnif(String arnif) {
		this.arnif = Y41bUtils.upperCase(arnif);
	}

	/**
	 * Method 'getArnombre'.
	 * 
	 * @return String
	 */

	public String getArnombre() {
		return this.arnombre;
	}

	/**
	 * Method 'setArnombre'.
	 * 
	 * @param arnombre
	 *            String
	 * @return
	 */

	public void setArnombre(String arnombre) {
		this.arnombre = arnombre;
	}

	/**
	 * Method 'getArnodir'.
	 * 
	 * @return String
	 */

	public String getArnodir() {
		return this.arnodir;
	}

	/**
	 * Method 'setArnodir'.
	 * 
	 * @param arnodir
	 *            String
	 * @return
	 */

	public void setArnodir(String arnodir) {
		this.arnodir = arnodir;
	}

	/**
	 * Method 'getArcolo'.
	 * 
	 * @return String
	 */

	public String getArcolo() {
		return this.arcolo;
	}

	/**
	 * Method 'setArcolo'.
	 * 
	 * @param arcolo
	 *            String
	 * @return
	 */

	public void setArcolo(String arcolo) {
		this.arcolo = arcolo;
	}

	/**
	 * Method 'getArnolo'.
	 * 
	 * @return String
	 */

	public String getArnolo() {
		return this.arnolo;
	}

	/**
	 * Method 'setArnolo'.
	 * 
	 * @param arnolo
	 *            String
	 * @return
	 */

	public void setArnolo(String arnolo) {
		this.arnolo = arnolo;
	}

	/**
	 * Method 'getArnrcopo'.
	 * 
	 * @return String
	 */

	public String getArnrcopo() {
		return this.arnrcopo;
	}

	/**
	 * Method 'setArnrcopo'.
	 * 
	 * @param arnrcopo
	 *            String
	 * @return
	 */

	public void setArnrcopo(String arnrcopo) {
		this.arnrcopo = arnrcopo;
	}

	/**
	 * Method 'getArcopv'.
	 * 
	 * @return String
	 */

	public String getArcopv() {
		return this.arcopv;
	}

	/**
	 * Method 'setArcopv'.
	 * 
	 * @param arcopv
	 *            String
	 * @return
	 */

	public void setArcopv(String arcopv) {
		this.arcopv = arcopv;
	}

	/**
	 * Method 'getArnopv'.
	 * 
	 * @return String
	 */

	public String getArnopv() {
		return this.arnopv;
	}

	/**
	 * Method 'setArnopv'.
	 * 
	 * @param arnopv
	 *            String
	 * @return
	 */

	public void setArnopv(String arnopv) {
		this.arnopv = arnopv;
	}

	/**
	 * Method 'getArnrtel'.
	 * 
	 * @return String
	 */

	public String getArnrtel() {
		return this.arnrtel;
	}

	/**
	 * Method 'setArnrtel'.
	 * 
	 * @param arnrtel
	 *            String
	 * @return
	 */

	public void setArnrtel(String arnrtel) {
		this.arnrtel = arnrtel;
	}

	/**
	 * Method 'getArnrtel2'.
	 * 
	 * @return String
	 */

	public String getArnrtel2() {
		return this.arnrtel2;
	}

	/**
	 * Method 'setArnrtel2'.
	 * 
	 * @param arnrtel2
	 *            String
	 * @return
	 */

	public void setArnrtel2(String arnrtel2) {
		this.arnrtel2 = arnrtel2;
	}

	/**
	 * Method 'getArnrfax'.
	 * 
	 * @return String
	 */

	public String getArnrfax() {
		return this.arnrfax;
	}

	/**
	 * Method 'setArnrfax'.
	 * 
	 * @param arnrfax
	 *            String
	 * @return
	 */

	public void setArnrfax(String arnrfax) {
		this.arnrfax = arnrfax;
	}

	/**
	 * Method 'getArteem'.
	 * 
	 * @return String
	 */

	public String getArteem() {
		return this.arteem;
	}

	/**
	 * Method 'setArteem'.
	 * 
	 * @param arteem
	 *            String
	 * @return
	 */

	public void setArteem(String arteem) {
		if (!"null".equalsIgnoreCase(arteem)) {
			this.arteem = arteem;
		}
	}

	/**
	 * Method 'getArteurl'.
	 * 
	 * @return String
	 */

	public String getArteurl() {
		return this.arteurl;
	}

	/**
	 * Method 'setArteurl'.
	 * 
	 * @param arteurl
	 *            String
	 * @return
	 */

	public void setArteurl(String arteurl) {
		this.arteurl = arteurl;
	}

	/**
	 * Method 'getArnodirc'.
	 * 
	 * @return String
	 */

	public String getArnodirc() {
		return this.arnodirc;
	}

	/**
	 * Method 'setArnodirc'.
	 * 
	 * @param arnodirc
	 *            String
	 * @return
	 */

	public void setArnodirc(String arnodirc) {
		if (arnodirc != null && arnodirc.length() > 50) {
			this.arnodirc = arnodirc.substring(0, 50);
		} else {
			this.arnodirc = arnodirc;
		}
	}

	/**
	 * Method 'getArcoloc'.
	 * 
	 * @return String
	 */

	public String getArcoloc() {
		return this.arcoloc;
	}

	/**
	 * Method 'setArcoloc'.
	 * 
	 * @param arcoloc
	 *            String
	 * @return
	 */

	public void setArcoloc(String arcoloc) {
		this.arcoloc = arcoloc;
	}

	/**
	 * Method 'getArnoloc'.
	 * 
	 * @return String
	 */

	public String getArnoloc() {
		return this.arnoloc;
	}

	/**
	 * Method 'setArnoloc'.
	 * 
	 * @param arnoloc
	 *            String
	 * @return
	 */

	public void setArnoloc(String arnoloc) {
		this.arnoloc = arnoloc;
	}

	/**
	 * Method 'getArnrcopoc'.
	 * 
	 * @return String
	 */

	public String getArnrcopoc() {
		return this.arnrcopoc;
	}

	/**
	 * Method 'setArnrcopoc'.
	 * 
	 * @param arnrcopoc
	 *            String
	 * @return
	 */

	public void setArnrcopoc(String arnrcopoc) {
		this.arnrcopoc = arnrcopoc;
	}

	/**
	 * Method 'getArcopvc'.
	 * 
	 * @return String
	 */

	public String getArcopvc() {
		return this.arcopvc;
	}

	/**
	 * Method 'setArcopvc'.
	 * 
	 * @param arcopvc
	 *            String
	 * @return
	 */

	public void setArcopvc(String arcopvc) {
		this.arcopvc = arcopvc;
	}

	/**
	 * Method 'getArnopvc'.
	 * 
	 * @return String
	 */

	public String getArnopvc() {
		return this.arnopvc;
	}

	/**
	 * Method 'setArnopvc'.
	 * 
	 * @param arnopvc
	 *            String
	 * @return
	 */

	public void setArnopvc(String arnopvc) {
		this.arnopvc = arnopvc;
	}

	/**
	 * Method 'getArnrtelc'.
	 * 
	 * @return String
	 */

	public String getArnrtelc() {
		return this.arnrtelc;
	}

	/**
	 * Method 'setArnrtelc'.
	 * 
	 * @param arnrtelc
	 *            String
	 * @return
	 */

	public void setArnrtelc(String arnrtelc) {
		this.arnrtelc = arnrtelc;
	}

	/**
	 * Method 'getArnrtel2c'.
	 * 
	 * @return String
	 */

	public String getArnrtel2c() {
		return this.arnrtel2c;
	}

	/**
	 * Method 'setArnrtel2c'.
	 * 
	 * @param arnrtel2c
	 *            String
	 * @return
	 */

	public void setArnrtel2c(String arnrtel2c) {
		this.arnrtel2c = arnrtel2c;
	}

	/**
	 * Method 'getArnrfaxc'.
	 * 
	 * @return String
	 */

	public String getArnrfaxc() {
		return this.arnrfaxc;
	}

	/**
	 * Method 'setArnrfaxc'.
	 * 
	 * @param arnrfaxc
	 *            String
	 * @return
	 */

	public void setArnrfaxc(String arnrfaxc) {
		this.arnrfaxc = arnrfaxc;
	}

	/**
	 * Method 'getArteemc'.
	 * 
	 * @return String
	 */

	public String getArteemc() {
		return this.arteemc;
	}

	/**
	 * Method 'setArteemc'.
	 * 
	 * @param arteemc
	 *            String
	 * @return
	 */

	public void setArteemc(String arteemc) {
		this.arteemc = arteemc;
	}

	/**
	 * Method 'getArteurlc'.
	 * 
	 * @return String
	 */

	public String getArteurlc() {
		return this.arteurlc;
	}

	/**
	 * Method 'setArteurlc'.
	 * 
	 * @param arteurlc
	 *            String
	 * @return
	 */

	public void setArteurlc(String arteurlc) {
		this.arteurlc = arteurlc;
	}

	/**
	 * Method 'getArindico'.
	 * 
	 * @return String
	 */

	public String getArindico() {
		return this.arindico;
	}

	/**
	 * Method 'setArindico'.
	 * 
	 * @param arindico
	 *            String
	 * @return
	 */

	public void setArindico(String arindico) {
		this.arindico = arindico;
	}

	/**
	 * Method 'getArfeac'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getArfeac() {
		return this.arfeac;
	}

	/**
	 * Method 'setArfeac'.
	 * 
	 * @param arfeac
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setArfeac(Date arfeac) {
		this.arfeac = arfeac;
	}

	/**
	 * Method 'getArfeba'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getArfeba() {
		return this.arfeba;
	}

	/**
	 * Method 'setArfeba'.
	 * 
	 * @param arfeba
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setArfeba(Date arfeba) {
		this.arfeba = arfeba;
	}

	/**
	 * Method 'getArteobs'.
	 * 
	 * @return String
	 */

	public String getArteobs() {
		return this.arteobs;
	}

	/**
	 * Method 'setArteobs'.
	 * 
	 * @param arteobs
	 *            String
	 * @return
	 */

	public void setArteobs(String arteobs) {
		this.arteobs = arteobs;
	}

	/**
	 * Method 'getArcoja'.
	 * 
	 * @return String
	 */

	public String getArcoja() {
		return this.arcoja;
	}

	/**
	 * Method 'setArcoja'.
	 * 
	 * @param arcoja
	 *            String
	 * @return
	 */

	public void setArcoja(String arcoja) {
		this.arcoja = arcoja;
	}

	/**
	 * Method 'getArcozs'.
	 * 
	 * @return String
	 */

	public String getArcozs() {
		return this.arcozs;
	}

	/**
	 * Method 'setArcozs'.
	 * 
	 * @param arcozs
	 *            String
	 * @return
	 */

	public void setArcozs(String arcozs) {
		this.arcozs = arcozs;
	}

	/**
	 * Method 'getArfemod'.
	 * 
	 * @return String
	 */

	public String getArfemod() {
		return this.arfemod;
	}

	/**
	 * Method 'setArfemod'.
	 * 
	 * @param arfemod
	 *            String
	 * @return
	 */

	public void setArfemod(String arfemod) {
		this.arfemod = arfemod;
	}

	/**
	 * Method 'getArnombrec'.
	 * 
	 * @return String
	 */

	public String getArnombrec() {
		return this.arnombrec;
	}

	/**
	 * Method 'setArnombrec'.
	 * 
	 * @param arnombrec
	 *            String
	 * @return
	 */

	public void setArnombrec(String arnombrec) {
		this.arnombrec = arnombrec;
	}

	/**
	 * Method 'getArinpf'.
	 * 
	 * @return String
	 */

	public String getArinpf() {
		return this.arinpf;
	}

	/**
	 * Method 'setArinpf'.
	 * 
	 * @param arinpf
	 *            String
	 * @return
	 */

	public void setArinpf(String arinpf) {
		this.arinpf = arinpf;
	}

	/**
	 * Method 'getArlicenciado'.
	 * 
	 * @return String
	 */

	public String getArlicenciado() {
		return this.arlicenciado;
	}

	/**
	 * Method 'setArlicenciado'.
	 * 
	 * @param arlicenciado
	 *            String
	 * @return
	 */

	public void setArlicenciado(String arlicenciado) {
		this.arlicenciado = arlicenciado;
	}

	/**
	 * Method 'getAridioma'.
	 * 
	 * @return String
	 */

	public String getAridioma() {
		return this.aridioma;
	}

	/**
	 * Method 'setAridioma'.
	 * 
	 * @param aridioma
	 *            String
	 * @return
	 */

	public void setAridioma(String aridioma) {
		this.aridioma = aridioma;
	}

	/**
	 * Method 'getArprovId'.
	 * 
	 * @return String
	 */

	public String getArprovId() {
		return this.arprovId;
	}

	/**
	 * Method 'setArprovId'.
	 * 
	 * @param arprovId
	 *            String
	 * @return
	 */

	public void setArprovId(String arprovId) {
		this.arprovId = arprovId;
	}

	/**
	 * Method 'getArmunId'.
	 * 
	 * @return String
	 */

	public String getArmunId() {
		return this.armunId;
	}

	/**
	 * Method 'setArmunId'.
	 * 
	 * @param armunId
	 *            String
	 * @return
	 */

	public void setArmunId(String armunId) {
		this.armunId = armunId;
	}

	/**
	 * Method 'getArlocId'.
	 * 
	 * @return String
	 */

	public String getArlocId() {
		return this.arlocId;
	}

	/**
	 * Method 'setArlocId'.
	 * 
	 * @param arlocId
	 *            String
	 * @return
	 */

	public void setArlocId(String arlocId) {
		this.arlocId = arlocId;
	}

	/**
	 * Method 'getArcalleId'.
	 * 
	 * @return String
	 */

	public String getArcalleId() {
		return this.arcalleId;
	}

	/**
	 * Method 'setArcalleId'.
	 * 
	 * @param arcalleId
	 *            String
	 * @return
	 */

	public void setArcalleId(String arcalleId) {
		this.arcalleId = arcalleId;
	}

	/**
	 * Method 'getArportalId'.
	 * 
	 * @return String
	 */

	public String getArportalId() {
		return this.arportalId;
	}

	/**
	 * Method 'setArportalId'.
	 * 
	 * @param arportalId
	 *            String
	 * @return
	 */

	public void setArportalId(String arportalId) {
		this.arportalId = arportalId;
	}

	/**
	 * Method 'getArprovcId'.
	 * 
	 * @return String
	 */

	public String getArprovcId() {
		return this.arprovcId;
	}

	/**
	 * Method 'setArprovcId'.
	 * 
	 * @param arprovcId
	 *            String
	 * @return
	 */

	public void setArprovcId(String arprovcId) {
		this.arprovcId = arprovcId;
	}

	/**
	 * Method 'getArmuncId'.
	 * 
	 * @return String
	 */

	public String getArmuncId() {
		return this.armuncId;
	}

	/**
	 * Method 'setArmuncId'.
	 * 
	 * @param armuncId
	 *            String
	 * @return
	 */

	public void setArmuncId(String armuncId) {
		this.armuncId = armuncId;
	}

	/**
	 * Method 'getArloccId'.
	 * 
	 * @return String
	 */

	public String getArloccId() {
		return this.arloccId;
	}

	/**
	 * Method 'setArloccId'.
	 * 
	 * @param arloccId
	 *            String
	 * @return
	 */

	public void setArloccId(String arloccId) {
		this.arloccId = arloccId;
	}

	/**
	 * Method 'getArcallecId'.
	 * 
	 * @return String
	 */

	public String getArcallecId() {
		return this.arcallecId;
	}

	/**
	 * Method 'setArcallecId'.
	 * 
	 * @param arcallecId
	 *            String
	 * @return
	 */

	public void setArcallecId(String arcallecId) {
		this.arcallecId = arcallecId;
	}

	/**
	 * Method 'getArportalcId'.
	 * 
	 * @return String
	 */

	public String getArportalcId() {
		return this.arportalcId;
	}

	/**
	 * Method 'setArportalcId'.
	 * 
	 * @param arportalcId
	 *            String
	 * @return
	 */

	public void setArportalcId(String arportalcId) {
		this.arportalcId = arportalcId;
	}

	/**
	 * Method 'getArfecalta'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getArfecalta() {
		return this.arfecalta;
	}

	/**
	 * Method 'setArfecalta'.
	 * 
	 * @param arfecalta
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setArfecalta(Date arfecalta) {
		this.arfecalta = arfecalta;
	}

	/**
	 * Method 'getArusualta'.
	 * 
	 * @return String
	 */

	public String getArusualta() {
		return this.arusualta;
	}

	/**
	 * Method 'setArusualta'.
	 * 
	 * @param arusualta
	 *            String
	 * @return
	 */

	public void setArusualta(String arusualta) {
		this.arusualta = arusualta;
	}

	/**
	 * Method 'getArses'.
	 * 
	 * @return List
	 */
	@JsonIgnore()
	public List<Arse> getArses() {
		return this.arses;
	}

	/**
	 * Method 'setArses'.
	 * 
	 * @param arses
	 *            List
	 * @return
	 */
	public void setArses(List<Arse> arses) {
		this.arses = arses;
	}

	/**
	 * Method 'getArta1s'.
	 * 
	 * @return List
	 */
	@JsonIgnore()
	public List<Arta1> getArta1s() {
		return this.arta1s;
	}

	/**
	 * Method 'setArta1s'.
	 * 
	 * @param arta1s
	 *            List
	 * @return
	 */
	public void setArta1s(List<Arta1> arta1s) {
		this.arta1s = arta1s;
	}

	/**
	 * Method 'getCcars'.
	 * 
	 * @return List
	 */
	public List<Ccar> getCcars() {
		return this.ccars;
	}

	/**
	 * Method 'setCcars'.
	 * 
	 * @param ccars
	 *            List
	 * @return
	 */
	public void setCcars(List<Ccar> ccars) {
		this.ccars = ccars;
	}

	/**
	 * Method 'getOears'.
	 * 
	 * @return List
	 */
	public List<Oear> getOears() {
		return this.oears;
	}

	/**
	 * Method 'setOears'.
	 * 
	 * @param oears
	 *            List
	 * @return
	 */
	public void setOears(List<Oear> oears) {
		this.oears = oears;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override()
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ arcodigo: ").append(this.arcodigo).append(" ]");
		result.append(", [ arincoes: ").append(this.arincoes).append(" ]");
		result.append(", [ arnif: ").append(this.arnif).append(" ]");
		result.append(", [ arnombre: ").append(this.arnombre).append(" ]");
		result.append(", [ arnodir: ").append(this.arnodir).append(" ]");
		result.append(", [ arcolo: ").append(this.arcolo).append(" ]");
		result.append(", [ arnolo: ").append(this.arnolo).append(" ]");
		result.append(", [ arnrcopo: ").append(this.arnrcopo).append(" ]");
		result.append(", [ arcopv: ").append(this.arcopv).append(" ]");
		result.append(", [ arnopv: ").append(this.arnopv).append(" ]");
		result.append(", [ arnrtel: ").append(this.arnrtel).append(" ]");
		result.append(", [ arnrtel2: ").append(this.arnrtel2).append(" ]");
		result.append(", [ arnrfax: ").append(this.arnrfax).append(" ]");
		result.append(", [ arteem: ").append(this.arteem).append(" ]");
		result.append(", [ arteurl: ").append(this.arteurl).append(" ]");
		result.append(", [ arnodirc: ").append(this.arnodirc).append(" ]");
		result.append(", [ arcoloc: ").append(this.arcoloc).append(" ]");
		result.append(", [ arnoloc: ").append(this.arnoloc).append(" ]");
		result.append(", [ arnrcopoc: ").append(this.arnrcopoc).append(" ]");
		result.append(", [ arcopvc: ").append(this.arcopvc).append(" ]");
		result.append(", [ arnopvc: ").append(this.arnopvc).append(" ]");
		result.append(", [ arnrtelc: ").append(this.arnrtelc).append(" ]");
		result.append(", [ arnrtel2c: ").append(this.arnrtel2c).append(" ]");
		result.append(", [ arnrfaxc: ").append(this.arnrfaxc).append(" ]");
		result.append(", [ arteemc: ").append(this.arteemc).append(" ]");
		result.append(", [ arteurlc: ").append(this.arteurlc).append(" ]");
		result.append(", [ arindico: ").append(this.arindico).append(" ]");
		result.append(", [ arfeac: ").append(this.arfeac).append(" ]");
		result.append(", [ arfeba: ").append(this.arfeba).append(" ]");
		result.append(", [ arteobs: ").append(this.arteobs).append(" ]");
		result.append(", [ arcoja: ").append(this.arcoja).append(" ]");
		result.append(", [ arcozs: ").append(this.arcozs).append(" ]");
		result.append(", [ arfemod: ").append(this.arfemod).append(" ]");
		result.append(", [ arnombrec: ").append(this.arnombrec).append(" ]");
		result.append(", [ arinpf: ").append(this.arinpf).append(" ]");
		result.append(", [ arlicenciado: ").append(this.arlicenciado)
				.append(" ]");
		result.append(", [ aridioma: ").append(this.aridioma).append(" ]");
		result.append(", [ arprovId: ").append(this.arprovId).append(" ]");
		result.append(", [ armunId: ").append(this.armunId).append(" ]");
		result.append(", [ arlocId: ").append(this.arlocId).append(" ]");
		result.append(", [ arcalleId: ").append(this.arcalleId).append(" ]");
		result.append(", [ arportalId: ").append(this.arportalId).append(" ]");
		result.append(", [ arprovcId: ").append(this.arprovcId).append(" ]");
		result.append(", [ armuncId: ").append(this.armuncId).append(" ]");
		result.append(", [ arloccId: ").append(this.arloccId).append(" ]");
		result.append(", [ arcallecId: ").append(this.arcallecId).append(" ]");
		result.append(", [ arportalcId: ").append(this.arportalcId)
				.append(" ]");
		result.append(", [ arfecalta: ").append(this.arfecalta).append(" ]");
		result.append(", [ arusualta: ").append(this.arusualta).append(" ]");
		result.append("}");
		return result.toString();
	}

	/**
	 * @return the arThActAraba
	 */
	public String getArThActAraba() {
		return this.arThActAraba;
	}

	/**
	 * @param arThActAraba
	 *            the arThActAraba to set
	 */
	public void setArThActAraba(String arThActAraba) {
		this.arThActAraba = arThActAraba;
	}

	/**
	 * @return the arThActBizkaia
	 */
	public String getArThActBizkaia() {
		return this.arThActBizkaia;
	}

	/**
	 * @param arThActBizkaia
	 *            the arThActBizkaia to set
	 */
	public void setArThActBizkaia(String arThActBizkaia) {
		this.arThActBizkaia = arThActBizkaia;
	}

	/**
	 * @return the arThActGipuzkoa
	 */
	public String getArThActGipuzkoa() {
		return this.arThActGipuzkoa;
	}

	/**
	 * @param arThActGipuzkoa
	 *            the arThActGipuzkoa to set
	 */
	public void setArThActGipuzkoa(String arThActGipuzkoa) {
		this.arThActGipuzkoa = arThActGipuzkoa;
	}

	/**
	 * @return the arcoentidad
	 */
	public String getArcoentidad() {
		return this.arcoentidad;
	}

	/**
	 * @param arcoentidad
	 *            the arcoentidad to set
	 */
	public void setArcoentidad(String arcoentidad) {
		this.arcoentidad = arcoentidad;
	}

	/**
	 * @return the arnoentidad
	 */
	public String getArnoentidad() {
		return this.arnoentidad;
	}

	/**
	 * @param arnoentidad
	 *            the arnoentidad to set
	 */
	public void setArnoentidad(String arnoentidad) {
		this.arnoentidad = arnoentidad;
	}

	/**
	 * @return the arcalle
	 */
	public String getArcalle() {
		return this.arcalle;
	}

	/**
	 * @param arcalle
	 *            the arcalle to set
	 */
	public void setArcalle(String arcalle) {
		this.arcalle = arcalle;
	}

	/**
	 * @return the ardireccionNoCAPV
	 */
	public String getArdireccionNoCAPV() {
		return this.ardireccionNoCAPV;
	}

	/**
	 * @param ardireccionNoCAPV
	 *            the ardireccionNoCAPV to set
	 */
	public void setArdireccionNoCAPV(String ardireccionNoCAPV) {
		this.ardireccionNoCAPV = ardireccionNoCAPV;
	}

	/**
	 * @return the arcallec
	 */
	public String getArcallec() {
		return this.arcallec;
	}

	/**
	 * @param arcallec
	 *            the arcallec to set
	 */
	public void setArcallec(String arcallec) {
		this.arcallec = arcallec;
	}

	/**
	 * @return the ardireccionNoCAPVc
	 */
	public String getArdireccionNoCAPVc() {
		return this.ardireccionNoCAPVc;
	}

	/**
	 * @param ardireccionNoCAPVc
	 *            the ardireccionNoCAPVc to set
	 */
	public void setArdireccionNoCAPVc(String ardireccionNoCAPVc) {
		this.ardireccionNoCAPVc = ardireccionNoCAPVc;
	}

	/**
	 * @return the arnoentidadEs
	 */
	public String getArnoentidadEs() {
		return this.arnoentidadEs;
	}

	/**
	 * @param arnoentidadEs
	 *            the arnoentidadEs to set
	 */
	public void setArnoentidadEs(String arnoentidadEs) {
		this.arnoentidadEs = arnoentidadEs;
	}

	/**
	 * @return the arnoentidadEu
	 */
	public String getArnoentidadEu() {
		return this.arnoentidadEu;
	}

	/**
	 * @param arnoentidadEu
	 *            the arnoentidadEu to set
	 */
	public void setArnoentidadEu(String arnoentidadEu) {
		this.arnoentidadEu = arnoentidadEu;
	}

	/**
	 * @return the oecodigo
	 */
	public String getOecodigo() {
		return oecodigo;
	}

	/**
	 * @param oecodigo
	 *            the oecodigo to set
	 */
	public void setOecodigo(String oecodigo) {
		this.oecodigo = oecodigo;
	}

	/**
	 * @return the secodigo
	 */
	public String getSecodigo() {
		return secodigo;
	}

	/**
	 * @param secodigo
	 *            the secodigo to set
	 */
	public void setSecodigo(String secodigo) {
		this.secodigo = secodigo;
	}

	// /**
	// * @return the numArbitrajes12
	// */
	// public BigDecimal getNumArbitrajes12() {
	// return numArbitrajes12;
	// }
	//
	// /**
	// * @param numArbitrajes12
	// * the numArbitrajes12 to set
	// */
	// public void setNumArbitrajes12(BigDecimal numArbitrajes12) {
	// this.numArbitrajes12 = numArbitrajes12;
	// }
	//
	// /**
	// * @return the numArbitrajes6
	// */
	// public BigDecimal getNumArbitrajes6() {
	// return numArbitrajes6;
	// }
	//
	// /**
	// * @param numArbitrajes6
	// * the numArbitrajes6 to set
	// */
	// public void setNumArbitrajes6(BigDecimal numArbitrajes6) {
	// this.numArbitrajes6 = numArbitrajes6;
	// }
	//
	// /**
	// * @return the numArbitrajes3
	// */
	// public BigDecimal getNumArbitrajes3() {
	// return numArbitrajes3;
	// }
	//
	// /**
	// * @param numArbitrajes3
	// * the numArbitrajes3 to set
	// */
	// public void setNumArbitrajes3(BigDecimal numArbitrajes3) {
	// this.numArbitrajes3 = numArbitrajes3;
	// }
	//
	// /**
	// * @return the numArbitrajes1
	// */
	// public BigDecimal getNumArbitrajes1() {
	// return numArbitrajes1;
	// }
	//
	// /**
	// * @param numArbitrajes1
	// * the numArbitrajes1 to set
	// */
	// public void setNumArbitrajes1(BigDecimal numArbitrajes1) {
	// this.numArbitrajes1 = numArbitrajes1;
	// }

	/**
	 * @return the aridiomaC
	 */
	public String getAridiomaC() {
		return aridiomaC;
	}

	/**
	 * @param aridiomaC
	 *            the aridiomaC to set
	 */
	public void setAridiomaC(String aridiomaC) {
		this.aridiomaC = aridiomaC;
	}

	/**
	 * @return the aridiomaE
	 */
	public String getAridiomaE() {
		return aridiomaE;
	}

	/**
	 * @param aridiomaE
	 *            the aridiomaE to set
	 */
	public void setAridiomaE(String aridiomaE) {
		this.aridiomaE = aridiomaE;
	}

	/**
	 * @return the artercero
	 */
	public String getArtercero() {
		return artercero;
	}

	/**
	 * @param artercero
	 *            the artercero to set
	 */
	public void setArtercero(String artercero) {
		this.artercero = artercero;
	}

	/**
	 * @return the arnombreCp
	 */
	public String getArnombreCp() {
		return arnombreCp;
	}

	/**
	 * @param arnombreCp
	 *            the arnombreCp to set
	 */
	public void setArnombreCp(String arnombreCp) {
		if (arnombreCp != null)
			this.arnombreCp = arnombreCp.trim();
	}

	/**
	 * @return the arnombrePiso
	 */
	public String getArnombrePiso() {
		return arnombrePiso;
	}

	/**
	 * @param arnombrePiso
	 *            the arnombrePiso to set
	 */
	public void setArnombrePiso(String arnombrePiso) {
		this.arnombrePiso = arnombrePiso;
	}

	/**
	 * @return the arnombrecCp
	 */
	public String getArnombrecCp() {
		return arnombrecCp;
	}

	/**
	 * @param arnombrecCp
	 *            the arnombrecCp to set
	 */
	public void setArnombrecCp(String arnombrecCp) {
		if (arnombrecCp != null)
			this.arnombrecCp = arnombrecCp.trim();
	}

	/**
	 * @return the arnombrecPiso
	 */
	public String getArnombrecPiso() {
		return arnombrecPiso;
	}

	/**
	 * @param arnombrecPiso
	 *            the arnombrecPiso to set
	 */
	public void setArnombrecPiso(String arnombrecPiso) {
		this.arnombrecPiso = arnombrecPiso;
	}

	/**
	 * @return the ardireccionAntigua
	 */
	public String getArdireccionAntigua() {
		return ardireccionAntigua;
	}

	/**
	 * @param ardireccionAntigua
	 *            the ardireccionAntigua to set
	 */
	public void setArdireccionAntigua(String ardireccionAntigua) {
		this.ardireccionAntigua = ardireccionAntigua;
	}

	/**
	 * @return the ardireccionAntiguac
	 */
	public String getArdireccionAntiguac() {
		return ardireccionAntiguac;
	}

	/**
	 * @param ardireccionAntiguac
	 *            the ardireccionAntiguac to set
	 */
	public void setArdireccionAntiguac(String ardireccionAntiguac) {
		this.ardireccionAntiguac = ardireccionAntiguac;
	}

	public void setBaja(String baja) {
		this.baja = baja;
	}

	public String getBaja() {
		return baja;
	}

	/**
	 * @param numArbitrajesAnyoNatural
	 *            the numArbitrajesAnyoNatural to set
	 */
	public void setNumArbitrajesAnyoNatural(BigDecimal numArbitrajesAnyoNatural) {
		this.numArbitrajesAnyoNatural = numArbitrajesAnyoNatural;
	}

	/**
	 * @return the numArbitrajesAnyoNatural
	 */
	public BigDecimal getNumArbitrajesAnyoNatural() {
		return numArbitrajesAnyoNatural;
	}

}
