package com.ejie.y41b.model;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.utils.Y41bUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

/**
 * Arbinterv  
 * 
 *  
 */

public class Arbinterv implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private BigDecimal uaidinterv;
	private String uanombre;
	private String uanif;
	private String uanrtel;
	private String uanrtel2;
	private String uaextranjero;
	private String uaprovId;
	private String uamunId;
	private String ualocId;
	private String uacalleId;
	private String uacpId;
	private String uaportalId;
	private String uanombrePiso;
	private String uadireNocapv;
	private String uadireAnt;
	private String uatipointerv;
	private String uaexcodigo;
	private String uadtcodigo;
	private String uaescodigo;
	private Date uatrfecalta;
	private Date uatrfecmodif;
	private String uatrusualta;
	private String uatrusumodif;
	private Date uafecalta;
	private Date uafecmodif;
	private String uausualta;
	private String uausumodif;
	private String uacoem;
	private String uanodir;
	private String uaapellido1;
	private String uaapellido2;
	private String uapaisId;
	private String uaentidadId;
	private String uanoco;
	private String uanopeco;
	private String uaurl;
	private String uasecodigo;
	private String uasenombre;
	private String uasenombree;
	private String uafecultmod;
	private String uausuultmod;
	private String uaformanotificacion;
	private String uaidioma;
	private String uasexo;
	private String uaestado;
	private String uaedad;
	private String uatipoidentificacion;
	private List<Arbenvio> arbenvios = new ArrayList<Arbenvio>();
	private List<Arbtramexp> arbtramexps = new ArrayList<Arbtramexp>();

	private Solarb solarb;
	private String direccionCompleta;
	private String nombreCompleto;
	private String usuarioxlnet;

	private String provinciaTxt;
	private String municipioTxt;
	private String codTipointerv;

	private String reclamadoCambio;
	private String reclamanteCambio;

	private String codigoTxt;

	// para estableciminetos
	private boolean adherida;
	private String tipoAdh;
	private String tipoArb;
	private String establecimientoCerrado;

	private String activos;

	/**
	 * Method 'Arbinterv'.
	 */
	public Arbinterv() {
	}

	/**
	 * Method 'Arbinterv'.
	 * 
	 * @param uaidinterv
	 *            Long
	 * @param uanombre
	 *            String
	 * @param uanif
	 *            String
	 * @param uanrtel
	 *            String
	 * @param uanrtel2
	 *            String
	 * @param uaprovId
	 *            String
	 * @param uamunId
	 *            String
	 * @param ualocId
	 *            String
	 * @param uacalleId
	 *            String
	 * @param uacpId
	 *            String
	 * @param uaportalId
	 *            String
	 * @param uanombrePiso
	 *            String
	 * @param uadireNocapv
	 *            String
	 * @param uadireAnt
	 *            String
	 * @param uatipointerv
	 *            String
	 * @param uaexcodigo
	 *            String
	 * @param uadtcodigo
	 *            String
	 * @param uaescodigo
	 *            String
	 * @param uatrfecalta
	 *            Date
	 * @param uatrfecmodif
	 *            Date
	 * @param uatrusualta
	 *            String
	 * @param uatrusumodif
	 *            String
	 * @param uafecalta
	 *            Date
	 * @param uafecmodif
	 *            Date
	 * @param uausualta
	 *            String
	 * @param uausumodif
	 *            String
	 * @param uacoem
	 *            String
	 * @param uanodir
	 *            String
	 * @param uaapellido1
	 *            String
	 * @param uaapellido2
	 *            String
	 * @param uapaisId
	 *            String
	 * @param uaentidadId
	 *            String
	 * @param uanoco
	 *            String
	 * @param uanopeco
	 *            String
	 * @param uaurl
	 *            String
	 * @param uasecodigo
	 *            String
	 * @param uasenombre
	 *            String
	 * @param uasenombree
	 *            String
	 * @param uafecultmod
	 *            String
	 * @param uausuultmod
	 *            String
	 * @param uaformanotificacion
	 *            String
	 * @param uaidioma
	 *            String
	 * @param uasexo
	 *            String
	 * @param uaedad
	 *            String
	 * @param uatipoidentificacion
	 *            String
	 */
	public Arbinterv(BigDecimal uaidinterv, String uanombre, String uanif, String uanrtel, String uanrtel2,
			String uaprovId, String uamunId, String ualocId, String uacalleId, String uacpId, String uaportalId,
			String uanombrePiso, String uadireNocapv, String uadireAnt, String uatipointerv, String uaexcodigo,
			String uadtcodigo, String uaescodigo, Date uatrfecalta, Date uatrfecmodif, String uatrusualta,
			String uatrusumodif, Date uafecalta, Date uafecmodif, String uausualta, String uausumodif, String uacoem,
			String uanodir, String uaapellido1, String uaapellido2, String uapaisId, String uaentidadId, String uanoco,
			String uanopeco, String uaurl, String uasecodigo, String uasenombre, String uasenombree, String uafecultmod,
			String uausuultmod, String uaformanotificacion, String uaidioma, String uasexo, String uaedad,
			String uatipoidentificacion) {
		this.uaidinterv = uaidinterv;
		this.uanombre = uanombre;
		this.uanif = uanif;
		this.uanrtel = uanrtel;
		this.uanrtel2 = uanrtel2;
		this.uaprovId = uaprovId;
		this.uamunId = uamunId;
		this.ualocId = ualocId;
		this.uacalleId = uacalleId;
		this.uacpId = uacpId;
		this.uaportalId = uaportalId;
		this.uanombrePiso = uanombrePiso;
		this.uadireNocapv = uadireNocapv;
		this.uadireAnt = uadireAnt;
		this.uatipointerv = uatipointerv;
		this.uaexcodigo = uaexcodigo;
		this.uadtcodigo = uadtcodigo;
		this.uaescodigo = uaescodigo;
		this.uatrfecalta = uatrfecalta;
		this.uatrfecmodif = uatrfecmodif;
		this.uatrusualta = uatrusualta;
		this.uatrusumodif = uatrusumodif;
		this.uafecalta = uafecalta;
		this.uafecmodif = uafecmodif;
		this.uausualta = uausualta;
		this.uausumodif = uausumodif;
		this.uacoem = uacoem;
		this.uanodir = uanodir;
		this.uaapellido1 = uaapellido1;
		this.uaapellido2 = uaapellido2;
		this.uapaisId = uapaisId;
		this.uaentidadId = uaentidadId;
		this.uanoco = uanoco;
		this.uanopeco = uanopeco;
		this.uaurl = uaurl;
		this.uasecodigo = uasecodigo;
		this.uasenombre = uasenombre;
		this.uasenombree = uasenombree;
		this.uafecultmod = uafecultmod;
		this.uausuultmod = uausuultmod;
		this.uaformanotificacion = uaformanotificacion;
		this.uaidioma = uaidioma;
		this.uasexo = uasexo;
		this.uaedad = uaedad;
		this.uatipoidentificacion = uatipoidentificacion;
	}

	/**
	 * Method 'Arbinterv'.
	 * 
	 * @param uaidinterv
	 *            BigDecimal
	 * @param uanombre
	 *            String
	 * @param uanif
	 *            String
	 * @param uanrtel
	 *            String
	 * @param uanrtel2
	 *            String
	 * @param uaprovId
	 *            String
	 * @param uamunId
	 *            String
	 * @param ualocId
	 *            String
	 * @param uacalleId
	 *            String
	 * @param uacpId
	 *            String
	 * @param uaportalId
	 *            String
	 * @param uanombrePiso
	 *            String
	 * @param uadireNocapv
	 *            String
	 * @param uadireAnt
	 *            String
	 * @param uatipointerv
	 *            String
	 * @param uaexcodigo
	 *            String
	 * @param uadtcodigo
	 *            String
	 * @param uaescodigo
	 *            String
	 * @param uatrfecalta
	 *            Date
	 * @param uatrfecmodif
	 *            Date
	 * @param uatrusualta
	 *            String
	 * @param uatrusumodif
	 *            String
	 * @param uafecalta
	 *            Date
	 * @param uafecmodif
	 *            Date
	 * @param uausualta
	 *            String
	 * @param uausumodif
	 *            String
	 * @param uacoem
	 *            String
	 * @param uanodir
	 *            String
	 * @param uaapellido1
	 *            String
	 * @param uaapellido2
	 *            String
	 * @param uapaisId
	 *            String
	 * @param uaentidadId
	 *            String
	 * @param uanoco
	 *            String
	 * @param uanopeco
	 *            String
	 * @param uaurl
	 *            String
	 * @param uasecodigo
	 *            String
	 * @param uasenombre
	 *            String
	 * @param uasenombree
	 *            String
	 * @param uafecultmod
	 *            String
	 * @param uausuultmod
	 *            String
	 * @param uaformanotificacion
	 *            String
	 * @param uaidioma
	 *            String
	 * @param uasexo
	 *            String
	 * @param uaedad
	 *            String
	 * @param uatipoidentificacion
	 *            String
	 * @param arbenvios
	 *            List<Arbenvio>
	 * @param arbtramexps
	 *            List<Arbtramexp>
	 */
	public Arbinterv(BigDecimal uaidinterv, String uanombre, String uanif, String uanrtel, String uanrtel2,
			String uaprovId, String uamunId, String ualocId, String uacalleId, String uacpId, String uaportalId,
			String uanombrePiso, String uadireNocapv, String uadireAnt, String uatipointerv, String uaexcodigo,
			String uadtcodigo, String uaescodigo, Date uatrfecalta, Date uatrfecmodif, String uatrusualta,
			String uatrusumodif, Date uafecalta, Date uafecmodif, String uausualta, String uausumodif, String uacoem,
			String uanodir, String uaapellido1, String uaapellido2, String uapaisId, String uaentidadId, String uanoco,
			String uanopeco, String uaurl, String uasecodigo, String uasenombre, String uasenombree, String uafecultmod,
			String uausuultmod, String uaformanotificacion, String uaidioma, String uasexo, String uaedad,
			String uatipoidentificacion, List<Arbenvio> arbenvios, List<Arbtramexp> arbtramexps) {

		this.uaidinterv = uaidinterv;
		this.uanombre = uanombre;
		this.uanif = uanif;
		this.uanrtel = uanrtel;
		this.uanrtel2 = uanrtel2;
		this.uaprovId = uaprovId;
		this.uamunId = uamunId;
		this.ualocId = ualocId;
		this.uacalleId = uacalleId;
		this.uacpId = uacpId;
		this.uaportalId = uaportalId;
		this.uanombrePiso = uanombrePiso;
		this.uadireNocapv = uadireNocapv;
		this.uadireAnt = uadireAnt;
		this.uatipointerv = uatipointerv;
		this.uaexcodigo = uaexcodigo;
		this.uadtcodigo = uadtcodigo;
		this.uaescodigo = uaescodigo;
		this.uatrfecalta = uatrfecalta;
		this.uatrfecmodif = uatrfecmodif;
		this.uatrusualta = uatrusualta;
		this.uatrusumodif = uatrusumodif;
		this.uafecalta = uafecalta;
		this.uafecmodif = uafecmodif;
		this.uausualta = uausualta;
		this.uausumodif = uausumodif;
		this.uacoem = uacoem;
		this.uanodir = uanodir;
		this.uaapellido1 = uaapellido1;
		this.uaapellido2 = uaapellido2;
		this.uapaisId = uapaisId;
		this.uaentidadId = uaentidadId;
		this.uanoco = uanoco;
		this.uanopeco = uanopeco;
		this.uaurl = uaurl;
		this.uasecodigo = uasecodigo;
		this.uasenombre = uasenombre;
		this.uasenombree = uasenombree;
		this.uafecultmod = uafecultmod;
		this.uausuultmod = uausuultmod;
		this.uaformanotificacion = uaformanotificacion;
		this.uaidioma = uaidioma;
		this.uasexo = uasexo;
		this.uaedad = uaedad;
		this.uatipoidentificacion = uatipoidentificacion;
		this.arbenvios = arbenvios;
		this.arbtramexps = arbtramexps;
	}

	/**
	 * @return the reclamadoCambio
	 */
	public String getReclamadoCambio() {
		return reclamadoCambio;
	}

	/**
	 * @param reclamadoCambio
	 *            the reclamadoCambio to set
	 */
	public void setReclamadoCambio(String reclamadoCambio) {
		this.reclamadoCambio = reclamadoCambio;
	}

	/**
	 * @return the reclamanteCambio
	 */
	public String getReclamanteCambio() {
		return reclamanteCambio;
	}

	/**
	 * @param reclamanteCambio
	 *            the reclamanteCambio to set
	 */
	public void setReclamanteCambio(String reclamanteCambio) {
		this.reclamanteCambio = reclamanteCambio;
	}

	/**
	 * @return the codigoTxt
	 */
	public String getCodigoTxt() {
		return codigoTxt;
	}

	/**
	 * @param codigoTxt
	 *            the codigoTxt to set
	 */
	public void setCodigoTxt(String codigoTxt) {
		this.codigoTxt = codigoTxt;
	}

	/**
	 * @param uaidinterv
	 *            BigDecimal
	 */
	public Arbinterv(BigDecimal uaidinterv) {
		this.uaidinterv = uaidinterv;
	}

	/**
	 * Method 'getUaidinterv'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getUaidinterv() {
		return this.uaidinterv;
	}

	/**
	 * Method 'setUaidinterv'.
	 * 
	 * @param uaidinterv
	 *            BigDecimal
	 * @return
	 */

	public void setUaidinterv(BigDecimal uaidinterv) {
		this.uaidinterv = uaidinterv;
	}

	/**
	 * Method 'getUanombre'.
	 * 
	 * @return String
	 */

	public String getUanombre() {
		return this.uanombre;
	}

	/**
	 * Method 'setUanombre'.
	 * 
	 * @param uanombre
	 *            String
	 * @return
	 */

	public void setUanombre(String uanombre) {
		this.uanombre = uanombre;
	}

	/**
	 * Method 'getUanif'.
	 * 
	 * @return String
	 */

	public String getUanif() {
		return this.uanif;
	}

	/**
	 * Method 'setUanif'.
	 * 
	 * @param uanif
	 *            String
	 * @return
	 */

	public void setUanif(String uanif) {
		this.uanif = uanif;
	}

	/**
	 * Method 'getUanrtel'.
	 * 
	 * @return String
	 */

	public String getUanrtel() {
		return this.uanrtel;
	}

	/**
	 * Method 'setUanrtel'.
	 * 
	 * @param uanrtel
	 *            String
	 * @return
	 */

	public void setUanrtel(String uanrtel) {
		this.uanrtel = uanrtel;
	}

	/**
	 * Method 'getUanrtel2'.
	 * 
	 * @return String
	 */

	public String getUanrtel2() {
		return this.uanrtel2;
	}

	/**
	 * Method 'setUanrtel2'.
	 * 
	 * @param uanrtel2
	 *            String
	 * @return
	 */

	public void setUanrtel2(String uanrtel2) {
		this.uanrtel2 = uanrtel2;
	}

	/**
	 * Method 'getUaprovId'.
	 * 
	 * @return String
	 */

	public String getUaprovId() {
		return this.uaprovId;
	}

	/**
	 * Method 'setUaprovId'.
	 * 
	 * @param uaprovId
	 *            String
	 * @return
	 */

	public void setUaprovId(String uaprovId) {
		this.uaprovId = uaprovId;
	}

	/**
	 * Method 'getUamunId'.
	 * 
	 * @return String
	 */

	public String getUamunId() {
		return this.uamunId;
	}

	/**
	 * Method 'setUamunId'.
	 * 
	 * @param uamunId
	 *            String
	 * @return
	 */

	public void setUamunId(String uamunId) {
		this.uamunId = uamunId;
	}

	/**
	 * Method 'getUalocId'.
	 * 
	 * @return String
	 */

	public String getUalocId() {
		return this.ualocId;
	}

	/**
	 * Method 'setUalocId'.
	 * 
	 * @param ualocId
	 *            String
	 * @return
	 */

	public void setUalocId(String ualocId) {
		this.ualocId = ualocId;
	}

	/**
	 * Method 'getUacalleId'.
	 * 
	 * @return String
	 */

	public String getUacalleId() {
		return this.uacalleId;
	}

	/**
	 * Method 'setUacalleId'.
	 * 
	 * @param uacalleId
	 *            String
	 * @return
	 */

	public void setUacalleId(String uacalleId) {
		this.uacalleId = uacalleId;
	}

	/**
	 * Method 'getUacpId'.
	 * 
	 * @return String
	 */

	public String getUacpId() {
		return this.uacpId;
	}

	/**
	 * Method 'setUacpId'.
	 * 
	 * @param uacpId
	 *            String
	 * @return
	 */

	public void setUacpId(String uacpId) {
		this.uacpId = uacpId;
	}

	/**
	 * Method 'getUaportalId'.
	 * 
	 * @return String
	 */

	public String getUaportalId() {
		return this.uaportalId;
	}

	/**
	 * Method 'setUaportalId'.
	 * 
	 * @param uaportalId
	 *            String
	 * @return
	 */

	public void setUaportalId(String uaportalId) {
		this.uaportalId = uaportalId;
	}

	/**
	 * Method 'getUanombrePiso'.
	 * 
	 * @return String
	 */

	public String getUanombrePiso() {
		return this.uanombrePiso;
	}

	/**
	 * Method 'setUanombrePiso'.
	 * 
	 * @param uanombrePiso
	 *            String
	 * @return
	 */

	public void setUanombrePiso(String uanombrePiso) {
		if (uanombrePiso != null && uanombrePiso.length() > 40) {
			this.uanombrePiso = uanombrePiso.substring(0, 40);
		} else {
			this.uanombrePiso = uanombrePiso;
		}
	}

	/**
	 * Method 'getUadireNocapv'.
	 * 
	 * @return String
	 */

	public String getUadireNocapv() {
		return this.uadireNocapv;
	}

	/**
	 * Method 'setUadireNocapv'.
	 * 
	 * @param uadireNocapv
	 *            String
	 * @return
	 */

	public void setUadireNocapv(String uadireNocapv) {
		this.uadireNocapv = uadireNocapv;
	}

	/**
	 * Method 'getUadireAnt'.
	 * 
	 * @return String
	 */

	public String getUadireAnt() {
		return this.uadireAnt;
	}

	/**
	 * Method 'setUadireAnt'.
	 * 
	 * @param uadireAnt
	 *            String
	 * @return
	 */

	public void setUadireAnt(String uadireAnt) {
		this.uadireAnt = uadireAnt;
	}

	/**
	 * Method 'getUatipointerv'.
	 * 
	 * @return String
	 */

	public String getUatipointerv() {
		return this.uatipointerv;
	}

	/**
	 * Method 'setUatipointerv'.
	 * 
	 * @param uatipointerv
	 *            String
	 * @return
	 */

	public void setUatipointerv(String uatipointerv) {
		this.uatipointerv = uatipointerv;
	}

	/**
	 * Method 'getUaexcodigo'.
	 * 
	 * @return String
	 */

	public String getUaexcodigo() {
		return this.uaexcodigo;
	}

	/**
	 * Method 'setUaexcodigo'.
	 * 
	 * @param uaexcodigo
	 *            String
	 * @return
	 */

	public void setUaexcodigo(String uaexcodigo) {
		this.uaexcodigo = uaexcodigo;
	}

	/**
	 * Method 'getUadtcodigo'.
	 * 
	 * @return String
	 */

	public String getUadtcodigo() {
		return this.uadtcodigo;
	}

	/**
	 * Method 'setUadtcodigo'.
	 * 
	 * @param uadtcodigo
	 *            String
	 * @return
	 */

	public void setUadtcodigo(String uadtcodigo) {
		this.uadtcodigo = uadtcodigo;
	}

	/**
	 * Method 'getUaescodigo'.
	 * 
	 * @return String
	 */

	public String getUaescodigo() {
		return this.uaescodigo;
	}

	/**
	 * Method 'setUaescodigo'.
	 * 
	 * @param uaescodigo
	 *            String
	 * @return
	 */

	public void setUaescodigo(String uaescodigo) {
		this.uaescodigo = uaescodigo;
	}

	/**
	 * Method 'getUatrfecalta'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getUatrfecalta() {
		return this.uatrfecalta;
	}

	/**
	 * Method 'setUatrfecalta'.
	 * 
	 * @param uatrfecalta
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setUatrfecalta(Date uatrfecalta) {
		this.uatrfecalta = uatrfecalta;
	}

	/**
	 * Method 'getUatrfecmodif'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getUatrfecmodif() {
		return this.uatrfecmodif;
	}

	/**
	 * Method 'setUatrfecmodif'.
	 * 
	 * @param uatrfecmodif
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setUatrfecmodif(Date uatrfecmodif) {
		this.uatrfecmodif = uatrfecmodif;
	}

	/**
	 * Method 'getUatrusualta'.
	 * 
	 * @return String
	 */

	public String getUatrusualta() {
		return this.uatrusualta;
	}

	/**
	 * Method 'setUatrusualta'.
	 * 
	 * @param uatrusualta
	 *            String
	 * @return
	 */

	public void setUatrusualta(String uatrusualta) {
		this.uatrusualta = uatrusualta;
	}

	/**
	 * Method 'getUatrusumodif'.
	 * 
	 * @return String
	 */

	public String getUatrusumodif() {
		return this.uatrusumodif;
	}

	/**
	 * Method 'setUatrusumodif'.
	 * 
	 * @param uatrusumodif
	 *            String
	 * @return
	 */

	public void setUatrusumodif(String uatrusumodif) {
		this.uatrusumodif = uatrusumodif;
	}

	/**
	 * Method 'getUafecalta'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getUafecalta() {
		return this.uafecalta;
	}

	/**
	 * Method 'setUafecalta'.
	 * 
	 * @param uafecalta
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setUafecalta(Date uafecalta) {
		this.uafecalta = uafecalta;
	}

	/**
	 * Method 'getUafecmodif'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getUafecmodif() {
		return this.uafecmodif;
	}

	/**
	 * Method 'setUafecmodif'.
	 * 
	 * @param uafecmodif
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setUafecmodif(Date uafecmodif) {
		this.uafecmodif = uafecmodif;
	}

	/**
	 * Method 'getUausualta'.
	 * 
	 * @return String
	 */

	public String getUausualta() {
		return this.uausualta;
	}

	/**
	 * Method 'setUausualta'.
	 * 
	 * @param uausualta
	 *            String
	 * @return
	 */

	public void setUausualta(String uausualta) {
		this.uausualta = uausualta;
	}

	/**
	 * Method 'getUausumodif'.
	 * 
	 * @return String
	 */

	public String getUausumodif() {
		return this.uausumodif;
	}

	/**
	 * Method 'setUausumodif'.
	 * 
	 * @param uausumodif
	 *            String
	 * @return
	 */

	public void setUausumodif(String uausumodif) {
		this.uausumodif = uausumodif;
	}

	/**
	 * Method 'getUacoem'.
	 * 
	 * @return String
	 */

	public String getUacoem() {
		return this.uacoem;
	}

	/**
	 * Method 'setUacoem'.
	 * 
	 * @param uacoem
	 *            String
	 * @return
	 */

	public void setUacoem(String uacoem) {
		this.uacoem = uacoem;
	}

	/**
	 * Method 'getUanodir'.
	 * 
	 * @return String
	 */

	public String getUanodir() {
		return this.uanodir;
	}

	/**
	 * Method 'setUanodir'.
	 * 
	 * @param uanodir
	 *            String
	 * @return
	 */

	public void setUanodir(String uanodir) {
		this.uanodir = uanodir;
	}

	/**
	 * Method 'getUaapellido1'.
	 * 
	 * @return String
	 */

	public String getUaapellido1() {
		return this.uaapellido1;
	}

	/**
	 * Method 'setUaapellido1'.
	 * 
	 * @param uaapellido1
	 *            String
	 * @return
	 */

	public void setUaapellido1(String uaapellido1) {
		this.uaapellido1 = uaapellido1;
	}

	/**
	 * Method 'getUaapellido2'.
	 * 
	 * @return String
	 */

	public String getUaapellido2() {
		return this.uaapellido2;
	}

	/**
	 * Method 'setUaapellido2'.
	 * 
	 * @param uaapellido2
	 *            String
	 * @return
	 */

	public void setUaapellido2(String uaapellido2) {
		this.uaapellido2 = uaapellido2;
	}

	/**
	 * Method 'getUapaisId'.
	 * 
	 * @return String
	 */

	public String getUapaisId() {
		return this.uapaisId;
	}

	/**
	 * Method 'setUapaisId'.
	 * 
	 * @param uapaisId
	 *            String
	 * @return
	 */

	public void setUapaisId(String uapaisId) {
		this.uapaisId = uapaisId;
	}

	/**
	 * Method 'getUaentidadId'.
	 * 
	 * @return String
	 */

	public String getUaentidadId() {
		return this.uaentidadId;
	}

	/**
	 * Method 'setUaentidadId'.
	 * 
	 * @param uaentidadId
	 *            String
	 * @return
	 */

	public void setUaentidadId(String uaentidadId) {
		this.uaentidadId = uaentidadId;
	}

	/**
	 * Method 'getUanoco'.
	 * 
	 * @return String
	 */

	public String getUanoco() {
		return this.uanoco;
	}

	/**
	 * Method 'setUanoco'.
	 * 
	 * @param uanoco
	 *            String
	 * @return
	 */

	public void setUanoco(String uanoco) {
		this.uanoco = uanoco;
	}

	/**
	 * Method 'getUanopeco'.
	 * 
	 * @return String
	 */

	public String getUanopeco() {
		return this.uanopeco;
	}

	/**
	 * Method 'setUanopeco'.
	 * 
	 * @param uanopeco
	 *            String
	 * @return
	 */

	public void setUanopeco(String uanopeco) {
		this.uanopeco = uanopeco;
	}

	/**
	 * Method 'getUaurl'.
	 * 
	 * @return String
	 */

	public String getUaurl() {
		return this.uaurl;
	}

	/**
	 * Method 'setUaurl'.
	 * 
	 * @param uaurl
	 *            String
	 * @return
	 */

	public void setUaurl(String uaurl) {
		this.uaurl = uaurl;
	}

	/**
	 * Method 'getUasecodigo'.
	 * 
	 * @return String
	 */

	public String getUasecodigo() {
		return this.uasecodigo;
	}

	/**
	 * Method 'setUasecodigo'.
	 * 
	 * @param uasecodigo
	 *            String
	 * @return
	 */

	public void setUasecodigo(String uasecodigo) {
		this.uasecodigo = uasecodigo;
	}

	/**
	 * Method 'getUasenombre'.
	 * 
	 * @return String
	 */

	public String getUasenombre() {
		return this.uasenombre;
	}

	/**
	 * Method 'setUasenombre'.
	 * 
	 * @param uasenombre
	 *            String
	 * @return
	 */

	public void setUasenombre(String uasenombre) {
		this.uasenombre = uasenombre;
	}

	/**
	 * Method 'getUasenombree'.
	 * 
	 * @return String
	 */

	public String getUasenombree() {
		return this.uasenombree;
	}

	/**
	 * Method 'setUasenombree'.
	 * 
	 * @param uasenombree
	 *            String
	 * @return
	 */

	public void setUasenombree(String uasenombree) {
		this.uasenombree = uasenombree;
	}

	/**
	 * Method 'getUafecultmod'.
	 * 
	 * @return String
	 */

	public String getUafecultmod() {
		return this.uafecultmod;
	}

	/**
	 * Method 'setUafecultmod'.
	 * 
	 * @param uafecultmod
	 *            String
	 * @return
	 */

	public void setUafecultmod(String uafecultmod) {
		this.uafecultmod = uafecultmod;
	}

	/**
	 * Method 'getUausuultmod'.
	 * 
	 * @return String
	 */

	public String getUausuultmod() {
		return this.uausuultmod;
	}

	/**
	 * Method 'setUausuultmod'.
	 * 
	 * @param uausuultmod
	 *            String
	 * @return
	 */

	public void setUausuultmod(String uausuultmod) {
		this.uausuultmod = uausuultmod;
	}

	/**
	 * Method 'getUaformanotificacion'.
	 * 
	 * @return String
	 */

	public String getUaformanotificacion() {
		return this.uaformanotificacion;
	}

	/**
	 * Method 'setUaformanotificacion'.
	 * 
	 * @param uaformanotificacion
	 *            String
	 * @return
	 */

	public void setUaformanotificacion(String uaformanotificacion) {
		this.uaformanotificacion = uaformanotificacion;
	}

	/**
	 * Method 'getUaidioma'.
	 * 
	 * @return String
	 */

	public String getUaidioma() {
		return this.uaidioma;
	}

	/**
	 * Method 'setUaidioma'.
	 * 
	 * @param uaidioma
	 *            String
	 * @return
	 */

	public void setUaidioma(String uaidioma) {
		this.uaidioma = uaidioma;
	}

	/**
	 * Method 'getUasexo'.
	 * 
	 * @return String
	 */

	public String getUasexo() {
		return this.uasexo;
	}

	/**
	 * Method 'setUasexo'.
	 * 
	 * @param uasexo
	 *            String
	 * @return
	 */

	public void setUasexo(String uasexo) {
		this.uasexo = uasexo;
	}

	/**
	 * Method 'getUaedad'.
	 * 
	 * @return String
	 */

	public String getUaedad() {
		return this.uaedad;
	}

	/**
	 * Method 'setUaedad'.
	 * 
	 * @param uaedad
	 *            String
	 * @return
	 */

	public void setUaedad(String uaedad) {
		this.uaedad = uaedad;
	}

	/**
	 * Method 'getUatipoidentificacion'.
	 * 
	 * @return String
	 */

	public String getUatipoidentificacion() {
		return this.uatipoidentificacion;
	}

	/**
	 * Method 'setUatipoidentificacion'.
	 * 
	 * @param uatipoidentificacion
	 *            String
	 * @return
	 */

	public void setUatipoidentificacion(String uatipoidentificacion) {
		this.uatipoidentificacion = uatipoidentificacion;
	}

	/**
	 * Method 'getArbenvios'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<Arbenvio> getArbenvios() {
		return this.arbenvios;
	}

	/**
	 * Method 'setArbenvios'.
	 * 
	 * @param arbenvios
	 *            List
	 * @return
	 */
	public void setArbenvios(List<Arbenvio> arbenvios) {
		this.arbenvios = arbenvios;
	}

	/**
	 * Method 'getArbtramexps'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<Arbtramexp> getArbtramexps() {
		return this.arbtramexps;
	}

	/**
	 * Method 'setArbtramexps'.
	 * 
	 * @param arbtramexps
	 *            List
	 * @return
	 */
	public void setArbtramexps(List<Arbtramexp> arbtramexps) {
		this.arbtramexps = arbtramexps;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ uaidinterv: ").append(this.uaidinterv).append(" ]");
		result.append(", [ uanombre: ").append(this.uanombre).append(" ]");
		result.append(", [ uanif: ").append(this.uanif).append(" ]");
		result.append(", [ uanrtel: ").append(this.uanrtel).append(" ]");
		result.append(", [ uanrtel2: ").append(this.uanrtel2).append(" ]");
		result.append(", [ uaprovId: ").append(this.uaprovId).append(" ]");
		result.append(", [ uamunId: ").append(this.uamunId).append(" ]");
		result.append(", [ ualocId: ").append(this.ualocId).append(" ]");
		result.append(", [ uacalleId: ").append(this.uacalleId).append(" ]");
		result.append(", [ uacpId: ").append(this.uacpId).append(" ]");
		result.append(", [ uaportalId: ").append(this.uaportalId).append(" ]");
		result.append(", [ uanombrePiso: ").append(this.uanombrePiso).append(" ]");
		result.append(", [ uadireNocapv: ").append(this.uadireNocapv).append(" ]");
		result.append(", [ uadireAnt: ").append(this.uadireAnt).append(" ]");
		result.append(", [ uatipointerv: ").append(this.uatipointerv).append(" ]");
		result.append(", [ uaexcodigo: ").append(this.uaexcodigo).append(" ]");
		result.append(", [ uadtcodigo: ").append(this.uadtcodigo).append(" ]");
		result.append(", [ uaescodigo: ").append(this.uaescodigo).append(" ]");
		result.append(", [ uatrfecalta: ").append(this.uatrfecalta).append(" ]");
		result.append(", [ uatrfecmodif: ").append(this.uatrfecmodif).append(" ]");
		result.append(", [ uatrusualta: ").append(this.uatrusualta).append(" ]");
		result.append(", [ uatrusumodif: ").append(this.uatrusumodif).append(" ]");
		result.append(", [ uafecalta: ").append(this.uafecalta).append(" ]");
		result.append(", [ uafecmodif: ").append(this.uafecmodif).append(" ]");
		result.append(", [ uausualta: ").append(this.uausualta).append(" ]");
		result.append(", [ uausumodif: ").append(this.uausumodif).append(" ]");
		result.append(", [ uacoem: ").append(this.uacoem).append(" ]");
		result.append(", [ uanodir: ").append(this.uanodir).append(" ]");
		result.append(", [ uaapellido1: ").append(this.uaapellido1).append(" ]");
		result.append(", [ uaapellido2: ").append(this.uaapellido2).append(" ]");
		result.append(", [ uapaisId: ").append(this.uapaisId).append(" ]");
		result.append(", [ uaentidadId: ").append(this.uaentidadId).append(" ]");
		result.append(", [ uanoco: ").append(this.uanoco).append(" ]");
		result.append(", [ uanopeco: ").append(this.uanopeco).append(" ]");
		result.append(", [ uaurl: ").append(this.uaurl).append(" ]");
		result.append(", [ uasecodigo: ").append(this.uasecodigo).append(" ]");
		result.append(", [ uasenombre: ").append(this.uasenombre).append(" ]");
		result.append(", [ uasenombree: ").append(this.uasenombree).append(" ]");
		result.append(", [ uafecultmod: ").append(this.uafecultmod).append(" ]");
		result.append(", [ uausuultmod: ").append(this.uausuultmod).append(" ]");
		result.append(", [ uaformanotificacion: ").append(this.uaformanotificacion).append(" ]");
		result.append(", [ uaidioma: ").append(this.uaidioma).append(" ]");
		result.append(", [ uasexo: ").append(this.uasexo).append(" ]");
		result.append(", [ uaedad: ").append(this.uaedad).append(" ]");
		result.append(", [ uatipoidentificacion: ").append(this.uatipoidentificacion).append(" ]");
		result.append("}");
		return result.toString();
	}

	public void setSolarb(Solarb solarb) {
		this.solarb = solarb;
	}

	public Solarb getSolarb() {
		return solarb;
	}

	public void setDireccionCompleta(String direccionCompleta) {
		this.direccionCompleta = direccionCompleta;
	}

	public String getDireccionCompleta() {
		return direccionCompleta;
	}

	public boolean getTieneDireccionCompleta() {
		// tiene direccion completa (como esta en el js)
		// 0193046: FAC. Direccin de notificacin completa

		boolean resultado = true;

		if (!Y41bConstantes.COD_PAIS_ESTADO.equals(this.getUapaisId())) {
			// si es extranjero
			if (!Y41bUtils.esNullOCadenaVacia(this.getUapaisId())
					&& !Y41bUtils.esNullOCadenaVacia(this.getUadireNocapv())) {
				resultado = true;
			} else {
				resultado = false;
			}
		} else {
			if (this.getUaprovId() != null && !("".equalsIgnoreCase(this.getUaprovId())) && this.getUamunId() != null
					&& !("".equalsIgnoreCase(this.getUamunId())) && this.getUacalleId() != null
					&& !("".equalsIgnoreCase(this.getUacalleId()))) {
				resultado = true;
				// si NO es de capv
			} else if (this.getUadireNocapv() != null && !("".equalsIgnoreCase(this.getUadireNocapv()))) {
				resultado = true;
			} else {
				resultado = false;
			}
		}

		return resultado;

	}

	/**
	 * @return the usuarioxlnet
	 */
	public String getUsuarioxlnet() {
		return usuarioxlnet;
	}

	/**
	 * @param usuarioxlnet
	 *            the usuarioxlnet to set
	 */
	public void setUsuarioxlnet(String usuarioxlnet) {
		this.usuarioxlnet = usuarioxlnet;
	}

	public void setNombreCompleto(String nombreCompleto) {
		this.nombreCompleto = nombreCompleto;
	}

	public String getNombreCompleto() {
		return nombreCompleto;
	}

	/**
	 * @return the provinciaTxt
	 */
	public String getProvinciaTxt() {
		return provinciaTxt;
	}

	/**
	 * @param provinciaTxt
	 *            the provinciaTxt to set
	 */
	public void setProvinciaTxt(String provinciaTxt) {
		this.provinciaTxt = provinciaTxt;
	}

	/**
	 * @return the municipioTxt
	 */
	public String getMunicipioTxt() {
		return municipioTxt;
	}

	/**
	 * @param municipioTxt
	 *            the municipioTxt to set
	 */
	public void setMunicipioTxt(String municipioTxt) {
		this.municipioTxt = municipioTxt;
	}

	/**
	 * 
	 * @param codTipointerv
	 *            String
	 */
	public void setCodTipointerv(String codTipointerv) {
		this.codTipointerv = codTipointerv;
	}

	/**
	 * 
	 * @return String
	 */
	public String getCodTipointerv() {
		return codTipointerv;
	}

	/**
	 * 
	 * @param adherida
	 *            boolean
	 */
	public void setAdherida(boolean adherida) {
		this.adherida = adherida;
	}

	/**
	 * 
	 * @return boolean
	 */
	public boolean isAdherida() {
		return adherida;
	}

	/**
	 * @return the uaextranjero
	 */
	public String getUaextranjero() {
		return this.uaextranjero;
	}

	/**
	 * @param uaextranjero
	 *            the uaextranjero to set
	 */
	public void setUaextranjero(String uaextranjero) {
		this.uaextranjero = uaextranjero;
	}

	/**
	 * @return the uaestado
	 */
	public String getUaestado() {
		return this.uaestado;
	}

	/**
	 * @param uaestado
	 *            the uaestado to set
	 */
	public void setUaestado(String uaestado) {
		this.uaestado = uaestado;
	}

	/**
	 * @return the tipoArb
	 */
	public String getTipoArb() {
		return tipoArb;
	}

	/**
	 * @param tipoArb
	 *            the tipoArb to set
	 */
	public void setTipoArb(String tipoArb) {
		this.tipoArb = tipoArb;
	}

	public void setTipoAdh(String tipoAdh) {
		this.tipoAdh = tipoAdh;
	}

	public String getTipoAdh() {
		return tipoAdh;
	}

	/**
	 * @return the activos
	 */
	public String getActivos() {
		return activos;
	}

	/**
	 * @param activos
	 *            the activos to set
	 */
	public void setActivos(String activos) {
		this.activos = activos;
	}

	public void setEstablecimientoCerrado(String establecimientoCerrado) {
		this.establecimientoCerrado = establecimientoCerrado;
	}

	public String getEstablecimientoCerrado() {
		return establecimientoCerrado;
	}

}
