package com.ejie.y41b.model;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.ejie.x38.serialization.JsonDateTimeDeserializer;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.control.Y41bJsonDateTimeSerializer;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

/**
 * Arbadhtram  
 * 
 *  
 */

public class Arbadhtram implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String trid;
	private String trtridrel;
	private String trcodigo;
	private String trexcodigo;
	private Date trfecini;

	private Date trfecfin;
	private String trnomtrames;

	private Date trresofecha;
	private String trresotipo;
	private Date trfeccierre;
	private String trfcodigo;
	private String trtiponot;
	private String trestado;
	private Date trfecnotif;
	private BigDecimal truaidinterv;
	private String trcodigorel;
	private String tridnotifplatea;
	private Date trfecregs;
	private String trtipocom;
	private String trestadoacuse;
	private String trnumregs;
	private Date trfecacuse;
	private String tridesperaplatea;
	private String trmatarespera;
	private String trasuntocomunicacion;
	private String trtiponotplatea;
	private String trsede;
	private String trcodrem;
	private String trenvrem;
	private String tridmailorigen;
	private String trmailorigen;
	private String tridmaildestino;
	private String trmaildestino;
	private Clob trtexto;
	private Clob trobserves;
	private Date trfechaenviobopvboe;
	private String trproceedingsidplatea;
	private String trmonitor;
	private Clob trsiguientestramites;
	private String trnotcomsolici;
	private Date trfecrem;
	private Date trfecalta;
	private Date trfecmodif;
	private String trusualta;
	private String trusumodif;
	private List<Arbadhdoctram> arbadhdoctrams = new ArrayList<Arbadhdoctram>();
	private List<Arbadhdoc> arbadhdocs = new ArrayList<Arbadhdoc>();
	private List<Arbadhtram> arbadhtrams = new ArrayList<Arbadhtram>();

	private Arbadhsol arbadhsol;
	private Fase fase;

	// // Documento
	private String indVariosDocumentos; // S o N
	private String x5codocumento;
	private String x5nofile;
	private Blob x5datafile;
	private Integer x5sizefile;
	private String x5tedesfile;
	private String x5contenttypefile;
	private String x5origen;
	private String acuseSinNotificacion;

	private String nombreDestOrigen;
	private String tipoDestOrigen;

	private CensoMonitor censoMonitor;
	private CensoMonitor censoMonitorEj; /* ejecucion */
	private Tramite tramite;

	private String trnomtramCompleto;
	private String rmestado;

	private String tracusereintentado;
	private String trnotreintentado;
	private String trautomatico;

	/**
	 * Method 'Arbadhtram'.
	 */
	public Arbadhtram() {
	}

	/**
	 * @param trid
	 */
	public Arbadhtram(String trid) {
		super();
		this.trid = trid;
	}

	/**
	 * Method 'Arbadhtram'.
	 * 
	 * @param trid
	 *            Long
	 * @param trcodigo
	 *            String
	 * @param trexcodigo
	 *            BigDecimal
	 * @param trfecini
	 *            Date
	 * @param trfecfin
	 *            Date
	 * @param trnomtrames
	 *            String
	 * @param trresofecha
	 *            Date
	 * @param trresotipo
	 *            String
	 * @param trfeccierre
	 *            Date
	 * @param trfcodigo
	 *            String
	 * @param trtiponot
	 *            String
	 * @param trestado
	 *            String
	 * @param trfecnotif
	 *            Date
	 * @param truaidinterv
	 *            BigDecimal
	 * @param trcodigorel
	 *            String
	 * @param tridnotifplatea
	 *            String
	 * @param trfecregs
	 *            Date
	 * @param trtipocom
	 *            String
	 * @param trestadoacuse
	 *            String
	 * @param trnumregs
	 *            String
	 * @param trfecacuse
	 *            Date
	 * @param tridesperaplatea
	 *            String
	 * @param trmatarespera
	 *            String
	 * @param trasuntocomunicacion
	 *            String
	 * @param trtiponotplatea
	 *            String
	 * @param trsede
	 *            String
	 * @param trcodrem
	 *            String
	 * @param trenvrem
	 *            String
	 * @param tridmailorigen
	 *            String
	 * @param trmailorigen
	 *            String
	 * @param tridmaildestino
	 *            String
	 * @param trmaildestino
	 *            String
	 * @param trtexto
	 *            Clob
	 * @param trobserves
	 *            Clob
	 * @param trfechaenviobopvboe
	 *            Date
	 * @param trproceedingsidplatea
	 *            String
	 * @param trmonitor
	 *            String
	 * @param trsiguientestramites
	 *            Clob
	 * @param trnotcomsolici
	 *            String
	 * @param trfecrem
	 *            Date
	 * @param trfecalta
	 *            Date
	 * @param trfecmodif
	 *            Date
	 * @param trusualta
	 *            String
	 * @param trusumodif
	 *            String
	 * @param arbadhtram
	 *            Arbadhtram
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param fase
	 *            Fase
	 */
	public Arbadhtram(String trid, String trcodigo, String trexcodigo,
			Date trfecini, Date trfecfin, String trnomtrames, Date trresofecha,
			String trresotipo, Date trfeccierre, String trfcodigo,
			String trtiponot, String trestado, Date trfecnotif,
			BigDecimal truaidinterv, String trcodigorel,
			String tridnotifplatea, Date trfecregs, String trtipocom,
			String trestadoacuse, String trnumregs, Date trfecacuse,
			String tridesperaplatea, String trmatarespera,
			String trasuntocomunicacion, String trtiponotplatea, String trsede,
			String trcodrem, String trenvrem, String tridmailorigen,
			String trmailorigen, String tridmaildestino, String trmaildestino,
			Clob trtexto, Clob trobserves, Date trfechaenviobopvboe,
			String trproceedingsidplatea, String trmonitor,
			Clob trsiguientestramites, String trnotcomsolici, Date trfecrem,
			Date trfecalta, Date trfecmodif, String trusualta,
			String trusumodif, String trtridrel, Arbadhsol arbadhsol,
			Fase fase, CensoMonitor censoMonitor, CensoMonitor censoMonitorEj,
			Tramite tramite) {
		this.trid = trid;
		this.setTrtridrel(trtridrel);
		this.trcodigo = trcodigo;
		this.trexcodigo = trexcodigo;
		this.trfecini = trfecini;
		this.trfecfin = trfecfin;
		this.trnomtrames = trnomtrames;
		this.trresofecha = trresofecha;
		this.trresotipo = trresotipo;
		this.trfeccierre = trfeccierre;
		this.trfcodigo = trfcodigo;
		this.trtiponot = trtiponot;
		this.trestado = trestado;
		this.trfecnotif = trfecnotif;
		this.truaidinterv = truaidinterv;
		this.trcodigorel = trcodigorel;
		this.tridnotifplatea = tridnotifplatea;
		this.trfecregs = trfecregs;
		this.trtipocom = trtipocom;
		this.trestadoacuse = trestadoacuse;
		this.trnumregs = trnumregs;
		this.trfecacuse = trfecacuse;
		this.tridesperaplatea = tridesperaplatea;
		this.trmatarespera = trmatarespera;
		this.trasuntocomunicacion = trasuntocomunicacion;
		this.trtiponotplatea = trtiponotplatea;
		this.trsede = trsede;
		this.trcodrem = trcodrem;
		this.trenvrem = trenvrem;
		this.tridmailorigen = tridmailorigen;
		this.trmailorigen = trmailorigen;
		this.tridmaildestino = tridmaildestino;
		this.trmaildestino = trmaildestino;
		this.trtexto = trtexto;
		this.trobserves = trobserves;
		this.trfechaenviobopvboe = trfechaenviobopvboe;
		this.trproceedingsidplatea = trproceedingsidplatea;
		this.trmonitor = trmonitor;
		this.trsiguientestramites = trsiguientestramites;
		this.trnotcomsolici = trnotcomsolici;
		this.trfecrem = trfecrem;
		this.trfecalta = trfecalta;
		this.trfecmodif = trfecmodif;
		this.trusualta = trusualta;
		this.trusumodif = trusumodif;
		this.arbadhsol = arbadhsol;
		this.fase = fase;
		this.censoMonitor = censoMonitor;
		this.censoMonitorEj = censoMonitorEj;
		this.tramite = tramite;

	}

	/**
	 * @param trid
	 * @param trtexto
	 * @param trobserves
	 */
	public Arbadhtram(String trid, Clob trtexto, Clob trobserves) {
		super();
		this.trid = trid;
		this.trtexto = trtexto;
		this.trobserves = trobserves;
	}

	/**
	 * Method 'getTrid'.
	 * 
	 * @return String
	 */

	public String getTrid() {
		return this.trid;
	}

	/**
	 * Method 'setTrid'.
	 * 
	 * @param trid
	 *            String
	 * @return
	 */

	public void setTrid(String trid) {
		this.trid = trid;
	}

	/**
	 * Method 'getTrcodigo'.
	 * 
	 * @return String
	 */

	public String getTrcodigo() {
		return this.trcodigo;
	}

	/**
	 * Method 'setTrcodigo'.
	 * 
	 * @param trcodigo
	 *            String
	 * @return
	 */

	public void setTrcodigo(String trcodigo) {
		this.trcodigo = trcodigo;
	}

	/**
	 * Method 'getTrexcodigo'.
	 * 
	 * @return String
	 */

	public String getTrexcodigo() {
		return this.trexcodigo;
	}

	/**
	 * Method 'setTrexcodigo'.
	 * 
	 * @param trexcodigo
	 *            BigDecimal
	 * @return
	 */

	public void setTrexcodigo(String trexcodigo) {
		this.trexcodigo = trexcodigo;
	}

	/**
	 * Method 'getTrfecini'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = Y41bJsonDateTimeSerializer.class)
	public Date getTrfecini() {
		return this.trfecini;
	}

	/**
	 * Method 'setTrfecini'.
	 * 
	 * @param trfecini
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateTimeDeserializer.class)
	public void setTrfecini(Date trfecini) {
		this.trfecini = trfecini;
	}

	/**
	 * Method 'getTrfecfin'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = Y41bJsonDateTimeSerializer.class)
	public Date getTrfecfin() {
		return this.trfecfin;
	}

	/**
	 * Method 'setTrfecfin'.
	 * 
	 * @param trfecfin
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateTimeDeserializer.class)
	public void setTrfecfin(Date trfecfin) {
		this.trfecfin = trfecfin;
	}

	/**
	 * Method 'getTrnomtrames'.
	 * 
	 * @return String
	 */

	public String getTrnomtrames() {
		return this.trnomtrames;
	}

	/**
	 * Method 'setTrnomtrames'.
	 * 
	 * @param trnomtrames
	 *            String
	 * @return
	 */

	public void setTrnomtrames(String trnomtrames) {
		this.trnomtrames = trnomtrames;
	}

	/**
	 * Method 'getTrresofecha'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getTrresofecha() {
		return this.trresofecha;
	}

	/**
	 * Method 'setTrresofecha'.
	 * 
	 * @param trresofecha
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setTrresofecha(Date trresofecha) {
		this.trresofecha = trresofecha;
	}

	/**
	 * Method 'getTrresotipo'.
	 * 
	 * @return String
	 */

	public String getTrresotipo() {
		return this.trresotipo;
	}

	/**
	 * Method 'setTrresotipo'.
	 * 
	 * @param trresotipo
	 *            String
	 * @return
	 */

	public void setTrresotipo(String trresotipo) {
		this.trresotipo = trresotipo;
	}

	/**
	 * Method 'getTrfeccierre'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getTrfeccierre() {
		return this.trfeccierre;
	}

	/**
	 * Method 'setTrfeccierre'.
	 * 
	 * @param trfeccierre
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setTrfeccierre(Date trfeccierre) {
		this.trfeccierre = trfeccierre;
	}

	/**
	 * Method 'getTrfcodigo'.
	 * 
	 * @return String
	 */

	public String getTrfcodigo() {
		return this.trfcodigo;
	}

	/**
	 * Method 'setTrfcodigo'.
	 * 
	 * @param trfcodigo
	 *            String
	 * @return
	 */

	public void setTrfcodigo(String trfcodigo) {
		this.trfcodigo = trfcodigo;
	}

	/**
	 * Method 'getTrtiponot'.
	 * 
	 * @return String
	 */

	public String getTrtiponot() {
		return this.trtiponot;
	}

	/**
	 * Method 'setTrtiponot'.
	 * 
	 * @param trtiponot
	 *            String
	 * @return
	 */

	public void setTrtiponot(String trtiponot) {
		this.trtiponot = trtiponot;
	}

	/**
	 * Method 'getTrestado'.
	 * 
	 * @return String
	 */

	public String getTrestado() {
		return this.trestado;
	}

	/**
	 * Method 'setTrestado'.
	 * 
	 * @param trestado
	 *            String
	 * @return
	 */

	public void setTrestado(String trestado) {
		this.trestado = trestado;
	}

	/**
	 * Method 'getTrfecnotif'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getTrfecnotif() {
		return this.trfecnotif;
	}

	/**
	 * Method 'setTrfecnotif'.
	 * 
	 * @param trfecnotif
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setTrfecnotif(Date trfecnotif) {
		this.trfecnotif = trfecnotif;
	}

	/**
	 * Method 'getTruaidinterv'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getTruaidinterv() {
		return this.truaidinterv;
	}

	/**
	 * Method 'setTruaidinterv'.
	 * 
	 * @param truaidinterv
	 *            BigDecimal
	 * @return
	 */

	public void setTruaidinterv(BigDecimal truaidinterv) {
		this.truaidinterv = truaidinterv;
	}

	/**
	 * Method 'getTrcodigorel'.
	 * 
	 * @return String
	 */

	public String getTrcodigorel() {
		return this.trcodigorel;
	}

	/**
	 * Method 'setTrcodigorel'.
	 * 
	 * @param trcodigorel
	 *            String
	 * @return
	 */

	public void setTrcodigorel(String trcodigorel) {
		this.trcodigorel = trcodigorel;
	}

	/**
	 * Method 'getTridnotifplatea'.
	 * 
	 * @return String
	 */

	public String getTridnotifplatea() {
		return this.tridnotifplatea;
	}

	/**
	 * Method 'setTridnotifplatea'.
	 * 
	 * @param tridnotifplatea
	 *            String
	 * @return
	 */

	public void setTridnotifplatea(String tridnotifplatea) {
		this.tridnotifplatea = tridnotifplatea;
	}

	/**
	 * Method 'getTrfecregs'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getTrfecregs() {
		return this.trfecregs;
	}

	/**
	 * Method 'setTrfecregs'.
	 * 
	 * @param trfecregs
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setTrfecregs(Date trfecregs) {
		this.trfecregs = trfecregs;
	}

	/**
	 * Method 'getTrtipocom'.
	 * 
	 * @return String
	 */

	public String getTrtipocom() {
		return this.trtipocom;
	}

	/**
	 * Method 'setTrtipocom'.
	 * 
	 * @param trtipocom
	 *            String
	 * @return
	 */

	public void setTrtipocom(String trtipocom) {
		this.trtipocom = trtipocom;
	}

	/**
	 * Method 'getTrestadoacuse'.
	 * 
	 * @return String
	 */

	public String getTrestadoacuse() {
		return this.trestadoacuse;
	}

	/**
	 * Method 'setTrestadoacuse'.
	 * 
	 * @param trestadoacuse
	 *            String
	 * @return
	 */

	public void setTrestadoacuse(String trestadoacuse) {
		this.trestadoacuse = trestadoacuse;
	}

	/**
	 * Method 'getTrnumregs'.
	 * 
	 * @return String
	 */

	public String getTrnumregs() {
		return this.trnumregs;
	}

	/**
	 * Method 'setTrnumregs'.
	 * 
	 * @param trnumregs
	 *            String
	 * @return
	 */

	public void setTrnumregs(String trnumregs) {
		this.trnumregs = trnumregs;
	}

	/**
	 * Method 'getTrfecacuse'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getTrfecacuse() {
		return this.trfecacuse;
	}

	/**
	 * Method 'setTrfecacuse'.
	 * 
	 * @param trfecacuse
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setTrfecacuse(Date trfecacuse) {
		this.trfecacuse = trfecacuse;
	}

	/**
	 * Method 'getTridesperaplatea'.
	 * 
	 * @return String
	 */

	public String getTridesperaplatea() {
		return this.tridesperaplatea;
	}

	/**
	 * Method 'setTridesperaplatea'.
	 * 
	 * @param tridesperaplatea
	 *            String
	 * @return
	 */

	public void setTridesperaplatea(String tridesperaplatea) {
		this.tridesperaplatea = tridesperaplatea;
	}

	/**
	 * Method 'getTrmatarespera'.
	 * 
	 * @return String
	 */

	public String getTrmatarespera() {
		return this.trmatarespera;
	}

	/**
	 * Method 'setTrmatarespera'.
	 * 
	 * @param trmatarespera
	 *            String
	 * @return
	 */

	public void setTrmatarespera(String trmatarespera) {
		this.trmatarespera = trmatarespera;
	}

	/**
	 * Method 'getTrasuntocomunicacion'.
	 * 
	 * @return String
	 */

	public String getTrasuntocomunicacion() {
		return this.trasuntocomunicacion;
	}

	/**
	 * Method 'setTrasuntocomunicacion'.
	 * 
	 * @param trasuntocomunicacion
	 *            String
	 * @return
	 */

	public void setTrasuntocomunicacion(String trasuntocomunicacion) {
		this.trasuntocomunicacion = trasuntocomunicacion;
	}

	/**
	 * Method 'getTrtiponotplatea'.
	 * 
	 * @return String
	 */

	public String getTrtiponotplatea() {
		return this.trtiponotplatea;
	}

	/**
	 * Method 'setTrtiponotplatea'.
	 * 
	 * @param trtiponotplatea
	 *            String
	 * @return
	 */

	public void setTrtiponotplatea(String trtiponotplatea) {
		this.trtiponotplatea = trtiponotplatea;
	}

	/**
	 * Method 'getTrsede'.
	 * 
	 * @return String
	 */

	public String getTrsede() {
		return this.trsede;
	}

	/**
	 * Method 'setTrsede'.
	 * 
	 * @param trsede
	 *            String
	 * @return
	 */

	public void setTrsede(String trsede) {
		this.trsede = trsede;
	}

	/**
	 * Method 'getTrcodrem'.
	 * 
	 * @return String
	 */

	public String getTrcodrem() {
		return this.trcodrem;
	}

	/**
	 * Method 'setTrcodrem'.
	 * 
	 * @param trcodrem
	 *            String
	 * @return
	 */

	public void setTrcodrem(String trcodrem) {
		this.trcodrem = trcodrem;
	}

	/**
	 * Method 'getTrenvrem'.
	 * 
	 * @return String
	 */

	public String getTrenvrem() {
		return this.trenvrem;
	}

	/**
	 * Method 'setTrenvrem'.
	 * 
	 * @param trenvrem
	 *            String
	 * @return
	 */

	public void setTrenvrem(String trenvrem) {
		this.trenvrem = trenvrem;
	}

	/**
	 * Method 'getTridmailorigen'.
	 * 
	 * @return String
	 */

	public String getTridmailorigen() {
		return this.tridmailorigen;
	}

	/**
	 * Method 'setTridmailorigen'.
	 * 
	 * @param tridmailorigen
	 *            String
	 * @return
	 */

	public void setTridmailorigen(String tridmailorigen) {
		this.tridmailorigen = tridmailorigen;
	}

	/**
	 * Method 'getTrmailorigen'.
	 * 
	 * @return String
	 */

	public String getTrmailorigen() {
		return this.trmailorigen;
	}

	/**
	 * Method 'setTrmailorigen'.
	 * 
	 * @param trmailorigen
	 *            String
	 * @return
	 */

	public void setTrmailorigen(String trmailorigen) {
		this.trmailorigen = trmailorigen;
	}

	/**
	 * Method 'getTridmaildestino'.
	 * 
	 * @return String
	 */

	public String getTridmaildestino() {
		return this.tridmaildestino;
	}

	/**
	 * Method 'setTridmaildestino'.
	 * 
	 * @param tridmaildestino
	 *            String
	 * @return
	 */

	public void setTridmaildestino(String tridmaildestino) {
		this.tridmaildestino = tridmaildestino;
	}

	/**
	 * Method 'getTrmaildestino'.
	 * 
	 * @return String
	 */

	public String getTrmaildestino() {
		return this.trmaildestino;
	}

	/**
	 * Method 'setTrmaildestino'.
	 * 
	 * @param trmaildestino
	 *            String
	 * @return
	 */

	public void setTrmaildestino(String trmaildestino) {
		this.trmaildestino = trmaildestino;
	}

	/**
	 * Method 'getTrtexto'.
	 * 
	 * @return Clob
	 */
	@JsonIgnore
	public Clob getTrtexto() {
		return this.trtexto;
	}

	/**
	 * Method 'setTrtexto'.
	 * 
	 * @param trtexto
	 *            Clob
	 * @return
	 */

	public void setTrtexto(Clob trtexto) {
		this.trtexto = trtexto;
	}

	/**
	 * Method 'getTrobserves'.
	 * 
	 * @return Clob
	 */
	@JsonIgnore
	public Clob getTrobserves() {
		return this.trobserves;
	}

	/**
	 * Method 'setTrobserves'.
	 * 
	 * @param trobserves
	 *            Clob
	 * @return
	 */

	public void setTrobserves(Clob trobserves) {
		this.trobserves = trobserves;
	}

	/**
	 * Method 'getTrfechaenviobopvboe'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getTrfechaenviobopvboe() {
		return this.trfechaenviobopvboe;
	}

	/**
	 * Method 'setTrfechaenviobopvboe'.
	 * 
	 * @param trfechaenviobopvboe
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setTrfechaenviobopvboe(Date trfechaenviobopvboe) {
		this.trfechaenviobopvboe = trfechaenviobopvboe;
	}

	/**
	 * Method 'getTrproceedingsidplatea'.
	 * 
	 * @return String
	 */

	public String getTrproceedingsidplatea() {
		return this.trproceedingsidplatea;
	}

	/**
	 * Method 'setTrproceedingsidplatea'.
	 * 
	 * @param trproceedingsidplatea
	 *            String
	 * @return
	 */

	public void setTrproceedingsidplatea(String trproceedingsidplatea) {
		this.trproceedingsidplatea = trproceedingsidplatea;
	}

	/**
	 * Method 'getTrmonitor'.
	 * 
	 * @return String
	 */

	public String getTrmonitor() {
		return this.trmonitor;
	}

	/**
	 * Method 'setTrmonitor'.
	 * 
	 * @param trmonitor
	 *            String
	 * @return
	 */

	public void setTrmonitor(String trmonitor) {
		this.trmonitor = trmonitor;
	}

	/**
	 * Method 'getTrsiguientestramites'.
	 * 
	 * @return Clob
	 */
	@JsonIgnore
	public Clob getTrsiguientestramites() {
		return this.trsiguientestramites;
	}

	/**
	 * Method 'setTrsiguientestramites'.
	 * 
	 * @param trsiguientestramites
	 *            Clob
	 * @return
	 */

	public void setTrsiguientestramites(Clob trsiguientestramites) {
		this.trsiguientestramites = trsiguientestramites;
	}

	/**
	 * Method 'getTrnotcomsolici'.
	 * 
	 * @return String
	 */

	public String getTrnotcomsolici() {
		return this.trnotcomsolici;
	}

	/**
	 * Method 'setTrnotcomsolici'.
	 * 
	 * @param trnotcomsolici
	 *            String
	 * @return
	 */

	public void setTrnotcomsolici(String trnotcomsolici) {
		this.trnotcomsolici = trnotcomsolici;
	}

	/**
	 * Method 'getTrfecrem'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getTrfecrem() {
		return this.trfecrem;
	}

	/**
	 * Method 'setTrfecrem'.
	 * 
	 * @param trfecrem
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setTrfecrem(Date trfecrem) {
		this.trfecrem = trfecrem;
	}

	/**
	 * Method 'getTrfecalta'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getTrfecalta() {
		return this.trfecalta;
	}

	/**
	 * Method 'setTrfecalta'.
	 * 
	 * @param trfecalta
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setTrfecalta(Date trfecalta) {
		this.trfecalta = trfecalta;
	}

	/**
	 * Method 'getTrfecmodif'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getTrfecmodif() {
		return this.trfecmodif;
	}

	/**
	 * Method 'setTrfecmodif'.
	 * 
	 * @param trfecmodif
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setTrfecmodif(Date trfecmodif) {
		this.trfecmodif = trfecmodif;
	}

	/**
	 * Method 'getTrusualta'.
	 * 
	 * @return String
	 */

	public String getTrusualta() {
		return this.trusualta;
	}

	/**
	 * Method 'setTrusualta'.
	 * 
	 * @param trusualta
	 *            String
	 * @return
	 */

	public void setTrusualta(String trusualta) {
		this.trusualta = trusualta;
	}

	/**
	 * Method 'getTrusumodif'.
	 * 
	 * @return String
	 */

	public String getTrusumodif() {
		return this.trusumodif;
	}

	/**
	 * Method 'setTrusumodif'.
	 * 
	 * @param trusumodif
	 *            String
	 * @return
	 */

	public void setTrusumodif(String trusumodif) {
		this.trusumodif = trusumodif;
	}

	/**
	 * Method 'getArbadhdoctrams'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<Arbadhdoctram> getArbadhdoctrams() {
		return this.arbadhdoctrams;
	}

	/**
	 * Method 'setArbadhdoctrams'.
	 * 
	 * @param arbadhdoctrams
	 *            List
	 * @return
	 */
	public void setArbadhdoctrams(List<Arbadhdoctram> arbadhdoctrams) {
		this.arbadhdoctrams = arbadhdoctrams;
	}

	/**
	 * Method 'getArbadhdocs'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<Arbadhdoc> getArbadhdocs() {
		return this.arbadhdocs;
	}

	/**
	 * Method 'setArbadhdocs'.
	 * 
	 * @param arbadhdocs
	 *            List
	 * @return
	 */
	public void setArbadhdocs(List<Arbadhdoc> arbadhdocs) {
		this.arbadhdocs = arbadhdocs;
	}

	/**
	 * Method 'getArbadhtrams'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<Arbadhtram> getArbadhtrams() {
		return this.arbadhtrams;
	}

	/**
	 * Method 'setArbadhtrams'.
	 * 
	 * @param arbadhtrams
	 *            List
	 * @return
	 */
	public void setArbadhtrams(List<Arbadhtram> arbadhtrams) {
		this.arbadhtrams = arbadhtrams;
	}

	/**
	 * @return the arbadhsol
	 */
	public Arbadhsol getArbadhsol() {
		return arbadhsol;
	}

	/**
	 * @param arbadhsol
	 *            the arbadhsol to set
	 */
	public void setArbadhsol(Arbadhsol arbadhsol) {
		this.arbadhsol = arbadhsol;
	}

	/**
	 * @param fase
	 *            the fase to set
	 */
	public void setFase(Fase fase) {
		this.fase = fase;
	}

	/**
	 * @return the fase
	 */
	public Fase getFase() {
		return fase;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ trid: ").append(this.trid).append(" ]");
		result.append(", [ trcodigo: ").append(this.trcodigo).append(" ]");
		result.append(", [ trexcodigo: ").append(this.trexcodigo).append(" ]");
		result.append(", [ trfecini: ").append(this.trfecini).append(" ]");
		result.append(", [ trfecfin: ").append(this.trfecfin).append(" ]");
		result.append(", [ trnomtrames: ").append(this.trnomtrames)
				.append(" ]");
		result.append(", [ trresofecha: ").append(this.trresofecha)
				.append(" ]");
		result.append(", [ trresotipo: ").append(this.trresotipo).append(" ]");
		result.append(", [ trfeccierre: ").append(this.trfeccierre)
				.append(" ]");
		result.append(", [ trfcodigo: ").append(this.trfcodigo).append(" ]");
		result.append(", [ trtiponot: ").append(this.trtiponot).append(" ]");
		result.append(", [ trestado: ").append(this.trestado).append(" ]");
		result.append(", [ trfecnotif: ").append(this.trfecnotif).append(" ]");
		result.append(", [ truaidinterv: ").append(this.truaidinterv)
				.append(" ]");
		result.append(", [ trcodigorel: ").append(this.trcodigorel)
				.append(" ]");
		result.append(", [ tridnotifplatea: ").append(this.tridnotifplatea)
				.append(" ]");
		result.append(", [ trfecregs: ").append(this.trfecregs).append(" ]");
		result.append(", [ trtipocom: ").append(this.trtipocom).append(" ]");
		result.append(", [ trestadoacuse: ").append(this.trestadoacuse)
				.append(" ]");
		result.append(", [ trnumregs: ").append(this.trnumregs).append(" ]");
		result.append(", [ trfecacuse: ").append(this.trfecacuse).append(" ]");
		result.append(", [ tridesperaplatea: ").append(this.tridesperaplatea)
				.append(" ]");
		result.append(", [ trmatarespera: ").append(this.trmatarespera)
				.append(" ]");
		result.append(", [ trasuntocomunicacion: ")
				.append(this.trasuntocomunicacion).append(" ]");
		result.append(", [ trtiponotplatea: ").append(this.trtiponotplatea)
				.append(" ]");
		result.append(", [ trsede: ").append(this.trsede).append(" ]");
		result.append(", [ trcodrem: ").append(this.trcodrem).append(" ]");
		result.append(", [ trenvrem: ").append(this.trenvrem).append(" ]");
		result.append(", [ tridmailorigen: ").append(this.tridmailorigen)
				.append(" ]");
		result.append(", [ trmailorigen: ").append(this.trmailorigen)
				.append(" ]");
		result.append(", [ tridmaildestino: ").append(this.tridmaildestino)
				.append(" ]");
		result.append(", [ trmaildestino: ").append(this.trmaildestino)
				.append(" ]");
		result.append(", [ trfechaenviobopvboe: ")
				.append(this.trfechaenviobopvboe).append(" ]");
		result.append(", [ trproceedingsidplatea: ")
				.append(this.trproceedingsidplatea).append(" ]");
		result.append(", [ trmonitor: ").append(this.trmonitor).append(" ]");
		result.append(", [ trnotcomsolici: ").append(this.trnotcomsolici)
				.append(" ]");
		result.append(", [ trfecrem: ").append(this.trfecrem).append(" ]");
		result.append(", [ trfecalta: ").append(this.trfecalta).append(" ]");
		result.append(", [ trfecmodif: ").append(this.trfecmodif).append(" ]");
		result.append(", [ trusualta: ").append(this.trusualta).append(" ]");
		result.append(", [ trusumodif: ").append(this.trusumodif).append(" ]");

		result.append("}");
		return result.toString();
	}

	/**
	 * 
	 * @param indVariosDocumentos
	 *            the indVariosDocumentos to set
	 */
	public void setIndVariosDocumentos(String indVariosDocumentos) {
		this.indVariosDocumentos = indVariosDocumentos;
	}

	/**
	 * 
	 * @return the indVariosDocumentos
	 */
	public String getIndVariosDocumentos() {
		return indVariosDocumentos;
	}

	/**
	 * @return the x5codocumento
	 */
	public String getX5codocumento() {
		return x5codocumento;
	}

	/**
	 * @param x5codocumento
	 *            the x5codocumento to set
	 */
	public void setX5codocumento(String x5codocumento) {
		this.x5codocumento = x5codocumento;
	}

	/**
	 * @return the x5nofile
	 */
	public String getX5nofile() {
		return x5nofile;
	}

	/**
	 * @param x5nofile
	 *            the x5nofile to set
	 */
	public void setX5nofile(String x5nofile) {
		this.x5nofile = x5nofile;
	}

	/**
	 * @return the x5datafile
	 */
	public Blob getX5datafile() {
		return x5datafile;
	}

	/**
	 * @param x5datafile
	 *            the x5datafile to set
	 */
	public void setX5datafile(Blob x5datafile) {
		this.x5datafile = x5datafile;
	}

	/**
	 * @return the x5sizefile
	 */
	public Integer getX5sizefile() {
		return x5sizefile;
	}

	/**
	 * @param x5sizefile
	 *            the x5sizefile to set
	 */
	public void setX5sizefile(Integer x5sizefile) {
		this.x5sizefile = x5sizefile;
	}

	/**
	 * @return the x5tedesfile
	 */
	public String getX5tedesfile() {
		return x5tedesfile;
	}

	/**
	 * @param x5tedesfile
	 *            the x5tedesfile to set
	 */
	public void setX5tedesfile(String x5tedesfile) {
		this.x5tedesfile = x5tedesfile;
	}

	/**
	 * @return the x5contenttypefile
	 */
	public String getX5contenttypefile() {
		return x5contenttypefile;
	}

	/**
	 * @param x5contenttypefile
	 *            the x5contenttypefile to set
	 */
	public void setX5contenttypefile(String x5contenttypefile) {
		this.x5contenttypefile = x5contenttypefile;
	}

	/**
	 * 
	 * @param x5origen
	 *            String
	 */
	public void setX5origen(String x5origen) {
		this.x5origen = x5origen;
	}

	/**
	 * 
	 * @return String
	 */
	public String getX5origen() {
		return this.x5origen;
	}

	/**
	 * @return the acuseSinNotificacion
	 */
	public String getAcuseSinNotificacion() {
		return acuseSinNotificacion;
	}

	/**
	 * @param acuseSinNotificacion
	 *            the acuseSinNotificacion to set
	 */
	public void setAcuseSinNotificacion(String acuseSinNotificacion) {
		this.acuseSinNotificacion = acuseSinNotificacion;
	}

	/**
	 * @return the nombreDestOrigen
	 */
	public String getNombreDestOrigen() {
		return nombreDestOrigen;
	}

	/**
	 * @param nombreDestOrigen
	 *            the nombreDestOrigen to set
	 */
	public void setNombreDestOrigen(String nombreDestOrigen) {
		this.nombreDestOrigen = nombreDestOrigen;
	}

	/**
	 * @return the tipoDestOrigen
	 */
	public String getTipoDestOrigen() {
		return tipoDestOrigen;
	}

	/**
	 * @param tipoDestOrigen
	 *            the tipoDestOrigen to set
	 */
	public void setTipoDestOrigen(String tipoDestOrigen) {
		this.tipoDestOrigen = tipoDestOrigen;
	}

	/**
	 * @return the censoMonitorEj
	 */
	public CensoMonitor getCensoMonitorEj() {
		return censoMonitorEj;
	}

	/**
	 * @param censoMonitorEj
	 *            the censoMonitorEj to set
	 */
	public void setCensoMonitorEj(CensoMonitor censoMonitorEj) {
		this.censoMonitorEj = censoMonitorEj;
	}

	/**
	 * @param tramite
	 *            the tramite to set
	 */
	public void setTramite(Tramite tramite) {
		this.tramite = tramite;
	}

	/**
	 * @return the tramite
	 */
	public Tramite getTramite() {
		return tramite;
	}

	/**
	 * @return the trnomtramCompleto
	 */
	public String getTrnomtramCompletoes() {
		if (Y41bConstantes.TRAMITE_ADHESION_GENERICO_MOD.equals(trcodigo)
				|| Y41bConstantes.TRAMITE_ADHESION_GENERICO_ALTA
						.equals(trcodigo)
				|| Y41bConstantes.TRAMITE_ADHESION_GENERICO_BAJA
						.equals(trcodigo)) {
			this.trnomtramCompleto = trnomtrames;
		} else {
			this.trnomtramCompleto = (null == tramite ? "" : tramite
					.getTrnombre());
		}
		return this.trnomtramCompleto;
	}

	/**
	 * @return the trnomtramCompletoEU
	 */
	public String getTrnomtramCompletoeu() {
		if (Y41bConstantes.TRAMITE_ADHESION_GENERICO_MOD.equals(trcodigo)
				|| Y41bConstantes.TRAMITE_ADHESION_GENERICO_ALTA
						.equals(trcodigo)
				|| Y41bConstantes.TRAMITE_ADHESION_GENERICO_BAJA
						.equals(trcodigo)) {
			this.trnomtramCompleto = trnomtrames;
		} else {
			this.trnomtramCompleto = (null == tramite ? "" : tramite
					.getTrnombree());
		}
		return this.trnomtramCompleto;
	}

	/**
	 * @return the censoMonitor
	 */
	public CensoMonitor getCensoMonitor() {
		return censoMonitor;
	}

	/**
	 * @param censoMonitor
	 *            the censoMonitor to set
	 */
	public void setCensoMonitor(CensoMonitor censoMonitor) {
		this.censoMonitor = censoMonitor;
	}

	/**
	 * @param trtridrel
	 *            the trtridrel to set
	 */
	public void setTrtridrel(String trtridrel) {
		this.trtridrel = trtridrel;
	}

	/**
	 * @return the trtridrel
	 */
	public String getTrtridrel() {
		return trtridrel;
	}

	/**
	 * @return the rmestado
	 */
	public String getRmestado() {
		return rmestado;
	}

	/**
	 * @param rmestado
	 *            the rmestado to set
	 */
	public void setRmestado(String rmestado) {
		this.rmestado = rmestado;
	}

	/**
	 * @return the trcusereintentado
	 */
	public void setTracusereintentado(String tracusereintentado) {
		this.tracusereintentado = tracusereintentado;
	}

	/**
	 * @param tracusereintentado
	 *            the tracusereintentado to set
	 */
	public String getTracusereintentado() {
		return tracusereintentado;
	}

	/**
	 * @return the trautomatico
	 */
	public String getTrautomatico() {
		return trautomatico;
	}

	/**
	 * @param trautomatico
	 *            the trautomatico to set
	 */
	public void setTrautomatico(String trautomatico) {
		this.trautomatico = trautomatico;
	}

	/**
	 * @return the trnotreintentado
	 */
	public String getTrnotreintentado() {
		return trnotreintentado;
	}

	/**
	 * @param trnotreintentado
	 *            the trnotreintentado to set
	 */
	public void setTrnotreintentado(String trnotreintentado) {
		this.trnotreintentado = trnotreintentado;
	}

}
