package com.ejie.y41b.model;

import java.math.BigDecimal;
import java.util.Date;

import org.apache.commons.lang.builder.HashCodeBuilder;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.ejie.y41b.constantes.Y41bConstantes;

/**
 * ArbFicheroADO  
 * 
 *  
 */

public class ArbPagoArbitroADO implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * Method 'ArbFicheroADO'.
	 */
	public ArbPagoArbitroADO() {
	}

	private String trcodigo;
	private String sacodigo;
	private String sacoja;
	private BigDecimal sanror;
	private BigDecimal sanran;
	private String tridpagolaudo;
	private Date trfeopla;
	private Date safelaud;
	private String sacoarpt;
	private String sacoartt;
	private String sacoardt;
	private String arnif;
	private String arnombre;
	private String artercero;
	private String trimporte;
	private String arcodigo;
	private String panumexp;
	private Date pafeccont;
	private Date pafeculton;
	private String padocfi;
	private String codCompleto;
	private String uaidinterv;
	// para el filtro
	private String terceroEika;
	private String enviadoEika;
	private String respuestaEika;
	private String estado;
	private String incluir;
	private Date fechaDesde;
	private Date fechaHasta;
	private Date fechaEnvioEIKADesde;
	private Date fechaEnvioEIKAHasta;

	/**
	 * @return the arnif
	 */
	public String getArnif() {
		return arnif;
	}

	/**
	 * @param arnif
	 *            the arnif to set
	 */
	public void setArnif(String arnif) {
		this.arnif = arnif;
	}

	/**
	 * @return the arnombre
	 */
	public String getArnombre() {
		return arnombre;
	}

	/**
	 * @param arnombre
	 *            the arnombre to set
	 */
	public void setArnombre(String arnombre) {
		this.arnombre = arnombre;
	}

	/**
	 * @return the artercero
	 */
	public String getArtercero() {
		return artercero;
	}

	/**
	 * @param artercero
	 *            the artercero to set
	 */
	public void setArtercero(String artercero) {
		this.artercero = artercero;
	}

	/**
	 * @return the trimporte
	 */
	public String getTrimporte() {
		return trimporte;
	}

	/**
	 * @param trimporte
	 *            the trimporte to set
	 */
	public void setTrimporte(String trimporte) {
		this.trimporte = trimporte;
	}

	// campos para filtrado fuera del constructor
	private String findByCriterio;
	private String findByAltaTercero;

	// private List<Arbitro> arbitrosPagoLaudo = new ArrayList<Arbitro>();

	private String trmocodigoEj;

	/**
	 * Method 'getSacodigo'.
	 * 
	 * @return String
	 */

	public String getSacodigo() {
		return this.sacodigo;
	}

	/**
	 * Method 'setSacodigo'.
	 * 
	 * @param sacodigo
	 *            String
	 * @return
	 */

	public void setSacodigo(String sacodigo) {
		this.sacodigo = sacodigo;
	}

	/**
	 * Method 'getSacoja'.
	 * 
	 * @return String
	 */

	public String getSacoja() {
		return this.sacoja;
	}

	/**
	 * Method 'setSacoja'.
	 * 
	 * @param sacoja
	 *            String
	 * @return
	 */

	public void setSacoja(String sacoja) {
		this.sacoja = sacoja;
	}

	/**
	 * Method 'getSanror'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getSanror() {
		return this.sanror;
	}

	/**
	 * Method 'setSanror'.
	 * 
	 * @param sanror
	 *            BigDecimal
	 * @return
	 */

	public void setSanror(BigDecimal sanror) {
		this.sanror = sanror;
	}

	/**
	 * Method 'getSanran'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getSanran() {
		return this.sanran;
	}

	/**
	 * Method 'setSanran'.
	 * 
	 * @param sanran
	 *            BigDecimal
	 * @return
	 */

	public void setSanran(BigDecimal sanran) {
		this.sanran = sanran;
	}

	// /**
	// * Method 'getArbitrosPagoLaudo'.
	// *
	// * @return List
	// */
	//
	// public List<Arbitro> getArbitrosPagoLaudo() {
	// return this.arbitrosPagoLaudo;
	// }
	//
	// /**
	// * Method 'setArbitrosPagoLaudo'.
	// *
	// * @param arbitrosPagoLaudo
	// * List
	// * @return
	// */
	// public void setArbitrosPagoLaudo(List<Arbitro> arbitrosPagoLaudo) {
	// this.arbitrosPagoLaudo = arbitrosPagoLaudo;
	// }

	/**
	 * Method 'getFindByCriterio'.
	 * 
	 * @return String
	 */

	public String getFindByCriterio() {
		return this.findByCriterio;
	}

	/**
	 * Method 'setFindByCriterio'.
	 * 
	 * @param findByCriterio
	 *            String
	 * @return
	 */

	public void setFindByCriterio(String findByCriterio) {
		this.findByCriterio = findByCriterio;
	}

	/**
	 * Method 'getFindByAltaTercero'.
	 * 
	 * @return String
	 */

	public String getFindByAltaTercero() {
		return this.findByAltaTercero;
	}

	/**
	 * Method 'setFindByAltaTercero'.
	 * 
	 * @param findByAltaTercero
	 *            String
	 * @return
	 */

	public void setFindByAltaTercero(String findByAltaTercero) {
		this.findByAltaTercero = findByAltaTercero;
	}

	/**
	 * Method 'getTridpagolaudo'.
	 * 
	 * @return String
	 */

	public String getTridpagolaudo() {
		return this.tridpagolaudo;
	}

	/**
	 * Method 'setTridpagolaudo'.
	 * 
	 * @param tridpagolaudo
	 *            BigDecimal
	 * @return
	 */

	public void setTridpagolaudo(String tridpagolaudo) {
		this.tridpagolaudo = tridpagolaudo;
	}

	/**
	 * Method 'getPanumexp'.
	 * 
	 * @return String
	 */

	public String getPanumexp() {
		return this.panumexp;
	}

	/**
	 * Method 'setPanumexp'.
	 * 
	 * @param panumexp
	 *            String
	 * @return
	 */

	public void setPanumexp(String panumexp) {
		this.panumexp = panumexp;
	}

	/**
	 * Method 'getSafelaud'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getSafelaud() {
		return this.safelaud;
	}

	/**
	 * Method 'setSafelaud'.
	 * 
	 * @param safelaud
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setSafelaud(Date safelaud) {
		this.safelaud = safelaud;
	}

	/**
	 * Method 'getTrfeopla'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getTrfeopla() {
		return this.trfeopla;
	}

	/**
	 * Method 'setTrfeopla'.
	 * 
	 * @param trfeopla
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setTrfeopla(Date trfeopla) {
		this.trfeopla = trfeopla;
	}

	/**
	 * Damecod completo.
	 * 
	 * @return the string
	 */
	@JsonIgnore
	public String damecodCompleto() {
		return this.getSacoja() + Y41bConstantes.SEPARADOR_COD_COMPLETO_ARB_ADO + this.getSanror().toString()
				+ Y41bConstantes.SEPARADOR_COD_COMPLETO_ARB_ADO + this.getSanran().toString();

	}

	/**
	 * Damecod completo platea.
	 * 
	 * @return the string
	 */
	@JsonIgnore
	public String damecodCompletoPlatea() {
		return Y41bConstantes.TIPO_PROC_ARBITRAJE + Y41bConstantes.SEPARADOR_COD_COMPLETO_ARB_ADO + this.getSacoja()
				+ Y41bConstantes.SEPARADOR_COD_COMPLETO_ARB_ADO + this.getSanror().toString()
				+ Y41bConstantes.SEPARADOR_COD_COMPLETO_ARB_ADO + this.getSanran().toString();

	}

	/**
	 * @return the trmocodigoEj
	 */
	public String getTrmocodigoEj() {
		return trmocodigoEj;
	}

	/**
	 * @param trmocodigoEj
	 *            the trmocodigoEj to set
	 */
	public void setTrmocodigoEj(String trmocodigoEj) {
		this.trmocodigoEj = trmocodigoEj;
	}

	public void setTrcodigo(String trcodigo) {
		this.trcodigo = trcodigo;
	}

	public String getTrcodigo() {
		return trcodigo;
	}

	/**
	 * @return the terceroEika
	 */
	public String getTerceroEika() {
		return terceroEika;
	}

	/**
	 * @param terceroEika
	 *            the terceroEika to set
	 */
	public void setTerceroEika(String terceroEika) {
		this.terceroEika = terceroEika;
	}

	/**
	 * @return the enviadoEika
	 */
	public String getEnviadoEika() {
		return enviadoEika;
	}

	/**
	 * @param enviadoEika
	 *            the enviadoEika to set
	 */
	public void setEnviadoEika(String enviadoEika) {
		this.enviadoEika = enviadoEika;
	}

	/**
	 * @return the respuestaEika
	 */
	public String getRespuestaEika() {
		return respuestaEika;
	}

	/**
	 * @param respuestaEika
	 *            the respuestaEika to set
	 */
	public void setRespuestaEika(String respuestaEika) {
		this.respuestaEika = respuestaEika;
	}

	/**
	 * @return the estado
	 */
	public String getEstado() {
		return estado;
	}

	/**
	 * @param estado
	 *            the estado to set
	 */
	public void setEstado(String estado) {
		this.estado = estado;
	}

	/**
	 * @return the incluir
	 */
	public String getIncluir() {
		return incluir;
	}

	/**
	 * @param incluir
	 *            the incluir to set
	 */
	public void setIncluir(String incluir) {
		this.incluir = incluir;
	}

	/**
	 * @return the fechaDesde
	 */
	public Date getFechaDesde() {
		return fechaDesde;
	}

	/**
	 * @param fechaDesde
	 *            the fechaDesde to set
	 */
	public void setFechaDesde(Date fechaDesde) {
		this.fechaDesde = fechaDesde;
	}

	/**
	 * @return the fechaHasta
	 */
	public Date getFechaHasta() {
		return fechaHasta;
	}

	/**
	 * @param fechaHasta
	 *            the fechaHasta to set
	 */
	public void setFechaHasta(Date fechaHasta) {
		this.fechaHasta = fechaHasta;
	}

	/**
	 * @return the sacoarpt
	 */
	public String getSacoarpt() {
		return sacoarpt;
	}

	/**
	 * @param sacoarpt
	 *            the sacoarpt to set
	 */
	public void setSacoarpt(String sacoarpt) {
		this.sacoarpt = sacoarpt;
	}

	/**
	 * @return the sacoartt
	 */
	public String getSacoartt() {
		return sacoartt;
	}

	/**
	 * @param sacoartt
	 *            the sacoartt to set
	 */
	public void setSacoartt(String sacoartt) {
		this.sacoartt = sacoartt;
	}

	/**
	 * @return the sacoardt
	 */
	public String getSacoardt() {
		return sacoardt;
	}

	/**
	 * @param sacoardt
	 *            the sacoardt to set
	 */
	public void setSacoardt(String sacoardt) {
		this.sacoardt = sacoardt;
	}

	/**
	 * @return the arcodigo
	 */
	public String getArcodigo() {
		return arcodigo;
	}

	/**
	 * @param arcodigo
	 *            the arcodigo to set
	 */
	public void setArcodigo(String arcodigo) {
		this.arcodigo = arcodigo;
	}

	/**
	 * @return the pafeccont
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getPafeccont() {
		return pafeccont;
	}

	/**
	 * @param pafeccont
	 *            the pafeccont to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setPafeccont(Date pafeccont) {
		this.pafeccont = pafeccont;
	}

	/**
	 * @return the pafeculton
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getPafeculton() {
		return pafeculton;
	}

	/**
	 * @param pafeculton
	 *            the pafeculton to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setPafeculton(Date pafeculton) {
		this.pafeculton = pafeculton;
	}

	/**
	 * @return the padocfi
	 */
	public String getPadocfi() {
		return padocfi;
	}

	/**
	 * @param padocfi
	 *            the padocfi to set
	 */
	public void setPadocfi(String padocfi) {
		this.padocfi = padocfi;
	}

	public String getCodCompleto() {
		return codCompleto;
	}

	public void setCodCompleto(String codCompleto) {
		this.codCompleto = codCompleto;
	}

	public String getUaidinterv() {
		return uaidinterv;
	}

	public void setUaidinterv(String uaidinterv) {
		this.uaidinterv = uaidinterv;
	}

	public Date getFechaEnvioEIKADesde() {
		return fechaEnvioEIKADesde;
	}

	public void setFechaEnvioEIKADesde(Date fechaEnvioEIKADesde) {
		this.fechaEnvioEIKADesde = fechaEnvioEIKADesde;
	}

	public Date getFechaEnvioEIKAHasta() {
		return fechaEnvioEIKAHasta;
	}

	public void setFechaEnvioEIKAHasta(Date fechaEnvioEIKAHasta) {
		this.fechaEnvioEIKAHasta = fechaEnvioEIKAHasta;
	}

	@Override
	public boolean equals(Object obj) {

		if (obj instanceof ArbPagoArbitroADO) {

			ArbPagoArbitroADO tmp = (ArbPagoArbitroADO) obj;

			if (this.sacodigo.equals(tmp.sacodigo) && this.arcodigo.equals(tmp.arcodigo) &&

					this.tridpagolaudo.equals(tmp.tridpagolaudo)) {
				return true;
			} else {
				return false;
			}

		} else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return new HashCodeBuilder(17, 31). // two randomly chosen prime
											// numbers// if deriving:
											// appendSuper(super.hashCode()).
				append(sacodigo).append(arcodigo).append(tridpagolaudo).toHashCode();
	}
}
