package com.ejie.y41b.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.ejie.y41b.constantes.Y41bConstantes;

/**
 * ArbFicheroADO  
 * 
 *  
 */

public class ArbFicheroADO implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * Method 'ArbFicheroADO'.
	 */
	public ArbFicheroADO() {
	}

	private String trcodigo;
	private String sacodigo;
	private String sacoja;
	private BigDecimal sanror;
	private BigDecimal sanran;
	private String tridpagolaudo;
	private Date safelaud;

	// campos para filtrado fuera del constructor
	private String findByCriterio;
	private String findByAltaTercero;

	private List<Arbitro> arbitrosPagoLaudo = new ArrayList<Arbitro>();

	private String trmocodigoEj;

	/**
	 * Method 'getSacodigo'.
	 * 
	 * @return String
	 */

	public String getSacodigo() {
		return this.sacodigo;
	}

	/**
	 * Method 'setSacodigo'.
	 * 
	 * @param sacodigo
	 *            String
	 * @return
	 */

	public void setSacodigo(String sacodigo) {
		this.sacodigo = sacodigo;
	}

	/**
	 * Method 'getSacoja'.
	 * 
	 * @return String
	 */

	public String getSacoja() {
		return this.sacoja;
	}

	/**
	 * Method 'setSacoja'.
	 * 
	 * @param sacoja
	 *            String
	 * @return
	 */

	public void setSacoja(String sacoja) {
		this.sacoja = sacoja;
	}

	/**
	 * Method 'getSanror'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getSanror() {
		return this.sanror;
	}

	/**
	 * Method 'setSanror'.
	 * 
	 * @param sanror
	 *            BigDecimal
	 * @return
	 */

	public void setSanror(BigDecimal sanror) {
		this.sanror = sanror;
	}

	/**
	 * Method 'getSanran'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getSanran() {
		return this.sanran;
	}

	/**
	 * Method 'setSanran'.
	 * 
	 * @param sanran
	 *            BigDecimal
	 * @return
	 */

	public void setSanran(BigDecimal sanran) {
		this.sanran = sanran;
	}

	/**
	 * Method 'getArbitrosPagoLaudo'.
	 * 
	 * @return List
	 */

	public List<Arbitro> getArbitrosPagoLaudo() {
		return this.arbitrosPagoLaudo;
	}

	/**
	 * Method 'setArbitrosPagoLaudo'.
	 * 
	 * @param arbitrosPagoLaudo
	 *            List
	 * @return
	 */
	public void setArbitrosPagoLaudo(List<Arbitro> arbitrosPagoLaudo) {
		this.arbitrosPagoLaudo = arbitrosPagoLaudo;
	}

	/**
	 * Method 'getFindByCriterio'.
	 * 
	 * @return String
	 */

	public String getFindByCriterio() {
		return this.findByCriterio;
	}

	/**
	 * Method 'setFindByCriterio'.
	 * 
	 * @param findByCriterio
	 *            String
	 * @return
	 */

	public void setFindByCriterio(String findByCriterio) {
		this.findByCriterio = findByCriterio;
	}

	/**
	 * Method 'getFindByAltaTercero'.
	 * 
	 * @return String
	 */

	public String getFindByAltaTercero() {
		return this.findByAltaTercero;
	}

	/**
	 * Method 'setFindByAltaTercero'.
	 * 
	 * @param findByAltaTercero
	 *            String
	 * @return
	 */

	public void setFindByAltaTercero(String findByAltaTercero) {
		this.findByAltaTercero = findByAltaTercero;
	}

	/**
	 * Method 'getTridpagolaudo'.
	 * 
	 * @return String
	 */

	public String getTridpagolaudo() {
		return this.tridpagolaudo;
	}

	/**
	 * Method 'setTridpagolaudo'.
	 * 
	 * @param tridpagolaudo
	 *            BigDecimal
	 * @return
	 */

	public void setTridpagolaudo(String tridpagolaudo) {
		this.tridpagolaudo = tridpagolaudo;
	}

	/**
	 * Method 'getSafelaud'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getSafelaud() {
		return this.safelaud;
	}

	/**
	 * Method 'setSafelaud'.
	 * 
	 * @param safelaud
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setSafelaud(Date safelaud) {
		this.safelaud = safelaud;
	}

	/**
	 * Damecod completo.
	 * 
	 * @return the string
	 */
	@JsonIgnore
	public String damecodCompleto() {
		return this.getSacoja() + Y41bConstantes.SEPARADOR_COD_COMPLETO_ARB_ADO
				+ this.getSanror().toString()
				+ Y41bConstantes.SEPARADOR_COD_COMPLETO_ARB_ADO
				+ this.getSanran().toString();

	}

	/**
	 * Damecod completo platea.
	 * 
	 * @return the string
	 */
	@JsonIgnore
	public String damecodCompletoPlatea() {
		return Y41bConstantes.TIPO_PROC_ARBITRAJE
				+ Y41bConstantes.SEPARADOR_COD_COMPLETO_ARB_ADO
				+ this.getSacoja()
				+ Y41bConstantes.SEPARADOR_COD_COMPLETO_ARB_ADO
				+ this.getSanror().toString()
				+ Y41bConstantes.SEPARADOR_COD_COMPLETO_ARB_ADO
				+ this.getSanran().toString();

	}

	/**
	 * @return the trmocodigoEj
	 */
	public String getTrmocodigoEj() {
		return trmocodigoEj;
	}

	/**
	 * @param trmocodigoEj
	 *            the trmocodigoEj to set
	 */
	public void setTrmocodigoEj(String trmocodigoEj) {
		this.trmocodigoEj = trmocodigoEj;
	}

	public void setTrcodigo(String trcodigo) {
		this.trcodigo = trcodigo;
	}

	public String getTrcodigo() {
		return trcodigo;
	}
}
