package com.ejie.y41b.model;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import java.util.Date;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

/**
 * AlertaProgramacion  
 * 
 *  
 */

public class AlertaProgramacion implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String crcodigo;
	private Alerta alerta;
	private TipoCaracterAlerta tipoCaracterAlerta;
	private Distribuidor distribuidor;
	private String crcoor;
	private Date crferere;
	private String crteinfo;
	private Integer crcnactu;
	private String crinprse;
	private Date crfechacomunicacion;
	private Date crfechaplazo;
	private Date crfechacierre;
	private String cracuerdoinicio;
	private String crprogramaciondesc;
	private String crprogramaciondesce;
	private String crinspeccionsolicitada;

	/**
	 * Method 'AlertaProgramacion'.
	 */
	public AlertaProgramacion() {
	}

	/**
	 * Method 'AlertaProgramacion'.
	 * 
	 * @param crcodigo
	 *            String
	 */
	public AlertaProgramacion(String crcodigo) {

		this.crcodigo = crcodigo;
	}

	/**
	 * Method 'AlertaProgramacion'.
	 * 
	 * @param crcodigo
	 *            String
	 * @param crcoor
	 *            String
	 * @param crferere
	 *            Date
	 * @param crteinfo
	 *            String
	 * @param crcnactu
	 *            Integer
	 * @param crinprse
	 *            String
	 * @param crfechacomunicacion
	 *            Date
	 * @param crfechaplazo
	 *            Date
	 * @param crfechacierre
	 *            Date
	 * @param alerta
	 *            Alerta
	 * @param tipoCaracterAlerta
	 *            TipoCaracterAlerta
	 * @param distribuidor
	 *            Distribuidor
	 * @param cracuerdoinicio
	 *            String
	 * @param crinspeccionsolicitada
	 *            String
	 */
	public AlertaProgramacion(String crcodigo, String crcoor, Date crferere,
			String crteinfo, Integer crcnactu, String crinprse,
			Date crfechacomunicacion, Date crfechaplazo, Date crfechacierre,
			Alerta alerta, TipoCaracterAlerta tipoCaracterAlerta,
			Distribuidor distribuidor, String cracuerdoinicio,
			String crinspeccionsolicitada) {

		this.crcodigo = crcodigo;
		this.alerta = alerta;
		this.tipoCaracterAlerta = tipoCaracterAlerta;
		this.distribuidor = distribuidor;
		this.crcoor = crcoor;
		this.crferere = crferere;
		this.crteinfo = crteinfo;
		this.crcnactu = crcnactu;
		this.crinprse = crinprse;
		this.crfechacomunicacion = crfechacomunicacion;
		this.crfechaplazo = crfechaplazo;
		this.crfechacierre = crfechacierre;
		this.cracuerdoinicio = cracuerdoinicio;
		this.crinspeccionsolicitada = crinspeccionsolicitada;
	}

	/**
	 * Method 'AlertaProgramacion'.
	 * 
	 * @param crfechaplazo
	 *            Date
	 */
	public AlertaProgramacion(Date crfechaplazo) {
		this.crfechaplazo = crfechaplazo;
	}

	/**
	 * Method 'getCrcodigo'.
	 * 
	 * @return String
	 */

	public String getCrcodigo() {
		return this.crcodigo;
	}

	/**
	 * Method 'setCrcodigo'.
	 * 
	 * @param crcodigo
	 *            String
	 * @return
	 */

	public void setCrcodigo(String crcodigo) {
		this.crcodigo = crcodigo;
	}

	/**
	 * Method 'getAlerta'.
	 * 
	 * @return Alerta
	 */

	public Alerta getAlerta() {
		return this.alerta;
	}

	/**
	 * Method 'setAlerta'.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return
	 */

	public void setAlerta(Alerta alerta) {
		this.alerta = alerta;
	}

	/**
	 * Method 'getTipoCaracterAlerta'.
	 * 
	 * @return TipoCaracterAlerta
	 */
	@JsonIgnore
	public TipoCaracterAlerta getTipoCaracterAlerta() {
		return this.tipoCaracterAlerta;
	}

	/**
	 * Method 'setTipoCaracterAlerta'.
	 * 
	 * @param tipoCaracterAlerta
	 *            TipoCaracterAlerta
	 * @return
	 */

	public void setTipoCaracterAlerta(TipoCaracterAlerta tipoCaracterAlerta) {
		this.tipoCaracterAlerta = tipoCaracterAlerta;
	}

	/**
	 * Method 'getDistribuidor'.
	 * 
	 * @return Distribuidor
	 */
	@JsonIgnore
	public Distribuidor getDistribuidor() {
		return this.distribuidor;
	}

	/**
	 * Method 'setDistribuidor'.
	 * 
	 * @param distribuidor
	 *            Distribuidor
	 * @return
	 */

	public void setDistribuidor(Distribuidor distribuidor) {
		this.distribuidor = distribuidor;
	}

	/**
	 * Method 'getCrcoor'.
	 * 
	 * @return String
	 */

	public String getCrcoor() {
		return this.crcoor;
	}

	/**
	 * Method 'setCrcoor'.
	 * 
	 * @param crcoor
	 *            String
	 * @return
	 */

	public void setCrcoor(String crcoor) {
		this.crcoor = crcoor;
	}

	/**
	 * Method 'getCrferere'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getCrferere() {
		return this.crferere;
	}

	/**
	 * Method 'setCrferere'.
	 * 
	 * @param crferere
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setCrferere(Date crferere) {
		this.crferere = crferere;
	}

	/**
	 * Method 'getCrteinfo'.
	 * 
	 * @return String
	 */

	public String getCrteinfo() {
		return this.crteinfo;
	}

	/**
	 * Method 'setCrteinfo'.
	 * 
	 * @param crteinfo
	 *            String
	 * @return
	 */

	public void setCrteinfo(String crteinfo) {
		this.crteinfo = crteinfo;
	}

	/**
	 * Method 'getCrcnactu'.
	 * 
	 * @return Integer
	 */

	public Integer getCrcnactu() {
		return this.crcnactu;
	}

	/**
	 * Method 'setCrcnactu'.
	 * 
	 * @param crcnactu
	 *            Integer
	 * @return
	 */

	public void setCrcnactu(Integer crcnactu) {
		this.crcnactu = crcnactu;
	}

	/**
	 * Method 'getCrinprse'.
	 * 
	 * @return String
	 */

	public String getCrinprse() {
		return this.crinprse;
	}

	/**
	 * Method 'setCrinprse'.
	 * 
	 * @param crinprse
	 *            String
	 * @return
	 */

	public void setCrinprse(String crinprse) {
		this.crinprse = crinprse;
	}

	/**
	 * Method 'getCrfechacomunicacion'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getCrfechacomunicacion() {
		return this.crfechacomunicacion;
	}

	/**
	 * Method 'setCrfechacomunicacion'.
	 * 
	 * @param crfechacomunicacion
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setCrfechacomunicacion(Date crfechacomunicacion) {
		this.crfechacomunicacion = crfechacomunicacion;
	}

	/**
	 * Method 'getCrfechaplazo'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getCrfechaplazo() {
		return this.crfechaplazo;
	}

	/**
	 * Method 'setCrfechaplazo'.
	 * 
	 * @param crfechaplazo
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setCrfechaplazo(Date crfechaplazo) {
		this.crfechaplazo = crfechaplazo;
	}

	/**
	 * Method 'getCrfechacierre'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getCrfechacierre() {
		return this.crfechacierre;
	}

	/**
	 * Method 'setCrfechacierre'.
	 * 
	 * @param crfechacierre
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setCrfechacierre(Date crfechacierre) {
		this.crfechacierre = crfechacierre;
	}

	/**
	 * @return the cracuerdoinicio
	 */
	public String getCracuerdoinicio() {
		return cracuerdoinicio;
	}

	/**
	 * @param cracuerdoinicio
	 *            the cracuerdoinicio to set
	 */
	public void setCracuerdoinicio(String cracuerdoinicio) {
		this.cracuerdoinicio = cracuerdoinicio;
	}

	/**
	 * @return the crprogramaciondesc
	 */
	public String getCrprogramaciondesc() {
		return crprogramaciondesc;
	}

	/**
	 * @param crprogramaciondesc
	 *            the crprogramaciondesc to set
	 */
	public void setCrprogramaciondesc(String crprogramaciondesc) {
		this.crprogramaciondesc = crprogramaciondesc;
	}

	/**
	 * @return the crprogramaciondesce
	 */
	public String getCrprogramaciondesce() {
		return crprogramaciondesce;
	}

	/**
	 * @param crprogramaciondesce
	 *            the crprogramaciondesce to set
	 */
	public void setCrprogramaciondesce(String crprogramaciondesce) {
		this.crprogramaciondesce = crprogramaciondesce;
	}

	/**
	 * @return the crinspeccionsolicitada
	 */
	public String getCrinspeccionsolicitada() {
		return crinspeccionsolicitada;
	}

	/**
	 * @param crinspeccionsolicitada
	 *            the crinspeccionsolicitada to set
	 */
	public void setCrinspeccionsolicitada(String crinspeccionsolicitada) {
		this.crinspeccionsolicitada = crinspeccionsolicitada;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ crcodigo: ").append(this.crcodigo).append(" ]");
		result.append(", [ crcoor: ").append(this.crcoor).append(" ]");
		result.append(", [ crferere: ").append(this.crferere).append(" ]");
		result.append(", [ crteinfo: ").append(this.crteinfo).append(" ]");
		result.append(", [ crcnactu: ").append(this.crcnactu).append(" ]");
		result.append(", [ crinprse: ").append(this.crinprse).append(" ]");
		result.append(", [ crfechacomunicacion: ")
				.append(this.crfechacomunicacion).append(" ]");
		result.append(", [ crfechaplazo: ").append(this.crfechaplazo)
				.append(" ]");
		result.append(", [ crfechacierre: ").append(this.crfechacierre)
				.append(" ]");
		result.append("}");
		return result.toString();
	}

}
