package com.ejie.y41b.model;

import java.io.InputStream;
import java.sql.Blob;
import java.util.Date;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.ejie.y41b.control.Y41bJsonDateDeserializer;
import com.ejie.y41b.control.Y41bJsonDateSerializer;
import com.ejie.y41b.control.Y41bJsonDateTimeDeserializer;
import com.ejie.y41b.control.Y41bJsonDateTimeSerializer;

/**
 * Adjuntardocs  
 * 
 *  
 */

public class Adjuntardocs implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String thcodocumento;
	private TipoProcedimiento tipoProcedimiento;
	private Perfil perfil;
	private TipoDocumento tipoDocumento;
	private String thidExpediente;
	private String thidTramite;
	private String thnofile;
	private Blob thdatafile;
	private InputStream thdatafileinputstream;
	private Integer thsizefile;
	private String thtedesfile;
	private String thorigen;
	private String thtramite;
	private Date thfecha;
	private String thindmail;
	private String thtrmail;
	private String thcontenttypefile;
	private String thiddocumentum;
	private Date thfechaaportacion;
	private Date thfechaentrada;
	private String thnumregistroentrada;
	private String thestadodocumento;
	private Date thfechasolfirma;
	private Date thfechalimfirma;
	private Date thfechafirma;
	private String thcomofirma;
	private String thdestino;

	private Date thfechasollocalizador;

	// Requiere firma
	private String threquierefirma;

	// Plantilla
	private String ptcodigo;

	// Plantilla Decision
	private String pdcodigo;

	private Date thfecharegistroorigen;
	private String thnumregistroorigen;

	private String idInterviniente;

	private String thidtipodoc;

	private String thnumExpediente;

	// Procedimiento del trmite
	private String trpcodigo;

	private String thhashfile;
	private String firma;

	// Este campo contiene la ruta del pif donde se encuentra el fichero
	private String rutaPif;

	// Este campo contiene la ruta del pif donde se encuentra el fichero
	// devuelto por Giltza con la firma
	private String rutaPifFileFirma;

	/**
	 * Method 'Adjuntardocs'.
	 */
	public Adjuntardocs() {
	}

	/**
	 * @param thcodocumento
	 *            String
	 * @param thdatafile
	 *            Blob
	 */
	public Adjuntardocs(String thcodocumento, Blob thdatafile) {
		super();
		this.thcodocumento = thcodocumento;
		this.thdatafile = thdatafile;
	}

	/**
	 * @param thcodocumento
	 *            String
	 * @param thdatafile
	 *            Blob
	 */
	public Adjuntardocs(String thcodocumento, InputStream thdatafileinputstream) {
		super();
		this.thcodocumento = thcodocumento;
		this.thdatafileinputstream = thdatafileinputstream;
	}

	/**
	 * Method 'Adjuntardocs'.
	 * 
	 * @param thcodocumento
	 *            String
	 * @param thidExpediente
	 *            String
	 * @param thidTramite
	 *            String
	 * @param thnofile
	 *            String
	 * @param thdatafile
	 *            Blob
	 * @param thsizefile
	 *            Integer
	 * @param thtedesfile
	 *            String
	 * @param thorigen
	 *            String
	 * @param thnumregistroorigen
	 *            String
	 * @param thfecharegistroorigen
	 *            Date
	 * @param thtramite
	 *            String
	 * @param thfecha
	 *            Date
	 * @param thindmail
	 *            String
	 * @param thtrmail
	 *            String
	 * @param thcontenttypefile
	 *            String
	 * @param thiddocumentum
	 *            String
	 * @param thfechaaportacion
	 *            Date
	 * @param thfechaentrada
	 *            Date
	 * @param thnumregistroentrada
	 *            String
	 * @param thestadodocumento
	 *            String
	 * @param thfechasolfirma
	 *            Date
	 * @param thfechalimfirma
	 *            Date
	 * @param thfechafirma
	 *            Date
	 * @param thcomofirma
	 *            String
	 * @param thdestino
	 *            String
	 * @param thfechasollocalizador
	 *            Date
	 * @param ptcodigo
	 *            String
	 * @param tipoProcedimiento
	 *            TipoProcedimiento
	 * @param perfil
	 *            Perfil
	 * @param tipoDocumento
	 *            TipoDocumento
	 * @param trpcodigo
	 *            String
	 * @param idInterviniente
	 *            String
	 * @param thhashfile
	 *            String
	 */
	public Adjuntardocs(String thcodocumento, String thidExpediente, String thidTramite, String thnofile,
			Blob thdatafile, Integer thsizefile, String thtedesfile, String thorigen, String thnumregistroorigen,
			Date thfecharegistroorigen, String thtramite, Date thfecha, String thindmail, String thtrmail,
			String thcontenttypefile, String thiddocumentum, Date thfechaaportacion, Date thfechaentrada,
			String thnumregistroentrada, String thestadodocumento, Date thfechasolfirma, Date thfechalimfirma,
			Date thfechafirma, String thcomofirma, String thdestino, Date thfechasollocalizador, String ptcodigo,
			TipoProcedimiento tipoProcedimiento, Perfil perfil, TipoDocumento tipoDocumento, String trpcodigo,
			String idInterviniente, String thhashfile) {

		this.thcodocumento = thcodocumento;
		this.tipoProcedimiento = tipoProcedimiento;
		this.perfil = perfil;
		this.tipoDocumento = tipoDocumento;
		this.thidExpediente = thidExpediente;
		this.thidTramite = thidTramite;
		this.thnofile = thnofile;
		this.thdatafile = thdatafile;
		this.thsizefile = thsizefile;
		this.thtedesfile = thtedesfile;
		this.thorigen = thorigen;
		this.thnumregistroorigen = thnumregistroorigen;
		this.thfecharegistroorigen = thfecharegistroorigen;
		this.thtramite = thtramite;
		this.thfecha = thfecha;
		this.thindmail = thindmail;
		this.thtrmail = thtrmail;
		this.thcontenttypefile = thcontenttypefile;
		this.thiddocumentum = thiddocumentum;
		this.thfechaaportacion = thfechaaportacion;
		this.thfechaentrada = thfechaentrada;
		this.thnumregistroentrada = thnumregistroentrada;
		this.thestadodocumento = thestadodocumento;
		this.thfechasolfirma = thfechasolfirma;
		this.thfechalimfirma = thfechalimfirma;
		this.thfechafirma = thfechafirma;
		this.thcomofirma = thcomofirma;
		this.thdestino = thdestino;
		this.thfechasollocalizador = thfechasollocalizador;
		this.ptcodigo = ptcodigo;
		this.trpcodigo = trpcodigo;
		this.idInterviniente = idInterviniente;
		this.thhashfile = thhashfile;
	}

	/**
	 * Method 'getThcodocumento'.
	 * 
	 * @return String
	 */

	public String getThcodocumento() {
		return this.thcodocumento;
	}

	/**
	 * Method 'setThcodocumento'.
	 * 
	 * @param thcodocumento
	 *            String
	 * @return
	 */

	public void setThcodocumento(String thcodocumento) {
		this.thcodocumento = thcodocumento;
	}

	/**
	 * Method 'getTipoProcedimiento'.
	 * 
	 * @return TipoProcedimiento
	 */
	@JsonIgnore
	public TipoProcedimiento getTipoProcedimiento() {
		return this.tipoProcedimiento;
	}

	/**
	 * Method 'setTipoProcedimiento'.
	 * 
	 * @param tipoProcedimiento
	 *            TipoProcedimiento
	 * @return
	 */

	public void setTipoProcedimiento(TipoProcedimiento tipoProcedimiento) {
		this.tipoProcedimiento = tipoProcedimiento;
	}

	/**
	 * Method 'getPerfil'.
	 * 
	 * @return Perfil
	 */
	public Perfil getPerfil() {
		return this.perfil;
	}

	/**
	 * Method 'setPerfil'.
	 * 
	 * @param perfil
	 *            Perfil
	 * @return
	 */

	public void setPerfil(Perfil perfil) {
		this.perfil = perfil;
	}

	/**
	 * Method 'getTipoDocumento'.
	 * 
	 * @return TipoDocumento
	 */
	public TipoDocumento getTipoDocumento() {
		return this.tipoDocumento;
	}

	/**
	 * Method 'setTipoDocumento'.
	 * 
	 * @param tipoDocumento
	 *            TipoDocumento
	 * @return
	 */

	public void setTipoDocumento(TipoDocumento tipoDocumento) {
		this.tipoDocumento = tipoDocumento;
	}

	/**
	 * Method 'getThidExpediente'.
	 * 
	 * @return String
	 */

	public String getThidExpediente() {
		return this.thidExpediente;
	}

	/**
	 * Method 'setThidExpediente'.
	 * 
	 * @param thidExpediente
	 *            String
	 * @return
	 */

	public void setThidExpediente(String thidExpediente) {
		this.thidExpediente = thidExpediente;
	}

	/**
	 * Method 'getThidTramite'.
	 * 
	 * @return String
	 */

	public String getThidTramite() {
		return this.thidTramite;
	}

	/**
	 * Method 'setThidTramite'.
	 * 
	 * @param thidTramite
	 *            String
	 * @return
	 */

	public void setThidTramite(String thidTramite) {
		this.thidTramite = thidTramite;
	}

	/**
	 * Method 'getThnofile'.
	 * 
	 * @return String
	 */

	public String getThnofile() {
		return this.thnofile;
	}

	/**
	 * Method 'setThnofile'.
	 * 
	 * @param thnofile
	 *            String
	 * @return
	 */

	public void setThnofile(String thnofile) {
		this.thnofile = thnofile;
	}

	/**
	 * Method 'getThdatafile'.
	 * 
	 * @return Blob
	 */
	@JsonIgnore
	public Blob getThdatafile() {
		return this.thdatafile;
	}

	/**
	 * Method 'setThdatafile'.
	 * 
	 * @param thdatafile
	 *            Blob
	 * @return
	 */

	public void setThdatafile(Blob thdatafile) {
		this.thdatafile = thdatafile;
	}

	/**
	 * Method 'getThdatafileinputstream'.
	 * 
	 * @return InputStream
	 */
	@JsonIgnore
	public InputStream getThdatafileinputstream() {
		return this.thdatafileinputstream;
	}

	/**
	 * Method 'setThdatafileinputstream'.
	 * 
	 * @param thdatafileinputstream
	 *            InputStream
	 * @return
	 */

	public void setThdatafileinputstream(InputStream thdatafileinputstream) {
		this.thdatafileinputstream = thdatafileinputstream;
	}

	/**
	 * Method 'getThsizefile'.
	 * 
	 * @return Integer
	 */

	public Integer getThsizefile() {
		return this.thsizefile;
	}

	/**
	 * Method 'setThsizefile'.
	 * 
	 * @param thsizefile
	 *            Integer
	 * @return
	 */

	public void setThsizefile(Integer thsizefile) {
		this.thsizefile = thsizefile;
	}

	/**
	 * Method 'getThtedesfile'.
	 * 
	 * @return String
	 */

	public String getThtedesfile() {
		return this.thtedesfile;
	}

	/**
	 * Method 'setThtedesfile'.
	 * 
	 * @param thtedesfile
	 *            String
	 * @return
	 */

	public void setThtedesfile(String thtedesfile) {
		this.thtedesfile = thtedesfile;
	}

	/**
	 * Method 'getThorigen'.
	 * 
	 * @return String
	 */

	public String getThorigen() {
		return this.thorigen;
	}

	/**
	 * Method 'setThorigen'.
	 * 
	 * @param thorigen
	 *            String
	 * @return
	 */

	public void setThorigen(String thorigen) {
		this.thorigen = thorigen;
	}

	/**
	 * Method 'getThtramite'.
	 * 
	 * @return String
	 */

	public String getThtramite() {
		return this.thtramite;
	}

	/**
	 * Method 'setThtramite'.
	 * 
	 * @param thtramite
	 *            String
	 * @return
	 */

	public void setThtramite(String thtramite) {
		this.thtramite = thtramite;
	}

	/**
	 * Method 'getThfecha'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getThfecha() {
		return this.thfecha;
	}

	/**
	 * Method 'setThfecha'.
	 * 
	 * @param thfecha
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setThfecha(Date thfecha) {
		this.thfecha = thfecha;
	}

	/**
	 * Method 'getThindmail'.
	 * 
	 * @return String
	 */

	public String getThindmail() {
		return this.thindmail;
	}

	/**
	 * Method 'setThindmail'.
	 * 
	 * @param thindmail
	 *            String
	 * @return
	 */

	public void setThindmail(String thindmail) {
		this.thindmail = thindmail;
	}

	/**
	 * Method 'getThtrmail'.
	 * 
	 * @return String
	 */

	public String getThtrmail() {
		return this.thtrmail;
	}

	/**
	 * Method 'setThtrmail'.
	 * 
	 * @param thtrmail
	 *            String
	 * @return
	 */

	public void setThtrmail(String thtrmail) {
		this.thtrmail = thtrmail;
	}

	/**
	 * Method 'getThcontenttypefile'.
	 * 
	 * @return String
	 */

	public String getThcontenttypefile() {
		return this.thcontenttypefile;
	}

	/**
	 * Method 'setThcontenttypefile'.
	 * 
	 * @param thcontenttypefile
	 *            String
	 * @return
	 */

	public void setThcontenttypefile(String thcontenttypefile) {
		this.thcontenttypefile = thcontenttypefile;
	}

	/**
	 * Method 'getThiddocumentum'.
	 * 
	 * @return String
	 */

	public String getThiddocumentum() {
		return this.thiddocumentum;
	}

	/**
	 * Method 'setThiddocumentum'.
	 * 
	 * @param thiddocumentum
	 *            String
	 * @return
	 */

	public void setThiddocumentum(String thiddocumentum) {
		this.thiddocumentum = thiddocumentum;
	}

	/**
	 * Method 'getThfechaaportacion'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getThfechaaportacion() {
		return this.thfechaaportacion;
	}

	/**
	 * Method 'setThfechaaportacion'.
	 * 
	 * @param thfechaaportacion
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setThfechaaportacion(Date thfechaaportacion) {
		this.thfechaaportacion = thfechaaportacion;
	}

	/**
	 * Method 'getThfechaentrada'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getThfechaentrada() {
		return this.thfechaentrada;
	}

	/**
	 * Method 'setThfechaentrada'.
	 * 
	 * @param thfechaentrada
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setThfechaentrada(Date thfechaentrada) {
		this.thfechaentrada = thfechaentrada;
	}

	/**
	 * Method 'getThnumregistroentrada'.
	 * 
	 * @return String
	 */

	public String getThnumregistroentrada() {
		return this.thnumregistroentrada;
	}

	/**
	 * Method 'setThnumregistroentrada'.
	 * 
	 * @param thnumregistroentrada
	 *            String
	 * @return
	 */

	public void setThnumregistroentrada(String thnumregistroentrada) {
		this.thnumregistroentrada = thnumregistroentrada;
	}

	/**
	 * Method 'getThestadodocumento'.
	 * 
	 * @return String
	 */

	public String getThestadodocumento() {
		return this.thestadodocumento;
	}

	/**
	 * Method 'setThestadodocumento'.
	 * 
	 * @param thestadodocumento
	 *            String
	 * @return
	 */

	public void setThestadodocumento(String thestadodocumento) {
		this.thestadodocumento = thestadodocumento;
	}

	/**
	 * Method 'getThfechasolfirma'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getThfechasolfirma() {
		return this.thfechasolfirma;
	}

	/**
	 * Method 'setThfechasolfirma'.
	 * 
	 * @param thfechasolfirma
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setThfechasolfirma(Date thfechasolfirma) {
		this.thfechasolfirma = thfechasolfirma;
	}

	/**
	 * Method 'getThfechalimfirma'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getThfechalimfirma() {
		return this.thfechalimfirma;
	}

	/**
	 * Method 'setThfechalimfirma'.
	 * 
	 * @param thfechalimfirma
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setThfechalimfirma(Date thfechalimfirma) {
		this.thfechalimfirma = thfechalimfirma;
	}

	/**
	 * Method 'getThfechafirma'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getThfechafirma() {
		return this.thfechafirma;
	}

	/**
	 * Method 'setThfechafirma'.
	 * 
	 * @param thfechafirma
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setThfechafirma(Date thfechafirma) {
		this.thfechafirma = thfechafirma;
	}

	/**
	 * Method 'getThcomofirma'.
	 * 
	 * @return String
	 */

	public String getThcomofirma() {
		return this.thcomofirma;
	}

	/**
	 * Method 'setThcomofirma'.
	 * 
	 * @param thcomofirma
	 *            String
	 * @return
	 */

	public void setThcomofirma(String thcomofirma) {
		this.thcomofirma = thcomofirma;
	}

	/**
	 * @return the thdestino
	 */
	public String getThdestino() {
		return thdestino;
	}

	/**
	 * @param thdestino
	 *            the thdestino to set
	 */
	public void setThdestino(String thdestino) {
		this.thdestino = thdestino;
	}

	/**
	 * @return the ptcodigo
	 */
	public String getPtcodigo() {
		return ptcodigo;
	}

	/**
	 * @param ptcodigo
	 *            the ptcodigo to set
	 */
	public void setPtcodigo(String ptcodigo) {
		this.ptcodigo = ptcodigo;
	}

	/**
	 * @return the threquierefirma
	 */
	public String getThrequierefirma() {
		return threquierefirma;
	}

	/**
	 * @param threquierefirma
	 *            the threquierefirma to set
	 */
	public void setThrequierefirma(String threquierefirma) {
		this.threquierefirma = threquierefirma;
	}

	/**
	 * @return the pdcodigo
	 */
	public String getPdcodigo() {
		return pdcodigo;
	}

	/**
	 * @param pdcodigo
	 *            the pdcodigo to set
	 */
	public void setPdcodigo(String pdcodigo) {
		this.pdcodigo = pdcodigo;
	}

	/**
	 * @return the thfechasollocalizador
	 */
	@JsonSerialize(using = Y41bJsonDateTimeSerializer.class)
	public Date getThfechasollocalizador() {
		return thfechasollocalizador;
	}

	/**
	 * @param thfechasollocalizador
	 *            the thfechasollocalizador to set
	 */
	@JsonDeserialize(using = Y41bJsonDateTimeDeserializer.class)
	public void setThfechasollocalizador(Date thfechasollocalizador) {
		this.thfechasollocalizador = thfechasollocalizador;
	}

	/**
	 * @return the thfecharegistroorigen
	 */
	@JsonSerialize(using = Y41bJsonDateTimeSerializer.class)
	public Date getThfecharegistroorigen() {
		return thfecharegistroorigen;
	}

	/**
	 * @param thfecharegistroorigen
	 *            the thfecharegistroorigen to set
	 */
	@JsonDeserialize(using = Y41bJsonDateTimeDeserializer.class)
	public void setThfecharegistroorigen(Date thfecharegistroorigen) {
		this.thfecharegistroorigen = thfecharegistroorigen;
	}

	/**
	 * @return the thnumregistroorigen
	 */
	public String getThnumregistroorigen() {
		return thnumregistroorigen;
	}

	/**
	 * @param thnumregistroorigen
	 *            the thnumregistroorigen to set
	 */
	public void setThnumregistroorigen(String thnumregistroorigen) {
		this.thnumregistroorigen = thnumregistroorigen;
	}

	/**
	 * @return the idInterviniente
	 */
	public String getIdInterviniente() {
		return idInterviniente;
	}

	/**
	 * @param idInterviniente
	 *            the idInterviniente to set
	 */
	public void setIdInterviniente(String idInterviniente) {
		this.idInterviniente = idInterviniente;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "Adjuntardocs [thcodocumento=" + thcodocumento + ", tipoProcedimiento=" + tipoProcedimiento + ", perfil="
				+ perfil + ", tipoDocumento=" + tipoDocumento + ", thidExpediente=" + thidExpediente + ", thidTramite="
				+ thidTramite + ", thnofile=" + thnofile + ", thdatafile=" + thdatafile + ", thsizefile=" + thsizefile
				+ ", thtedesfile=" + thtedesfile + ", thorigen=" + thorigen + ", thtramite=" + thtramite + ", thfecha="
				+ thfecha + ", thindmail=" + thindmail + ", thtrmail=" + thtrmail + ", thcontenttypefile="
				+ thcontenttypefile + ", thiddocumentum=" + thiddocumentum + ", thfechaaportacion=" + thfechaaportacion
				+ ", thfechaentrada=" + thfechaentrada + ", thnumregistroentrada=" + thnumregistroentrada
				+ ", thestadodocumento=" + thestadodocumento + ", thfechasolfirma=" + thfechasolfirma
				+ ", thfechalimfirma=" + thfechalimfirma + ", thfechafirma=" + thfechafirma + ", thcomofirma="
				+ thcomofirma + ", thdestino=" + thdestino + "]";
	}

	/**
	 * @return the thidtipodoc
	 */
	public String getThidtipodoc() {
		return thidtipodoc;
	}

	/**
	 * @param thidtipodoc
	 *            the thidtipodoc to set
	 */
	public void setThidtipodoc(String thidtipodoc) {
		this.thidtipodoc = thidtipodoc;
	}

	/**
	 * @return the thnumExpediente
	 */
	public String getThnumExpediente() {
		return thnumExpediente;
	}

	/**
	 * @param thnumExpediente
	 *            the thnumExpediente to set
	 */
	public void setThnumExpediente(String thnumExpediente) {
		this.thnumExpediente = thnumExpediente;
	}

	/**
	 * @return the trpcodigo
	 */
	public String getTrpcodigo() {
		return trpcodigo;
	}

	/**
	 * @param trpcodigo
	 *            the trpcodigo to set
	 */
	public void setTrpcodigo(String trpcodigo) {
		this.trpcodigo = trpcodigo;
	}

	/**
	 * @return the thhashfile
	 */
	public String getThhashfile() {
		return thhashfile;
	}

	/**
	 * @param thhashfile
	 *            the thhashfile to set
	 */
	public void setThhashfile(String thhashfile) {
		this.thhashfile = thhashfile;
	}

	/**
	 * @return the firma
	 */
	public String getFirma() {
		return firma;
	}

	/**
	 * @param firma
	 *            the firma to set
	 */
	public void setFirma(String firma) {
		this.firma = firma;
	}

	/**
	 * @return the rutaPif
	 */
	public String getRutaPif() {
		return rutaPif;
	}

	/**
	 * @param rutaPif
	 *            the rutaPif to set
	 */
	public void setRutaPif(String rutaPif) {
		this.rutaPif = rutaPif;
	}

	/**
	 * @return the rutaPifFileFirma
	 */
	public String getRutaPifFileFirma() {
		return rutaPifFileFirma;
	}

	/**
	 * @param rutaPifFileFirma
	 *            the rutaPifFileFirma to set
	 */
	public void setRutaPifFileFirma(String rutaPifFileFirma) {
		this.rutaPifFileFirma = rutaPifFileFirma;
	}

}
