package com.ejie.y41b.model;

import java.math.BigDecimal;
import java.util.Date;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hibernate.validator.constraints.NotEmpty;

import com.ejie.y41b.control.Y41bJsonDateDeserializer;
import com.ejie.y41b.control.Y41bJsonDateSerializer;

/**
 * * ActuacionDetalle  
 * 
 *  
 */

public class ActuacionDetalle implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	// Campaña
	private String tipo;
	private String codigo;
	private String descripcion;

	// Visita
	private String accodigo;

	// Actuacion
	private String atcodigo;
	private BigDecimal atnror;
	private String atcotp;
	private String atteinfo;

	// Tipo de actuacion
	@NotEmpty(message = "required.tipoactuacion")
	private String ttacodigo;
	private String ttanombre;

	// Motivo de actuacion
	@NotEmpty(message = "required.motivoactuacion")
	private String tmacodigo;
	private String tmanombre;

	// Establecimiento Actuacion
	@NotEmpty(message = "required.estresponsable")
	private String escodigoActuacion;
	private String esnombreActuacion;
	private String esnifActuacion;
	private String esnocoActuacion;
	private String esnodirActuacion;
	private String escoloActuacion;
	private String esnrcopoActuacion;
	private String esnrtelActuacion;
	private String esnrfaxActuacion;
	private String escopaActuacion;
	private String esinadarActuacion;
	private Date esfeadarActuacion;
	private String escoemActuacion;
	private String esnrtel2Actuacion;
	private Date esfebaActuacion;
	private String esnoloActuacion;
	private String escomapvActuacion;
	private String escocaActuacion;
	private String esnomuActuacion;
	private String esteurlActuacion;
	private String esnoraPaisIdActuacion;
	private String esnoraPaisNombreActuacion;
	private String provinciaIdActuacion;
	private String esnombreProvinciaActuacion;
	private String municipioIdActuacion;
	private String esnombreMunicipioActuacion;
	private String localidadIdActuacion;
	private String esnombreLocalidadActuacion;
	private String calleIdActuacion;
	private String calleId_labelActuacion;
	private String cpIdActuacion;
	private String esnombreCpActuacion;
	private String portalIdActuacion;
	private String esnombrePortalActuacion;
	private String esnombrePisoActuacion;
	private String esdireccion_nocapvActuacion;
	private String eacodigoActuacion;
	private String avcodigoActuacion;
	private String avnombreActuacion;
	private String avnombreeActuacion;
	private String secodigoActuacion;
	private String senombreActuacion;
	private String senombreeActuacion;
	private String eainprseActuacion;
	private String direccionAntiguaCompletaActuacion;

	// Producto Actuacion
	@NotEmpty(message = "required.productoactuacion")
	private String pscodigoActuacion;
	private String psnombreActuacion;
	private String psnombreeActuacion;
	private String atnoprse;
	private String atnomaps;
	private String atnomops;
	private String atnrlops;
	private Date atfedumi;

	// CampahnaRecib
	private String s4codigo;
	// AlertaRecib
	private String s5codigo;
	// DenunciaRecib
	private String s6codigo;

	// Producto encontrado
	private String atinprse;
	private BigDecimal atcaunep;

	/**
	 * 
	 */
	public ActuacionDetalle() {

	}

	/**
	 * @param tipo
	 * @param codigo
	 * @param descripcion
	 * @param accodigo
	 * @param atcodigo
	 * @param atnror
	 * @param atcotp
	 * @param atteinfo
	 * @param ttacodigo
	 * @param ttanombre
	 * @param tmacodigo
	 * @param tmanombre
	 * @param escodigoActuacion
	 * @param esnombreActuacion
	 * @param esnifActuacion
	 * @param esnocoActuacion
	 * @param esnodirActuacion
	 * @param escoloActuacion
	 * @param esnrcopoActuacion
	 * @param esnrtelActuacion
	 * @param esnrfaxActuacion
	 * @param escopaActuacion
	 * @param esinadarActuacion
	 * @param esfeadarActuacion
	 * @param escoemActuacion
	 * @param esnrtel2Actuacion
	 * @param esfebaActuacion
	 * @param esnoloActuacion
	 * @param escomapvActuacion
	 * @param escocaActuacion
	 * @param esnomuActuacion
	 * @param esteurlActuacion
	 * @param esnoraPaisIdActuacion
	 * @param esnoraPaisNombreActuacion
	 * @param provinciaIdActuacion
	 * @param esnombreProvinciaActuacion
	 * @param municipioIdActuacion
	 * @param esnombreMunicipioActuacion
	 * @param localidadIdActuacion
	 * @param esnombreLocalidadActuacion
	 * @param calleIdActuacion
	 * @param calleId_labelActuacion
	 * @param cpIdActuacion
	 * @param esnombreCpActuacion
	 * @param portalIdActuacion
	 * @param esnombrePortalActuacion
	 * @param esnombrePisoActuacion
	 * @param esdireccion_nocapvActuacion
	 * @param eacodigoActuacion
	 * @param avcodigoActuacion
	 * @param avnombreActuacion
	 * @param avnombreeActuacion
	 * @param secodigoActuacion
	 * @param senombreActuacion
	 * @param senombreeActuacion
	 * @param eainprseActuacion
	 * @param direccionAntiguaCompletaActuacion
	 * @param pscodigoActuacion
	 * @param psnombreActuacion
	 * @param psnombreeActuacion
	 * @param atnoprse
	 * @param atnomaps
	 * @param atnomops
	 * @param atnrlops
	 * @param atfedumi
	 * @param s4codigo
	 * @param s5codigo
	 * @param s6codigo
	 * @param atinprse
	 * @param atcaunep
	 */
	public ActuacionDetalle(String tipo, String codigo, String descripcion,
			String accodigo, String atcodigo, BigDecimal atnror, String atcotp,
			String atteinfo, String ttacodigo, String ttanombre,
			String tmacodigo, String tmanombre, String escodigoActuacion,
			String esnombreActuacion, String esnifActuacion,
			String esnocoActuacion, String esnodirActuacion,
			String escoloActuacion, String esnrcopoActuacion,
			String esnrtelActuacion, String esnrfaxActuacion,
			String escopaActuacion, String esinadarActuacion,
			Date esfeadarActuacion, String escoemActuacion,
			String esnrtel2Actuacion, Date esfebaActuacion,
			String esnoloActuacion, String escomapvActuacion,
			String escocaActuacion, String esnomuActuacion,
			String esteurlActuacion, String esnoraPaisIdActuacion,
			String esnoraPaisNombreActuacion, String provinciaIdActuacion,
			String esnombreProvinciaActuacion, String municipioIdActuacion,
			String esnombreMunicipioActuacion, String localidadIdActuacion,
			String esnombreLocalidadActuacion, String calleIdActuacion,
			String calleId_labelActuacion, String cpIdActuacion,
			String esnombreCpActuacion, String portalIdActuacion,
			String esnombrePortalActuacion, String esnombrePisoActuacion,
			String esdireccion_nocapvActuacion, String eacodigoActuacion,
			String avcodigoActuacion, String avnombreActuacion,
			String avnombreeActuacion, String secodigoActuacion,
			String senombreActuacion, String senombreeActuacion,
			String eainprseActuacion, String direccionAntiguaCompletaActuacion,
			String pscodigoActuacion, String psnombreActuacion,
			String psnombreeActuacion, String atnoprse, String atnomaps,
			String atnomops, String atnrlops, Date atfedumi, String s4codigo,
			String s5codigo, String s6codigo, String atinprse,
			BigDecimal atcaunep) {
		this.tipo = tipo;
		this.codigo = codigo;
		this.descripcion = descripcion;
		this.accodigo = accodigo;
		this.atcodigo = atcodigo;
		this.atnror = atnror;
		this.atcotp = atcotp;
		this.atteinfo = atteinfo;
		this.ttacodigo = ttacodigo;
		this.ttanombre = ttanombre;
		this.tmacodigo = tmacodigo;
		this.tmanombre = tmanombre;
		this.escodigoActuacion = escodigoActuacion;
		this.esnombreActuacion = esnombreActuacion;
		this.esnifActuacion = esnifActuacion;
		this.esnocoActuacion = esnocoActuacion;
		this.esnodirActuacion = esnodirActuacion;
		this.escoloActuacion = escoloActuacion;
		this.esnrcopoActuacion = esnrcopoActuacion;
		this.esnrtelActuacion = esnrtelActuacion;
		this.esnrfaxActuacion = esnrfaxActuacion;
		this.escopaActuacion = escopaActuacion;
		this.esinadarActuacion = esinadarActuacion;
		this.esfeadarActuacion = esfeadarActuacion;
		this.escoemActuacion = escoemActuacion;
		this.esnrtel2Actuacion = esnrtel2Actuacion;
		this.esfebaActuacion = esfebaActuacion;
		this.esnoloActuacion = esnoloActuacion;
		this.escomapvActuacion = escomapvActuacion;
		this.escocaActuacion = escocaActuacion;
		this.esnomuActuacion = esnomuActuacion;
		this.esteurlActuacion = esteurlActuacion;
		this.esnoraPaisIdActuacion = esnoraPaisIdActuacion;
		this.esnoraPaisNombreActuacion = esnoraPaisNombreActuacion;
		this.provinciaIdActuacion = provinciaIdActuacion;
		this.esnombreProvinciaActuacion = esnombreProvinciaActuacion;
		this.municipioIdActuacion = municipioIdActuacion;
		this.esnombreMunicipioActuacion = esnombreMunicipioActuacion;
		this.localidadIdActuacion = localidadIdActuacion;
		this.esnombreLocalidadActuacion = esnombreLocalidadActuacion;
		this.calleIdActuacion = calleIdActuacion;
		this.calleId_labelActuacion = calleId_labelActuacion;
		this.cpIdActuacion = cpIdActuacion;
		this.esnombreCpActuacion = esnombreCpActuacion;
		this.portalIdActuacion = portalIdActuacion;
		this.esnombrePortalActuacion = esnombrePortalActuacion;
		this.esnombrePisoActuacion = esnombrePisoActuacion;
		this.esdireccion_nocapvActuacion = esdireccion_nocapvActuacion;
		this.eacodigoActuacion = eacodigoActuacion;
		this.avcodigoActuacion = avcodigoActuacion;
		this.avnombreActuacion = avnombreActuacion;
		this.avnombreeActuacion = avnombreeActuacion;
		this.secodigoActuacion = secodigoActuacion;
		this.senombreActuacion = senombreActuacion;
		this.senombreeActuacion = senombreeActuacion;
		this.eainprseActuacion = eainprseActuacion;
		this.direccionAntiguaCompletaActuacion = direccionAntiguaCompletaActuacion;
		this.pscodigoActuacion = pscodigoActuacion;
		this.psnombreActuacion = psnombreActuacion;
		this.psnombreeActuacion = psnombreeActuacion;
		this.atnoprse = atnoprse;
		this.atnomaps = atnomaps;
		this.atnomops = atnomops;
		this.atnrlops = atnrlops;
		this.atfedumi = atfedumi;
		this.s4codigo = s4codigo;
		this.s5codigo = s5codigo;
		this.s6codigo = s6codigo;
		this.atinprse = atinprse;
		this.atcaunep = atcaunep;
	}

	/**
	 * @return the tipo
	 */
	public String getTipo() {
		return tipo;
	}

	/**
	 * @param tipo
	 *            the tipo to set
	 */
	public void setTipo(String tipo) {
		this.tipo = tipo;
	}

	/**
	 * @return the codigo
	 */
	public String getCodigo() {
		return codigo;
	}

	/**
	 * @param codigo
	 *            the codigo to set
	 */
	public void setCodigo(String codigo) {
		this.codigo = codigo;
	}

	/**
	 * @return the descripcion
	 */
	public String getDescripcion() {
		return descripcion;
	}

	/**
	 * @param descripcion
	 *            the descripcion to set
	 */
	public void setDescripcion(String descripcion) {
		this.descripcion = descripcion;
	}

	/**
	 * @return the accodigo
	 */
	public String getAccodigo() {
		return accodigo;
	}

	/**
	 * @param accodigo
	 *            the accodigo to set
	 */
	public void setAccodigo(String accodigo) {
		this.accodigo = accodigo;
	}

	/**
	 * @return the atcodigo
	 */
	public String getAtcodigo() {
		return atcodigo;
	}

	/**
	 * @param atcodigo
	 *            the atcodigo to set
	 */
	public void setAtcodigo(String atcodigo) {
		this.atcodigo = atcodigo;
	}

	/**
	 * @return the atnror
	 */
	public BigDecimal getAtnror() {
		return atnror;
	}

	/**
	 * @param atnror
	 *            the atnror to set
	 */
	public void setAtnror(BigDecimal atnror) {
		this.atnror = atnror;
	}

	/**
	 * @return the ttacodigo
	 */
	public String getTtacodigo() {
		return ttacodigo;
	}

	/**
	 * @param ttacodigo
	 *            the ttacodigo to set
	 */
	public void setTtacodigo(String ttacodigo) {
		this.ttacodigo = ttacodigo;
	}

	/**
	 * @return the ttanombre
	 */
	public String getTtanombre() {
		return ttanombre;
	}

	/**
	 * @param ttanombre
	 *            the ttanombre to set
	 */
	public void setTtanombre(String ttanombre) {
		this.ttanombre = ttanombre;
	}

	/**
	 * @return the tmacodigo
	 */
	public String getTmacodigo() {
		return tmacodigo;
	}

	/**
	 * @param tmacodigo
	 *            the tmacodigo to set
	 */
	public void setTmacodigo(String tmacodigo) {
		this.tmacodigo = tmacodigo;
	}

	/**
	 * @return the tmanombre
	 */
	public String getTmanombre() {
		return tmanombre;
	}

	/**
	 * @param tmanombre
	 *            the tmanombre to set
	 */
	public void setTmanombre(String tmanombre) {
		this.tmanombre = tmanombre;
	}

	/**
	 * @return the escodigoActuacion
	 */
	public String getEscodigoActuacion() {
		return escodigoActuacion;
	}

	/**
	 * @param escodigoActuacion
	 *            the escodigoActuacion to set
	 */
	public void setEscodigoActuacion(String escodigoActuacion) {
		this.escodigoActuacion = escodigoActuacion;
	}

	/**
	 * @return the esnombreActuacion
	 */
	public String getEsnombreActuacion() {
		return esnombreActuacion;
	}

	/**
	 * @param esnombreActuacion
	 *            the esnombreActuacion to set
	 */
	public void setEsnombreActuacion(String esnombreActuacion) {
		this.esnombreActuacion = esnombreActuacion;
	}

	/**
	 * @return the esnifActuacion
	 */
	public String getEsnifActuacion() {
		return esnifActuacion;
	}

	/**
	 * @param esnifActuacion
	 *            the esnifActuacion to set
	 */
	public void setEsnifActuacion(String esnifActuacion) {
		this.esnifActuacion = esnifActuacion;
	}

	/**
	 * @return the esnocoActuacion
	 */
	public String getEsnocoActuacion() {
		return esnocoActuacion;
	}

	/**
	 * @param esnocoActuacion
	 *            the esnocoActuacion to set
	 */
	public void setEsnocoActuacion(String esnocoActuacion) {
		this.esnocoActuacion = esnocoActuacion;
	}

	/**
	 * @return the esnodirActuacion
	 */
	public String getEsnodirActuacion() {
		return esnodirActuacion;
	}

	/**
	 * @param esnodirActuacion
	 *            the esnodirActuacion to set
	 */
	public void setEsnodirActuacion(String esnodirActuacion) {
		this.esnodirActuacion = esnodirActuacion;
	}

	/**
	 * @return the escoloActuacion
	 */
	public String getEscoloActuacion() {
		return escoloActuacion;
	}

	/**
	 * @param escoloActuacion
	 *            the escoloActuacion to set
	 */
	public void setEscoloActuacion(String escoloActuacion) {
		this.escoloActuacion = escoloActuacion;
	}

	/**
	 * @return the esnrcopoActuacion
	 */
	public String getEsnrcopoActuacion() {
		return esnrcopoActuacion;
	}

	/**
	 * @param esnrcopoActuacion
	 *            the esnrcopoActuacion to set
	 */
	public void setEsnrcopoActuacion(String esnrcopoActuacion) {
		this.esnrcopoActuacion = esnrcopoActuacion;
	}

	/**
	 * @return the esnrtelActuacion
	 */
	public String getEsnrtelActuacion() {
		return esnrtelActuacion;
	}

	/**
	 * @param esnrtelActuacion
	 *            the esnrtelActuacion to set
	 */
	public void setEsnrtelActuacion(String esnrtelActuacion) {
		this.esnrtelActuacion = esnrtelActuacion;
	}

	/**
	 * @return the esnrfaxActuacion
	 */
	public String getEsnrfaxActuacion() {
		return esnrfaxActuacion;
	}

	/**
	 * @param esnrfaxActuacion
	 *            the esnrfaxActuacion to set
	 */
	public void setEsnrfaxActuacion(String esnrfaxActuacion) {
		this.esnrfaxActuacion = esnrfaxActuacion;
	}

	/**
	 * @return the escopaActuacion
	 */
	public String getEscopaActuacion() {
		return escopaActuacion;
	}

	/**
	 * @param escopaActuacion
	 *            the escopaActuacion to set
	 */
	public void setEscopaActuacion(String escopaActuacion) {
		this.escopaActuacion = escopaActuacion;
	}

	/**
	 * @return the esinadarActuacion
	 */
	public String getEsinadarActuacion() {
		return esinadarActuacion;
	}

	/**
	 * @param esinadarActuacion
	 *            the esinadarActuacion to set
	 */
	public void setEsinadarActuacion(String esinadarActuacion) {
		this.esinadarActuacion = esinadarActuacion;
	}

	/**
	 * @return the esfeadarActuacion
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getEsfeadarActuacion() {
		return esfeadarActuacion;
	}

	/**
	 * @param esfeadarActuacion
	 *            the esfeadarActuacion to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setEsfeadarActuacion(Date esfeadarActuacion) {
		this.esfeadarActuacion = esfeadarActuacion;
	}

	/**
	 * @return the escoemActuacion
	 */
	public String getEscoemActuacion() {
		return escoemActuacion;
	}

	/**
	 * @param escoemActuacion
	 *            the escoemActuacion to set
	 */
	public void setEscoemActuacion(String escoemActuacion) {
		this.escoemActuacion = escoemActuacion;
	}

	/**
	 * @return the esnrtel2Actuacion
	 */
	public String getEsnrtel2Actuacion() {
		return esnrtel2Actuacion;
	}

	/**
	 * @param esnrtel2Actuacion
	 *            the esnrtel2Actuacion to set
	 */
	public void setEsnrtel2Actuacion(String esnrtel2Actuacion) {
		this.esnrtel2Actuacion = esnrtel2Actuacion;
	}

	/**
	 * @return the esfebaActuacion
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getEsfebaActuacion() {
		return esfebaActuacion;
	}

	/**
	 * @param esfebaActuacion
	 *            the esfebaActuacion to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setEsfebaActuacion(Date esfebaActuacion) {
		this.esfebaActuacion = esfebaActuacion;
	}

	/**
	 * @return the esnoloActuacion
	 */
	public String getEsnoloActuacion() {
		return esnoloActuacion;
	}

	/**
	 * @param esnoloActuacion
	 *            the esnoloActuacion to set
	 */
	public void setEsnoloActuacion(String esnoloActuacion) {
		this.esnoloActuacion = esnoloActuacion;
	}

	/**
	 * @return the escomapvActuacion
	 */
	public String getEscomapvActuacion() {
		return escomapvActuacion;
	}

	/**
	 * @param escomapvActuacion
	 *            the escomapvActuacion to set
	 */
	public void setEscomapvActuacion(String escomapvActuacion) {
		this.escomapvActuacion = escomapvActuacion;
	}

	/**
	 * @return the escocaActuacion
	 */
	public String getEscocaActuacion() {
		return escocaActuacion;
	}

	/**
	 * @param escocaActuacion
	 *            the escocaActuacion to set
	 */
	public void setEscocaActuacion(String escocaActuacion) {
		this.escocaActuacion = escocaActuacion;
	}

	/**
	 * @return the esnomuActuacion
	 */
	public String getEsnomuActuacion() {
		return esnomuActuacion;
	}

	/**
	 * @param esnomuActuacion
	 *            the esnomuActuacion to set
	 */
	public void setEsnomuActuacion(String esnomuActuacion) {
		this.esnomuActuacion = esnomuActuacion;
	}

	/**
	 * @return the esteurlActuacion
	 */
	public String getEsteurlActuacion() {
		return esteurlActuacion;
	}

	/**
	 * @param esteurlActuacion
	 *            the esteurlActuacion to set
	 */
	public void setEsteurlActuacion(String esteurlActuacion) {
		this.esteurlActuacion = esteurlActuacion;
	}

	/**
	 * @return the esnoraPaisIdActuacion
	 */
	public String getEsnoraPaisIdActuacion() {
		return esnoraPaisIdActuacion;
	}

	/**
	 * @param esnoraPaisIdActuacion
	 *            the esnoraPaisIdActuacion to set
	 */
	public void setEsnoraPaisIdActuacion(String esnoraPaisIdActuacion) {
		this.esnoraPaisIdActuacion = esnoraPaisIdActuacion;
	}

	/**
	 * @return the esnoraPaisNombreActuacion
	 */
	public String getEsnoraPaisNombreActuacion() {
		return esnoraPaisNombreActuacion;
	}

	/**
	 * @param esnoraPaisNombreActuacion
	 *            the esnoraPaisNombreActuacion to set
	 */
	public void setEsnoraPaisNombreActuacion(String esnoraPaisNombreActuacion) {
		this.esnoraPaisNombreActuacion = esnoraPaisNombreActuacion;
	}

	/**
	 * @return the provinciaIdActuacion
	 */
	public String getProvinciaIdActuacion() {
		return provinciaIdActuacion;
	}

	/**
	 * @param provinciaIdActuacion
	 *            the provinciaIdActuacion to set
	 */
	public void setProvinciaIdActuacion(String provinciaIdActuacion) {
		this.provinciaIdActuacion = provinciaIdActuacion;
	}

	/**
	 * @return the esnombreProvinciaActuacion
	 */
	public String getEsnombreProvinciaActuacion() {
		return esnombreProvinciaActuacion;
	}

	/**
	 * @param esnombreProvinciaActuacion
	 *            the esnombreProvinciaActuacion to set
	 */
	public void setEsnombreProvinciaActuacion(String esnombreProvinciaActuacion) {
		this.esnombreProvinciaActuacion = esnombreProvinciaActuacion;
	}

	/**
	 * @return the municipioIdActuacion
	 */
	public String getMunicipioIdActuacion() {
		return municipioIdActuacion;
	}

	/**
	 * @param municipioIdActuacion
	 *            the municipioIdActuacion to set
	 */
	public void setMunicipioIdActuacion(String municipioIdActuacion) {
		this.municipioIdActuacion = municipioIdActuacion;
	}

	/**
	 * @return the esnombreMunicipioActuacion
	 */
	public String getEsnombreMunicipioActuacion() {
		return esnombreMunicipioActuacion;
	}

	/**
	 * @param esnombreMunicipioActuacion
	 *            the esnombreMunicipioActuacion to set
	 */
	public void setEsnombreMunicipioActuacion(String esnombreMunicipioActuacion) {
		this.esnombreMunicipioActuacion = esnombreMunicipioActuacion;
	}

	/**
	 * @return the localidadIdActuacion
	 */
	public String getLocalidadIdActuacion() {
		return localidadIdActuacion;
	}

	/**
	 * @param localidadIdActuacion
	 *            the localidadIdActuacion to set
	 */
	public void setLocalidadIdActuacion(String localidadIdActuacion) {
		this.localidadIdActuacion = localidadIdActuacion;
	}

	/**
	 * @return the esnombreLocalidadActuacion
	 */
	public String getEsnombreLocalidadActuacion() {
		return esnombreLocalidadActuacion;
	}

	/**
	 * @param esnombreLocalidadActuacion
	 *            the esnombreLocalidadActuacion to set
	 */
	public void setEsnombreLocalidadActuacion(String esnombreLocalidadActuacion) {
		this.esnombreLocalidadActuacion = esnombreLocalidadActuacion;
	}

	/**
	 * @return the calleIdActuacion
	 */
	public String getCalleIdActuacion() {
		return calleIdActuacion;
	}

	/**
	 * @param calleIdActuacion
	 *            the calleIdActuacion to set
	 */
	public void setCalleIdActuacion(String calleIdActuacion) {
		this.calleIdActuacion = calleIdActuacion;
	}

	/**
	 * @return the calleId_labelActuacion
	 */
	public String getCalleId_labelActuacion() {
		return calleId_labelActuacion;
	}

	/**
	 * @param calleId_labelActuacion
	 *            the calleId_labelActuacion to set
	 */
	public void setCalleId_labelActuacion(String calleId_labelActuacion) {
		this.calleId_labelActuacion = calleId_labelActuacion;
	}

	/**
	 * @return the cpIdActuacion
	 */
	public String getCpIdActuacion() {
		return cpIdActuacion;
	}

	/**
	 * @param cpIdActuacion
	 *            the cpIdActuacion to set
	 */
	public void setCpIdActuacion(String cpIdActuacion) {
		this.cpIdActuacion = cpIdActuacion;
	}

	/**
	 * @return the esnombreCpActuacion
	 */
	public String getEsnombreCpActuacion() {
		return esnombreCpActuacion;
	}

	/**
	 * @param esnombreCpActuacion
	 *            the esnombreCpActuacion to set
	 */
	public void setEsnombreCpActuacion(String esnombreCpActuacion) {
		this.esnombreCpActuacion = esnombreCpActuacion;
	}

	/**
	 * @return the portalIdActuacion
	 */
	public String getPortalIdActuacion() {
		return portalIdActuacion;
	}

	/**
	 * @param portalIdActuacion
	 *            the portalIdActuacion to set
	 */
	public void setPortalIdActuacion(String portalIdActuacion) {
		this.portalIdActuacion = portalIdActuacion;
	}

	/**
	 * @return the esnombrePortalActuacion
	 */
	public String getEsnombrePortalActuacion() {
		return esnombrePortalActuacion;
	}

	/**
	 * @param esnombrePortalActuacion
	 *            the esnombrePortalActuacion to set
	 */
	public void setEsnombrePortalActuacion(String esnombrePortalActuacion) {
		this.esnombrePortalActuacion = esnombrePortalActuacion;
	}

	/**
	 * @return the esnombrePisoActuacion
	 */
	public String getEsnombrePisoActuacion() {
		return esnombrePisoActuacion;
	}

	/**
	 * @param esnombrePisoActuacion
	 *            the esnombrePisoActuacion to set
	 */
	public void setEsnombrePisoActuacion(String esnombrePisoActuacion) {
		this.esnombrePisoActuacion = esnombrePisoActuacion;
	}

	/**
	 * @return the eacodigoActuacion
	 */
	public String getEacodigoActuacion() {
		return eacodigoActuacion;
	}

	/**
	 * @param eacodigoActuacion
	 *            the eacodigoActuacion to set
	 */
	public void setEacodigoActuacion(String eacodigoActuacion) {
		this.eacodigoActuacion = eacodigoActuacion;
	}

	/**
	 * @return the avcodigoActuacion
	 */
	public String getAvcodigoActuacion() {
		return avcodigoActuacion;
	}

	/**
	 * @param avcodigoActuacion
	 *            the avcodigoActuacion to set
	 */
	public void setAvcodigoActuacion(String avcodigoActuacion) {
		this.avcodigoActuacion = avcodigoActuacion;
	}

	/**
	 * @return the avnombreActuacion
	 */
	public String getAvnombreActuacion() {
		return avnombreActuacion;
	}

	/**
	 * @param avnombreActuacion
	 *            the avnombreActuacion to set
	 */
	public void setAvnombreActuacion(String avnombreActuacion) {
		this.avnombreActuacion = avnombreActuacion;
	}

	/**
	 * @return the avnombreeActuacion
	 */
	public String getAvnombreeActuacion() {
		return avnombreeActuacion;
	}

	/**
	 * @param avnombreeActuacion
	 *            the avnombreeActuacion to set
	 */
	public void setAvnombreeActuacion(String avnombreeActuacion) {
		this.avnombreeActuacion = avnombreeActuacion;
	}

	/**
	 * @return the secodigoActuacion
	 */
	public String getSecodigoActuacion() {
		return secodigoActuacion;
	}

	/**
	 * @param secodigoActuacion
	 *            the secodigoActuacion to set
	 */
	public void setSecodigoActuacion(String secodigoActuacion) {
		this.secodigoActuacion = secodigoActuacion;
	}

	/**
	 * @return the senombreActuacion
	 */
	public String getSenombreActuacion() {
		return senombreActuacion;
	}

	/**
	 * @param senombreActuacion
	 *            the senombreActuacion to set
	 */
	public void setSenombreActuacion(String senombreActuacion) {
		this.senombreActuacion = senombreActuacion;
	}

	/**
	 * @return the senombreeActuacion
	 */
	public String getSenombreeActuacion() {
		return senombreeActuacion;
	}

	/**
	 * @param senombreeActuacion
	 *            the senombreeActuacion to set
	 */
	public void setSenombreeActuacion(String senombreeActuacion) {
		this.senombreeActuacion = senombreeActuacion;
	}

	/**
	 * @return the eainprseActuacion
	 */
	public String getEainprseActuacion() {
		return eainprseActuacion;
	}

	/**
	 * @param eainprseActuacion
	 *            the eainprseActuacion to set
	 */
	public void setEainprseActuacion(String eainprseActuacion) {
		this.eainprseActuacion = eainprseActuacion;
	}

	/**
	 * @return the direccionAntiguaCompletaActuacion
	 */
	public String getDireccionAntiguaCompletaActuacion() {
		return direccionAntiguaCompletaActuacion;
	}

	/**
	 * @param direccionAntiguaCompletaActuacion
	 *            the direccionAntiguaCompletaActuacion to set
	 */
	public void setDireccionAntiguaCompletaActuacion(
			String direccionAntiguaCompletaActuacion) {
		this.direccionAntiguaCompletaActuacion = direccionAntiguaCompletaActuacion;
	}

	/**
	 * @return the pscodigoActuacion
	 */
	public String getPscodigoActuacion() {
		return pscodigoActuacion;
	}

	/**
	 * @param pscodigoActuacion
	 *            the pscodigoActuacion to set
	 */
	public void setPscodigoActuacion(String pscodigoActuacion) {
		this.pscodigoActuacion = pscodigoActuacion;
	}

	/**
	 * @return the psnombreActuacion
	 */
	public String getPsnombreActuacion() {
		return psnombreActuacion;
	}

	/**
	 * @param psnombreActuacion
	 *            the psnombreActuacion to set
	 */
	public void setPsnombreActuacion(String psnombreActuacion) {
		this.psnombreActuacion = psnombreActuacion;
	}

	/**
	 * @return the psnombreeActuacion
	 */
	public String getPsnombreeActuacion() {
		return psnombreeActuacion;
	}

	/**
	 * @param psnombreeActuacion
	 *            the psnombreeActuacion to set
	 */
	public void setPsnombreeActuacion(String psnombreeActuacion) {
		this.psnombreeActuacion = psnombreeActuacion;
	}

	/**
	 * @return the atnoprse
	 */
	public String getAtnoprse() {
		return atnoprse;
	}

	/**
	 * @param atnoprse
	 *            the atnoprse to set
	 */
	public void setAtnoprse(String atnoprse) {
		this.atnoprse = atnoprse;
	}

	/**
	 * @return the atnomaps
	 */
	public String getAtnomaps() {
		return atnomaps;
	}

	/**
	 * @param atnomaps
	 *            the atnomaps to set
	 */
	public void setAtnomaps(String atnomaps) {
		this.atnomaps = atnomaps;
	}

	/**
	 * @return the atnomops
	 */
	public String getAtnomops() {
		return atnomops;
	}

	/**
	 * @param atnomops
	 *            the atnomops to set
	 */
	public void setAtnomops(String atnomops) {
		this.atnomops = atnomops;
	}

	/**
	 * @return the atnrlops
	 */
	public String getAtnrlops() {
		return atnrlops;
	}

	/**
	 * @param atnrlops
	 *            the atnrlops to set
	 */
	public void setAtnrlops(String atnrlops) {
		this.atnrlops = atnrlops;
	}

	/**
	 * @return the atfedumi
	 */
	@JsonSerialize(using = Y41bJsonDateSerializer.class)
	public Date getAtfedumi() {
		return atfedumi;
	}

	/**
	 * @param atfedumi
	 *            the atfedumi to set
	 */
	@JsonDeserialize(using = Y41bJsonDateDeserializer.class)
	public void setAtfedumi(Date atfedumi) {
		this.atfedumi = atfedumi;
	}

	/**
	 * @return the atinprse
	 */
	public String getAtinprse() {
		return atinprse;
	}

	/**
	 * @param atinprse
	 *            the atinprse to set
	 */
	public void setAtinprse(String atinprse) {
		this.atinprse = atinprse;
	}

	/**
	 * @return the atcaunep
	 */
	public BigDecimal getAtcaunep() {
		return atcaunep;
	}

	/**
	 * @param atcaunep
	 *            the atcaunep to set
	 */
	public void setAtcaunep(BigDecimal atcaunep) {
		this.atcaunep = atcaunep;
	}

	/**
	 * @return the s4codigo
	 */
	public String getS4codigo() {
		return s4codigo;
	}

	/**
	 * @param s4codigo
	 *            the s4codigo to set
	 */
	public void setS4codigo(String s4codigo) {
		this.s4codigo = s4codigo;
	}

	/**
	 * @return the s5codigo
	 */
	public String getS5codigo() {
		return s5codigo;
	}

	/**
	 * @param s5codigo
	 *            the s5codigo to set
	 */
	public void setS5codigo(String s5codigo) {
		this.s5codigo = s5codigo;
	}

	/**
	 * @return the s6codigo
	 */
	public String getS6codigo() {
		return s6codigo;
	}

	/**
	 * @param s6codigo
	 *            the s6codigo to set
	 */
	public void setS6codigo(String s6codigo) {
		this.s6codigo = s6codigo;
	}

	/**
	 * @return the atcotp
	 */
	public String getAtcotp() {
		return atcotp;
	}

	/**
	 * @param atcotp
	 *            the atcotp to set
	 */
	public void setAtcotp(String atcotp) {
		this.atcotp = atcotp;
	}

	/**
	 * @return the esdireccion_nocapvActuacion
	 */
	public String getEsdireccion_nocapvActuacion() {
		return esdireccion_nocapvActuacion;
	}

	/**
	 * @param esdireccion_nocapvActuacion
	 *            the esdireccion_nocapvActuacion to set
	 */
	public void setEsdireccion_nocapvActuacion(
			String esdireccion_nocapvActuacion) {
		this.esdireccion_nocapvActuacion = esdireccion_nocapvActuacion;
	}

	/**
	 * @return the atteinfo
	 */
	public String getAtteinfo() {
		return atteinfo;
	}

	/**
	 * @param atteinfo
	 *            the atteinfo to set
	 */
	public void setAtteinfo(String atteinfo) {
		this.atteinfo = atteinfo;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "ActuacionDetalle [tipo=" + tipo + ", codigo=" + codigo
				+ ", descripcion=" + descripcion + ", accodigo=" + accodigo
				+ ", atcodigo=" + atcodigo + ", atnror=" + atnror + ", atcotp="
				+ atcotp + ", ttacodigo=" + ttacodigo + ", ttanombre="
				+ ttanombre + ", tmacodigo=" + tmacodigo + ", tmanombre="
				+ tmanombre + ", escodigoActuacion=" + escodigoActuacion
				+ ", esnombreActuacion=" + esnombreActuacion
				+ ", esnifActuacion=" + esnifActuacion + ", esnocoActuacion="
				+ esnocoActuacion + ", esnodirActuacion=" + esnodirActuacion
				+ ", escoloActuacion=" + escoloActuacion
				+ ", esnrcopoActuacion=" + esnrcopoActuacion
				+ ", esnrtelActuacion=" + esnrtelActuacion
				+ ", esnrfaxActuacion=" + esnrfaxActuacion
				+ ", escopaActuacion=" + escopaActuacion
				+ ", esinadarActuacion=" + esinadarActuacion
				+ ", esfeadarActuacion=" + esfeadarActuacion
				+ ", escoemActuacion=" + escoemActuacion
				+ ", esnrtel2Actuacion=" + esnrtel2Actuacion
				+ ", esfebaActuacion=" + esfebaActuacion + ", esnoloActuacion="
				+ esnoloActuacion + ", escomapvActuacion=" + escomapvActuacion
				+ ", escocaActuacion=" + escocaActuacion + ", esnomuActuacion="
				+ esnomuActuacion + ", esteurlActuacion=" + esteurlActuacion
				+ ", esnoraPaisIdActuacion=" + esnoraPaisIdActuacion
				+ ", esnoraPaisNombreActuacion=" + esnoraPaisNombreActuacion
				+ ", provinciaIdActuacion=" + provinciaIdActuacion
				+ ", esnombreProvinciaActuacion=" + esnombreProvinciaActuacion
				+ ", municipioIdActuacion=" + municipioIdActuacion
				+ ", esnombreMunicipioActuacion=" + esnombreMunicipioActuacion
				+ ", localidadIdActuacion=" + localidadIdActuacion
				+ ", esnombreLocalidadActuacion=" + esnombreLocalidadActuacion
				+ ", calleIdActuacion=" + calleIdActuacion
				+ ", calleId_labelActuacion=" + calleId_labelActuacion
				+ ", cpIdActuacion=" + cpIdActuacion + ", esnombreCpActuacion="
				+ esnombreCpActuacion + ", portalIdActuacion="
				+ portalIdActuacion + ", esnombrePortalActuacion="
				+ esnombrePortalActuacion + ", esnombrePisoActuacion="
				+ esnombrePisoActuacion + ", esdireccion_nocapvActuacion="
				+ esdireccion_nocapvActuacion + ", eacodigoActuacion="
				+ eacodigoActuacion + ", avcodigoActuacion="
				+ avcodigoActuacion + ", avnombreActuacion="
				+ avnombreActuacion + ", avnombreeActuacion="
				+ avnombreeActuacion + ", secodigoActuacion="
				+ secodigoActuacion + ", senombreActuacion="
				+ senombreActuacion + ", senombreeActuacion="
				+ senombreeActuacion + ", eainprseActuacion="
				+ eainprseActuacion + ", direccionAntiguaCompletaActuacion="
				+ direccionAntiguaCompletaActuacion + ", pscodigoActuacion="
				+ pscodigoActuacion + ", psnombreActuacion="
				+ psnombreActuacion + ", psnombreeActuacion="
				+ psnombreeActuacion + ", atnoprse=" + atnoprse + ", atnomaps="
				+ atnomaps + ", atnomops=" + atnomops + ", atnrlops="
				+ atnrlops + ", atfedumi=" + atfedumi + ", s4codigo="
				+ s4codigo + ", s5codigo=" + s5codigo + ", s6codigo="
				+ s6codigo + ", atinprse=" + atinprse + ", atcaunep="
				+ atcaunep + "]";
	}

}
