package com.ejie.y41b.model;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.springframework.context.i18n.LocaleContextHolder;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * Acta  
 * 
 *  
 */

public class Acta implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	private String accodigo;
	private String accoor;
	private String acnror;
	private BigDecimal acnran;
	private String accoinun;
	private String accoindo;
	private Date acfele;
	private Date acfere;

	private Date acfereDesde;
	private Date acfereHasta;
	private String acfereDesdeStr;
	private String acfereHastaStr;
	private String accoes;
	private String accoav;
	private String accose;
	private Date acfeex;
	private String acinre;
	private String acnoco;
	private String acdnico;
	private String accoco;
	private String acdirco;
	private String accoloco;
	private String acnrcpco;
	private String acnrtfco;
	private String accotd;
	private String acnoraPaisId;
	private String acnoraPaisNombre;
	private String acnoraProvinciaId;
	private String acnombreProvincia;
	private String acnoraMunicipioId;
	private String acnombreMunicipio;
	private String acnoraLocalidadId;
	private String acnombreLocalidad;
	private String acnoraCalleId;
	private String acnombreCalle;
	private String acnoraCpId;
	private String acnombreCp;
	private String acnoraPortalId;
	private String acnombrePortal;
	private String acnombrePiso;
	private String acdireccionNocapv;
	private String acape1co;
	private String acape2co;
	private String accodexpedienteorigen;
	private String accoororigen;
	private String accoorganismoorigen;
	private String actiororigen;
	private String acincumplimiento;
	private String monombre;

	private Establecimiento establecimiento;
	private Establecimiento establecimientoResponsable;

	private String senombre;
	private String avnombre;

	private String monombre1;
	private String monombre2;

	private List<Actuacion> actuacions = new ArrayList<Actuacion>();
	private Actuacion actuacion;

	private String accomo;

	// tramitacion
	private String fcodigo;
	private String trcodigo;
	private String decodigo;
	private String mocodigoTramitador;
	private Date ehfechafinDecisionDesde;
	private Date ehfechafinDecisionHasta;
	private String ehfechafinDecisionDesdeStr;
	private String ehfechafinDecisionHastaStr;

	private String indUltimoTramite;
	private String indPendienteAcuse;
	private String indIncluirCerrados;
	private String indPendienteDecision;
	private String indPendienteFirma;

	private String estRespResidencia;
	private String estResidencia;

	private String ancodac;

	/**
	 * @param accodigo
	 *            String
	 * @param accoor
	 *            String
	 * @param acnror
	 *            String
	 * @param acnran
	 *            BigDecimal
	 * @param accoinun
	 *            String
	 * @param accoindo
	 *            String
	 * @param acfele
	 *            Date
	 * @param acfere
	 *            Date
	 * @param acfereDesde
	 *            Date
	 * @param acfereHasta
	 *            Date
	 * @param accoes
	 *            String
	 * @param accoav
	 *            String
	 * @param accose
	 *            String
	 * @param acfeex
	 *            String
	 * @param acinre
	 *            String
	 * @param acnoco
	 *            String
	 * @param acdnico
	 *            String
	 * @param accoco
	 *            String
	 * @param acdirco
	 *            String
	 * @param accoloco
	 *            String
	 * @param acnrcpco
	 *            String
	 * @param acnrtfco
	 *            String
	 * @param accotd
	 *            String
	 * @param acnoraPaisId
	 *            String
	 * @param acnoraPaisNombre
	 *            String
	 * @param acnoraProvinciaId
	 *            String
	 * @param acnombreProvincia
	 *            String
	 * @param acnoraMunicipioId
	 *            String
	 * @param acnombreMunicipio
	 *            String
	 * @param acnoraLocalidadId
	 *            String
	 * @param acnombreLocalidad
	 *            String
	 * @param acnoraCalleId
	 *            String
	 * @param acnombreCalle
	 *            String
	 * @param acnoraCpId
	 *            String
	 * @param acnombreCp
	 *            String
	 * @param acnoraPortalId
	 *            String
	 * @param acnombrePortal
	 *            String
	 * @param acnombrePiso
	 *            String
	 * @param acdireccionNocapv
	 *            String
	 * @param acape1co
	 *            String
	 * @param acape2co
	 *            String
	 * @param accodexpedienteorigen
	 *            String
	 * @param accoororigen
	 *            String
	 */
	public Acta(String accodigo, String accoor, String acnror, BigDecimal acnran, String accoinun, String accoindo,
			Date acfele, Date acfere, Date acfereDesde, Date acfereHasta, String accoes, String accoav, String accose,
			Date acfeex, String acinre, String acnoco, String acdnico, String accoco, String acdirco, String accoloco,
			String acnrcpco, String acnrtfco, String accotd, String acnoraPaisId, String acnoraPaisNombre,
			String acnoraProvinciaId, String acnombreProvincia, String acnoraMunicipioId, String acnombreMunicipio,
			String acnoraLocalidadId, String acnombreLocalidad, String acnoraCalleId, String acnombreCalle,
			String acnoraCpId, String acnombreCp, String acnoraPortalId, String acnombrePortal, String acnombrePiso,
			String acdireccionNocapv, String acape1co, String acape2co, String accodexpedienteorigen,
			String accoororigen) {
		super();
		this.accodigo = accodigo;
		this.accoor = accoor;
		this.acnror = acnror;
		this.acnran = acnran;
		this.accoinun = accoinun;
		this.accoindo = accoindo;
		this.acfele = acfele;
		this.acfere = acfere;
		this.acfereDesde = acfereDesde;
		this.acfereHasta = acfereHasta;
		this.accoes = accoes;
		this.accoav = accoav;
		this.accose = accose;
		this.acfeex = acfeex;
		this.acinre = acinre;
		this.acnoco = acnoco;
		this.acdnico = acdnico;
		this.accoco = accoco;
		this.acdirco = acdirco;
		this.accoloco = accoloco;
		this.acnrcpco = acnrcpco;
		this.acnrtfco = acnrtfco;
		this.accotd = accotd;
		this.acnoraPaisId = acnoraPaisId;
		this.acnoraPaisNombre = acnoraPaisNombre;
		this.acnoraProvinciaId = acnoraProvinciaId;
		this.acnombreProvincia = acnombreProvincia;
		this.acnoraMunicipioId = acnoraMunicipioId;
		this.acnombreMunicipio = acnombreMunicipio;
		this.acnoraLocalidadId = acnoraLocalidadId;
		this.acnombreLocalidad = acnombreLocalidad;
		this.acnoraCalleId = acnoraCalleId;
		this.acnombreCalle = acnombreCalle;
		this.acnoraCpId = acnoraCpId;
		this.acnombreCp = acnombreCp;
		this.acnoraPortalId = acnoraPortalId;
		this.acnombrePortal = acnombrePortal;
		this.acnombrePiso = acnombrePiso;
		this.acdireccionNocapv = acdireccionNocapv;
		this.acape1co = acape1co;
		this.acape2co = acape2co;
		this.accodexpedienteorigen = accodexpedienteorigen;
		this.accoororigen = accoororigen;
	}

	/**
	 * Method 'Acta'.
	 */
	public Acta() {
	}

	/**
	 * Method 'Acta'.
	 * 
	 * @param accodigo
	 *            String
	 * @param accomo
	 *            String
	 * @param accoor
	 *            String
	 * @param acnror
	 *            String
	 * @param acnran
	 *            BigDecimal
	 * @param accoinun
	 *            String
	 * @param accoindo
	 *            String
	 * @param acfele
	 *            Date
	 * @param acfere
	 *            Date
	 * @param accoes
	 *            String
	 * @param accoav
	 *            String
	 * @param accose
	 *            String
	 * @param acfeex
	 *            Date
	 * @param acinre
	 *            String
	 * @param acnoco
	 *            String
	 * @param acdnico
	 *            String
	 * @param accoco
	 *            String
	 * @param acdirco
	 *            String
	 * @param accoloco
	 *            String
	 * @param acnrcpco
	 *            String
	 * @param acnrtfco
	 *            String
	 * @param accotd
	 *            String
	 * @param acnoraPaisId
	 *            String
	 * @param acnoraPaisNombre
	 *            String
	 * @param acnoraProvinciaId
	 *            String
	 * @param acnombreProvincia
	 *            String
	 * @param acnoraMunicipioId
	 *            String
	 * @param acnombreMunicipio
	 *            String
	 * @param acnoraLocalidadId
	 *            String
	 * @param acnombreLocalidad
	 *            String
	 * @param acnoraCalleId
	 *            String
	 * @param acnombreCalle
	 *            String
	 * @param acnoraCpId
	 *            String
	 * @param acnombreCp
	 *            String
	 * @param acnoraPortalId
	 *            String
	 * @param acnombrePortal
	 *            String
	 * @param acnombrePiso
	 *            String
	 * @param acdireccionNocapv
	 *            String
	 * @param acape1co
	 *            String
	 * @param acape2co
	 *            String
	 * @param accodexpedienteorigen
	 *            String
	 * @param accoororigen
	 *            String
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimientoResponsable
	 *            Establecimiento
	 * @param actuacion
	 *            Actuacion
	 * @param monombre
	 *            String
	 * @param senombre
	 *            String
	 * @param avnombre
	 *            String
	 * @param monombre1
	 *            String
	 * @param monombre2
	 *            String
	 */
	public Acta(String accodigo, String accoor, String accomo, String acnror, BigDecimal acnran, String accoinun,
			String accoindo, Date acfele, Date acfere, String accoes, String accoav, String accose, Date acfeex,
			String acinre, String acnoco, String acdnico, String accoco, String acdirco, String accoloco,
			String acnrcpco, String acnrtfco, String accotd, String acnoraPaisId, String acnoraPaisNombre,
			String acnoraProvinciaId, String acnombreProvincia, String acnoraMunicipioId, String acnombreMunicipio,
			String acnoraLocalidadId, String acnombreLocalidad, String acnoraCalleId, String acnombreCalle,
			String acnoraCpId, String acnombreCp, String acnoraPortalId, String acnombrePortal, String acnombrePiso,
			String acdireccionNocapv, String acape1co, String acape2co, String accodexpedienteorigen,
			String accoororigen, Establecimiento establecimiento, Establecimiento establecimientoResponsable,
			Actuacion actuacion, String monombre, String senombre, String avnombre, String monombre1,
			String monombre2) {
		this.accodigo = accodigo;
		this.accoor = accoor;
		this.accomo = accomo;
		this.acnror = acnror;
		this.acnran = acnran;
		this.accoinun = accoinun;
		this.accoindo = accoindo;
		this.acfele = acfele;
		this.acfere = acfere;
		this.accoes = accoes;
		this.accoav = accoav;
		this.accose = accose;
		this.acfeex = acfeex;
		this.acinre = acinre;
		this.acnoco = acnoco;
		this.acdnico = acdnico;
		this.accoco = accoco;
		this.acdirco = acdirco;
		this.accoloco = accoloco;
		this.acnrcpco = acnrcpco;
		this.acnrtfco = acnrtfco;
		this.accotd = accotd;
		this.acnoraPaisId = acnoraPaisId;
		this.acnoraPaisNombre = acnoraPaisNombre;
		this.acnoraProvinciaId = acnoraProvinciaId;
		this.acnombreProvincia = acnombreProvincia;
		this.acnoraMunicipioId = acnoraMunicipioId;
		this.acnombreMunicipio = acnombreMunicipio;
		this.acnoraLocalidadId = acnoraLocalidadId;
		this.acnombreLocalidad = acnombreLocalidad;
		this.acnoraCalleId = acnoraCalleId;
		this.acnombreCalle = acnombreCalle;
		this.acnoraCpId = acnoraCpId;
		this.acnombreCp = acnombreCp;
		this.acnoraPortalId = acnoraPortalId;
		this.acnombrePortal = acnombrePortal;
		this.acnombrePiso = acnombrePiso;
		this.acdireccionNocapv = acdireccionNocapv;
		this.acape1co = acape1co;
		this.acape2co = acape2co;
		this.accodexpedienteorigen = accodexpedienteorigen;
		this.accoororigen = accoororigen;
		this.establecimiento = establecimiento;
		this.establecimientoResponsable = establecimientoResponsable;
		this.actuacion = actuacion;
		this.monombre = monombre;
		this.senombre = senombre;
		this.avnombre = avnombre;

		this.monombre1 = monombre1;
		this.monombre2 = monombre2;
	}

	/**
	 * Method 'Acta'.
	 * 
	 * @param accodigo
	 *            String
	 * @param accoor
	 *            String
	 * @param acnror
	 *            String
	 * @param acnran
	 *            BigDecimal
	 * @param accoinun
	 *            String
	 * @param accoindo
	 *            String
	 * @param acfele
	 *            Date
	 * @param acfere
	 *            Date
	 * @param accoes
	 *            String
	 * @param accoav
	 *            String
	 * @param accose
	 *            String
	 * @param acfeex
	 *            Date
	 * @param acinre
	 *            String
	 * @param acnoco
	 *            String
	 * @param acdnico
	 *            String
	 * @param accoco
	 *            String
	 * @param acdirco
	 *            String
	 * @param accoloco
	 *            String
	 * @param acnrcpco
	 *            String
	 * @param acnrtfco
	 *            String
	 * @param accotd
	 *            String
	 * @param acnoraPaisId
	 *            String
	 * @param acnoraPaisNombre
	 *            String
	 * @param acnoraProvinciaId
	 *            String
	 * @param acnombreProvincia
	 *            String
	 * @param acnoraMunicipioId
	 *            String
	 * @param acnombreMunicipio
	 *            String
	 * @param acnoraLocalidadId
	 *            String
	 * @param acnombreLocalidad
	 *            String
	 * @param acnoraCalleId
	 *            String
	 * @param acnombreCalle
	 *            String
	 * @param acnoraCpId
	 *            String
	 * @param acnombreCp
	 *            String
	 * @param acnoraPortalId
	 *            String
	 * @param acnombrePortal
	 *            String
	 * @param acnombrePiso
	 *            String
	 * @param acdireccionNocapv
	 *            String
	 * @param acape1co
	 *            String
	 * @param acape2co
	 *            String
	 * @param accodexpedienteorigen
	 *            String
	 * @param accoororigen
	 *            String
	 * @param actuacions
	 *            List<Actuacion>
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimientoResponsable
	 *            Establecimiento
	 * @param actuacion
	 *            Actuacion
	 * @param monombre
	 *            String
	 */
	public Acta(String accodigo, String accoor, String acnror, BigDecimal acnran, String accoinun, String accoindo,
			Date acfele, Date acfere, String accoes, String accoav, String accose, Date acfeex, String acinre,
			String acnoco, String acdnico, String accoco, String acdirco, String accoloco, String acnrcpco,
			String acnrtfco, String accotd, String acnoraPaisId, String acnoraPaisNombre, String acnoraProvinciaId,
			String acnombreProvincia, String acnoraMunicipioId, String acnombreMunicipio, String acnoraLocalidadId,
			String acnombreLocalidad, String acnoraCalleId, String acnombreCalle, String acnoraCpId, String acnombreCp,
			String acnoraPortalId, String acnombrePortal, String acnombrePiso, String acdireccionNocapv,
			String acape1co, String acape2co, String accodexpedienteorigen, String accoororigen,
			List<Actuacion> actuacions, Establecimiento establecimiento, Establecimiento establecimientoResponsable,
			Actuacion actuacion, String monombre) {

		this.accodigo = accodigo;
		this.accoor = accoor;
		this.acnror = acnror;
		this.acnran = acnran;
		this.accoinun = accoinun;
		this.accoindo = accoindo;
		this.acfele = acfele;
		this.acfere = acfere;
		this.accoes = accoes;
		this.accoav = accoav;
		this.accose = accose;
		this.acfeex = acfeex;
		this.acinre = acinre;
		this.acnoco = acnoco;
		this.acdnico = acdnico;
		this.accoco = accoco;
		this.acdirco = acdirco;
		this.accoloco = accoloco;
		this.acnrcpco = acnrcpco;
		this.acnrtfco = acnrtfco;
		this.accotd = accotd;
		this.acnoraPaisId = acnoraPaisId;
		this.acnoraPaisNombre = acnoraPaisNombre;
		this.acnoraProvinciaId = acnoraProvinciaId;
		this.acnombreProvincia = acnombreProvincia;
		this.acnoraMunicipioId = acnoraMunicipioId;
		this.acnombreMunicipio = acnombreMunicipio;
		this.acnoraLocalidadId = acnoraLocalidadId;
		this.acnombreLocalidad = acnombreLocalidad;
		this.acnoraCalleId = acnoraCalleId;
		this.acnombreCalle = acnombreCalle;
		this.acnoraCpId = acnoraCpId;
		this.acnombreCp = acnombreCp;
		this.acnoraPortalId = acnoraPortalId;
		this.acnombrePortal = acnombrePortal;
		this.acnombrePiso = acnombrePiso;
		this.acdireccionNocapv = acdireccionNocapv;
		this.acape1co = acape1co;
		this.acape2co = acape2co;
		this.accodexpedienteorigen = accodexpedienteorigen;
		this.accoororigen = accoororigen;
		this.actuacions = actuacions;
		this.establecimiento = establecimiento;
		this.establecimientoResponsable = establecimientoResponsable;
		this.actuacion = actuacion;
		this.monombre = monombre;
	}

	/**
	 * @return the monombre1
	 */
	public String getMonombre1() {
		return this.monombre1;
	}

	/**
	 * @param monombre1
	 *            the monombre1 to set
	 */
	public void setMonombre1(String monombre1) {
		this.monombre1 = monombre1;
	}

	/**
	 * @return the monombre2
	 */
	public String getMonombre2() {
		return this.monombre2;
	}

	/**
	 * @param monombre2
	 *            the monombre2 to set
	 */
	public void setMonombre2(String monombre2) {
		this.monombre2 = monombre2;
	}

	/**
	 * @return the senombre
	 */
	public String getSenombre() {
		return this.senombre;
	}

	/**
	 * @param senombre
	 *            the senombre to set
	 */
	public void setSenombre(String senombre) {
		this.senombre = senombre;
	}

	/**
	 * @return the avnombre
	 */
	public String getAvnombre() {
		return this.avnombre;
	}

	/**
	 * @param avnombre
	 *            the avnombre to set
	 */
	public void setAvnombre(String avnombre) {
		this.avnombre = avnombre;
	}

	/**
	 * @return the monombre
	 */
	public String getMonombre() {
		return this.monombre;
	}

	/**
	 * @param monombre
	 *            the monombre to set
	 */
	public void setMonombre(String monombre) {
		this.monombre = monombre;
	}

	/**
	 * @return the actuacion
	 */
	public Actuacion getActuacion() {
		return this.actuacion;
	}

	/**
	 * @param actuacion
	 *            the actuacion to set
	 */
	public void setActuacion(Actuacion actuacion) {
		this.actuacion = actuacion;
	}

	/**
	 * @return the establecimientoResponsable
	 */
	public Establecimiento getEstablecimientoResponsable() {
		return this.establecimientoResponsable;
	}

	/**
	 * @param establecimientoResponsable
	 *            the establecimientoResponsable to set
	 */
	public void setEstablecimientoResponsable(Establecimiento establecimientoResponsable) {
		this.establecimientoResponsable = establecimientoResponsable;
	}

	/**
	 * @return the acfereDesde
	 */
	public Date getAcfereDesde() {
		return this.acfereDesde;
	}

	/**
	 * @param acfereDesde
	 *            the acfereDesde to set
	 */
	public void setAcfereDesde(Date acfereDesde) {
		String lang = "";
		Locale locale = LocaleContextHolder.getLocale();
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			lang = Y41bConstantes.FORMATO_FECHA_ES;
		} else {
			lang = Y41bConstantes.FORMATO_FECHA_EU;
		}
		DateFormat df = new SimpleDateFormat(lang);
		if (acfereDesde == null) {
			this.acfereDesdeStr = "";
		} else {
			this.acfereDesdeStr = df.format(acfereDesde);
		}

		this.acfereDesde = acfereDesde;
	}

	/**
	 * @param acfereDesdeStr
	 *            the acfereDesde to set
	 * @throws Exception
	 *             excepcion
	 */
	public void setAcfereDesde(String acfereDesdeStr) throws Exception {
		Locale locale = LocaleContextHolder.getLocale();
		if (acfereDesdeStr != null && !"".equals(acfereDesdeStr)) {
			Date acfereDesde = Y41bUtils.parseDate(acfereDesdeStr, locale);
			this.acfereDesde = acfereDesde;
		} else {
			this.acfereDesde = null;
		}

		this.acfereDesdeStr = acfereDesdeStr;
	}

	/**
	 * @return the acfereHasta
	 */
	public Date getAcfereHasta() {
		return this.acfereHasta;
	}

	/**
	 * @param acfereHasta
	 *            the acfereHasta to set
	 */
	public void setAcfereHasta(Date acfereHasta) {
		String lang = "";
		Locale locale = LocaleContextHolder.getLocale();
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			lang = Y41bConstantes.FORMATO_FECHA_ES;
		} else {
			lang = Y41bConstantes.FORMATO_FECHA_EU;
		}
		DateFormat df = new SimpleDateFormat(lang);
		if (acfereHasta == null) {
			this.acfereHastaStr = "";
		} else {
			this.acfereHastaStr = df.format(acfereHasta);
		}

		this.acfereHasta = acfereHasta;
	}

	/**
	 * @param acfereHastaStr
	 *            the acfereHastaStr to set
	 * @throws Exception
	 *             excepcion
	 */
	public void setAcfereHasta(String acfereHastaStr) throws Exception {
		Locale locale = LocaleContextHolder.getLocale();
		if (acfereHastaStr != null && !"".equals(acfereHastaStr)) {
			Date acfereHasta = Y41bUtils.parseDate(acfereHastaStr, locale);
			this.acfereHasta = acfereHasta;
		} else {
			this.acfereHasta = null;
		}

		this.acfereHastaStr = acfereHastaStr;
	}

	/**
	 * @return the acfereDesdeStr
	 */
	public String getAcfereDesdeStr() {
		return this.acfereDesdeStr;
	}

	/**
	 * @param acfereDesdeStr
	 *            the acfereDesdeStr to set
	 */
	public void setAcfereDesdeStr(String acfereDesdeStr) {
		this.acfereDesdeStr = acfereDesdeStr;
	}

	/**
	 * @return the acfereHastaStr
	 */
	public String getAcfereHastaStr() {
		return this.acfereHastaStr;
	}

	/**
	 * @param acfereHastaStr
	 *            the acfereHastaStr to set
	 */
	public void setAcfereHastaStr(String acfereHastaStr) {
		this.acfereHastaStr = acfereHastaStr;
	}

	/**
	 * Method 'getAccodigo'.
	 * 
	 * @return String
	 */

	public String getAccodigo() {
		return this.accodigo;
	}

	/**
	 * Method 'setAccodigo'.
	 * 
	 * @param accodigo
	 *            String
	 * @return
	 */

	public void setAccodigo(String accodigo) {
		this.accodigo = accodigo;
	}

	/**
	 * Method 'getAccoor'.
	 * 
	 * @return String
	 */

	public String getAccoor() {
		return this.accoor;
	}

	/**
	 * Method 'getEstablecimiento'.
	 * 
	 * @return Establecimiento
	 */
	@JsonIgnore()
	public Establecimiento getEstablecimiento() {
		return this.establecimiento;
	}

	/**
	 * Method 'setEstablecimiento'.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return
	 */

	public void setEstablecimiento(Establecimiento establecimiento) {
		this.establecimiento = establecimiento;
	}

	/**
	 * Method 'setAccoor'.
	 * 
	 * @param accoor
	 *            String
	 * @return
	 */

	public void setAccoor(String accoor) {
		this.accoor = accoor;
	}

	/**
	 * Method 'getAcnror'.
	 * 
	 * @return String
	 */

	public String getAcnror() {
		return this.acnror;
	}

	/**
	 * Method 'setAcnror'.
	 * 
	 * @param acnror
	 *            String
	 * @return
	 */

	public void setAcnror(String acnror) {
		this.acnror = acnror;
	}

	/**
	 * Method 'getAcnran'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getAcnran() {
		return this.acnran;
	}

	/**
	 * Method 'setAcnran'.
	 * 
	 * @param acnran
	 *            BigDecimal
	 * @return
	 */

	public void setAcnran(BigDecimal acnran) {
		this.acnran = acnran;
	}

	/**
	 * Method 'getAccoinun'.
	 * 
	 * @return String
	 */

	public String getAccoinun() {
		return this.accoinun;
	}

	/**
	 * Method 'setAccoinun'.
	 * 
	 * @param accoinun
	 *            String
	 * @return
	 */

	public void setAccoinun(String accoinun) {
		this.accoinun = accoinun;
	}

	/**
	 * Method 'getAccoindo'.
	 * 
	 * @return String
	 */

	public String getAccoindo() {
		return this.accoindo;
	}

	/**
	 * Method 'setAccoindo'.
	 * 
	 * @param accoindo
	 *            String
	 * @return
	 */

	public void setAccoindo(String accoindo) {
		this.accoindo = accoindo;
	}

	/**
	 * Method 'getAcfele'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getAcfele() {
		return this.acfele;
	}

	/**
	 * Method 'setAcfele'.
	 * 
	 * @param acfele
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setAcfele(Date acfele) {
		this.acfele = acfele;
	}

	/**
	 * Method 'getAcfere'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getAcfere() {
		return this.acfere;
	}

	/**
	 * Method 'setAcfere'.
	 * 
	 * @param acfere
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setAcfere(Date acfere) {
		this.acfere = acfere;
	}

	/**
	 * Method 'getAccoes'.
	 * 
	 * @return String
	 */

	public String getAccoes() {
		return this.accoes;
	}

	/**
	 * Method 'setAccoes'.
	 * 
	 * @param accoes
	 *            String
	 * @return
	 */

	public void setAccoes(String accoes) {
		this.accoes = accoes;
	}

	/**
	 * Method 'getAccoav'.
	 * 
	 * @return String
	 */

	public String getAccoav() {
		return this.accoav;
	}

	/**
	 * Method 'setAccoav'.
	 * 
	 * @param accoav
	 *            String
	 * @return
	 */

	public void setAccoav(String accoav) {
		this.accoav = accoav;
	}

	/**
	 * Method 'getAccose'.
	 * 
	 * @return String
	 */

	public String getAccose() {
		return this.accose;
	}

	/**
	 * Method 'setAccose'.
	 * 
	 * @param accose
	 *            String
	 * @return
	 */

	public void setAccose(String accose) {
		this.accose = accose;
	}

	/**
	 * Method 'getAcfeex'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getAcfeex() {
		return this.acfeex;
	}

	/**
	 * Method 'setAcfeex'.
	 * 
	 * @param acfeex
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setAcfeex(Date acfeex) {
		this.acfeex = acfeex;
	}

	/**
	 * Method 'getAcinre'.
	 * 
	 * @return String
	 */

	public String getAcinre() {
		return this.acinre;
	}

	/**
	 * Method 'setAcinre'.
	 * 
	 * @param acinre
	 *            String
	 * @return
	 */

	public void setAcinre(String acinre) {
		this.acinre = acinre;
	}

	/**
	 * Method 'getAcnoco'.
	 * 
	 * @return String
	 */

	public String getAcnoco() {
		return this.acnoco;
	}

	/**
	 * Method 'setAcnoco'.
	 * 
	 * @param acnoco
	 *            String
	 * @return
	 */

	public void setAcnoco(String acnoco) {
		this.acnoco = acnoco;
	}

	/**
	 * Method 'getAcdnico'.
	 * 
	 * @return String
	 */

	public String getAcdnico() {
		return this.acdnico;
	}

	/**
	 * Method 'setAcdnico'.
	 * 
	 * @param acdnico
	 *            String
	 * @return
	 */

	public void setAcdnico(String acdnico) {
		this.acdnico = acdnico;
	}

	/**
	 * Method 'getAccoco'.
	 * 
	 * @return String
	 */

	public String getAccoco() {
		return this.accoco;
	}

	/**
	 * Method 'setAccoco'.
	 * 
	 * @param accoco
	 *            String
	 * @return
	 */

	public void setAccoco(String accoco) {
		this.accoco = accoco;
	}

	/**
	 * Method 'getAcdirco'.
	 * 
	 * @return String
	 */

	public String getAcdirco() {
		return this.acdirco;
	}

	/**
	 * Method 'setAcdirco'.
	 * 
	 * @param acdirco
	 *            String
	 * @return
	 */

	public void setAcdirco(String acdirco) {
		this.acdirco = acdirco;
	}

	/**
	 * Method 'getAccoloco'.
	 * 
	 * @return String
	 */

	public String getAccoloco() {
		return this.accoloco;
	}

	/**
	 * Method 'setAccoloco'.
	 * 
	 * @param accoloco
	 *            String
	 * @return
	 */

	public void setAccoloco(String accoloco) {
		this.accoloco = accoloco;
	}

	/**
	 * Method 'getAcnrcpco'.
	 * 
	 * @return String
	 */

	public String getAcnrcpco() {
		return this.acnrcpco;
	}

	/**
	 * Method 'setAcnrcpco'.
	 * 
	 * @param acnrcpco
	 *            String
	 * @return
	 */

	public void setAcnrcpco(String acnrcpco) {
		this.acnrcpco = acnrcpco;
	}

	/**
	 * Method 'getAcnrtfco'.
	 * 
	 * @return String
	 */

	public String getAcnrtfco() {
		return this.acnrtfco;
	}

	/**
	 * Method 'setAcnrtfco'.
	 * 
	 * @param acnrtfco
	 *            String
	 * @return
	 */

	public void setAcnrtfco(String acnrtfco) {
		this.acnrtfco = acnrtfco;
	}

	/**
	 * Method 'getAccotd'.
	 * 
	 * @return String
	 */

	public String getAccotd() {
		return this.accotd;
	}

	/**
	 * Method 'setAccotd'.
	 * 
	 * @param accotd
	 *            String
	 * @return
	 */

	public void setAccotd(String accotd) {
		this.accotd = accotd;
	}

	/**
	 * Method 'getAcnoraPaisId'.
	 * 
	 * @return String
	 */

	public String getAcnoraPaisId() {
		return this.acnoraPaisId;
	}

	/**
	 * Method 'setAcnoraPaisId'.
	 * 
	 * @param acnoraPaisId
	 *            String
	 * @return
	 */

	public void setAcnoraPaisId(String acnoraPaisId) {
		this.acnoraPaisId = acnoraPaisId;
	}

	/**
	 * Method 'getAcnoraPaisNombre'.
	 * 
	 * @return String
	 */

	public String getAcnoraPaisNombre() {
		return this.acnoraPaisNombre;
	}

	/**
	 * Method 'setAcnoraPaisNombre'.
	 * 
	 * @param acnoraPaisNombre
	 *            String
	 * @return
	 */

	public void setAcnoraPaisNombre(String acnoraPaisNombre) {
		this.acnoraPaisNombre = acnoraPaisNombre;
	}

	/**
	 * Method 'getAcnoraProvinciaId'.
	 * 
	 * @return String
	 */

	public String getAcnoraProvinciaId() {
		return this.acnoraProvinciaId;
	}

	/**
	 * Method 'setAcnoraProvinciaId'.
	 * 
	 * @param acnoraProvinciaId
	 *            String
	 * @return
	 */

	public void setAcnoraProvinciaId(String acnoraProvinciaId) {
		this.acnoraProvinciaId = acnoraProvinciaId;
	}

	/**
	 * Method 'getAcnombreProvincia'.
	 * 
	 * @return String
	 */

	public String getAcnombreProvincia() {
		return this.acnombreProvincia;
	}

	/**
	 * Method 'setAcnombreProvincia'.
	 * 
	 * @param acnombreProvincia
	 *            String
	 * @return
	 */

	public void setAcnombreProvincia(String acnombreProvincia) {
		this.acnombreProvincia = acnombreProvincia;
	}

	/**
	 * Method 'getAcnoraMunicipioId'.
	 * 
	 * @return String
	 */

	public String getAcnoraMunicipioId() {
		return this.acnoraMunicipioId;
	}

	/**
	 * Method 'setAcnoraMunicipioId'.
	 * 
	 * @param acnoraMunicipioId
	 *            String
	 * @return
	 */

	public void setAcnoraMunicipioId(String acnoraMunicipioId) {
		this.acnoraMunicipioId = acnoraMunicipioId;
	}

	/**
	 * Method 'getAcnombreMunicipio'.
	 * 
	 * @return String
	 */

	public String getAcnombreMunicipio() {
		return this.acnombreMunicipio;
	}

	/**
	 * Method 'setAcnombreMunicipio'.
	 * 
	 * @param acnombreMunicipio
	 *            String
	 * @return
	 */

	public void setAcnombreMunicipio(String acnombreMunicipio) {
		this.acnombreMunicipio = acnombreMunicipio;
	}

	/**
	 * Method 'getAcnoraLocalidadId'.
	 * 
	 * @return String
	 */

	public String getAcnoraLocalidadId() {
		return this.acnoraLocalidadId;
	}

	/**
	 * Method 'setAcnoraLocalidadId'.
	 * 
	 * @param acnoraLocalidadId
	 *            String
	 * @return
	 */

	public void setAcnoraLocalidadId(String acnoraLocalidadId) {
		this.acnoraLocalidadId = acnoraLocalidadId;
	}

	/**
	 * Method 'getAcnombreLocalidad'.
	 * 
	 * @return String
	 */

	public String getAcnombreLocalidad() {
		return this.acnombreLocalidad;
	}

	/**
	 * Method 'setAcnombreLocalidad'.
	 * 
	 * @param acnombreLocalidad
	 *            String
	 * @return
	 */

	public void setAcnombreLocalidad(String acnombreLocalidad) {
		this.acnombreLocalidad = acnombreLocalidad;
	}

	/**
	 * Method 'getAcnoraCalleId'.
	 * 
	 * @return String
	 */

	public String getAcnoraCalleId() {
		return this.acnoraCalleId;
	}

	/**
	 * Method 'setAcnoraCalleId'.
	 * 
	 * @param acnoraCalleId
	 *            String
	 * @return
	 */

	public void setAcnoraCalleId(String acnoraCalleId) {
		this.acnoraCalleId = acnoraCalleId;
	}

	/**
	 * Method 'getAcnombreCalle'.
	 * 
	 * @return String
	 */

	public String getAcnombreCalle() {
		return this.acnombreCalle;
	}

	/**
	 * Method 'setAcnombreCalle'.
	 * 
	 * @param acnombreCalle
	 *            String
	 * @return
	 */

	public void setAcnombreCalle(String acnombreCalle) {
		this.acnombreCalle = acnombreCalle;
	}

	/**
	 * Method 'getAcnoraCpId'.
	 * 
	 * @return String
	 */

	public String getAcnoraCpId() {
		return this.acnoraCpId;
	}

	/**
	 * Method 'setAcnoraCpId'.
	 * 
	 * @param acnoraCpId
	 *            String
	 * @return
	 */

	public void setAcnoraCpId(String acnoraCpId) {
		this.acnoraCpId = acnoraCpId;
	}

	/**
	 * Method 'getAcnombreCp'.
	 * 
	 * @return String
	 */

	public String getAcnombreCp() {
		return this.acnombreCp;
	}

	/**
	 * Method 'setAcnombreCp'.
	 * 
	 * @param acnombreCp
	 *            String
	 * @return
	 */

	public void setAcnombreCp(String acnombreCp) {
		this.acnombreCp = acnombreCp;
	}

	/**
	 * Method 'getAcnoraPortalId'.
	 * 
	 * @return String
	 */

	public String getAcnoraPortalId() {
		return this.acnoraPortalId;
	}

	/**
	 * Method 'setAcnoraPortalId'.
	 * 
	 * @param acnoraPortalId
	 *            String
	 * @return
	 */

	public void setAcnoraPortalId(String acnoraPortalId) {
		this.acnoraPortalId = acnoraPortalId;
	}

	/**
	 * Method 'getAcnombrePortal'.
	 * 
	 * @return String
	 */

	public String getAcnombrePortal() {
		return this.acnombrePortal;
	}

	/**
	 * Method 'setAcnombrePortal'.
	 * 
	 * @param acnombrePortal
	 *            String
	 * @return
	 */

	public void setAcnombrePortal(String acnombrePortal) {
		this.acnombrePortal = acnombrePortal;
	}

	/**
	 * Method 'getAcnombrePiso'.
	 * 
	 * @return String
	 */

	public String getAcnombrePiso() {
		return this.acnombrePiso;
	}

	/**
	 * Method 'setAcnombrePiso'.
	 * 
	 * @param acnombrePiso
	 *            String
	 * @return
	 */

	public void setAcnombrePiso(String acnombrePiso) {
		this.acnombrePiso = acnombrePiso;
	}

	/**
	 * Method 'getAcdireccionNocapv'.
	 * 
	 * @return String
	 */

	public String getAcdireccionNocapv() {
		return this.acdireccionNocapv;
	}

	/**
	 * Method 'setAcdireccionNocapv'.
	 * 
	 * @param acdireccionNocapv
	 *            String
	 * @return
	 */

	public void setAcdireccionNocapv(String acdireccionNocapv) {
		this.acdireccionNocapv = acdireccionNocapv;
	}

	/**
	 * Method 'getAcape1co'.
	 * 
	 * @return String
	 */

	public String getAcape1co() {
		return this.acape1co;
	}

	/**
	 * Method 'setAcape1co'.
	 * 
	 * @param acape1co
	 *            String
	 * @return
	 */

	public void setAcape1co(String acape1co) {
		this.acape1co = acape1co;
	}

	/**
	 * Method 'getAcape2co'.
	 * 
	 * @return String
	 */

	public String getAcape2co() {
		return this.acape2co;
	}

	/**
	 * Method 'setAcape2co'.
	 * 
	 * @param acape2co
	 *            String
	 * @return
	 */

	public void setAcape2co(String acape2co) {
		this.acape2co = acape2co;
	}

	/**
	 * Method 'getAccodexpedienteorigen'.
	 * 
	 * @return String
	 */

	public String getAccodexpedienteorigen() {
		return this.accodexpedienteorigen;
	}

	/**
	 * Method 'setAccodexpedienteorigen'.
	 * 
	 * @param accodexpedienteorigen
	 *            String
	 * @return
	 */

	public void setAccodexpedienteorigen(String accodexpedienteorigen) {
		this.accodexpedienteorigen = accodexpedienteorigen;
	}

	/**
	 * Method 'getAccoororigen'.
	 * 
	 * @return String
	 */

	public String getAccoororigen() {
		return this.accoororigen;
	}

	/**
	 * Method 'setAccoororigen'.
	 * 
	 * @param accoororigen
	 *            String
	 * @return
	 */

	public void setAccoororigen(String accoororigen) {
		this.accoororigen = accoororigen;
	}

	/**
	 * Method 'getActuacions'.
	 * 
	 * @return List
	 */
	@JsonIgnore()
	public List<Actuacion> getActuacions() {
		return this.actuacions;
	}

	/**
	 * Method 'setActuacions'.
	 * 
	 * @param actuacions
	 *            List
	 * @return
	 */
	public void setActuacions(List<Actuacion> actuacions) {
		this.actuacions = actuacions;
	}

	/**
	 * @return the fcodigo
	 */
	public String getFcodigo() {
		return this.fcodigo;
	}

	/**
	 * @param fcodigo
	 *            the fcodigo to set
	 */
	public void setFcodigo(String fcodigo) {
		this.fcodigo = fcodigo;
	}

	/**
	 * @return the trcodigo
	 */
	public String getTrcodigo() {
		return this.trcodigo;
	}

	/**
	 * @param trcodigo
	 *            the trcodigo to set
	 */
	public void setTrcodigo(String trcodigo) {
		this.trcodigo = trcodigo;
	}

	/**
	 * @return the decodigo
	 */
	public String getDecodigo() {
		return this.decodigo;
	}

	/**
	 * @param decodigo
	 *            the decodigo to set
	 */
	public void setDecodigo(String decodigo) {
		this.decodigo = decodigo;
	}

	/**
	 * @return the mocodigoTramitador
	 */
	public String getMocodigoTramitador() {
		return this.mocodigoTramitador;
	}

	/**
	 * @param mocodigoTramitador
	 *            the mocodigoTramitador to set
	 */
	public void setMocodigoTramitador(String mocodigoTramitador) {
		this.mocodigoTramitador = mocodigoTramitador;
	}

	/**
	 * @return the ehfechafinDecisionDesde
	 */
	public Date getEhfechafinDecisionDesde() {
		return this.ehfechafinDecisionDesde;
	}

	/**
	 * @param ehfechafinDecisionDesde
	 *            the ehfechafinDecisionDesde to set
	 */
	public void setEhfechafinDecisionDesde(Date ehfechafinDecisionDesde) {

		String lang = "";
		Locale locale = LocaleContextHolder.getLocale();
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			lang = Y41bConstantes.FORMATO_FECHA_ES;
		} else {
			lang = Y41bConstantes.FORMATO_FECHA_EU;
		}
		DateFormat df = new SimpleDateFormat(lang);
		if (ehfechafinDecisionDesde == null) {
			this.ehfechafinDecisionDesdeStr = "";
		} else {
			this.ehfechafinDecisionDesdeStr = df.format(ehfechafinDecisionDesde);
		}
		this.ehfechafinDecisionDesde = ehfechafinDecisionDesde;
	}

	/**
	 * @param ehfechafinDecisionDesdeStr
	 *            the ehfechafinDecisionDesdeStr to set
	 * @throws Exception
	 *             excepcion
	 */
	public void setEhfechafinDecisionDesde(String ehfechafinDecisionDesdeStr) throws Exception {
		Locale locale = LocaleContextHolder.getLocale();
		if (ehfechafinDecisionDesdeStr != null && !"".equals(ehfechafinDecisionDesdeStr)) {
			Date ehfechafinDecisionDesde = Y41bUtils.parseDate(ehfechafinDecisionDesdeStr, locale);
			this.ehfechafinDecisionDesde = ehfechafinDecisionDesde;
		} else {
			this.ehfechafinDecisionDesde = null;
		}

		this.ehfechafinDecisionDesdeStr = ehfechafinDecisionDesdeStr;
	}

	/**
	 * @return the ehfechafinDecisionHasta
	 */
	public Date getEhfechafinDecisionHasta() {
		return this.ehfechafinDecisionHasta;
	}

	/**
	 * @param ehfechafinDecisionHasta
	 *            the ehfechafinDecisionHasta to set
	 */
	public void setEhfechafinDecisionHasta(Date ehfechafinDecisionHasta) {
		String lang = "";
		Locale locale = LocaleContextHolder.getLocale();
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			lang = Y41bConstantes.FORMATO_FECHA_ES;
		} else {
			lang = Y41bConstantes.FORMATO_FECHA_EU;
		}
		DateFormat df = new SimpleDateFormat(lang);
		if (ehfechafinDecisionHasta == null) {
			this.ehfechafinDecisionHastaStr = "";
		} else {
			this.ehfechafinDecisionHastaStr = df.format(ehfechafinDecisionHasta);
		}

		this.ehfechafinDecisionHasta = ehfechafinDecisionHasta;
	}

	/**
	 * @param ehfechafinDecisionHastaStr
	 *            the ehfechafinDecisionDesdeStr to set
	 * @throws Exception
	 *             excepcion
	 */
	public void setEhfechafinDecisionHasta(String ehfechafinDecisionHastaStr) throws Exception {
		Locale locale = LocaleContextHolder.getLocale();
		if (ehfechafinDecisionHastaStr != null && !"".equals(ehfechafinDecisionHastaStr)) {
			Date ehfechafinDecisionHasta = Y41bUtils.parseDate(ehfechafinDecisionHastaStr, locale);
			this.ehfechafinDecisionHasta = ehfechafinDecisionHasta;
		} else {
			this.ehfechafinDecisionHasta = null;
		}

		this.ehfechafinDecisionHastaStr = ehfechafinDecisionHastaStr;
	}

	/**
	 * @return the ehfechafinDecisionDesdeStr
	 */
	public String getEhfechafinDecisionDesdeStr() {
		return this.ehfechafinDecisionDesdeStr;
	}

	/**
	 * @param ehfechafinDecisionDesdeStr
	 *            the ehfechafinDecisionDesdeStr to set
	 */
	public void setEhfechafinDecisionDesdeStr(String ehfechafinDecisionDesdeStr) {
		this.ehfechafinDecisionDesdeStr = ehfechafinDecisionDesdeStr;
	}

	/**
	 * @return the ehfechafinDecisionHastaStr
	 */
	public String getEhfechafinDecisionHastaStr() {
		return this.ehfechafinDecisionHastaStr;
	}

	/**
	 * @param ehfechafinDecisionHastaStr
	 *            the ehfechafinDecisionHastaStr to set
	 */
	public void setEhfechafinDecisionHastaStr(String ehfechafinDecisionHastaStr) {
		this.ehfechafinDecisionHastaStr = ehfechafinDecisionHastaStr;
	}

	/**
	 * @return the indUltimoTramite
	 */
	public String getIndUltimoTramite() {
		return this.indUltimoTramite;
	}

	/**
	 * @param indUltimoTramite
	 *            the indUltimoTramite to set
	 */
	public void setIndUltimoTramite(String indUltimoTramite) {
		this.indUltimoTramite = indUltimoTramite;
	}

	/**
	 * @return the indPendienteAcuse
	 */
	public String getIndPendienteAcuse() {
		return this.indPendienteAcuse;
	}

	/**
	 * @param indPendienteAcuse
	 *            the indPendienteAcuse to set
	 */
	public void setIndPendienteAcuse(String indPendienteAcuse) {
		this.indPendienteAcuse = indPendienteAcuse;
	}

	/**
	 * @return the indIncluirCerrados
	 */
	public String getIndIncluirCerrados() {
		return this.indIncluirCerrados;
	}

	/**
	 * @param indIncluirCerrados
	 *            the indIncluirCerrados to set
	 */
	public void setIndIncluirCerrados(String indIncluirCerrados) {
		this.indIncluirCerrados = indIncluirCerrados;
	}

	/**
	 * @return the indPendienteDecision
	 */
	public String getIndPendienteDecision() {
		return this.indPendienteDecision;
	}

	/**
	 * @param indPendienteDecision
	 *            the indPendienteDecision to set
	 */
	public void setIndPendienteDecision(String indPendienteDecision) {
		this.indPendienteDecision = indPendienteDecision;
	}

	/**
	 * @return the indPendienteFirma
	 */
	public String getIndPendienteFirma() {
		return this.indPendienteFirma;
	}

	/**
	 * @param indPendienteFirma
	 *            the indPendienteFirma to set
	 */
	public void setIndPendienteFirma(String indPendienteFirma) {
		this.indPendienteFirma = indPendienteFirma;
	}

	/**
	 * @return the accomo
	 */
	public String getAccomo() {
		return this.accomo;
	}

	/**
	 * @param accomo
	 *            the accomo to set
	 */
	public void setAccomo(String accomo) {
		this.accomo = accomo;
	}

	/**
	 * @return the estRespResidencia
	 */
	public String getEstRespResidencia() {
		return this.estRespResidencia;
	}

	/**
	 * @param estRespResidencia
	 *            the estRespResidencia to set
	 */
	public void setEstRespResidencia(String estRespResidencia) {
		this.estRespResidencia = estRespResidencia;
	}

	/**
	 * @return the estResidencia
	 */
	public String getEstResidencia() {
		return this.estResidencia;
	}

	/**
	 * @param estResidencia
	 *            the estResidencia to set
	 */
	public void setEstResidencia(String estResidencia) {
		this.estResidencia = estResidencia;
	}

	/**
	 * @return the actiororigen
	 */
	public String getActiororigen() {
		return this.actiororigen;
	}

	/**
	 * @param actiororigen
	 *            the actiororigen to set
	 */
	public void setActiororigen(String actiororigen) {
		this.actiororigen = actiororigen;
	}

	/**
	 * @return the acincumplimiento
	 */
	public String getAcincumplimiento() {
		return this.acincumplimiento;
	}

	/**
	 * @param acincumplimiento
	 *            the acincumplimiento to set
	 */
	public void setAcincumplimiento(String acincumplimiento) {
		this.acincumplimiento = acincumplimiento;
	}

	/**
	 * @return the ancodac
	 */
	public String getAncodac() {
		return ancodac;
	}

	/**
	 * @param ancodac
	 *            the ancodac to set
	 */
	public void setAncodac(String ancodac) {
		this.ancodac = ancodac;
	}

	/**
	 * @return the accoorganismoorigen
	 */
	public String getAccoorganismoorigen() {
		return accoorganismoorigen;
	}

	/**
	 * @param accoorganismoorigen
	 *            the accoorganismoorigen to set
	 */
	public void setAccoorganismoorigen(String accoorganismoorigen) {
		this.accoorganismoorigen = accoorganismoorigen;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override()
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ accodigo: ").append(this.accodigo).append(" ]");
		result.append(", [ accoor: ").append(this.accoor).append(" ]");
		result.append(", [ acnror: ").append(this.acnror).append(" ]");
		result.append(", [ acnran: ").append(this.acnran).append(" ]");
		result.append(", [ accoinun: ").append(this.accoinun).append(" ]");
		result.append(", [ accoindo: ").append(this.accoindo).append(" ]");
		result.append(", [ acfele: ").append(this.acfele).append(" ]");
		result.append(", [ acfere: ").append(this.acfere).append(" ]");
		result.append(", [ accoes: ").append(this.accoes).append(" ]");
		result.append(", [ accoav: ").append(this.accoav).append(" ]");
		result.append(", [ accose: ").append(this.accose).append(" ]");
		result.append(", [ acfeex: ").append(this.acfeex).append(" ]");
		result.append(", [ acinre: ").append(this.acinre).append(" ]");
		result.append(", [ acnoco: ").append(this.acnoco).append(" ]");
		result.append(", [ acdnico: ").append(this.acdnico).append(" ]");
		result.append(", [ accoco: ").append(this.accoco).append(" ]");
		result.append(", [ acdirco: ").append(this.acdirco).append(" ]");
		result.append(", [ accoloco: ").append(this.accoloco).append(" ]");
		result.append(", [ acnrcpco: ").append(this.acnrcpco).append(" ]");
		result.append(", [ acnrtfco: ").append(this.acnrtfco).append(" ]");
		result.append(", [ accotd: ").append(this.accotd).append(" ]");
		result.append(", [ acnoraPaisId: ").append(this.acnoraPaisId).append(" ]");
		result.append(", [ acnoraPaisNombre: ").append(this.acnoraPaisNombre).append(" ]");
		result.append(", [ acnoraProvinciaId: ").append(this.acnoraProvinciaId).append(" ]");
		result.append(", [ acnombreProvincia: ").append(this.acnombreProvincia).append(" ]");
		result.append(", [ acnoraMunicipioId: ").append(this.acnoraMunicipioId).append(" ]");
		result.append(", [ acnombreMunicipio: ").append(this.acnombreMunicipio).append(" ]");
		result.append(", [ acnoraLocalidadId: ").append(this.acnoraLocalidadId).append(" ]");
		result.append(", [ acnombreLocalidad: ").append(this.acnombreLocalidad).append(" ]");
		result.append(", [ acnoraCalleId: ").append(this.acnoraCalleId).append(" ]");
		result.append(", [ acnombreCalle: ").append(this.acnombreCalle).append(" ]");
		result.append(", [ acnoraCpId: ").append(this.acnoraCpId).append(" ]");
		result.append(", [ acnombreCp: ").append(this.acnombreCp).append(" ]");
		result.append(", [ acnoraPortalId: ").append(this.acnoraPortalId).append(" ]");
		result.append(", [ acnombrePortal: ").append(this.acnombrePortal).append(" ]");
		result.append(", [ acnombrePiso: ").append(this.acnombrePiso).append(" ]");
		result.append(", [ acdireccionNocapv: ").append(this.acdireccionNocapv).append(" ]");
		result.append(", [ acape1co: ").append(this.acape1co).append(" ]");
		result.append(", [ acape2co: ").append(this.acape2co).append(" ]");
		result.append(", [ accodexpedienteorigen: ").append(this.accodexpedienteorigen).append(" ]");
		result.append(", [ accoororigen: ").append(this.accoororigen).append(" ]");
		result.append("}");
		return result.toString();
	}
}
