package com.ejie.y41b.model;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.ejie.y41b.validation.Y41bNifNieCif;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hibernate.validator.constraints.NotEmpty;

/**
 * Aacc  
 * 
 *  
 */

public class AaccEuskadi implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	// filter
	private String numRegistro;
	private String nif;
	private String nombre;
	private String provinciaId;
	private String municipioId;
	private String localidadId;
	private String checkAsociacion;
	private String checkCooperativa;
	private String checkFederacion;
	private String checkConfederacion;
	private String checkBaja;

	private String nombreEs;
	private String nombreEu;

	// new
	private String aeNumRegistro;
	private String aeTipoOrg;
	private Date aeFechaBaja;
	private Date aeFechaAlta;
	private Date aeFechaUltMod;
	private String aeUsuUltMod;
	private String aeUsuUltModNb;
	private String aeCodigo; // codigo de organismo (codOrg)
	private String aeServPresencial;
	private String aeServTelematica;
	private String aeServTelefono;
	private String aeServUrl;
	private String aeNaturalezaFederacion;
	private String aeTotalSocios;
	private String aeAmbitoFuncional;

	// from org - entidad
	private String aeActiva;
	private String aeNif;
	private String aeNombreEs;
	private String aeNombreEu;
	private String aeTerritorio;
	private String aeMunicipio;
	private String aeDireccion;
	private String aePortal;
	private String aeCompledirec;

	// org full
	private Organismo organismo;

	private Contacto contacto;

	/**
	 * Method 'AaccEuskadi'.
	 */
	public AaccEuskadi() {
	}

	/**
	 * Method 'AaccEuskadi'.
	 * 
	 * @param aeNumRegistro
	 *            String
	 * @param aeTipoOrg
	 *            String
	 * @param aeFechaBaja
	 *            Date
	 * @param aeActiva
	 *            String
	 * @param aeCodigo
	 *            String
	 * @param aeNif
	 *            String
	 * @param aeNombreEs
	 *            String
	 * @param aeNombreEu
	 *            String
	 * @param aeTerritorio
	 *            String
	 * @param aeMunicipio
	 *            String
	 * @param aeDireccion
	 *            String
	 * @param aePortal
	 *            String
	 * @param aeCompledirec
	 *            String
	 * @param aeNaturalezaFederacion
	 *            String
	 */
	public AaccEuskadi(String aeNumRegistro, String aeTipoOrg, Date aeFechaBaja, String aeActiva, String aeCodigo,
			String aeNif, String aeNombreEs, String aeNombreEu, String aeTerritorio, String aeMunicipio,
			String aeDireccion, String aePortal, String aeCompledirec, String aeNaturalezaFederacion) {
		this.aeNumRegistro = aeNumRegistro;
		this.aeTipoOrg = aeTipoOrg;
		this.aeFechaBaja = aeFechaBaja;

		this.aeActiva = aeActiva;
		this.aeCodigo = aeCodigo;
		this.aeNif = aeNif;
		this.aeNombreEs = aeNombreEs;
		this.aeNombreEu = aeNombreEu;
		this.aeTerritorio = aeTerritorio;
		this.aeMunicipio = aeMunicipio;
		this.aeDireccion = aeDireccion;
		this.aePortal = aePortal;
		this.aeCompledirec = aeCompledirec;
		this.aeNaturalezaFederacion = aeNaturalezaFederacion;
	}

	/**
	 * Method 'AaccEuskadi'.
	 * 
	 * @param aeNumRegistro
	 *            String
	 * @param aeCodigo
	 *            String
	 * @param aeTipoOrg
	 *            Date
	 * @param aeServPresencial
	 *            String
	 * @param aeServTelematica
	 *            String
	 * @param aeServTelefono
	 *            String
	 * @param aeServUrl
	 *            String
	 * @param aeFechaAlta
	 *            Date
	 * @param aeFechaBaja
	 *            Date
	 * @param aeFechaUltMod
	 *            Date
	 * @param aeUsuUltModNb
	 *            String
	 * @param aeNaturalezaFederacion
	 *            String
	 * @param aeTotalSocios
	 *            String
	 * @param aeAmbitoFuncional
	 *            String
	 */
	public AaccEuskadi(String aeNumRegistro, String aeCodigo, String aeTipoOrg, String aeServPresencial,
			String aeServTelematica, String aeServTelefono, String aeServUrl, Date aeFechaAlta, Date aeFechaBaja,
			Date aeFechaUltMod, String aeUsuUltModNb, String aeNaturalezaFederacion, String aeTotalSocios,
			String aeAmbitoFuncional) {
		this.aeNumRegistro = aeNumRegistro;
		this.aeCodigo = aeCodigo;
		this.aeTipoOrg = aeTipoOrg;
		this.aeServPresencial = aeServPresencial;
		this.aeServTelematica = aeServTelematica;
		this.aeServTelefono = aeServTelefono;
		this.aeServUrl = aeServUrl;
		this.aeFechaAlta = aeFechaAlta;
		this.aeFechaBaja = aeFechaBaja;
		this.aeFechaUltMod = aeFechaUltMod;
		this.aeUsuUltModNb = aeUsuUltModNb;
		this.aeNaturalezaFederacion = aeNaturalezaFederacion;
		this.aeTotalSocios = aeTotalSocios;
		this.aeAmbitoFuncional = aeAmbitoFuncional;
	}

	/**
	 * @return the numRegistro
	 */
	public String getNumRegistro() {
		return numRegistro;
	}

	/**
	 * @param numRegistro
	 *            the numRegistro to set
	 */
	public void setNumRegistro(String numRegistro) {
		this.numRegistro = numRegistro;
	}

	/**
	 * @return the nif
	 */
	public String getNif() {
		return nif;
	}

	/**
	 * @param nif
	 *            the nif to set
	 */
	public void setNif(String nif) {
		this.nif = nif;
	}

	/**
	 * @return the nombre
	 */
	public String getNombre() {
		return nombre;
	}

	/**
	 * @param nombre
	 *            the nombre to set
	 */
	public void setNombre(String nombre) {
		this.nombre = nombre;
	}

	/**
	 * @return the provinciaId
	 */
	public String getProvinciaId() {
		return provinciaId;
	}

	/**
	 * @param provinciaId
	 *            the provinciaId to set
	 */
	public void setProvinciaId(String provinciaId) {
		this.provinciaId = provinciaId;
	}

	/**
	 * @return the municipioId
	 */
	public String getMunicipioId() {
		return municipioId;
	}

	/**
	 * @param municipioId
	 *            the municipioId to set
	 */
	public void setMunicipioId(String municipioId) {
		this.municipioId = municipioId;
	}

	/**
	 * @return the localidadId
	 */
	public String getLocalidadId() {
		return localidadId;
	}

	/**
	 * @param localidadId
	 *            the localidadId to set
	 */
	public void setLocalidadId(String localidadId) {
		this.localidadId = localidadId;
	}

	/**
	 * @return the checkAsociacion
	 */
	public String getCheckAsociacion() {
		return checkAsociacion;
	}

	/**
	 * @param checkAsociacion
	 *            the checkAsociacion to set
	 */
	public void setCheckAsociacion(String checkAsociacion) {
		this.checkAsociacion = checkAsociacion;
	}

	/**
	 * @return the checkCooperativa
	 */
	public String getCheckCooperativa() {
		return checkCooperativa;
	}

	/**
	 * @param checkCooperativa
	 *            the checkCooperativa to set
	 */
	public void setCheckCooperativa(String checkCooperativa) {
		this.checkCooperativa = checkCooperativa;
	}

	/**
	 * @return the checkFederacion
	 */
	public String getCheckFederacion() {
		return checkFederacion;
	}

	/**
	 * @param checkFederacion
	 *            the checkFederacion to set
	 */
	public void setCheckFederacion(String checkFederacion) {
		this.checkFederacion = checkFederacion;
	}

	/**
	 * @return the checkConfederacion
	 */
	public String getCheckConfederacion() {
		return checkConfederacion;
	}

	/**
	 * @param checkConfederacion
	 *            the checkConfederacion to set
	 */
	public void setCheckConfederacion(String checkConfederacion) {
		this.checkConfederacion = checkConfederacion;
	}

	/**
	 * @return the checkBaja
	 */
	public String getCheckBaja() {
		return checkBaja;
	}

	/**
	 * @param checkBaja
	 *            the checkBaja to set
	 */
	public void setCheckBaja(String checkBaja) {
		this.checkBaja = checkBaja;
	}

	/**
	 * @return the nombreEs
	 */
	public String getNombreEs() {
		return nombreEs;
	}

	/**
	 * @param nombreEs
	 *            the nombreEs to set
	 */
	public void setNombreEs(String nombreEs) {
		this.nombreEs = nombreEs;
	}

	/**
	 * @return the nombreEu
	 */
	public String getNombreEu() {
		return nombreEu;
	}

	/**
	 * @param nombreEu
	 *            the nombreEu to set
	 */
	public void setNombreEu(String nombreEu) {
		this.nombreEu = nombreEu;
	}

	/**
	 * @return the aeNumRegistro
	 */
	public String getAeNumRegistro() {
		return aeNumRegistro;
	}

	/**
	 * @param aeNumRegistro
	 *            the aeNumRegistro to set
	 */
	public void setAeNumRegistro(String aeNumRegistro) {
		this.aeNumRegistro = aeNumRegistro;
	}

	/**
	 * @return the aeTipoOrg
	 */
	public String getAeTipoOrg() {
		return aeTipoOrg;
	}

	/**
	 * @param aeTipoOrg
	 *            the aeTipoOrg to set
	 */
	public void setAeTipoOrg(String aeTipoOrg) {
		this.aeTipoOrg = aeTipoOrg;
	}

	/**
	 * @return the aeFechaBaja
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getAeFechaBaja() {
		return aeFechaBaja;
	}

	/**
	 * @param aeFechaBaja
	 *            the aeFechaBaja to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setAeFechaBaja(Date aeFechaBaja) {
		this.aeFechaBaja = aeFechaBaja;
	}

	/**
	 * @return the aeFechaAlta
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getAeFechaAlta() {
		return aeFechaAlta;
	}

	/**
	 * @param aeFechaAlta
	 *            the aeFechaAlta to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setAeFechaAlta(Date aeFechaAlta) {
		this.aeFechaAlta = aeFechaAlta;
	}

	/**
	 * @return the aeFechaUltMod
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getAeFechaUltMod() {
		return aeFechaUltMod;
	}

	/**
	 * @param aeFechaUltMod
	 *            the aeFechaUltMod to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setAeFechaUltMod(Date aeFechaUltMod) {
		this.aeFechaUltMod = aeFechaUltMod;
	}

	/**
	 * @return the aeUsuUltMod
	 */
	public String getAeUsuUltMod() {
		return aeUsuUltMod;
	}

	/**
	 * @param aeUsuUltMod
	 *            the aeUsuUltMod to set
	 */
	public void setAeUsuUltMod(String aeUsuUltMod) {
		this.aeUsuUltMod = aeUsuUltMod;
	}

	/**
	 * @return the aeUsuUltModNb
	 */
	public String getAeUsuUltModNb() {
		return aeUsuUltModNb;
	}

	/**
	 * @param aeUsuUltModNb
	 *            the aeUsuUltModNb to set
	 */
	public void setAeUsuUltModNb(String aeUsuUltModNb) {
		this.aeUsuUltModNb = aeUsuUltModNb;
	}

	/**
	 * @return the aeActiva
	 */
	public String getAeActiva() {
		return aeActiva;
	}

	/**
	 * @param aeActiva
	 *            the aeActiva to set
	 */
	public void setAeActiva(String aeActiva) {
		this.aeActiva = aeActiva;
	}

	/**
	 * @return the aeCodigo
	 */
	public String getAeCodigo() {
		return aeCodigo;
	}

	/**
	 * @param aeCodigo
	 *            the aeCodigo to set
	 */
	public void setAeCodigo(String aeCodigo) {
		this.aeCodigo = aeCodigo;
	}

	/**
	 * @return the aeServPresencial
	 */
	public String getAeServPresencial() {
		return aeServPresencial;
	}

	/**
	 * @param aeServPresencial
	 *            the aeServPresencial to set
	 */
	public void setAeServPresencial(String aeServPresencial) {
		this.aeServPresencial = aeServPresencial;
	}

	/**
	 * @return the aeServTelematica
	 */
	public String getAeServTelematica() {
		return aeServTelematica;
	}

	/**
	 * @param aeServTelematica
	 *            the aeServTelematica to set
	 */
	public void setAeServTelematica(String aeServTelematica) {
		this.aeServTelematica = aeServTelematica;
	}

	/**
	 * @return the aeServTelefono
	 */
	public String getAeServTelefono() {
		return aeServTelefono;
	}

	/**
	 * @param aeServTelefono
	 *            the aeServTelefono to set
	 */
	public void setAeServTelefono(String aeServTelefono) {
		this.aeServTelefono = aeServTelefono;
	}

	/**
	 * @return the aeServUrl
	 */
	public String getAeServUrl() {
		return aeServUrl;
	}

	/**
	 * @param aeServUrl
	 *            the aeServUrl to set
	 */
	public void setAeServUrl(String aeServUrl) {
		this.aeServUrl = aeServUrl;
	}

	/**
	 * @return the aeNaturalezaFederacion
	 */
	public String getAeNaturalezaFederacion() {
		return aeNaturalezaFederacion;
	}

	/**
	 * @param aeNaturalezaFederacion
	 *            the aeNaturalezaFederacion to set
	 */
	public void setAeNaturalezaFederacion(String aeNaturalezaFederacion) {
		this.aeNaturalezaFederacion = aeNaturalezaFederacion;
	}

	/**
	 * @return the aeTotalSocios
	 */
	public String getAeTotalSocios() {
		return aeTotalSocios;
	}

	/**
	 * @param aeTotalSocios
	 *            the aeTotalSocios to set
	 */
	public void setAeTotalSocios(String aeTotalSocios) {
		this.aeTotalSocios = aeTotalSocios;
	}

	/**
	 * @return the aeAmbitoFuncional
	 */
	public String getAeAmbitoFuncional() {
		return aeAmbitoFuncional;
	}

	/**
	 * @param aeAmbitoFuncional
	 *            the aeAmbitoFuncional to set
	 */
	public void setAeAmbitoFuncional(String aeAmbitoFuncional) {
		this.aeAmbitoFuncional = aeAmbitoFuncional;
	}

	/**
	 * @return the aeNif
	 */
	public String getAeNif() {
		return aeNif;
	}

	/**
	 * @param aeNif
	 *            the aeNif to set
	 */
	public void setAeNif(String aeNif) {
		this.aeNif = aeNif;
	}

	/**
	 * @return the aeNombreEs
	 */
	public String getAeNombreEs() {
		return aeNombreEs;
	}

	/**
	 * @param aeNombreEs
	 *            the aeNombreEs to set
	 */
	public void setAeNombreEs(String aeNombreEs) {
		this.aeNombreEs = aeNombreEs;
	}

	/**
	 * @return the aeNombreEu
	 */
	public String getAeNombreEu() {
		return aeNombreEu;
	}

	/**
	 * @param aeNombreEu
	 *            the aeNombreEu to set
	 */
	public void setAeNombreEu(String aeNombreEu) {
		this.aeNombreEu = aeNombreEu;
	}

	/**
	 * @return the aeTerritorio
	 */
	public String getAeTerritorio() {
		return aeTerritorio;
	}

	/**
	 * @param aeTerritorio
	 *            the aeTerritorio to set
	 */
	public void setAeTerritorio(String aeTerritorio) {
		this.aeTerritorio = aeTerritorio;
	}

	/**
	 * @return the aeMunicipio
	 */
	public String getAeMunicipio() {
		return aeMunicipio;
	}

	/**
	 * @param aeMunicipio
	 *            the aeMunicipio to set
	 */
	public void setAeMunicipio(String aeMunicipio) {
		this.aeMunicipio = aeMunicipio;
	}

	/**
	 * @return the aeDireccion
	 */
	public String getAeDireccion() {
		return aeDireccion;
	}

	/**
	 * @param aeDireccion
	 *            the aeDireccion to set
	 */
	public void setAeDireccion(String aeDireccion) {
		this.aeDireccion = aeDireccion;
	}

	/**
	 * @return the aePortal
	 */
	public String getAePortal() {
		return aePortal;
	}

	/**
	 * @param aePortal
	 *            the aePortal to set
	 */
	public void setAePortal(String aePortal) {
		this.aePortal = aePortal;
	}

	/**
	 * @return the aeCompledirec
	 */
	public String getAeCompledirec() {
		return aeCompledirec;
	}

	/**
	 * @param aeCompledirec
	 *            the aeCompledirec to set
	 */
	public void setAeCompledirec(String aeCompledirec) {
		this.aeCompledirec = aeCompledirec;
	}

	/**
	 * @return the organismo
	 */
	public Organismo getOrganismo() {
		return organismo;
	}

	/**
	 * @param organismo
	 *            the organismo to set
	 */
	public void setOrganismo(Organismo organismo) {
		this.organismo = organismo;
	}

	/**
	 * @return the contacto
	 */
	public Contacto getContacto() {
		return contacto;
	}

	/**
	 * @param contacto
	 *            the contacto to set
	 */
	public void setContacto(Contacto contacto) {
		this.contacto = contacto;
	}

}
