package com.ejie.y41b.log;

import java.util.Hashtable;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.LayoutBase;
import ch.qos.logback.core.LogbackException;

import com.ejie.x38.util.DateTimeManager;
import com.ejie.x38.util.TableManager;

public class Y41bLogLayout extends LayoutBase<ILoggingEvent> {

	public String doLayout(ILoggingEvent event) throws LogbackException {

		try {

			Hashtable table = TableManager.initTable();

			table.put("datetime", DateTimeManager.getDateTime());
			// table.put("appCode", (this.appCode != null) ? this.appCode : "");
			// table.put("thread", ThreadStorageManager.getCurrentThreadId());
			table.put("loggerClass", event.getLoggerName());
			// table.put("serverInstance", (this.instance != null) ?
			// this.instance: "");
			table.put("criticality",
					(event.getLevel() != null) ? event.getLevel() : "");
			table.put("message",
					(event.getMessage() != null) ? event.getMessage() : "");

			StringBuffer sbuf = new StringBuffer(1023);
			sbuf.append("##| ");
			for (String param : Y41bLogConstants.parameters) {
				String campo = "";
				if (table.get(param) != null
						&& table.get(param) instanceof String) {
					campo = (String) table.get(param);
					sbuf.append(("".equals(campo)) ? "" : " ~~ ");
				}
				sbuf.append(campo);

			}
			sbuf.append(" |##");
			sbuf.append("\r\n");
			return sbuf.toString();
		} catch (LogbackException lbe) {
			throw lbe;
		} catch (Exception e) {
			throw new LogbackException(
					"System error logs. Error creating the log trace.", e);
		}
	}
}
