package com.ejie.y41b.log;

import java.util.Hashtable;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger.Level;

import com.ejie.x38.log.LoggingManager;
import com.ejie.x38.util.StackTraceManager;
import com.ejie.x38.util.TableManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

public class Y41bIncidenceLoggingAdviceImpl implements
		Y41bIncidenceLoggingAdvice {
	private static final Logger logger = LoggerFactory
			.getLogger(Y41bIncidenceLoggingAdviceImpl.class);

	private LoggingManager loggingManager;

	/**
	 * logIncidence
	 */
	public void logIncidence(Object target, Exception exception) {

		Exception exceptionFinal = null;
		if (exception instanceof Y41bUDAException
				&& null != ((Y41bUDAException) exception).getException()) {

			exceptionFinal = (Exception) ((Y41bUDAException) exception)
					.getException();
		} else {
			exceptionFinal = exception;
		}
		Hashtable<String, String> table = TableManager.initTable();
		table.put(Y41bLogConstants.CRITICALITY, Level.ERROR.toString());
		table.put(Y41bLogConstants.FUNCTIONALSUBSYSTEM,
				Y41bLogConstants.INCIDENCESUBSYSTEM);
		table.put(Y41bLogConstants.ADITIONALINFO,
				StackTraceManager.getStackTrace(exceptionFinal));
		if (exceptionFinal.getMessage() != null) {
			table.put(Y41bLogConstants.MESSAGE, exceptionFinal.getMessage());
		}
		loggingManager
				.logIncidences(target.getClass().getName(), logger, table);
	}

	// Getters & Setters
	public LoggingManager getLoggingManager() {
		return loggingManager;
	}

	public void setLoggingManager(LoggingManager loggingManager) {
		this.loggingManager = loggingManager;
	}
}
