package com.ejie.y41b.jms.helper;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.bea.xml.XmlException;
import com.ejie.notification.xml.NotificationBodyDocument;
import com.ejie.notification.xml.NotificationBodyDocument.NotificationBody.Property;
import com.ejie.y41b.constantes.Y41bJMSConstantes;

/**
 * Y41bJMSHelper
 * 
 *  
 * 
 */
public class Y41bJMSHelper {
	private static final Logger logger = LoggerFactory
			.getLogger(Y41bJMSHelper.class);

	/**
	 * Constructor
	 */
	private Y41bJMSHelper() {
		super();
	}

	/**
	 * Parsea un xml y retorna un Map donde el key es el property del xml y el
	 * value es el value
	 * 
	 * @param strPfMensaje
	 *            String
	 * @return mapa Map
	 */
	public static Map parsearMensajeJms(final String strPfMensaje) {
		final StringReader readerMensaje = new StringReader(strPfMensaje);
		Property arrProperties[] = null;
		final HashMap mapaMensaje = new HashMap();
		try {
			NotificationBodyDocument mensaje = NotificationBodyDocument.Factory
					.parse(readerMensaje);
			arrProperties = mensaje.getNotificationBody().getPropertyArray();

			Pattern p = Pattern.compile(Y41bJMSConstantes.REG_EXP_CDATA);

			Y41bJMSHelper.logger.debug("Regular expression: "
					+ Y41bJMSConstantes.REG_EXP_CDATA);

			for (int i = 0; i < arrProperties.length; i++) {
				String valor = "";
				if (arrProperties[i].getValueArray(0) != null) {
					valor = arrProperties[i].getValueArray(0).toString();

					final Matcher m = p.matcher(valor);
					if (m.matches()) {
						valor = m.group(2);
					}
				}
				mapaMensaje.put(arrProperties[i].getName(), valor);
			}

			Y41bJMSHelper.logger.debug("folderNumber ::: "
					+ mapaMensaje.get("folderNumber"));
			Y41bJMSHelper.logger.debug("documents ::: "
					+ mapaMensaje.get("documents"));
			Y41bJMSHelper.logger.debug("mapaMensaje: " + mapaMensaje);

		} catch (final XmlException e1) {
			Y41bJMSHelper.logger.error("PlateaXmlParser.parsearMensajeJms()",
					e1);
			Y41bJMSHelper.logger
					.error("PlateaXmlParser.parsearMensajeJms() -Error parseando mensaje JMS.",
							e1);
		} catch (final IOException e1) {
			Y41bJMSHelper.logger.error("PlateaXmlParser.parsearMensajeJms()",
					e1);
			Y41bJMSHelper.logger
					.error("PlateaXmlParser.parsearMensajeJms() -Error parseando mensaje JMS.",
							e1);
		}

		return mapaMensaje;
	}
}