package com.ejie.y41b.jms;

import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

import javax.annotation.Resource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.bea.xml.XmlObject;
import com.ejie.ctfm.xml.DocumentBODocument.DocumentBO;
import com.ejie.ctfm.xml.DocumentsBODocument;
import com.ejie.ctfm.xml.DocumentsBODocument.DocumentsBO;
import com.ejie.horizontalSystemOfNotification.xml.DeliveredNotificationInfoDocument;
import com.ejie.horizontalSystemOfNotification.xml.DeliveredNotificationInfoDocument.DeliveredNotificationInfo;
import com.ejie.y41b.adapter.Y41bDokusiAdapterService;
import com.ejie.y41b.adapter.Y41bPlateaAdapterService;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.constantes.Y41bJMSConstantes;
import com.ejie.y41b.dao.ActuacionDao;
import com.ejie.y41b.dao.ArbadhtramDao;
import com.ejie.y41b.dao.ArbtramexpDao;
import com.ejie.y41b.dao.HechoDenunciadoDao;
import com.ejie.y41b.dao.SantramexpDao;
import com.ejie.y41b.dao.TramiteHechoDao;
import com.ejie.y41b.dao.TramiteInspeccionDao;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.AdhesionTele;
import com.ejie.y41b.model.Arbadhsol;
import com.ejie.y41b.model.Arbadhtram;
import com.ejie.y41b.model.Arbexp;
import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.DocumentoSolicitudTelematicaEventos;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.HechoDenunciado;
import com.ejie.y41b.model.InspeccionDetalle;
import com.ejie.y41b.model.Mensajecola;
import com.ejie.y41b.model.NotificacionAcuseRecibo;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.model.Santramexp;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.SolicitudTelematicaEventos;
import com.ejie.y41b.model.TramiteHecho;
import com.ejie.y41b.model.TramiteInspeccion;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.User;
import com.ejie.y41b.model.platea.Contact;
import com.ejie.y41b.model.platea.ContextSubmission;
import com.ejie.y41b.model.platea.DatosPersona;
import com.ejie.y41b.model.platea.DatosRegistro;
import com.ejie.y41b.model.platea.InterestedRRI;
import com.ejie.y41b.model.platea.MensajeAportacionDocumentacion;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.model.platea.RepresentativeRRI;
import com.ejie.y41b.model.platea.SolicitudTelematica;
import com.ejie.y41b.service.ArbadhsolService;
import com.ejie.y41b.service.ArbadhtramService;
import com.ejie.y41b.service.ArbsolteleService;
import com.ejie.y41b.service.Arbtramexp2Service;
import com.ejie.y41b.service.Arbtramexp3Service;
import com.ejie.y41b.service.Arbtramexp4Service;
import com.ejie.y41b.service.CensoMonitorService;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.InspeccionService;
import com.ejie.y41b.service.InstramexpService;
import com.ejie.y41b.service.MensajecolaService;
import com.ejie.y41b.service.ParametrosService;
import com.ejie.y41b.service.SantramexpService;
import com.ejie.y41b.service.SolarbService;
import com.ejie.y41b.service.SolicitudesTelematicasEventosService;
import com.ejie.y41b.service.SoltramexpService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.xml.Y41bXMLUtils;
import com.ejie.y41b.ws.cliente.x43notificaciones.TNotification;

/**
 * Y41bTratamientoPlateaJMSServiceImpl Clase encargada del tratamiento de los
 * mensajes recibidos en la cola JMS para PLATEA
 * 
 * Los metodos deberian ser TRANSACCIONALES del tipo "propagation =
 * Propagation.REQUIRES_NEW" para que no participe de ninguna transaccion global
 * y no de problemas de reenvio del mensaje a la cola.
 * 
 *  
 * 
 */
@Service(value = "y41bTratamientoPlateaJMSService")
public class Y41bTratamientoPlateaJMSServiceImpl implements Y41bTratamientoPlateaJMSService {
	private static final Logger logger = LoggerFactory.getLogger(Y41bTratamientoPlateaJMSServiceImpl.class);

	@Autowired()
	private Y41bPlateaAdapterService y41bPlateaAdapterService;
	@Autowired
	private Y41bDokusiAdapterService y41bDokusiAdapterService;

	@Autowired
	private DenunciaService denunciaService;

	@Autowired
	private SoltramexpService soltramexpService;

	@Autowired
	private SantramexpService santramexpService;

	@Autowired
	private TramiteHechoDao tramiteHechoDao;

	@Autowired
	private SantramexpDao santramexpDao;

	@Autowired
	private HechoDenunciadoDao hechoDenunciadoDao;

	@Autowired
	private MensajecolaService mensajecolaService;

	@Autowired
	private ArbadhsolService arbadhsolService;

	@Autowired
	private ArbsolteleService arbsolteleService;
	@Autowired
	private SolarbService solarbService;
	@Autowired
	private SolicitudesTelematicasEventosService solicitudesTelematicasEventosService;

	@Autowired
	private ArbtramexpDao arbtramexpDao;
	@Autowired
	private Arbtramexp3Service arbtramexp3Service;
	@Autowired
	private Arbtramexp2Service arbtramexp2Service;
	@Autowired
	private Arbtramexp4Service arbtramexp4Service;

	@Autowired
	private ArbadhtramService arbadhtramService;
	@Autowired
	private ArbadhtramDao arbadhtramDao;

	@Autowired()
	private InspeccionService inspeccionService;

	@Autowired()
	private InstramexpService instramexpService;

	@Autowired()
	private TramiteInspeccionDao tramiteInspeccionDao;

	@Autowired()
	private ActuacionDao actuacionDao;

	@Autowired()
	private ParametrosService parametrosService;

	@Autowired()
	private CensoMonitorService censoMonitorService;

	@Resource
	ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Constructor privado
	 */
	private Y41bTratamientoPlateaJMSServiceImpl() {
		super();
	}

	/**
	 * tratamientoSolicitudes
	 * 
	 * @param stPfToken
	 *            token
	 * @param mapaMensaje
	 *            mensaje
	 * @throws Exception
	 *             Cualquier excepcion
	 */
	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Throwable.class)
	public void tratamientoSolicitudes(String stPfToken, Map mapaMensaje, String mensajeCola) throws Exception {
		Y41bTratamientoPlateaJMSServiceImpl.logger
				.info("Y41bTratamientoPlateaJMSServiceImpl.tratamientoSolicitudes - Inicio");
		ContextSubmission contextSubmission = null;
		DocumentsBO documents = null;
		boolean expedienteYaExiste = false;
		try {
			// 1.1. Recuperamos el contextSubmission
			contextSubmission = this.getContextSubmissionFromSolicitud(mapaMensaje);
			// 1.2. Recuperamos los documentos
			documents = this.getDocumentsBOFromSolicitud(mapaMensaje);
			List<Documento> listDocumento = this.getDocumentsByDocumentsBO(documents);

			// TODO 2. Aqui se llamaría al método que actualiza en Base de
			// Datos
			// para
			// recoger la info de la solicitud telematica y volcarla en el censo
			// Para ello basta con usar el registryNumber como identificador de
			// la solicitud y el idProcedimiento para saber a que tablas ir
			String registryNumber = (String) mapaMensaje.get("registryNumber");
			String registryTimestamp = (String) mapaMensaje.get("registryTimestamp");
			String solicitudID = (String) mapaMensaje.get("solicitudID");

			Y41bTratamientoPlateaJMSServiceImpl.logger
					.info("Y41bTratamientoPlateaJMSServiceImpl.tratamientoSolicitudes - solicitudID:" + solicitudID);

			String procedureId = contextSubmission.getProcedureID();
			String numExpediente = null;
			Y41bTratamientoPlateaJMSServiceImpl.logger
					.info("Y41bTratamientoPlateaJMSServiceImpl.tratamientoSolicitudes - Se haria el proceso para el procedimiento:"
							+ procedureId);

			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();

			if (Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES.equals(procedureId)) {
				solicitudDetalle.setNumregistroentrada(registryNumber);

				SolicitudDetalle solDetalleRegistryNumber = this.denunciaService
						.findSolicitudByRegistryNumber(solicitudDetalle, null);

				// // prueba forzada eliminar
				// solicitudDetalle =
				// this.denunciaService.enviarSolicitudTelematica(solicitudDetalle,
				// contextSubmission,
				// solicitudID, listDocumento);
				// // 

				if (solDetalleRegistryNumber == null || !Y41bUtils.isFilled(solDetalleRegistryNumber.getHdcodigo())) {
					solicitudDetalle = this.denunciaService.enviarSolicitudTelematica(solicitudDetalle,
							contextSubmission, solicitudID, listDocumento);

					// crear el numero de expediente
					numExpediente = solicitudDetalle.getNumExpediente();
				} else {
					numExpediente = solDetalleRegistryNumber.getNumExpediente();
					expedienteYaExiste = true;
				}
			} else if (Y41bConstantes.ID_PROCEDIMIENTO_ADHALTA.equals(procedureId)
					|| Y41bConstantes.ID_PROCEDIMIENTO_ADHBAJA.equals(procedureId)
					|| Y41bConstantes.ID_PROCEDIMIENTO_ADHMODIF.equals(procedureId)) {

				// crear el numero de expediente
				// numExpediente = solicitudDetalle.getNumExpediente();
				AdhesionTele solicitudAdhTele = new AdhesionTele();
				solicitudAdhTele.setAdhsolregen(registryNumber);

				Arbadhsol solicitudAdh = new Arbadhsol();
				solicitudAdh = this.arbadhsolService.recibirSolicitudTelematica(solicitudAdhTele, listDocumento);

				numExpediente = solicitudAdh.getNumExpediente();

				// limpiar las solicitudes que se hayan podido quedar antiguas,
				// sin terminar de registrar hace ms de 1 semana
				this.arbadhsolService.limpiarTemporalesTelematicasAntiguas();

			} else if (Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE.equals(procedureId)) {
				// Buscar la telemtica por nmero de registro.
				Arbexp arbexp = new Arbexp();
				arbexp.setExregen(registryNumber);

				Solarb solarb = new Solarb();
				solarb.setArbexp(arbexp);

				solarb = this.solarbService.findArbitrajeByRegistryNumber(solarb);

				if (solarb == null || !Y41bUtils.isFilled(solarb.getSacodigo())) {
					arbexp = new Arbexp();
					arbexp.setExregen(registryNumber);

					arbexp.setExfecreg(Y41bUtils.formatearStringToDateFormato(registryTimestamp,
							Y41bConstantes.FORMATO_FECHAHORA_TOOLKIT));
					// Formatear fecha aa-mm-yyyy a yyyymmaa
					solarb = this.arbsolteleService.recibirSolicitudTelematica(arbexp, contextSubmission, listDocumento,
							solicitudID);

					// crear el numero de expediente
					numExpediente = solarb.getNumExpediente();
				} else {
					numExpediente = solarb.getNumExpediente();
					expedienteYaExiste = true;
				}

			}

			if (numExpediente != null) {
				if (!Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE.equals(procedureId)) {
					if (!expedienteYaExiste) {
						// 3. Realizamos la apertura del expediente en PLATEA

						SolicitudTelematica solicitudTelematica = null;
						if (Y41bConstantes.ID_PROCEDIMIENTO_ADHALTA.equals(procedureId)
								|| Y41bConstantes.ID_PROCEDIMIENTO_ADHBAJA.equals(procedureId)
								|| Y41bConstantes.ID_PROCEDIMIENTO_ADHMODIF.equals(procedureId)) {
							// Recuperamos el ContextSubmission 'antiguo'
							com.ejie.folderManagement.xml.ContextSubmissionDocument.ContextSubmission contextSubmissionOLD = null;
							contextSubmissionOLD = this.getContextSubmissionOLDFromSolicitud(mapaMensaje);
							solicitudTelematica = this.getSolicitudTelematicaAdhesiones(contextSubmissionOLD, documents,
									procedureId, numExpediente);
						} else {
							solicitudTelematica = this.getSolicitudTelematica(contextSubmission, documents, procedureId,
									numExpediente);
						}

						y41bPlateaAdapterService.crearSolicitudTelematica(solicitudTelematica);

						if (Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES.equals(procedureId)) {
							if (Y41bConstantes.VALOR_SI.equals(solicitudDetalle.getHddenunciaaaccempresas())) {
								this.enviarEmailNuevaDenunciaEmpresa(solicitudDetalle);
							}
						}

						Y41bTratamientoPlateaJMSServiceImpl.logger
								.debug("Y41bTratamientoPlateaJMSServiceImpl.tratamientoSolicitudes - registryNumber:"
										+ registryNumber);
					}
				}

			} else {
				Y41bTratamientoPlateaJMSServiceImpl.logger
						.debug("Y41bTratamientoPlateaJMSServiceImpl.tratamientoSolicitudes NO EXISTE registryNumber:"
								+ registryNumber);
				Mensajecola mensajecola = new Mensajecola();
				mensajecola = new Mensajecola();
				mensajecola.setSwnumreg(registryNumber);
				mensajecola.setSwdtipomensaje("NO_EXISTE");
				mensajecola.setSwfecreg(Y41bUtils.fncPresentarFechaSistemaTimeStamp(false));
				mensajecolaService.add(mensajecola);
			}

		} catch (Y41bUDAException e) {

			SolicitudTelematicaEventos solicitudTelematicaEventos = this.getSolicitudFromEventSolicitud(mapaMensaje,
					mensajeCola);

			solicitudTelematicaEventos = this.solicitudesTelematicasEventosService
					.addSolicitudTelematicaEventos(solicitudTelematicaEventos);

			// throw e;
		} catch (Exception e_tratamientoSolicitudes) {
			// logger.error("Y41bTratamientoPlateaJMSServiceImpl.tratamientoSolicitudes",
			// e_tratamientoSolicitudes);

			SolicitudTelematicaEventos solicitudTelematicaEventos = this.getSolicitudFromEventSolicitud(mapaMensaje,
					mensajeCola);

			solicitudTelematicaEventos = this.solicitudesTelematicasEventosService
					.addSolicitudTelematicaEventos(solicitudTelematicaEventos);

			// throw new Y41bUDAException("error.platea.invocation", true,
			// e_tratamientoSolicitudes);
		} finally {
			logger.info("Y41bTratamientoPlateaJMSServiceImpl.tratamientoSolicitudes - Final");
		}
	}

	/**
	 * tratamientoAcuses
	 * 
	 * @param stPfToken
	 *            token
	 * @param mapaMensaje
	 *            mensaje
	 * @throws Exception
	 *             Cualquier excepcion
	 */
	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Throwable.class)
	public void tratamientoAcuses(String stPfToken, Map mapaMensaje, String mensajeCola) throws Exception {
		Y41bTratamientoPlateaJMSServiceImpl.logger
				.info("Y41bTratamientoPlateaJMSServiceImpl.tratamientoAcuses - Inicio");
		try {

			String notificationId = (String) mapaMensaje.get("notificationID");
			Y41bTratamientoPlateaJMSServiceImpl.logger
					.debug("Y41bTratamientoPlateaJMSServiceImpl.tratamientoAcuses - registryNumber:" + notificationId);
			String eventWhat = (String) mapaMensaje.get(Y41bJMSConstantes.EVENT_WHAT);
			DeliveredNotificationInfo deliveredNotificationInfo = this.getAcuseFromSolicitud(mapaMensaje);
			// 1. Recupero tramite de acuse de recibo a traves del
			// ID_NOTIFICACION
			NotificacionAcuseRecibo notificacionAcuseRecibo = new NotificacionAcuseRecibo();
			notificacionAcuseRecibo.setEhidnotificacionplatea(notificationId);
			notificacionAcuseRecibo = this.tramiteHechoDao.findNotificacionAcuseRecibo(notificacionAcuseRecibo);

			Y41bTratamientoPlateaJMSServiceImpl.logger
					.debug("Y41bTratamientoPlateaJMSServiceImpl.tratamientoAcuses - notificacionAcuseRecibo:"
							+ notificacionAcuseRecibo.toString());

			String estadoTramite = null;

			TramiteHecho tramitehechoAcuse = new TramiteHecho();
			Santramexp tramiteAcuse = new Santramexp();
			Arbtramexp tramiteAcuseArb = new Arbtramexp();
			Arbadhtram tramiteAcuseAdh = new Arbadhtram();
			TramiteInspeccion tramiteinspeccionAcuse = new TramiteInspeccion();
			String tipoProcedimiento = notificacionAcuseRecibo.getEhpcodigo();
			if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(tipoProcedimiento)) {
				Y41bTratamientoPlateaJMSServiceImpl.logger
						.debug("Y41bTratamientoPlateaJMSServiceImpl.tratamientoAcuses - tipoProcedimiento:"
								+ tipoProcedimiento);
				tramitehechoAcuse.setEhcodigo(notificacionAcuseRecibo.getEhcodigoacuse());
				tramitehechoAcuse = this.tramiteHechoDao.find(tramitehechoAcuse);
				estadoTramite = tramitehechoAcuse.getEhestadotramite();
				Y41bTratamientoPlateaJMSServiceImpl.logger.debug(
						"Y41bTratamientoPlateaJMSServiceImpl.tratamientoAcuses - estadoTramite:" + estadoTramite);
			} else if (Y41bConstantes.TIPO_PROC_SANCIONES.equals(tipoProcedimiento)) {

				tramiteAcuse.setTrid(notificacionAcuseRecibo.getEhcodigoacuse());
				tramiteAcuse = this.santramexpDao.find(tramiteAcuse);
				estadoTramite = tramiteAcuse.getTrestado();
			} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(tipoProcedimiento)) {

				tramiteAcuseArb.setTrid(notificacionAcuseRecibo.getEhcodigoacuse());
				tramiteAcuseArb = this.arbtramexpDao.find(tramiteAcuseArb);
				estadoTramite = tramiteAcuseArb.getTrestado();
			} else if (Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA.equals(tipoProcedimiento)
					|| Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA.equals(tipoProcedimiento)
					|| Y41bConstantes.TIPO_PROC_ADHESIONES_MOD.equals(tipoProcedimiento)) {
				tramiteAcuseAdh.setTrid(notificacionAcuseRecibo.getEhcodigoacuse());
				tramiteAcuseAdh = this.arbadhtramDao.find(tramiteAcuseAdh);
				estadoTramite = tramiteAcuseAdh.getTrestado();
			} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(tipoProcedimiento)) {
				Y41bTratamientoPlateaJMSServiceImpl.logger
						.debug("Y41bTratamientoPlateaJMSServiceImpl.tratamientoAcuses - tipoProcedimiento:"
								+ tipoProcedimiento);
				tramiteinspeccionAcuse.setTicodigo(notificacionAcuseRecibo.getEhcodigoacuse());
				tramiteinspeccionAcuse = this.tramiteInspeccionDao.find(tramiteinspeccionAcuse);
				estadoTramite = tramiteinspeccionAcuse.getTiestadotramite();
				Y41bTratamientoPlateaJMSServiceImpl.logger.debug(
						"Y41bTratamientoPlateaJMSServiceImpl.tratamientoAcuses - estadoTramite:" + estadoTramite);
			}

			// Unicamente sigo adelante el tratamiento del acuse en caso de que
			// el acuse NO ESTE TRAMITADO
			if (!Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(estadoTramite)) {
				String situacionNotificacion = "";
				Documento justificanteAcuse = null;
				if (eventWhat.equals(Y41bJMSConstantes.NOTIFICATION_EXPIRATION)) {
					Y41bTratamientoPlateaJMSServiceImpl.logger
							.info("Y41bTratamientoPlateaJMSServiceImpl.tratamientoAcuses - Expiration");
					Y41bTratamientoPlateaJMSServiceImpl.logger
							.info("Y41bTratamientoPlateaJMSServiceImpl.tratamientoAcuses - acuse:"
									+ deliveredNotificationInfo.xmlText());
					// situacionNotificacion =
					// Y41bConstantes.SITUACION_ACUSERECIBO_NOENTREGADO;
					situacionNotificacion = Y41bConstantes.SITUACION_ACUSERECIBO_RECHAZADO;
				} else if (eventWhat.equals(Y41bJMSConstantes.NOTIFICATION_DELIVERY)) {
					Y41bTratamientoPlateaJMSServiceImpl.logger
							.info("Y41bTratamientoPlateaJMSServiceImpl.tratamientoAcuses - Delivery");
					Y41bTratamientoPlateaJMSServiceImpl.logger
							.info("Y41bTratamientoPlateaJMSServiceImpl.tratamientoAcuses - acuse:"
									+ deliveredNotificationInfo.xmlText());
					situacionNotificacion = Y41bConstantes.SITUACION_ACUSERECIBO_ACEPTADO;

					justificanteAcuse = this.getJustificanteAcuse(notificationId);
				}
				// 2. Actualizamos la tabla de tramite hecho poniendo el tramite
				// a
				// tramitado
				if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(tipoProcedimiento)) {

					if (justificanteAcuse != null) {
						this.soltramexpService.aportarJustificanteAcuseRecibo(tramitehechoAcuse, justificanteAcuse);
					}

					tramitehechoAcuse = this.tramiteHechoDao.completaAcuseRecibo(tramitehechoAcuse,
							situacionNotificacion, deliveredNotificationInfo);

					HechoDenunciado hechodenunciadoAux = new HechoDenunciado();

					// 3.1 Actualizar ultimo tramite acuse de recibo
					hechodenunciadoAux = new HechoDenunciado();
					hechodenunciadoAux.setHdcodigo(tramitehechoAcuse.getEhcohd());
					hechodenunciadoAux.setTrcodigoactual(Y41bConstantes.TRAMITE_ACUSE_RECIBO);

					this.hechoDenunciadoDao.updateUltimoTramiteGenerico(hechodenunciadoAux);

					// 4. Tratamiento de Bandeja Solicitudes
					hechodenunciadoAux = new HechoDenunciado();
					hechodenunciadoAux.setHdcodigo(tramitehechoAcuse.getEhcohd());
					this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

					TramiteHecho tramitehechoAux = this.tramiteHechoDao.find(tramitehechoAcuse);

					this.soltramexpService.tratamientoMisGestionesAcuseRecibo(tramitehechoAux);

				} else if (Y41bConstantes.TIPO_PROC_SANCIONES.equals(tipoProcedimiento)) {
					logger.info("ACUSE DE SANCIONES.EXP " + situacionNotificacion + ".");
					if (justificanteAcuse != null) {
						this.santramexpService.aportarJustificanteAcuseRecibo(tramiteAcuse, justificanteAcuse);
					}

					tramiteAcuse = this.santramexpDao.completaAcuseRecibo(tramiteAcuse, situacionNotificacion,
							deliveredNotificationInfo);

					// 4. Tratamiento de Bandeja Solicitudes
					logger.info("tratamientoAcuses.Paso1. ");
					this.santramexpService.actualizaUltimoTramiteEnSanExp(tramiteAcuse);
					logger.info("tratamientoAcuses.Paso2. ");
					/*
					 * actualizamos la bandeja despues de tratar el acuse porque
					 * se ha podido generar el informe bopv
					 */
					this.santramexpService.actualizaBandeja(tramiteAcuse);

					logger.info("tratamientoAcuses.Paso3. ");

					// En sancionadores llamamos a
					// actualizarMisGestionesNotificacion desde
					// tratarTramitacionAcuse en SantramexpService
					this.santramexpService.tratarTramitacionAcuse(tramiteAcuse);
					logger.info("tratamientoAcuses.Paso4. ");
				} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(tipoProcedimiento)) {
					logger.info("ACUSE DE ARBITRAJE " + situacionNotificacion + ".");

					if (justificanteAcuse != null) {
						this.arbtramexp4Service.aportarJustificanteAcuseRecibo(tramiteAcuseArb, justificanteAcuse);
					}

					tramiteAcuseArb = this.arbtramexpDao.completaAcuseRecibo(tramiteAcuseArb, situacionNotificacion,
							deliveredNotificationInfo);

					// 4. Tratamiento de Bandeja Solicitudes
					logger.info("tratamientoAcuses.Paso1. ");
					this.arbtramexp2Service.actualizaUltimoTramiteArbexp(tramiteAcuseArb);
					logger.info("tratamientoAcuses.Paso2. ");
					/*
					 * actualizamos la bandeja despues de tratar el acuse porque
					 * se ha podido generar el informe bopv
					 */
					this.arbtramexp2Service.actualizaBandeja(tramiteAcuseArb);
					logger.info("tratamientoAcuses.Paso3. ");

					// En arbitraje llamamos a
					// actualizarMisGestionesNotificacion desde
					// tratarTramitacionAcuse en SantramexpService
					this.arbtramexp3Service.tratarTramitacionAcuse(tramiteAcuseArb, null);
					logger.info("tratamientoAcuses.Paso4. ");
				} else if (Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA.equals(tipoProcedimiento)
						|| Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA.equals(tipoProcedimiento)
						|| Y41bConstantes.TIPO_PROC_ADHESIONES_MOD.equals(tipoProcedimiento)) {
					logger.info("ACUSE DE ADHESIONES " + situacionNotificacion + ".");

					if (justificanteAcuse != null) {
						this.arbadhtramService.aportarJustificanteAcuseRecibo(tramiteAcuseAdh, justificanteAcuse,
								tipoProcedimiento);
					}

					tramiteAcuseAdh = this.arbadhtramDao.completaAcuseRecibo(tramiteAcuseAdh, situacionNotificacion,
							deliveredNotificationInfo);
					logger.info("tratamientoAcuses.Paso1. ");

					// En adhesiones llamamos a
					// actualizarMisGestionesNotificacion desde
					// tratarTramitacionAcuse en SantramexpService
					this.arbadhtramService.tratarTramitacionAcuse(tramiteAcuseAdh);
					logger.info("tratamientoAcuses.Paso2. ");
				} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(tipoProcedimiento)) {

					if (justificanteAcuse != null) {
						this.instramexpService.aportarJustificanteAcuseRecibo(tramiteinspeccionAcuse,
								justificanteAcuse);
					}

					tramiteinspeccionAcuse = this.tramiteInspeccionDao.completaAcuseRecibo(tramiteinspeccionAcuse,
							situacionNotificacion, deliveredNotificationInfo);

					// 3.1 Actualizar ultimo tramite acuse de recibo
					Actuacion actuacionAux = new Actuacion();
					actuacionAux.setAtcodigo(tramiteinspeccionAcuse.getTiatcodigo());
					actuacionAux.setTrcodigoactual(Y41bConstantes.TRAMITE_INSPECCIONES_ACUSE_DE_RECIBO);

					this.actuacionDao.updateUltimoTramiteGenerico(actuacionAux);

					TramiteInspeccion tramiteInspeccionAux = this.tramiteInspeccionDao.find(tramiteinspeccionAcuse);

					this.instramexpService.tratamientoMisGestionesAcuseRecibo(tramiteInspeccionAux);

				}

			}
		} catch (Y41bUDAException e) {
			// logger.error("Y41bTratamientoPlateaJMSServiceImpl.tratamientoAcuses"
			// + e.getMessage());
			// throw e;
			SolicitudTelematicaEventos solicitudTelematicaEventos = this.getSolicitudFromEventSolicitud(mapaMensaje,
					mensajeCola);

			solicitudTelematicaEventos = this.solicitudesTelematicasEventosService
					.addSolicitudTelematicaEventos(solicitudTelematicaEventos);
		} catch (Exception e_tratamientoAcuses) {
			// logger.error("Y41bTratamientoPlateaJMSServiceImpl.tratamientoAcuses",
			// e_tratamientoAcuses);
			// throw new Y41bUDAException("error.platea.invocation", true,
			// e_tratamientoAcuses);
			SolicitudTelematicaEventos solicitudTelematicaEventos = this.getSolicitudFromEventSolicitud(mapaMensaje,
					mensajeCola);

			solicitudTelematicaEventos = this.solicitudesTelematicasEventosService
					.addSolicitudTelematicaEventos(solicitudTelematicaEventos);
		} finally {
			logger.info("Y41bTratamientoPlateaJMSServiceImpl.tratamientoAcuses - Final");
		}
	}

	/**
	 * tratamientoAportacionDocumentacion
	 * 
	 * @param stPfToken
	 *            token
	 * @param mapaMensaje
	 *            mensaje
	 * @throws Exception
	 *             Cualquier excepcion
	 */
	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Throwable.class)
	public void tratamientoAportacionDocumentacion(String stPfToken, Map mapaMensaje, String mensajeCola)
			throws Exception {
		Y41bTratamientoPlateaJMSServiceImpl.logger
				.info("Y41bTratamientoPlateaJMSServiceImpl.tratamientoAportacionDocumentacion - Inicio");
		DocumentsBO documents = null;
		try {
			// 1. Recuperamos informacion necesaria
			documents = this.getDocumentsBOFromSolicitud(mapaMensaje);
			String numExpediente = (String) mapaMensaje.get("folderNumber");
			String procedureId = (String) mapaMensaje.get("procedureID");
			String registryNumber = (String) mapaMensaje.get("registryNumber");
			String registryTimestamp = (String) mapaMensaje.get("registryTimestamp");
			String tipoAportacion = (String) mapaMensaje.get("submissionType");
			String senderID = (String) mapaMensaje.get("senderID");

			// 2. Creamos el objeto con la informacion necesaria
			MensajeAportacionDocumentacion mensajeAportacionDoc = new MensajeAportacionDocumentacion();
			mensajeAportacionDoc.setNumeroExpediente(numExpediente);
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(procedureId);
			mensajeAportacionDoc.setProcedure(procedure);
			DatosRegistro registro = new DatosRegistro();
			registro.setRegistryNumber(registryNumber);
			registro.setRegistryTimestamp(registryTimestamp);
			mensajeAportacionDoc.setRegistro(registro);
			mensajeAportacionDoc.setTipoAportacion(tipoAportacion);
			mensajeAportacionDoc.setSender(senderID);
			mensajeAportacionDoc.setDocumentosAportados(this.getDocumentsByDocumentsBO(documents));
			Y41bTratamientoPlateaJMSServiceImpl.logger
					.info("Y41bTratamientoPlateaJMSServiceImpl.aportacionDocumentacion - mensaje aportacion:"
							+ mensajeAportacionDoc.toString());
			// 3. Logica de negocio para tratamiento de aportacion
			// documentacion

			// Controlar si el numero de registro de entrada existe en la tabla
			// L21Q5T00 (todos los documentos de todos los expedientes se
			// encuentran en esta tabla), si existe no se hace nada, si no
			// existe se procesa normalmente.
			DocumentoHecho documentoHecho = new DocumentoHecho();
			documentoHecho.setQ5numregistroentrada(registryNumber);

			if (this.denunciaService.findAllDocumentosByRegistryNumberCount(documentoHecho) == 0) {

				if (Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES.equals(procedureId)) {
					SolicitudDetalle solicitudDetalle = new SolicitudDetalle();

					String numeroExpediente = numExpediente
							.replace(new StringBuffer(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-").toString(), "");

					StringTokenizer strTokenizer = new StringTokenizer(numeroExpediente, "-");

					if (strTokenizer.hasMoreElements()) {
						solicitudDetalle.setDecoor(strTokenizer.nextToken());
					}
					if (strTokenizer.hasMoreElements()) {
						solicitudDetalle.setDenror(new Long(strTokenizer.nextToken()));
					}
					if (strTokenizer.hasMoreElements()) {
						solicitudDetalle.setDenran(new Integer(strTokenizer.nextToken()));
					}
					if (strTokenizer.hasMoreElements()) {
						solicitudDetalle.setHdnror(new Long(strTokenizer.nextToken()));
					}

					this.denunciaService.generarTramiteAportacionDocumentacion(solicitudDetalle, mensajeAportacionDoc);
				} else if (Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES.equals(procedureId)) {

					Expedien expediente = new Expedien();

					String numeroExpediente = numExpediente
							.replace(new StringBuffer(Y41bConstantes.TIPO_PROC_SANCIONES).append("-").toString(), "");

					StringTokenizer strTokenizer = new StringTokenizer(numeroExpediente, "-");

					if (strTokenizer.hasMoreElements()) {
						expediente.setExcoor(strTokenizer.nextToken());
					}
					if (strTokenizer.hasMoreElements()) {
						expediente.setExnror(new BigDecimal(strTokenizer.nextToken()));
					}
					if (strTokenizer.hasMoreElements()) {
						expediente.setExnran(new BigDecimal(strTokenizer.nextToken()));
					}

					this.santramexpService.generarTramiteAportacionDocumentacion(expediente, mensajeAportacionDoc);

				} else if (Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE.equals(procedureId)) {

					Solarb expediente = new Solarb();

					String numeroExpediente = numExpediente
							.replace(new StringBuffer(Y41bConstantes.TIPO_PROC_ARBITRAJE).append("-").toString(), "");

					StringTokenizer strTokenizer = new StringTokenizer(numeroExpediente, "-");

					if (strTokenizer.hasMoreElements()) {
						expediente.setSacoja(strTokenizer.nextToken());
					}
					if (strTokenizer.hasMoreElements()) {
						expediente.setSanror(new BigDecimal(strTokenizer.nextToken()));
					}
					if (strTokenizer.hasMoreElements()) {
						expediente.setSanran(new BigDecimal(strTokenizer.nextToken()));
					}

					this.arbtramexp4Service.generarTramiteAportacionDocumentacion(expediente, mensajeAportacionDoc);

				} else if (Y41bConstantes.ID_PROCEDIMIENTO_ADHALTA.equals(procedureId)
						|| Y41bConstantes.ID_PROCEDIMIENTO_ADHBAJA.equals(procedureId)
						|| Y41bConstantes.ID_PROCEDIMIENTO_ADHMODIF.equals(procedureId)) {

					Arbadhsol arbadhsol = new Arbadhsol();

					String numeroExpediente = "";
					if (Y41bConstantes.ID_PROCEDIMIENTO_ADHALTA.equals(procedureId)) {
						numeroExpediente = numExpediente.replace(
								new StringBuffer(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA).append("-").toString(), "");
					} else if (Y41bConstantes.ID_PROCEDIMIENTO_ADHBAJA.equals(procedureId)) {
						numeroExpediente = numExpediente.replace(
								new StringBuffer(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA).append("-").toString(), "");
					} else if (Y41bConstantes.ID_PROCEDIMIENTO_ADHMODIF.equals(procedureId)) {
						numeroExpediente = numExpediente.replace(
								new StringBuffer(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD).append("-").toString(), "");
					}

					StringTokenizer strTokenizer = new StringTokenizer(numeroExpediente, "-");

					if (strTokenizer.hasMoreElements()) {
						arbadhsol.setAdhsolcoor(strTokenizer.nextToken());
					}
					if (strTokenizer.hasMoreElements()) {
						arbadhsol.setAdhsolnror(new BigDecimal(strTokenizer.nextToken()));
					}
					if (strTokenizer.hasMoreElements()) {
						arbadhsol.setAdhsolnran(new BigDecimal(strTokenizer.nextToken()));
					}

					this.arbadhtramService.generarTramiteAportacionDocumentacion(arbadhsol, mensajeAportacionDoc);

				} else if (Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES.equals(procedureId)) {
					InspeccionDetalle inspeccionDetalle = new InspeccionDetalle();

					String numeroExpediente = numExpediente.replace(
							new StringBuffer(Y41bConstantes.TIPO_PROC_INSPECCIONES).append("-").toString(), "");

					StringTokenizer strTokenizer = new StringTokenizer(numeroExpediente, "-");

					if (strTokenizer.hasMoreElements()) {
						inspeccionDetalle.setAccoor(strTokenizer.nextToken());
					}
					if (strTokenizer.hasMoreElements()) {
						inspeccionDetalle.setAcnror(strTokenizer.nextToken());
					}
					if (strTokenizer.hasMoreElements()) {
						inspeccionDetalle.setAcnran(new BigDecimal(strTokenizer.nextToken()));
					}
					if (strTokenizer.hasMoreElements()) {
						inspeccionDetalle.setAtnror(strTokenizer.nextToken());
					}

					this.inspeccionService.generarTramiteAportacionDocumentacion(inspeccionDetalle,
							mensajeAportacionDoc);

					inspeccionDetalle = this.inspeccionService.findInspeccionByNumeroExpediente(inspeccionDetalle);

					TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
					tramiteinspeccion.setTiatcodigo(inspeccionDetalle.getAtcodigo());
					this.instramexpService.enviarMailInstructorRegistroDecision(tramiteinspeccion);
				}
			}
		} catch (Y41bUDAException e) {
			// logger.error("Y41bTratamientoPlateaJMSServiceImpl.tratamientoAportacionDocumentacion
			// ERROR ***** ", e);
			// throw e;

			SolicitudTelematicaEventos solicitudTelematicaEventos = this.getSolicitudFromEventSolicitud(mapaMensaje,
					mensajeCola);

			solicitudTelematicaEventos = this.solicitudesTelematicasEventosService
					.addSolicitudTelematicaEventos(solicitudTelematicaEventos);
		} catch (Exception e_tratamientoAportacionDocumentacion) {

			SolicitudTelematicaEventos solicitudTelematicaEventos = this.getSolicitudFromEventSolicitud(mapaMensaje,
					mensajeCola);

			solicitudTelematicaEventos = this.solicitudesTelematicasEventosService
					.addSolicitudTelematicaEventos(solicitudTelematicaEventos);
			// logger.error("Y41bTratamientoPlateaJMSServiceImpl.tratamientoAportacionDocumentacion
			// ERROR ***** ",
			// e_tratamientoAportacionDocumentacion);
			// throw new Y41bUDAException("error.platea.invocation", true,
			// e_tratamientoAportacionDocumentacion);
		} finally {
			logger.info("Y41bTratamientoPlateaJMSServiceImpl.tratamientoAportacionDocumentacion - Final");
		}
	}

	/**
	 * Obtiene el justificante del acuse
	 * 
	 * @param idnotificacionplatea
	 *            String
	 * @return Documento
	 * @throws Exception
	 *             Cualquier excepcion
	 */
	private Documento getJustificanteAcuse(String idnotificacionplatea) throws Exception {
		Y41bTratamientoPlateaJMSServiceImpl.logger
				.info("Y41bTratamientoPlateaJMSServiceImpl.getJustificanteAcuse - Inicio");
		try {
			TNotification tNotification = this.y41bPlateaAdapterService
					.getJustificanteAcuseNotificacion(idnotificacionplatea);

			// descargar de dokusi
			// descargar documentos dokusi
			Documento documento = new Documento();
			User user = new User();
			user.setNombre(Y41bConstantes.COD_APLICACION);
			user.setDni(Y41bConstantes.COD_APLICACION);
			documento.setUser(user);
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(tNotification.getProcedureID());
			documento.setProcedure(procedure);
			documento.setOidDokusi(tNotification.getAccuseDocument().getDokusiID());

			Documento docDokusi = y41bDokusiAdapterService.descargarDocumentoDokusi(documento);

			docDokusi.setOidDokusi(documento.getOidDokusi());

			return docDokusi;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e_getContextSubmissionFromSolicitud) {
			logger.error("Y41bTratamientoPlateaJMSServiceImpl.getJustificanteAcuse",
					e_getContextSubmissionFromSolicitud);
			throw new Y41bUDAException("error.platea.invocation", true, e_getContextSubmissionFromSolicitud);
		} finally {
			logger.info("Y41bTratamientoPlateaJMSServiceImpl.getJustificanteAcuse - Final");
		}
	}

	/**
	 * getContextSubmissionFromSolicitud
	 * 
	 * @param mapaMensaje
	 *            mensaje
	 * @return ContextSubmission
	 * @throws Exception
	 *             Cualquier excepcion
	 */
	private ContextSubmission getContextSubmissionFromSolicitud(Map mapaMensaje) throws Exception {
		Y41bTratamientoPlateaJMSServiceImpl.logger
				.info("Y41bTratamientoPlateaJMSServiceImpl.getContextSubmissionFromSolicitud - Inicio");
		try {
			String contentSubmission = (String) mapaMensaje.get("contentSubmission");

			// Parseo del XML mediante JAXB
			JAXBContext jaxbContext;
			ContextSubmission contextSubmission = null;

			jaxbContext = JAXBContext.newInstance(ContextSubmission.class);

			Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
			StringReader reader = new StringReader(contentSubmission);
			contextSubmission = (ContextSubmission) jaxbUnmarshaller.unmarshal(reader);

			return contextSubmission;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e_getContextSubmissionFromSolicitud) {
			logger.error("Y41bTratamientoPlateaJMSServiceImpl.getContextSubmissionFromSolicitud",
					e_getContextSubmissionFromSolicitud);
			throw new Y41bUDAException("error.platea.invocation", true, e_getContextSubmissionFromSolicitud);
		} finally {
			logger.info("Y41bTratamientoPlateaJMSServiceImpl.getContextSubmissionFromSolicitud - Final");
		}
	}

	/**
	 * getContextSubmissionFromSolicitud
	 * 
	 * @param mapaMensaje
	 *            mensaje
	 * @return ContextSubmission
	 * @throws Exception
	 *             Cualquier excepcion
	 */
	private com.ejie.folderManagement.xml.ContextSubmissionDocument.ContextSubmission getContextSubmissionOLDFromSolicitud(
			Map mapaMensaje) throws Exception {
		Y41bTratamientoPlateaJMSServiceImpl.logger
				.info("Y41bTratamientoPlateaJMSServiceImpl.getContextSubmissionOLDFromSolicitud - Inicio");
		try {
			String contentSubmission = (String) mapaMensaje.get("contentSubmission");

			com.ejie.folderManagement.xml.ContextSubmissionDocument contentSubmissionDocument = com.ejie.folderManagement.xml.ContextSubmissionDocument.Factory
					.parse(contentSubmission);
			return contentSubmissionDocument.getContextSubmission();
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e_getContextSubmissionOLDFromSolicitud) {
			logger.error("Y41bTratamientoPlateaJMSServiceImpl.getContextSubmissionOLDFromSolicitud",
					e_getContextSubmissionOLDFromSolicitud);
			throw new Y41bUDAException("error.platea.invocation", true, e_getContextSubmissionOLDFromSolicitud);
		} finally {
			logger.info("Y41bTratamientoPlateaJMSServiceImpl.getContextSubmissionOLDFromSolicitud - Final");
		}
	}

	/**
	 * getAcuseFromSolicitud
	 * 
	 * @param mapaMensaje
	 *            mensaje
	 * @return DeliveredNotificationInfo
	 * @throws Exception
	 *             Cualquier excepcion
	 */
	private DeliveredNotificationInfo getAcuseFromSolicitud(Map mapaMensaje) throws Exception {
		Y41bTratamientoPlateaJMSServiceImpl.logger
				.info("Y41bTratamientoPlateaJMSServiceImpl.getAcuseFromSolicitud - Inicio");
		try {
			String xmlAcuse = (String) mapaMensaje.get("DeliveredNotificationInfo");
			DeliveredNotificationInfoDocument deliveredNotificationInfoDocument = DeliveredNotificationInfoDocument.Factory
					.parse(xmlAcuse);
			return deliveredNotificationInfoDocument.getDeliveredNotificationInfo();
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e_getAcuseFromSolicitud) {
			logger.error("Y41bTratamientoPlateaJMSServiceImpl.getAcuseFromSolicitud", e_getAcuseFromSolicitud);
			throw new Y41bUDAException("error.platea.invocation", true, e_getAcuseFromSolicitud);
		} finally {
			logger.info("Y41bTratamientoPlateaJMSServiceImpl.getAcuseFromSolicitud - Final");
		}
	}

	/**
	 * getDocumentsBOFromSolicitud
	 * 
	 * @param mapaMensaje
	 *            mensaje
	 * @return DocumentsBO
	 * @throws Exception
	 *             Cualquier excepcion
	 */
	private DocumentsBO getDocumentsBOFromSolicitud(Map mapaMensaje) throws Exception {
		Y41bTratamientoPlateaJMSServiceImpl.logger
				.info("Y41bTratamientoPlateaJMSServiceImpl.getDocumentsBOFromSolicitud - Inicio");
		try {
			String documentsBOStr = (String) mapaMensaje.get("documents");
			documentsBOStr = Y41bXMLUtils.quitarNameSpacesString(XmlObject.Factory.parse(documentsBOStr));
			documentsBOStr = documentsBOStr.replaceAll(Y41bJMSConstantes.ETIQUETA_DOCSBO_INI,
					Y41bJMSConstantes.ETIQUETA_DOCSBO_INI_XMLNS);
			DocumentsBODocument documentsBODocument = DocumentsBODocument.Factory.parse(documentsBOStr);
			return documentsBODocument.getDocumentsBO();
		} catch (Y41bUDAException e) {
			logger.error("Y41bTratamientoPlateaJMSServiceImpl.getDocumentsBOFromSolicitud", e);
			throw e;
		} catch (Exception e_getContextSubmissionFromSolicitud) {
			logger.error("Y41bTratamientoPlateaJMSServiceImpl.getDocumentsBOFromSolicitud",
					e_getContextSubmissionFromSolicitud);
			throw new Y41bUDAException("error.platea.invocation", true, e_getContextSubmissionFromSolicitud);
		} finally {
			logger.info("Y41bTratamientoPlateaJMSServiceImpl.getDocumentsBOFromSolicitud - Final");
		}
	}

	/**
	 * getDocumentsByDocumentsBO
	 * 
	 * @param documentsBO
	 *            DocumentsBO
	 * @return List<Documento>
	 * @throws Exception
	 *             Cualquier excepcion
	 */
	private List<Documento> getDocumentsByDocumentsBO(DocumentsBO documentsBO) throws Exception {
		Y41bTratamientoPlateaJMSServiceImpl.logger
				.info("Y41bTratamientoPlateaJMSServiceImpl.getDocumentsByDocumentsBO - Inicio");
		try {
			List<Documento> listaDocumentosRdo = null;
			if (documentsBO != null && documentsBO.sizeOfDocumentBOArray() > 0) {
				listaDocumentosRdo = new ArrayList<Documento>();
				DocumentBO[] documentsBOArray = documentsBO.getDocumentBOArray();
				Documento documento = null;
				for (int i = 0; i < documentsBO.sizeOfDocumentBOArray(); i++) {
					documento = new Documento();
					documento.setNombre(documentsBOArray[i].getSourceName());
					documento.setDescripcion(documentsBOArray[i].getDescriptors().getDescriptorArray(0).getValue());
					documento.setOidDokusi(documentsBOArray[i].getOid());
					documento.setTipoDocumental(documentsBOArray[i].getRoleId());
					listaDocumentosRdo.add(documento);
				}
			}
			return listaDocumentosRdo;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e_getDocumentsByDocumentsBO) {
			logger.error("Y41bTratamientoPlateaJMSServiceImpl.getDocumentsByDocumentsBO", e_getDocumentsByDocumentsBO);
			throw new Y41bUDAException("error.platea.invocation", true, e_getDocumentsByDocumentsBO);
		} finally {
			logger.info("Y41bTratamientoPlateaJMSServiceImpl.getDocumentsByDocumentsBO - Final");
		}
	}

	/**
	 * getSolicitudTelematica
	 * 
	 * @param contextSubmission
	 *            ContextSubmission
	 * @param documentsBO
	 *            DocumentsBO
	 * @param procedureId
	 *            String
	 * @param numExpediente
	 *            String
	 * @return SolicitudTelematica
	 * @throws Exception
	 *             Cualquier excepcion
	 */
	private SolicitudTelematica getSolicitudTelematica(ContextSubmission contextSubmission, DocumentsBO documentsBO,
			String procedureId, String numExpediente) throws Exception {
		Y41bTratamientoPlateaJMSServiceImpl.logger
				.info("Y41bTratamientoPlateaJMSServiceImpl.getSolicitudTelematica - Inicio");
		try {
			SolicitudTelematica solicitudTelematica = new SolicitudTelematica();
			// DATOS PROCEDIMIENTO/EXPEDIENTE INICIO
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(procedureId);
			solicitudTelematica.setProcedure(procedure);
			solicitudTelematica.setNumeroExpediente(numExpediente);
			// DATOS PROCEDIMIENTO/EXPEDIENTE FIN
			// TERCEROS SOLICITUD INICIO
			DatosPersona solicitante = new DatosPersona();
			DatosPersona representante = new DatosPersona();

			String email = "";
			String telefono = "";

			RepresentativeRRI representanteReclamante = null;
			InterestedRRI reclamante = null;

			reclamante = contextSubmission.getApplicantInfoRRI().getInterestedListRRI().getInterestedRRI().get(0);

			String idiomaNotificacion = contextSubmission.getApplicantInfoRRI().getInterestedListRRI()
					.getInterestedRRI().get(0).getLanguage();

			representanteReclamante = contextSubmission.getApplicantInfoRRI().getRepresentativeRRI();

			solicitante.setDni(reclamante.getID());
			solicitante.setNombre(reclamante.getName());

			StringBuilder apellidosTitular = new StringBuilder();

			if (Y41bUtils.isFilled(reclamante.getApe1())) {
				apellidosTitular.append(reclamante.getApe1());
			}
			if (Y41bUtils.isFilled(reclamante.getApe2())) {
				apellidosTitular.append(" ").append(reclamante.getApe2());
			}
			solicitante.setApellido1(apellidosTitular.toString());

			if (contextSubmission.getApplicantInfoRRI().getInterestedListRRI().getInterestedRRI().get(0)
					.getAccount() != null
					&& contextSubmission.getApplicantInfoRRI().getInterestedListRRI().getInterestedRRI().get(0)
							.getAccount().getContactList() != null
					&& contextSubmission.getApplicantInfoRRI().getInterestedListRRI().getInterestedRRI().get(0)
							.getAccount().getContactList().getContact() != null
					&& !contextSubmission.getApplicantInfoRRI().getInterestedListRRI().getInterestedRRI().get(0)
							.getAccount().getContactList().getContact().isEmpty()) {
				for (Contact contact : contextSubmission.getApplicantInfoRRI().getInterestedListRRI().getInterestedRRI()
						.get(0).getAccount().getContactList().getContact()) {
					if (Y41bConstantes.CONTACT_TOOLKIT.EMAIL.equals(contact.getType())) {
						email = contact.getValue().getEmailAddress();
					}

					if (Y41bConstantes.CONTACT_TOOLKIT.SMS.equals(contact.getType())) {
						telefono = contact.getValue().getSmsNumber();
					}
				}
			}

			if (representanteReclamante != null) {
				idiomaNotificacion = contextSubmission.getApplicantInfoRRI().getRepresentativeRRI().getLanguage();

				representante.setDni(representanteReclamante.getID());
				representante.setNombre(representanteReclamante.getName());

				StringBuilder apellidosRepresentante = new StringBuilder();

				if (Y41bUtils.isFilled(representanteReclamante.getApe1())) {
					apellidosRepresentante.append(representanteReclamante.getApe1());
				}
				if (Y41bUtils.isFilled(representanteReclamante.getApe2())) {
					apellidosRepresentante.append(" ").append(representanteReclamante.getApe2());
				}
				representante.setApellido1(apellidosRepresentante.toString());

				if (contextSubmission.getApplicantInfoRRI().getRepresentativeRRI().getAccount() != null
						&& contextSubmission.getApplicantInfoRRI().getRepresentativeRRI().getAccount()
								.getContactList() != null
						&& contextSubmission.getApplicantInfoRRI().getRepresentativeRRI().getAccount().getContactList()
								.getContact() != null
						&& !contextSubmission.getApplicantInfoRRI().getRepresentativeRRI().getAccount().getContactList()
								.getContact().isEmpty()) {
					for (Contact contact : contextSubmission.getApplicantInfoRRI().getRepresentativeRRI().getAccount()
							.getContactList().getContact()) {
						if (Y41bConstantes.CONTACT_TOOLKIT.EMAIL.equals(contact.getType())) {
							email = contact.getValue().getEmailAddress();
						}

						if (Y41bConstantes.CONTACT_TOOLKIT.SMS.equals(contact.getType())) {
							telefono = contact.getValue().getSmsNumber();
						}
					}
				}
			}

			// TERCEROS SOLICITUD FIN

			// DATOS NOTIFICACION INICIO
			// cuando es arbitraje telemtico el idioma que domina no es el que
			// viene en el JMS si no el del hecho relacionado
			if (!Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE.equals(procedureId)) {
				solicitudTelematica.setIdiomaNotificacion(idiomaNotificacion);
			}

			solicitudTelematica.setTipoNotificacion(Y41bConstantes.ELECTRONICO);
			// DATOS NOTIFICACION FIN

			// DATOS AVISO INICIO
			solicitante.setMail(email);
			solicitante.setTelefono(telefono);
			// DATOS AVISO FIN

			// DOCUMENTOS INICIO
			if (documentsBO != null && documentsBO.sizeOfDocumentBOArray() > 0) {
				List<Documento> documentosAdjuntos = new ArrayList<Documento>();
				Documento documentoAdjunto = null;
				for (int i = 0; i < documentsBO.getDocumentBOArray().length; i++) {
					if (Y41bUtils.isFilled(documentsBO.getDocumentBOArray(i).getOid())) {
						documentoAdjunto = new Documento();
						documentoAdjunto.setOidDokusi(documentsBO.getDocumentBOArray(i).getOid());
						documentoAdjunto.setNombre(documentsBO.getDocumentBOArray(i).getSourceName());
						documentoAdjunto.setDescripcion(
								documentsBO.getDocumentBOArray(i).getDescriptors().getDescriptorArray(0).getValue());
						documentosAdjuntos.add(documentoAdjunto);
					}
				}
				solicitudTelematica.setDocumentosAdjuntos(documentosAdjuntos);
			}
			// DOCUMENTOS FIN
			solicitudTelematica.setSolicitante(solicitante);
			solicitudTelematica.setRepresentante(representante);
			return solicitudTelematica;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e_getSolicitudTelematica) {
			logger.error("Y41bTratamientoPlateaJMSServiceImpl.getSolicitudTelematica", e_getSolicitudTelematica);
			throw new Y41bUDAException("error.platea.invocation", true, e_getSolicitudTelematica);
		} finally {
			logger.info("Y41bTratamientoPlateaJMSServiceImpl.getSolicitudTelematica - Final");
		}
	}

	/**
	 * getSolicitudTelematica
	 * 
	 * @param contextSubmission
	 *            ContextSubmission
	 * @param documentsBO
	 *            DocumentsBO
	 * @param procedureId
	 *            String
	 * @param numExpediente
	 *            String
	 * @return SolicitudTelematica
	 * @throws Exception
	 *             Cualquier excepcion
	 */
	private SolicitudTelematica getSolicitudTelematicaAdhesiones(
			com.ejie.folderManagement.xml.ContextSubmissionDocument.ContextSubmission contextSubmission,
			DocumentsBO documentsBO, String procedureId, String numExpediente) throws Exception {
		Y41bTratamientoPlateaJMSServiceImpl.logger
				.info("Y41bTratamientoPlateaJMSServiceImpl.getSolicitudTelematica - Inicio");
		try {
			com.ejie.folderManagement.xml.ApplicantInfoDocument.ApplicantInfo applicantInfo = contextSubmission
					.getApplicantInfo();
			SolicitudTelematica solicitudTelematica = new SolicitudTelematica();
			// DATOS PROCEDIMIENTO/EXPEDIENTE INICIO
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(procedureId);
			solicitudTelematica.setProcedure(procedure);
			solicitudTelematica.setNumeroExpediente(numExpediente);
			// DATOS PROCEDIMIENTO/EXPEDIENTE FIN
			// TERCEROS SOLICITUD INICIO
			DatosPersona solicitante = new DatosPersona();
			DatosPersona representante = new DatosPersona();
			com.ejie.folderManagement.xml.PersonsDocument.Persons persons = applicantInfo.getPersons();
			String dniTitularSolicitud = "";
			StringBuilder apellidosTitular = new StringBuilder();
			StringBuilder apellidosRepresentante = new StringBuilder();
			if (persons != null) {
				for (int i = 0; i < persons.getPersonArray().length; i++) {
					com.ejie.folderManagement.xml.PersonDocument.Person person = persons.getPersonArray(i);
					if (person.getHolderShip().equals(Y41bConstantes.TITULAR)) {
						dniTitularSolicitud = person.getId();
						solicitante.setDni(dniTitularSolicitud);
						solicitante.setNombre(person.getName());

						if (Y41bUtils.isFilled(person.getApellido1())) {
							apellidosTitular.append(person.getApellido1());
						}
						if (Y41bUtils.isFilled(person.getApellido2())) {
							apellidosTitular.append(" ").append(person.getApellido2());
						}
						solicitante.setApellido1(apellidosTitular.toString());
					} else if (person.getHolderShip().equals(Y41bConstantes.REPRESENTANTE)) {
						representante.setDni(person.getId());
						representante.setNombre(person.getName());

						if (Y41bUtils.isFilled(person.getApellido1())) {
							apellidosRepresentante.append(person.getApellido1());
						}
						if (Y41bUtils.isFilled(person.getApellido2())) {
							apellidosRepresentante.append(" ").append(person.getApellido2());
						}
						representante.setApellido1(apellidosRepresentante.toString());
					}
				}
			}
			// TERCEROS SOLICITUD FIN
			// DATOS NOTIFICACION INICIO
			com.ejie.folderManagement.xml.NotificationDocument.Notification notification = applicantInfo
					.getNotification();

			// cuando es arbitraje telemtico el idioma que domina no es el que
			// viene en el JMS si no el del hecho relacionado
			if (!Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE.equals(procedureId)) {
				solicitudTelematica.setIdiomaNotificacion(applicantInfo.getLanguage());
			}

			if (notification != null && notification.getChannel() != null
					&& notification.getChannel().getChannelInfo() != null) {
				String channelInfoNotifStr = this
						.createChannelInfoByStr(notification.getChannel().getChannelInfo().copy());
				com.ejie.r02K.xml.ChannelInfoDocument channelInfoNotif = com.ejie.r02K.xml.ChannelInfoDocument.Factory
						.parse(channelInfoNotifStr);
				if (Y41bConstantes.ELECTRONICO.equals(notification.getChannel().getChannelType())) {
					solicitudTelematica.setTipoNotificacion(Y41bConstantes.ELECTRONICO);
				} else if (Y41bConstantes.POSTAL.equals(notification.getChannel().getChannelType())) {
					if (channelInfoNotif.getChannelInfo().isSetPostalAddress()) {
						com.ejie.y41b.model.platea.NotificacionPostal notificacionPostal = new com.ejie.y41b.model.platea.NotificacionPostal(
								channelInfoNotif.getChannelInfo().getPostalAddress().getPais(),
								channelInfoNotif.getChannelInfo().getPostalAddress().getProvincia().getLanguageArray(0)
										.toString(),
								channelInfoNotif.getChannelInfo().getPostalAddress().getMunicipio(),
								channelInfoNotif.getChannelInfo().getPostalAddress().getLocalidad(),
								channelInfoNotif.getChannelInfo().getPostalAddress().getDireccion(),
								channelInfoNotif.getChannelInfo().getPostalAddress().getPortal(),
								channelInfoNotif.getChannelInfo().getPostalAddress().getPiso(),
								channelInfoNotif.getChannelInfo().getPostalAddress().getCp());
						solicitudTelematica.setNotificacionPostal(notificacionPostal);

					}
					solicitudTelematica.setTipoNotificacion(Y41bConstantes.POSTAL);
				}
			}
			// DATOS NOTIFICACION FIN
			// DATOS AVISO INICIO
			com.ejie.folderManagement.xml.NoticesDocument.Notices notices = applicantInfo.getNotices();
			if (notices != null) {
				for (int j = 0; j < notices.getNoticeArray().length; j++) {
					com.ejie.folderManagement.xml.NoticeDocument.Notice notice = notices.getNoticeArray(j);
					if (notice.getAddressee() != null && notice.getChannel() != null
							&& dniTitularSolicitud.equals(notice.getAddressee().getAddresseeID())) {
						if (notice.getChannel() != null) {
							String channelInfoNoticeStr = this
									.createChannelInfoByStr(notice.getChannel().getChannelInfo().copy());
							com.ejie.r02K.xml.ChannelInfoDocument channelInfoNotice = com.ejie.r02K.xml.ChannelInfoDocument.Factory
									.parse(channelInfoNoticeStr);
							if (channelInfoNotice.getChannelInfo().isSetEmailAddress()) {
								solicitante.setMail(channelInfoNotice.getChannelInfo().getEmailAddress());
							} else if (channelInfoNotice.getChannelInfo().isSetSmsNumber()) {
								solicitante.setTelefono(channelInfoNotice.getChannelInfo().getSmsNumber());
							}
						}
					}
				}
			}
			// DATOS AVISO FIN
			// DOCUMENTOS INICIO
			if (documentsBO != null && documentsBO.sizeOfDocumentBOArray() > 0) {
				List<Documento> documentosAdjuntos = new ArrayList<Documento>();
				Documento documentoAdjunto = null;
				for (int i = 0; i < documentsBO.getDocumentBOArray().length; i++) {
					if (Y41bUtils.isFilled(documentsBO.getDocumentBOArray(i).getOid())) {
						documentoAdjunto = new Documento();
						documentoAdjunto.setOidDokusi(documentsBO.getDocumentBOArray(i).getOid());
						documentoAdjunto.setNombre(documentsBO.getDocumentBOArray(i).getSourceName());
						documentoAdjunto.setDescripcion(
								documentsBO.getDocumentBOArray(i).getDescriptors().getDescriptorArray(0).getValue());
						documentosAdjuntos.add(documentoAdjunto);
					}
				}
				solicitudTelematica.setDocumentosAdjuntos(documentosAdjuntos);
			}
			// DOCUMENTOS FIN
			solicitudTelematica.setSolicitante(solicitante);
			solicitudTelematica.setRepresentante(representante);
			return solicitudTelematica;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e_getSolicitudTelematica) {
			logger.error("Y41bTratamientoPlateaJMSServiceImpl.getSolicitudTelematica", e_getSolicitudTelematica);
			throw new Y41bUDAException("error.platea.invocation", true, e_getSolicitudTelematica);
		} finally {
			logger.info("Y41bTratamientoPlateaJMSServiceImpl.getSolicitudTelematica - Final");
		}
	}

	/**
	 * createChannelInfoByStr
	 * 
	 * @param oXmlChannelInfo
	 *            com.bea.xml.XmlObject
	 * @return String
	 * @throws Exception
	 *             Cualquier excepcion
	 */
	private String createChannelInfoByStr(com.bea.xml.XmlObject oXmlChannelInfo) throws Exception {
		Y41bTratamientoPlateaJMSServiceImpl.logger
				.info("Y41bTratamientoPlateaJMSServiceImpl.createChannelInfoByStr - Inicio");
		try {
			StringBuffer channelInfoNotifStrBuf = new StringBuffer();
			// Quitamos namespaces
			String channelInfoNotifStr = Y41bXMLUtils.quitarNameSpaces(oXmlChannelInfo).xmlText();
			// Quitamos xml-fragment
			channelInfoNotifStr = Y41bXMLUtils.quitarXMLFragment(channelInfoNotifStr);
			// Añadimos channelInfo
			channelInfoNotifStrBuf.append(Y41bJMSConstantes.ETIQUETA_CHANNELINFO_INI_XMLNS).append(channelInfoNotifStr)
					.append(Y41bJMSConstantes.ETIQUETA_CHANNELINFO_FIN);
			return channelInfoNotifStrBuf.toString();
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e_createChannelInfoByStr) {
			logger.error("Y41bTratamientoPlateaJMSServiceImpl.createChannelInfoByStr", e_createChannelInfoByStr);
			throw new Y41bUDAException("error.platea.invocation", true, e_createChannelInfoByStr);
		} finally {
			logger.info("Y41bTratamientoPlateaJMSServiceImpl.createChannelInfoByStr - Final");
		}
	}

	/**
	 * Envia un mail al recibir una nueva denuncia de empresa telematica
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 */
	private void enviarEmailNuevaDenunciaEmpresa(SolicitudDetalle solicitudDetalle) {
		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

		String smtpMail = (String) prop.getProperty("y41bVistaWar.mail.ejie.smtp");

		// Remitente
		String from = "";
		Parametros parametros = new Parametros();

		parametros.setParametro(Y41bConstantes.PARAMETRO_CONTROLMERCADO_FROMGENERICO);
		parametros = this.parametrosService.find(parametros);

		if (parametros != null && (parametros.getValor() == null || parametros.getValor().equals(""))) {
			throw new Y41bUDAException("error.parametro.CONTROLMERCADO_FROMGENERICO_EMAIL", true, new Exception());
		} else {
			from = parametros.getValor();
		}

		// Destinatarios
		CensoMonitor censoMonitor = new CensoMonitor();
		List<CensoMonitor> listCensoMonitor = this.censoMonitorService
				.findAllCensoMonitorDenunciaEmpresas(censoMonitor);

		StringBuffer destinatarios = new StringBuffer("");
		for (CensoMonitor censoMonitorAux : listCensoMonitor) {
			if (Y41bUtils.isFilled(censoMonitorAux.getMocoem())) {
				if (destinatarios.toString().equals("")) {
					destinatarios.append(censoMonitorAux.getMocoem());
				} else {
					destinatarios.append(";").append(censoMonitorAux.getMocoem());
				}
			}
		}

		// 2. Asunto del mail
		StringBuffer asunto = new StringBuffer();
		asunto.append(this.appMessageSource.getMessage("solicitud.nuevadenunciaempresa.mail.asunto", null,
				new Locale(Y41bConstantes.CASTELLANO)));

		// 3. Creo el contenido del mail
		StringBuffer texto = new StringBuffer();
		String[] params1 = new String[Y41bConstantes.NUM_2];
		params1[0] = solicitudDetalle.getNumExpediente();

		texto.append(this.appMessageSource.getMessage("solicitud.nuevadenunciaempresa.mail.texto", params1,
				new Locale(Y41bConstantes.CASTELLANO)));

		if (!destinatarios.toString().equals("")) {
			boolean enviadoOK = Y41bUtils.sendMail(smtpMail, asunto.toString(), texto.toString(), from,
					destinatarios.toString(), "", null);
			if (!enviadoOK) {
				throw new Y41bUDAException("error.comunicacion.email", true, new Exception());
			}
		}
	}

	/**
	 * Recupera los datos de la solicitudTelematica para Y41B a partir de los
	 * datos recibidos en el evento de solicitud.
	 * 
	 * @param contextSubmission
	 *            ContextSubmission
	 * @param documentsBO
	 *            documents
	 * @param procedureId
	 *            String
	 * @param registryNumber
	 *            String
	 * @param registryTimestamp
	 *            String
	 * @param accionTelematica
	 *            String
	 * @param mensajeCola
	 *            String
	 * @return Solicitud
	 * @throws Exception
	 *             Cualquier excepcion
	 */
	public SolicitudTelematicaEventos getSolicitudFromEventSolicitud(Map mapaMensaje, String mensajeCola)
			throws Exception {
		logger.info("Y41bTratamientoPlateaJMSServiceImpl.getSolicitudFromEventSolicitud - Inicio");
		try {

			// Recuperar informacion del mapa
			String procedureId = (String) mapaMensaje.get("procedureID");
			String folderNumber = (String) mapaMensaje.get("folderNumber");
			String registryTimestamp = (String) mapaMensaje.get("registryTimestamp");
			String accionTelematica = (String) mapaMensaje.get("EventWhat");
			String registryNumber = (String) mapaMensaje.get("registryNumber");
			String documentsBOStr = (String) mapaMensaje.get("documents");

			SolicitudTelematicaEventos solicitudTelematicaEventos = new SolicitudTelematicaEventos();

			if (Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES.equalsIgnoreCase(procedureId)) {
				solicitudTelematicaEventos.setStTipoExpediente(Y41bConstantes.TIPO_PROC_SOLICITUDES);
			} else if (Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES.equalsIgnoreCase(procedureId)) {
				solicitudTelematicaEventos.setStTipoExpediente(Y41bConstantes.TIPO_PROC_INSPECCIONES);
			} else if (Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES.equalsIgnoreCase(procedureId)) {
				solicitudTelematicaEventos.setStTipoExpediente(Y41bConstantes.TIPO_PROC_SANCIONES);
			} else if (Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE.equalsIgnoreCase(procedureId)) {
				solicitudTelematicaEventos.setStTipoExpediente(Y41bConstantes.TIPO_PROC_ARBITRAJE);
			} else if (Y41bConstantes.ID_PROCEDIMIENTO_ADHALTA.equalsIgnoreCase(procedureId)) {
				solicitudTelematicaEventos.setStTipoExpediente(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA);
			} else if (Y41bConstantes.ID_PROCEDIMIENTO_ADHMODIF.equalsIgnoreCase(procedureId)) {
				solicitudTelematicaEventos.setStTipoExpediente(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD);
			} else if (Y41bConstantes.ID_PROCEDIMIENTO_ADHBAJA.equalsIgnoreCase(procedureId)) {
				solicitudTelematicaEventos.setStTipoExpediente(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA);
			}

			solicitudTelematicaEventos.setStNumExpediente(folderNumber);
			solicitudTelematicaEventos.setStFechaRegistro(Y41bUtils.parseRegistrytimestamp(registryTimestamp));

			// 0173789: No quieren reenviar las PUBLISH
			if (accionTelematica.equalsIgnoreCase(Y41bConstantes.MANAGE_NOTIFICATION_EXPIRATION)) {
				// ||
				// accionTelematica.equalsIgnoreCase(Y41bConstantes.PUBLISH_NOTIFICATION_DELIVERY))
				// {
				accionTelematica = Y41bConstantes.ACCION_TELEMATICA_NOTIFICACION;
			}

			solicitudTelematicaEventos.setStIdAccionTelematica(accionTelematica);
			solicitudTelematicaEventos.setStNumRegistro(registryNumber);
			solicitudTelematicaEventos.setStXMLSolicitud(Y41bUtils.stringToClob(mensajeCola));

			if (documentsBOStr != null) {// && documentsBOStr != "") {
				DocumentsBO documents = this.getDocumentsBOFromSolicitud(mapaMensaje);
				// Documentos inicio
				if (documents != null && documents.sizeOfDocumentBOArray() > 0) {
					List<DocumentoSolicitudTelematicaEventos> listaDocumentosSolicitudTelematicaEventos = new ArrayList<DocumentoSolicitudTelematicaEventos>();
					DocumentoSolicitudTelematicaEventos documentoSolicitudTelematicaEventos = null;
					String tipodocumento = null;
					for (int i = 0; i < documents.getDocumentBOArray().length; i++) {
						if (Y41bUtils.isFilled(documents.getDocumentBOArray(i).getOid())) {
							documentoSolicitudTelematicaEventos = new DocumentoSolicitudTelematicaEventos();
							documentoSolicitudTelematicaEventos
									.setDsOIDDokusi(documents.getDocumentBOArray(i).getOid());
							documentoSolicitudTelematicaEventos
									.setDsNoFile(documents.getDocumentBOArray(i).getSourceName());
							if (documents.getDocumentBOArray(i).getRoleId() != null) {
								tipodocumento = this.getTipoDocumento(documents.getDocumentBOArray(i).getRoleId());
							}
							documentoSolicitudTelematicaEventos.setDsCodTipoDoc(tipodocumento);

							listaDocumentosSolicitudTelematicaEventos.add(documentoSolicitudTelematicaEventos);
						}
					}
					solicitudTelematicaEventos
							.setDocumentoSolicitudTelematicaEventos(listaDocumentosSolicitudTelematicaEventos);
				}
				// Documentos Fin
			}
			return solicitudTelematicaEventos;
		} catch (Y41bUDAException e) {
			logger.error("Y41bTratamientoPlateaJMSServiceImpl.getSolicitudFromEventSolicitud", e);
			throw e;
		} catch (Exception e_getSolicitudFromSolicitudes) {
			logger.error("Y41bTratamientoPlateaJMSServiceImpl.getSolicitudFromEventSolicitud",
					e_getSolicitudFromSolicitudes);
			throw new Y41bUDAException(Y41bConstantes.PLATEA_LITERAL_GENERAL, true, e_getSolicitudFromSolicitudes);
		} finally {
			logger.info("Y41bTratamientoPlateaJMSServiceImpl.getSolicitudFromEventSolicitud - Final");
		}
	}

	/**
	 * getTipoDocumento
	 * 
	 * @param roleId
	 *            String
	 * @return String
	 */
	protected String getTipoDocumento(String roleId) {
		StringTokenizer tokCadena = null;
		tokCadena = new StringTokenizer(roleId, ".");
		String tipo = tokCadena.nextToken();
		String subtipo = tokCadena.nextToken();
		if (subtipo != null && !subtipo.equals("0")) {
			tipo = subtipo;
		}

		return tipo;
	}
}
