package com.ejie.y41b.jms;

import java.util.Map;
import java.util.Properties;

import javax.jms.Message;
import javax.jms.TextMessage;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.y41b.constantes.Y41bJMSConstantes;
import com.ejie.y41b.jms.helper.Y41bJMSHelper;
import com.ejie.y41b.model.Mensajecola;
import com.ejie.y41b.service.MensajecolaService;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * Y41bTratamientoJMSServiceImpl Clase encargada del tratamiento de los mensajes
 * recibidos en la cola JMS
 * 
 *  
 * 
 */
@Service(value = "y41bTratamientoJMSService")
public class Y41bTratamientoJMSServiceImpl implements Y41bTratamientoJMSService {
	private static final Logger logger = LoggerFactory.getLogger(Y41bTratamientoJMSServiceImpl.class);

	@Autowired
	private Properties appConfiguration;

	@Autowired
	private Y41bTratamientoPlateaJMSService tratamientoPlateaJMS;

	@Autowired
	private Y41bTratamientoDokusiJMSService tratamientoDokusiJMS;

	@Autowired
	private MensajecolaService mensajecolaService;

	/**
	 * Constructor privado
	 */
	private Y41bTratamientoJMSServiceImpl() {
		super();
	}

	/**
	 * onMessage
	 * 
	 * @param inMessage
	 *            mensaje de entrada
	 * @throws Throwable
	 *             Throwable
	 */
	public synchronized void onMessage(Message inMessage) throws Throwable {
		Y41bTratamientoJMSServiceImpl.logger.info("Y41bTratamientoJMSServiceImpl.onMessage - Inicio");
		String tokenAppSesion = com.ejie.y41b.utils.xlnets.Y41bUtils.getInstance()
				.getTokenAplicacion(Boolean.parseBoolean(appConfiguration.getProperty("xlnets.loginApp.isSimulated")));
		TextMessage msg = null;
		// Mensaje msgDO se usa para guardar en BBDD
		Mensajecola mensajecola = new Mensajecola();
		try {
			if (inMessage instanceof TextMessage) {
				msg = (TextMessage) inMessage;
				Y41bTratamientoJMSServiceImpl.logger.debug("TEXTMESSAGE beans: " + msg.getText());
				Y41bTratamientoJMSServiceImpl.logger.debug("ANTES de parsearMensajeJms ");
				Map mapaMensaje = Y41bJMSHelper.parsearMensajeJms(msg.getText());
				Y41bTratamientoJMSServiceImpl.logger.debug("DESPUES de parsearMensajeJms ");

				Y41bTratamientoJMSServiceImpl.logger.debug("ANTES de BBDD guardar mensaje ");

				mensajecola.setSwidprocedure((String) mapaMensaje.get("procedureID"));
				mensajecola.setSwmensaje(msg.getText());
				mensajecola.setSwdtipomensaje((String) mapaMensaje.get("EventWhat"));
				mensajecola.setSwdnumexp((String) mapaMensaje.get("folderNumber"));
				mensajecola.setSwnumreg((String) mapaMensaje.get("registryNumber"));
				mensajecola.setSwfecreg((String) mapaMensaje.get("registryTimestamp"));
				mensajecola.setSwjmsmessageid(msg.getJMSMessageID());

				this.mensajecolaService.add(mensajecola);

				Y41bTratamientoJMSServiceImpl.logger.debug("DESPUES de BBDD guardar mensaje ");

				String strTipoMensaje = (String) mapaMensaje.get("EventTipology");
				Y41bTratamientoJMSServiceImpl.logger.debug("TIPO_MENSAJE_SOLICITUD: " + strTipoMensaje);

				// Dependiendo del tipo de mensaje, se realiza una accion
				if (Y41bJMSConstantes.MENSAJE_SOLICITUD.equals(strTipoMensaje)) {
					if (Y41bJMSConstantes.SUBMISSIONTYPE_SOLICITUD.equals((String) mapaMensaje.get("submissionType"))
							&& (!"1.0".equals((String) mapaMensaje.get("version")))) {
						Y41bTratamientoJMSServiceImpl.logger
								.debug("El mensaje : " + strTipoMensaje + " entra al tratamiento de solicitudes");
						tratamientoPlateaJMS.tratamientoSolicitudes(tokenAppSesion, mapaMensaje, msg.getText());
					} else {
						Y41bTratamientoJMSServiceImpl.logger.debug(
								"El mensaje : " + strTipoMensaje + " no ha entrado al tratamiento de solicitudes");
					}
				} else if (Y41bJMSConstantes.MENSAJE_APORTACION_DOC.equals(strTipoMensaje)
						&& (!"1.0".equals((String) mapaMensaje.get("version")))) {
					Y41bTratamientoJMSServiceImpl.logger.debug(
							"El mensaje : " + strTipoMensaje + " entra al tratamiento de aportacion documentacion");
					tratamientoPlateaJMS.tratamientoAportacionDocumentacion(tokenAppSesion, mapaMensaje, msg.getText());
				} else if (Y41bJMSConstantes.MENSAJE_ACUSES.equals(strTipoMensaje)) {
					Y41bTratamientoJMSServiceImpl.logger
							.debug("El mensaje : " + strTipoMensaje + " entra al tratamiento de acuses");
					tratamientoPlateaJMS.tratamientoAcuses(tokenAppSesion, mapaMensaje, msg.getText());
				} else if (Y41bJMSConstantes.MENSAJE_LOCATOR.equals(strTipoMensaje)) {
					Y41bTratamientoJMSServiceImpl.logger
							.debug("El mensaje : " + strTipoMensaje + " entra al tratamiento de locator");
					tratamientoDokusiJMS.tratamientoLocalizador(tokenAppSesion, mapaMensaje);
				} else if (Y41bJMSConstantes.MENSAJE_TRANSFORMATION.equals(strTipoMensaje)) {
					Y41bTratamientoJMSServiceImpl.logger
							.debug("El mensaje : " + strTipoMensaje + " entra al tratamiento de transformacion");
					tratamientoDokusiJMS.tratamientoLocalizador(tokenAppSesion, mapaMensaje);
				} else if (Y41bJMSConstantes.MENSAJE_ERROR.equals(strTipoMensaje)) {
					Y41bTratamientoJMSServiceImpl.logger.debug(
							"El mensaje : " + strTipoMensaje + " entra al tratamiento de error - En Construccion");
					// TODO Pendiente de definir
				} else {
					Y41bTratamientoJMSServiceImpl.logger
							.debug("El mensaje : " + strTipoMensaje + " no esta controlado");
				}
			}
		} catch (Throwable e_onMessage) {
			Y41bTratamientoJMSServiceImpl.logger.error("Y41bTratamientoJMSServiceImpl.onMessage - Error", e_onMessage);
			mensajecola = new Mensajecola();
			mensajecola.setSwmensaje(((TextMessage) inMessage).getText());
			mensajecola.setSwdtipomensaje("ERROR_JMS");
			mensajecola.setSwfecreg(Y41bUtils.fncPresentarFechaSistemaTimeStamp(false));
			mensajecola.setSwjmsmessageid(((TextMessage) inMessage).getJMSMessageID());
			mensajecolaService.add(mensajecola);
		} finally {
			// TODO Se debería llamar al Service de control de auditoria
			// encargado de guardar en
			// BBDD el mensaje para AUDITARLO
			Y41bTratamientoJMSServiceImpl.logger.debug("Se guarda en BBDD el msg:" + mensajecola.toString());
			Y41bTratamientoJMSServiceImpl.logger.info("Y41bTratamientoJMSServiceImpl.onMessage - Fin");
		}
	}
}
