package com.ejie.y41b.jms;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.jms.DeliveryMode;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.y41b.adapter.Y41bDokusiAdapterService;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.AsientoRegistral;
import com.ejie.y41b.model.DocumentoAsientoRegistral;
import com.ejie.y41b.model.Mensajecola;
import com.ejie.y41b.model.SolicitudTelematicaEventos;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.User;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.model.sir.NotificationBody;
import com.ejie.y41b.model.sir.NotificationBody.XmlValue.InputRegister.Documents.DocumentOid;
import com.ejie.y41b.service.AsientoRegistralService;
import com.ejie.y41b.service.SolicitudesTelematicasEventosService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.config.Y41bConfig;

/**
 * Y41bSirJMSServiceImpl Clase encargada del tratamiento de los mensajes
 * recibidos en la cola JMS para el SIR
 * 
 *  
 * 
 */
@Service(value = "y41bSirJMSService")
public class Y41bSirJMSServiceImpl implements Y41bSirJMSService {
	private static final Logger logger = LoggerFactory.getLogger(Y41bSirJMSServiceImpl.class);

	@Autowired
	private AsientoRegistralService asientoRegistralService;

	@Autowired()
	private Y41bDokusiAdapterService y41bDokusiAdapterService;

	@Autowired
	private SolicitudesTelematicasEventosService solicitudesTelematicasEventosService;

	/**
	 * Constructor privado
	 */
	private Y41bSirJMSServiceImpl() {
		super();
	}

	/**
	 * onMessage
	 * 
	 * @param inMessage
	 *            mensaje de entrada
	 * @throws Throwable
	 *             Throwable
	 */
	public synchronized void onMessage(Message inMessage) throws Throwable {
		Y41bSirJMSServiceImpl.logger.info("Y41bSirJMSServiceImpl.onMessage - Inicio");
		TextMessage msg = null;
		Mensajecola mensajecola = new Mensajecola();

		try {
			if (inMessage instanceof TextMessage) {
				// para probar SIR a tabla de mensajes para reenvio
				// int i = 1 / 0;

				msg = (TextMessage) inMessage;
				Y41bSirJMSServiceImpl.logger.debug("TEXTMESSAGE beans: " + msg.getText());

				// Parseo del XML mediante JAXB
				JAXBContext jaxbContext;
				NotificationBody objetoNotificationBody = null;

				jaxbContext = JAXBContext.newInstance(NotificationBody.class);
				Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();

				StringReader reader = new StringReader(
						StringEscapeUtils.unescapeHtml(msg.getText()).replaceAll("xsi:nil=\"true\"", ""));
				objetoNotificationBody = (NotificationBody) jaxbUnmarshaller.unmarshal(reader);

				String pcodigo = objetoNotificationBody.getXmlValue().getInputRegister().getProcedure();
				Y41bSirJMSServiceImpl.logger.debug("PROCEDIMIENTO: " + pcodigo);

				String numregistro = objetoNotificationBody.getXmlValue().getInputRegister().getRegistryNumber();
				Y41bSirJMSServiceImpl.logger.debug("NUMERO REGISTRO ENTRADA: " + numregistro);

				Date fecha = Y41bUtils.formatearStringToDateFormato(
						objetoNotificationBody.getXmlValue().getInputRegister().getRegistryDate(),
						Y41bConstantes.FORMATO_FECHAHORA_SIR);
				String fechaConvertida = Y41bUtils.formatearDateToString(fecha,
						Y41bConstantes.FORMATO_FECHAHORALARGA_ES);

				Y41bSirJMSServiceImpl.logger.debug("FECHA REGISTRO ENTRADA: " + fechaConvertida);

				// 209010
				String solicitante = "";
				if (objetoNotificationBody.getXmlValue().getInputRegister().getPersons().getPerson() != null) {
					solicitante = objetoNotificationBody.getXmlValue().getInputRegister().getPersons().getPerson()
							.getName();
				}

				Y41bSirJMSServiceImpl.logger.debug("SOLICITANTE: " + solicitante);

				String resumen = objetoNotificationBody.getXmlValue().getInputRegister().getResumen();
				Y41bSirJMSServiceImpl.logger.debug("RESUMEN: " + resumen);

				String territorioHistorico = objetoNotificationBody.getXmlValue().getInputRegister()
						.getTerritorioHistorico();
				Y41bSirJMSServiceImpl.logger.debug("TERRITORIOHISTORICO: " + territorioHistorico);

				String originalRegistryNumber = objetoNotificationBody.getXmlValue().getInputRegister()
						.getOriginalRegistryNumber();
				Y41bSirJMSServiceImpl.logger.debug("ORIGINALREGISTRYNUMBER: " + originalRegistryNumber);

				Date fechaOrigen = null;
				String fechaOrigenConvertida = "";
				if (objetoNotificationBody.getXmlValue().getInputRegister().getOriginalRegistryDate() != null
						&& !objetoNotificationBody.getXmlValue().getInputRegister().getOriginalRegistryDate()
								.isEmpty()) {
					fechaOrigen = Y41bUtils.formatearStringToDateFormato(
							objetoNotificationBody.getXmlValue().getInputRegister().getOriginalRegistryDate(),
							Y41bConstantes.FORMATO_FECHAHORA_SIR);
					fechaOrigenConvertida = Y41bUtils.formatearDateToString(fechaOrigen,
							Y41bConstantes.FORMATO_FECHAHORALARGA_ES);

					Y41bSirJMSServiceImpl.logger.debug("ORIGINALREGISTRYDATE: " + fechaOrigenConvertida);
				} else {

					Y41bSirJMSServiceImpl.logger.debug("ORIGINALREGISTRYDATE: null");
				}

				if (Y41bConstantes.COD_PROCEDIMIENTO_SOLICITUDES.equalsIgnoreCase(pcodigo)) {
					pcodigo = Y41bConstantes.TIPO_PROC_SOLICITUDES;
				} else if (Y41bConstantes.COD_PROCEDIMIENTO_INSPECCIONES.equalsIgnoreCase(pcodigo)) {
					pcodigo = Y41bConstantes.TIPO_PROC_INSPECCIONES;
				} else if (Y41bConstantes.COD_PROCEDIMIENTO_SANCIONES.equalsIgnoreCase(pcodigo)) {
					pcodigo = Y41bConstantes.TIPO_PROC_SANCIONES;
				} else if (Y41bConstantes.COD_PROCEDIMIENTO_ARBITRAJE.equalsIgnoreCase(pcodigo)) {
					pcodigo = Y41bConstantes.TIPO_PROC_ARBITRAJE;
					territorioHistorico = Y41bConstantes.CODIGO_PROVINCIA_ARABA;
					Y41bSirJMSServiceImpl.logger
							.debug("TERRITORIOHISTORICO cambiado para ARBITRAJE a: " + territorioHistorico);
				} else if (Y41bConstantes.COD_PROCEDIMIENTO_ADHALTA.equalsIgnoreCase(pcodigo)) {
					pcodigo = Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA;
				} else if (Y41bConstantes.COD_PROCEDIMIENTO_ADHMODIF.equalsIgnoreCase(pcodigo)) {
					pcodigo = Y41bConstantes.TIPO_PROC_ADHESIONES_MOD;
				} else if (Y41bConstantes.COD_PROCEDIMIENTO_ADHBAJA.equalsIgnoreCase(pcodigo)) {
					pcodigo = Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA;
				}

				Locale localeCastellano = new Locale(Y41bConstantes.CASTELLANO);

				AsientoRegistral asientoRegistral = new AsientoRegistral();
				asientoRegistral.setPcodigo(pcodigo);

				asientoRegistral.setFechaRegistro(Y41bUtils.parseDateTime(fechaConvertida, localeCastellano));
				asientoRegistral.setNumRegistro(numregistro);
				asientoRegistral.setSolicitante(solicitante);
				asientoRegistral.setResumen(resumen);
				asientoRegistral.setTerritorioHistorico(territorioHistorico);
				asientoRegistral
						.setFechaRegistroOrigen(Y41bUtils.parseDateTime(fechaOrigenConvertida, localeCastellano));
				asientoRegistral.setNumRegistroOrigen(originalRegistryNumber);

				// if
				// (objetoNotificationBody.getXmlValue().getInputRegister().getDocuments().getDocumentOid()
				// != null) {
				//
				// }

				List<DocumentoAsientoRegistral> listaDocumentoAsientoRegistral = new ArrayList<DocumentoAsientoRegistral>();
				DocumentoAsientoRegistral documentoAsientoRegistral = null;

				for (DocumentOid documentOid : objetoNotificationBody.getXmlValue().getInputRegister().getDocuments()
						.getDocumentOid()) {

					String oidDokusi = documentOid.getId();
					Y41bSirJMSServiceImpl.logger.debug("DOCUMENTOS: " + oidDokusi);

					Documento documento = new Documento();
					User user = new User();
					user.setNombre(Y41bConstantes.COD_APLICACION);
					user.setDni(Y41bConstantes.COD_APLICACION);
					documento.setUser(user);
					Procedure procedure = new Procedure();
					procedure.setIdProcedimiento(pcodigo);
					documento.setProcedure(procedure);

					documento.setOidDokusi(oidDokusi);

					Documento documentoRdo = y41bDokusiAdapterService.descargarDocumentoSIR(documento);

					documentoAsientoRegistral = new DocumentoAsientoRegistral();
					documentoAsientoRegistral.setOidDokusi(oidDokusi);
					if (documentoRdo.getTipoDocumental() != null) {
						documentoAsientoRegistral.setTipoDoc(documentoRdo.getTipoDocumental());
					} else {
						documentoAsientoRegistral.setTipoDoc("");
					}

					documentoAsientoRegistral.setLiteralTipoDoc("");
					if (documentoRdo.getNombre() != null) {
						documentoAsientoRegistral.setDescDoc(
								documentoRdo.getNombre().substring(0, documentoRdo.getNombre().lastIndexOf(".")));
					} else {
						documentoAsientoRegistral.setDescDoc("");
					}

					listaDocumentoAsientoRegistral.add(documentoAsientoRegistral);
				}

				asientoRegistral.setDocumentoAsientoRegistral(listaDocumentoAsientoRegistral);
				asientoRegistral = this.asientoRegistralService.addAsientoRegistral(asientoRegistral);

			}
		} catch (Throwable e_onMessage) {
			Y41bSirJMSServiceImpl.logger.error("Y41bTratamientoJMSServiceImpl.onMessage - Error", e_onMessage);

			if (inMessage instanceof TextMessage) {

				msg = (TextMessage) inMessage;

				SolicitudTelematicaEventos solicitudTelematicaEventos = new SolicitudTelematicaEventos();
				solicitudTelematicaEventos.setStIdAccionTelematica(Y41bConstantes.TEXTO_SIR);
				solicitudTelematicaEventos.setStXMLSolicitud(Y41bUtils.stringToClob(msg.getText()));

				solicitudTelematicaEventos.setStTipoExpediente(null);

				solicitudTelematicaEventos = this.solicitudesTelematicasEventosService
						.addSolicitudTelematicaEventos(solicitudTelematicaEventos);
			}
		} finally {
			Y41bSirJMSServiceImpl.logger.debug("Se guarda en BBDD el msg:" + mensajecola.toString());
			Y41bSirJMSServiceImpl.logger.info("Y41bTratamientoJMSServiceImpl.onMessage - Fin");
		}
	}

	public void sendMessage(String messageText) {
		InitialContext ctx = null;
		QueueConnectionFactory qcf = null;
		QueueConnection qc = null;
		QueueSession qsess = null;
		Queue q = null;
		QueueSender qsndr = null;
		TextMessage message = null;
		// NOTE: The next two lines set the name of the Queue Connection Factory
		// and the Queue that we want to use.

		// TODO Crear carpeta con el id de remesa
		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
		// SE especifica la ruta temporal de las remesas

		String QCF_NAME = prop.getProperty("jndi.jsm.sirFactory");
		String QUEUE_NAME = prop.getProperty("jndi.jsm.sirQueue");

		// create InitialContext
		Hashtable properties = new Hashtable();
		properties.put(Context.INITIAL_CONTEXT_FACTORY, "weblogic.jndi.WLInitialContextFactory");
		try {
			ctx = new InitialContext(properties);
		} catch (NamingException ne) {
			ne.printStackTrace(System.err);
		}
		logger.debug("Got InitialContext " + ctx.toString());
		// create QueueConnectionFactory
		try {
			qcf = (QueueConnectionFactory) ctx.lookup(QCF_NAME);
		} catch (NamingException ne) {
			logger.error("ERROR JMS: " + ne.getMessage());
		}
		logger.debug("Got QueueConnectionFactory " + qcf.toString());
		// create QueueConnection
		try {
			qc = qcf.createQueueConnection();
		} catch (JMSException jmse) {
			logger.error("ERROR JMS: " + jmse.getMessage());
		}
		logger.debug("Got QueueConnection " + qc.toString());
		// create QueueSession
		try {
			qsess = qc.createQueueSession(false, 0);
		} catch (JMSException jmse) {
			logger.error("ERROR JMS: " + jmse.getMessage());
		}
		logger.debug("Got QueueSession " + qsess.toString());
		// lookup Queue
		try {
			q = (Queue) ctx.lookup(QUEUE_NAME);
		} catch (NamingException ne) {
			logger.error("ERROR JMS: " + ne.getMessage());
		}
		logger.debug("Got Queue " + q.toString());
		// create QueueSender
		try {
			qsndr = qsess.createSender(q);
		} catch (JMSException jmse) {
			logger.error("ERROR JMS: " + jmse.getMessage());
		}
		logger.debug("Got QueueSender " + qsndr.toString());
		// create TextMessage
		try {
			message = qsess.createTextMessage();
			message.setJMSExpiration(100000);
			message.setJMSDeliveryMode(DeliveryMode.NON_PERSISTENT);
		} catch (JMSException jmse) {
			logger.error("ERROR JMS: " + jmse.getMessage());
		}
		logger.debug("Got TextMessage " + message.toString());
		// set message text in TextMessage
		try {
			message.setText(messageText);
		} catch (JMSException jmse) {
			logger.error("ERROR JMS: " + jmse.getMessage());
		}
		logger.debug("Set text in TextMessage " + message.toString());
		// send message
		try {
			qsndr.send(message);
		} catch (JMSException jmse) {
			logger.error("ERROR JMS: " + jmse.getMessage());
		}
		logger.debug("Sent message ");
		// clean up
		try {
			message = null;
			qsndr.close();
			qsndr = null;
			q = null;
			qsess.close();
			qsess = null;
			qc.close();
			qc = null;
			qcf = null;
			ctx = null;
		} catch (JMSException jmse) {
			logger.error("ERROR JMS: " + jmse.getMessage());
		}
		logger.debug("Cleaned up and done.");
	}

}