package com.ejie.y41b.jms;

import java.util.Iterator;
import java.util.Map;

import javax.jms.MapMessage;
import javax.jms.Message;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.utils.ws.Y41bUtilsWS;

/**
 * Y41bRemesasJMSServiceImpl Clase encargada del tratamiento de los mensajes
 * recibidos en la cola JMS
 * 
 *  
 * 
 */
@Service(value = "y41bRemesasJMSService")
public class Y41bRemesasJMSServiceImpl implements Y41bRemesasJMSService {
	private static final Logger logger = LoggerFactory
			.getLogger(Y41bRemesasJMSServiceImpl.class);

	@Autowired
	private Y41bRemesasEmisionJMSService remesasEmisionJMS;

	// @Autowired
	// private RemesaService remesaService;

	/**
	 * Constructor privado
	 */
	private Y41bRemesasJMSServiceImpl() {
		super();
	}

	/**
	 * onMessage
	 * 
	 * @param inMessage
	 *            mensaje de entrada
	 * @throws Throwable
	 *             Throwable
	 */
	public synchronized void onMessage(Message inMessage) throws Throwable {
		Y41bRemesasJMSServiceImpl.logger
				.info("Y41bRemesasJMSServiceImpl.onMessage - Inicio");
		MapMessage msg = null;
		try {
			if (inMessage instanceof MapMessage) {
				msg = (MapMessage) inMessage;

				String operacionRemesa = "";
				String idRemesa = "";
				if (msg != null) {
					if (msg.itemExists(Y41bConstantes.OPERACION_REMESA)) {
						operacionRemesa = Y41bUtilsWS.decodeToString(msg
								.getString(Y41bConstantes.OPERACION_REMESA));
					}
					if (msg.itemExists(Y41bConstantes.CODIGO_REMESA)) {
						idRemesa = Y41bUtilsWS.decodeToString(msg
								.getString(Y41bConstantes.CODIGO_REMESA));
					}
				}

				Y41bRemesasJMSServiceImpl.logger.debug("OPERACION_REMESA: "
						+ operacionRemesa);
				Y41bRemesasJMSServiceImpl.logger.debug("CODIGO_REMESA: "
						+ idRemesa);

				// Dependiendo del tipo de mensaje, se realiza una accion
				if (Y41bConstantes.OPERACION_REMESA_GENERAR_REMESA
						.equals(operacionRemesa)) {

					remesasEmisionJMS.generarRemesa(idRemesa);

				} else if (Y41bConstantes.OPERACION_REMESA_ACTUALIZAR_ESTADO_TODAS_REMESAS
						.equals(operacionRemesa)) {
					// IMPORTANTE:
					// "Despues de la release de febrero del 2017 en desuso. Se opta por mensaje por remesas en vez de por todas las remesas (por el tiempo que tarda en PROD)."

					Map<String, Object> mapaResultados = remesasEmisionJMS
							.actualizarEstadoTodasRemesas();

					if (mapaResultados.isEmpty()) {
						Y41bRemesasJMSServiceImpl.logger
								.info("Y41bRemesasJMSServiceImpl.onMessage. NO HAY REMESAS PENDIENTES DE ACTUALIZAR ENVIOS.");

					} else {

						StringBuffer strBfResultado = new StringBuffer(
								"\nRESUMEN DE LAS REMESAS QUE SE HA INTENTADO ACTUALIZAR");

						Iterator<String> listaKeysAux = mapaResultados.keySet()
								.iterator();
						while (listaKeysAux.hasNext()) {
							String codigoRemesaAux = (String) listaKeysAux
									.next();

							strBfResultado.append("\n   REMESA ");
							strBfResultado.append(codigoRemesaAux);
							strBfResultado.append(": ");
							strBfResultado.append(mapaResultados
									.get(codigoRemesaAux));
						}

						Y41bRemesasJMSServiceImpl.logger
								.info("Y41bRemesasJMSServiceImpl.onMessage. PROCESO FINALIZADO DE JMS: OK."
										+ strBfResultado.toString());
					}

				} else if (Y41bConstantes.OPERACION_REMESA_ACTUALIZAR_ESTADO_UNA_REMESA
						.equals(operacionRemesa)) {

					remesasEmisionJMS.actualizarEstadoUnaRemesa(idRemesa);

				} else if (Y41bConstantes.OPERACION_REMESA_ACTUALIZAR_MISGESTIONES
						.equals(operacionRemesa)) {

					remesasEmisionJMS.actualizarMisGestiones(idRemesa);

				} else {
					Y41bRemesasJMSServiceImpl.logger.debug("El mensaje : "
							+ operacionRemesa + " no esta controlado");
				}
			}

		} catch (Throwable e_onMessage) {
			Y41bRemesasJMSServiceImpl.logger.error(
					"Y41bRemesasJMSServiceImpl.onMessage - Error", e_onMessage);
			/*
			 * Remesa remesaErronea = new Remesa();
			 * remesaErronea.setRmcodigo(msg.getText());
			 * remesaErronea.setRmestado(Y41bConstantes.ESTADO_REMESA_ERRONEA);
			 * remesaService.updateEstadoRemesa(remesaErronea);
			 */
			// throw new Y41bUDAException("error.generico", true, e_onMessage);
		} finally {
			Y41bRemesasJMSServiceImpl.logger
					.info("Y41bRemesasJMSServiceImpl.onMessage - Fin");
		}
	}
}
