package com.ejie.y41b.jms;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

import javax.annotation.Resource;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialException;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.aa66.CargaRemesaBuzonWs;
import com.ejie.y41b.aa66.DestinatarioWs;
import com.ejie.y41b.aa66.EnvioOutWs;
import com.ejie.y41b.aa66.EnvioWs;
import com.ejie.y41b.aa66.IdentTramitadorWs;
import com.ejie.y41b.aa66.MotivoObsWs;
import com.ejie.y41b.aa66.RemesaOutWs;
import com.ejie.y41b.adapter.services.AA66ServiceImpl;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ParametrosDao;
import com.ejie.y41b.model.Arbadhdoc;
import com.ejie.y41b.model.Arbadhtram;
import com.ejie.y41b.model.Arbdoctemp;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.EnviosPorRemesa;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.NotificacionesComunicacionesBusqueda;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.model.PlantillaTramite;
import com.ejie.y41b.model.Remesa;
import com.ejie.y41b.model.RemesaBusqueda;
import com.ejie.y41b.model.RemesaDocumentos;
import com.ejie.y41b.model.Sandoctemp;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.Santramexp;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteHecho;
import com.ejie.y41b.model.TramiteInspeccion;
import com.ejie.y41b.model.platea.RegistroSalida;
import com.ejie.y41b.report.Y41bReportGeneratorService;
import com.ejie.y41b.report.Y41bReportMergeService;
import com.ejie.y41b.report.model.listadonotificaciones.ListadoNotificacionesReport;
import com.ejie.y41b.service.ArbadhsolService;
import com.ejie.y41b.service.ArbadhtramService;
import com.ejie.y41b.service.ArbdoctempService;
import com.ejie.y41b.service.ArbintervService;
import com.ejie.y41b.service.Arbtramexp3Service;
import com.ejie.y41b.service.Arbtramexp4Service;
import com.ejie.y41b.service.ArbtramexpService;
import com.ejie.y41b.service.CensoMonitorService;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.EnviosPorRemesaService;
import com.ejie.y41b.service.InstramexpService;
import com.ejie.y41b.service.IntervinientesService;
import com.ejie.y41b.service.PlantillaTramiteService;
import com.ejie.y41b.service.RemesaService;
import com.ejie.y41b.service.SandoctempService;
import com.ejie.y41b.service.SanintervService;
import com.ejie.y41b.service.SantramexpService;
import com.ejie.y41b.service.SoltramexpService;
import com.ejie.y41b.service.TramiteHechoService;
import com.ejie.y41b.service.TramiteInspeccionService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.exception.Y41bAA66Exception;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.fichero.Y41bFicheroUtils;
import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfWriter;

/**
 * Y41bRemesasEmisionJMSServiceImpl Clase encargada del tratamiento de los
 * mensajes recibidos en la cola JMS para la emision de remesas
 * 
 * Los metodos deberian ser TRANSACCIONALES del tipo "propagation =
 * Propagation.REQUIRES_NEW" para que no participe de ninguna transaccion global
 * y no de problemas de reenvio del mensaje a la cola.
 * 
 *  
 * 
 */
@Service(value = "y41bRemesasEmisionJMSService")
public class Y41bRemesasEmisionJMSServiceImpl implements Y41bRemesasEmisionJMSService {
	private static final Logger logger = LoggerFactory.getLogger(Y41bRemesasEmisionJMSServiceImpl.class);

	@Autowired
	private TramiteHechoService tramiteHechoService;

	@Autowired
	private RemesaService remesaService;

	@Autowired
	private PlantillaTramiteService plantillaTramiteService;

	@Autowired
	private Y41bReportGeneratorService reportGeneratorService;

	@Autowired
	private Y41bReportMergeService reportMergeService;

	@Autowired
	private CensoMonitorService censoMonitorService;

	@Autowired
	private SoltramexpService soltramexpService;

	@Autowired
	private SantramexpService santramexpService;

	@Autowired
	private EnviosPorRemesaService enviosPorRemesaService;

	@Autowired
	private IntervinientesService intervinientesService;

	@Autowired
	private DenunciaService denunciaService;

	@Resource
	ReloadableResourceBundleMessageSource appMessageSource;
	@Autowired
	private SandoctempService sandoctempService;
	@Autowired
	private SanintervService sanintervService;

	@Autowired
	private ParametrosDao parametrosDao;
	@Autowired
	private ArbadhsolService arbadhsolService;
	@Autowired
	private Arbtramexp3Service arbtramexp3Service;
	@Autowired
	private ArbtramexpService arbtramexpService;
	@Autowired
	private ArbdoctempService arbdoctempService;
	@Autowired
	private Arbtramexp4Service arbtramexp4Service;
	@Autowired
	private ArbadhtramService arbadhtramService;
	@Autowired
	private ArbintervService arbintervService;

	@Autowired
	private InstramexpService instramexpService;
	@Autowired
	private TramiteInspeccionService tramiteInspeccionService;

	/**
	 * Constructor privado
	 */
	private Y41bRemesasEmisionJMSServiceImpl() {
		super();
	}

	/**
	 * tratamientoLocalizador
	 * 
	 * @param idRemesa
	 *            identificador de la remesa
	 * @throws Exception
	 *             Cualquier excepcion
	 */
	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Throwable.class)
	public void emitirRemesa(String idRemesa) throws Exception {
		Y41bRemesasEmisionJMSServiceImpl.logger.info("Y41bRemesasEmisionJMSServiceImpl.emitirRemesa - Inicio");
		try {
			// TODO Aqui viene la orquestacion de la remesa
			Y41bRemesasEmisionJMSServiceImpl.logger.info("Generando remesa....");
			TramiteHecho tramiteHecho = new TramiteHecho();
			tramiteHecho.setEhcodrem(idRemesa);
			List<TramiteHecho> listaTramites = tramiteHechoService.findAll(tramiteHecho, null);
			if (listaTramites != null && !listaTramites.isEmpty()) {
				Y41bRemesasEmisionJMSServiceImpl.logger.info("Remesa con " + listaTramites.size() + " tramites");
			}
			Y41bRemesasEmisionJMSServiceImpl.logger.info("Remesa generada!!!!");
		} catch (Y41bUDAException e) {
			logger.error("Y41bUDAException - Y41bRemesasEmisionJMSServiceImpl.tratamientoLocalizador", e);
			throw e;
		} catch (Throwable e_emitirRemesa) {
			logger.error("Y41bRemesasEmisionJMSServiceImpl.tratamientoLocalizador", e_emitirRemesa);
			throw new Y41bUDAException("error.generico", true, e_emitirRemesa);
		} finally {
			logger.info("Y41bRemesasEmisionJMSServiceImpl.emitirRemesa - Final");
		}

	}

	/**
	 * generarRemesa
	 * 
	 * @param idRemesa
	 *            identificador de la remesa
	 * @throws Throwable
	 *             Cualquier excepcion
	 */
	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Throwable.class)
	public void generarRemesa(String idRemesa) throws Throwable {
		generarRemesa0(idRemesa);
	}

	/**
	 * generarRemesa
	 * 
	 * @param idRemesa
	 *            identificador de la remesa
	 * @throws Throwable
	 *             Cualquier excepcion
	 */
	public void generarRemesa0(String idRemesa) throws Throwable {
		Y41bRemesasEmisionJMSServiceImpl.logger.info("Y41bRemesasEmisionJMSServiceImpl.GENERAR REMESA - INICIO");
		Y41bRemesasEmisionJMSServiceImpl.logger
				.info("Y41bRemesasEmisionJMSServiceImpl.GENERAR REMESA - CODREMESA:" + idRemesa);

		String trazaSituacionCodigo = "generarRemesa0_INICIO: ";

		// TODO Crear carpeta con el id de remesa
		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
		// SE especifica la ruta temporal de las remesas
		String strTmpRemesasDirectory = prop.getProperty("RUTA_TMP_REMESAS");

		File folder = new File(strTmpRemesasDirectory + idRemesa);
		folder.mkdirs();

		String strTmpRemesasImgRepot = prop.getProperty("URL_IMAGENES_REPORT_LISTADO");
		String logoCabecera = strTmpRemesasImgRepot + "y41b-logo-kontsumo-report.png";
		String logoGV = strTmpRemesasImgRepot + "y41b-logo-gv-report.png";

		// Aqui viene la orquestacion de la remesa
		long tiempoInicio = System.currentTimeMillis();

		// Obtener datos de la remesa a tratar
		Remesa remesaFilter = new Remesa();
		remesaFilter.setRmcodigo(idRemesa);

		Y41bRemesasEmisionJMSServiceImpl.logger
				.info("Y41bRemesasEmisionJMSServiceImpl.BUSCAR LA REMESA A GENERAR - CODREMESA:" + idRemesa);
		Remesa remesa = remesaService.find(remesaFilter);
		if (remesa == null) {
			Y41bRemesasEmisionJMSServiceImpl.logger
					.info("Y41bRemesasEmisionJMSServiceImpl.ESPERAR UNOS SEGUNDOS Y REALIZAR UNA SEGUNDA BUSQUEDA");
			Thread.sleep(Y41bConstantes.AA66_SLEEP);
			remesa = remesaService.find(remesaFilter);
		}
		Y41bRemesasEmisionJMSServiceImpl.logger.info("Y41bRemesasEmisionJMSServiceImpl.RESULTADO BUSQUEDA:" + remesa);

		try {
			trazaSituacionCodigo = "generarRemesa0_obtenerCodigoBarrasDesdeAA66: ";

			// Obtener un listado con todos los datos de informacion de las
			// notificacionesComunicaciones de la remesa a tratar y todos sus
			// documentos
			NotificacionesComunicacionesBusqueda filterNotifiComuni = null;
			List<NotificacionesComunicacionesBusqueda> listaClobNotifComuni = null;
			List<NotificacionesComunicacionesBusqueda> listaDatosNotifiComuni = null;
			if (remesa.getRmtipoproc().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

				filterNotifiComuni = new NotificacionesComunicacionesBusqueda();
				filterNotifiComuni.setRmcodigo(remesa.getRmcodigo());
				filterNotifiComuni.setRmtipoExpediente(remesa.getRmtipoproc());
				listaDatosNotifiComuni = soltramexpService.findAllNotifiComuni(filterNotifiComuni, null);

				// Este metodo controla si el tipo de remesa es notificacion
				// electronica para llamar o no al ws
				remesa = obtenerCodigoBarrasDesdeAA66(remesa, listaDatosNotifiComuni);

				trazaSituacionCodigo = "generarRemesa0_obtenerRegistroSalida: ";

				listaDatosNotifiComuni = this.getRegistroSalidaSolicitudes(remesa, listaDatosNotifiComuni);

				listaClobNotifComuni = soltramexpService.findAllBlobNotifiComuni(filterNotifiComuni);

			} else if (remesa.getRmtipoproc().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

				filterNotifiComuni = new NotificacionesComunicacionesBusqueda();
				filterNotifiComuni.setRmcodigo(remesa.getRmcodigo());
				filterNotifiComuni.setRmtipoExpediente(remesa.getRmtipoproc());
				listaDatosNotifiComuni = santramexpService.findAllNotifiComuni(filterNotifiComuni, null);

				// Este metodo controla si el tipo de remesa es notificacion
				// electronica para llamar o no al ws
				remesa = obtenerCodigoBarrasDesdeAA66(remesa, listaDatosNotifiComuni);

				trazaSituacionCodigo = "generarRemesa0_obtenerRegistroSalida: ";

				listaDatosNotifiComuni = this.getRegistroSalidaSanciones(remesa, listaDatosNotifiComuni);

				listaClobNotifComuni = santramexpService.findAllBlobNotifiComuni(filterNotifiComuni);

			} else if (Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA.equals(remesa.getRmtipoproc())
					|| Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA.equals(remesa.getRmtipoproc())
					|| Y41bConstantes.TIPO_PROC_ADHESIONES_MOD.equals(remesa.getRmtipoproc())) {
				filterNotifiComuni = new NotificacionesComunicacionesBusqueda();
				filterNotifiComuni.setRmcodigo(remesa.getRmcodigo());
				filterNotifiComuni.setRmtipoExpediente(remesa.getRmtipoproc());
				listaDatosNotifiComuni = arbadhtramService.findAllNotifiComuni(filterNotifiComuni, null);

				// Este metodo controla si el tipo de remesa es notificacion
				// electronica para llamar o no al ws
				remesa = obtenerCodigoBarrasDesdeAA66(remesa, listaDatosNotifiComuni);

				trazaSituacionCodigo = "generarRemesa0_obtenerRegistroSalida: ";

				listaDatosNotifiComuni = this.getRegistroSalidaAdhesiones(remesa, listaDatosNotifiComuni);

				listaClobNotifComuni = arbadhtramService.findAllBlobNotifiComuni(filterNotifiComuni);

			} else if (remesa.getRmtipoproc().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				filterNotifiComuni = new NotificacionesComunicacionesBusqueda();
				filterNotifiComuni.setRmcodigo(remesa.getRmcodigo());
				filterNotifiComuni.setRmtipoExpediente(remesa.getRmtipoproc());
				listaDatosNotifiComuni = arbtramexp3Service.findAllNotifiComuni(filterNotifiComuni, null);

				// Este metodo controla si el tipo de remesa es notificacion
				// electronica para llamar o no al ws
				remesa = obtenerCodigoBarrasDesdeAA66(remesa, listaDatosNotifiComuni);

				trazaSituacionCodigo = "generarRemesa0_obtenerRegistroSalida: ";

				listaDatosNotifiComuni = this.getRegistroSalidaArbitraje(remesa, listaDatosNotifiComuni);

				listaClobNotifComuni = arbtramexp3Service.findAllBlobNotifiComuni(filterNotifiComuni);
			} else if (remesa.getRmtipoproc().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

				filterNotifiComuni = new NotificacionesComunicacionesBusqueda();
				filterNotifiComuni.setRmcodigo(remesa.getRmcodigo());
				filterNotifiComuni.setRmtipoExpediente(remesa.getRmtipoproc());
				listaDatosNotifiComuni = instramexpService.findAllNotifiComuni(filterNotifiComuni, null);

				// Este metodo controla si el tipo de remesa es notificacion
				// electronica para llamar o no al ws
				remesa = obtenerCodigoBarrasDesdeAA66(remesa, listaDatosNotifiComuni);

				trazaSituacionCodigo = "generarRemesa0_obtenerRegistroSalida: ";

				listaDatosNotifiComuni = this.getRegistroSalidaInspecciones(remesa, listaDatosNotifiComuni);

				listaClobNotifComuni = instramexpService.findAllBlobNotifiComuni(filterNotifiComuni);
			}

			trazaSituacionCodigo = "generarRemesa0_generarPdfCaratula: ";

			// Generacion del PDF de Caratulas con notificaciones
			Blob pdfCaratula = this.generarPdfCaratula(remesa, listaClobNotifComuni, listaDatosNotifiComuni,
					logoCabecera, logoGV);

			Blob pdfAcuses = null;
			Blob pdfListado = null;
			if (remesa.getRmtipo().equals(Y41bConstantes.TRAMITE_NOTIFICACION)) {
				trazaSituacionCodigo = "generarRemesa0_generarPdfAcuses: ";
				// Generacin del PDF Acuses de Recibo
				pdfAcuses = this.generarPdfAcuses(remesa, listaDatosNotifiComuni, logoCabecera, logoGV);

				trazaSituacionCodigo = "generarRemesa0_generarPdfListado: ";
				// Generacin del PDF del listado de notificaciones
				pdfListado = this.generarPdfListado(remesa, listaDatosNotifiComuni);
			} else if (remesa.getRmtipo().equals(Y41bConstantes.TRAMITE_NOTIFICACION_ELECTRONICA)) {
				// Generacin del PDF del listado de notificaciones
				// pdfListado = this.generarPdfListado(remesa,
				// listaDatosNotifiComuni);
				// Jgrey (21/11/2016): Se va a hacer uso de utilidada de AA66
				// para sacar este listado
			}
			// Acutalizar el estado de la remesa a ESTADO_REMESA_GENERADA y
			// guardar los ficheros creados

			remesa.setRmdatafile(pdfCaratula);
			remesa.setRmacusesfile(pdfAcuses);
			remesa.setRmlistadofile(pdfListado);
			remesa.setRmestado(Y41bConstantes.ESTADO_REMESA_GENERADA);
			remesa.setRmfechageneracion(new Date());

			trazaSituacionCodigo = "generarRemesa0_updateDatosGeneracion: ";
			this.remesaService.updateDatosGeneracion(remesa);

			Y41bRemesasEmisionJMSServiceImpl.logger
					.info("Y41bRemesasEmisionJMSServiceImpl.GENERAR REMESA - REMESA GENERADA CODREMESA: " + idRemesa);

			long totalTiempo = System.currentTimeMillis() - tiempoInicio;
			Y41bRemesasEmisionJMSServiceImpl.logger
					.info("Y41bRemesasEmisionJMSServiceImpl.GENERAR REMESA TIEMPO TOTAL QUE HA TRANSCURRIDO: "
							+ (new SimpleDateFormat("mm:ss:SSS")).format(new Date(totalTiempo)));

			Y41bRemesasEmisionJMSServiceImpl.logger
					.info("Y41bRemesasEmisionJMSServiceImpl.GENERAR REMESA - DURACIN DEL PROCESO: "
							+ Y41bUtils.getDurationProceso(totalTiempo));
		} catch (Throwable e) {
			if (remesa.getRmtipo() != null
					&& remesa.getRmtipo().equals(Y41bConstantes.TRAMITE_NOTIFICACION_ELECTRONICA)) {

				AA66ServiceImpl aa66Ws = new AA66ServiceImpl();
				List<NotificacionesComunicacionesBusqueda> listaDatosNotifiComuniAux = this.remesaService
						.findAllNotiComuni(remesa);
				if (listaDatosNotifiComuniAux != null) {
					for (NotificacionesComunicacionesBusqueda envio : listaDatosNotifiComuniAux) {

						if (envio.getEnvcidenvio() != 0) {
							try {
								IdentTramitadorWs identTramitadorWs = new IdentTramitadorWs();
								identTramitadorWs.setId(envio.getEnvcidenvio());
								identTramitadorWs.setUidPuestoTramitador(this.remesaService.getPuestoXlNet(remesa));
								// Llamada al metodo del WS de eliminacin
								aa66Ws.eliminarEnvio(identTramitadorWs);
							} catch (Throwable ex) {
							}
						}
					}
				}
			}

			Y41bRemesasEmisionJMSServiceImpl.logger.error("Y41bRemesasEmisionJMSServiceImpl.generarRemesa", e);
			this.remesaService.updateEstadoRemesaErronea_Y_Estado(remesa, Y41bConstantes.ESTADO_REMESA_ERRONEA, e,
					trazaSituacionCodigo);
		} finally {
			// todo eliminar carpeta con el id de remesa
			Y41bFicheroUtils.deleteDirectoryAndContents(folder);

			if (folder.delete()) {

				Y41bRemesasEmisionJMSServiceImpl.logger
						.info("Y41bRemesasEmisionJMSServiceImpl.GENERAR REMESA El directorio " + folder
								+ " ha sido borrado correctamente");
			} else {

				Y41bRemesasEmisionJMSServiceImpl.logger
						.info("Y41bRemesasEmisionJMSServiceImpl.GENERAR REMESA El directorio " + folder
								+ " no se ha podido borrar");
			}

			Y41bRemesasEmisionJMSServiceImpl.logger
					.info("Y41bRemesasEmisionJMSServiceImpl.GENERAR REMESA - FIN CODREMESA" + idRemesa);
		}
	}

	private Remesa obtenerCodigoBarrasDesdeAA66(Remesa remesaAA66,
			List<NotificacionesComunicacionesBusqueda> listaDatosNotifiComuni) throws Exception {
		if (remesaAA66.getRmtipo().equals(Y41bConstantes.TRAMITE_NOTIFICACION_ELECTRONICA)) {
			CensoMonitor censoMonitor = new CensoMonitor();
			censoMonitor.setMocodigo(remesaAA66.getRmcomo());
			censoMonitor = this.censoMonitorService.find(censoMonitor);

			CargaRemesaBuzonWs cargaRemesaBuzonWs = new CargaRemesaBuzonWs();
			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
			String local = (String) prop.getProperty("y41bVistaWar.entorno.local");

			if (local.equals("true")) {
				cargaRemesaBuzonWs.setUidPuestoTramitador("Y41BU001");
			} else {
				cargaRemesaBuzonWs.setUidPuestoTramitador(censoMonitor.getPuestoxlnet());
			}

			cargaRemesaBuzonWs.setTelefonoTramitador(censoMonitor.getOrganismo().getTelefono());

			String descripcionRemesa = appMessageSource.getMessage("remesa.descripcion", null,
					new Locale(Y41bConstantes.CASTELLANO));

			cargaRemesaBuzonWs.setDescripcionRemesa(descripcionRemesa);
			if (censoMonitor.getMocoem() != null && censoMonitor.getMocoem() != "") {
				cargaRemesaBuzonWs.setEmail(censoMonitor.getMocoem());
				cargaRemesaBuzonWs.setRecibirMail(true);
			} else {
				cargaRemesaBuzonWs.setRecibirMail(false);
			}
			cargaRemesaBuzonWs.setAplicacion(Y41bConstantes.COD_APLICACION.toUpperCase());
			cargaRemesaBuzonWs.setTipoRemesa(Y41bConstantes.COD_TIPO_REMESA_DIARIA);

			StringBuilder motivoCas = new StringBuilder(
					appMessageSource.getMessage("remesa.motivo", null, new Locale(Y41bConstantes.CASTELLANO)));
			motivoCas.append(remesaAA66.getRmcodigo());

			StringBuilder motivoEus = new StringBuilder(
					appMessageSource.getMessage("remesa.motivo", null, new Locale(Y41bConstantes.EUSKERA)));
			motivoEus.append(remesaAA66.getRmcodigo());

			MotivoObsWs motivoObsWs = new MotivoObsWs();
			motivoObsWs.setDescripcionMotivo(motivoCas.toString());// literal
			// motivoObsWs.setMotivoEuskera(motivoEus.toString());// literal

			cargaRemesaBuzonWs.setMotivo(motivoObsWs);
			HashMap<Integer, String> mapeoEhcodigoIdInterno = new HashMap<Integer, String>();
			for (int i = 0; i < listaDatosNotifiComuni.size(); i++) {
				NotificacionesComunicacionesBusqueda notiElec = listaDatosNotifiComuni.get(i);
				EnvioWs envioWs = new EnvioWs();

				envioWs.setExpediente(notiElec.getNumExpediente() + "("
						+ obtenerDescripcionActo(remesaAA66.getRmtipoproc(), notiElec.getActo()) + ")");
				envioWs.setIdInterno(String.valueOf(i + 1));

				if (local.equals("true")) {
					envioWs.setUidPuestoSolicitante("Y41BU001");
				} else {
					envioWs.setUidPuestoSolicitante(notiElec.getPuestoXlNet());
				}

				DestinatarioWs destinatarioWs = new DestinatarioWs();
				destinatarioWs.setCodigoPostal(notiElec.getNombre_CP().trim());
				destinatarioWs.setMunicipio(notiElec.getNombre_Municipio());
				destinatarioWs.setProvincia(notiElec.getNombre_Provincia());

				obtenerNomAppOInstitucion(notiElec, destinatarioWs);

				StringBuilder direccion = new StringBuilder();
				if (notiElec.getDireccion1() != null && notiElec.getDireccion1() != "") {
					direccion.append(notiElec.getDireccion1());
				}
				if (notiElec.getDireccion2() != null && notiElec.getDireccion2() != "") {
					direccion.append(", ").append(notiElec.getDireccion2());
				}
				destinatarioWs.setDireccion(direccion.toString());

				envioWs.setDestinatario(destinatarioWs);

				cargaRemesaBuzonWs.getListaEnvios().add(envioWs);
				mapeoEhcodigoIdInterno.put(i + 1, notiElec.getCodExpediente());

				Y41bRemesasEmisionJMSServiceImpl.logger
						.info("AA66.obtenerCodigoBarrasDesdeAA66.getCodExpediente();getNumExpediente();getActo();direccion:"
								+ notiElec.getCodExpediente() + ";" + notiElec.getNumExpediente() + ";"
								+ notiElec.getActo() + ";" + direccion);
			}

			Y41bRemesasEmisionJMSServiceImpl.logger
					.info("AA66.obtenerCodigoBarrasDesdeAA66.mapeoEhcodigoIdInterno:" + mapeoEhcodigoIdInterno);
			AA66ServiceImpl aa66Ws = new AA66ServiceImpl();
			RemesaOutWs remesaOutWs;
			try {
				remesaOutWs = aa66Ws.cargaRemesaBuzon(cargaRemesaBuzonWs);
			} catch (Y41bAA66Exception e) {
				throw e;
			}

			// Si todo va bien y se insertan los datos en envo por remesa,
			// se actualiza la remesa
			remesaAA66.setRmcodColeccionAA66(remesaOutWs.getCodigoColeccion());
			remesaAA66.setRmidColeccionAA66(remesaOutWs.getIdColeccion());
			remesaAA66.setRmcodRemesaAA66(remesaOutWs.getCodigoRemesa());
			remesaAA66.setRmidRemesaAA66(remesaOutWs.getIdremesa());
			remesaAA66.setRmdesMotremes(motivoCas.toString());
			remesaAA66.setRmdesMotremeu(motivoEus.toString());
			remesaAA66.setRmdesDesremesa(descripcionRemesa);

			List<EnvioOutWs> listaEnviosRespuesta = remesaOutWs.getEnvios();

			for (EnvioOutWs envioOutWs : listaEnviosRespuesta) {
				Y41bRemesasEmisionJMSServiceImpl.logger
						.info("AA66 - Respuesta llamada al metodo carga masiva - Id envio:" + envioOutWs.getCodEnvio());
				Y41bRemesasEmisionJMSServiceImpl.logger
						.info("AA66 - Respuesta llamada al metodo carga masiva - Codigo de barras:"
								+ envioOutWs.getCodigoBarras());
				Y41bRemesasEmisionJMSServiceImpl.logger.info(
						"AA66 - Respuesta llamada al metodo carga masiva - IdInterno:" + envioOutWs.getIdInterno());

				String ehcodigo = mapeoEhcodigoIdInterno.get(Integer.parseInt(envioOutWs.getIdInterno()));

				Y41bRemesasEmisionJMSServiceImpl.logger
						.info("AA66.obtenerCodigoBarrasDesdeAA66.mapeoEhcodigoIdInterno - ehcodigo:" + ehcodigo);

				actualizaUnEnvioConDatosDeAA66_cargaMasiva(envioOutWs, censoMonitor, ehcodigo);

				// Volver a obtener la notificacion para insertarle la imagen
				NotificacionesComunicacionesBusqueda notiElec = new NotificacionesComunicacionesBusqueda();
				for (NotificacionesComunicacionesBusqueda noti : listaDatosNotifiComuni) {
					if (noti.getCodExpediente().equals(ehcodigo)) {
						notiElec = noti;
						InputStream img = new ByteArrayInputStream(envioOutWs.getImagen().get(0));
						InputStream img2 = new ByteArrayInputStream(envioOutWs.getImagen().get(0));
						notiElec.setCodigoBarrasCaratula(img);
						notiElec.setCodigoBarras(img2);
						break;
					}
				}
			}
		}
		return remesaAA66;
	}

	private String obtenerDescripcionActo(String rmtipoproc, String acto) {

		if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(rmtipoproc)) {
			if (Y41bConstantes.NOTIFICACION_SUBSANACION.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.subsanacion");
			}
			if (Y41bConstantes.NOTIFICACION_RESOLUCION.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.resolucion");
			}
			if (Y41bConstantes.NOTIFICACION_RESOLUCION_RECURSO.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.resolucionrecurso");
			}
			if (Y41bConstantes.NOTIFICACION_DESISTIMIENTO.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.desistimiento");
			}
			if (Y41bConstantes.NOTIFICACION_ACEPTACION_RENUNCIA.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.aceptacionrenuncia");
			}
			if (Y41bConstantes.NOTIFICACION_PROPUESTA_RESOLUCION.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.propuestaresolucion");
			}
			if (Y41bConstantes.NOTIFICACION_RESOL_COMPLEMENTARIA.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.resolucioncomplementaria");
			}
			if (Y41bConstantes.NOTIFICACION_SOL_INCOACION.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.incoacion");
			}
			if (Y41bConstantes.NOTIFICACION_ALEGACION.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.alegacion");
			}
			if (Y41bConstantes.NOTIFICACION_REQUERIMIENTO.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.requerimiento");
			}
			if (Y41bConstantes.NOTIFICACION_RECURSO.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.resolucionrecurso");
			}
			if (Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_ACUERDO_AMPLIACIONPLAZOALEGACIONES.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.acuerdoAmplPlazAleg");
			}
		} else if (Y41bConstantes.TIPO_PROC_SANCIONES.equals(rmtipoproc)) {
			if (Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_RESOLUCION.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.resolucion");
			}
			if (Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_PROPUESTA_RESOLUCION.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.propuestaresolucion");
			}
			if ("PRUEBAS".equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.resolucionrecursoAceptDen");
			}
			if (Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_RESOLUCION_SOLICITUD_PRUEBA.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.resolucionsolicitud");
			}
			if ("INCO".equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.incoacion");
			}
			if (Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_ACUERDO_AMPLIACIONPLAZOALEGACIONES.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.acuerdoAmplPlazAleg");
			}
			if (Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_REQUERIMIENTO.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.requerimientoAcredRepr");
			}
			if ("RESPALEGACIONES".equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.resolucionFraccionamiento");
			}
			if (Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_ACUERDO_RESOLUCIONACEPTACIONPRUEBA.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.resolucionRecursoAlzada");
			}
			if (Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_ACUERDO_INCOACCION.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.acuerdoincoacion");
			}
			if (Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_RESOLUCIONCOMPLEMENTARIA.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.resolucioncomplementaria");
			}
			if (Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_OTROS.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.liquidacionpagovoluntario");
			} // EVOLUTIVO 0135083 2.4
			if ("REQUERIMIENTOINFORMACION".equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.requerimientoInformacion");
			} // EVOLUTIVO 0135083 2.4
		} else if (Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA.equals(rmtipoproc)
				|| Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA.equals(rmtipoproc)
				|| Y41bConstantes.TIPO_PROC_ADHESIONES_MOD.equals(rmtipoproc)) {
			return doGetDescripcionActo("remesa.notificaActo.resolucion");
		} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(rmtipoproc)) {
			if (Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_RESOLUCION.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.resolucion");
			} else if (Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_SUBSANACION.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.subsanacion");
			} else if (Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_RESULTADO_ANALISIS.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.resultadoAnalisis");
			} else if (Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_RECEPCION_ALEGACIONES.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.alegacion");
			} else if (Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_CITACION_AUDIENCIA.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.citacion");
			} else if (Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_CITACION_2AUDIENCIA.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.citacion2");
			} else if (Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_CONVENIO_ARBITRAL.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.convenio");
			} else if (Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_SUSPENSION_AUDIENCIA.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.suspension");
			} else if (Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_CITACION_A_PRUEBA.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.citacionPrueba");
			} else if (Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_LAUDO.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.laudo");
			} else if (Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_ACLARACION.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.aclaracion");
			} else if (Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_RECEPCION_INFORME_PERICIAL.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.recepInformePericial");
			} else if (Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_PAGO_PERICIAL.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.pagoPericial");
			} else if (Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_RECEPCION_SOLICITUD_ACLARACION.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.recepSolAclaracion");
			} // 0150948: Evolutivo Arbitraje Marzo-2020
				// 2.5
			else if (Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_COPIA_COMPULSADA.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.copiaCompulsada");
			}
		} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(rmtipoproc)) {
			if (Y41bConstantes.NOTIFICACION_SUBSANACION.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.subsanacion");
			}
			if (Y41bConstantes.NOTIFICACION_RESOLUCION.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.resolucion");
			}
			if (Y41bConstantes.NOTIFICACION_RESOLUCION_RECURSO.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.resolucionrecurso");
			}
			if (Y41bConstantes.NOTIFICACION_DESISTIMIENTO.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.desistimiento");
			}
			if (Y41bConstantes.NOTIFICACION_ACEPTACION_RENUNCIA.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.aceptacionrenuncia");
			}
			if (Y41bConstantes.NOTIFICACION_PROPUESTA_RESOLUCION.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.propuestaresolucion");
			}
			if (Y41bConstantes.NOTIFICACION_RESOL_COMPLEMENTARIA.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.resolucioncomplementaria");
			}
			if (Y41bConstantes.NOTIFICACION_SOL_INCOACION.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.incoacion");
			}
			if (Y41bConstantes.NOTIFICACION_ALEGACION.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.alegacion");
			}
			if (Y41bConstantes.NOTIFICACION_REQUERIMIENTO.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.requerimiento");
			}
			if (Y41bConstantes.NOTIFICACION_RECURSO.equals(acto)) {
				return doGetDescripcionActo("remesa.notificaActo.resolucionrecurso");
			}
		}
		return "";
	}

	private String doGetDescripcionActo(String aKeyActo) {
		return appMessageSource.getMessage(aKeyActo, null, new Locale(Y41bConstantes.CASTELLANO));
	}

	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Throwable.class)
	private void actualizaUnEnvioConDatosDeAA66_cargaMasiva(EnvioOutWs envioOutWs, CensoMonitor censoMonitor,
			String ehcodigo) throws SerialException, SQLException {
		EnviosPorRemesa enviosPorRemesa = new EnviosPorRemesa();
		enviosPorRemesa.setEnvcIdEnvio(envioOutWs.getIdEnvio());
		enviosPorRemesa.setEnvcCodEnvio(envioOutWs.getCodEnvio());
		enviosPorRemesa.setEnvccodbarras(envioOutWs.getCodigoBarras());
		Blob blob = new SerialBlob(envioOutWs.getImagen().get(0));
		enviosPorRemesa.setEnvccodbarrasfile(blob);
		enviosPorRemesa.setEhcodigo(ehcodigo);
		enviosPorRemesa.setEnvccomoejecucion(censoMonitor.getMocodigo());
		this.enviosPorRemesaService.add(enviosPorRemesa);
	}

	/**
	 * Mtodo para obtener nombre y apellidos o institucion
	 * 
	 * @param notiElec
	 * @param destinatarioWs
	 */
	private void obtenerNomAppOInstitucion(NotificacionesComunicacionesBusqueda notiElec,
			DestinatarioWs destinatarioWs) {
		if (notiElec.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO)
				|| notiElec.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_CONSUMIDOR)) {
			destinatarioWs.setNombreApellidos(notiElec.getNombreDestinatario());
		} else {
			destinatarioWs.setInstitucion(notiElec.getNombreDestinatario());
		}

		// Forma antigua de obtencin de los datos, antes del cambio del modelo
		// del WS
		// ObjectFactory objectFactory = new ObjectFactory();
		// JAXBElement<String> nomApe = null;
		// if (notiElec.getTipoInterviniente().equals(
		// Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO)
		// || notiElec
		// .getTipoInterviniente()
		// .equals(Y41bConstantes.TIPO_INTERVINIENTESOL_CONSUMIDOR)) {
		// nomApe = objectFactory
		// .createDestinatarioWsNombreApellidos(notiElec
		// .getNombreDestinatario());
		// } else {
		// nomApe = objectFactory
		// .createDestinatarioWsInstitucion(notiElec
		// .getNombreDestinatario());
		// }
		//
		// destinatarioWs.getInstitucionOrNombreApellidos().add(nomApe);
	}

	/**
	 * generarPdfCaratula
	 * 
	 * @param idRemesa
	 *            identificador de la remesa
	 * @throws Exception
	 *             Cualquier excepcion
	 */

	public Blob generarPdfCaratula(Remesa remesa, List<NotificacionesComunicacionesBusqueda> listaClobNotifComuni,
			List<NotificacionesComunicacionesBusqueda> listaDatosNotifiComuni, String logoCabecera, String logoGV)
			throws Exception {
		Y41bRemesasEmisionJMSServiceImpl.logger.info("Y41bRemesasEmisionJMSServiceImpl.GENERARPDFCARATULA - INICIO");
		Blob caratulaPdffile = null;
		PlantillaTramite plantillaCaratula = new PlantillaTramite();
		try {

			Y41bRemesasEmisionJMSServiceImpl.logger
					.info("Y41bRemesasEmisionJMSServiceImpl.GENERARPDFCARATULA - Generando Caratula con notificaciones...."
							+ remesa.getRmcodigo());
			long tiempoInicio = System.currentTimeMillis();

			// TODO Obtener la plantilla de la caratula

			plantillaCaratula.setPtcodigo(remesa.getRmcodplantcaratula());
			plantillaCaratula = this.plantillaTramiteService.obtenerDocumentoPlantilla(plantillaCaratula);

			if (plantillaCaratula == null) {
				throw new Exception(remesa.getRmcodplantcaratula().toString());
			}
			Y41bRemesasEmisionJMSServiceImpl.logger
					.info("Y41bRemesasEmisionJMSServiceImpl.GENERARPDFCARATULA - COD PLANTILLA CARATULA: "
							+ remesa.getRmcodplantcaratula());

			// TODO Generar todos los PDf de las caratulas
			// necesarias
			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
			// SE especifica la ruta temporal de las remesas
			String strTmpRemesasDirectory = prop.getProperty("RUTA_TMP_REMESAS") + remesa.getRmcodigo() + "/";
			List<RemesaDocumentos> pdfsCaratulas = new ArrayList<RemesaDocumentos>();

			for (NotificacionesComunicacionesBusqueda notifComuniAux : listaDatosNotifiComuni) {
				Y41bRemesasEmisionJMSServiceImpl.logger
						.info("Y41bRemesasEmisionJMSServiceImpl.GENERARPDFCARATULA - Datos necesarios de comunicaciones o notificaciones "
								+ notifComuniAux.getCodExpediente() + "-" + notifComuniAux.getIdInterviniente());
				Document document = new Document();
				PdfWriter writer = null;
				File ficheroCaratula = new File(
						strTmpRemesasDirectory + notifComuniAux.getCodExpediente() + "_Caratula.pdf");

				OutputStream out = new FileOutputStream(ficheroCaratula);

				Blob ficheroPlantillaCaratula = plantillaCaratula.getPtplantilla();
				Map<String, Object> data = new HashMap<String, Object>();

				// RELLENAR LOS DATOS DE LA CARATULA Y GENERAR EL PDF
				if (Y41bConstantes.TIPO_PROC_SANCIONES.equals(notifComuniAux.getRmtipoExpediente())) {
					data.put("EXPEDIENTE", notifComuniAux.getDecoor() + "-" + notifComuniAux.getDenror() + "-"
							+ notifComuniAux.getDenran());
				} else if (Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA.equals(notifComuniAux.getRmtipoExpediente())
						|| Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA.equals(notifComuniAux.getRmtipoExpediente())
						|| Y41bConstantes.TIPO_PROC_ADHESIONES_MOD.equals(notifComuniAux.getRmtipoExpediente())) {
					data.put("EXPEDIENTE", notifComuniAux.getNumExpediente());
				} else {
					data.put("EXPEDIENTE", notifComuniAux.getDecoor() + "-"

							+ notifComuniAux.getDenran() + "-" + notifComuniAux.getDenror() + "-"
							+ notifComuniAux.getHdnror());
				}

				if (Y41bUtils.isFilled(notifComuniAux.getNombreComercialDestinatario())) {
					if (!notifComuniAux.getNombreDestinatario().trim()
							.equals(notifComuniAux.getNombreComercialDestinatario().trim())) {
						StringBuffer nombreDestinaratio = new StringBuffer();
						nombreDestinaratio.append(notifComuniAux.getNombreDestinatario()).append(" (")
								.append(notifComuniAux.getNombreComercialDestinatario()).append(")");
						data.put("NOMBREDS", nombreDestinaratio.toString());
					} else {
						data.put("NOMBREDS", notifComuniAux.getNombreDestinatario());
					}
				} else {
					data.put("NOMBREDS", notifComuniAux.getNombreDestinatario());
				}

				if (notifComuniAux.getDireccion1() != null) {
					data.put("DIRECCIONDS", notifComuniAux.getDireccion1());
				} else {
					data.put("DIRECCIONDS", "");
				}
				if (notifComuniAux.getNombre_CP() != null) {
					data.put("COPODS", notifComuniAux.getNombre_CP());
				} else {
					data.put("COPODS", "");
				}
				if (notifComuniAux.getNombre_Municipio() != null) {
					if (!notifComuniAux.getNombre_Municipio().equals(notifComuniAux.getNombre_Localidad())) {
						if (Y41bUtils.isFilled(notifComuniAux.getNombre_Localidad())) {
							StringBuffer localidads = new StringBuffer();
							localidads.append(notifComuniAux.getNombre_Localidad()).append("/")
									.append(notifComuniAux.getNombre_Municipio());
							data.put("LOCALIDADS", localidads.toString());
						} else {
							data.put("LOCALIDADS", notifComuniAux.getNombre_Municipio());
						}
					} else {
						data.put("LOCALIDADS", notifComuniAux.getNombre_Municipio());
					}
				} else {
					data.put("LOCALIDADS", "");
				}

				if (notifComuniAux.getExtranjero() != null && notifComuniAux.getExtranjero().equals("S")) {
					data.put("PROVINCDS", notifComuniAux.getNombre_Pais());
				} else {
					if (notifComuniAux.getNombre_Provincia() != null) {
						data.put("PROVINCDS", notifComuniAux.getNombre_Provincia());
					} else {
						data.put("PROVINCDS", "");
					}
				}

				data.put("LOGOCABECERA", logoCabecera);
				data.put("LOGOGV", logoGV);
				data.put("REGSALIDA", notifComuniAux.getEhnumregistrosalida());
				data.put("NUM_EXPEDIENTE", notifComuniAux.getNumExpediente());
				data.put("FECHA_REGISTRO_CAS", notifComuniAux.getEhfecharegistrosalidacas());
				data.put("FECHA_REGISTRO_EUS", notifComuniAux.getEhfecharegistrosalidaeus());
				data.put("PIE_DIRECCION", notifComuniAux.getPiePaginaLinea1());
				data.put("PIE_EMAIL", notifComuniAux.getPiePaginaLinea2());
				data.put("CODIGO_BARRAS", notifComuniAux.getCodigoBarrasCaratula());
				reportGeneratorService.generate(ficheroPlantillaCaratula.getBinaryStream(), data, out);

				writer = PdfWriter.getInstance(document, out);

				writer.close();
				out.flush();
				out.close();

				if (document.isOpen()) {
					document.close();
				}

			}

			// TODO Unificar las caratulas y las notificaciones en un solo PDF
			String nombreFicherPdfCaratula = strTmpRemesasDirectory + remesa.getRmcodigo() + "_Caratula.pdf";
			OutputStream outputPdfCaratula = new FileOutputStream(nombreFicherPdfCaratula);

			RemesaDocumentos remesaDocumentos = null;
			for (NotificacionesComunicacionesBusqueda notifComuniAux : listaDatosNotifiComuni) {
				remesaDocumentos = new RemesaDocumentos();
				remesaDocumentos.setDocumento(new FileInputStream(
						strTmpRemesasDirectory + notifComuniAux.getCodExpediente() + "_Caratula.pdf"));
				remesaDocumentos.setCaratula(Y41bConstantes.VALOR_SI);
				pdfsCaratulas.add(remesaDocumentos);
				for (NotificacionesComunicacionesBusqueda notifComuniClobAux : listaClobNotifComuni) {
					if (notifComuniClobAux.getCodExpediente().equals(notifComuniAux.getCodExpediente())) {
						// CREAR TODOS LOS FICHEROS TEMPORALES DE LAS
						// NOTIFICACIONES
						File ficheroClobCaratula = new File(
								strTmpRemesasDirectory + notifComuniClobAux.getQ5coddoc() + "_CaraNoti.pdf");

						FileOutputStream outStream = new FileOutputStream(ficheroClobCaratula);
						InputStream inStream = notifComuniClobAux.getQ5datafile().getBinaryStream();
						int read = 0;
						byte[] bytes = new byte[1024];
						while ((read = inStream.read(bytes)) != -1) {
							outStream.write(bytes, 0, read);
						}
						remesaDocumentos = new RemesaDocumentos();
						remesaDocumentos.setDocumento(new FileInputStream(ficheroClobCaratula));
						remesaDocumentos.setCaratula(Y41bConstantes.VALOR_NO);
						pdfsCaratulas.add(remesaDocumentos);
						inStream.close();
						outStream.close();

					}
				}
			}
			reportMergeService.concatDocumentosPDFs(pdfsCaratulas, outputPdfCaratula, false);
			outputPdfCaratula.flush();
			outputPdfCaratula.close();
			caratulaPdffile = Y41bUtils.convertPdftoBlob(nombreFicherPdfCaratula);

			Y41bRemesasEmisionJMSServiceImpl.logger.info(
					"Y41bRemesasEmisionJMSServiceImpl.GENERARPDFCARATULA - Caratula con notificaciones GENERADA!!!!");
			long totalTiempo = System.currentTimeMillis() - tiempoInicio;

			Y41bRemesasEmisionJMSServiceImpl.logger
					.info("Y41bRemesasEmisionJMSServiceImpl.GENERARPDFCARATULA: Duracion del proceso generar caratula: "
							+ Y41bUtils.getDurationProceso(totalTiempo));
		} catch (Y41bUDAException e) {

			throw new Y41bUDAException("error.generico", true, e);
		} catch (Throwable e_emitirRemesa) {

			logger.error("Y41bRemesasEmisionJMSServiceImpl.GENERARPDFCARATULA", e_emitirRemesa);
			throw new Y41bUDAException("error.generico", true, e_emitirRemesa);
		} finally {

			logger.info("Y41bRemesasEmisionJMSServiceImpl.GENERARPDFCARATULA - FIN");

		}
		return caratulaPdffile;
	}

	/**
	 * generarPdfAcuses
	 * 
	 * @param idRemesa
	 *            identificador de la remesa
	 * @throws Exception
	 *             Cualquier excepcion
	 */
	// @Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor =
	// Throwable.class)
	public Blob generarPdfAcuses(Remesa remesa, List<NotificacionesComunicacionesBusqueda> listaDatosNotifiComuni,
			String logoCabecera, String logoGV) throws Exception {
		Y41bRemesasEmisionJMSServiceImpl.logger.info("Y41bRemesasEmisionJMSServiceImpl.GENERARPDFACUSES - INICIO");
		Blob acusePdffile = null;
		PlantillaTramite plantillaAcuses = new PlantillaTramite();
		try {

			Y41bRemesasEmisionJMSServiceImpl.logger
					.info("Y41bRemesasEmisionJMSServiceImpl.GENERARPDFACUSES ...." + remesa.getRmcodigo());
			long tiempoInicio = System.currentTimeMillis();

			// Obtener la plantilla necesaria para acuses correspondiente

			plantillaAcuses.setPtcodigo(remesa.getRmcodplantacuse());
			plantillaAcuses = this.plantillaTramiteService.obtenerDocumentoPlantilla(plantillaAcuses);

			if (plantillaAcuses == null) {
				throw new Exception(remesa.getRmcodplantacuse().toString());
			}
			Y41bRemesasEmisionJMSServiceImpl.logger
					.info("Y41bRemesasEmisionJMSServiceImpl.GENERARPDFACUSES - COD PLANTILLA ACUSES: "
							+ remesa.getRmcodplantacuse());
			// TODO Generar un listado con todos los PDf de los acuses
			// necesarios

			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
			// SE especifica la ruta temporal de las remesas
			String strTmpRemesasDirectory = prop.getProperty("RUTA_TMP_REMESAS") + remesa.getRmcodigo() + "/";
			List<InputStream> pdfsAcuses = new ArrayList<InputStream>();
			int contador = 1;
			int numAcuse = 1;
			Blob ficheroPlantillaAcuses = plantillaAcuses.getPtplantilla();
			Map<String, Object> data = new HashMap<String, Object>();

			Document document = null;
			PdfWriter writer = null;
			File ficheroAcuse = null;
			OutputStream out = null;

			// Obtener datos del CensoMonitor
			CensoMonitor censoMonitor = new CensoMonitor();
			censoMonitor.setMocodigo(remesa.getRmcomo());
			censoMonitor = censoMonitorService.find(censoMonitor);
			remesa.setRmnombremonitor(censoMonitor.getMonombre());

			for (NotificacionesComunicacionesBusqueda notifComuniAux : listaDatosNotifiComuni) {

				// Generamos el documento
				if (numAcuse == 1) {
					document = new Document();

					ficheroAcuse = new File(strTmpRemesasDirectory + contador + "_Acuses.pdf");

					out = new FileOutputStream(ficheroAcuse);

				}

				// Parseamos los datos correspondiente del acuse
				if (Y41bConstantes.TIPO_PROC_SANCIONES.equals(notifComuniAux.getRmtipoExpediente())) {
					data.put("EXPEDIENTE" + numAcuse,
							Y41bConstantes.TIPO_PROC_SANCIONES + "-" + notifComuniAux.getDecoor() + "-"
									+ notifComuniAux.getDenror() + "-" + notifComuniAux.getDenran());
				} else if (Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA.equals(notifComuniAux.getRmtipoExpediente())
						|| Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA.equals(notifComuniAux.getRmtipoExpediente())
						|| Y41bConstantes.TIPO_PROC_ADHESIONES_MOD.equals(notifComuniAux.getRmtipoExpediente())) {
					data.put("EXPEDIENTE" + numAcuse, notifComuniAux.getNumExpediente());
				} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(notifComuniAux.getRmtipoExpediente())) {
					data.put("EXPEDIENTE" + numAcuse,
							Y41bConstantes.TIPO_PROC_ARBITRAJE + "-" + notifComuniAux.getDecoor() + "-"
									+ notifComuniAux.getDenror() + "-" + notifComuniAux.getDenran());
				} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(notifComuniAux.getRmtipoExpediente())) {
					data.put("EXPEDIENTE" + numAcuse,
							Y41bConstantes.TIPO_PROC_INSPECCIONES + "-" + notifComuniAux.getDecoor() + "-"

									+ notifComuniAux.getDenran() + "-" + notifComuniAux.getDenror() + "-"
									+ notifComuniAux.getHdnror());
				} else {
					data.put("EXPEDIENTE" + numAcuse,
							Y41bConstantes.TIPO_PROC_SOLICITUDES + "-" + notifComuniAux.getDecoor() + "-"

									+ notifComuniAux.getDenran() + "-" + notifComuniAux.getDenror() + "-"
									+ notifComuniAux.getHdnror());
				}
				data.put("NOMBREDS" + numAcuse, notifComuniAux.getNombreDestinatario());
				data.put("DIRECCIONDS" + numAcuse, notifComuniAux.getDireccion1());
				data.put("COPODS" + numAcuse, notifComuniAux.getNombre_CP());
				data.put("LOCALIDADS" + numAcuse, notifComuniAux.getNombre_Municipio());
				if (notifComuniAux.getExtranjero() != null && notifComuniAux.getExtranjero().equals("S")) {
					data.put("PROVINCDS" + numAcuse, notifComuniAux.getNombre_Pais());
				} else {
					data.put("PROVINCDS" + numAcuse, notifComuniAux.getNombre_Provincia());
				}
				data.put("ORNOMBRE" + numAcuse, censoMonitor.getOrganismo().getNombreEs());
				data.put("ORNODIR" + numAcuse, censoMonitor.getOrganismo().getAdressCallePortal());
				data.put("ORNRCOPO" + numAcuse, censoMonitor.getOrganismo().getAdressCP());
				data.put("LONOMBREOR" + numAcuse, censoMonitor.getOrganismo().getAdressLocalidad());

				data.put("FECHA" + numAcuse, new SimpleDateFormat("dd/MM/yyyy").format(remesa.getRmfechageneracion()));
				data.put("ASUNTO" + numAcuse, notifComuniAux.getAsunto());
				data.put("ZSCODIGO" + numAcuse, StringUtils.leftPad("" + contador, Y41bConstantes.NUM_3, "0") + "/"
						+ listaDatosNotifiComuni.size());
				data.put("NOMBREORGANICO" + numAcuse, remesa.getRmnombremonitor());
				data.put("CONTADOR" + numAcuse, StringUtils.leftPad("" + contador, Y41bConstantes.NUM_3, "0") + "/"
						+ listaDatosNotifiComuni.size());

				// Generamos el reporte si se ha completado los acuses o se han
				// acabado
				if (numAcuse == Y41bConstantes.NUM_3 || contador == listaDatosNotifiComuni.size()) {
					data.put("LOGOTIPO", logoCabecera);
					data.put("LOGOTIPOGV", logoGV);

					reportGeneratorService.generate(ficheroPlantillaAcuses.getBinaryStream(), data, out);

					writer = PdfWriter.getInstance(document, out);

					pdfsAcuses.add(new FileInputStream(ficheroAcuse));
					writer.close();
					out.close();

					numAcuse = 0;
					data = new HashMap<String, Object>();
				}

				// document.close();
				contador++;
				numAcuse++;
			}

			// TODO Unificar todos los acuses de recibo en un sólo PDF
			String nombreFicheroPdfAcuses = strTmpRemesasDirectory + remesa.getRmcodigo() + "_Acuses.pdf";
			OutputStream outputPdfCaratula = new FileOutputStream(nombreFicheroPdfAcuses);
			reportMergeService.concatAcusePDFs(pdfsAcuses, outputPdfCaratula, false);
			outputPdfCaratula.flush();
			outputPdfCaratula.close();

			if (document.isOpen()) {
				document.close();
			}
			acusePdffile = Y41bUtils.convertPdftoBlob(nombreFicheroPdfAcuses);

			Y41bRemesasEmisionJMSServiceImpl.logger
					.info("Y41bRemesasEmisionJMSServiceImpl.GENERARPDFACUSES: Acuses GENERADOS!!!!");
			long totalTiempo = System.currentTimeMillis() - tiempoInicio;

			Y41bRemesasEmisionJMSServiceImpl.logger
					.info("Y41bRemesasEmisionJMSServiceImpl.GENERARPDFACUSES: Duracion proceso de generación de Acuses -  "
							+ Y41bUtils.getDurationProceso(totalTiempo));
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Throwable e_emitirRemesa) {
			logger.error("Y41bRemesasEmisionJMSServiceImpl.GENERARPDFACUSES", e_emitirRemesa);
			throw new Y41bUDAException("error.generico", true, e_emitirRemesa);
		} finally {
			logger.info("Y41bRemesasEmisionJMSServiceImpl.GENERARPDFACUSES - FIN");
		}
		return acusePdffile;
	}

	/**
	 * generarPdfListado
	 * 
	 * @param idRemesa
	 *            identificador de la remesa
	 * @throws Exception
	 *             Cualquier excepcion
	 */
	// @Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor =
	// Throwable.class)
	public Blob generarPdfListado(Remesa remesa, List<NotificacionesComunicacionesBusqueda> listaDatosNotifiComuni)
			throws Exception {
		Y41bRemesasEmisionJMSServiceImpl.logger.info("Y41bRemesasClientJMSServiceImpl.GENERARPDFLISTADO- Inicio");

		Blob listadoPdfFile;
		PlantillaTramite plantillaListado = new PlantillaTramite();
		try {

			Y41bRemesasEmisionJMSServiceImpl.logger.info("Generando Pdf listado...." + remesa.getRmcodigo());
			long tiempoInicio = System.currentTimeMillis();

			// TODO Obtener la plantilla de listado
			// Obtener la plantilla necesaria para acuses correspondiente

			plantillaListado.setPtcodigo(remesa.getRmcodplantlistado());

			plantillaListado = this.plantillaTramiteService.obtenerDocumentoPlantilla(plantillaListado);

			if (plantillaListado == null) {
				throw new Exception(remesa.getRmcodplantacuse().toString());
			}
			Y41bRemesasEmisionJMSServiceImpl.logger
					.info("Y41bRemesasClientJMSServiceImpl.GENERARPDFLISTADO - COD PLANTILLA LISTADO: "
							+ remesa.getRmcodplantlistado());

			// TODO Generar el PDF de listado
			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
			// SE especifica la ruta temporal de las remesas
			String strTmpRemesasDirectory = prop.getProperty("RUTA_TMP_REMESAS") + remesa.getRmcodigo() + "/";
			String nombreFicheroListado = strTmpRemesasDirectory + remesa.getRmcodigo() + "_Listado.pdf";
			File ficheroListado = new File(nombreFicheroListado);
			Document document = new Document();
			PdfWriter writer = null;

			OutputStream out = new FileOutputStream(ficheroListado);

			Blob ficheroPlantillaListado = plantillaListado.getPtplantilla();
			Map<String, Object> data = new HashMap<String, Object>();

			// Obtener datos del CensoMonitor
			CensoMonitor censoMonitor = new CensoMonitor();
			censoMonitor.setMocodigo(remesa.getRmcomo());
			censoMonitor = censoMonitorService.find(censoMonitor);

			data.put("ORGNOMBRE", censoMonitor.getOrganismo().getNombreEs());
			data.put("ORGTELEFONO", censoMonitor.getOrganismo().getTelefono());

			ListadoNotificacionesReport listadoNotificacionesReport = new ListadoNotificacionesReport(remesa,
					listaDatosNotifiComuni);
			List<ListadoNotificacionesReport> listadoReport = new ArrayList<ListadoNotificacionesReport>();
			listadoReport.add(listadoNotificacionesReport);

			reportGeneratorService.generate(ficheroPlantillaListado.getBinaryStream(), data, listadoReport, out);

			writer = PdfWriter.getInstance(document, out);

			writer.close();
			out.close();
			// document.close();

			listadoPdfFile = Y41bUtils.convertPdftoBlob(nombreFicheroListado);
			Y41bRemesasEmisionJMSServiceImpl.logger
					.info("Y41bRemesasClientJMSServiceImpl.GENERARPDFLISTADO: LISTADO GENERADO!!!!");
			long totalTiempo = System.currentTimeMillis() - tiempoInicio;

			Y41bRemesasEmisionJMSServiceImpl.logger
					.info("Y41bRemesasClientJMSServiceImpl.GENERARPDFLISTADO - Duracion del proceso del listado: "
							+ Y41bUtils.getDurationProceso(totalTiempo));
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Throwable e_emitirRemesa) {
			logger.error("Y41bRemesasClientJMSServiceImpl.GENERARPDFLISTADO", e_emitirRemesa);
			throw new Y41bUDAException("error.generico", true, e_emitirRemesa);
		} finally {
			logger.info("Y41bRemesasClientJMSServiceImpl.GENERARPDFLISTADO - FIN");
		}

		return listadoPdfFile;
	}

	public static void main(String[] args) throws Exception {
		List<String> listado = new ArrayList<String>();
		listado.add("1");
		listado.add("2");
		listado.add("3");
		listado.add("4");
		listado.add("5");
		listado.add("6");
		listado.add("7");
		int contador = 1;
		for (String elemento : listado) {

			if (contador == 1) {
				Y41bRemesasEmisionJMSServiceImpl.logger.info("Crear documento" + elemento);
				// System.out.println("Crear documento" + elemento);
			}
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("EXPEDIENTE" + contador, "numExpediente" + contador);

			contador++;
			if (contador == Y41bConstantes.NUM_4) {
				contador = 1;
			}

		}

	}

	/**
	 * Finds registro salida document
	 * 
	 * @param remesa
	 *            Remesa
	 * @param listaDatosNotifiComuni
	 *            List<NotificacionesComunicacionesBusqueda>
	 * @return List<NotificacionesComunicacionesBusqueda>
	 * @throws Exception
	 *             Exception
	 */
	public List<NotificacionesComunicacionesBusqueda> getRegistroSalidaSolicitudes(Remesa remesa,
			List<NotificacionesComunicacionesBusqueda> listaDatosNotifiComuni) throws Exception {

		for (NotificacionesComunicacionesBusqueda notifcomun : listaDatosNotifiComuni) {
			// llamar a obtener registro salida
			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdinterviniente(notifcomun.getIdInterviniente());

			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdExpediente(notifcomun.getHdcodigo());

			RegistroSalida registroSalida = soltramexpService.getRegistroSalida(remesa, tramiteComun, intervinientes);

			// actualizar el numero de registro y fecha de salida
			TramiteHecho tramitehecho = new TramiteHecho();
			tramitehecho.setEhnumregistrosalida(registroSalida.getRegistryNumber());
			tramitehecho.setEhfecharegistrosalida(registroSalida.getRegistryDate());
			tramitehecho.setEhcodigo(notifcomun.getCodExpediente());

			tramiteHechoService.updateRegistroSalidaPlatea(tramitehecho);

			notifcomun.setEhfecharegistrosalidacas(
					Y41bUtils.parseDateToString(tramitehecho.getEhfecharegistrosalida(), Y41bConstantes.CASTELLANO));
			notifcomun.setEhfecharegistrosalidaeus(
					Y41bUtils.parseDateToString(tramitehecho.getEhfecharegistrosalida(), Y41bConstantes.EUSKERA));
			notifcomun.setEhnumregistrosalida(registroSalida.getRegistryNumber());
		}

		return listaDatosNotifiComuni;
	}

	/**
	 * Finds registro salida document
	 * 
	 * @param remesa
	 *            Remesa
	 * @param listaDatosNotifiComuni
	 *            List<NotificacionesComunicacionesBusqueda>
	 * @return List<NotificacionesComunicacionesBusqueda>
	 * @throws Exception
	 *             Exception
	 */
	public List<NotificacionesComunicacionesBusqueda> getRegistroSalidaInspecciones(Remesa remesa,
			List<NotificacionesComunicacionesBusqueda> listaDatosNotifiComuni) throws Exception {

		for (NotificacionesComunicacionesBusqueda notifcomun : listaDatosNotifiComuni) {
			// llamar a obtener registro salida
			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdinterviniente(notifcomun.getIdInterviniente());

			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdExpediente(notifcomun.getHdcodigo());

			RegistroSalida registroSalida = instramexpService.getRegistroSalida(remesa, tramiteComun, intervinientes);

			// actualizar el numero de registro y fecha de salida
			TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
			tramiteInspeccion.setTinumregistrosalida(registroSalida.getRegistryNumber());
			tramiteInspeccion.setTifecharegistrosalida(registroSalida.getRegistryDate());
			tramiteInspeccion.setTicodigo(notifcomun.getCodExpediente());

			tramiteInspeccionService.updateRegistroSalidaPlatea(tramiteInspeccion);

			notifcomun.setEhfecharegistrosalidacas(Y41bUtils
					.parseDateToString(tramiteInspeccion.getTifecharegistrosalida(), Y41bConstantes.CASTELLANO));
			notifcomun.setEhfecharegistrosalidaeus(
					Y41bUtils.parseDateToString(tramiteInspeccion.getTifecharegistrosalida(), Y41bConstantes.EUSKERA));
			notifcomun.setEhnumregistrosalida(registroSalida.getRegistryNumber());
		}

		return listaDatosNotifiComuni;
	}

	/**
	 * Finds registro salida document
	 * 
	 * @param listaDatosNotifiComuni
	 *            List<NotificacionesComunicacionesBusqueda>
	 * @return List<NotificacionesComunicacionesBusqueda>
	 * @throws Exception
	 *             Exception
	 */
	public List<NotificacionesComunicacionesBusqueda> getRegistroSalidaSanciones(Remesa remesa,
			List<NotificacionesComunicacionesBusqueda> listaDatosNotifiComuni) throws Exception {

		for (NotificacionesComunicacionesBusqueda notifcomun : listaDatosNotifiComuni) {
			// llamar a obtener registro salida

			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdExpediente(notifcomun.getHdcodigo());

			RegistroSalida registroSalida = santramexpService.getRegistroSalida(tramiteComun,
					notifcomun.getIdInterviniente(), (remesa.getRmtipo().equals(Y41bConstantes.TRAMITE_NOTIFICACION)));

			// actualizar el numero de registro y fecha de salida
			Santramexp santramexp = new Santramexp();
			santramexp.setTrnumregs(registroSalida.getRegistryNumber());
			santramexp.setTrfecregs(registroSalida.getRegistryDate());
			santramexp.setTrid(notifcomun.getIdTramite());

			santramexpService.updateRegistroSalidaPlatea(santramexp);

			notifcomun.setEhfecharegistrosalidacas(
					Y41bUtils.parseDateToString(santramexp.getTrfecregs(), Y41bConstantes.CASTELLANO));
			notifcomun.setEhfecharegistrosalidaeus(
					Y41bUtils.parseDateToString(santramexp.getTrfecregs(), Y41bConstantes.EUSKERA));
			notifcomun.setEhnumregistrosalida(registroSalida.getRegistryNumber());

			santramexpService.crearAvisoNotifiComuniRegistroSalida(santramexp);

		}

		return listaDatosNotifiComuni;
	}

	/**
	 * Finds registro salida document
	 * 
	 * @param listaDatosNotifiComuni
	 *            List<NotificacionesComunicacionesBusqueda>
	 * @return List<NotificacionesComunicacionesBusqueda>
	 * @throws Exception
	 *             Exception
	 */
	public List<NotificacionesComunicacionesBusqueda> getRegistroSalidaArbitraje(Remesa remesa,
			List<NotificacionesComunicacionesBusqueda> listaDatosNotifiComuni) throws Exception {

		for (NotificacionesComunicacionesBusqueda notifcomun : listaDatosNotifiComuni) {
			// llamar a obtener registro salida

			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdExpediente(notifcomun.getHdcodigo());

			RegistroSalida registroSalida = arbtramexp3Service.getRegistroSalida(tramiteComun,
					notifcomun.getIdInterviniente(), (remesa.getRmtipo().equals(Y41bConstantes.TRAMITE_NOTIFICACION)));

			// actualizar el numero de registro y fecha de salida
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrnumregs(registroSalida.getRegistryNumber());
			arbtramexp.setTrfecregs(registroSalida.getRegistryDate());
			arbtramexp.setTrid(notifcomun.getIdTramite());

			arbtramexp3Service.updateRegistroSalidaPlatea(arbtramexp);

			notifcomun.setEhfecharegistrosalidacas(
					Y41bUtils.parseDateToString(arbtramexp.getTrfecregs(), Y41bConstantes.CASTELLANO));
			notifcomun.setEhfecharegistrosalidaeus(
					Y41bUtils.parseDateToString(arbtramexp.getTrfecregs(), Y41bConstantes.EUSKERA));
			notifcomun.setEhnumregistrosalida(registroSalida.getRegistryNumber());

			arbtramexp3Service.crearAvisoNotifiComuniRegistroSalida(arbtramexp);

		}

		return listaDatosNotifiComuni;
	}

	/**
	 * actualizarEstadoTodasRemesas
	 * 
	 * @throws Throwable
	 *             Cualquier excepcion
	 */
	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Throwable.class)
	public Map<String, Object> actualizarEstadoTodasRemesas() throws Throwable {
		Y41bRemesasEmisionJMSServiceImpl.logger
				.info("Y41bRemesasEmisionJMSServiceImpl.actualizarEstadoTodasRemesas - INICIO");

		Map<String, Object> mapaRetorno = new HashMap<String, Object>();

		try {
			if (estaParametroUltimaEjecucionIgualN()) {
				logger.info(
						"*********** >>>>>>>>>> actualizarEstadoTodasRemesas. INACTIVA. PARAMETRO AA66_ULTIMA_EJECUCION_JMS = N.");
				return mapaRetorno;
			}

			RemesaBusqueda remesaBusquedaFilter = new RemesaBusqueda();

			List<Remesa> listRemesa = remesaService.findAllRemesasPendientes(remesaBusquedaFilter, null);

			for (Remesa remesaAux : listRemesa) {
				try {
					remesaService.actualizarEnvios(remesaAux);
					mapaRetorno.put(remesaAux.getRmcodigo(),
							"OK. Revisar en la Remision Remesas en que estado han quedado los envios de esta remesa.");

				} catch (Throwable e_actualizarEnvios) {
					logger.error("Y41bRemesasClientJMSServiceImpl.actualizarEstadoTodasRemesas", e_actualizarEnvios);

					mapaRetorno.put(remesaAux.getRmcodigo(), e_actualizarEnvios);
				}
			}

		} catch (Throwable e_actualizarEstadoTodasRemesas) {
			logger.error("Y41bRemesasClientJMSServiceImpl.actualizarEstadoTodasRemesas",
					e_actualizarEstadoTodasRemesas);
		} finally {
			Y41bRemesasEmisionJMSServiceImpl.logger
					.info("Y41bRemesasEmisionJMSServiceImpl.actualizarEstadoTodasRemesas - FIN");
		}

		return mapaRetorno;
	}

	/**
	 * actualizarEstadoUnaRemesas
	 * 
	 * @param idRemesa
	 *            String
	 * @throws Throwable
	 *             Cualquier excepcion
	 */
	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Throwable.class)
	public void actualizarEstadoUnaRemesa(String idRemesa) {

		try {
			Y41bRemesasEmisionJMSServiceImpl.logger
					.info("Y41bRemesasEmisionJMSServiceImpl.actualizarEstadoUnaRemesas - INICIO. Remesa: " + idRemesa);

			if (estaParametroUltimaEjecucionIgualN()) {
				logger.info(
						"*********** >>>>>>>>>> actualizarEstadoUnaRemesa. INACTIVA. PARAMETRO AA66_ULTIMA_EJECUCION_JMS = N.");
			} else {
				Remesa remesaFilter = new Remesa(idRemesa);
				Remesa remesaAux = remesaService.find(remesaFilter);

				remesaService.actualizarEnvios(remesaAux);
			}
		} catch (Throwable e_actualizarEstadoUnaRemesas) {
			logger.error("Y41bRemesasEmisionJMSServiceImpl.actualizarEstadoUnaRemesas", e_actualizarEstadoUnaRemesas);
		} finally {
			Y41bRemesasEmisionJMSServiceImpl.logger
					.info("Y41bRemesasEmisionJMSServiceImpl.actualizarEstadoUnaRemesas - FIN");
		}
	}

	/**
	 * actualizarMisGestiones
	 * 
	 * @param idRemesa
	 *            identificador de la remesa
	 * @throws Throwable
	 *             Cualquier excepcion
	 */
	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Throwable.class)
	public void actualizarMisGestiones(String idRemesa) throws Throwable {
		Y41bRemesasEmisionJMSServiceImpl.logger
				.info("Y41bRemesasEmisionJMSServiceImpl.actualizarMisGestiones - INICIO");
		Y41bRemesasEmisionJMSServiceImpl.logger
				.info("Y41bRemesasEmisionJMSServiceImpl.actualizarMisGestiones - CODREMESA:" + idRemesa);

		String trazaSituacionCodigo = "actualizarMisGestiones: ";

		// Obtener datos de la remesa a tratar
		Remesa remesaFilter = new Remesa();
		remesaFilter.setRmcodigo(idRemesa);

		Y41bRemesasEmisionJMSServiceImpl.logger
				.info("Y41bRemesasEmisionJMSServiceImpl.actualizarMisGestiones BUSCAR LA REMESA A GENERAR - CODREMESA:"
						+ idRemesa);
		Remesa remesa = remesaService.find(remesaFilter);

		Y41bRemesasEmisionJMSServiceImpl.logger
				.info("Y41bRemesasEmisionJMSServiceImpl.actualizarMisGestiones RESULTADO BUSQUEDA:" + remesa);

		try {
			// Obtener un listado con todos los datos de informacion de las
			// notificacionesComunicaciones de la remesa a tratar y todos sus
			// documentos
			NotificacionesComunicacionesBusqueda filterNotifiComuni = null;
			List<NotificacionesComunicacionesBusqueda> listaDatosNotifiComuni = null;
			if (remesa.getRmtipoproc().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

				filterNotifiComuni = new NotificacionesComunicacionesBusqueda();
				filterNotifiComuni.setRmcodigo(remesa.getRmcodigo());
				filterNotifiComuni.setRmtipoExpediente(remesa.getRmtipoproc());
				listaDatosNotifiComuni = soltramexpService.findAllNotifiComuni(filterNotifiComuni, null);

				TramiteHecho tramitehecho = new TramiteHecho();
				TramiteHecho tramitehechoAux = new TramiteHecho();
				for (int i = 0; i < listaDatosNotifiComuni.size(); i++) {
					NotificacionesComunicacionesBusqueda notiElec = listaDatosNotifiComuni.get(i);

					tramitehecho = new TramiteHecho();
					tramitehecho.setEhcodigo(notiElec.getCodExpediente());
					tramitehechoAux = this.tramiteHechoService.find(tramitehecho);

					Intervinientes intervinientes = new Intervinientes();
					intervinientes.setIdinterviniente(tramitehechoAux.getEhiddestinatario());

					intervinientes = this.intervinientesService.find(intervinientes);

					if (intervinientes != null && intervinientes.getTipoInterviniente() != null && (intervinientes
							.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO)
							|| intervinientes.getTipoInterviniente()
									.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE)
							|| intervinientes.getTipoInterviniente().equals(
									Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE_NO_VALIDADO))) {

						TramiteComun tramiteComun = new TramiteComun();
						tramiteComun.setIdTramite(notiElec.getCodExpediente());

						List<DocumentoHecho> listDocumentoHecho = this.denunciaService
								.findAllDocumentosTramite(tramiteComun, null);

						if (tramitehechoAux != null && tramitehechoAux.getTramiteHecho() != null
								&& tramitehechoAux.getTramiteHecho().getEhcodigo() != null) {

							tramitehecho.setEhcodigo(tramitehechoAux.getTramiteHecho().getEhcodigo());
							tramitehecho = this.tramiteHechoService.find(tramitehecho);
							if (tramitehecho.getEhcotee() != null
									&& tramitehecho.getEhcotee().equals(Y41bConstantes.TRAMITE_REGISTRO_DECISION)) {
								this.soltramexpService.actualizarMisGestionesRegistroDecisionReclamante(tramitehecho);
							} else if (tramitehecho.getEhcotee() != null && tramitehecho.getEhcotee()
									.equals(Y41bConstantes.TRAMITE_REQUERIMIENTO_SUBSANACION)) {
								this.soltramexpService
										.actualizarMisGestionesRequerimientoSubsanacionConsumidor(tramitehecho);
							}
						}

						this.soltramexpService.actualizarMisGestionesComunicacionReclamante(tramitehechoAux,
								listDocumentoHecho);
					} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null
							&& (intervinientes.getTipoInterviniente()
									.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO)
									|| intervinientes.getTipoInterviniente()
											.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO)
									|| intervinientes.getTipoInterviniente().equals(
											Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO_NO_VALIDADO))) {
						TramiteComun tramiteComun = new TramiteComun();
						tramiteComun.setIdTramite(notiElec.getCodExpediente());

						List<DocumentoHecho> listDocumentoHecho = this.denunciaService
								.findAllDocumentosTramite(tramiteComun, null);

						if (tramitehechoAux != null && tramitehechoAux.getTramiteHecho() != null
								&& tramitehechoAux.getTramiteHecho().getEhcodigo() != null) {

							tramitehecho.setEhcodigo(tramitehechoAux.getTramiteHecho().getEhcodigo());
							tramitehecho = this.tramiteHechoService.find(tramitehecho);
							if (tramitehecho.getEhcotee() != null
									&& tramitehecho.getEhcotee().equals(Y41bConstantes.TRAMITE_REGISTRO_DECISION)) {
								this.soltramexpService.actualizarMisGestionesRegistroDecisionReclamado(tramitehecho);
							}
						}

						this.soltramexpService.actualizarMisGestionesComunicacionReclamado(tramitehechoAux,
								listDocumentoHecho);
					}
				}

			} else if (remesa.getRmtipoproc().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

				filterNotifiComuni = new NotificacionesComunicacionesBusqueda();
				filterNotifiComuni.setRmcodigo(remesa.getRmcodigo());
				filterNotifiComuni.setRmtipoExpediente(remesa.getRmtipoproc());
				listaDatosNotifiComuni = this.santramexpService.findAllNotifiComuni(filterNotifiComuni, null);

				Santramexp santramexp = new Santramexp();
				Santramexp santramexpAux = new Santramexp();
				for (int i = 0; i < listaDatosNotifiComuni.size(); i++) {
					NotificacionesComunicacionesBusqueda notiElec = listaDatosNotifiComuni.get(i);

					santramexp = new Santramexp();
					santramexp.setTrid(notiElec.getIdTramite());
					santramexpAux = this.santramexpService.find(santramexp);
					if (santramexpAux != null) {
						Saninterv saninterv = new Saninterv();
						saninterv.setUaidinterv(santramexpAux.getTruaidinterv());

						saninterv = this.sanintervService.find(saninterv);

						if (saninterv != null && saninterv.getUatipointerv() != null
								&& (saninterv.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO)
										|| saninterv
												.getUatipointerv()
												.equals(Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO)
										|| saninterv.getUatipointerv().equals(
												Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO_NO_VALIDADO))) {

							TramiteComun tramiteComun = new TramiteComun();
							tramiteComun.setIdTramite(notiElec.getIdTramite());

							List<Sandoctemp> listDocumentos = this.sandoctempService
									.findAllDocumentosTramite(tramiteComun, null);

							this.santramexpService.actualizarMisGestionesComunicacion(santramexpAux, listDocumentos);
						}
					}
				}
			} else if (Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA.equals(remesa.getRmtipoproc())
					|| Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA.equals(remesa.getRmtipoproc())
					|| Y41bConstantes.TIPO_PROC_ADHESIONES_MOD.equals(remesa.getRmtipoproc())) {
				filterNotifiComuni = new NotificacionesComunicacionesBusqueda();
				filterNotifiComuni.setRmcodigo(remesa.getRmcodigo());
				filterNotifiComuni.setRmtipoExpediente(remesa.getRmtipoproc());
				listaDatosNotifiComuni = this.arbadhtramService.findAllNotifiComuni(filterNotifiComuni, null);

				Arbadhtram arbadhtram = new Arbadhtram();
				Arbadhtram arbadhtramAux = new Arbadhtram();
				for (int i = 0; i < listaDatosNotifiComuni.size(); i++) {
					NotificacionesComunicacionesBusqueda notiElec = listaDatosNotifiComuni.get(i);

					arbadhtram = new Arbadhtram();
					arbadhtram.setTrid(notiElec.getIdTramite());
					arbadhtramAux = this.arbadhtramService.find(arbadhtram);
					if (arbadhtramAux != null) {
						TramiteComun tramiteComun = new TramiteComun();
						tramiteComun.setIdTramite(notiElec.getIdTramite());
						tramiteComun.setTipoProcedimiento(new TipoProcedimiento(remesa.getRmtipoproc()));
						List<Arbadhdoc> listDocumentoHecho = this.arbadhsolService
								.findAllDocumentosTramite(tramiteComun, null);
						this.arbadhtramService.actualizarMisGestionesComunicacion(arbadhtramAux, listDocumentoHecho);
					}
				}
			} else if (remesa.getRmtipoproc().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				filterNotifiComuni = new NotificacionesComunicacionesBusqueda();
				filterNotifiComuni.setRmcodigo(remesa.getRmcodigo());
				filterNotifiComuni.setRmtipoExpediente(remesa.getRmtipoproc());
				listaDatosNotifiComuni = this.arbtramexp3Service.findAllNotifiComuni(filterNotifiComuni, null);

				Arbtramexp arbtramexp = new Arbtramexp();
				Arbtramexp arbtramexpAux = new Arbtramexp();
				for (int i = 0; i < listaDatosNotifiComuni.size(); i++) {
					NotificacionesComunicacionesBusqueda notiElec = listaDatosNotifiComuni.get(i);

					arbtramexp = new Arbtramexp();
					arbtramexp.setTrid(notiElec.getIdTramite());
					arbtramexpAux = this.arbtramexpService.find(arbtramexp);
					if (arbtramexpAux != null) {
						if (arbtramexp.getTrtridrel() != null) {
							this.arbtramexp3Service.crearAviso(arbtramexp,
									new Solarb(arbtramexpAux.getSolarb().getSacodigo()), Y41bUtils.hoy());
						}
						Arbinterv arbinterv = new Arbinterv();
						arbinterv.setUaidinterv(arbtramexpAux.getTruaidinterv());

						arbinterv = this.arbintervService.find(arbinterv);

						if (arbinterv != null && arbinterv.getUatipointerv() != null
								&& (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
										|| Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO
												.equals(arbinterv.getUatipointerv())
										|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
												.equals(arbinterv.getUatipointerv())
										|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO
												.equals(arbinterv.getUatipointerv())
										|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
												.equals(arbinterv.getUatipointerv())
										|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_NO_VALIDADO
												.equals(arbinterv.getUatipointerv()))) {

							TramiteComun tramiteComun = new TramiteComun();
							tramiteComun.setIdTramite(notiElec.getIdTramite());

							List<Arbdoctemp> listDocumentos = this.arbdoctempService
									.findAllDocumentosTramite(tramiteComun, null);
							this.arbtramexp4Service.actualizarMisGestionesComunicacion(arbtramexpAux, listDocumentos,
									null);
						}
					}
				}
			} else if (remesa.getRmtipoproc().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

				filterNotifiComuni = new NotificacionesComunicacionesBusqueda();
				filterNotifiComuni.setRmcodigo(remesa.getRmcodigo());
				filterNotifiComuni.setRmtipoExpediente(remesa.getRmtipoproc());
				listaDatosNotifiComuni = instramexpService.findAllNotifiComuni(filterNotifiComuni, null);

				TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
				TramiteInspeccion tramiteInspeccionAux = new TramiteInspeccion();
				for (int i = 0; i < listaDatosNotifiComuni.size(); i++) {
					NotificacionesComunicacionesBusqueda notiElec = listaDatosNotifiComuni.get(i);

					tramiteInspeccion = new TramiteInspeccion();
					tramiteInspeccion.setTicodigo(notiElec.getCodExpediente());
					tramiteInspeccionAux = this.tramiteInspeccionService.find(tramiteInspeccion);

					Intervinientes intervinientes = new Intervinientes();
					intervinientes.setIdinterviniente(tramiteInspeccionAux.getTiiddestinatario());

					intervinientes = this.intervinientesService.find(intervinientes);

					if (intervinientes != null && intervinientes.getTipoInterviniente() != null && (intervinientes
							.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO)
							|| intervinientes.getTipoInterviniente()
									.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO)
							|| intervinientes.getTipoInterviniente().equals(
									Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO_NO_VALIDADO))) {

						TramiteComun tramiteComun = new TramiteComun();
						tramiteComun.setIdTramite(notiElec.getCodExpediente());

						List<DocumentoHecho> listDocumentoHecho = this.denunciaService
								.findAllDocumentosTramite(tramiteComun, null);

						if (tramiteInspeccionAux != null && tramiteInspeccionAux.getTramiteInspeccion() != null
								&& tramiteInspeccionAux.getTramiteInspeccion().getTicodigo() != null) {

							tramiteInspeccion.setTicodigo(tramiteInspeccionAux.getTramiteInspeccion().getTicodigo());
							tramiteInspeccion = this.tramiteInspeccionService.find(tramiteInspeccion);
							if (tramiteInspeccion.getTicotee() != null && tramiteInspeccion.getTicotee()
									.equals(Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_DECISION)) {
								this.instramexpService.actualizarMisGestionesRegistroDecisionEstablecimientoVisitado(
										tramiteInspeccion);
							}
						}

						this.instramexpService.actualizarMisGestionesComunicacionEstablecimientoVisitado(
								tramiteInspeccionAux, listDocumentoHecho);
					} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null
							&& (intervinientes.getTipoInterviniente()
									.equals(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE)
									|| intervinientes.getTipoInterviniente()
											.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE)
									|| intervinientes.getTipoInterviniente().equals(
											Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE_NO_VALIDADO))) {

						TramiteComun tramiteComun = new TramiteComun();
						tramiteComun.setIdTramite(notiElec.getCodExpediente());

						List<DocumentoHecho> listDocumentoHecho = this.denunciaService
								.findAllDocumentosTramite(tramiteComun, null);

						if (tramiteInspeccionAux != null && tramiteInspeccionAux.getTramiteInspeccion() != null
								&& tramiteInspeccionAux.getTramiteInspeccion().getTicodigo() != null) {

							tramiteInspeccion.setTicodigo(tramiteInspeccionAux.getTramiteInspeccion().getTicodigo());
							tramiteInspeccion = this.tramiteInspeccionService.find(tramiteInspeccion);
							if (tramiteInspeccion.getTicotee() != null && tramiteInspeccion.getTicotee()
									.equals(Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_DECISION)) {
								this.instramexpService.actualizarMisGestionesRegistroDecisionEstablecimientoResponsable(
										tramiteInspeccion);
							}
						}

						this.instramexpService.actualizarMisGestionesComunicacionEstablecimientoResponsable(
								tramiteInspeccionAux, listDocumentoHecho);
					}
				}

			}

		} catch (Throwable e) {
			Y41bRemesasEmisionJMSServiceImpl.logger.error("Y41bRemesasEmisionJMSServiceImpl.actualizarMisGestiones", e);

			this.remesaService.updateEstadoRemesaErronea_Y_Estado(remesa, Y41bConstantes.ESTADO_REMESA_ERRONEA, e,
					trazaSituacionCodigo);
		} finally {

			Y41bRemesasEmisionJMSServiceImpl.logger
					.info("Y41bRemesasEmisionJMSServiceImpl.actualizarMisGestiones - FIN CODREMESA" + idRemesa);
		}
	}

	private boolean estaParametroUltimaEjecucionIgualN() {
		Parametros parametros = new Parametros();
		parametros.setParametro(Y41bConstantes.PARAMETRO_AA66_ULTIMA_EJECUCION_JMS);
		return Y41bConstantes.NO.equals(this.parametrosDao.find(parametros).getValor());

	}

	/**
	 * Finds registro salida document
	 * 
	 * @param listaDatosNotifiComuni
	 *            List<NotificacionesComunicacionesBusqueda>
	 * @return List<NotificacionesComunicacionesBusqueda>
	 * @throws Exception
	 *             Exception
	 */
	public List<NotificacionesComunicacionesBusqueda> getRegistroSalidaAdhesiones(Remesa remesa,
			List<NotificacionesComunicacionesBusqueda> listaDatosNotifiComuni) throws Exception {

		for (NotificacionesComunicacionesBusqueda notifcomun : listaDatosNotifiComuni) {
			// llamar a obtener registro salida

			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdExpediente(notifcomun.getHdcodigo());

			RegistroSalida registroSalida = arbadhtramService.getRegistroSalida(tramiteComun,
					notifcomun.getIdInterviniente(), (remesa.getRmtipo().equals(Y41bConstantes.TRAMITE_NOTIFICACION)));

			// actualizar el numero de registro y fecha de salida
			Arbadhtram arbadhtram = new Arbadhtram();
			arbadhtram.setTrnumregs(registroSalida.getRegistryNumber());
			arbadhtram.setTrfecregs(registroSalida.getRegistryDate());
			arbadhtram.setTrid(notifcomun.getIdTramite());

			arbadhtramService.updateRegistroSalidaPlatea(arbadhtram);

			notifcomun.setEhfecharegistrosalidacas(
					Y41bUtils.parseDateToString(arbadhtram.getTrfecregs(), Y41bConstantes.CASTELLANO));
			notifcomun.setEhfecharegistrosalidaeus(
					Y41bUtils.parseDateToString(arbadhtram.getTrfecregs(), Y41bConstantes.EUSKERA));
			notifcomun.setEhnumregistrosalida(registroSalida.getRegistryNumber());

		}

		return listaDatosNotifiComuni;
	}
}
