package com.ejie.y41b.filter;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.DelegatingFilterProxy;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.security.CensoMonitorThreadLocal;

/**
 * Filtro de carga de datos de usuario identificado en thread local.
 * 
 *  
 * 
 */
public class MonitorFilter extends DelegatingFilterProxy {

	/**
	 * Logger.
	 */
	private static final Logger logger = LoggerFactory
			.getLogger(MonitorFilter.class);

	/**
	 * Metodo doFilter.
	 * 
	 * @param request
	 *            ServletRequest
	 * @param response
	 *            ServletResponse
	 * @param filterChain
	 *            FilterChain
	 */
	@Override()
	public void doFilter(ServletRequest request, ServletResponse response,
			FilterChain filterChain) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession session = httpRequest.getSession();

			if (session
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED) != null) {
				CensoMonitorThreadLocal
						.set((CensoMonitor) session
								.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED));
			}

			filterChain.doFilter(request, response);
		} catch (Exception e) {
			MonitorFilter.logger.error("Error en MonitorFilter", e);
		}
	}
}
