package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.UnidadesDir3;

/**
 * UnidadesDir3DaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class UnidadesDir3DaoImpl implements UnidadesDir3Dao {

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<UnidadesDir3> rwMap = new RowMapper<UnidadesDir3>() {
		public UnidadesDir3 mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new UnidadesDir3(resultSet.getString("IDUNIDADDIR3"), resultSet.getString("CODOFICINA"),
					resultSet.getString("DESCOFICINA"), resultSet.getString("CODUNIDAD"),
					resultSet.getString("DESCUNIDAD"));
		}
	};

	private RowMapper<UnidadesDir3> rwMapOficinas = new RowMapper<UnidadesDir3>() {
		public UnidadesDir3 mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new UnidadesDir3(resultSet.getString("CODOFICINA"), resultSet.getString("DESCOFICINA"));
		}
	};

	private RowMapper<UnidadesDir3> rwMapDir3 = new RowMapper<UnidadesDir3>() {
		public UnidadesDir3 mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new UnidadesDir3(resultSet.getString("IDUNIDADDIR3"), resultSet.getString("CODOFICINA"),
					resultSet.getString("DESCOFICINA"), resultSet.getString("CODUNIDAD"),
					resultSet.getString("DESCUNIDAD"), resultSet.getString("NIVELADMIN"),
					resultSet.getString("COMUNIDAD"));
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the UnidadesDir3 table.
	 *
	 * @param unidadesdir3
	 *            UnidadesDir3
	 * @return UnidadesDir3
	 */
	public UnidadesDir3 add(UnidadesDir3 unidadesdir3) {
		String query = "INSERT INTO UNIDADES_DIR3 (ID_UNIDAD_DIR3, COD_OFICINA, DESC_OFICINA, COD_UNIDAD, DESC_UNIDAD) VALUES (?,?,?,?,?)";
		this.jdbcTemplate.update(query, unidadesdir3.getIdUnidadDir3(), unidadesdir3.getCodOficina(),
				unidadesdir3.getDescOficina(), unidadesdir3.getCodUnidad(), unidadesdir3.getDescUnidad());
		return unidadesdir3;
	}

	/**
	 * Updates a single row in the UnidadesDir3 table.
	 *
	 * @param unidadesdir3
	 *            UnidadesDir3
	 * @return UnidadesDir3
	 */
	public UnidadesDir3 update(UnidadesDir3 unidadesdir3) {
		String query = "UPDATE UNIDADES_DIR3 SET COD_OFICINA=?, DESC_OFICINA=?, COD_UNIDAD=?, DESC_UNIDAD=? WHERE ID_UNIDAD_DIR3=?";
		this.jdbcTemplate.update(query, unidadesdir3.getCodOficina(), unidadesdir3.getDescOficina(),
				unidadesdir3.getCodUnidad(), unidadesdir3.getDescUnidad(), unidadesdir3.getIdUnidadDir3());
		return unidadesdir3;
	}

	/**
	 * Finds a single row in the UnidadesDir3 table.
	 *
	 * @param unidadesdir3
	 *            UnidadesDir3
	 * @return UnidadesDir3
	 */
	@Transactional(readOnly = true)
	public UnidadesDir3 find(UnidadesDir3 unidadesdir3) {
		String query = "SELECT t1.ID_UNIDAD_DIR3 IDUNIDADDIR3, t1.COD_OFICINA CODOFICINA, t1.DESC_OFICINA DESCOFICINA, t1.COD_UNIDAD CODUNIDAD, t1.DESC_UNIDAD DESCUNIDAD FROM UNIDADES_DIR3 t1  WHERE t1.ID_UNIDAD_DIR3 = ?  ";

		List<UnidadesDir3> unidadesdir3List = this.jdbcTemplate.query(query, this.rwMap,
				unidadesdir3.getIdUnidadDir3());
		return (UnidadesDir3) DataAccessUtils.uniqueResult(unidadesdir3List);
	}

	/**
	 * Removes a single row in the UnidadesDir3 table.
	 *
	 * @param unidadesdir3
	 *            UnidadesDir3
	 * @return
	 */
	public void remove(UnidadesDir3 unidadesdir3) {
		String query = "DELETE FROM UNIDADES_DIR3 WHERE ID_UNIDAD_DIR3=?";
		this.jdbcTemplate.update(query, unidadesdir3.getIdUnidadDir3());
	}

	/**
	 * Finds a list of rows in the UnidadesDir3 table.
	 *
	 * @param unidadesdir3
	 *            UnidadesDir3
	 * @param pagination
	 *            Pagination
	 * @return List<UnidadesDir3>
	 */
	@Transactional(readOnly = true)
	public List<UnidadesDir3> findAll(UnidadesDir3 unidadesdir3, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_UNIDAD_DIR3 IDUNIDADDIR3,t1.COD_OFICINA CODOFICINA,t1.DESC_OFICINA DESCOFICINA,t1.COD_UNIDAD CODUNIDAD,t1.DESC_UNIDAD DESCUNIDAD ");
		query.append("FROM UNIDADES_DIR3 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(unidadesdir3);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<UnidadesDir3>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the UnidadesDir3 table using like.
	 *
	 * @param unidadesdir3
	 *            UnidadesDir3
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List<UnidadesDir3>
	 */
	@Transactional(readOnly = true)
	public List<UnidadesDir3> findAllLike(UnidadesDir3 unidadesdir3, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_UNIDAD_DIR3 IDUNIDADDIR3,t1.COD_OFICINA CODOFICINA,t1.DESC_OFICINA DESCOFICINA,t1.COD_UNIDAD CODUNIDAD,t1.DESC_UNIDAD DESCUNIDAD ");
		query.append("FROM UNIDADES_DIR3 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(unidadesdir3, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<UnidadesDir3>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the UnidadesDir3 table using like.
	 *
	 * @param unidadesdir3
	 *            UnidadesDir3
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List<UnidadesDir3>
	 */
	@Transactional(readOnly = true)
	public List<UnidadesDir3> findAllLikeOficinas(UnidadesDir3 unidadesdir3, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  distinct t1.COD_OFICINA CODOFICINA,t1.DESC_OFICINA DESCOFICINA ");
		query.append("FROM UNIDADES_DIR3 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(unidadesdir3, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<UnidadesDir3>) this.jdbcTemplate.query(query.toString(), this.rwMapOficinas, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the UnidadesDir3 table.
	 *
	 * @param unidadesdir3
	 *            UnidadesDir3
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(UnidadesDir3 unidadesdir3) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM UNIDADES_DIR3 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(unidadesdir3);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Counts rows in the UnidadesDir3 table using like.
	 *
	 * @param unidadesdir3
	 *            UnidadesDir3
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(UnidadesDir3 unidadesdir3, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM UNIDADES_DIR3 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(unidadesdir3, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Counts rows in the UnidadesDir3 table using like.
	 *
	 * @param unidadesdir3
	 *            UnidadesDir3
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCountOficinas(UnidadesDir3 unidadesdir3, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(distinct t1.COD_OFICINA) FROM UNIDADES_DIR3 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(unidadesdir3, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the UnidadesDir3 entity
	 *
	 * @param unidadesdir3
	 *            UnidadesDir3 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(UnidadesDir3 unidadesdir3) {

		StringBuilder where = new StringBuilder(UnidadesDir3DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (unidadesdir3 != null && unidadesdir3.getIdUnidadDir3() != null) {
			where.append(" AND t1.ID_UNIDAD_DIR3 = ?");
			params.add(unidadesdir3.getIdUnidadDir3());
		}
		if (unidadesdir3 != null && unidadesdir3.getCodOficina() != null) {
			where.append(" AND t1.COD_OFICINA = ?");
			params.add(unidadesdir3.getCodOficina());
		}
		if (unidadesdir3 != null && unidadesdir3.getDescOficina() != null) {
			where.append(" AND t1.DESC_OFICINA = ?");
			params.add(unidadesdir3.getDescOficina());
		}
		if (unidadesdir3 != null && unidadesdir3.getCodUnidad() != null) {
			where.append(" AND t1.COD_UNIDAD = ?");
			params.add(unidadesdir3.getCodUnidad());
		}
		if (unidadesdir3 != null && unidadesdir3.getDescUnidad() != null) {
			where.append(" AND t1.DESC_UNIDAD = ?");
			params.add(unidadesdir3.getDescUnidad());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the UnidadesDir3 entity
	 *
	 * @param unidadesdir3
	 *            UnidadesDir3 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(UnidadesDir3 unidadesdir3, Boolean startsWith) {

		StringBuilder where = new StringBuilder(UnidadesDir3DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (unidadesdir3 != null && unidadesdir3.getIdUnidadDir3() != null) {
			where.append(" AND UPPER(t1.ID_UNIDAD_DIR3) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(unidadesdir3.getIdUnidadDir3().toUpperCase() + "%");
			} else {
				params.add("%" + unidadesdir3.getIdUnidadDir3().toUpperCase() + "%");
			}
			where.append(" AND t1.ID_UNIDAD_DIR3 IS NOT NULL");
		}
		if (unidadesdir3 != null && unidadesdir3.getCodOficina() != null) {
			where.append(" AND UPPER(t1.COD_OFICINA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(unidadesdir3.getCodOficina().toUpperCase() + "%");
			} else {
				params.add("%" + unidadesdir3.getCodOficina().toUpperCase() + "%");
			}
			where.append(" AND t1.COD_OFICINA IS NOT NULL");
		}
		if (unidadesdir3 != null && unidadesdir3.getDescOficina() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.DESC_OFICINA),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(unidadesdir3.getDescOficina().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + unidadesdir3.getDescOficina().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.DESC_OFICINA IS NOT NULL");
		}

		if (unidadesdir3 != null && unidadesdir3.getCodUnidad() != null) {
			where.append(" AND UPPER(t1.COD_UNIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(unidadesdir3.getCodUnidad().toUpperCase() + "%");
			} else {
				params.add("%" + unidadesdir3.getCodUnidad().toUpperCase() + "%");
			}
			where.append(" AND t1.COD_UNIDAD IS NOT NULL");
		}
		if (unidadesdir3 != null && unidadesdir3.getDescUnidad() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.DESC_UNIDAD),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(unidadesdir3.getDescUnidad().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + unidadesdir3.getDescUnidad().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.DESC_UNIDAD IS NOT NULL");
		}

		if (unidadesdir3 != null && unidadesdir3.getNivelAdmin() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NIVEL_ADMIN),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(unidadesdir3.getNivelAdmin().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + unidadesdir3.getNivelAdmin().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NIVEL_ADMIN IS NOT NULL");
		}

		if (unidadesdir3 != null && unidadesdir3.getComunidad() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.COMUNIDAD),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(unidadesdir3.getComunidad().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + unidadesdir3.getComunidad().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.COMUNIDAD IS NOT NULL");
		}

		if (unidadesdir3 != null && unidadesdir3.getTextoOU() != null) {
			where.append(" AND ( ");
			where.append(" ( ");
			where.append(" TRANSLATE(UPPER(t1.DESC_OFICINA),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(unidadesdir3.getTextoOU().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + unidadesdir3.getTextoOU().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.DESC_OFICINA IS NOT NULL");
			where.append(" ) ");

			where.append(" OR ");
			where.append(" ( ");
			where.append(" TRANSLATE(UPPER(t1.DESC_UNIDAD),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(unidadesdir3.getTextoOU().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + unidadesdir3.getTextoOU().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.DESC_UNIDAD IS NOT NULL");
			where.append(" ) ");
			where.append(" ) ");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds rows in the UnidadesDir3 table using like.
	 *
	 * @param unidadesdir3
	 *            UnidadesDir3
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List<UnidadesDir3>
	 */
	@Transactional(readOnly = true)
	public List<UnidadesDir3> findAllLikeDir3(UnidadesDir3 unidadesdir3, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_UNIDAD_DIR3 IDUNIDADDIR3, t1.COD_OFICINA CODOFICINA, t1.DESC_OFICINA DESCOFICINA, t1.COD_UNIDAD CODUNIDAD, t1.DESC_UNIDAD DESCUNIDAD, t1.NIVEL_ADMIN NIVELADMIN, t1.COMUNIDAD COMUNIDAD ");
		query.append("FROM UNIDADES_DIR3 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(unidadesdir3, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<UnidadesDir3>) this.jdbcTemplate.query(query.toString(), this.rwMapDir3, params.toArray());
	}

	/**
	 * Counts rows in the UnidadesDir3 table using like.
	 *
	 * @param unidadesdir3
	 *            UnidadesDir3
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeDir3Count(UnidadesDir3 unidadesdir3, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM UNIDADES_DIR3 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(unidadesdir3, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}
}
