package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.UnidadesDir3;

/**
 * UnidadesDir3Dao  
 * 
 *  
 */

public interface UnidadesDir3Dao {

	/**
	 * Inserts a single row in the UnidadesDir3 table.
	 *
	 * @param unidadesdir3
	 *            UnidadesDir3
	 * @return UnidadesDir3
	 */
	UnidadesDir3 add(UnidadesDir3 unidadesdir3);

	/**
	 * Updates a single row in the UnidadesDir3 table.
	 *
	 * @param unidadesdir3
	 *            UnidadesDir3
	 * @return UnidadesDir3
	 */
	UnidadesDir3 update(UnidadesDir3 unidadesdir3);

	/**
	 * Finds a single row in the UnidadesDir3 table.
	 *
	 * @param unidadesdir3
	 *            UnidadesDir3
	 * @return UnidadesDir3
	 */
	UnidadesDir3 find(UnidadesDir3 unidadesdir3);

	/**
	 * Removes a single row in the UnidadesDir3 table.
	 *
	 * @param unidadesdir3
	 *            UnidadesDir3
	 */
	void remove(UnidadesDir3 unidadesdir3);

	/**
	 * Finds a List of rows in the UnidadesDir3 table.
	 *
	 * @param unidadesdir3
	 *            UnidadesDir3
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<UnidadesDir3> findAll(UnidadesDir3 unidadesdir3, Pagination pagination);

	/**
	 * Finds rows in the UnidadesDir3 table using like.
	 *
	 * @param unidadesdir3
	 *            UnidadesDir3
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<UnidadesDir3> findAllLike(UnidadesDir3 unidadesdir3, Pagination pagination, Boolean startsWith);

	/**
	 * Finds rows in the UnidadesDir3 table using like.
	 *
	 * @param unidadesdir3
	 *            UnidadesDir3
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List<UnidadesDir3>
	 */
	public List<UnidadesDir3> findAllLikeOficinas(UnidadesDir3 unidadesdir3, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the UnidadesDir3 table using like.
	 *
	 * @param unidadesdir3
	 *            UnidadesDir3
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(UnidadesDir3 unidadesdir3, Boolean startsWith);

	/**
	 * Counts rows in the UnidadesDir3 table using like.
	 *
	 * @param unidadesdir3
	 *            UnidadesDir3
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCountOficinas(UnidadesDir3 unidadesdir3, Boolean startsWith);

	/**
	 * Counts rows in the UnidadesDir3 table.
	 *
	 * @param unidadesdir3
	 *            UnidadesDir3
	 * @return Long
	 */
	Long findAllCount(UnidadesDir3 unidadesdir3);

	/**
	 * Finds rows in the UnidadesDir3 table using like.
	 *
	 * @param unidadesdir3
	 *            UnidadesDir3
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List<UnidadesDir3>
	 */
	public List<UnidadesDir3> findAllLikeDir3(UnidadesDir3 unidadesdir3, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the UnidadesDir3 table using like.
	 *
	 * @param unidadesdir3
	 *            UnidadesDir3
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeDir3Count(UnidadesDir3 unidadesdir3, Boolean startsWith);
}
