package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Tribunal;

/**
 * TribunalDao  
 *  
 */

public interface TribunalDao {
    
    /**
     * Inserts a single row in the Tribunal table.
     *
     * @param tribunal Tribunal
     * @return Tribunal
     */
    Tribunal add(Tribunal tribunal);

    /**
     * Updates a single row in the Tribunal table.
     *
     * @param tribunal Tribunal
     * @return Tribunal
     */
    Tribunal update(Tribunal tribunal);

    /**
     * Finds a single row in the Tribunal table.
     *
     * @param tribunal Tribunal
     * @return Tribunal
     */
    Tribunal find(Tribunal tribunal);

    /**
     * Deletes a single row in the Tribunal table.
     *
     * @param tribunal Tribunal
     * @return 
     */
    void remove(Tribunal tribunal);

    /**
     * Finds a List of rows in the Tribunal table.
     *
     * @param tribunal Tribunal
     * @param pagination Pagination
     * @return List
     */
    List<Tribunal> findAll(Tribunal tribunal, Pagination pagination);

    /**
     * Counts rows in the Tribunal table.
     *
     * @param tribunal Tribunal
     * @return Long
     */
    Long findAllCount(Tribunal tribunal);
	
	/**
     * Finds rows in the Tribunal table using like.
     *
     * @param tribunal Tribunal
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<Tribunal> findAllLike(Tribunal tribunal, Pagination pagination, Boolean startsWith);
	
    /**
     * Counts rows in the Tribunal table using like.
     *
     * @param tribunal Tribunal
     * @param startsWith Boolean
     * @return Long
     */
    Long findAllLikeCount(Tribunal tribunal, Boolean startsWith);
}

