package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.TramiteHechoDetalle;
import com.ejie.y41b.model.Traslado;
import com.ejie.y41b.model.TrasladoBusqueda;

/**
 * * TrasladoDao  
 * 
 *  
 */

public interface TrasladoDao {

	/**
	 * Inserts a single row in the Traslado table.
	 * 
	 * @param traslado
	 *            Traslado
	 * @return Traslado
	 */
	Traslado add(Traslado traslado);

	/**
	 * Inserts a single row in the Traslado table.
	 * 
	 * @param traslado
	 *            Pagination
	 * @return Traslado
	 */
	Traslado addTraslado(Traslado traslado);

	/**
	 * Updates a single row in the Traslado table.
	 * 
	 * @param traslado
	 *            Traslado
	 * @return Traslado
	 */
	Traslado update(Traslado traslado);

	/**
	 * Updates a single row in the Traslado table.
	 * 
	 * @param trasladoBusqueda
	 *            TrasladoBusqueda
	 * @return TrasladoBusqueda
	 */
	TrasladoBusqueda updateTraslado(TrasladoBusqueda trasladoBusqueda);

	/**
	 * Finds a single row in the Traslado table.
	 * 
	 * @param traslado
	 *            Traslado
	 * @return Traslado
	 */
	Traslado find(Traslado traslado);

	/**
	 * Finds a single row in the Traslado table.
	 * 
	 * @param trasladoBusqueda
	 *            TrasladoBusqueda
	 * @return TrasladoBusqueda
	 */
	TrasladoBusqueda findTraslado(TrasladoBusqueda trasladoBusqueda);

	/**
	 * Finds a single row in the Traslado table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TrasladoBusqueda
	 */
	TrasladoBusqueda findTrasladoTramite(TramiteHechoDetalle tramiteHechoDetalle);

	/**
	 * Deletes a single row in the Traslado table.
	 * 
	 * @param traslado
	 *            Traslado
	 * @return
	 */
	void remove(Traslado traslado);

	/**
	 * Removes a single row in the Traslado table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return
	 */
	public void removeTrasladoExpediente(SolicitudDetalle solicitudDetalle);

	/**
	 * Finds a List of rows in the Traslado table.
	 * 
	 * @param traslado
	 *            Traslado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Traslado> findAll(Traslado traslado, Pagination pagination);

	/**
	 * Counts rows in the Traslado table.
	 * 
	 * @param traslado
	 *            Traslado
	 * @return List
	 */
	Long findAllCount(Traslado traslado);

	/**
	 * Finds rows in the Traslado table using like.
	 * 
	 * @param traslado
	 *            Traslado
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Traslado> findAllLike(Traslado traslado, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds rows in the Traslado table using like.
	 * 
	 * @param trasladoBusqueda
	 *            TrasladoBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<TrasladoBusqueda> findAllTraslado(TrasladoBusqueda trasladoBusqueda,
			Pagination pagination);

	/**
	 * Counts rows in the Traslado table.
	 * 
	 * @param trasladoBusqueda
	 *            TrasladoBusqueda
	 * @return Long
	 */
	Long findAllTrasladoCount(TrasladoBusqueda trasladoBusqueda);
}
