// CHECKSTYLE:OFF
package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.horizontalSystemOfNotification.xml.DeliveredNotificationInfoDocument.DeliveredNotificationInfo;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Acta;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.NotificacionAcuseRecibo;
import com.ejie.y41b.model.NotificacionesComunicacionesBusqueda;
import com.ejie.y41b.model.TramiteHecho;
import com.ejie.y41b.model.TramiteHechoDetalleKnet;
import com.ejie.y41b.model.TramiteInspeccion;
import com.ejie.y41b.model.TramiteInspeccionDetalle;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * TramiteInspeccionDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class TramiteInspeccionDaoImpl implements TramiteInspeccionDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<TramiteInspeccion> rwMap = new RowMapper<TramiteInspeccion>() {
		public TramiteInspeccion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new TramiteInspeccion(resultSet.getString("TICODIGO"), resultSet.getString("TIATCODIGO"),
					resultSet.getString("TIACCODIGO"), resultSet.getString("TICOTEE"),
					resultSet.getTimestamp("TIFECHAINICIO"), resultSet.getTimestamp("TIFECHAFIN"),
					resultSet.getString("TICOMOASIGNADO"), resultSet.getString("TICOMOEJECUCION"),
					Y41bUtils.clobToString(resultSet.getClob("TICOMENTARIO")), resultSet.getString("TICOMODESIGNADO"),
					Y41bUtils.clobToString(resultSet.getClob("TIDOCUMENTACIONREQUERIDA")),
					Y41bUtils.clobToString(resultSet.getClob("TIDOCUMENTACIONREQUERIDAE")),
					resultSet.getString("TIDECODIGO"), resultSet.getDate("TIFECHARESOLUCION"),
					resultSet.getDate("TIFECHARECURSO"), resultSet.getString("TITIPORECURSO"),
					resultSet.getString("TIABOGADO"), Y41bUtils.clobToString(resultSet.getClob("TIMOTIVORECURSO")),
					resultSet.getString("TIESTIMACION"), resultSet.getDate("TIFECHACIERRE"),
					resultSet.getString("TIDESTINATARIO"), resultSet.getDate("TIFECHACOMUNICACION"),
					resultSet.getString("TITIPOCOMUNICACION"), resultSet.getString("TITIPONOTIFICACION"),
					resultSet.getString("TINOTIFICACIONPORACTA"), resultSet.getString("TINUMREGISTROSALIDA"),
					resultSet.getDate("TIFECHAREGISTROSALIDA"), resultSet.getDate("TIACUSERECIBO"),
					resultSet.getString("TIACUSERECIBORECIBIDO"), resultSet.getString("TINUMREGISTROENTRADA"),
					resultSet.getDate("TIFECHAREGISTROENTRADA"), resultSet.getString("TIIDNOTIFICACIONPLATEA"),
					resultSet.getString("TINOMBRETRAMITE"), resultSet.getString("TIIDDESTINATARIO"),
					resultSet.getString("TIESTADOTRAMITE"), resultSet.getString("TIREQUIEREFIRMA"),
					Y41bUtils.clobToString(resultSet.getClob("TITEXTOCOMUNICACION")),
					resultSet.getString("TITIPONOTIFICACIONPLATEA"), resultSet.getString("TIIDESPERAPLATEA"),
					resultSet.getString("TIMATARESPERA"), resultSet.getString("TIASUNTOCOMUNICACION"),
					resultSet.getDate("TIFECHAENVIOBOPVBOE"), resultSet.getDate("TIFECHAPUBLICACIONBOPV"),
					resultSet.getDate("TIFECHAPUBLICACIONAYTO"), resultSet.getString("TISEDE"),
					resultSet.getDate("TIFECHALIMITE"), resultSet.getString("TICODREM"),
					resultSet.getString("TIENVREM"), resultSet.getString("TIFCODIGO"),
					resultSet.getString("TIIDMAILORIGEN"), resultSet.getString("TIMAILORIGEN"),
					resultSet.getString("TIIDMAILDESTINO"), resultSet.getString("TIMAILDESTINO"),
					resultSet.getString("TIPROCEEDINGSIDPLATEA"), resultSet.getString("TIACUSEREINTENTADO"),
					resultSet.getString("TIAUTOMATICO"), resultSet.getString("TIORIGENALEGACION"),
					resultSet.getString("TIANCODIGO"), resultSet.getString("TITIPACTUA"),
					resultSet.getString("TIRESPUESTARECEPCION"),
					Y41bUtils.clobToString(resultSet.getClob("TIRESUMENRECEPCION")),
					resultSet.getDate("TIFECHAREDALERTA"), resultSet.getString("TIINCLUSIREDALERTA"),
					Y41bUtils.clobToString(resultSet.getClob("TIMOTIVOREDALERTA")),
					Y41bUtils.clobToString(resultSet.getClob("TIJUSTIFICACIONINFRACCION")),
					resultSet.getDate("TIFECHAENVLAB"), resultSet.getString("TICODMUESTRA"),
					resultSet.getString("TILACODIGO"), Y41bUtils.clobToString(resultSet.getClob("TIDETANA")),
					resultSet.getDate("TIFECHARESENS"), resultSet.getString("TICODINFENSAY"),
					Y41bUtils.clobToString(resultSet.getClob("TIRESUDICTAM")), resultSet.getString("TICONSTATACION"),
					resultSet.getDate("TIFECHADESIN"), resultSet.getString("TINUMDESIN"),
					resultSet.getString("TINUMIN"),

					resultSet.getString("TIDESTINODESIN"), resultSet.getString("TIDESTRUCCIONINSITU"),
					resultSet.getString("TIEMPRESAGEST"), resultSet.getString("TINUMRECUPE"),
					resultSet.getString("TINUMADESTRUIR"), resultSet.getString("TINUMADEVOLVER"),
					resultSet.getDate("TIFECHAEMIINF"), resultSet.getString("TIHORAINICIOEMIINF"),
					resultSet.getString("TIHORAFININF"), resultSet.getString("TIDNIINF"),
					resultSet.getString("TINOMBREINF"), resultSet.getString("TINORAPROVINCIAID"),
					resultSet.getString("TINOMBREPROVINCIA"), resultSet.getString("TINORAMUNICIPIOID"),
					resultSet.getString("TINOMBREMUNICIPIO"), resultSet.getString("TINORALOCALIDADID"),
					resultSet.getString("TINOMBRELOCALIDAD"), resultSet.getString("TINORACALLEID"),
					resultSet.getString("TINOMBRECALLE"), resultSet.getString("TINORACPID"),
					resultSet.getString("TINOMBRECP"), resultSet.getString("TINORAPORTALID"),
					resultSet.getString("TINOMBREPORTAL"), resultSet.getString("TINOMBREPISO"),
					resultSet.getString("TIDIRECCIONNOCAPV"), resultSet.getString("TIEXTRANJERO"),
					resultSet.getString("TINORAPAISID"), resultSet.getString("TINOMBREPAIS"),
					resultSet.getString("TITELINF"), resultSet.getString("TIENCONDICIONINF"),
					Y41bUtils.clobToString(resultSet.getClob("TIINFORME")),
					Y41bUtils.clobToString(resultSet.getClob("TIVALORACION")), resultSet.getDate("TIFECHAACEPTACION"),
					resultSet.getDate("TIFECHAAMPLI"), Y41bUtils.clobToString(resultSet.getClob("TIMOTIVOAMPLI")),
					resultSet.getString("TICOALREL"), resultSet.getString("TICOORTRASPASO"),
					resultSet.getString("TITELINF2"), resultSet.getString("TICOMPDIRECCION"),
					resultSet.getString("TIAPE1INF"), resultSet.getString("TIAPE2INF"), resultSet.getDate("TIFECHAAIP"),
					resultSet.getDate("TIFECALTA"), resultSet.getDate("TIFECMODIF"), resultSet.getString("TICOCR"),
					resultSet.getString("TILIGADOPROTOCOLO"), resultSet.getString("TIISTELEMATICO"),
					resultSet.getString("TIISSIR"), resultSet.getString("TIISSIRCONNUMREGENTORI"),
					resultSet.getString("TICOCMREL"), resultSet.getString("TICOPG"),
					resultSet.getString("TIEXCLUIRCIERRE"), resultSet.getString("TIARCHIVAR"),
					new TramiteInspeccion(resultSet.getString("TRAMINSTICODIGO"),
							resultSet.getString("TRAMINSTIATCODIGO"), resultSet.getString("TRAMINSTIACCODIGO"),
							resultSet.getString("TRAMINSTICOTEE"), resultSet.getDate("TRAMINSTIFECHAINICIO"),
							resultSet.getDate("TRAMINSTIFECHAFIN"), resultSet.getString("TRAMINSTICOMOASIGNADO"),
							resultSet.getString("TRAMINSTICOMOEJECUCION"),
							Y41bUtils.clobToString(resultSet.getClob("TRAMINSTICOMENTARIO")),
							resultSet.getString("TRAMINSTICOMODESIGNADO"),
							Y41bUtils.clobToString(resultSet.getClob("TRAMINSTIDOCUREQUERIDA")),
							Y41bUtils.clobToString(resultSet.getClob("TRAMINSTIDOCUREQUERIDAE")),
							resultSet.getString("TRAMINSTIDECODIGO"), resultSet.getDate("TRAMINSTIFECHARESOLUCION"),
							resultSet.getDate("TRAMINSTIFECHARECURSO"), resultSet.getString("TRAMINSTITIPORECURSO"),
							resultSet.getString("TRAMINSTIABOGADO"),
							Y41bUtils.clobToString(resultSet.getClob("TRAMINSTIMOTIVORECURSO")),
							resultSet.getString("TRAMINSTIESTIMACION"), resultSet.getDate("TRAMINSTIFECHACIERRE"),
							resultSet.getString("TRAMINSTIDESTINATARIO"),
							resultSet.getDate("TRAMINSTIFECHACOMUNICACION"),
							resultSet.getString("TRAMINSTITIPOCOMUNICACION"),
							resultSet.getString("TRAMINSTITIPONOTIFICACION"),
							resultSet.getString("TRAMINSTINOTIFICACIONPORACTA"),
							resultSet.getString("TRAMINSTINUMREGISTROSALIDA"),
							resultSet.getDate("TRAMINSTIFECHAREGSALIDA"), resultSet.getDate("TRAMINSTIACUSERECIBO"),
							resultSet.getString("TRAMINSTIACUSERECRECIBIDO"),
							resultSet.getString("TRAMINSTINUMREGISTROENTRADA"),
							resultSet.getDate("TRAMINSTIFECHAREGENTRADA"),
							resultSet.getString("TRAMINSTIIDNOTIFPLATEA"),
							resultSet.getString("TRAMINSTINOMBRETRAMITE"),
							resultSet.getString("TRAMINSTIIDDESTINATARIO"),
							resultSet.getString("TRAMINSTIESTADOTRAMITE"),
							resultSet.getString("TRAMINSTIREQUIEREFIRMA"),
							Y41bUtils.clobToString(resultSet.getClob("TRAMINSTITEXTOCOMUNICACION")),
							resultSet.getString("TRAMINSTITIPONOTIFPLATEA"),
							resultSet.getString("TRAMINSTIIDESPERAPLATEA"), resultSet.getString("TRAMINSTIMATARESPERA"),
							resultSet.getString("TRAMINSTIASUNTOCOMUNICACION"),
							resultSet.getDate("TRAMINSTIFECHAENVIOBOPVBOE"), resultSet.getDate("TRAMINSTIFECHAPUBBOPV"),
							resultSet.getDate("TRAMINSTIFECHAPUBAYTO"), resultSet.getString("TRAMINSTISEDE"),
							resultSet.getDate("TRAMINSTIFECHALIMITE"), resultSet.getString("TRAMINSTICODREM"),
							resultSet.getString("TRAMINSTIENVREM"), resultSet.getString("TRAMINSTIFCODIGO"),
							resultSet.getString("TRAMINSTIIDMAILORIGEN"), resultSet.getString("TRAMINSTIMAILORIGEN"),
							resultSet.getString("TRAMINSTIIDMAILDESTINO"), resultSet.getString("TRAMINSTIMAILDESTINO"),
							resultSet.getString("TRAMINSTIPROCEEDINGSIDPLATEA"),
							resultSet.getString("TRAMINSTIACUSEREINTENTADO"),
							resultSet.getString("TRAMINSTIAUTOMATICO"), resultSet.getString("TRAMINSTIORIGENALEGACION"),
							resultSet.getString("TRAMINSTIANCODIGO"), resultSet.getString("TRAMINSTITIPACTUA"),
							resultSet.getString("TRAMINSTIRESPUESTARECEPCION"),
							Y41bUtils.clobToString(resultSet.getClob("TRAMINSTIRESUMENRECEPCION")),
							resultSet.getDate("TRAMINSTIFECHAREDALERTA"),
							resultSet.getString("TRAMINSTIINCLUSIREDALERTA"),
							Y41bUtils.clobToString(resultSet.getClob("TRAMINSTIMOTIVOREDALERTA")),
							Y41bUtils.clobToString(resultSet.getClob("TRAMINSTIJUSTIFINFRACCION")),
							resultSet.getDate("TRAMINSTIFECHAENVLAB"), resultSet.getString("TRAMINSTICODMUESTRA"),
							resultSet.getString("TRAMINSTILACODIGO"),
							Y41bUtils.clobToString(resultSet.getClob("TRAMINSTIDETANA")),
							resultSet.getDate("TRAMINSTIFECHARESENS"), resultSet.getString("TRAMINSTICODINFENSAY"),
							Y41bUtils.clobToString(resultSet.getClob("TRAMINSTIRESUDICTAM")),
							resultSet.getString("TRAMINSTICONSTATACION"), resultSet.getDate("TRAMINSTIFECHADESIN"),
							resultSet.getString("TRAMINSTINUMDESIN"), resultSet.getString("TRAMINSTINUMIN"),
							resultSet.getString("TRAMINSTIDESTINODESIN"),
							resultSet.getString("TRAMINSTIDESTRUCCIONINSITU"),
							resultSet.getString("TRAMINSTIEMPRESAGEST"), resultSet.getString("TRAMINSTINUMRECUPE"),
							resultSet.getString("TRAMINSTINUMADESTRUIR"), resultSet.getString("TRAMINSTINUMADEVOLVER"),
							resultSet.getDate("TRAMINSTIFECHAEMIINF"), resultSet.getString("TRAMINSTIHORAINICIOEMIINF"),
							resultSet.getString("TRAMINSTIHORAFININF"), resultSet.getString("TRAMINSTIDNIINF"),
							resultSet.getString("TRAMINSTINOMBREINF"), resultSet.getString("TRAMINSTINORAPROVINCIAID"),
							resultSet.getString("TRAMINSTINOMBREPROVINCIA"),
							resultSet.getString("TRAMINSTINORAMUNICIPIOID"),
							resultSet.getString("TRAMINSTINOMBREMUNICIPIO"),
							resultSet.getString("TRAMINSTINORALOCALIDADID"),
							resultSet.getString("TRAMINSTINOMBRELOCALIDAD"),
							resultSet.getString("TRAMINSTINORACALLEID"), resultSet.getString("TRAMINSTINOMBRECALLE"),
							resultSet.getString("TRAMINSTINORACPID"), resultSet.getString("TRAMINSTINOMBRECP"),
							resultSet.getString("TRAMINSTINORAPORTALID"), resultSet.getString("TRAMINSTINOMBREPORTAL"),
							resultSet.getString("TRAMINSTINOMBREPISO"), resultSet.getString("TRAMINSTIDIRECCIONNOCAPV"),
							resultSet.getString("TRAMINSTIEXTRANJERO"), resultSet.getString("TRAMINSTINORAPAISID"),
							resultSet.getString("TRAMINSTINOMBREPAIS"), resultSet.getString("TRAMINSTITELINF"),
							resultSet.getString("TRAMINSTIENCONDICIONINF"),
							Y41bUtils.clobToString(resultSet.getClob("TRAMINSTIINFORME")),
							Y41bUtils.clobToString(resultSet.getClob("TRAMINSTIVALORACION")),
							resultSet.getDate("TRAMINSTIFECHAACEPTACION"), resultSet.getDate("TRAMINSTIFECHAAMPLI"),
							Y41bUtils.clobToString(resultSet.getClob("TRAMINSTIMOTIVOAMPLI")), null,
							resultSet.getString("TRAMINSTICOORTRASPASO"), resultSet.getString("TRAMINSTITELINF2"),
							resultSet.getString("TRAMINSTICOMPDIRECCION"), resultSet.getString("TRAMINSTIAPE1INF"),
							resultSet.getString("TRAMINSTIAPE2INF"), resultSet.getDate("TRAMINSTIFECHAAIP"),
							resultSet.getDate("TRAMINSTIFECALTA"), resultSet.getDate("TRAMINSTIFECMODIF"), null, null,
							null, null, null, null, null, null, null,
							new TramiteInspeccion(resultSet.getString("TRAMINSTICODIGORELACIONADO"))));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteinspeccion
	 *            Pagination
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             excepcion
	 */
	public TramiteInspeccion add(TramiteInspeccion tramiteinspeccion) throws Exception {
		String query = "INSERT INTO TRAMITE_INSPECCION (TICODIGO, TIATCODIGO, TICOTEE, TICODIGORELACIONADO, TIFECHAINICIO, TIFECHAFIN, TICOMOASIGNADO, TICOMOEJECUCION, TICOMENTARIO, TICOMODESIGNADO, TIDOCUMENTACIONREQUERIDA, TIDOCUMENTACIONREQUERIDAE, TIDECODIGO, TIFECHARESOLUCION, TIFECHARECURSO, TITIPORECURSO, TIABOGADO, TIMOTIVORECURSO, TIESTIMACION, TIFECHACIERRE, TIDESTINATARIO, TIFECHACOMUNICACION, TITIPOCOMUNICACION, TITIPONOTIFICACION, TINOTIFICACIONPORACTA, TINUMREGISTROSALIDA, TIFECHAREGISTROSALIDA, TIACUSERECIBO, TIACUSERECIBORECIBIDO, TINUMREGISTROENTRADA, TIFECHAREGISTROENTRADA, TIIDNOTIFICACIONPLATEA, TINOMBRETRAMITE, TIIDDESTINATARIO, TIESTADOTRAMITE, TIREQUIEREFIRMA, TITEXTOCOMUNICACION, TITIPONOTIFICACIONPLATEA, TIIDESPERAPLATEA, TIMATARESPERA, TIASUNTOCOMUNICACION, TIFECHAENVIOBOPVBOE, TIFECHAPUBLICACIONBOPV, TIFECHAPUBLICACIONAYTO, TISEDE, TIFECHALIMITE, TICODREM, TIENVREM, TIFCODIGO, TIIDMAILORIGEN, TIMAILORIGEN, TIIDMAILDESTINO, TIMAILDESTINO, TIPROCEEDINGSIDPLATEA, TIACUSEREINTENTADO, TIAUTOMATICO, TIORIGENALEGACION, TIANCODIGO, TITIPACTUA, TIRESPUESTARECEPCION, TIRESUMENRECEPCION, TIFECHAREDALERTA, TIINCLUSIREDALERTA, TIMOTIVOREDALERTA, TIJUSTIFICACIONINFRACCION, TIFECHAENVLAB, TICODMUESTRA, TILACODIGO, TIDETANA, TIFECHARESENS, TICODINFENSAY, TIRESUDICTAM, TICONSTATACION, TIFECHADESIN, TINUMDESIN, TINUMIN, TIDESTINODESIN, TIDESTRUCCIONINSITU, TIEMPRESAGEST, TINUMRECUPE, TINUMADESTRUIR, TINUMADEVOLVER, TIFECHAEMIINF, TIHORAINICIOEMIINF, TIHORAFININF, TIDNIINF, TINOMBREINF, TINORA_PROVINCIA_ID, TINOMBRE_PROVINCIA, TINORA_MUNICIPIO_ID, TINOMBRE_MUNICIPIO, TINORA_LOCALIDAD_ID, TINOMBRE_LOCALIDAD, TINORA_CALLE_ID, TINOMBRE_CALLE, TINORA_CP_ID, TINOMBRE_CP, TINORA_PORTAL_ID, TINOMBRE_PORTAL, TINOMBRE_PISO, TIDIRECCION_NOCAPV, TIEXTRANJERO, TINORA_PAIS_ID, TINOMBRE_PAIS, TITELINF, TIENCONDICIONINF, TIINFORME, TIVALORACION, TIFECHAACEPTACION, TIFECHAAMPLI, TIMOTIVOAMPLI, TIACCODIGO, TICOORTRASPASO, TICOALREL, TITELINF2, TICOMPDIRECCION, TIAPE1INF, TIAPE2INF, TIFECHAAIP,TICOCR, TILIGADOPROTOCOLO, TIISTELEMATICO, TIISSIR, TIISSIRCONNUMREGENTORI, TICOCMREL, TICOPG, TIEXCLUIRCIERRE, TIARCHIVAR) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		Object getTramiteInspeccionTicodigoAux = null;
		if (tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTicodigo() != null) {
			getTramiteInspeccionTicodigoAux = tramiteinspeccion.getTramiteInspeccion().getTicodigo();
		}
		this.jdbcTemplate.update(query, tramiteinspeccion.getTicodigo(), tramiteinspeccion.getTiatcodigo(),
				tramiteinspeccion.getTicotee(), getTramiteInspeccionTicodigoAux, tramiteinspeccion.getTifechainicio(),
				tramiteinspeccion.getTifechafin(), tramiteinspeccion.getTicomoasignado(),
				tramiteinspeccion.getTicomoejecucion(), tramiteinspeccion.getTicomentario(),
				tramiteinspeccion.getTicomodesignado(), tramiteinspeccion.getTidocumentacionrequerida(),
				tramiteinspeccion.getTidocumentacionrequeridae(), tramiteinspeccion.getTidecodigo(),
				tramiteinspeccion.getTifecharesolucion(), tramiteinspeccion.getTifecharecurso(),
				tramiteinspeccion.getTitiporecurso(), tramiteinspeccion.getTiabogado(),
				tramiteinspeccion.getTimotivorecurso(), tramiteinspeccion.getTiestimacion(),
				tramiteinspeccion.getTifechacierre(), tramiteinspeccion.getTidestinatario(),
				tramiteinspeccion.getTifechacomunicacion(), tramiteinspeccion.getTitipocomunicacion(),
				tramiteinspeccion.getTitiponotificacion(), tramiteinspeccion.getTinotificacionporacta(),
				tramiteinspeccion.getTinumregistrosalida(), tramiteinspeccion.getTifecharegistrosalida(),
				tramiteinspeccion.getTiacuserecibo(), tramiteinspeccion.getTiacusereciborecibido(),
				tramiteinspeccion.getTinumregistroentrada(), tramiteinspeccion.getTifecharegistroentrada(),
				tramiteinspeccion.getTiidnotificacionplatea(), tramiteinspeccion.getTinombretramite(),
				tramiteinspeccion.getTiiddestinatario(), tramiteinspeccion.getTiestadotramite(),
				tramiteinspeccion.getTirequierefirma(), tramiteinspeccion.getTitextocomunicacion(),
				tramiteinspeccion.getTitiponotificacionplatea(), tramiteinspeccion.getTiidesperaplatea(),
				tramiteinspeccion.getTimatarespera(), tramiteinspeccion.getTiasuntocomunicacion(),
				tramiteinspeccion.getTifechaenviobopvboe(), tramiteinspeccion.getTifechapublicacionbopv(),
				tramiteinspeccion.getTifechapublicacionayto(), tramiteinspeccion.getTisede(),
				tramiteinspeccion.getTifechalimite(), tramiteinspeccion.getTicodrem(), tramiteinspeccion.getTienvrem(),
				tramiteinspeccion.getTifcodigo(), tramiteinspeccion.getTiidmailorigen(),
				tramiteinspeccion.getTimailorigen(), tramiteinspeccion.getTiidmaildestino(),
				tramiteinspeccion.getTimaildestino(), tramiteinspeccion.getTiproceedingsidplatea(),
				tramiteinspeccion.getTiacusereintentado(), tramiteinspeccion.getTiautomatico(),
				tramiteinspeccion.getTiorigenalegacion(), tramiteinspeccion.getTiancodigo(),
				tramiteinspeccion.getTitipactua(), tramiteinspeccion.getTirespuestarecepcion(),
				tramiteinspeccion.getTiresumenrecepcion(), tramiteinspeccion.getTifecharedalerta(),
				tramiteinspeccion.getTiinclusiredalerta(), tramiteinspeccion.getTimotivoredalerta(),
				tramiteinspeccion.getTijustificacioninfraccion(), tramiteinspeccion.getTifechaenvlab(),
				tramiteinspeccion.getTicodmuestra(), tramiteinspeccion.getTilacodigo(), tramiteinspeccion.getTidetana(),
				tramiteinspeccion.getTifecharesens(), tramiteinspeccion.getTicodinfensay(),
				tramiteinspeccion.getTiresudictam(), tramiteinspeccion.getTiconstatacion(),
				tramiteinspeccion.getTifechadesin(), tramiteinspeccion.getTinumdesin(), tramiteinspeccion.getTinumin(),
				tramiteinspeccion.getTidestinodesin(), tramiteinspeccion.getTidestruccioninsitu(),
				tramiteinspeccion.getTiempresagest(), tramiteinspeccion.getTinumrecupe(),
				tramiteinspeccion.getTinumadestruir(), tramiteinspeccion.getTinumadevolver(),
				tramiteinspeccion.getTifechaemiinf(), tramiteinspeccion.getTihorainicioemiinf(),
				tramiteinspeccion.getTihorafininf(), tramiteinspeccion.getTidniinf(),
				tramiteinspeccion.getTinombreinf(), tramiteinspeccion.getTinoraProvinciaId(),
				tramiteinspeccion.getTinombreProvincia(), tramiteinspeccion.getTinoraMunicipioId(),
				tramiteinspeccion.getTinombreMunicipio(), tramiteinspeccion.getTinoraLocalidadId(),
				tramiteinspeccion.getTinombreLocalidad(), tramiteinspeccion.getTinoraCalleId(),
				tramiteinspeccion.getTinombreCalle(), tramiteinspeccion.getTinoraCpId(),
				tramiteinspeccion.getTinombreCp(), tramiteinspeccion.getTinoraPortalId(),
				tramiteinspeccion.getTinombrePortal(), tramiteinspeccion.getTinombrePiso(),
				tramiteinspeccion.getTidireccionNocapv(), tramiteinspeccion.getTiextranjero(),
				tramiteinspeccion.getTinoraPaisId(), tramiteinspeccion.getTinombrePais(),
				tramiteinspeccion.getTitelinf(), tramiteinspeccion.getTiencondicioninf(),
				tramiteinspeccion.getTiinforme(), tramiteinspeccion.getTivaloracion(),
				tramiteinspeccion.getTifechaaceptacion(), tramiteinspeccion.getTifechaampli(),
				tramiteinspeccion.getTimotivoampli(), tramiteinspeccion.getTiaccodigo(),
				tramiteinspeccion.getTicoortraspaso(), tramiteinspeccion.getTicoalrel(),
				tramiteinspeccion.getTitelinf2(), tramiteinspeccion.getTicompdireccion(),
				tramiteinspeccion.getTiape1inf(), tramiteinspeccion.getTiape2inf(), tramiteinspeccion.getTifechaaip(),
				tramiteinspeccion.getTicocr(), tramiteinspeccion.getTiligadoprotocolo(),
				tramiteinspeccion.getTiistelematico(), tramiteinspeccion.getTiissir(),
				tramiteinspeccion.getTiissirconnumregentori(), tramiteinspeccion.getTicocmrel(),
				tramiteinspeccion.getTicopg(), tramiteinspeccion.getTiexcluircierre(),
				tramiteinspeccion.getTiarchivar());

		return tramiteinspeccion;
	}

	/**
	 * Inserts a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteinspeccion
	 *            Pagination
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             excepcion
	 */
	public TramiteInspeccion addMasiva(TramiteInspeccion tramiteinspeccion) throws Exception {
		String query = "INSERT INTO TRAMITE_INSPECCION (TICODIGO, TIATCODIGO, TICOTEE, TIFECHAINICIO, TICOMOASIGNADO, TICOMODESIGNADO, TIESTADOTRAMITE) VALUES (?,?,?,?,?,?,?)";

		this.jdbcTemplate.update(query, tramiteinspeccion.getTicodigo(), tramiteinspeccion.getTiatcodigo(),
				tramiteinspeccion.getTicotee(), tramiteinspeccion.getTifechainicio(),
				tramiteinspeccion.getTicomoasignado(), tramiteinspeccion.getTicomodesignado(),
				tramiteinspeccion.getTiestadotramite());

		return tramiteinspeccion;
	}

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteinspeccion
	 *            Pagination
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             excepcion
	 */
	public TramiteInspeccion update(TramiteInspeccion tramiteinspeccion) throws Exception {
		String query = "UPDATE TRAMITE_INSPECCION SET TIATCODIGO=?, TICOTEE=?, TIFECHAFIN=?, TICOMOASIGNADO=?, TICOMOEJECUCION=?, TICOMENTARIO=?, TICOMODESIGNADO=?, TIDOCUMENTACIONREQUERIDA=?, TIDOCUMENTACIONREQUERIDAE=?, TIDECODIGO=?, TIFECHARESOLUCION=?, TIFECHARECURSO=?, TITIPORECURSO=?, TIABOGADO=?, TIMOTIVORECURSO=?, TIESTIMACION=?, TIFECHACIERRE=?, TIDESTINATARIO=?, TIFECHACOMUNICACION=?, TITIPOCOMUNICACION=?, TITIPONOTIFICACION=?, TINOTIFICACIONPORACTA=?, TINUMREGISTROSALIDA=?, TIFECHAREGISTROSALIDA=?, TIACUSERECIBO=?, TIACUSERECIBORECIBIDO=?, TINUMREGISTROENTRADA=?, TIFECHAREGISTROENTRADA=?, TIIDNOTIFICACIONPLATEA=?, TINOMBRETRAMITE=?, TIIDDESTINATARIO=?, TIESTADOTRAMITE=?, TIREQUIEREFIRMA=?, TITEXTOCOMUNICACION=?, TITIPONOTIFICACIONPLATEA=?, TIASUNTOCOMUNICACION=?, TIFECHAENVIOBOPVBOE=?, TIFECHAPUBLICACIONBOPV=?, TIFECHAPUBLICACIONAYTO=?, TISEDE=?, TIFECHALIMITE=?, TICODREM=?, TIENVREM=?, TIIDMAILORIGEN=?, TIMAILORIGEN=?, TIIDMAILDESTINO=?, TIMAILDESTINO=?, TIORIGENALEGACION=?, TIANCODIGO=?, TITIPACTUA=?, TIRESPUESTARECEPCION=?, TIRESUMENRECEPCION=?, TIFECHAREDALERTA=?, TIINCLUSIREDALERTA=?, TIMOTIVOREDALERTA=?, TIJUSTIFICACIONINFRACCION=?, TIFECHAENVLAB=?, TICODMUESTRA=?, TILACODIGO=?, TIDETANA=?, TIFECHARESENS=?, TICODINFENSAY=?, TIRESUDICTAM=?, TICONSTATACION=?, TIFECHADESIN=?, TINUMDESIN=?, TINUMIN=?, TIDESTINODESIN=?, TIDESTRUCCIONINSITU=?, TIEMPRESAGEST=?, TINUMRECUPE=?, TINUMADESTRUIR=?, TINUMADEVOLVER=?, TIFECHAEMIINF=?, TIHORAINICIOEMIINF=?, TIHORAFININF=?, TIDNIINF=?, TINOMBREINF=?, TINORA_PROVINCIA_ID=?, TINOMBRE_PROVINCIA=?, TINORA_MUNICIPIO_ID=?, TINOMBRE_MUNICIPIO=?, TINORA_LOCALIDAD_ID=?, TINOMBRE_LOCALIDAD=?, TINORA_CALLE_ID=?, TINOMBRE_CALLE=?, TINORA_CP_ID=?, TINOMBRE_CP=?, TINORA_PORTAL_ID=?, TINOMBRE_PORTAL=?, TINOMBRE_PISO=?, TIDIRECCION_NOCAPV=?, TIEXTRANJERO=?, TINORA_PAIS_ID=?, TINOMBRE_PAIS=?, TITELINF=?, TIENCONDICIONINF=?, TIINFORME=?, TIVALORACION=?, TIFECHAACEPTACION=?, TIFECHAAMPLI=?, TIMOTIVOAMPLI=?, TIACCODIGO=?, TICOALREL=?, TITELINF2=?, TICOMPDIRECCION=?, TIAPE1INF=?, TIAPE2INF=?, TIFECHAAIP=?, TICOORTRASPASO=?, TICOCR=?, TILIGADOPROTOCOLO=?, TICOCMREL=?, TICOPG=?, TIEXCLUIRCIERRE=?, TIARCHIVAR=?  WHERE TICODIGO=?";

		this.jdbcTemplate.update(query, tramiteinspeccion.getTiatcodigo(), tramiteinspeccion.getTicotee(),
				tramiteinspeccion.getTifechafin(), tramiteinspeccion.getTicomoasignado(),
				tramiteinspeccion.getTicomoejecucion(), tramiteinspeccion.getTicomentario(),
				tramiteinspeccion.getTicomodesignado(), tramiteinspeccion.getTidocumentacionrequerida(),
				tramiteinspeccion.getTidocumentacionrequeridae(), tramiteinspeccion.getTidecodigo(),
				tramiteinspeccion.getTifecharesolucion(), tramiteinspeccion.getTifecharecurso(),
				tramiteinspeccion.getTitiporecurso(), tramiteinspeccion.getTiabogado(),
				tramiteinspeccion.getTimotivorecurso(), tramiteinspeccion.getTiestimacion(),
				tramiteinspeccion.getTifechacierre(), tramiteinspeccion.getTidestinatario(),
				tramiteinspeccion.getTifechacomunicacion(), tramiteinspeccion.getTitipocomunicacion(),
				tramiteinspeccion.getTitiponotificacion(), tramiteinspeccion.getTinotificacionporacta(),
				tramiteinspeccion.getTinumregistrosalida(), tramiteinspeccion.getTifecharegistrosalida(),
				tramiteinspeccion.getTiacuserecibo(), tramiteinspeccion.getTiacusereciborecibido(),
				tramiteinspeccion.getTinumregistroentrada(), tramiteinspeccion.getTifecharegistroentrada(),
				tramiteinspeccion.getTiidnotificacionplatea(), tramiteinspeccion.getTinombretramite(),
				tramiteinspeccion.getTiiddestinatario(), tramiteinspeccion.getTiestadotramite(),
				tramiteinspeccion.getTirequierefirma(), tramiteinspeccion.getTitextocomunicacion(),
				tramiteinspeccion.getTitiponotificacionplatea(), tramiteinspeccion.getTiasuntocomunicacion(),
				tramiteinspeccion.getTifechaenviobopvboe(), tramiteinspeccion.getTifechapublicacionbopv(),
				tramiteinspeccion.getTifechapublicacionayto(), tramiteinspeccion.getTisede(),
				tramiteinspeccion.getTifechalimite(), tramiteinspeccion.getTicodrem(), tramiteinspeccion.getTienvrem(),
				tramiteinspeccion.getTiidmailorigen(), tramiteinspeccion.getTimailorigen(),
				tramiteinspeccion.getTiidmaildestino(), tramiteinspeccion.getTimaildestino(),
				tramiteinspeccion.getTiorigenalegacion(), tramiteinspeccion.getTiancodigo(),
				tramiteinspeccion.getTitipactua(), tramiteinspeccion.getTirespuestarecepcion(),
				tramiteinspeccion.getTiresumenrecepcion(), tramiteinspeccion.getTifecharedalerta(),
				tramiteinspeccion.getTiinclusiredalerta(), tramiteinspeccion.getTimotivoredalerta(),
				tramiteinspeccion.getTijustificacioninfraccion(), tramiteinspeccion.getTifechaenvlab(),
				tramiteinspeccion.getTicodmuestra(), tramiteinspeccion.getTilacodigo(), tramiteinspeccion.getTidetana(),
				tramiteinspeccion.getTifecharesens(), tramiteinspeccion.getTicodinfensay(),
				tramiteinspeccion.getTiresudictam(), tramiteinspeccion.getTiconstatacion(),
				tramiteinspeccion.getTifechadesin(), tramiteinspeccion.getTinumdesin(), tramiteinspeccion.getTinumin(),
				tramiteinspeccion.getTidestinodesin(), tramiteinspeccion.getTidestruccioninsitu(),
				tramiteinspeccion.getTiempresagest(), tramiteinspeccion.getTinumrecupe(),
				tramiteinspeccion.getTinumadestruir(), tramiteinspeccion.getTinumadevolver(),
				tramiteinspeccion.getTifechaemiinf(), tramiteinspeccion.getTihorainicioemiinf(),
				tramiteinspeccion.getTihorafininf(), tramiteinspeccion.getTidniinf(),
				tramiteinspeccion.getTinombreinf(), tramiteinspeccion.getTinoraProvinciaId(),
				tramiteinspeccion.getTinombreProvincia(), tramiteinspeccion.getTinoraMunicipioId(),
				tramiteinspeccion.getTinombreMunicipio(), tramiteinspeccion.getTinoraLocalidadId(),
				tramiteinspeccion.getTinombreLocalidad(), tramiteinspeccion.getTinoraCalleId(),
				tramiteinspeccion.getTinombreCalle(), tramiteinspeccion.getTinoraCpId(),
				tramiteinspeccion.getTinombreCp(), tramiteinspeccion.getTinoraPortalId(),
				tramiteinspeccion.getTinombrePortal(), tramiteinspeccion.getTinombrePiso(),
				tramiteinspeccion.getTidireccionNocapv(), tramiteinspeccion.getTiextranjero(),
				tramiteinspeccion.getTinoraPaisId(), tramiteinspeccion.getTinombrePais(),
				tramiteinspeccion.getTitelinf(), tramiteinspeccion.getTiencondicioninf(),
				tramiteinspeccion.getTiinforme(), tramiteinspeccion.getTivaloracion(),
				tramiteinspeccion.getTifechaaceptacion(), tramiteinspeccion.getTifechaampli(),
				tramiteinspeccion.getTimotivoampli(), tramiteinspeccion.getTiaccodigo(),
				tramiteinspeccion.getTicoalrel(), tramiteinspeccion.getTitelinf2(),
				tramiteinspeccion.getTicompdireccion(), tramiteinspeccion.getTiape1inf(),
				tramiteinspeccion.getTiape2inf(), tramiteinspeccion.getTifechaaip(),
				tramiteinspeccion.getTicoortraspaso(), tramiteinspeccion.getTicocr(),
				tramiteinspeccion.getTiligadoprotocolo(), tramiteinspeccion.getTicocmrel(),
				tramiteinspeccion.getTicopg(), tramiteinspeccion.getTiexcluircierre(),
				tramiteinspeccion.getTiarchivar(), tramiteinspeccion.getTicodigo());
		return tramiteinspeccion;
	}

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	public TramiteInspeccion updateFechaInicio(TramiteInspeccion tramiteInspeccion) {
		String query = "UPDATE TRAMITE_INSPECCION SET TIFECHAINICIO=? WHERE TICODIGO=?";

		this.jdbcTemplate.update(query, tramiteInspeccion.getTifechainicio(), tramiteInspeccion.getTicodigo());
		return tramiteInspeccion;
	}

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	public TramiteInspeccion updateFechaLimite(TramiteInspeccion tramiteInspeccion) {
		String query = "UPDATE TRAMITE_INSPECCION SET TIFECHALIMITE=? WHERE TICODIGO=?";

		this.jdbcTemplate.update(query, tramiteInspeccion.getTifechalimite(), tramiteInspeccion.getTicodigo());
		return tramiteInspeccion;
	}

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	public TramiteInspeccion updateInstructor(TramiteInspeccion tramiteInspeccion) {
		String query = "UPDATE TRAMITE_INSPECCION SET TICOMOASIGNADO=? WHERE TICODIGO=?";

		this.jdbcTemplate.update(query, tramiteInspeccion.getTicomoasignado(), tramiteInspeccion.getTicodigo());
		return tramiteInspeccion;
	}

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	public TramiteInspeccion updateReabrirTramite(TramiteInspeccion tramiteInspeccion) {
		String query = "UPDATE TRAMITE_INSPECCION SET TIESTADOTRAMITE=?, TIFECHAFIN=null, TICOMOEJECUCION=null WHERE TICODIGO=?";

		this.jdbcTemplate.update(query, tramiteInspeccion.getTiestadotramite(), tramiteInspeccion.getTicodigo());
		return tramiteInspeccion;
	}

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	public TramiteInspeccion updateTramitarTramite(TramiteInspeccion tramiteInspeccion) {
		String query = "UPDATE TRAMITE_INSPECCION SET TIESTADOTRAMITE=?, TIFECHAFIN=?, TICOMOEJECUCION=? WHERE TICODIGO=?";

		this.jdbcTemplate.update(query, tramiteInspeccion.getTiestadotramite(), tramiteInspeccion.getTifechafin(),
				tramiteInspeccion.getTicomoejecucion(), tramiteInspeccion.getTicodigo());
		return tramiteInspeccion;
	}

	/**
	 * Counts rows in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTramiteRegistroDecisionTramitadoCount(TramiteInspeccionDetalle tramiteInspeccionDetalle) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.TICOTEE= t2.TRCODIGO(+) AND t1.TICOMOASIGNADO= t3ASIGNADO.MOCODIGO(+) AND t1.TICOMOEJECUCION= t3EJECUCION.MOCODIGO(+) AND t1.TIATCODIGO= t4.ATCODIGO(+) AND t2.FCODIGO = t5.FCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM TRAMITE_INSPECCION t1 ,TRAMITE t2 ,CENSO_MONITOR t3ASIGNADO,CENSO_MONITOR t3EJECUCION ,ACTUACION t4, FASE t5 ");

		where.append(" AND t4.ATCODIGO = ?");
		params.add(tramiteInspeccionDetalle.getAtcodigo());

		where.append(" AND t1.TICOTEE = ?");
		params.add(Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_DECISION);

		where.append(" AND t1.TIFECHAFIN IS NOT NULL ");

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTramiteResultadoEnsayosNoTramitadoCount(TramiteInspeccionDetalle tramiteInspeccionDetalle) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.TICOTEE= t2.TRCODIGO(+) AND t1.TICOMOASIGNADO= t3ASIGNADO.MOCODIGO(+) AND t1.TICOMOEJECUCION= t3EJECUCION.MOCODIGO(+) AND t1.TIATCODIGO= t4.ATCODIGO(+) AND t2.FCODIGO = t5.FCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM TRAMITE_INSPECCION t1 ,TRAMITE t2 ,CENSO_MONITOR t3ASIGNADO,CENSO_MONITOR t3EJECUCION ,ACTUACION t4, FASE t5 ");

		where.append(" AND t4.ATCODIGO = ?");
		params.add(tramiteInspeccionDetalle.getAtcodigo());

		where.append(" AND t1.TICOTEE = ?");
		params.add(Y41bConstantes.TRAMITE_INSPECCIONES_RESULTADO_ENSAYOS);

		where.append(" AND t1.TIFECHAFIN IS NULL ");

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTramiteEmisionInformeProtocoloTramitadoCount(TramiteInspeccionDetalle tramiteInspeccionDetalle) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.TICOTEE= t2.TRCODIGO(+) AND t1.TICOMOASIGNADO= t3ASIGNADO.MOCODIGO(+) AND t1.TICOMOEJECUCION= t3EJECUCION.MOCODIGO(+) AND t1.TIATCODIGO= t4.ATCODIGO(+) AND t2.FCODIGO = t5.FCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM TRAMITE_INSPECCION t1 ,TRAMITE t2 ,CENSO_MONITOR t3ASIGNADO,CENSO_MONITOR t3EJECUCION ,ACTUACION t4, FASE t5 ");

		where.append(" AND t4.ATCODIGO = ?");
		params.add(tramiteInspeccionDetalle.getAtcodigo());

		where.append(" AND t1.TICOTEE = ?");
		params.add(Y41bConstantes.TRAMITE_INSPECCIONES_EMISION_DE_INFORME);

		where.append(" AND t1.TILIGADOPROTOCOLO = ?");
		params.add(Y41bConstantes.VALOR_SI);

		where.append(" AND t1.TIFECHAFIN IS NOT NULL ");

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Count of rows in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public Long findAllTramiteInspeccionCount(TramiteInspeccionDetalle tramiteInspeccionDetalle) {
		StringBuffer where = new StringBuffer(Y41bConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.TICOTEE= t2.TRCODIGO(+) AND t1.TICOMOASIGNADO= t3ASIGNADO.MOCODIGO(+) AND t1.TICOMOEJECUCION= t3EJECUCION.MOCODIGO(+) AND t1.TIATCODIGO= t4.ATCODIGO(+) AND t2.FCODIGO = t5.FCODIGO(+) AND t1.TIFCODIGO = t6.FCODIGO(+)	AND t1.TICODIGORELACIONADO = t7.EHCODIGO(+) AND t1.TIDECODIGO= t8.DECODIGO(+) AND t1.TIIDDESTINATARIO=t9.IDINTERVINIENTE(+) ");

		StringBuffer query = new StringBuffer("SELECT count(8) "
				+ "FROM TRAMITE_INSPECCION t1 ,TRAMITE t2 ,CENSO_MONITOR t3ASIGNADO,CENSO_MONITOR t3EJECUCION ,ACTUACION t4, FASE t5, FASE t6, ENVIOS_POR_REMESA t7, DECISION t8, INTERVINIENTES t9  ");

		if (tramiteInspeccionDetalle != null && tramiteInspeccionDetalle.getAtcodigo() != null) {
			where.append(" AND t4.ATCODIGO = ?");
			params.add(tramiteInspeccionDetalle.getAtcodigo());
		}

		if (tramiteInspeccionDetalle != null && tramiteInspeccionDetalle.getTrcodigo() != null) {
			where.append(" AND t1.TICOTEE = ?");
			params.add(tramiteInspeccionDetalle.getTrcodigo());
		}

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a List of rows in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TramiteInspeccionDetalle> findAllTramiteInspeccion(TramiteInspeccionDetalle tramiteInspeccionDetalle,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(Y41bConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.TICOTEE= t2.TRCODIGO(+) AND t1.TICOMOASIGNADO= t3ASIGNADO.MOCODIGO(+) AND t1.TICOMOEJECUCION= t3EJECUCION.MOCODIGO(+) AND t1.TIATCODIGO= t4.ATCODIGO(+) AND t2.FCODIGO = t5.FCODIGO(+) AND t1.TIFCODIGO = t6.FCODIGO(+)	AND t1.TICODIGORELACIONADO = t7.EHCODIGO(+) AND t1.TIDECODIGO= t8.DECODIGO(+) AND t1.TIIDDESTINATARIO=t9.IDINTERVINIENTE(+) AND t1.TIACCODIGO = t10.ANCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT t1.TICODIGO TICODIGO,t1.tiatcodigo, t4.ATCODIGO ATCODIGO, DECODE(t6.FCODIGO,null,t5.FCODIGO,t6.FCODIGO)  FCODIGO, DECODE(t6.FNOMBRE,null,t5.FNOMBRE,t6.FNOMBRE) FNOMBRE, "
						+ "DECODE(t6.FNOMBREE,null,t5.FNOMBREE,t6.FNOMBREE) FNOMBREE, t1.TICOTEE TRCODIGO, t2.TRNOMBRE TRNOMBRE, "
						+ "t2.TRNOMBREE TRNOMBREE, t1.TIFECHAINICIO TIFECHAINICIO, t1.TICOMOASIGNADO TICOMOASIGNADO, t1.TICOMOEJECUCION TICOMOEJECUCION, "
						+ "t1.TIFECHAFIN TIFECHAFIN, DECODE(t1.TIFECHAFIN,null,t3ASIGNADO.MOCODIGO,t3EJECUCION.MOCODIGO) MOCODIGO, DECODE(t1.TIFECHAFIN,null,t3ASIGNADO.MONOMBRE,t3EJECUCION.MONOMBRE) MONOMBRE, "
						+ "t1.TIESTADOTRAMITE TIESTADOTRAMITE, t1.TIACUSERECIBORECIBIDO TIACUSERECIBORECIBIDO, "
						+ "t1.TIFECHAENVIOBOPVBOE TIFECHAENVIOBOPVBOE, t7.ENVCDES_SIT_CORREOS_ES ENVCDESSITCORREOSES, t7.ENVCDES_SIT_CORREOS_EU ENVCDESSITCORREOSEU, t1.TIPROCEEDINGSIDPLATEA TIPROCEEDINGSIDPLATEA, "
						+ "t8.DECODIGO DECODIGO, t8.DENOMBRE DENOMBRE, t8.DENOMBREE DENOMBREE, DECODE(t1.TIORIGENALEGACION,null,t1.TIDESTINATARIO,t1.TIORIGENALEGACION) ORIGENDESTINO, t1.TIIDDESTINATARIO, "
						+ "t1.TIACUSEREINTENTADO TIACUSEREINTENTADO, t1.TINOMBRETRAMITE TINOMBRETRAMITE, t9.NOMBRE || ' ' || t9.APELLIDO1 || ' ' || t9.APELLIDO2 NOMDESTINATARIO, t9.TIPO_INTERVINIENTE TIPOINTERVINIENTE, t1.TIACCODIGO TIACCODIGO, t10.ANCODAC ANCODAC, t1.TILIGADOPROTOCOLO TILIGADOPROTOCOLO, t1.TIISTELEMATICO TIISTELEMATICO, t1.TIISSIR TIISSIR,t1.TIISSIRCONNUMREGENTORI TIISSIRCONNUMREGENTORI "
						+ "FROM TRAMITE_INSPECCION t1 ,TRAMITE t2 ,CENSO_MONITOR t3ASIGNADO,CENSO_MONITOR t3EJECUCION ,ACTUACION t4, FASE t5, FASE t6, ENVIOS_POR_REMESA t7, DECISION t8, INTERVINIENTES t9, ACTA_NUEVA t10 ");

		if (tramiteInspeccionDetalle != null && tramiteInspeccionDetalle.getAtcodigo() != null) {
			where.append(" AND t4.ATCODIGO = ?");
			params.add(tramiteInspeccionDetalle.getAtcodigo());
		}

		if (tramiteInspeccionDetalle != null && tramiteInspeccionDetalle.getTicotee() != null) {
			where.append(" AND t1.TICOTEE = ?");
			params.add(tramiteInspeccionDetalle.getTicotee());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(Y41bConstantes.NUM_3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<TramiteInspeccionDetalle>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<TramiteInspeccionDetalle>() {
					public TramiteInspeccionDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
						tramiteInspeccionDetalle.setTicodigo(resultSet.getString("TICODIGO"));
						tramiteInspeccionDetalle.setAtcodigo(resultSet.getString("TIATCODIGO"));
						tramiteInspeccionDetalle.setFcodigo(resultSet.getString("FCODIGO"));
						tramiteInspeccionDetalle.setFnombre(resultSet.getString("FNOMBRE"));
						tramiteInspeccionDetalle.setFnombree(resultSet.getString("FNOMBREE"));
						tramiteInspeccionDetalle.setTrcodigo(resultSet.getString("TRCODIGO"));
						tramiteInspeccionDetalle.setTrnombre(resultSet.getString("TRNOMBRE"));
						tramiteInspeccionDetalle.setTrnombree(resultSet.getString("TRNOMBREE"));
						tramiteInspeccionDetalle.setTifechainicio(resultSet.getTimestamp("TIFECHAINICIO"));
						tramiteInspeccionDetalle.setTifechafin(resultSet.getTimestamp("TIFECHAFIN"));
						tramiteInspeccionDetalle.setMocodigo(resultSet.getString("MOCODIGO"));
						tramiteInspeccionDetalle.setMonombre(resultSet.getString("MONOMBRE"));
						tramiteInspeccionDetalle.setOrigenDestino(resultSet.getString("ORIGENDESTINO"));
						tramiteInspeccionDetalle.setIdDestinatario(resultSet.getString("TIIDDESTINATARIO"));
						tramiteInspeccionDetalle.setNomDestinatario(resultSet.getString("NOMDESTINATARIO"));
						tramiteInspeccionDetalle.setTiestadotramite(resultSet.getString("TIESTADOTRAMITE"));
						tramiteInspeccionDetalle.setTiacusereciborecibido(resultSet.getString("TIACUSERECIBORECIBIDO"));
						tramiteInspeccionDetalle.setTinombretramite(resultSet.getString("TINOMBRETRAMITE"));
						tramiteInspeccionDetalle.setDecodigo(resultSet.getString("DECODIGO"));
						tramiteInspeccionDetalle.setDenombre(resultSet.getString("DENOMBRE"));
						tramiteInspeccionDetalle.setDenombree(resultSet.getString("DENOMBREE"));
						tramiteInspeccionDetalle.setTiaccodigo(resultSet.getString("TIACCODIGO"));
						tramiteInspeccionDetalle.setAncodac(resultSet.getString("ANCODAC"));

						tramiteInspeccionDetalle.setTipoInterviniente(resultSet.getString("TIPOINTERVINIENTE"));

						tramiteInspeccionDetalle.setTiacusereintentado(resultSet.getString("TIACUSEREINTENTADO"));

						tramiteInspeccionDetalle.setTiligadoprotocolo(resultSet.getString("TILIGADOPROTOCOLO"));

						tramiteInspeccionDetalle.setTiistelematico(resultSet.getString("TIISTELEMATICO"));
						tramiteInspeccionDetalle.setTiissir(resultSet.getString("TIISSIR"));
						tramiteInspeccionDetalle
								.setTiissirconnumregentori(resultSet.getString("TIISSIRCONNUMREGENTORI"));

						tramiteInspeccionDetalle.setTiproceedingsidplatea(resultSet.getString("TIPROCEEDINGSIDPLATEA"));

						return tramiteInspeccionDetalle;
					}
				}, params.toArray());
	}

	/**
	 * Finds a List of rows in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TramiteInspeccionDetalle> findAllTramiteInspeccionPendientes(
			TramiteInspeccionDetalle tramiteInspeccionDetalle, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.TICOTEE= t2.TRCODIGO(+) AND t1.TICOMOASIGNADO= t3ASIGNADO.MOCODIGO(+) AND t1.TICOMOEJECUCION= t3EJECUCION.MOCODIGO(+) AND t1.TIATCODIGO= t4.ATCODIGO(+) AND t2.FCODIGO = t5.FCODIGO(+)	");

		StringBuffer query = new StringBuffer(
				"SELECT t1.TICODIGO TICODIGO,t4.ATCODIGO ATCODIGO, t5.FCODIGO FCODIGO, t5.FNOMBRE FNOMBRE, t5.FNOMBREE FNOMBREE, t2.TRCODIGO TRCODIGO, DECODE(t2.TRCODIGO, 'IN25',t1.TINOMBRETRAMITE,t2.TRNOMBRE) TRNOMBRE, DECODE(t2.TRCODIGO, 'IN25',t1.TINOMBRETRAMITE,t2.TRNOMBREE) TRNOMBREE, t1.TIFECHAINICIO TIFECHAINICIO, t1.TIFECHAFIN TIFECHAFIN, t3EJECUCION.MOCODIGO MOCODIGO,t3EJECUCION.MONOMBRE MONOMBRE, t1.TIESTADOTRAMITE TIESTADOTRAMITE "
						+ "FROM TRAMITE_INSPECCION t1 ,TRAMITE t2 ,CENSO_MONITOR t3ASIGNADO,CENSO_MONITOR t3EJECUCION ,ACTUACION t4, FASE t5 ");

		if (tramiteInspeccionDetalle != null && tramiteInspeccionDetalle.getAtcodigo() != null) {
			where.append(" AND t4.ATCODIGO = ?");
			params.add(tramiteInspeccionDetalle.getAtcodigo());
		}

		where.append(" AND t1.TIFECHAINICIO IS NOT NULL AND t1.TIFECHAFIN IS NULL ");

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<TramiteInspeccionDetalle>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<TramiteInspeccionDetalle>() {
					public TramiteInspeccionDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new TramiteInspeccionDetalle(resultSet.getString("TICODIGO"),
								resultSet.getString("ATCODIGO"), resultSet.getString("FCODIGO"),
								resultSet.getString("FNOMBRE"), resultSet.getString("FNOMBREE"),
								resultSet.getString("TRCODIGO"), resultSet.getString("TRNOMBRE"),
								resultSet.getString("TRNOMBREE"), resultSet.getDate("TIFECHAINICIO"),
								resultSet.getDate("TIFECHAFIN"), resultSet.getString("MOCODIGO"),
								resultSet.getString("MONOMBRE"), resultSet.getString("TIESTADOTRAMITE"));
					}
				}, params.toArray());
	}

	/**
	 * Finds a List of rows in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TramiteInspeccion> findAllTramiteInspeccionATramitarautomaticamente(TramiteInspeccion tramiteInspeccion,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND TIATCODIGO = ? AND TIESTADOTRAMITE <> ? AND TICOTEE IN (? , ? , ?) AND TIFECHAINICIO < ?");

		StringBuffer query = new StringBuffer("SELECT t1.TICODIGO TICODIGO " + "FROM TRAMITE_INSPECCION t1 ");

		params.add(tramiteInspeccion.getTiatcodigo());

		params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		params.add(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_REQUERIMIENTO);
		params.add(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_ALEGACIONES);
		params.add(Y41bConstantes.TRAMITE_INSPECCIONES_GENERICO);

		params.add(tramiteInspeccion.getTifechafin());

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<TramiteInspeccion>) this.jdbcTemplate.query(query.toString(), new RowMapper<TramiteInspeccion>() {
			public TramiteInspeccion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new TramiteInspeccion(resultSet.getString("TICODIGO"));
			}
		}, params.toArray());
	}

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @return TramiteInspeccionDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteInspeccionDetalle findUltimaFase(TramiteInspeccionDetalle tramiteInspeccionDetalle) {

		String query = "select FNOMBRE, FNOMBREE FROM(" + "SELECT tr3.FNOMBRE FNOMBRE, tr3.FNOMBREE FNOMBREE "
				+ "FROM TRAMITE_INSPECCION tr1, TRAMITE tr2, FASE tr3 "
				// TODO: Hacer la query correcta que esta copiada de
				// TramiteInspeccionDao.
				+ "WHERE tr1.TICOTEE = tr2.TRCODIGO AND tr2.FCODIGO = tr3.FCODIGO(+) AND tr2.FCODIGO IS NOT NULL AND tr1.TIATCODIGO=? AND TIFECHAINICIO <= (SELECT TIFECHAINICIO FROM TRAMITE_INSPECCION tr2 WHERE tr2.TICODIGO=? ) "
				+ "ORDER BY EHFECHA DESC) WHERE ROWNUM=1 ";
		return (TramiteInspeccionDetalle) this.jdbcTemplate.queryForObject(query,
				new RowMapper<TramiteInspeccionDetalle>() {
					public TramiteInspeccionDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
						tramiteInspeccionDetalle.setFnombre(resultSet.getString("FNOMBRE"));
						tramiteInspeccionDetalle.setFnombree(resultSet.getString("FNOMBREE"));
						return tramiteInspeccionDetalle;
					}
				}, tramiteInspeccionDetalle.getAtcodigo(), tramiteInspeccionDetalle.getTicodigo());
	}

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteinspeccion
	 *            Pagination
	 * @return TramiteInspeccion
	 */
	@Transactional(readOnly = true)
	public TramiteInspeccion find(TramiteInspeccion tramiteinspeccion) {
		String query = "SELECT t1.TICODIGO TICODIGO, t1.TIATCODIGO TIATCODIGO, t1.TIACCODIGO TIACCODIGO, t1.TICOTEE TICOTEE, t1.TIFECHAINICIO TIFECHAINICIO, t1.TIFECHAFIN TIFECHAFIN, t1.TICOMOASIGNADO TICOMOASIGNADO, t1.TICOMOEJECUCION TICOMOEJECUCION, t1.TICOMENTARIO TICOMENTARIO, t1.TICOMODESIGNADO TICOMODESIGNADO, t1.TICOALREL TICOALREL, t1.TIDOCUMENTACIONREQUERIDA TIDOCUMENTACIONREQUERIDA, t1.TIDOCUMENTACIONREQUERIDAE TIDOCUMENTACIONREQUERIDAE, t1.TIDECODIGO TIDECODIGO, t1.TIFECHARESOLUCION TIFECHARESOLUCION, t1.TIFECHARECURSO TIFECHARECURSO, t1.TITIPORECURSO TITIPORECURSO, t1.TIABOGADO TIABOGADO, t1.TIMOTIVORECURSO TIMOTIVORECURSO, t1.TIESTIMACION TIESTIMACION, t1.TIFECHACIERRE TIFECHACIERRE, t1.TIDESTINATARIO TIDESTINATARIO, t1.TIFECHACOMUNICACION TIFECHACOMUNICACION, t1.TITIPOCOMUNICACION TITIPOCOMUNICACION, t1.TITIPONOTIFICACION TITIPONOTIFICACION, t1.TINOTIFICACIONPORACTA TINOTIFICACIONPORACTA, t1.TINUMREGISTROSALIDA TINUMREGISTROSALIDA, t1.TIFECHAREGISTROSALIDA TIFECHAREGISTROSALIDA, t1.TIACUSERECIBO TIACUSERECIBO, t1.TIACUSERECIBORECIBIDO TIACUSERECIBORECIBIDO, t1.TINUMREGISTROENTRADA TINUMREGISTROENTRADA, t1.TIFECHAREGISTROENTRADA TIFECHAREGISTROENTRADA, t1.TIIDNOTIFICACIONPLATEA TIIDNOTIFICACIONPLATEA, t1.TINOMBRETRAMITE TINOMBRETRAMITE, t1.TIIDDESTINATARIO TIIDDESTINATARIO, t1.TIESTADOTRAMITE TIESTADOTRAMITE, t1.TIREQUIEREFIRMA TIREQUIEREFIRMA, t1.TITEXTOCOMUNICACION TITEXTOCOMUNICACION, t1.TITIPONOTIFICACIONPLATEA TITIPONOTIFICACIONPLATEA, t1.TIIDESPERAPLATEA TIIDESPERAPLATEA, t1.TIMATARESPERA TIMATARESPERA, t1.TIASUNTOCOMUNICACION TIASUNTOCOMUNICACION, t1.TIFECHAENVIOBOPVBOE TIFECHAENVIOBOPVBOE, t1.TIFECHAPUBLICACIONBOPV TIFECHAPUBLICACIONBOPV, t1.TIFECHAPUBLICACIONAYTO TIFECHAPUBLICACIONAYTO, t1.TISEDE TISEDE, t1.TIFECHALIMITE TIFECHALIMITE, t1.TICODREM TICODREM, t1.TIENVREM TIENVREM, t1.TIFCODIGO TIFCODIGO, t1.TIIDMAILORIGEN TIIDMAILORIGEN, t1.TIMAILORIGEN TIMAILORIGEN, t1.TIIDMAILDESTINO TIIDMAILDESTINO, t1.TIMAILDESTINO TIMAILDESTINO, t1.TIPROCEEDINGSIDPLATEA TIPROCEEDINGSIDPLATEA, t1.TIACUSEREINTENTADO TIACUSEREINTENTADO, t1.TIAUTOMATICO TIAUTOMATICO, t1.TIORIGENALEGACION TIORIGENALEGACION, t1.TIANCODIGO TIANCODIGO, t1.TITIPACTUA TITIPACTUA, t1.TIRESPUESTARECEPCION TIRESPUESTARECEPCION, t1.TIRESUMENRECEPCION TIRESUMENRECEPCION, t1.TIFECHAREDALERTA TIFECHAREDALERTA, t1.TIINCLUSIREDALERTA TIINCLUSIREDALERTA, t1.TIMOTIVOREDALERTA TIMOTIVOREDALERTA, t1.TIJUSTIFICACIONINFRACCION TIJUSTIFICACIONINFRACCION, t1.TIFECHAENVLAB TIFECHAENVLAB, t1.TICODMUESTRA TICODMUESTRA, t1.TILACODIGO TILACODIGO, t1.TIDETANA TIDETANA, t1.TIFECHARESENS TIFECHARESENS, t1.TICODINFENSAY TICODINFENSAY, t1.TIRESUDICTAM TIRESUDICTAM, t1.TICONSTATACION TICONSTATACION, t1.TIFECHADESIN TIFECHADESIN, t1.TINUMDESIN TINUMDESIN, t1.TINUMIN TINUMIN, t1.TIDESTINODESIN TIDESTINODESIN, t1.TIDESTRUCCIONINSITU TIDESTRUCCIONINSITU, t1.TIEMPRESAGEST TIEMPRESAGEST, t1.TINUMRECUPE TINUMRECUPE, t1.TINUMADESTRUIR TINUMADESTRUIR, t1.TINUMADEVOLVER TINUMADEVOLVER, t1.TIFECHAEMIINF TIFECHAEMIINF, t1.TIHORAINICIOEMIINF TIHORAINICIOEMIINF, t1.TIHORAFININF TIHORAFININF, t1.TIDNIINF TIDNIINF, t1.TINOMBREINF TINOMBREINF, t1.TINORA_PROVINCIA_ID TINORAPROVINCIAID, t1.TINOMBRE_PROVINCIA TINOMBREPROVINCIA, t1.TINORA_MUNICIPIO_ID TINORAMUNICIPIOID, t1.TINOMBRE_MUNICIPIO TINOMBREMUNICIPIO, t1.TINORA_LOCALIDAD_ID TINORALOCALIDADID, t1.TINOMBRE_LOCALIDAD TINOMBRELOCALIDAD, t1.TINORA_CALLE_ID TINORACALLEID, t1.TINOMBRE_CALLE TINOMBRECALLE, t1.TINORA_CP_ID TINORACPID, t1.TINOMBRE_CP TINOMBRECP, t1.TINORA_PORTAL_ID TINORAPORTALID, t1.TINOMBRE_PORTAL TINOMBREPORTAL, t1.TINOMBRE_PISO TINOMBREPISO, t1.TIDIRECCION_NOCAPV TIDIRECCIONNOCAPV, t1.TIEXTRANJERO TIEXTRANJERO, t1.TINORA_PAIS_ID TINORAPAISID, t1.TINOMBRE_PAIS TINOMBREPAIS, t1.TITELINF TITELINF, t1.TIENCONDICIONINF TIENCONDICIONINF, t1.TIINFORME TIINFORME, t1.TIVALORACION TIVALORACION, t1.TIFECHAACEPTACION TIFECHAACEPTACION, t1.TIFECHAAMPLI TIFECHAAMPLI, t1.TIMOTIVOAMPLI TIMOTIVOAMPLI, t1.TINUMIN TINUMIN, t1.TIDIRECCION_NOCAPV TIDIRECCIONNOCAPV, t1.TIEXTRANJERO TIEXTRANJERO, t1.TINORA_PAIS_ID TINORAPAISID, t1.TINOMBRE_PAIS TINOMBREPAIS, t1.TITELINF TITELINF, t1.TIENCONDICIONINF TIENCONDICIONINF, t1.TIINFORME TIINFORME, t1.TIVALORACION TIVALORACION, t1.TIFECHAACEPTACION TIFECHAACEPTACION, t1.TIFECHAAMPLI TIFECHAAMPLI, t1.TIMOTIVOAMPLI TIMOTIVOAMPLI, t1.TICOALREL TICOALREL, t1.TICOORTRASPASO TICOORTRASPASO, t1.TITELINF2 TITELINF2, t1.TICOMPDIRECCION TICOMPDIRECCION, t1.TIAPE1INF TIAPE1INF, t1.TIAPE2INF TIAPE2INF, t1.TIFECHAAIP TIFECHAAIP, t1.TIFECALTA TIFECALTA, t1.TIFECMODIF TIFECMODIF, t1.TICOCR TICOCR, t1.TILIGADOPROTOCOLO TILIGADOPROTOCOLO, t1.TIISTELEMATICO TIISTELEMATICO, t1.TIISSIR TIISSIR,t1.TIISSIRCONNUMREGENTORI TIISSIRCONNUMREGENTORI, t1.TICOCMREL TICOCMREL, t1.TICOPG TICOPG, t1.TIEXCLUIRCIERRE TIEXCLUIRCIERRE, t1.TIARCHIVAR TIARCHIVAR, t2.TICODIGO TRAMINSTICODIGO, t2.TIATCODIGO TRAMINSTIATCODIGO, t2.TIACCODIGO TRAMINSTIACCODIGO, t2.TICOTEE TRAMINSTICOTEE, t2.TIFECHAINICIO TRAMINSTIFECHAINICIO, t2.TIFECHAFIN TRAMINSTIFECHAFIN, t2.TICOMOASIGNADO TRAMINSTICOMOASIGNADO, t2.TICOMOEJECUCION TRAMINSTICOMOEJECUCION, t2.TICOMENTARIO TRAMINSTICOMENTARIO, t2.TICOMODESIGNADO TRAMINSTICOMODESIGNADO, t2.TIDOCUMENTACIONREQUERIDA TRAMINSTIDOCUREQUERIDA, t2.TIDOCUMENTACIONREQUERIDAE TRAMINSTIDOCUREQUERIDAE, t2.TIDECODIGO TRAMINSTIDECODIGO, t2.TIFECHARESOLUCION TRAMINSTIFECHARESOLUCION, t2.TIFECHARECURSO TRAMINSTIFECHARECURSO, t2.TITIPORECURSO TRAMINSTITIPORECURSO, t2.TIABOGADO TRAMINSTIABOGADO, t2.TIMOTIVORECURSO TRAMINSTIMOTIVORECURSO, t2.TIESTIMACION TRAMINSTIESTIMACION, t2.TIFECHACIERRE TRAMINSTIFECHACIERRE, t2.TIDESTINATARIO TRAMINSTIDESTINATARIO, t2.TIFECHACOMUNICACION TRAMINSTIFECHACOMUNICACION, t2.TITIPOCOMUNICACION TRAMINSTITIPOCOMUNICACION, t2.TITIPONOTIFICACION TRAMINSTITIPONOTIFICACION, t2.TINOTIFICACIONPORACTA TRAMINSTINOTIFICACIONPORACTA, t2.TINUMREGISTROSALIDA TRAMINSTINUMREGISTROSALIDA, t2.TIFECHAREGISTROSALIDA TRAMINSTIFECHAREGSALIDA, t2.TIACUSERECIBO TRAMINSTIACUSERECIBO, t2.TIACUSERECIBORECIBIDO TRAMINSTIACUSERECRECIBIDO, t2.TINUMREGISTROENTRADA TRAMINSTINUMREGISTROENTRADA, t2.TIFECHAREGISTROENTRADA TRAMINSTIFECHAREGENTRADA, t2.TIIDNOTIFICACIONPLATEA TRAMINSTIIDNOTIFPLATEA, t2.TINOMBRETRAMITE TRAMINSTINOMBRETRAMITE, t2.TIIDDESTINATARIO TRAMINSTIIDDESTINATARIO, t2.TIESTADOTRAMITE TRAMINSTIESTADOTRAMITE, t2.TIREQUIEREFIRMA TRAMINSTIREQUIEREFIRMA, t2.TITEXTOCOMUNICACION TRAMINSTITEXTOCOMUNICACION, t2.TITIPONOTIFICACIONPLATEA TRAMINSTITIPONOTIFPLATEA, t2.TIIDESPERAPLATEA TRAMINSTIIDESPERAPLATEA, t2.TIMATARESPERA TRAMINSTIMATARESPERA, t2.TIASUNTOCOMUNICACION TRAMINSTIASUNTOCOMUNICACION, t2.TIFECHAENVIOBOPVBOE TRAMINSTIFECHAENVIOBOPVBOE, t2.TIFECHAPUBLICACIONBOPV TRAMINSTIFECHAPUBBOPV, t2.TIFECHAPUBLICACIONAYTO TRAMINSTIFECHAPUBAYTO, t2.TISEDE TRAMINSTISEDE, t2.TIFECHALIMITE TRAMINSTIFECHALIMITE, t2.TICODREM TRAMINSTICODREM, t2.TIENVREM TRAMINSTIENVREM, t2.TIFCODIGO TRAMINSTIFCODIGO, t2.TIIDMAILORIGEN TRAMINSTIIDMAILORIGEN, t2.TIMAILORIGEN TRAMINSTIMAILORIGEN, t2.TIIDMAILDESTINO TRAMINSTIIDMAILDESTINO, t2.TIMAILDESTINO TRAMINSTIMAILDESTINO, t2.TIPROCEEDINGSIDPLATEA TRAMINSTIPROCEEDINGSIDPLATEA, t2.TIACUSEREINTENTADO TRAMINSTIACUSEREINTENTADO, t2.TIAUTOMATICO TRAMINSTIAUTOMATICO, t2.TIORIGENALEGACION TRAMINSTIORIGENALEGACION, t2.TIANCODIGO TRAMINSTIANCODIGO, t2.TITIPACTUA TRAMINSTITIPACTUA, t2.TIRESPUESTARECEPCION TRAMINSTIRESPUESTARECEPCION, t2.TIRESUMENRECEPCION TRAMINSTIRESUMENRECEPCION, t2.TIFECHAREDALERTA TRAMINSTIFECHAREDALERTA, t2.TIINCLUSIREDALERTA TRAMINSTIINCLUSIREDALERTA, t2.TIMOTIVOREDALERTA TRAMINSTIMOTIVOREDALERTA, t2.TIJUSTIFICACIONINFRACCION TRAMINSTIJUSTIFINFRACCION, t2.TIFECHAENVLAB TRAMINSTIFECHAENVLAB, t2.TICODMUESTRA TRAMINSTICODMUESTRA, t2.TILACODIGO TRAMINSTILACODIGO, t2.TIDETANA TRAMINSTIDETANA, t2.TIFECHARESENS TRAMINSTIFECHARESENS, t2.TICODINFENSAY TRAMINSTICODINFENSAY, t2.TIRESUDICTAM TRAMINSTIRESUDICTAM, t2.TICONSTATACION TRAMINSTICONSTATACION, t2.TIFECHADESIN TRAMINSTIFECHADESIN, t2.TINUMDESIN TRAMINSTINUMDESIN, t2.TINUMIN TRAMINSTINUMIN, t2.TIDESTINODESIN TRAMINSTIDESTINODESIN, t2.TIDESTRUCCIONINSITU TRAMINSTIDESTRUCCIONINSITU, t2.TIEMPRESAGEST TRAMINSTIEMPRESAGEST, t2.TINUMRECUPE TRAMINSTINUMRECUPE, t2.TINUMADESTRUIR TRAMINSTINUMADESTRUIR, t2.TINUMADEVOLVER TRAMINSTINUMADEVOLVER, t2.TIFECHAEMIINF TRAMINSTIFECHAEMIINF, t2.TIHORAINICIOEMIINF TRAMINSTIHORAINICIOEMIINF, t2.TIHORAFININF TRAMINSTIHORAFININF, t2.TIDNIINF TRAMINSTIDNIINF, t2.TINOMBREINF TRAMINSTINOMBREINF, t2.TINORA_PROVINCIA_ID TRAMINSTINORAPROVINCIAID, t2.TINOMBRE_PROVINCIA TRAMINSTINOMBREPROVINCIA, t2.TICODIGO TRAMINSTICODIGO, t2.TIATCODIGO TRAMINSTIATCODIGO, t2.TIACCODIGO TRAMINSTIACCODIGO, t2.TICOTEE TRAMINSTICOTEE, t2.TIFECHAINICIO TRAMINSTIFECHAINICIO, t2.TIFECHAFIN TRAMINSTIFECHAFIN, t2.TICOMOASIGNADO TRAMINSTICOMOASIGNADO, t2.TICOMOEJECUCION TRAMINSTICOMOEJECUCION, t2.TICOMENTARIO TRAMINSTICOMENTARIO, t2.TICOMODESIGNADO TRAMINSTICOMODESIGNADO, t2.TIDOCUMENTACIONREQUERIDA TRAMINSTIDOCUREQUERIDA, t2.TIDOCUMENTACIONREQUERIDAE TRAMINSTIDOCUREQUERIDAE, t2.TIDECODIGO TRAMINSTIDECODIGO, t2.TIFECHARESOLUCION TRAMINSTIFECHARESOLUCION, t2.TIFECHARECURSO TRAMINSTIFECHARECURSO, t2.TITIPORECURSO TRAMINSTITIPORECURSO, t2.TIABOGADO TRAMINSTIABOGADO, t2.TIMOTIVORECURSO TRAMINSTIMOTIVORECURSO, t2.TIESTIMACION TRAMINSTIESTIMACION, t2.TIFECHACIERRE TRAMINSTIFECHACIERRE, t2.TIDESTINATARIO TRAMINSTIDESTINATARIO, t2.TIFECHACOMUNICACION TRAMINSTIFECHACOMUNICACION, t2.TITIPOCOMUNICACION TRAMINSTITIPOCOMUNICACION, t2.TITIPONOTIFICACION TRAMINSTITIPONOTIFICACION, t2.TINOTIFICACIONPORACTA TRAMINSTINOTIFICACIONPORACTA, t2.TINUMREGISTROSALIDA TRAMINSTINUMREGISTROSALIDA, t2.TIFECHAREGISTROSALIDA TRAMINSTIFECHAREGSALIDA, t2.TIACUSERECIBO TRAMINSTIACUSERECIBO, t2.TIACUSERECIBORECIBIDO TRAMINSTIACUSERECRECIBIDO, t2.TINUMREGISTROENTRADA TRAMINSTINUMREGISTROENTRADA, t2.TIFECHAREGISTROENTRADA TRAMINSTIFECHAREGENTRADA, t2.TIIDNOTIFICACIONPLATEA TRAMINSTIIDNOTIFPLATEA, t2.TINOMBRETRAMITE TRAMINSTINOMBRETRAMITE, t2.TIIDDESTINATARIO TRAMINSTIIDDESTINATARIO, t2.TIESTADOTRAMITE TRAMINSTIESTADOTRAMITE, t2.TIREQUIEREFIRMA TRAMINSTIREQUIEREFIRMA, t2.TITEXTOCOMUNICACION TRAMINSTITEXTOCOMUNICACION, t2.TITIPONOTIFICACIONPLATEA TRAMINSTITIPONOTIFPLATEA, t2.TIIDESPERAPLATEA TRAMINSTIIDESPERAPLATEA, t2.TIMATARESPERA TRAMINSTIMATARESPERA, t2.TIASUNTOCOMUNICACION TRAMINSTIASUNTOCOMUNICACION, t2.TIFECHAENVIOBOPVBOE TRAMINSTIFECHAENVIOBOPVBOE, t2.TIFECHAPUBLICACIONBOPV TRAMINSTIFECHAPUBBOPV, t2.TIFECHAPUBLICACIONAYTO TRAMINSTIFECHAPUBAYTO, t2.TISEDE TRAMINSTISEDE, t2.TIFECHALIMITE TRAMINSTIFECHALIMITE, t2.TICODREM TRAMINSTICODREM, t2.TIENVREM TRAMINSTIENVREM, t2.TIFCODIGO TRAMINSTIFCODIGO, t2.TIIDMAILORIGEN TRAMINSTIIDMAILORIGEN, t2.TIMAILORIGEN TRAMINSTIMAILORIGEN, t2.TIIDMAILDESTINO TRAMINSTIIDMAILDESTINO, t2.TIMAILDESTINO TRAMINSTIMAILDESTINO, t2.TIPROCEEDINGSIDPLATEA TRAMINSTIPROCEEDINGSIDPLATEA, t2.TIACUSEREINTENTADO TRAMINSTIACUSEREINTENTADO, t2.TIAUTOMATICO TRAMINSTIAUTOMATICO, t2.TIORIGENALEGACION TRAMINSTIORIGENALEGACION, t2.TIANCODIGO TRAMINSTIANCODIGO, t2.TITIPACTUA TRAMINSTITIPACTUA, t2.TIRESPUESTARECEPCION TRAMINSTIRESPUESTARECEPCION, t2.TIRESUMENRECEPCION TRAMINSTIRESUMENRECEPCION, t2.TIFECHAREDALERTA TRAMINSTIFECHAREDALERTA, t2.TIINCLUSIREDALERTA TRAMINSTIINCLUSIREDALERTA, t2.TIMOTIVOREDALERTA TRAMINSTIMOTIVOREDALERTA, t2.TIJUSTIFICACIONINFRACCION TRAMINSTIJUSTIFFRACCION, t2.TIFECHAENVLAB TRAMINSTIFECHAENVLAB, t2.TICODMUESTRA TRAMINSTICODMUESTRA, t2.TILACODIGO TRAMINSTILACODIGO, t2.TIDETANA TRAMINSTIDETANA, t2.TIFECHARESENS TRAMINSTIFECHARESENS, t2.TICODINFENSAY TRAMINSTICODINFENSAY, t2.TIRESUDICTAM TRAMINSTIRESUDICTAM, t2.TICONSTATACION TRAMINSTICONSTATACION, t2.TIFECHADESIN TRAMINSTIFECHADESIN, t2.TINUMDESIN TRAMINSTINUMDESIN, t2.TIDESTINODESIN TRAMINSTIDESTINODESIN, t2.TIDESTRUCCIONINSITU TRAMINSTIDESTRUCCIONINSITU, t2.TIEMPRESAGEST TRAMINSTIEMPRESAGEST, t2.TINUMRECUPE TRAMINSTINUMRECUPE, t2.TINUMADESTRUIR TRAMINSTINUMADESTRUIR, t2.TINUMADEVOLVER TRAMINSTINUMADEVOLVER, t2.TIFECHAEMIINF TRAMINSTIFECHAEMIINF, t2.TIHORAINICIOEMIINF TRAMINSTIHORAINICIOEMIINF, t2.TIHORAFININF TRAMINSTIHORAFININF, t2.TIDNIINF TRAMINSTIDNIINF, t2.TINOMBREINF TRAMINSTINOMBREINF, t2.TINORA_PROVINCIA_ID TRAMINSTINORAPROVINCIAID, t2.TINOMBRE_PROVINCIA TRAMINSTINOMBREPROVINCIA, t2.TINORA_MUNICIPIO_ID TRAMINSTINORAMUNICIPIOID, t2.TINOMBRE_MUNICIPIO TRAMINSTINOMBREMUNICIPIO, t2.TINORA_LOCALIDAD_ID TRAMINSTINORALOCALIDADID, t2.TINOMBRE_LOCALIDAD TRAMINSTINOMBRELOCALIDAD, t2.TINORA_CALLE_ID TRAMINSTINORACALLEID, t2.TINOMBRE_CALLE TRAMINSTINOMBRECALLE, t2.TINORA_CP_ID TRAMINSTINORACPID, t2.TINOMBRE_CP TRAMINSTINOMBRECP, t2.TINORA_PORTAL_ID TRAMINSTINORAPORTALID, t2.TINOMBRE_PORTAL TRAMINSTINOMBREPORTAL, t2.TINOMBRE_PISO TRAMINSTINOMBREPISO, t2.TIDIRECCION_NOCAPV TRAMINSTIDIRECCIONNOCAPV, t2.TIEXTRANJERO TRAMINSTIEXTRANJERO, t2.TINORA_PAIS_ID TRAMINSTINORAPAISID, t2.TINOMBRE_PAIS TRAMINSTINOMBREPAIS, t2.TITELINF TRAMINSTITELINF, t2.TIENCONDICIONINF TRAMINSTIENCONDICIONINF, t2.TIINFORME TRAMINSTIINFORME, t2.TIVALORACION TRAMINSTIVALORACION, t2.TIFECHAACEPTACION TRAMINSTIFECHAACEPTACION, t2.TIFECHAAMPLI TRAMINSTIFECHAAMPLI, t2.TIMOTIVOAMPLI TRAMINSTIMOTIVOAMPLI, t2.TICODIGORELACIONADO TRAMINSTICODIGORELACIONADO, t2.TICOORTRASPASO TRAMINSTICOORTRASPASO, t2.TITELINF2 TRAMINSTITELINF2, t2.TICOMPDIRECCION TRAMINSTICOMPDIRECCION, t2.TIAPE1INF TRAMINSTIAPE1INF, t2.TIAPE2INF TRAMINSTIAPE2INF, t2.TIFECHAAIP TRAMINSTIFECHAAIP, t2.TIFECALTA TRAMINSTIFECALTA, t2.TIFECMODIF TRAMINSTIFECMODIF FROM TRAMITE_INSPECCION t1 , TRAMITE_INSPECCION t2 WHERE t1.TICODIGO = ? AND t1.TICODIGORELACIONADO= t2.TICODIGO(+)";

		List<TramiteInspeccion> tramiteinspeccionList = this.jdbcTemplate.query(query, this.rwMap,
				tramiteinspeccion.getTicodigo());
		return (TramiteInspeccion) DataAccessUtils.uniqueResult(tramiteinspeccionList);
	}

	/**
	 * Removes a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteinspeccion
	 *            Pagination
	 * @return
	 */
	public void remove(TramiteInspeccion tramiteinspeccion) {
		String query = "DELETE FROM TRAMITE_INSPECCION WHERE TICODIGO=?";
		this.jdbcTemplate.update(query, tramiteinspeccion.getTicodigo());
	}

	/**
	 * Removes a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteinspeccion
	 *            Pagination
	 * @return
	 */
	public void removeAllTramitesExpediente(TramiteInspeccion tramiteinspeccion) {
		String query = "DELETE FROM TRAMITE_INSPECCION WHERE TIATCODIGO=?";
		this.jdbcTemplate.update(query, tramiteinspeccion.getTiatcodigo());
	}

	/**
	 * Removes a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteinspeccion
	 *            TramiteInspeccion
	 * @return
	 */
	public void removeTramiteCierreSinTramitarExpediente(TramiteInspeccion tramiteinspeccion) {
		String query = "DELETE FROM TRAMITE_INSPECCION WHERE TIATCODIGO=? AND TICOTEE=? AND TIFECHAFIN IS NULL";
		this.jdbcTemplate.update(query, tramiteinspeccion.getTiatcodigo(),
				Y41bConstantes.TRAMITE_INSPECCIONES_CIERRE_EXPEDIENTE);
	}

	/**
	 * Finds a List of rows in the TramiteInspeccion table.
	 * 
	 * @param tramiteinspeccion
	 *            TramiteInspeccion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TramiteInspeccion> findAll(TramiteInspeccion tramiteinspeccion, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TICODIGO TICODIGO,t1.TIATCODIGO TIATCODIGO,t1.TIACCODIGO TIACCODIGO,t1.TICOTEE TICOTEE,t1.TIFECHAINICIO TIFECHAINICIO,t1.TIFECHAFIN TIFECHAFIN,t1.TICOMOASIGNADO TICOMOASIGNADO,t1.TICOMOEJECUCION TICOMOEJECUCION,t1.TICOMENTARIO TICOMENTARIO,t1.TICOMODESIGNADO TICOMODESIGNADO,t1.TIDOCUMENTACIONREQUERIDA TIDOCUMENTACIONREQUERIDA,t1.TIDOCUMENTACIONREQUERIDAE TIDOCUMENTACIONREQUERIDAE,t1.TIDECODIGO TIDECODIGO,t1.TIFECHARESOLUCION TIFECHARESOLUCION,t1.TIFECHARECURSO TIFECHARECURSO,t1.TITIPORECURSO TITIPORECURSO,t1.TIABOGADO TIABOGADO,t1.TIMOTIVORECURSO TIMOTIVORECURSO,t1.TIESTIMACION TIESTIMACION,t1.TIFECHACIERRE TIFECHACIERRE,t1.TIDESTINATARIO TIDESTINATARIO,t1.TIFECHACOMUNICACION TIFECHACOMUNICACION,t1.TITIPOCOMUNICACION TITIPOCOMUNICACION,t1.TITIPONOTIFICACION TITIPONOTIFICACION,t1.TINOTIFICACIONPORACTA TINOTIFICACIONPORACTA,t1.TINUMREGISTROSALIDA TINUMREGISTROSALIDA,t1.TIFECHAREGISTROSALIDA TIFECHAREGISTROSALIDA,t1.TIACUSERECIBO TIACUSERECIBO,t1.TIACUSERECIBORECIBIDO TIACUSERECIBORECIBIDO,t1.TINUMREGISTROENTRADA TINUMREGISTROENTRADA,t1.TIFECHAREGISTROENTRADA TIFECHAREGISTROENTRADA,t1.TIIDNOTIFICACIONPLATEA TIIDNOTIFICACIONPLATEA,t1.TINOMBRETRAMITE TINOMBRETRAMITE,t1.TIIDDESTINATARIO TIIDDESTINATARIO,t1.TIESTADOTRAMITE TIESTADOTRAMITE,t1.TIREQUIEREFIRMA TIREQUIEREFIRMA,t1.TITEXTOCOMUNICACION TITEXTOCOMUNICACION,t1.TITIPONOTIFICACIONPLATEA TITIPONOTIFICACIONPLATEA,t1.TIIDESPERAPLATEA TIIDESPERAPLATEA,t1.TIMATARESPERA TIMATARESPERA,t1.TIASUNTOCOMUNICACION TIASUNTOCOMUNICACION,t1.TIFECHAENVIOBOPVBOE TIFECHAENVIOBOPVBOE,t1.TIFECHAPUBLICACIONBOPV TIFECHAPUBLICACIONBOPV,t1.TIFECHAPUBLICACIONAYTO TIFECHAPUBLICACIONAYTO,t1.TISEDE TISEDE,t1.TIFECHALIMITE TIFECHALIMITE,t1.TICODREM TICODREM,t1.TIENVREM TIENVREM,t1.TIFCODIGO TIFCODIGO,t1.TIIDMAILORIGEN TIIDMAILORIGEN,t1.TIMAILORIGEN TIMAILORIGEN,t1.TIIDMAILDESTINO TIIDMAILDESTINO,t1.TIMAILDESTINO TIMAILDESTINO,t1.TIPROCEEDINGSIDPLATEA TIPROCEEDINGSIDPLATEA,t1.TIACUSEREINTENTADO TIACUSEREINTENTADO,t1.TIAUTOMATICO TIAUTOMATICO,t1.TIORIGENALEGACION TIORIGENALEGACION,t1.TIANCODIGO TIANCODIGO,t1.TITIPACTUA TITIPACTUA,t1.TIRESPUESTARECEPCION TIRESPUESTARECEPCION,t1.TIRESUMENRECEPCION TIRESUMENRECEPCION,t1.TIFECHAREDALERTA TIFECHAREDALERTA,t1.TIINCLUSIREDALERTA TIINCLUSIREDALERTA,t1.TIMOTIVOREDALERTA TIMOTIVOREDALERTA,t1.TIJUSTIFICACIONINFRACCION TIJUSTIFICACIONINFRACCION,t1.TIFECHAENVLAB TIFECHAENVLAB,t1.TICODMUESTRA TICODMUESTRA,t1.TILACODIGO TILACODIGO,t1.TIDETANA TIDETANA,t1.TIFECHARESENS TIFECHARESENS,t1.TICODINFENSAY TICODINFENSAY,t1.TIRESUDICTAM TIRESUDICTAM,t1.TICONSTATACION TICONSTATACION,t1.TIFECHADESIN TIFECHADESIN,t1.TINUMDESIN TINUMDESIN,t1.TIDESTINODESIN TIDESTINODESIN,t1.TIDESTRUCCIONINSITU TIDESTRUCCIONINSITU,t1.TIEMPRESAGEST TIEMPRESAGEST,t1.TINUMRECUPE TINUMRECUPE,t1.TINUMADESTRUIR TINUMADESTRUIR,t1.TINUMADEVOLVER TINUMADEVOLVER,t1.TIFECHAEMIINF TIFECHAEMIINF,t1.TIHORAINICIOEMIINF TIHORAINICIOEMIINF,t1.TIHORAFININF TIHORAFININF,t1.TIDNIINF TIDNIINF,t1.TINOMBREINF TINOMBREINF,t1.TINORA_PROVINCIA_ID TINORAPROVINCIAID,t1.TINOMBRE_PROVINCIA TINOMBREPROVINCIA,t1.TINORA_MUNICIPIO_ID TINORAMUNICIPIOID,t1.TINOMBRE_MUNICIPIO TINOMBREMUNICIPIO,t1.TINORA_LOCALIDAD_ID TINORALOCALIDADID,t1.TINOMBRE_LOCALIDAD TINOMBRELOCALIDAD,t1.TINORA_CALLE_ID TINORACALLEID,t1.TINOMBRE_CALLE TINOMBRECALLE,t1.TINORA_CP_ID TINORACPID,t1.TINOMBRE_CP TINOMBRECP,t1.TINORA_PORTAL_ID TINORAPORTALID,t1.TINOMBRE_PORTAL TINOMBREPORTAL,t1.TINOMBRE_PISO TINOMBREPISO,t1.TIDIRECCION_NOCAPV TIDIRECCIONNOCAPV,t1.TIEXTRANJERO TIEXTRANJERO,t1.TINORA_PAIS_ID TINORAPAISID,t1.TINOMBRE_PAIS TINOMBREPAIS,t1.TITELINF TITELINF,t1.TIENCONDICIONINF TIENCONDICIONINF,t1.TIINFORME TIINFORME,t1.TIVALORACION TIVALORACION,t1.TIFECHAACEPTACION TIFECHAACEPTACION,t1.TIFECHAAMPLI TIFECHAAMPLI,t1.TIMOTIVOAMPLI TIMOTIVOAMPLI,t1.TINUMIN TINUMIN, t1.TIDIRECCION_NOCAPV TIDIRECCIONNOCAPV, t1.TIEXTRANJERO TIEXTRANJERO, t1.TINORA_PAIS_ID TINORAPAISID, t1.TINOMBRE_PAIS TINOMBREPAIS, t1.TITELINF TITELINF, t1.TIENCONDICIONINF TIENCONDICIONINF, t1.TIINFORME TIINFORME, t1.TIVALORACION TIVALORACION, t1.TIFECHAACEPTACION TIFECHAACEPTACION, t1.TIFECHAAMPLI TIFECHAAMPLI, t1.TIMOTIVOAMPLI TIMOTIVOAMPLI, t1.TICOALREL TICOALREL, t1.TICOORTRASPASO TICOORTRASPASO, t1.TITELINF2 TITELINF2, t1.TICOMPDIRECCION TICOMPDIRECCION, t1.TIAPE1INF TIAPE1INF, t1.TIAPE2INF, t1.TIFECHAAIP TIFECHAAIP, t1.TIFECALTA TIFECALTA, t1.TIFECMODIF TIFECMODIF, t1.TICOCR TICOCR, t1.TILIGADOPROTOCOLO TILIGADOPROTOCOLO, t1.TIISTELEMATICO  TIISTELEMATICO, t1.TIISSIR TIISSIR, t1.TIISSIRCONNUMREGENTORI TIISSIRCONNUMREGENTORI,t1.TICOCMREL TICOCMREL, t1.TICOPG TICOPG, t1.TIEXCLUIRCIERRE TIEXCLUIRCIERRE, t1.TIARCHIVAR TIARCHIVAR, t2.TICODIGO TRAMINSTICODIGO, t2.TIATCODIGO TRAMINSTIATCODIGO, t2.TIACCODIGO TRAMINSTIACCODIGO, t2.TICOTEE TRAMINSTICOTEE, t2.TIFECHAINICIO TRAMINSTIFECHAINICIO, t2.TIFECHAFIN TRAMINSTIFECHAFIN, t2.TICOMOASIGNADO TRAMINSTICOMOASIGNADO, t2.TICOMOEJECUCION TRAMINSTICOMOEJECUCION, t2.TICOMENTARIO TRAMINSTICOMENTARIO, t2.TICOMODESIGNADO TRAMINSTICOMODESIGNADO, t2.TIDOCUMENTACIONREQUERIDA TRAMINSTIDOCUREQUERIDA, t2.TIDOCUMENTACIONREQUERIDAE TRAMINSTIDOCUREQUERIDAE, t2.TIDECODIGO TRAMINSTIDECODIGO, t2.TIFECHARESOLUCION TRAMINSTIFECHARESOLUCION, t2.TIFECHARECURSO TRAMINSTIFECHARECURSO, t2.TITIPORECURSO TRAMINSTITIPORECURSO, t2.TIABOGADO TRAMINSTIABOGADO, t2.TIMOTIVORECURSO TRAMINSTIMOTIVORECURSO, t2.TIESTIMACION TRAMINSTIESTIMACION, t2.TIFECHACIERRE TRAMINSTIFECHACIERRE, t2.TIDESTINATARIO TRAMINSTIDESTINATARIO, t2.TIFECHACOMUNICACION TRAMINSTIFECHACOMUNICACION, t2.TITIPOCOMUNICACION TRAMINSTITIPOCOMUNICACION, t2.TITIPONOTIFICACION TRAMINSTITIPONOTIFICACION, t2.TINOTIFICACIONPORACTA TRAMINSTINOTIFICACIONPORACTA, t2.TINUMREGISTROSALIDA TRAMINSTINUMREGISTROSALIDA, t2.TIFECHAREGISTROSALIDA TRAMINSTIFECHAREGSALIDA, t2.TIACUSERECIBO TRAMINSTIACUSERECIBO, t2.TIACUSERECIBORECIBIDO TRAMINSTIACUSERECRECIBIDO, t2.TINUMREGISTROENTRADA TRAMINSTINUMREGISTROENTRADA, t2.TIFECHAREGISTROENTRADA TRAMINSTIFECHAREGENTRADA, t2.TIIDNOTIFICACIONPLATEA TRAMINSTIIDNOTIFPLATEA, t2.TINOMBRETRAMITE TRAMINSTINOMBRETRAMITE, t2.TIIDDESTINATARIO TRAMINSTIIDDESTINATARIO, t2.TIESTADOTRAMITE TRAMINSTIESTADOTRAMITE, t2.TIREQUIEREFIRMA TRAMINSTIREQUIEREFIRMA, t2.TITEXTOCOMUNICACION TRAMINSTITEXTOCOMUNICACION, t2.TITIPONOTIFICACIONPLATEA TRAMINSTITIPONOTIFPLATEA, t2.TIIDESPERAPLATEA TRAMINSTIIDESPERAPLATEA, t2.TIMATARESPERA TRAMINSTIMATARESPERA, t2.TIASUNTOCOMUNICACION TRAMINSTIASUNTOCOMUNICACION, t2.TIFECHAENVIOBOPVBOE TRAMINSTIFECHAENVIOBOPVBOE, t2.TIFECHAPUBLICACIONBOPV TRAMINSTIFECHAPUBBOPV, t2.TIFECHAPUBLICACIONAYTO TRAMINSTIFECHAPUBAYTO, t2.TISEDE TRAMINSTISEDE, t2.TIFECHALIMITE TRAMINSTIFECHALIMITE, t2.TICODREM TRAMINSTICODREM, t2.TIENVREM TRAMINSTIENVREM, t2.TIFCODIGO TRAMINSTIFCODIGO, t2.TIIDMAILORIGEN TRAMINSTIIDMAILORIGEN, t2.TIMAILORIGEN TRAMINSTIMAILORIGEN, t2.TIIDMAILDESTINO TRAMINSTIIDMAILDESTINO, t2.TIMAILDESTINO TRAMINSTIMAILDESTINO, t2.TIPROCEEDINGSIDPLATEA TRAMINSTIPROCEEDINGSIDPLATEA, t2.TIACUSEREINTENTADO TRAMINSTIACUSEREINTENTADO, t2.TIAUTOMATICO TRAMINSTIAUTOMATICO, t2.TIORIGENALEGACION TRAMINSTIORIGENALEGACION, t2.TIANCODIGO TRAMINSTIANCODIGO, t2.TITIPACTUA TRAMINSTITIPACTUA, t2.TIRESPUESTARECEPCION TRAMINSTIRESPUESTARECEPCION, t2.TIRESUMENRECEPCION TRAMINSTIRESUMENRECEPCION, t2.TIFECHAREDALERTA TRAMINSTIFECHAREDALERTA, t2.TIINCLUSIREDALERTA TRAMINSTIINCLUSIREDALERTA, t2.TIMOTIVOREDALERTA TRAMINSTIMOTIVOREDALERTA, t2.TIJUSTIFICACIONINFRACCION TRAMINSTIJUSTIFINFRACCION, t2.TIFECHAENVLAB TRAMINSTIFECHAENVLAB, t2.TICODMUESTRA TRAMINSTICODMUESTRA, t2.TILACODIGO TRAMINSTILACODIGO, t2.TIDETANA TRAMINSTIDETANA, t2.TIFECHARESENS TRAMINSTIFECHARESENS, t2.TICODINFENSAY TRAMINSTICODINFENSAY, t2.TIRESUDICTAM TRAMINSTIRESUDICTAM, t2.TICONSTATACION TRAMINSTICONSTATACION, t2.TIFECHADESIN  TRAMINSTIFECHADESIN, t2.TINUMDESIN TRAMINSTINUMDESIN, t2.TINUMIN TRAMINSTINUMIN, t2.TIDESTINODESIN TRAMINSTIDESTINODESIN, t2.TIDESTRUCCIONINSITU TRAMINSTIDESTRUCCIONINSITU, t2.TIEMPRESAGEST TRAMINSTIEMPRESAGEST, t2.TINUMRECUPE TRAMINSTINUMRECUPE, t2.TINUMADESTRUIR TRAMINSTINUMADESTRUIR, t2.TINUMADEVOLVER TRAMINSTINUMADEVOLVER, t2.TIFECHAEMIINF TRAMINSTIFECHAEMIINF, t2.TIHORAINICIOEMIINF TRAMINSTIHORAINICIOEMIINF, t2.TIHORAFININF TRAMINSTIHORAFININF, t2.TIDNIINF TRAMINSTIDNIINF, t2.TINOMBREINF TRAMINSTINOMBREINF, t2.TINORA_PROVINCIA_ID TRAMINSTINORAPROVINCIAID, t2.TINOMBRE_PROVINCIA TRAMINSTINOMBREPROVINCIA, t2.TICODIGO TRAMINSTICODIGO,t2.TIATCODIGO TRAMINSTIATCODIGO, t2.TIACCODIGO TRAMINSTIACCODIGO,t2.TICOTEE TRAMINSTICOTEE,t2.TIFECHAINICIO TRAMINSTIFECHAINICIO,t2.TIFECHAFIN TRAMINSTIFECHAFIN,t2.TICOMOASIGNADO TRAMINSTICOMOASIGNADO,t2.TICOMOEJECUCION TRAMINSTICOMOEJECUCION,t2.TICOMENTARIO TRAMINSTICOMENTARIO,t2.TICOMODESIGNADO TRAMINSTICOMODESIGNADO,t2.TIDOCUMENTACIONREQUERIDA TRAMINSTIDOCUREQUERIDA,t2.TIDOCUMENTACIONREQUERIDAE TRAMINSTIDOCUREQUERIDAE,t2.TIDECODIGO TRAMINSTIDECODIGO,t2.TIFECHARESOLUCION TRAMINSTIFECHARESOLUCION,t2.TIFECHARECURSO TRAMINSTIFECHARECURSO,t2.TITIPORECURSO TRAMINSTITIPORECURSO,t2.TIABOGADO TRAMINSTIABOGADO,t2.TIMOTIVORECURSO TRAMINSTIMOTIVORECURSO,t2.TIESTIMACION TRAMINSTIESTIMACION,t2.TIFECHACIERRE TRAMINSTIFECHACIERRE,t2.TIDESTINATARIO TRAMINSTIDESTINATARIO,t2.TIFECHACOMUNICACION TRAMINSTIFECHACOMUNICACION,t2.TITIPOCOMUNICACION TRAMINSTITIPOCOMUNICACION,t2.TITIPONOTIFICACION TRAMINSTITIPONOTIFICACION,t2.TINOTIFICACIONPORACTA TRAMINSTINOTIFICACIONPORACTA,t2.TINUMREGISTROSALIDA TRAMINSTINUMREGISTROSALIDA,t2.TIFECHAREGISTROSALIDA TRAMINSTIFECHAREGSALIDA,t2.TIACUSERECIBO TRAMINSTIACUSERECIBO,t2.TIACUSERECIBORECIBIDO TRAMINSTIACUSERECRECIBIDO,t2.TINUMREGISTROENTRADA TRAMINSTINUMREGISTROENTRADA,t2.TIFECHAREGISTROENTRADA TRAMINSTIFECHAREGENTRADA,t2.TIIDNOTIFICACIONPLATEA TRAMINSTIIDNOTIFPLATEA,t2.TINOMBRETRAMITE TRAMINSTINOMBRETRAMITE,t2.TIIDDESTINATARIO TRAMINSTIIDDESTINATARIO,t2.TIESTADOTRAMITE TRAMINSTIESTADOTRAMITE,t2.TIREQUIEREFIRMA TRAMINSTIREQUIEREFIRMA,t2.TITEXTOCOMUNICACION TRAMINSTITEXTOCOMUNICACION,t2.TITIPONOTIFICACIONPLATEA TRAMINSTITIPONOTIFPLATEA,t2.TIIDESPERAPLATEA TRAMINSTIIDESPERAPLATEA,t2.TIMATARESPERA TRAMINSTIMATARESPERA,t2.TIASUNTOCOMUNICACION TRAMINSTIASUNTOCOMUNICACION,t2.TIFECHAENVIOBOPVBOE TRAMINSTIFECHAENVIOBOPVBOE,t2.TIFECHAPUBLICACIONBOPV TRAMINSTIFECHAPUBBOPV,t2.TIFECHAPUBLICACIONAYTO TRAMINSTIFECHAPUBAYTO,t2.TISEDE TRAMINSTISEDE,t2.TIFECHALIMITE TRAMINSTIFECHALIMITE,t2.TICODREM TRAMINSTICODREM,t2.TIENVREM TRAMINSTIENVREM,t2.TIFCODIGO TRAMINSTIFCODIGO,t2.TIIDMAILORIGEN TRAMINSTIIDMAILORIGEN,t2.TIMAILORIGEN TRAMINSTIMAILORIGEN,t2.TIIDMAILDESTINO TRAMINSTIIDMAILDESTINO,t2.TIMAILDESTINO TRAMINSTIMAILDESTINO,t2.TIPROCEEDINGSIDPLATEA TRAMINSTIPROCEEDINGSIDPLATEA,t2.TIACUSEREINTENTADO TRAMINSTIACUSEREINTENTADO,t2.TIAUTOMATICO TRAMINSTIAUTOMATICO,t2.TIORIGENALEGACION TRAMINSTIORIGENALEGACION,t2.TIANCODIGO TRAMINSTIANCODIGO,t2.TITIPACTUA TRAMINSTITIPACTUA,t2.TIRESPUESTARECEPCION TRAMINSTIRESPUESTARECEPCION,t2.TIRESUMENRECEPCION TRAMINSTIRESUMENRECEPCION,t2.TIFECHAREDALERTA TRAMINSTIFECHAREDALERTA,t2.TIINCLUSIREDALERTA TRAMINSTIINCLUSIREDALERTA,t2.TIMOTIVOREDALERTA TRAMINSTIMOTIVOREDALERTA,t2.TIJUSTIFICACIONINFRACCION TRAMINSTIJUSTIFFRACCION,t2.TIFECHAENVLAB TRAMINSTIFECHAENVLAB,t2.TICODMUESTRA TRAMINSTICODMUESTRA,t2.TILACODIGO TRAMINSTILACODIGO,t2.TIDETANA TRAMINSTIDETANA,t2.TIFECHARESENS TRAMINSTIFECHARESENS,t2.TICODINFENSAY TRAMINSTICODINFENSAY,t2.TIRESUDICTAM TRAMINSTIRESUDICTAM,t2.TICONSTATACION TRAMINSTICONSTATACION,t2.TIFECHADESIN TRAMINSTIFECHADESIN,t2.TINUMDESIN TRAMINSTINUMDESIN,t2.TIDESTINODESIN TRAMINSTIDESTINODESIN,t2.TIDESTRUCCIONINSITU TRAMINSTIDESTRUCCIONINSITU,t2.TIEMPRESAGEST TRAMINSTIEMPRESAGEST,t2.TINUMRECUPE TRAMINSTINUMRECUPE,t2.TINUMADESTRUIR TRAMINSTINUMADESTRUIR,t2.TINUMADEVOLVER TRAMINSTINUMADEVOLVER,t2.TIFECHAEMIINF TRAMINSTIFECHAEMIINF,t2.TIHORAINICIOEMIINF TRAMINSTIHORAINICIOEMIINF,t2.TIHORAFININF TRAMINSTIHORAFININF,t2.TIDNIINF TRAMINSTIDNIINF,t2.TINOMBREINF TRAMINSTINOMBREINF,t2.TINORA_PROVINCIA_ID TRAMINSTINORAPROVINCIAID,t2.TINOMBRE_PROVINCIA TRAMINSTINOMBREPROVINCIA,t2.TINORA_MUNICIPIO_ID TRAMINSTINORAMUNICIPIOID,t2.TINOMBRE_MUNICIPIO TRAMINSTINOMBREMUNICIPIO,t2.TINORA_LOCALIDAD_ID TRAMINSTINORALOCALIDADID,t2.TINOMBRE_LOCALIDAD TRAMINSTINOMBRELOCALIDAD,t2.TINORA_CALLE_ID TRAMINSTINORACALLEID,t2.TINOMBRE_CALLE TRAMINSTINOMBRECALLE,t2.TINORA_CP_ID TRAMINSTINORACPID,t2.TINOMBRE_CP TRAMINSTINOMBRECP,t2.TINORA_PORTAL_ID TRAMINSTINORAPORTALID,t2.TINOMBRE_PORTAL TRAMINSTINOMBREPORTAL,t2.TINOMBRE_PISO TRAMINSTINOMBREPISO,t2.TIDIRECCION_NOCAPV TRAMINSTIDIRECCIONNOCAPV,t2.TIEXTRANJERO TRAMINSTIEXTRANJERO,t2.TINORA_PAIS_ID TRAMINSTINORAPAISID,t2.TINOMBRE_PAIS TRAMINSTINOMBREPAIS,t2.TITELINF TRAMINSTITELINF,t2.TIENCONDICIONINF TRAMINSTIENCONDICIONINF,t2.TIINFORME TRAMINSTIINFORME,t2.TIVALORACION TRAMINSTIVALORACION,t2.TIFECHAACEPTACION TRAMINSTIFECHAACEPTACION,t2.TIFECHAAMPLI TRAMINSTIFECHAAMPLI,t2.TIMOTIVOAMPLI TRAMINSTIMOTIVOAMPLI,t2.TICODIGORELACIONADO TRAMINSTICODIGORELACIONADO, t2.TICOORTRASPASO TRAMINSTICOORTRASPASO, t2.TITELINF2 TRAMINSTITELINF2, t2.TICOMPDIRECCION TRAMINSTICOMPDIRECCION, t2.TIAPE1INF TRAMINSTIAPE1INF, t2.TIAPE2INF TRAMINSTIAPE2INF, t2.TIFECHAAIP TRAMINSTIFECHAAIP, t2.TIFECALTA TRAMINSTIFECALTA, t2.TIFECMODIF TRAMINSTIFECMODIF ");
		query.append("FROM TRAMITE_INSPECCION t1 ,TRAMITE_INSPECCION t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tramiteinspeccion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.TICODIGORELACIONADO= t2.TICODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<TramiteInspeccion>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the TramiteInspeccion table.
	 * 
	 * @param tramiteinspeccion
	 *            TramiteInspeccion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TramiteInspeccion> findAllTramitesPendientesPorTipo(TramiteInspeccion tramiteinspeccion,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TICODIGO TICODIGO,t1.TIATCODIGO TIATCODIGO,t1.TIACCODIGO TIACCODIGO,t1.TICOTEE TICOTEE,t1.TIFECHAINICIO TIFECHAINICIO,t1.TIFECHAFIN TIFECHAFIN,t1.TICOMOASIGNADO TICOMOASIGNADO,t1.TICOMOEJECUCION TICOMOEJECUCION,t1.TICOMENTARIO TICOMENTARIO,t1.TICOMODESIGNADO TICOMODESIGNADO,t1.TIDOCUMENTACIONREQUERIDA TIDOCUMENTACIONREQUERIDA,t1.TIDOCUMENTACIONREQUERIDAE TIDOCUMENTACIONREQUERIDAE,t1.TIDECODIGO TIDECODIGO,t1.TIFECHARESOLUCION TIFECHARESOLUCION,t1.TIFECHARECURSO TIFECHARECURSO,t1.TITIPORECURSO TITIPORECURSO,t1.TIABOGADO TIABOGADO,t1.TIMOTIVORECURSO TIMOTIVORECURSO,t1.TIESTIMACION TIESTIMACION,t1.TIFECHACIERRE TIFECHACIERRE,t1.TIDESTINATARIO TIDESTINATARIO,t1.TIFECHACOMUNICACION TIFECHACOMUNICACION,t1.TITIPOCOMUNICACION TITIPOCOMUNICACION,t1.TITIPONOTIFICACION TITIPONOTIFICACION,t1.TINOTIFICACIONPORACTA TINOTIFICACIONPORACTA,t1.TINUMREGISTROSALIDA TINUMREGISTROSALIDA,t1.TIFECHAREGISTROSALIDA TIFECHAREGISTROSALIDA,t1.TIACUSERECIBO TIACUSERECIBO,t1.TIACUSERECIBORECIBIDO TIACUSERECIBORECIBIDO,t1.TINUMREGISTROENTRADA TINUMREGISTROENTRADA,t1.TIFECHAREGISTROENTRADA TIFECHAREGISTROENTRADA,t1.TIIDNOTIFICACIONPLATEA TIIDNOTIFICACIONPLATEA,t1.TINOMBRETRAMITE TINOMBRETRAMITE,t1.TIIDDESTINATARIO TIIDDESTINATARIO,t1.TIESTADOTRAMITE TIESTADOTRAMITE,t1.TIREQUIEREFIRMA TIREQUIEREFIRMA,t1.TITEXTOCOMUNICACION TITEXTOCOMUNICACION,t1.TITIPONOTIFICACIONPLATEA TITIPONOTIFICACIONPLATEA,t1.TIIDESPERAPLATEA TIIDESPERAPLATEA,t1.TIMATARESPERA TIMATARESPERA,t1.TIASUNTOCOMUNICACION TIASUNTOCOMUNICACION,t1.TIFECHAENVIOBOPVBOE TIFECHAENVIOBOPVBOE,t1.TIFECHAPUBLICACIONBOPV TIFECHAPUBLICACIONBOPV,t1.TIFECHAPUBLICACIONAYTO TIFECHAPUBLICACIONAYTO,t1.TISEDE TISEDE,t1.TIFECHALIMITE TIFECHALIMITE,t1.TICODREM TICODREM,t1.TIENVREM TIENVREM,t1.TIFCODIGO TIFCODIGO,t1.TIIDMAILORIGEN TIIDMAILORIGEN,t1.TIMAILORIGEN TIMAILORIGEN,t1.TIIDMAILDESTINO TIIDMAILDESTINO,t1.TIMAILDESTINO TIMAILDESTINO,t1.TIPROCEEDINGSIDPLATEA TIPROCEEDINGSIDPLATEA,t1.TIACUSEREINTENTADO TIACUSEREINTENTADO,t1.TIAUTOMATICO TIAUTOMATICO,t1.TIORIGENALEGACION TIORIGENALEGACION,t1.TIANCODIGO TIANCODIGO,t1.TITIPACTUA TITIPACTUA,t1.TIRESPUESTARECEPCION TIRESPUESTARECEPCION,t1.TIRESUMENRECEPCION TIRESUMENRECEPCION,t1.TIFECHAREDALERTA TIFECHAREDALERTA,t1.TIINCLUSIREDALERTA TIINCLUSIREDALERTA,t1.TIMOTIVOREDALERTA TIMOTIVOREDALERTA,t1.TIJUSTIFICACIONINFRACCION TIJUSTIFICACIONINFRACCION,t1.TIFECHAENVLAB TIFECHAENVLAB,t1.TICODMUESTRA TICODMUESTRA,t1.TILACODIGO TILACODIGO,t1.TIDETANA TIDETANA,t1.TIFECHARESENS TIFECHARESENS,t1.TICODINFENSAY TICODINFENSAY,t1.TIRESUDICTAM TIRESUDICTAM,t1.TICONSTATACION TICONSTATACION,t1.TIFECHADESIN TIFECHADESIN,t1.TINUMDESIN TINUMDESIN,t1.TIDESTINODESIN TIDESTINODESIN,t1.TIDESTRUCCIONINSITU TIDESTRUCCIONINSITU,t1.TIEMPRESAGEST TIEMPRESAGEST,t1.TINUMRECUPE TINUMRECUPE,t1.TINUMADESTRUIR TINUMADESTRUIR,t1.TINUMADEVOLVER TINUMADEVOLVER,t1.TIFECHAEMIINF TIFECHAEMIINF,t1.TIHORAINICIOEMIINF TIHORAINICIOEMIINF,t1.TIHORAFININF TIHORAFININF,t1.TIDNIINF TIDNIINF,t1.TINOMBREINF TINOMBREINF,t1.TINORA_PROVINCIA_ID TINORAPROVINCIAID,t1.TINOMBRE_PROVINCIA TINOMBREPROVINCIA,t1.TINORA_MUNICIPIO_ID TINORAMUNICIPIOID,t1.TINOMBRE_MUNICIPIO TINOMBREMUNICIPIO,t1.TINORA_LOCALIDAD_ID TINORALOCALIDADID,t1.TINOMBRE_LOCALIDAD TINOMBRELOCALIDAD,t1.TINORA_CALLE_ID TINORACALLEID,t1.TINOMBRE_CALLE TINOMBRECALLE,t1.TINORA_CP_ID TINORACPID,t1.TINOMBRE_CP TINOMBRECP,t1.TINORA_PORTAL_ID TINORAPORTALID,t1.TINOMBRE_PORTAL TINOMBREPORTAL,t1.TINOMBRE_PISO TINOMBREPISO,t1.TIDIRECCION_NOCAPV TIDIRECCIONNOCAPV,t1.TIEXTRANJERO TIEXTRANJERO,t1.TINORA_PAIS_ID TINORAPAISID,t1.TINOMBRE_PAIS TINOMBREPAIS,t1.TITELINF TITELINF,t1.TIENCONDICIONINF TIENCONDICIONINF,t1.TIINFORME TIINFORME,t1.TIVALORACION TIVALORACION,t1.TIFECHAACEPTACION TIFECHAACEPTACION,t1.TIFECHAAMPLI TIFECHAAMPLI,t1.TIMOTIVOAMPLI TIMOTIVOAMPLI,t1.TINUMIN TINUMIN, t1.TIDIRECCION_NOCAPV TIDIRECCIONNOCAPV, t1.TIEXTRANJERO TIEXTRANJERO, t1.TINORA_PAIS_ID TINORAPAISID, t1.TINOMBRE_PAIS TINOMBREPAIS, t1.TITELINF TITELINF, t1.TIENCONDICIONINF TIENCONDICIONINF, t1.TIINFORME TIINFORME, t1.TIVALORACION TIVALORACION, t1.TIFECHAACEPTACION TIFECHAACEPTACION, t1.TIFECHAAMPLI TIFECHAAMPLI, t1.TIMOTIVOAMPLI TIMOTIVOAMPLI, t1.TICOALREL TICOALREL, t1.TICOORTRASPASO TICOORTRASPASO, t1.TITELINF2 TITELINF2, t1.TICOMPDIRECCION TICOMPDIRECCION, t1.TIAPE1INF TIAPE1INF, t1.TIAPE2INF, t1.TIFECHAAIP TIFECHAAIP, t1.TIFECALTA TIFECALTA, t1.TIFECMODIF TIFECMODIF, t1.TICOCR TICOCR, t1.TILIGADOPROTOCOLO TILIGADOPROTOCOLO, t1.TIISTELEMATICO  TIISTELEMATICO, t1.TIISSIR TIISSIR, t1.TIISSIRCONNUMREGENTORI TIISSIRCONNUMREGENTORI,t1.TICOCMREL TICOCMREL, t1.TICOPG TICOPG, t1.TIEXCLUIRCIERRE TIEXCLUIRCIERRE, t1.TIARCHIVAR TIARCHIVAR, t2.TICODIGO TRAMINSTICODIGO, t2.TIATCODIGO TRAMINSTIATCODIGO, t2.TIACCODIGO TRAMINSTIACCODIGO, t2.TICOTEE TRAMINSTICOTEE, t2.TIFECHAINICIO TRAMINSTIFECHAINICIO, t2.TIFECHAFIN TRAMINSTIFECHAFIN, t2.TICOMOASIGNADO TRAMINSTICOMOASIGNADO, t2.TICOMOEJECUCION TRAMINSTICOMOEJECUCION, t2.TICOMENTARIO TRAMINSTICOMENTARIO, t2.TICOMODESIGNADO TRAMINSTICOMODESIGNADO, t2.TIDOCUMENTACIONREQUERIDA TRAMINSTIDOCUREQUERIDA, t2.TIDOCUMENTACIONREQUERIDAE TRAMINSTIDOCUREQUERIDAE, t2.TIDECODIGO TRAMINSTIDECODIGO, t2.TIFECHARESOLUCION TRAMINSTIFECHARESOLUCION, t2.TIFECHARECURSO TRAMINSTIFECHARECURSO, t2.TITIPORECURSO TRAMINSTITIPORECURSO, t2.TIABOGADO TRAMINSTIABOGADO, t2.TIMOTIVORECURSO TRAMINSTIMOTIVORECURSO, t2.TIESTIMACION TRAMINSTIESTIMACION, t2.TIFECHACIERRE TRAMINSTIFECHACIERRE, t2.TIDESTINATARIO TRAMINSTIDESTINATARIO, t2.TIFECHACOMUNICACION TRAMINSTIFECHACOMUNICACION, t2.TITIPOCOMUNICACION TRAMINSTITIPOCOMUNICACION, t2.TITIPONOTIFICACION TRAMINSTITIPONOTIFICACION, t2.TINOTIFICACIONPORACTA TRAMINSTINOTIFICACIONPORACTA, t2.TINUMREGISTROSALIDA TRAMINSTINUMREGISTROSALIDA, t2.TIFECHAREGISTROSALIDA TRAMINSTIFECHAREGSALIDA, t2.TIACUSERECIBO TRAMINSTIACUSERECIBO, t2.TIACUSERECIBORECIBIDO TRAMINSTIACUSERECRECIBIDO, t2.TINUMREGISTROENTRADA TRAMINSTINUMREGISTROENTRADA, t2.TIFECHAREGISTROENTRADA TRAMINSTIFECHAREGENTRADA, t2.TIIDNOTIFICACIONPLATEA TRAMINSTIIDNOTIFPLATEA, t2.TINOMBRETRAMITE TRAMINSTINOMBRETRAMITE, t2.TIIDDESTINATARIO TRAMINSTIIDDESTINATARIO, t2.TIESTADOTRAMITE TRAMINSTIESTADOTRAMITE, t2.TIREQUIEREFIRMA TRAMINSTIREQUIEREFIRMA, t2.TITEXTOCOMUNICACION TRAMINSTITEXTOCOMUNICACION, t2.TITIPONOTIFICACIONPLATEA TRAMINSTITIPONOTIFPLATEA, t2.TIIDESPERAPLATEA TRAMINSTIIDESPERAPLATEA, t2.TIMATARESPERA TRAMINSTIMATARESPERA, t2.TIASUNTOCOMUNICACION TRAMINSTIASUNTOCOMUNICACION, t2.TIFECHAENVIOBOPVBOE TRAMINSTIFECHAENVIOBOPVBOE, t2.TIFECHAPUBLICACIONBOPV TRAMINSTIFECHAPUBBOPV, t2.TIFECHAPUBLICACIONAYTO TRAMINSTIFECHAPUBAYTO, t2.TISEDE TRAMINSTISEDE, t2.TIFECHALIMITE TRAMINSTIFECHALIMITE, t2.TICODREM TRAMINSTICODREM, t2.TIENVREM TRAMINSTIENVREM, t2.TIFCODIGO TRAMINSTIFCODIGO, t2.TIIDMAILORIGEN TRAMINSTIIDMAILORIGEN, t2.TIMAILORIGEN TRAMINSTIMAILORIGEN, t2.TIIDMAILDESTINO TRAMINSTIIDMAILDESTINO, t2.TIMAILDESTINO TRAMINSTIMAILDESTINO, t2.TIPROCEEDINGSIDPLATEA TRAMINSTIPROCEEDINGSIDPLATEA, t2.TIACUSEREINTENTADO TRAMINSTIACUSEREINTENTADO, t2.TIAUTOMATICO TRAMINSTIAUTOMATICO, t2.TIORIGENALEGACION TRAMINSTIORIGENALEGACION, t2.TIANCODIGO TRAMINSTIANCODIGO, t2.TITIPACTUA TRAMINSTITIPACTUA, t2.TIRESPUESTARECEPCION TRAMINSTIRESPUESTARECEPCION, t2.TIRESUMENRECEPCION TRAMINSTIRESUMENRECEPCION, t2.TIFECHAREDALERTA TRAMINSTIFECHAREDALERTA, t2.TIINCLUSIREDALERTA TRAMINSTIINCLUSIREDALERTA, t2.TIMOTIVOREDALERTA TRAMINSTIMOTIVOREDALERTA, t2.TIJUSTIFICACIONINFRACCION TRAMINSTIJUSTIFINFRACCION, t2.TIFECHAENVLAB TRAMINSTIFECHAENVLAB, t2.TICODMUESTRA TRAMINSTICODMUESTRA, t2.TILACODIGO TRAMINSTILACODIGO, t2.TIDETANA TRAMINSTIDETANA, t2.TIFECHARESENS TRAMINSTIFECHARESENS, t2.TICODINFENSAY TRAMINSTICODINFENSAY, t2.TIRESUDICTAM TRAMINSTIRESUDICTAM, t2.TICONSTATACION TRAMINSTICONSTATACION, t2.TIFECHADESIN  TRAMINSTIFECHADESIN, t2.TINUMDESIN TRAMINSTINUMDESIN, t2.TINUMIN TRAMINSTINUMIN, t2.TIDESTINODESIN TRAMINSTIDESTINODESIN, t2.TIDESTRUCCIONINSITU TRAMINSTIDESTRUCCIONINSITU, t2.TIEMPRESAGEST TRAMINSTIEMPRESAGEST, t2.TINUMRECUPE TRAMINSTINUMRECUPE, t2.TINUMADESTRUIR TRAMINSTINUMADESTRUIR, t2.TINUMADEVOLVER TRAMINSTINUMADEVOLVER, t2.TIFECHAEMIINF TRAMINSTIFECHAEMIINF, t2.TIHORAINICIOEMIINF TRAMINSTIHORAINICIOEMIINF, t2.TIHORAFININF TRAMINSTIHORAFININF, t2.TIDNIINF TRAMINSTIDNIINF, t2.TINOMBREINF TRAMINSTINOMBREINF, t2.TINORA_PROVINCIA_ID TRAMINSTINORAPROVINCIAID, t2.TINOMBRE_PROVINCIA TRAMINSTINOMBREPROVINCIA, t2.TICODIGO TRAMINSTICODIGO,t2.TIATCODIGO TRAMINSTIATCODIGO, t2.TIACCODIGO TRAMINSTIACCODIGO,t2.TICOTEE TRAMINSTICOTEE,t2.TIFECHAINICIO TRAMINSTIFECHAINICIO,t2.TIFECHAFIN TRAMINSTIFECHAFIN,t2.TICOMOASIGNADO TRAMINSTICOMOASIGNADO,t2.TICOMOEJECUCION TRAMINSTICOMOEJECUCION,t2.TICOMENTARIO TRAMINSTICOMENTARIO,t2.TICOMODESIGNADO TRAMINSTICOMODESIGNADO,t2.TIDOCUMENTACIONREQUERIDA TRAMINSTIDOCUREQUERIDA,t2.TIDOCUMENTACIONREQUERIDAE TRAMINSTIDOCUREQUERIDAE,t2.TIDECODIGO TRAMINSTIDECODIGO,t2.TIFECHARESOLUCION TRAMINSTIFECHARESOLUCION,t2.TIFECHARECURSO TRAMINSTIFECHARECURSO,t2.TITIPORECURSO TRAMINSTITIPORECURSO,t2.TIABOGADO TRAMINSTIABOGADO,t2.TIMOTIVORECURSO TRAMINSTIMOTIVORECURSO,t2.TIESTIMACION TRAMINSTIESTIMACION,t2.TIFECHACIERRE TRAMINSTIFECHACIERRE,t2.TIDESTINATARIO TRAMINSTIDESTINATARIO,t2.TIFECHACOMUNICACION TRAMINSTIFECHACOMUNICACION,t2.TITIPOCOMUNICACION TRAMINSTITIPOCOMUNICACION,t2.TITIPONOTIFICACION TRAMINSTITIPONOTIFICACION,t2.TINOTIFICACIONPORACTA TRAMINSTINOTIFICACIONPORACTA,t2.TINUMREGISTROSALIDA TRAMINSTINUMREGISTROSALIDA,t2.TIFECHAREGISTROSALIDA TRAMINSTIFECHAREGSALIDA,t2.TIACUSERECIBO TRAMINSTIACUSERECIBO,t2.TIACUSERECIBORECIBIDO TRAMINSTIACUSERECRECIBIDO,t2.TINUMREGISTROENTRADA TRAMINSTINUMREGISTROENTRADA,t2.TIFECHAREGISTROENTRADA TRAMINSTIFECHAREGENTRADA,t2.TIIDNOTIFICACIONPLATEA TRAMINSTIIDNOTIFPLATEA,t2.TINOMBRETRAMITE TRAMINSTINOMBRETRAMITE,t2.TIIDDESTINATARIO TRAMINSTIIDDESTINATARIO,t2.TIESTADOTRAMITE TRAMINSTIESTADOTRAMITE,t2.TIREQUIEREFIRMA TRAMINSTIREQUIEREFIRMA,t2.TITEXTOCOMUNICACION TRAMINSTITEXTOCOMUNICACION,t2.TITIPONOTIFICACIONPLATEA TRAMINSTITIPONOTIFPLATEA,t2.TIIDESPERAPLATEA TRAMINSTIIDESPERAPLATEA,t2.TIMATARESPERA TRAMINSTIMATARESPERA,t2.TIASUNTOCOMUNICACION TRAMINSTIASUNTOCOMUNICACION,t2.TIFECHAENVIOBOPVBOE TRAMINSTIFECHAENVIOBOPVBOE,t2.TIFECHAPUBLICACIONBOPV TRAMINSTIFECHAPUBBOPV,t2.TIFECHAPUBLICACIONAYTO TRAMINSTIFECHAPUBAYTO,t2.TISEDE TRAMINSTISEDE,t2.TIFECHALIMITE TRAMINSTIFECHALIMITE,t2.TICODREM TRAMINSTICODREM,t2.TIENVREM TRAMINSTIENVREM,t2.TIFCODIGO TRAMINSTIFCODIGO,t2.TIIDMAILORIGEN TRAMINSTIIDMAILORIGEN,t2.TIMAILORIGEN TRAMINSTIMAILORIGEN,t2.TIIDMAILDESTINO TRAMINSTIIDMAILDESTINO,t2.TIMAILDESTINO TRAMINSTIMAILDESTINO,t2.TIPROCEEDINGSIDPLATEA TRAMINSTIPROCEEDINGSIDPLATEA,t2.TIACUSEREINTENTADO TRAMINSTIACUSEREINTENTADO,t2.TIAUTOMATICO TRAMINSTIAUTOMATICO,t2.TIORIGENALEGACION TRAMINSTIORIGENALEGACION,t2.TIANCODIGO TRAMINSTIANCODIGO,t2.TITIPACTUA TRAMINSTITIPACTUA,t2.TIRESPUESTARECEPCION TRAMINSTIRESPUESTARECEPCION,t2.TIRESUMENRECEPCION TRAMINSTIRESUMENRECEPCION,t2.TIFECHAREDALERTA TRAMINSTIFECHAREDALERTA,t2.TIINCLUSIREDALERTA TRAMINSTIINCLUSIREDALERTA,t2.TIMOTIVOREDALERTA TRAMINSTIMOTIVOREDALERTA,t2.TIJUSTIFICACIONINFRACCION TRAMINSTIJUSTIFFRACCION,t2.TIFECHAENVLAB TRAMINSTIFECHAENVLAB,t2.TICODMUESTRA TRAMINSTICODMUESTRA,t2.TILACODIGO TRAMINSTILACODIGO,t2.TIDETANA TRAMINSTIDETANA,t2.TIFECHARESENS TRAMINSTIFECHARESENS,t2.TICODINFENSAY TRAMINSTICODINFENSAY,t2.TIRESUDICTAM TRAMINSTIRESUDICTAM,t2.TICONSTATACION TRAMINSTICONSTATACION,t2.TIFECHADESIN TRAMINSTIFECHADESIN,t2.TINUMDESIN TRAMINSTINUMDESIN,t2.TIDESTINODESIN TRAMINSTIDESTINODESIN,t2.TIDESTRUCCIONINSITU TRAMINSTIDESTRUCCIONINSITU,t2.TIEMPRESAGEST TRAMINSTIEMPRESAGEST,t2.TINUMRECUPE TRAMINSTINUMRECUPE,t2.TINUMADESTRUIR TRAMINSTINUMADESTRUIR,t2.TINUMADEVOLVER TRAMINSTINUMADEVOLVER,t2.TIFECHAEMIINF TRAMINSTIFECHAEMIINF,t2.TIHORAINICIOEMIINF TRAMINSTIHORAINICIOEMIINF,t2.TIHORAFININF TRAMINSTIHORAFININF,t2.TIDNIINF TRAMINSTIDNIINF,t2.TINOMBREINF TRAMINSTINOMBREINF,t2.TINORA_PROVINCIA_ID TRAMINSTINORAPROVINCIAID,t2.TINOMBRE_PROVINCIA TRAMINSTINOMBREPROVINCIA,t2.TINORA_MUNICIPIO_ID TRAMINSTINORAMUNICIPIOID,t2.TINOMBRE_MUNICIPIO TRAMINSTINOMBREMUNICIPIO,t2.TINORA_LOCALIDAD_ID TRAMINSTINORALOCALIDADID,t2.TINOMBRE_LOCALIDAD TRAMINSTINOMBRELOCALIDAD,t2.TINORA_CALLE_ID TRAMINSTINORACALLEID,t2.TINOMBRE_CALLE TRAMINSTINOMBRECALLE,t2.TINORA_CP_ID TRAMINSTINORACPID,t2.TINOMBRE_CP TRAMINSTINOMBRECP,t2.TINORA_PORTAL_ID TRAMINSTINORAPORTALID,t2.TINOMBRE_PORTAL TRAMINSTINOMBREPORTAL,t2.TINOMBRE_PISO TRAMINSTINOMBREPISO,t2.TIDIRECCION_NOCAPV TRAMINSTIDIRECCIONNOCAPV,t2.TIEXTRANJERO TRAMINSTIEXTRANJERO,t2.TINORA_PAIS_ID TRAMINSTINORAPAISID,t2.TINOMBRE_PAIS TRAMINSTINOMBREPAIS,t2.TITELINF TRAMINSTITELINF,t2.TIENCONDICIONINF TRAMINSTIENCONDICIONINF,t2.TIINFORME TRAMINSTIINFORME,t2.TIVALORACION TRAMINSTIVALORACION,t2.TIFECHAACEPTACION TRAMINSTIFECHAACEPTACION,t2.TIFECHAAMPLI TRAMINSTIFECHAAMPLI,t2.TIMOTIVOAMPLI TRAMINSTIMOTIVOAMPLI,t2.TICODIGORELACIONADO TRAMINSTICODIGORELACIONADO, t2.TICOORTRASPASO TRAMINSTICOORTRASPASO, t2.TITELINF2 TRAMINSTITELINF2, t2.TICOMPDIRECCION TRAMINSTICOMPDIRECCION, t2.TIAPE1INF TRAMINSTIAPE1INF, t2.TIAPE2INF TRAMINSTIAPE2INF, t2.TIFECHAAIP TRAMINSTIFECHAAIP, t2.TIFECALTA TRAMINSTIFECALTA, t2.TIFECMODIF TRAMINSTIFECMODIF ");
		query.append("FROM TRAMITE_INSPECCION t1 ,TRAMITE_INSPECCION t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapTramitesPendientesPorTipo(tramiteinspeccion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.TICODIGORELACIONADO= t2.TICODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<TramiteInspeccion>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the TramiteInspeccion table.
	 * 
	 * @param tramiteinspeccion
	 *            TramiteInspeccion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(TramiteInspeccion tramiteinspeccion) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM TRAMITE_INSPECCION t1 , TRAMITE_INSPECCION t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tramiteinspeccion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.TICODIGORELACIONADO= t2.TICODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the TramiteInspeccion table using like.
	 * 
	 * @param tramiteinspeccion
	 *            TramiteInspeccion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TramiteInspeccion> findAllLike(TramiteInspeccion tramiteinspeccion, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TICODIGO TICODIGO,t1.TIATCODIGO TIATCODIGO,t1.TIACCODIGO TIACCODIGO,t1.TICOTEE TICOTEE,t1.TIFECHAINICIO TIFECHAINICIO,t1.TIFECHAFIN TIFECHAFIN,t1.TICOMOASIGNADO TICOMOASIGNADO,t1.TICOMOEJECUCION TICOMOEJECUCION,t1.TICOMENTARIO TICOMENTARIO,t1.TICOMODESIGNADO TICOMODESIGNADO,t1.TIDOCUMENTACIONREQUERIDA TIDOCUMENTACIONREQUERIDA,t1.TIDOCUMENTACIONREQUERIDAE TIDOCUMENTACIONREQUERIDAE,t1.TIDECODIGO TIDECODIGO,t1.TIFECHARESOLUCION TIFECHARESOLUCION,t1.TIFECHARECURSO TIFECHARECURSO,t1.TITIPORECURSO TITIPORECURSO,t1.TIABOGADO TIABOGADO,t1.TIMOTIVORECURSO TIMOTIVORECURSO,t1.TIESTIMACION TIESTIMACION,t1.TIFECHACIERRE TIFECHACIERRE,t1.TIDESTINATARIO TIDESTINATARIO,t1.TIFECHACOMUNICACION TIFECHACOMUNICACION,t1.TITIPOCOMUNICACION TITIPOCOMUNICACION,t1.TITIPONOTIFICACION TITIPONOTIFICACION,t1.TINOTIFICACIONPORACTA TINOTIFICACIONPORACTA,t1.TINUMREGISTROSALIDA TINUMREGISTROSALIDA,t1.TIFECHAREGISTROSALIDA TIFECHAREGISTROSALIDA,t1.TIACUSERECIBO TIACUSERECIBO,t1.TIACUSERECIBORECIBIDO TIACUSERECIBORECIBIDO,t1.TINUMREGISTROENTRADA TINUMREGISTROENTRADA,t1.TIFECHAREGISTROENTRADA TIFECHAREGISTROENTRADA,t1.TIIDNOTIFICACIONPLATEA TIIDNOTIFICACIONPLATEA,t1.TINOMBRETRAMITE TINOMBRETRAMITE,t1.TIIDDESTINATARIO TIIDDESTINATARIO,t1.TIESTADOTRAMITE TIESTADOTRAMITE,t1.TIREQUIEREFIRMA TIREQUIEREFIRMA,t1.TITEXTOCOMUNICACION TITEXTOCOMUNICACION,t1.TITIPONOTIFICACIONPLATEA TITIPONOTIFICACIONPLATEA,t1.TIIDESPERAPLATEA TIIDESPERAPLATEA,t1.TIMATARESPERA TIMATARESPERA,t1.TIASUNTOCOMUNICACION TIASUNTOCOMUNICACION,t1.TIFECHAENVIOBOPVBOE TIFECHAENVIOBOPVBOE,t1.TIFECHAPUBLICACIONBOPV TIFECHAPUBLICACIONBOPV,t1.TIFECHAPUBLICACIONAYTO TIFECHAPUBLICACIONAYTO,t1.TISEDE TISEDE,t1.TIFECHALIMITE TIFECHALIMITE,t1.TICODREM TICODREM,t1.TIENVREM TIENVREM,t1.TIFCODIGO TIFCODIGO,t1.TIIDMAILORIGEN TIIDMAILORIGEN,t1.TIMAILORIGEN TIMAILORIGEN,t1.TIIDMAILDESTINO TIIDMAILDESTINO,t1.TIMAILDESTINO TIMAILDESTINO,t1.TIPROCEEDINGSIDPLATEA TIPROCEEDINGSIDPLATEA,t1.TIACUSEREINTENTADO TIACUSEREINTENTADO,t1.TIAUTOMATICO TIAUTOMATICO,t1.TIORIGENALEGACION TIORIGENALEGACION,t1.TIANCODIGO TIANCODIGO,t1.TITIPACTUA TITIPACTUA,t1.TIRESPUESTARECEPCION TIRESPUESTARECEPCION,t1.TIRESUMENRECEPCION TIRESUMENRECEPCION,t1.TIFECHAREDALERTA TIFECHAREDALERTA,t1.TIINCLUSIREDALERTA TIINCLUSIREDALERTA,t1.TIMOTIVOREDALERTA TIMOTIVOREDALERTA,t1.TIJUSTIFICACIONINFRACCION TIJUSTIFICACIONINFRACCION,t1.TIFECHAENVLAB TIFECHAENVLAB,t1.TICODMUESTRA TICODMUESTRA,t1.TILACODIGO TILACODIGO,t1.TIDETANA TIDETANA,t1.TIFECHARESENS TIFECHARESENS,t1.TICODINFENSAY TICODINFENSAY,t1.TIRESUDICTAM TIRESUDICTAM,t1.TICONSTATACION TICONSTATACION,t1.TIFECHADESIN TIFECHADESIN,t1.TINUMDESIN TINUMDESIN,t1.TIDESTINODESIN TIDESTINODESIN,t1.TIDESTRUCCIONINSITU TIDESTRUCCIONINSITU,t1.TIEMPRESAGEST TIEMPRESAGEST,t1.TINUMRECUPE TINUMRECUPE,t1.TINUMADESTRUIR TINUMADESTRUIR,t1.TINUMADEVOLVER TINUMADEVOLVER,t1.TIFECHAEMIINF TIFECHAEMIINF,t1.TIHORAINICIOEMIINF TIHORAINICIOEMIINF,t1.TIHORAFININF TIHORAFININF,t1.TIDNIINF TIDNIINF,t1.TINOMBREINF TINOMBREINF,t1.TINORA_PROVINCIA_ID TINORAPROVINCIAID,t1.TINOMBRE_PROVINCIA TINOMBREPROVINCIA,t1.TINORA_MUNICIPIO_ID TINORAMUNICIPIOID,t1.TINOMBRE_MUNICIPIO TINOMBREMUNICIPIO,t1.TINORA_LOCALIDAD_ID TINORALOCALIDADID,t1.TINOMBRE_LOCALIDAD TINOMBRELOCALIDAD,t1.TINORA_CALLE_ID TINORACALLEID,t1.TINOMBRE_CALLE TINOMBRECALLE,t1.TINORA_CP_ID TINORACPID,t1.TINOMBRE_CP TINOMBRECP,t1.TINORA_PORTAL_ID TINORAPORTALID,t1.TINOMBRE_PORTAL TINOMBREPORTAL,t1.TINOMBRE_PISO TINOMBREPISO,t1.TIDIRECCION_NOCAPV TIDIRECCIONNOCAPV,t1.TIEXTRANJERO TIEXTRANJERO,t1.TINORA_PAIS_ID TINORAPAISID,t1.TINOMBRE_PAIS TINOMBREPAIS,t1.TITELINF TITELINF,t1.TIENCONDICIONINF TIENCONDICIONINF,t1.TIINFORME TIINFORME,t1.TIVALORACION TIVALORACION,t1.TIFECHAACEPTACION TIFECHAACEPTACION,t1.TIFECHAAMPLI TIFECHAAMPLI,t1.TIMOTIVOAMPLI TIMOTIVOAMPLI,t1.TINUMIN TINUMIN, t1.TIDIRECCION_NOCAPV TIDIRECCIONNOCAPV, t1.TIEXTRANJERO TIEXTRANJERO, t1.TINORA_PAIS_ID TINORAPAISID, t1.TINOMBRE_PAIS TINOMBREPAIS, t1.TITELINF TITELINF, t1.TIENCONDICIONINF TIENCONDICIONINF, t1.TIINFORME TIINFORME, t1.TIVALORACION TIVALORACION, t1.TIFECHAACEPTACION TIFECHAACEPTACION, t1.TIFECHAAMPLI TIFECHAAMPLI, t1.TIMOTIVOAMPLI TIMOTIVOAMPLI, t1.TICOALREL TICOALREL, t1.TICOORTRASPASO TICOORTRASPASO, t1.TITELINF2 TITELINF2, t1.TICOMPDIRECCION TICOMPDIRECCION, t1.TIAPE1INF TIAPE1INF, t1.TIAPE2INF, t1.TIFECHAAIP TIFECHAAIP, t1.TIFECALTA TIFECALTA, t1.TIFECMODIF TIFECMODIF, t1.TICOCR TICOCR, t1.TILIGADOPROTOCOLO TILIGADOPROTOCOLO, t1.TIISTELEMATICO  TIISTELEMATICO, t1.TIISSIR TIISSIR, t1.TIISSIRCONNUMREGENTORI TIISSIRCONNUMREGENTORI, t1.TICOCMREL TICOCMREL, t1.TICOPG TICOPG, t1.TIEXCLUIRCIERRE TIEXCLUIRCIERRE, t1.TIARCHIVAR TIARCHIVAR, t2.TICODIGO TRAMINSTICODIGO, t2.TIATCODIGO TRAMINSTIATCODIGO, t2.TIACCODIGO TRAMINSTIACCODIGO, t2.TICOTEE TRAMINSTICOTEE, t2.TIFECHAINICIO TRAMINSTIFECHAINICIO, t2.TIFECHAFIN TRAMINSTIFECHAFIN, t2.TICOMOASIGNADO TRAMINSTICOMOASIGNADO, t2.TICOMOEJECUCION TRAMINSTICOMOEJECUCION, t2.TICOMENTARIO TRAMINSTICOMENTARIO, t2.TICOMODESIGNADO TRAMINSTICOMODESIGNADO, t2.TIDOCUMENTACIONREQUERIDA TRAMINSTIDOCUREQUERIDA, t2.TIDOCUMENTACIONREQUERIDAE TRAMINSTIDOCUREQUERIDAE, t2.TIDECODIGO TRAMINSTIDECODIGO, t2.TIFECHARESOLUCION TRAMINSTIFECHARESOLUCION, t2.TIFECHARECURSO TRAMINSTIFECHARECURSO, t2.TITIPORECURSO TRAMINSTITIPORECURSO, t2.TIABOGADO TRAMINSTIABOGADO, t2.TIMOTIVORECURSO TRAMINSTIMOTIVORECURSO, t2.TIESTIMACION TRAMINSTIESTIMACION, t2.TIFECHACIERRE TRAMINSTIFECHACIERRE, t2.TIDESTINATARIO TRAMINSTIDESTINATARIO, t2.TIFECHACOMUNICACION TRAMINSTIFECHACOMUNICACION, t2.TITIPOCOMUNICACION TRAMINSTITIPOCOMUNICACION, t2.TITIPONOTIFICACION TRAMINSTITIPONOTIFICACION, t2.TINOTIFICACIONPORACTA TRAMINSTINOTIFICACIONPORACTA, t2.TINUMREGISTROSALIDA TRAMINSTINUMREGISTROSALIDA, t2.TIFECHAREGISTROSALIDA TRAMINSTIFECHAREGSALIDA, t2.TIACUSERECIBO TRAMINSTIACUSERECIBO, t2.TIACUSERECIBORECIBIDO TRAMINSTIACUSERECRECIBIDO, t2.TINUMREGISTROENTRADA TRAMINSTINUMREGISTROENTRADA, t2.TIFECHAREGISTROENTRADA TRAMINSTIFECHAREGENTRADA, t2.TIIDNOTIFICACIONPLATEA TRAMINSTIIDNOTIFPLATEA, t2.TINOMBRETRAMITE TRAMINSTINOMBRETRAMITE, t2.TIIDDESTINATARIO TRAMINSTIIDDESTINATARIO, t2.TIESTADOTRAMITE TRAMINSTIESTADOTRAMITE, t2.TIREQUIEREFIRMA TRAMINSTIREQUIEREFIRMA, t2.TITEXTOCOMUNICACION TRAMINSTITEXTOCOMUNICACION, t2.TITIPONOTIFICACIONPLATEA TRAMINSTITIPONOTIFPLATEA, t2.TIIDESPERAPLATEA TRAMINSTIIDESPERAPLATEA, t2.TIMATARESPERA TRAMINSTIMATARESPERA, t2.TIASUNTOCOMUNICACION TRAMINSTIASUNTOCOMUNICACION, t2.TIFECHAENVIOBOPVBOE TRAMINSTIFECHAENVIOBOPVBOE, t2.TIFECHAPUBLICACIONBOPV TRAMINSTIFECHAPUBBOPV, t2.TIFECHAPUBLICACIONAYTO TRAMINSTIFECHAPUBAYTO, t2.TISEDE TRAMINSTISEDE, t2.TIFECHALIMITE TRAMINSTIFECHALIMITE, t2.TICODREM TRAMINSTICODREM, t2.TIENVREM TRAMINSTIENVREM, t2.TIFCODIGO TRAMINSTIFCODIGO, t2.TIIDMAILORIGEN TRAMINSTIIDMAILORIGEN, t2.TIMAILORIGEN TRAMINSTIMAILORIGEN, t2.TIIDMAILDESTINO TRAMINSTIIDMAILDESTINO, t2.TIMAILDESTINO TRAMINSTIMAILDESTINO, t2.TIPROCEEDINGSIDPLATEA TRAMINSTIPROCEEDINGSIDPLATEA, t2.TIACUSEREINTENTADO TRAMINSTIACUSEREINTENTADO, t2.TIAUTOMATICO TRAMINSTIAUTOMATICO, t2.TIORIGENALEGACION TRAMINSTIORIGENALEGACION, t2.TIANCODIGO TRAMINSTIANCODIGO, t2.TITIPACTUA TRAMINSTITIPACTUA, t2.TIRESPUESTARECEPCION TRAMINSTIRESPUESTARECEPCION, t2.TIRESUMENRECEPCION TRAMINSTIRESUMENRECEPCION, t2.TIFECHAREDALERTA TRAMINSTIFECHAREDALERTA, t2.TIINCLUSIREDALERTA TRAMINSTIINCLUSIREDALERTA, t2.TIMOTIVOREDALERTA TRAMINSTIMOTIVOREDALERTA, t2.TIJUSTIFICACIONINFRACCION TRAMINSTIJUSTIFINFRACCION, t2.TIFECHAENVLAB TRAMINSTIFECHAENVLAB, t2.TICODMUESTRA TRAMINSTICODMUESTRA, t2.TILACODIGO TRAMINSTILACODIGO, t2.TIDETANA TRAMINSTIDETANA, t2.TIFECHARESENS TRAMINSTIFECHARESENS, t2.TICODINFENSAY TRAMINSTICODINFENSAY, t2.TIRESUDICTAM TRAMINSTIRESUDICTAM, t2.TICONSTATACION TRAMINSTICONSTATACION, t2.TIFECHADESIN  TRAMINSTIFECHADESIN, t2.TINUMDESIN TRAMINSTINUMDESIN, t2.TINUMIN TRAMINSTINUMIN, t2.TIDESTINODESIN TRAMINSTIDESTINODESIN, t2.TIDESTRUCCIONINSITU TRAMINSTIDESTRUCCIONINSITU, t2.TIEMPRESAGEST TRAMINSTIEMPRESAGEST, t2.TINUMRECUPE TRAMINSTINUMRECUPE, t2.TINUMADESTRUIR TRAMINSTINUMADESTRUIR, t2.TINUMADEVOLVER TRAMINSTINUMADEVOLVER, t2.TIFECHAEMIINF TRAMINSTIFECHAEMIINF, t2.TIHORAINICIOEMIINF TRAMINSTIHORAINICIOEMIINF, t2.TIHORAFININF TRAMINSTIHORAFININF, t2.TIDNIINF TRAMINSTIDNIINF, t2.TINOMBREINF TRAMINSTINOMBREINF, t2.TINORA_PROVINCIA_ID TRAMINSTINORAPROVINCIAID, t2.TINOMBRE_PROVINCIA TRAMINSTINOMBREPROVINCIA, t2.TICODIGO TRAMINSTICODIGO,t2.TIATCODIGO TRAMINSTIATCODIGO, t2.TIACCODIGO TRAMINSTIACCODIGO,t2.TICOTEE TRAMINSTICOTEE,t2.TIFECHAINICIO TRAMINSTIFECHAINICIO,t2.TIFECHAFIN TRAMINSTIFECHAFIN,t2.TICOMOASIGNADO TRAMINSTICOMOASIGNADO,t2.TICOMOEJECUCION TRAMINSTICOMOEJECUCION,t2.TICOMENTARIO TRAMINSTICOMENTARIO,t2.TICOMODESIGNADO TRAMINSTICOMODESIGNADO,t2.TIDOCUMENTACIONREQUERIDA TRAMINSTIDOCUREQUERIDA,t2.TIDOCUMENTACIONREQUERIDAE TRAMINSTIDOCUREQUERIDAE,t2.TIDECODIGO TRAMINSTIDECODIGO,t2.TIFECHARESOLUCION TRAMINSTIFECHARESOLUCION,t2.TIFECHARECURSO TRAMINSTIFECHARECURSO,t2.TITIPORECURSO TRAMINSTITIPORECURSO,t2.TIABOGADO TRAMINSTIABOGADO,t2.TIMOTIVORECURSO TRAMINSTIMOTIVORECURSO,t2.TIESTIMACION TRAMINSTIESTIMACION,t2.TIFECHACIERRE TRAMINSTIFECHACIERRE,t2.TIDESTINATARIO TRAMINSTIDESTINATARIO,t2.TIFECHACOMUNICACION TRAMINSTIFECHACOMUNICACION,t2.TITIPOCOMUNICACION TRAMINSTITIPOCOMUNICACION,t2.TITIPONOTIFICACION TRAMINSTITIPONOTIFICACION,t2.TINOTIFICACIONPORACTA TRAMINSTINOTIFICACIONPORACTA,t2.TINUMREGISTROSALIDA TRAMINSTINUMREGISTROSALIDA,t2.TIFECHAREGISTROSALIDA TRAMINSTIFECHAREGSALIDA,t2.TIACUSERECIBO TRAMINSTIACUSERECIBO,t2.TIACUSERECIBORECIBIDO TRAMINSTIACUSERECRECIBIDO,t2.TINUMREGISTROENTRADA TRAMINSTINUMREGISTROENTRADA,t2.TIFECHAREGISTROENTRADA TRAMINSTIFECHAREGENTRADA,t2.TIIDNOTIFICACIONPLATEA TRAMINSTIIDNOTIFPLATEA,t2.TINOMBRETRAMITE TRAMINSTINOMBRETRAMITE,t2.TIIDDESTINATARIO TRAMINSTIIDDESTINATARIO,t2.TIESTADOTRAMITE TRAMINSTIESTADOTRAMITE,t2.TIREQUIEREFIRMA TRAMINSTIREQUIEREFIRMA,t2.TITEXTOCOMUNICACION TRAMINSTITEXTOCOMUNICACION,t2.TITIPONOTIFICACIONPLATEA TRAMINSTITIPONOTIFPLATEA,t2.TIIDESPERAPLATEA TRAMINSTIIDESPERAPLATEA,t2.TIMATARESPERA TRAMINSTIMATARESPERA,t2.TIASUNTOCOMUNICACION TRAMINSTIASUNTOCOMUNICACION,t2.TIFECHAENVIOBOPVBOE TRAMINSTIFECHAENVIOBOPVBOE,t2.TIFECHAPUBLICACIONBOPV TRAMINSTIFECHAPUBBOPV,t2.TIFECHAPUBLICACIONAYTO TRAMINSTIFECHAPUBAYTO,t2.TISEDE TRAMINSTISEDE,t2.TIFECHALIMITE TRAMINSTIFECHALIMITE,t2.TICODREM TRAMINSTICODREM,t2.TIENVREM TRAMINSTIENVREM,t2.TIFCODIGO TRAMINSTIFCODIGO,t2.TIIDMAILORIGEN TRAMINSTIIDMAILORIGEN,t2.TIMAILORIGEN TRAMINSTIMAILORIGEN,t2.TIIDMAILDESTINO TRAMINSTIIDMAILDESTINO,t2.TIMAILDESTINO TRAMINSTIMAILDESTINO,t2.TIPROCEEDINGSIDPLATEA TRAMINSTIPROCEEDINGSIDPLATEA,t2.TIACUSEREINTENTADO TRAMINSTIACUSEREINTENTADO,t2.TIAUTOMATICO TRAMINSTIAUTOMATICO,t2.TIORIGENALEGACION TRAMINSTIORIGENALEGACION,t2.TIANCODIGO TRAMINSTIANCODIGO,t2.TITIPACTUA TRAMINSTITIPACTUA,t2.TIRESPUESTARECEPCION TRAMINSTIRESPUESTARECEPCION,t2.TIRESUMENRECEPCION TRAMINSTIRESUMENRECEPCION,t2.TIFECHAREDALERTA TRAMINSTIFECHAREDALERTA,t2.TIINCLUSIREDALERTA TRAMINSTIINCLUSIREDALERTA,t2.TIMOTIVOREDALERTA TRAMINSTIMOTIVOREDALERTA,t2.TIJUSTIFICACIONINFRACCION TRAMINSTIJUSTIFFRACCION,t2.TIFECHAENVLAB TRAMINSTIFECHAENVLAB,t2.TICODMUESTRA TRAMINSTICODMUESTRA,t2.TILACODIGO TRAMINSTILACODIGO,t2.TIDETANA TRAMINSTIDETANA,t2.TIFECHARESENS TRAMINSTIFECHARESENS,t2.TICODINFENSAY TRAMINSTICODINFENSAY,t2.TIRESUDICTAM TRAMINSTIRESUDICTAM,t2.TICONSTATACION TRAMINSTICONSTATACION,t2.TIFECHADESIN TRAMINSTIFECHADESIN,t2.TINUMDESIN TRAMINSTINUMDESIN,t2.TIDESTINODESIN TRAMINSTIDESTINODESIN,t2.TIDESTRUCCIONINSITU TRAMINSTIDESTRUCCIONINSITU,t2.TIEMPRESAGEST TRAMINSTIEMPRESAGEST,t2.TINUMRECUPE TRAMINSTINUMRECUPE,t2.TINUMADESTRUIR TRAMINSTINUMADESTRUIR,t2.TINUMADEVOLVER TRAMINSTINUMADEVOLVER,t2.TIFECHAEMIINF TRAMINSTIFECHAEMIINF,t2.TIHORAINICIOEMIINF TRAMINSTIHORAINICIOEMIINF,t2.TIHORAFININF TRAMINSTIHORAFININF,t2.TIDNIINF TRAMINSTIDNIINF,t2.TINOMBREINF TRAMINSTINOMBREINF,t2.TINORA_PROVINCIA_ID TRAMINSTINORAPROVINCIAID,t2.TINOMBRE_PROVINCIA TRAMINSTINOMBREPROVINCIA,t2.TINORA_MUNICIPIO_ID TRAMINSTINORAMUNICIPIOID,t2.TINOMBRE_MUNICIPIO TRAMINSTINOMBREMUNICIPIO,t2.TINORA_LOCALIDAD_ID TRAMINSTINORALOCALIDADID,t2.TINOMBRE_LOCALIDAD TRAMINSTINOMBRELOCALIDAD,t2.TINORA_CALLE_ID TRAMINSTINORACALLEID,t2.TINOMBRE_CALLE TRAMINSTINOMBRECALLE,t2.TINORA_CP_ID TRAMINSTINORACPID,t2.TINOMBRE_CP TRAMINSTINOMBRECP,t2.TINORA_PORTAL_ID TRAMINSTINORAPORTALID,t2.TINOMBRE_PORTAL TRAMINSTINOMBREPORTAL,t2.TINOMBRE_PISO TRAMINSTINOMBREPISO,t2.TIDIRECCION_NOCAPV TRAMINSTIDIRECCIONNOCAPV,t2.TIEXTRANJERO TRAMINSTIEXTRANJERO,t2.TINORA_PAIS_ID TRAMINSTINORAPAISID,t2.TINOMBRE_PAIS TRAMINSTINOMBREPAIS,t2.TITELINF TRAMINSTITELINF,t2.TIENCONDICIONINF TRAMINSTIENCONDICIONINF,t2.TIINFORME TRAMINSTIINFORME,t2.TIVALORACION TRAMINSTIVALORACION,t2.TIFECHAACEPTACION TRAMINSTIFECHAACEPTACION,t2.TIFECHAAMPLI TRAMINSTIFECHAAMPLI,t2.TIMOTIVOAMPLI TRAMINSTIMOTIVOAMPLI,t2.TICODIGORELACIONADO TRAMINSTICODIGORELACIONADO, t2.TICOORTRASPASO TRAMINSTICOORTRASPASO, t2.TITELINF2 TRAMINSTITELINF2, t2.TICOMPDIRECCION TRAMINSTICOMPDIRECCION, t2.TIAPE1INF TRAMINSTIAPE1INF, t2.TIAPE2INF TRAMINSTIAPE2INF, t2.TIFECHAAIP TRAMINSTIFECHAAIP, t2.TIFECALTA TRAMINSTIFECALTA, t2.TIFECMODIF TRAMINSTIFECMODIF ");
		query.append("FROM TRAMITE_INSPECCION t1 ,TRAMITE_INSPECCION t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tramiteinspeccion, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.TICODIGORELACIONADO= t2.TICODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<TramiteInspeccion>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the TramiteInspeccion table using like.
	 * 
	 * @param tramiteinspeccion
	 *            TramiteInspeccion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(TramiteInspeccion tramiteinspeccion, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM TRAMITE_INSPECCION t1 ,TRAMITE_INSPECCION t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tramiteinspeccion, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.TICODIGORELACIONADO= t2.TICODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TramiteInspeccion entity
	 * 
	 * @param tramiteinspeccion
	 *            TramiteInspeccion Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generacion de codigo de UDA
	private Map<String, ?> getWhereMap(TramiteInspeccion tramiteinspeccion) {

		StringBuilder where = new StringBuilder(TramiteInspeccionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tramiteinspeccion != null && tramiteinspeccion.getTicodigo() != null) {
			where.append(" AND t1.TICODIGO = ?");
			params.add(tramiteinspeccion.getTicodigo());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTicotee() != null) {
			where.append(" AND t1.TICOTEE = ?");
			params.add(tramiteinspeccion.getTicotee());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTicodigo() != null) {
			where.append(" AND t2.TICODIGO = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTicodigo());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTramiteInspeccion().getTicodigo() != null) {
			where.append(" AND t2.TICODIGORELACIONADO = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTramiteInspeccion().getTicodigo());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiatcodigo() != null) {
			where.append(" AND t2.TIATCODIGO = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTiatcodigo());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTicotee() != null) {
			where.append(" AND t2.TICOTEE = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTicotee());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifechainicio() != null) {
			where.append(" AND t2.TIFECHAINICIO = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifechainicio());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifechafin() != null) {
			where.append(" AND t2.TIFECHAFIN = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifechafin());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTicomoasignado() != null) {
			where.append(" AND t2.TICOMOASIGNADO = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTicomoasignado());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTicomoejecucion() != null) {
			where.append(" AND t2.TICOMOEJECUCION = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTicomoejecucion());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTicomodesignado() != null) {
			where.append(" AND t2.TICOMODESIGNADO = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTicomodesignado());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTidecodigo() != null) {
			where.append(" AND t2.TIDECODIGO = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTidecodigo());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifecharesolucion() != null) {
			where.append(" AND t2.TIFECHARESOLUCION = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifecharesolucion());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifecharecurso() != null) {
			where.append(" AND t2.TIFECHARECURSO = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifecharecurso());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTitiporecurso() != null) {
			where.append(" AND t2.TITIPORECURSO = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTitiporecurso());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiabogado() != null) {
			where.append(" AND t2.TIABOGADO = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTiabogado());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiestimacion() != null) {
			where.append(" AND t2.TIESTIMACION = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTiestimacion());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifechacierre() != null) {
			where.append(" AND t2.TIFECHACIERRE = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifechacierre());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTidestinatario() != null) {
			where.append(" AND t2.TIDESTINATARIO = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTidestinatario());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifechacomunicacion() != null) {
			where.append(" AND t2.TIFECHACOMUNICACION = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifechacomunicacion());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTitipocomunicacion() != null) {
			where.append(" AND t2.TITIPOCOMUNICACION = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTitipocomunicacion());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTitiponotificacion() != null) {
			where.append(" AND t2.TITIPONOTIFICACION = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTitiponotificacion());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinotificacionporacta() != null) {
			where.append(" AND t2.TINOTIFICACIONPORACTA = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTinotificacionporacta());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinumregistrosalida() != null) {
			where.append(" AND t2.TINUMREGISTROSALIDA = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTinumregistrosalida());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifecharegistrosalida() != null) {
			where.append(" AND t2.TIFECHAREGISTROSALIDA = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifecharegistrosalida());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiacuserecibo() != null) {
			where.append(" AND t2.TIACUSERECIBO = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTiacuserecibo());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiacusereciborecibido() != null) {
			where.append(" AND t2.TIACUSERECIBORECIBIDO = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTiacusereciborecibido());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinumregistroentrada() != null) {
			where.append(" AND t2.TINUMREGISTROENTRADA = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTinumregistroentrada());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifecharegistroentrada() != null) {
			where.append(" AND t2.TIFECHAREGISTROENTRADA = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifecharegistroentrada());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiidnotificacionplatea() != null) {
			where.append(" AND t2.TIIDNOTIFICACIONPLATEA = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTiidnotificacionplatea());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinombretramite() != null) {
			where.append(" AND t2.TINOMBRETRAMITE = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTinombretramite());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiiddestinatario() != null) {
			where.append(" AND t2.TIIDDESTINATARIO = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTiiddestinatario());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiestadotramite() != null) {
			where.append(" AND t2.TIESTADOTRAMITE = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTiestadotramite());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTirequierefirma() != null) {
			where.append(" AND t2.TIREQUIEREFIRMA = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTirequierefirma());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTitiponotificacionplatea() != null) {
			where.append(" AND t2.TITIPONOTIFICACIONPLATEA = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTitiponotificacionplatea());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiidesperaplatea() != null) {
			where.append(" AND t2.TIIDESPERAPLATEA = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTiidesperaplatea());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTimatarespera() != null) {
			where.append(" AND t2.TIMATARESPERA = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTimatarespera());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiasuntocomunicacion() != null) {
			where.append(" AND t2.TIASUNTOCOMUNICACION = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTiasuntocomunicacion());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifechaenviobopvboe() != null) {
			where.append(" AND t2.TIFECHAENVIOBOPVBOE = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifechaenviobopvboe());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifechapublicacionbopv() != null) {
			where.append(" AND t2.TIFECHAPUBLICACIONBOPV = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifechapublicacionbopv());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifechapublicacionayto() != null) {
			where.append(" AND t2.TIFECHAPUBLICACIONAYTO = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifechapublicacionayto());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTisede() != null) {
			where.append(" AND t2.TISEDE = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTisede());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifechalimite() != null) {
			where.append(" AND t2.TIFECHALIMITE = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifechalimite());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTicodrem() != null) {
			where.append(" AND t2.TICODREM = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTicodrem());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTienvrem() != null) {
			where.append(" AND t2.TIENVREM = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTienvrem());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifcodigo() != null) {
			where.append(" AND t2.TIFCODIGO = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifcodigo());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiidmailorigen() != null) {
			where.append(" AND t2.TIIDMAILORIGEN = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTiidmailorigen());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTimailorigen() != null) {
			where.append(" AND t2.TIMAILORIGEN = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTimailorigen());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiidmaildestino() != null) {
			where.append(" AND t2.TIIDMAILDESTINO = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTiidmaildestino());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTimaildestino() != null) {
			where.append(" AND t2.TIMAILDESTINO = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTimaildestino());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiproceedingsidplatea() != null) {
			where.append(" AND t2.TIPROCEEDINGSIDPLATEA = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTiproceedingsidplatea());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiacusereintentado() != null) {
			where.append(" AND t2.TIACUSEREINTENTADO = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTiacusereintentado());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiautomatico() != null) {
			where.append(" AND t2.TIAUTOMATICO = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTiautomatico());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiorigenalegacion() != null) {
			where.append(" AND t2.TIORIGENALEGACION = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTiorigenalegacion());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiancodigo() != null) {
			where.append(" AND t2.TIANCODIGO = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTiancodigo());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTitipactua() != null) {
			where.append(" AND t2.TITIPACTUA = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTitipactua());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTirespuestarecepcion() != null) {
			where.append(" AND t2.TIRESPUESTARECEPCION = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTirespuestarecepcion());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifecharedalerta() != null) {
			where.append(" AND t2.TIFECHAREDALERTA = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifecharedalerta());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiinclusiredalerta() != null) {
			where.append(" AND t2.TIINCLUSIREDALERTA = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTiinclusiredalerta());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifechaenvlab() != null) {
			where.append(" AND t2.TIFECHAENVLAB = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifechaenvlab());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTicodmuestra() != null) {
			where.append(" AND t2.TICODMUESTRA = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTicodmuestra());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTilacodigo() != null) {
			where.append(" AND t2.TILACODIGO = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTilacodigo());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifecharesens() != null) {
			where.append(" AND t2.TIFECHARESENS = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifecharesens());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTicodinfensay() != null) {
			where.append(" AND t2.TICODINFENSAY = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTicodinfensay());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiconstatacion() != null) {
			where.append(" AND t2.TICONSTATACION = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTiconstatacion());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifechadesin() != null) {
			where.append(" AND t2.TIFECHADESIN = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifechadesin());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinumdesin() != null) {
			where.append(" AND t2.TINUMDESIN = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTinumdesin());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTidestinodesin() != null) {
			where.append(" AND t2.TIDESTINODESIN = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTidestinodesin());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTidestruccioninsitu() != null) {
			where.append(" AND t2.TIDESTRUCCIONINSITU = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTidestruccioninsitu());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiempresagest() != null) {
			where.append(" AND t2.TIEMPRESAGEST = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTiempresagest());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinumrecupe() != null) {
			where.append(" AND t2.TINUMRECUPE = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTinumrecupe());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinumadestruir() != null) {
			where.append(" AND t2.TINUMADESTRUIR = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTinumadestruir());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinumadevolver() != null) {
			where.append(" AND t2.TINUMADEVOLVER = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTinumadevolver());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifechaemiinf() != null) {
			where.append(" AND t2.TIFECHAEMIINF = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifechaemiinf());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTihorainicioemiinf() != null) {
			where.append(" AND t2.TIHORAINICIOEMIINF = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTihorainicioemiinf());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTihorafininf() != null) {
			where.append(" AND t2.TIHORAFININF = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTihorafininf());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTidniinf() != null) {
			where.append(" AND t2.TIDNIINF = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTidniinf());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinombreinf() != null) {
			where.append(" AND t2.TINOMBREINF = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTinombreinf());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinoraProvinciaId() != null) {
			where.append(" AND t2.TINORA_PROVINCIA_ID = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTinoraProvinciaId());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinombreProvincia() != null) {
			where.append(" AND t2.TINOMBRE_PROVINCIA = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTinombreProvincia());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinoraMunicipioId() != null) {
			where.append(" AND t2.TINORA_MUNICIPIO_ID = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTinoraMunicipioId());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinombreMunicipio() != null) {
			where.append(" AND t2.TINOMBRE_MUNICIPIO = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTinombreMunicipio());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinoraLocalidadId() != null) {
			where.append(" AND t2.TINORA_LOCALIDAD_ID = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTinoraLocalidadId());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinombreLocalidad() != null) {
			where.append(" AND t2.TINOMBRE_LOCALIDAD = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTinombreLocalidad());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinoraCalleId() != null) {
			where.append(" AND t2.TINORA_CALLE_ID = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTinoraCalleId());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinombreCalle() != null) {
			where.append(" AND t2.TINOMBRE_CALLE = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTinombreCalle());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinoraCpId() != null) {
			where.append(" AND t2.TINORA_CP_ID = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTinoraCpId());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinombreCp() != null) {
			where.append(" AND t2.TINOMBRE_CP = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTinombreCp());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinoraPortalId() != null) {
			where.append(" AND t2.TINORA_PORTAL_ID = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTinoraPortalId());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinombrePortal() != null) {
			where.append(" AND t2.TINOMBRE_PORTAL = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTinombrePortal());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinombrePiso() != null) {
			where.append(" AND t2.TINOMBRE_PISO = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTinombrePiso());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTidireccionNocapv() != null) {
			where.append(" AND t2.TIDIRECCION_NOCAPV = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTidireccionNocapv());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiextranjero() != null) {
			where.append(" AND t2.TIEXTRANJERO = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTiextranjero());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinoraPaisId() != null) {
			where.append(" AND t2.TINORA_PAIS_ID = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTinoraPaisId());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinombrePais() != null) {
			where.append(" AND t2.TINOMBRE_PAIS = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTinombrePais());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTitelinf() != null) {
			where.append(" AND t2.TITELINF = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTitelinf());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiencondicioninf() != null) {
			where.append(" AND t2.TIENCONDICIONINF = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTiencondicioninf());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifechaaceptacion() != null) {
			where.append(" AND t2.TIFECHAACEPTACION = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifechaaceptacion());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifechaampli() != null) {
			where.append(" AND t2.TIFECHAAMPLI = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifechaampli());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiatcodigo() != null) {
			where.append(" AND t1.TIATCODIGO = ?");
			params.add(tramiteinspeccion.getTiatcodigo());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTicotee() != null) {
			where.append(" AND t1.TICOTEE = ?");
			params.add(tramiteinspeccion.getTicotee());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifechainicio() != null) {
			where.append(" AND t1.TIFECHAINICIO = ?");
			params.add(tramiteinspeccion.getTifechainicio());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifechafin() != null) {
			where.append(" AND t1.TIFECHAFIN = ?");
			params.add(tramiteinspeccion.getTifechafin());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTicomoasignado() != null) {
			where.append(" AND t1.TICOMOASIGNADO = ?");
			params.add(tramiteinspeccion.getTicomoasignado());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTicomoejecucion() != null) {
			where.append(" AND t1.TICOMOEJECUCION = ?");
			params.add(tramiteinspeccion.getTicomoejecucion());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTicomodesignado() != null) {
			where.append(" AND t1.TICOMODESIGNADO = ?");
			params.add(tramiteinspeccion.getTicomodesignado());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTidecodigo() != null) {
			where.append(" AND t1.TIDECODIGO = ?");
			params.add(tramiteinspeccion.getTidecodigo());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifecharesolucion() != null) {
			where.append(" AND t1.TIFECHARESOLUCION = ?");
			params.add(tramiteinspeccion.getTifecharesolucion());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifecharecurso() != null) {
			where.append(" AND t1.TIFECHARECURSO = ?");
			params.add(tramiteinspeccion.getTifecharecurso());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTitiporecurso() != null) {
			where.append(" AND t1.TITIPORECURSO = ?");
			params.add(tramiteinspeccion.getTitiporecurso());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiabogado() != null) {
			where.append(" AND t1.TIABOGADO = ?");
			params.add(tramiteinspeccion.getTiabogado());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiestimacion() != null) {
			where.append(" AND t1.TIESTIMACION = ?");
			params.add(tramiteinspeccion.getTiestimacion());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifechacierre() != null) {
			where.append(" AND t1.TIFECHACIERRE = ?");
			params.add(tramiteinspeccion.getTifechacierre());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTidestinatario() != null) {
			where.append(" AND t1.TIDESTINATARIO = ?");
			params.add(tramiteinspeccion.getTidestinatario());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifechacomunicacion() != null) {
			where.append(" AND t1.TIFECHACOMUNICACION = ?");
			params.add(tramiteinspeccion.getTifechacomunicacion());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTitipocomunicacion() != null) {
			where.append(" AND t1.TITIPOCOMUNICACION = ?");
			params.add(tramiteinspeccion.getTitipocomunicacion());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTitiponotificacion() != null) {
			where.append(" AND t1.TITIPONOTIFICACION = ?");
			params.add(tramiteinspeccion.getTitiponotificacion());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinotificacionporacta() != null) {
			where.append(" AND t1.TINOTIFICACIONPORACTA = ?");
			params.add(tramiteinspeccion.getTinotificacionporacta());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinumregistrosalida() != null) {
			where.append(" AND t1.TINUMREGISTROSALIDA = ?");
			params.add(tramiteinspeccion.getTinumregistrosalida());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifecharegistrosalida() != null) {
			where.append(" AND t1.TIFECHAREGISTROSALIDA = ?");
			params.add(tramiteinspeccion.getTifecharegistrosalida());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiacuserecibo() != null) {
			where.append(" AND t1.TIACUSERECIBO = ?");
			params.add(tramiteinspeccion.getTiacuserecibo());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiacusereciborecibido() != null) {
			where.append(" AND t1.TIACUSERECIBORECIBIDO = ?");
			params.add(tramiteinspeccion.getTiacusereciborecibido());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinumregistroentrada() != null) {
			where.append(" AND t1.TINUMREGISTROENTRADA = ?");
			params.add(tramiteinspeccion.getTinumregistroentrada());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifecharegistroentrada() != null) {
			where.append(" AND t1.TIFECHAREGISTROENTRADA = ?");
			params.add(tramiteinspeccion.getTifecharegistroentrada());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiidnotificacionplatea() != null) {
			where.append(" AND t1.TIIDNOTIFICACIONPLATEA = ?");
			params.add(tramiteinspeccion.getTiidnotificacionplatea());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinombretramite() != null) {
			where.append(" AND t1.TINOMBRETRAMITE = ?");
			params.add(tramiteinspeccion.getTinombretramite());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiiddestinatario() != null) {
			where.append(" AND t1.TIIDDESTINATARIO = ?");
			params.add(tramiteinspeccion.getTiiddestinatario());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiestadotramite() != null) {
			where.append(" AND t1.TIESTADOTRAMITE = ?");
			params.add(tramiteinspeccion.getTiestadotramite());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTirequierefirma() != null) {
			where.append(" AND t1.TIREQUIEREFIRMA = ?");
			params.add(tramiteinspeccion.getTirequierefirma());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTitiponotificacionplatea() != null) {
			where.append(" AND t1.TITIPONOTIFICACIONPLATEA = ?");
			params.add(tramiteinspeccion.getTitiponotificacionplatea());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiidesperaplatea() != null) {
			where.append(" AND t1.TIIDESPERAPLATEA = ?");
			params.add(tramiteinspeccion.getTiidesperaplatea());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTimatarespera() != null) {
			where.append(" AND t1.TIMATARESPERA = ?");
			params.add(tramiteinspeccion.getTimatarespera());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiasuntocomunicacion() != null) {
			where.append(" AND t1.TIASUNTOCOMUNICACION = ?");
			params.add(tramiteinspeccion.getTiasuntocomunicacion());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifechaenviobopvboe() != null) {
			where.append(" AND t1.TIFECHAENVIOBOPVBOE = ?");
			params.add(tramiteinspeccion.getTifechaenviobopvboe());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifechapublicacionbopv() != null) {
			where.append(" AND t1.TIFECHAPUBLICACIONBOPV = ?");
			params.add(tramiteinspeccion.getTifechapublicacionbopv());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifechapublicacionayto() != null) {
			where.append(" AND t1.TIFECHAPUBLICACIONAYTO = ?");
			params.add(tramiteinspeccion.getTifechapublicacionayto());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTisede() != null) {
			where.append(" AND t1.TISEDE = ?");
			params.add(tramiteinspeccion.getTisede());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifechalimite() != null) {
			where.append(" AND t1.TIFECHALIMITE = ?");
			params.add(tramiteinspeccion.getTifechalimite());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTicodrem() != null) {
			where.append(" AND t1.TICODREM = ?");
			params.add(tramiteinspeccion.getTicodrem());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTienvrem() != null) {
			where.append(" AND t1.TIENVREM = ?");
			params.add(tramiteinspeccion.getTienvrem());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifcodigo() != null) {
			where.append(" AND t1.TIFCODIGO = ?");
			params.add(tramiteinspeccion.getTifcodigo());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiidmailorigen() != null) {
			where.append(" AND t1.TIIDMAILORIGEN = ?");
			params.add(tramiteinspeccion.getTiidmailorigen());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTimailorigen() != null) {
			where.append(" AND t1.TIMAILORIGEN = ?");
			params.add(tramiteinspeccion.getTimailorigen());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiidmaildestino() != null) {
			where.append(" AND t1.TIIDMAILDESTINO = ?");
			params.add(tramiteinspeccion.getTiidmaildestino());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTimaildestino() != null) {
			where.append(" AND t1.TIMAILDESTINO = ?");
			params.add(tramiteinspeccion.getTimaildestino());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiproceedingsidplatea() != null) {
			where.append(" AND t1.TIPROCEEDINGSIDPLATEA = ?");
			params.add(tramiteinspeccion.getTiproceedingsidplatea());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiacusereintentado() != null) {
			where.append(" AND t1.TIACUSEREINTENTADO = ?");
			params.add(tramiteinspeccion.getTiacusereintentado());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiautomatico() != null) {
			where.append(" AND t1.TIAUTOMATICO = ?");
			params.add(tramiteinspeccion.getTiautomatico());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiorigenalegacion() != null) {
			where.append(" AND t1.TIORIGENALEGACION = ?");
			params.add(tramiteinspeccion.getTiorigenalegacion());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiancodigo() != null) {
			where.append(" AND t1.TIANCODIGO = ?");
			params.add(tramiteinspeccion.getTiancodigo());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTitipactua() != null) {
			where.append(" AND t1.TITIPACTUA = ?");
			params.add(tramiteinspeccion.getTitipactua());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTirespuestarecepcion() != null) {
			where.append(" AND t1.TIRESPUESTARECEPCION = ?");
			params.add(tramiteinspeccion.getTirespuestarecepcion());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifecharedalerta() != null) {
			where.append(" AND t1.TIFECHAREDALERTA = ?");
			params.add(tramiteinspeccion.getTifecharedalerta());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiinclusiredalerta() != null) {
			where.append(" AND t1.TIINCLUSIREDALERTA = ?");
			params.add(tramiteinspeccion.getTiinclusiredalerta());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifechaenvlab() != null) {
			where.append(" AND t1.TIFECHAENVLAB = ?");
			params.add(tramiteinspeccion.getTifechaenvlab());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTicodmuestra() != null) {
			where.append(" AND t1.TICODMUESTRA = ?");
			params.add(tramiteinspeccion.getTicodmuestra());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTilacodigo() != null) {
			where.append(" AND t1.TILACODIGO = ?");
			params.add(tramiteinspeccion.getTilacodigo());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifecharesens() != null) {
			where.append(" AND t1.TIFECHARESENS = ?");
			params.add(tramiteinspeccion.getTifecharesens());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTicodinfensay() != null) {
			where.append(" AND t1.TICODINFENSAY = ?");
			params.add(tramiteinspeccion.getTicodinfensay());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiconstatacion() != null) {
			where.append(" AND t1.TICONSTATACION = ?");
			params.add(tramiteinspeccion.getTiconstatacion());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifechadesin() != null) {
			where.append(" AND t1.TIFECHADESIN = ?");
			params.add(tramiteinspeccion.getTifechadesin());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinumdesin() != null) {
			where.append(" AND t1.TINUMDESIN = ?");
			params.add(tramiteinspeccion.getTinumdesin());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTidestinodesin() != null) {
			where.append(" AND t1.TIDESTINODESIN = ?");
			params.add(tramiteinspeccion.getTidestinodesin());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTidestruccioninsitu() != null) {
			where.append(" AND t1.TIDESTRUCCIONINSITU = ?");
			params.add(tramiteinspeccion.getTidestruccioninsitu());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiempresagest() != null) {
			where.append(" AND t1.TIEMPRESAGEST = ?");
			params.add(tramiteinspeccion.getTiempresagest());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinumrecupe() != null) {
			where.append(" AND t1.TINUMRECUPE = ?");
			params.add(tramiteinspeccion.getTinumrecupe());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinumadestruir() != null) {
			where.append(" AND t1.TINUMADESTRUIR = ?");
			params.add(tramiteinspeccion.getTinumadestruir());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinumadevolver() != null) {
			where.append(" AND t1.TINUMADEVOLVER = ?");
			params.add(tramiteinspeccion.getTinumadevolver());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifechaemiinf() != null) {
			where.append(" AND t1.TIFECHAEMIINF = ?");
			params.add(tramiteinspeccion.getTifechaemiinf());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTihorainicioemiinf() != null) {
			where.append(" AND t1.TIHORAINICIOEMIINF = ?");
			params.add(tramiteinspeccion.getTihorainicioemiinf());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTihorafininf() != null) {
			where.append(" AND t1.TIHORAFININF = ?");
			params.add(tramiteinspeccion.getTihorafininf());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTidniinf() != null) {
			where.append(" AND t1.TIDNIINF = ?");
			params.add(tramiteinspeccion.getTidniinf());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinombreinf() != null) {
			where.append(" AND t1.TINOMBREINF = ?");
			params.add(tramiteinspeccion.getTinombreinf());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinoraProvinciaId() != null) {
			where.append(" AND t1.TINORA_PROVINCIA_ID = ?");
			params.add(tramiteinspeccion.getTinoraProvinciaId());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinombreProvincia() != null) {
			where.append(" AND t1.TINOMBRE_PROVINCIA = ?");
			params.add(tramiteinspeccion.getTinombreProvincia());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinoraMunicipioId() != null) {
			where.append(" AND t1.TINORA_MUNICIPIO_ID = ?");
			params.add(tramiteinspeccion.getTinoraMunicipioId());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinombreMunicipio() != null) {
			where.append(" AND t1.TINOMBRE_MUNICIPIO = ?");
			params.add(tramiteinspeccion.getTinombreMunicipio());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinoraLocalidadId() != null) {
			where.append(" AND t1.TINORA_LOCALIDAD_ID = ?");
			params.add(tramiteinspeccion.getTinoraLocalidadId());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinombreLocalidad() != null) {
			where.append(" AND t1.TINOMBRE_LOCALIDAD = ?");
			params.add(tramiteinspeccion.getTinombreLocalidad());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinoraCalleId() != null) {
			where.append(" AND t1.TINORA_CALLE_ID = ?");
			params.add(tramiteinspeccion.getTinoraCalleId());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinombreCalle() != null) {
			where.append(" AND t1.TINOMBRE_CALLE = ?");
			params.add(tramiteinspeccion.getTinombreCalle());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinoraCpId() != null) {
			where.append(" AND t1.TINORA_CP_ID = ?");
			params.add(tramiteinspeccion.getTinoraCpId());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinombreCp() != null) {
			where.append(" AND t1.TINOMBRE_CP = ?");
			params.add(tramiteinspeccion.getTinombreCp());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinoraPortalId() != null) {
			where.append(" AND t1.TINORA_PORTAL_ID = ?");
			params.add(tramiteinspeccion.getTinoraPortalId());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinombrePortal() != null) {
			where.append(" AND t1.TINOMBRE_PORTAL = ?");
			params.add(tramiteinspeccion.getTinombrePortal());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinombrePiso() != null) {
			where.append(" AND t1.TINOMBRE_PISO = ?");
			params.add(tramiteinspeccion.getTinombrePiso());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTidireccionNocapv() != null) {
			where.append(" AND t1.TIDIRECCION_NOCAPV = ?");
			params.add(tramiteinspeccion.getTidireccionNocapv());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiextranjero() != null) {
			where.append(" AND t1.TIEXTRANJERO = ?");
			params.add(tramiteinspeccion.getTiextranjero());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinoraPaisId() != null) {
			where.append(" AND t1.TINORA_PAIS_ID = ?");
			params.add(tramiteinspeccion.getTinoraPaisId());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinombrePais() != null) {
			where.append(" AND t1.TINOMBRE_PAIS = ?");
			params.add(tramiteinspeccion.getTinombrePais());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTitelinf() != null) {
			where.append(" AND t1.TITELINF = ?");
			params.add(tramiteinspeccion.getTitelinf());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiencondicioninf() != null) {
			where.append(" AND t1.TIENCONDICIONINF = ?");
			params.add(tramiteinspeccion.getTiencondicioninf());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifechaaceptacion() != null) {
			where.append(" AND t1.TIFECHAACEPTACION = ?");
			params.add(tramiteinspeccion.getTifechaaceptacion());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifechaampli() != null) {
			where.append(" AND t1.TIFECHAAMPLI = ?");
			params.add(tramiteinspeccion.getTifechaampli());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiaccodigo() != null) {
			where.append(" AND t1.TIACCODIGO = ?");
			params.add(tramiteinspeccion.getTiaccodigo());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TramiteInspeccion entity
	 * 
	 * @param tramiteinspeccion
	 *            TramiteInspeccion Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generacion de codigo de UDA
	private Map<String, ?> getWhereMapTramitesPendientesPorTipo(TramiteInspeccion tramiteinspeccion) {

		StringBuilder where = new StringBuilder(TramiteInspeccionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tramiteinspeccion != null && tramiteinspeccion.getTicotee() != null) {
			where.append(" AND t1.TICOTEE = ?");
			params.add(tramiteinspeccion.getTicotee());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiatcodigo() != null) {
			where.append(" AND t1.TIATCODIGO = ?");
			params.add(tramiteinspeccion.getTiatcodigo());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiaccodigo() != null
				&& !tramiteinspeccion.getTiaccodigo().equals("")) {
			where.append(" AND t1.TIACCODIGO = ?");
			params.add(tramiteinspeccion.getTiaccodigo());
		}

		where.append(" AND t1.TIFECHAINICIO IS NOT NULL AND t1.TIFECHAFIN IS NULL ");

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TramiteInspeccion entity
	 * 
	 * @param tramiteinspeccion
	 *            TramiteInspeccion Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(TramiteInspeccion tramiteinspeccion, Boolean startsWith) {

		StringBuilder where = new StringBuilder(TramiteInspeccionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tramiteinspeccion != null && tramiteinspeccion.getTicodigo() != null) {
			where.append(" AND UPPER(t1.TICODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTicodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTicodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.TICODIGO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTicodigo() != null) {
			where.append(" AND t2.TICODIGO = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTicodigo());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTramiteInspeccion().getTicodigo() != null) {
			where.append(" AND UPPER(t2.TICODIGORELACIONADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTramiteInspeccion().getTicodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tramiteinspeccion.getTramiteInspeccion().getTramiteInspeccion().getTicodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.TICODIGORELACIONADO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiatcodigo() != null) {
			where.append(" AND UPPER(t2.TIATCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTiatcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTiatcodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.TIATCODIGO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTicotee() != null) {
			where.append(" AND UPPER(t2.TICOTEE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTicotee().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTicotee().toUpperCase() + "%");
			}
			where.append(" AND t2.TICOTEE IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifechainicio() != null) {
			where.append(" AND t2.TIFECHAINICIO = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifechainicio());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifechafin() != null) {
			where.append(" AND t2.TIFECHAFIN = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifechafin());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTicomoasignado() != null) {
			where.append(" AND UPPER(t2.TICOMOASIGNADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTicomoasignado().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTicomoasignado().toUpperCase() + "%");
			}
			where.append(" AND t2.TICOMOASIGNADO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTicomoejecucion() != null) {
			where.append(" AND UPPER(t2.TICOMOEJECUCION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTicomoejecucion().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTicomoejecucion().toUpperCase() + "%");
			}
			where.append(" AND t2.TICOMOEJECUCION IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTicomodesignado() != null) {
			where.append(" AND UPPER(t2.TICOMODESIGNADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTicomodesignado().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTicomodesignado().toUpperCase() + "%");
			}
			where.append(" AND t2.TICOMODESIGNADO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTidecodigo() != null) {
			where.append(" AND UPPER(t2.TIDECODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTidecodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTidecodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.TIDECODIGO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifecharesolucion() != null) {
			where.append(" AND t2.TIFECHARESOLUCION = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifecharesolucion());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifecharecurso() != null) {
			where.append(" AND t2.TIFECHARECURSO = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifecharecurso());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTitiporecurso() != null) {
			where.append(" AND UPPER(t2.TITIPORECURSO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTitiporecurso().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTitiporecurso().toUpperCase() + "%");
			}
			where.append(" AND t2.TITIPORECURSO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiabogado() != null) {
			where.append(" AND UPPER(t2.TIABOGADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTiabogado().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTiabogado().toUpperCase() + "%");
			}
			where.append(" AND t2.TIABOGADO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiestimacion() != null) {
			where.append(" AND UPPER(t2.TIESTIMACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTiestimacion().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTiestimacion().toUpperCase() + "%");
			}
			where.append(" AND t2.TIESTIMACION IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifechacierre() != null) {
			where.append(" AND t2.TIFECHACIERRE = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifechacierre());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTidestinatario() != null) {
			where.append(" AND UPPER(t2.TIDESTINATARIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTidestinatario().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTidestinatario().toUpperCase() + "%");
			}
			where.append(" AND t2.TIDESTINATARIO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifechacomunicacion() != null) {
			where.append(" AND t2.TIFECHACOMUNICACION = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifechacomunicacion());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTitipocomunicacion() != null) {
			where.append(" AND UPPER(t2.TITIPOCOMUNICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTitipocomunicacion().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTitipocomunicacion().toUpperCase() + "%");
			}
			where.append(" AND t2.TITIPOCOMUNICACION IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTitiponotificacion() != null) {
			where.append(" AND UPPER(t2.TITIPONOTIFICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTitiponotificacion().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTitiponotificacion().toUpperCase() + "%");
			}
			where.append(" AND t2.TITIPONOTIFICACION IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinotificacionporacta() != null) {
			where.append(" AND UPPER(t2.TINOTIFICACIONPORACTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTinotificacionporacta().toUpperCase() + "%");
			} else {
				params.add(
						"%" + tramiteinspeccion.getTramiteInspeccion().getTinotificacionporacta().toUpperCase() + "%");
			}
			where.append(" AND t2.TINOTIFICACIONPORACTA IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinumregistrosalida() != null) {
			where.append(" AND UPPER(t2.TINUMREGISTROSALIDA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTinumregistrosalida().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTinumregistrosalida().toUpperCase() + "%");
			}
			where.append(" AND t2.TINUMREGISTROSALIDA IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifecharegistrosalida() != null) {
			where.append(" AND t2.TIFECHAREGISTROSALIDA = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifecharegistrosalida());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiacuserecibo() != null) {
			where.append(" AND t2.TIACUSERECIBO = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTiacuserecibo());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiacusereciborecibido() != null) {
			where.append(" AND UPPER(t2.TIACUSERECIBORECIBIDO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTiacusereciborecibido().toUpperCase() + "%");
			} else {
				params.add(
						"%" + tramiteinspeccion.getTramiteInspeccion().getTiacusereciborecibido().toUpperCase() + "%");
			}
			where.append(" AND t2.TIACUSERECIBORECIBIDO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinumregistroentrada() != null) {
			where.append(" AND UPPER(t2.TINUMREGISTROENTRADA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTinumregistroentrada().toUpperCase() + "%");
			} else {
				params.add(
						"%" + tramiteinspeccion.getTramiteInspeccion().getTinumregistroentrada().toUpperCase() + "%");
			}
			where.append(" AND t2.TINUMREGISTROENTRADA IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifecharegistroentrada() != null) {
			where.append(" AND t2.TIFECHAREGISTROENTRADA = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifecharegistroentrada());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiidnotificacionplatea() != null) {
			where.append(" AND UPPER(t2.TIIDNOTIFICACIONPLATEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTiidnotificacionplatea().toUpperCase() + "%");
			} else {
				params.add(
						"%" + tramiteinspeccion.getTramiteInspeccion().getTiidnotificacionplatea().toUpperCase() + "%");
			}
			where.append(" AND t2.TIIDNOTIFICACIONPLATEA IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinombretramite() != null) {
			where.append(" AND UPPER(t2.TINOMBRETRAMITE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTinombretramite().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTinombretramite().toUpperCase() + "%");
			}
			where.append(" AND t2.TINOMBRETRAMITE IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiiddestinatario() != null) {
			where.append(" AND UPPER(t2.TIIDDESTINATARIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTiiddestinatario().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTiiddestinatario().toUpperCase() + "%");
			}
			where.append(" AND t2.TIIDDESTINATARIO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiestadotramite() != null) {
			where.append(" AND UPPER(t2.TIESTADOTRAMITE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTiestadotramite().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTiestadotramite().toUpperCase() + "%");
			}
			where.append(" AND t2.TIESTADOTRAMITE IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTirequierefirma() != null) {
			where.append(" AND UPPER(t2.TIREQUIEREFIRMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTirequierefirma().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTirequierefirma().toUpperCase() + "%");
			}
			where.append(" AND t2.TIREQUIEREFIRMA IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTitiponotificacionplatea() != null) {
			where.append(" AND UPPER(t2.TITIPONOTIFICACIONPLATEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTitiponotificacionplatea().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTitiponotificacionplatea().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.TITIPONOTIFICACIONPLATEA IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiidesperaplatea() != null) {
			where.append(" AND UPPER(t2.TIIDESPERAPLATEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTiidesperaplatea().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTiidesperaplatea().toUpperCase() + "%");
			}
			where.append(" AND t2.TIIDESPERAPLATEA IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTimatarespera() != null) {
			where.append(" AND UPPER(t2.TIMATARESPERA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTimatarespera().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTimatarespera().toUpperCase() + "%");
			}
			where.append(" AND t2.TIMATARESPERA IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiasuntocomunicacion() != null) {
			where.append(" AND UPPER(t2.TIASUNTOCOMUNICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTiasuntocomunicacion().toUpperCase() + "%");
			} else {
				params.add(
						"%" + tramiteinspeccion.getTramiteInspeccion().getTiasuntocomunicacion().toUpperCase() + "%");
			}
			where.append(" AND t2.TIASUNTOCOMUNICACION IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifechaenviobopvboe() != null) {
			where.append(" AND t2.TIFECHAENVIOBOPVBOE = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifechaenviobopvboe());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifechapublicacionbopv() != null) {
			where.append(" AND t2.TIFECHAPUBLICACIONBOPV = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifechapublicacionbopv());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifechapublicacionayto() != null) {
			where.append(" AND t2.TIFECHAPUBLICACIONAYTO = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifechapublicacionayto());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTisede() != null) {
			where.append(" AND UPPER(t2.TISEDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTisede().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTisede().toUpperCase() + "%");
			}
			where.append(" AND t2.TISEDE IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifechalimite() != null) {
			where.append(" AND t2.TIFECHALIMITE = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifechalimite());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTicodrem() != null) {
			where.append(" AND UPPER(t2.TICODREM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTicodrem().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTicodrem().toUpperCase() + "%");
			}
			where.append(" AND t2.TICODREM IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTienvrem() != null) {
			where.append(" AND UPPER(t2.TIENVREM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTienvrem().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTienvrem().toUpperCase() + "%");
			}
			where.append(" AND t2.TIENVREM IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifcodigo() != null) {
			where.append(" AND UPPER(t2.TIFCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTifcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTifcodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.TIFCODIGO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiidmailorigen() != null) {
			where.append(" AND UPPER(t2.TIIDMAILORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTiidmailorigen().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTiidmailorigen().toUpperCase() + "%");
			}
			where.append(" AND t2.TIIDMAILORIGEN IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTimailorigen() != null) {
			where.append(" AND UPPER(t2.TIMAILORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTimailorigen().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTimailorigen().toUpperCase() + "%");
			}
			where.append(" AND t2.TIMAILORIGEN IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiidmaildestino() != null) {
			where.append(" AND UPPER(t2.TIIDMAILDESTINO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTiidmaildestino().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTiidmaildestino().toUpperCase() + "%");
			}
			where.append(" AND t2.TIIDMAILDESTINO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTimaildestino() != null) {
			where.append(" AND UPPER(t2.TIMAILDESTINO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTimaildestino().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTimaildestino().toUpperCase() + "%");
			}
			where.append(" AND t2.TIMAILDESTINO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiproceedingsidplatea() != null) {
			where.append(" AND UPPER(t2.TIPROCEEDINGSIDPLATEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTiproceedingsidplatea().toUpperCase() + "%");
			} else {
				params.add(
						"%" + tramiteinspeccion.getTramiteInspeccion().getTiproceedingsidplatea().toUpperCase() + "%");
			}
			where.append(" AND t2.TIPROCEEDINGSIDPLATEA IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiacusereintentado() != null) {
			where.append(" AND UPPER(t2.TIACUSEREINTENTADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTiacusereintentado().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTiacusereintentado().toUpperCase() + "%");
			}
			where.append(" AND t2.TIACUSEREINTENTADO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiautomatico() != null) {
			where.append(" AND UPPER(t2.TIAUTOMATICO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTiautomatico().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTiautomatico().toUpperCase() + "%");
			}
			where.append(" AND t2.TIAUTOMATICO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiorigenalegacion() != null) {
			where.append(" AND UPPER(t2.TIORIGENALEGACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTiorigenalegacion().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTiorigenalegacion().toUpperCase() + "%");
			}
			where.append(" AND t2.TIORIGENALEGACION IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiancodigo() != null) {
			where.append(" AND UPPER(t2.TIANCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTiancodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTiancodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.TIANCODIGO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTitipactua() != null) {
			where.append(" AND UPPER(t2.TITIPACTUA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTitipactua().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTitipactua().toUpperCase() + "%");
			}
			where.append(" AND t2.TITIPACTUA IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTirespuestarecepcion() != null) {
			where.append(" AND UPPER(t2.TIRESPUESTARECEPCION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTirespuestarecepcion().toUpperCase() + "%");
			} else {
				params.add(
						"%" + tramiteinspeccion.getTramiteInspeccion().getTirespuestarecepcion().toUpperCase() + "%");
			}
			where.append(" AND t2.TIRESPUESTARECEPCION IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifecharedalerta() != null) {
			where.append(" AND t2.TIFECHAREDALERTA = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifecharedalerta());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiinclusiredalerta() != null) {
			where.append(" AND UPPER(t2.TIINCLUSIREDALERTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTiinclusiredalerta().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTiinclusiredalerta().toUpperCase() + "%");
			}
			where.append(" AND t2.TIINCLUSIREDALERTA IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifechaenvlab() != null) {
			where.append(" AND t2.TIFECHAENVLAB = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifechaenvlab());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTicodmuestra() != null) {
			where.append(" AND UPPER(t2.TICODMUESTRA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTicodmuestra().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTicodmuestra().toUpperCase() + "%");
			}
			where.append(" AND t2.TICODMUESTRA IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTilacodigo() != null) {
			where.append(" AND UPPER(t2.TILACODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTilacodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTilacodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.TILACODIGO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifecharesens() != null) {
			where.append(" AND t2.TIFECHARESENS = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifecharesens());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTicodinfensay() != null) {
			where.append(" AND UPPER(t2.TICODINFENSAY) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTicodinfensay().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTicodinfensay().toUpperCase() + "%");
			}
			where.append(" AND t2.TICODINFENSAY IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiconstatacion() != null) {
			where.append(" AND UPPER(t2.TICONSTATACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTiconstatacion().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTiconstatacion().toUpperCase() + "%");
			}
			where.append(" AND t2.TICONSTATACION IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifechadesin() != null) {
			where.append(" AND t2.TIFECHADESIN = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifechadesin());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinumdesin() != null) {
			where.append(" AND UPPER(t2.TINUMDESIN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTinumdesin().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTinumdesin().toUpperCase() + "%");
			}
			where.append(" AND t2.TINUMDESIN IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTidestinodesin() != null) {
			where.append(" AND UPPER(t2.TIDESTINODESIN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTidestinodesin().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTidestinodesin().toUpperCase() + "%");
			}
			where.append(" AND t2.TIDESTINODESIN IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTidestruccioninsitu() != null) {
			where.append(" AND UPPER(t2.TIDESTRUCCIONINSITU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTidestruccioninsitu().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTidestruccioninsitu().toUpperCase() + "%");
			}
			where.append(" AND t2.TIDESTRUCCIONINSITU IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiempresagest() != null) {
			where.append(" AND UPPER(t2.TIEMPRESAGEST) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTiempresagest().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTiempresagest().toUpperCase() + "%");
			}
			where.append(" AND t2.TIEMPRESAGEST IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinumrecupe() != null) {
			where.append(" AND UPPER(t2.TINUMRECUPE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTinumrecupe().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTinumrecupe().toUpperCase() + "%");
			}
			where.append(" AND t2.TINUMRECUPE IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinumadestruir() != null) {
			where.append(" AND UPPER(t2.TINUMADESTRUIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTinumadestruir().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTinumadestruir().toUpperCase() + "%");
			}
			where.append(" AND t2.TINUMADESTRUIR IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinumadevolver() != null) {
			where.append(" AND UPPER(t2.TINUMADEVOLVER) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTinumadevolver().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTinumadevolver().toUpperCase() + "%");
			}
			where.append(" AND t2.TINUMADEVOLVER IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifechaemiinf() != null) {
			where.append(" AND t2.TIFECHAEMIINF = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifechaemiinf());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTihorainicioemiinf() != null) {
			where.append(" AND UPPER(t2.TIHORAINICIOEMIINF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTihorainicioemiinf().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTihorainicioemiinf().toUpperCase() + "%");
			}
			where.append(" AND t2.TIHORAINICIOEMIINF IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTihorafininf() != null) {
			where.append(" AND UPPER(t2.TIHORAFININF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTihorafininf().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTihorafininf().toUpperCase() + "%");
			}
			where.append(" AND t2.TIHORAFININF IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTidniinf() != null) {
			where.append(" AND UPPER(t2.TIDNIINF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTidniinf().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTidniinf().toUpperCase() + "%");
			}
			where.append(" AND t2.TIDNIINF IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinombreinf() != null) {
			where.append(" AND UPPER(t2.TINOMBREINF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTinombreinf().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTinombreinf().toUpperCase() + "%");
			}
			where.append(" AND t2.TINOMBREINF IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinoraProvinciaId() != null) {
			where.append(" AND UPPER(t2.TINORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTinoraProvinciaId().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTinoraProvinciaId().toUpperCase() + "%");
			}
			where.append(" AND t2.TINORA_PROVINCIA_ID IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinombreProvincia() != null) {
			where.append(" AND UPPER(t2.TINOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTinombreProvincia().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTinombreProvincia().toUpperCase() + "%");
			}
			where.append(" AND t2.TINOMBRE_PROVINCIA IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinoraMunicipioId() != null) {
			where.append(" AND UPPER(t2.TINORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTinoraMunicipioId().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTinoraMunicipioId().toUpperCase() + "%");
			}
			where.append(" AND t2.TINORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinombreMunicipio() != null) {
			where.append(" AND UPPER(t2.TINOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTinombreMunicipio().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTinombreMunicipio().toUpperCase() + "%");
			}
			where.append(" AND t2.TINOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinoraLocalidadId() != null) {
			where.append(" AND UPPER(t2.TINORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTinoraLocalidadId().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTinoraLocalidadId().toUpperCase() + "%");
			}
			where.append(" AND t2.TINORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinombreLocalidad() != null) {
			where.append(" AND UPPER(t2.TINOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTinombreLocalidad().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTinombreLocalidad().toUpperCase() + "%");
			}
			where.append(" AND t2.TINOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinoraCalleId() != null) {
			where.append(" AND UPPER(t2.TINORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTinoraCalleId().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTinoraCalleId().toUpperCase() + "%");
			}
			where.append(" AND t2.TINORA_CALLE_ID IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinombreCalle() != null) {
			where.append(" AND UPPER(t2.TINOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTinombreCalle().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTinombreCalle().toUpperCase() + "%");
			}
			where.append(" AND t2.TINOMBRE_CALLE IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinoraCpId() != null) {
			where.append(" AND UPPER(t2.TINORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTinoraCpId().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTinoraCpId().toUpperCase() + "%");
			}
			where.append(" AND t2.TINORA_CP_ID IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinombreCp() != null) {
			where.append(" AND UPPER(t2.TINOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTinombreCp().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTinombreCp().toUpperCase() + "%");
			}
			where.append(" AND t2.TINOMBRE_CP IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinoraPortalId() != null) {
			where.append(" AND UPPER(t2.TINORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTinoraPortalId().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTinoraPortalId().toUpperCase() + "%");
			}
			where.append(" AND t2.TINORA_PORTAL_ID IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinombrePortal() != null) {
			where.append(" AND UPPER(t2.TINOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTinombrePortal().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTinombrePortal().toUpperCase() + "%");
			}
			where.append(" AND t2.TINOMBRE_PORTAL IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinombrePiso() != null) {
			where.append(" AND UPPER(t2.TINOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTinombrePiso().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTinombrePiso().toUpperCase() + "%");
			}
			where.append(" AND t2.TINOMBRE_PISO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTidireccionNocapv() != null) {
			where.append(" AND UPPER(t2.TIDIRECCION_NOCAPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTidireccionNocapv().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTidireccionNocapv().toUpperCase() + "%");
			}
			where.append(" AND t2.TIDIRECCION_NOCAPV IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiextranjero() != null) {
			where.append(" AND UPPER(t2.TIEXTRANJERO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTiextranjero().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTiextranjero().toUpperCase() + "%");
			}
			where.append(" AND t2.TIEXTRANJERO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinoraPaisId() != null) {
			where.append(" AND UPPER(t2.TINORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTinoraPaisId().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTinoraPaisId().toUpperCase() + "%");
			}
			where.append(" AND t2.TINORA_PAIS_ID IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTinombrePais() != null) {
			where.append(" AND UPPER(t2.TINOMBRE_PAIS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTinombrePais().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTinombrePais().toUpperCase() + "%");
			}
			where.append(" AND t2.TINOMBRE_PAIS IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTitelinf() != null) {
			where.append(" AND UPPER(t2.TITELINF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTitelinf().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTitelinf().toUpperCase() + "%");
			}
			where.append(" AND t2.TITELINF IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTiencondicioninf() != null) {
			where.append(" AND UPPER(t2.TIENCONDICIONINF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTramiteInspeccion().getTiencondicioninf().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTramiteInspeccion().getTiencondicioninf().toUpperCase() + "%");
			}
			where.append(" AND t2.TIENCONDICIONINF IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifechaaceptacion() != null) {
			where.append(" AND t2.TIFECHAACEPTACION = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifechaaceptacion());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
				&& tramiteinspeccion.getTramiteInspeccion().getTifechaampli() != null) {
			where.append(" AND t2.TIFECHAAMPLI = ?");
			params.add(tramiteinspeccion.getTramiteInspeccion().getTifechaampli());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiatcodigo() != null) {
			where.append(" AND UPPER(t1.TIATCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTiatcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTiatcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.TIATCODIGO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTicotee() != null) {
			where.append(" AND UPPER(t1.TICOTEE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTicotee().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTicotee().toUpperCase() + "%");
			}
			where.append(" AND t1.TICOTEE IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifechainicio() != null) {
			where.append(" AND t1.TIFECHAINICIO = ?");
			params.add(tramiteinspeccion.getTifechainicio());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifechafin() != null) {
			where.append(" AND t1.TIFECHAFIN = ?");
			params.add(tramiteinspeccion.getTifechafin());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTicomoasignado() != null) {
			where.append(" AND UPPER(t1.TICOMOASIGNADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTicomoasignado().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTicomoasignado().toUpperCase() + "%");
			}
			where.append(" AND t1.TICOMOASIGNADO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTicomoejecucion() != null) {
			where.append(" AND UPPER(t1.TICOMOEJECUCION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTicomoejecucion().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTicomoejecucion().toUpperCase() + "%");
			}
			where.append(" AND t1.TICOMOEJECUCION IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTicomodesignado() != null) {
			where.append(" AND UPPER(t1.TICOMODESIGNADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTicomodesignado().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTicomodesignado().toUpperCase() + "%");
			}
			where.append(" AND t1.TICOMODESIGNADO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTidecodigo() != null) {
			where.append(" AND UPPER(t1.TIDECODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTidecodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTidecodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.TIDECODIGO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifecharesolucion() != null) {
			where.append(" AND t1.TIFECHARESOLUCION = ?");
			params.add(tramiteinspeccion.getTifecharesolucion());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifecharecurso() != null) {
			where.append(" AND t1.TIFECHARECURSO = ?");
			params.add(tramiteinspeccion.getTifecharecurso());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTitiporecurso() != null) {
			where.append(" AND UPPER(t1.TITIPORECURSO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTitiporecurso().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTitiporecurso().toUpperCase() + "%");
			}
			where.append(" AND t1.TITIPORECURSO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiabogado() != null) {
			where.append(" AND UPPER(t1.TIABOGADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTiabogado().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTiabogado().toUpperCase() + "%");
			}
			where.append(" AND t1.TIABOGADO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiestimacion() != null) {
			where.append(" AND UPPER(t1.TIESTIMACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTiestimacion().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTiestimacion().toUpperCase() + "%");
			}
			where.append(" AND t1.TIESTIMACION IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifechacierre() != null) {
			where.append(" AND t1.TIFECHACIERRE = ?");
			params.add(tramiteinspeccion.getTifechacierre());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTidestinatario() != null) {
			where.append(" AND UPPER(t1.TIDESTINATARIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTidestinatario().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTidestinatario().toUpperCase() + "%");
			}
			where.append(" AND t1.TIDESTINATARIO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifechacomunicacion() != null) {
			where.append(" AND t1.TIFECHACOMUNICACION = ?");
			params.add(tramiteinspeccion.getTifechacomunicacion());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTitipocomunicacion() != null) {
			where.append(" AND UPPER(t1.TITIPOCOMUNICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTitipocomunicacion().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTitipocomunicacion().toUpperCase() + "%");
			}
			where.append(" AND t1.TITIPOCOMUNICACION IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTitiponotificacion() != null) {
			where.append(" AND UPPER(t1.TITIPONOTIFICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTitiponotificacion().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTitiponotificacion().toUpperCase() + "%");
			}
			where.append(" AND t1.TITIPONOTIFICACION IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinotificacionporacta() != null) {
			where.append(" AND UPPER(t1.TINOTIFICACIONPORACTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTinotificacionporacta().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTinotificacionporacta().toUpperCase() + "%");
			}
			where.append(" AND t1.TINOTIFICACIONPORACTA IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinumregistrosalida() != null) {
			where.append(" AND UPPER(t1.TINUMREGISTROSALIDA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTinumregistrosalida().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTinumregistrosalida().toUpperCase() + "%");
			}
			where.append(" AND t1.TINUMREGISTROSALIDA IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifecharegistrosalida() != null) {
			where.append(" AND t1.TIFECHAREGISTROSALIDA = ?");
			params.add(tramiteinspeccion.getTifecharegistrosalida());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiacuserecibo() != null) {
			where.append(" AND t1.TIACUSERECIBO = ?");
			params.add(tramiteinspeccion.getTiacuserecibo());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiacusereciborecibido() != null) {
			where.append(" AND UPPER(t1.TIACUSERECIBORECIBIDO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTiacusereciborecibido().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTiacusereciborecibido().toUpperCase() + "%");
			}
			where.append(" AND t1.TIACUSERECIBORECIBIDO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinumregistroentrada() != null) {
			where.append(" AND UPPER(t1.TINUMREGISTROENTRADA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTinumregistroentrada().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTinumregistroentrada().toUpperCase() + "%");
			}
			where.append(" AND t1.TINUMREGISTROENTRADA IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifecharegistroentrada() != null) {
			where.append(" AND t1.TIFECHAREGISTROENTRADA = ?");
			params.add(tramiteinspeccion.getTifecharegistroentrada());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiidnotificacionplatea() != null) {
			where.append(" AND UPPER(t1.TIIDNOTIFICACIONPLATEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTiidnotificacionplatea().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTiidnotificacionplatea().toUpperCase() + "%");
			}
			where.append(" AND t1.TIIDNOTIFICACIONPLATEA IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinombretramite() != null) {
			where.append(" AND UPPER(t1.TINOMBRETRAMITE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTinombretramite().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTinombretramite().toUpperCase() + "%");
			}
			where.append(" AND t1.TINOMBRETRAMITE IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiiddestinatario() != null) {
			where.append(" AND UPPER(t1.TIIDDESTINATARIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTiiddestinatario().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTiiddestinatario().toUpperCase() + "%");
			}
			where.append(" AND t1.TIIDDESTINATARIO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiestadotramite() != null) {
			where.append(" AND UPPER(t1.TIESTADOTRAMITE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTiestadotramite().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTiestadotramite().toUpperCase() + "%");
			}
			where.append(" AND t1.TIESTADOTRAMITE IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTirequierefirma() != null) {
			where.append(" AND UPPER(t1.TIREQUIEREFIRMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTirequierefirma().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTirequierefirma().toUpperCase() + "%");
			}
			where.append(" AND t1.TIREQUIEREFIRMA IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTitiponotificacionplatea() != null) {
			where.append(" AND UPPER(t1.TITIPONOTIFICACIONPLATEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTitiponotificacionplatea().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTitiponotificacionplatea().toUpperCase() + "%");
			}
			where.append(" AND t1.TITIPONOTIFICACIONPLATEA IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiidesperaplatea() != null) {
			where.append(" AND UPPER(t1.TIIDESPERAPLATEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTiidesperaplatea().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTiidesperaplatea().toUpperCase() + "%");
			}
			where.append(" AND t1.TIIDESPERAPLATEA IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTimatarespera() != null) {
			where.append(" AND UPPER(t1.TIMATARESPERA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTimatarespera().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTimatarespera().toUpperCase() + "%");
			}
			where.append(" AND t1.TIMATARESPERA IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiasuntocomunicacion() != null) {
			where.append(" AND UPPER(t1.TIASUNTOCOMUNICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTiasuntocomunicacion().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTiasuntocomunicacion().toUpperCase() + "%");
			}
			where.append(" AND t1.TIASUNTOCOMUNICACION IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifechaenviobopvboe() != null) {
			where.append(" AND t1.TIFECHAENVIOBOPVBOE = ?");
			params.add(tramiteinspeccion.getTifechaenviobopvboe());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifechapublicacionbopv() != null) {
			where.append(" AND t1.TIFECHAPUBLICACIONBOPV = ?");
			params.add(tramiteinspeccion.getTifechapublicacionbopv());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifechapublicacionayto() != null) {
			where.append(" AND t1.TIFECHAPUBLICACIONAYTO = ?");
			params.add(tramiteinspeccion.getTifechapublicacionayto());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTisede() != null) {
			where.append(" AND UPPER(t1.TISEDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTisede().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTisede().toUpperCase() + "%");
			}
			where.append(" AND t1.TISEDE IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifechalimite() != null) {
			where.append(" AND t1.TIFECHALIMITE = ?");
			params.add(tramiteinspeccion.getTifechalimite());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTicodrem() != null) {
			where.append(" AND UPPER(t1.TICODREM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTicodrem().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTicodrem().toUpperCase() + "%");
			}
			where.append(" AND t1.TICODREM IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTienvrem() != null) {
			where.append(" AND UPPER(t1.TIENVREM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTienvrem().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTienvrem().toUpperCase() + "%");
			}
			where.append(" AND t1.TIENVREM IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifcodigo() != null) {
			where.append(" AND UPPER(t1.TIFCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTifcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTifcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.TIFCODIGO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiidmailorigen() != null) {
			where.append(" AND UPPER(t1.TIIDMAILORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTiidmailorigen().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTiidmailorigen().toUpperCase() + "%");
			}
			where.append(" AND t1.TIIDMAILORIGEN IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTimailorigen() != null) {
			where.append(" AND UPPER(t1.TIMAILORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTimailorigen().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTimailorigen().toUpperCase() + "%");
			}
			where.append(" AND t1.TIMAILORIGEN IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiidmaildestino() != null) {
			where.append(" AND UPPER(t1.TIIDMAILDESTINO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTiidmaildestino().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTiidmaildestino().toUpperCase() + "%");
			}
			where.append(" AND t1.TIIDMAILDESTINO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTimaildestino() != null) {
			where.append(" AND UPPER(t1.TIMAILDESTINO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTimaildestino().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTimaildestino().toUpperCase() + "%");
			}
			where.append(" AND t1.TIMAILDESTINO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiproceedingsidplatea() != null) {
			where.append(" AND UPPER(t1.TIPROCEEDINGSIDPLATEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTiproceedingsidplatea().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTiproceedingsidplatea().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPROCEEDINGSIDPLATEA IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiacusereintentado() != null) {
			where.append(" AND UPPER(t1.TIACUSEREINTENTADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTiacusereintentado().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTiacusereintentado().toUpperCase() + "%");
			}
			where.append(" AND t1.TIACUSEREINTENTADO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiautomatico() != null) {
			where.append(" AND UPPER(t1.TIAUTOMATICO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTiautomatico().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTiautomatico().toUpperCase() + "%");
			}
			where.append(" AND t1.TIAUTOMATICO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiorigenalegacion() != null) {
			where.append(" AND UPPER(t1.TIORIGENALEGACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTiorigenalegacion().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTiorigenalegacion().toUpperCase() + "%");
			}
			where.append(" AND t1.TIORIGENALEGACION IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiancodigo() != null) {
			where.append(" AND UPPER(t1.TIANCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTiancodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTiancodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.TIANCODIGO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTitipactua() != null) {
			where.append(" AND UPPER(t1.TITIPACTUA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTitipactua().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTitipactua().toUpperCase() + "%");
			}
			where.append(" AND t1.TITIPACTUA IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTirespuestarecepcion() != null) {
			where.append(" AND UPPER(t1.TIRESPUESTARECEPCION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTirespuestarecepcion().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTirespuestarecepcion().toUpperCase() + "%");
			}
			where.append(" AND t1.TIRESPUESTARECEPCION IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifecharedalerta() != null) {
			where.append(" AND t1.TIFECHAREDALERTA = ?");
			params.add(tramiteinspeccion.getTifecharedalerta());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiinclusiredalerta() != null) {
			where.append(" AND UPPER(t1.TIINCLUSIREDALERTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTiinclusiredalerta().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTiinclusiredalerta().toUpperCase() + "%");
			}
			where.append(" AND t1.TIINCLUSIREDALERTA IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifechaenvlab() != null) {
			where.append(" AND t1.TIFECHAENVLAB = ?");
			params.add(tramiteinspeccion.getTifechaenvlab());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTicodmuestra() != null) {
			where.append(" AND UPPER(t1.TICODMUESTRA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTicodmuestra().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTicodmuestra().toUpperCase() + "%");
			}
			where.append(" AND t1.TICODMUESTRA IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTilacodigo() != null) {
			where.append(" AND UPPER(t1.TILACODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTilacodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTilacodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.TILACODIGO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifecharesens() != null) {
			where.append(" AND t1.TIFECHARESENS = ?");
			params.add(tramiteinspeccion.getTifecharesens());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTicodinfensay() != null) {
			where.append(" AND UPPER(t1.TICODINFENSAY) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTicodinfensay().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTicodinfensay().toUpperCase() + "%");
			}
			where.append(" AND t1.TICODINFENSAY IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiconstatacion() != null) {
			where.append(" AND UPPER(t1.TICONSTATACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTiconstatacion().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTiconstatacion().toUpperCase() + "%");
			}
			where.append(" AND t1.TICONSTATACION IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifechadesin() != null) {
			where.append(" AND t1.TIFECHADESIN = ?");
			params.add(tramiteinspeccion.getTifechadesin());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinumdesin() != null) {
			where.append(" AND UPPER(t1.TINUMDESIN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTinumdesin().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTinumdesin().toUpperCase() + "%");
			}
			where.append(" AND t1.TINUMDESIN IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTidestinodesin() != null) {
			where.append(" AND UPPER(t1.TIDESTINODESIN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTidestinodesin().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTidestinodesin().toUpperCase() + "%");
			}
			where.append(" AND t1.TIDESTINODESIN IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTidestruccioninsitu() != null) {
			where.append(" AND UPPER(t1.TIDESTRUCCIONINSITU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTidestruccioninsitu().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTidestruccioninsitu().toUpperCase() + "%");
			}
			where.append(" AND t1.TIDESTRUCCIONINSITU IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiempresagest() != null) {
			where.append(" AND UPPER(t1.TIEMPRESAGEST) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTiempresagest().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTiempresagest().toUpperCase() + "%");
			}
			where.append(" AND t1.TIEMPRESAGEST IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinumrecupe() != null) {
			where.append(" AND UPPER(t1.TINUMRECUPE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTinumrecupe().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTinumrecupe().toUpperCase() + "%");
			}
			where.append(" AND t1.TINUMRECUPE IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinumadestruir() != null) {
			where.append(" AND UPPER(t1.TINUMADESTRUIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTinumadestruir().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTinumadestruir().toUpperCase() + "%");
			}
			where.append(" AND t1.TINUMADESTRUIR IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinumadevolver() != null) {
			where.append(" AND UPPER(t1.TINUMADEVOLVER) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTinumadevolver().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTinumadevolver().toUpperCase() + "%");
			}
			where.append(" AND t1.TINUMADEVOLVER IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifechaemiinf() != null) {
			where.append(" AND t1.TIFECHAEMIINF = ?");
			params.add(tramiteinspeccion.getTifechaemiinf());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTihorainicioemiinf() != null) {
			where.append(" AND UPPER(t1.TIHORAINICIOEMIINF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTihorainicioemiinf().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTihorainicioemiinf().toUpperCase() + "%");
			}
			where.append(" AND t1.TIHORAINICIOEMIINF IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTihorafininf() != null) {
			where.append(" AND UPPER(t1.TIHORAFININF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTihorafininf().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTihorafininf().toUpperCase() + "%");
			}
			where.append(" AND t1.TIHORAFININF IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTidniinf() != null) {
			where.append(" AND UPPER(t1.TIDNIINF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTidniinf().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTidniinf().toUpperCase() + "%");
			}
			where.append(" AND t1.TIDNIINF IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinombreinf() != null) {
			where.append(" AND UPPER(t1.TINOMBREINF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTinombreinf().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTinombreinf().toUpperCase() + "%");
			}
			where.append(" AND t1.TINOMBREINF IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinoraProvinciaId() != null) {
			where.append(" AND UPPER(t1.TINORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTinoraProvinciaId().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTinoraProvinciaId().toUpperCase() + "%");
			}
			where.append(" AND t1.TINORA_PROVINCIA_ID IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinombreProvincia() != null) {
			where.append(" AND UPPER(t1.TINOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTinombreProvincia().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTinombreProvincia().toUpperCase() + "%");
			}
			where.append(" AND t1.TINOMBRE_PROVINCIA IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinoraMunicipioId() != null) {
			where.append(" AND UPPER(t1.TINORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTinoraMunicipioId().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTinoraMunicipioId().toUpperCase() + "%");
			}
			where.append(" AND t1.TINORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinombreMunicipio() != null) {
			where.append(" AND UPPER(t1.TINOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTinombreMunicipio().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTinombreMunicipio().toUpperCase() + "%");
			}
			where.append(" AND t1.TINOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinoraLocalidadId() != null) {
			where.append(" AND UPPER(t1.TINORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTinoraLocalidadId().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTinoraLocalidadId().toUpperCase() + "%");
			}
			where.append(" AND t1.TINORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinombreLocalidad() != null) {
			where.append(" AND UPPER(t1.TINOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTinombreLocalidad().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTinombreLocalidad().toUpperCase() + "%");
			}
			where.append(" AND t1.TINOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinoraCalleId() != null) {
			where.append(" AND UPPER(t1.TINORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTinoraCalleId().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTinoraCalleId().toUpperCase() + "%");
			}
			where.append(" AND t1.TINORA_CALLE_ID IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinombreCalle() != null) {
			where.append(" AND UPPER(t1.TINOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTinombreCalle().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTinombreCalle().toUpperCase() + "%");
			}
			where.append(" AND t1.TINOMBRE_CALLE IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinoraCpId() != null) {
			where.append(" AND UPPER(t1.TINORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTinoraCpId().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTinoraCpId().toUpperCase() + "%");
			}
			where.append(" AND t1.TINORA_CP_ID IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinombreCp() != null) {
			where.append(" AND UPPER(t1.TINOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTinombreCp().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTinombreCp().toUpperCase() + "%");
			}
			where.append(" AND t1.TINOMBRE_CP IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinoraPortalId() != null) {
			where.append(" AND UPPER(t1.TINORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTinoraPortalId().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTinoraPortalId().toUpperCase() + "%");
			}
			where.append(" AND t1.TINORA_PORTAL_ID IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinombrePortal() != null) {
			where.append(" AND UPPER(t1.TINOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTinombrePortal().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTinombrePortal().toUpperCase() + "%");
			}
			where.append(" AND t1.TINOMBRE_PORTAL IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinombrePiso() != null) {
			where.append(" AND UPPER(t1.TINOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTinombrePiso().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTinombrePiso().toUpperCase() + "%");
			}
			where.append(" AND t1.TINOMBRE_PISO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTidireccionNocapv() != null) {
			where.append(" AND UPPER(t1.TIDIRECCION_NOCAPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTidireccionNocapv().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTidireccionNocapv().toUpperCase() + "%");
			}
			where.append(" AND t1.TIDIRECCION_NOCAPV IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiextranjero() != null) {
			where.append(" AND UPPER(t1.TIEXTRANJERO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTiextranjero().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTiextranjero().toUpperCase() + "%");
			}
			where.append(" AND t1.TIEXTRANJERO IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinoraPaisId() != null) {
			where.append(" AND UPPER(t1.TINORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTinoraPaisId().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTinoraPaisId().toUpperCase() + "%");
			}
			where.append(" AND t1.TINORA_PAIS_ID IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTinombrePais() != null) {
			where.append(" AND UPPER(t1.TINOMBRE_PAIS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTinombrePais().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTinombrePais().toUpperCase() + "%");
			}
			where.append(" AND t1.TINOMBRE_PAIS IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTitelinf() != null) {
			where.append(" AND UPPER(t1.TITELINF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTitelinf().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTitelinf().toUpperCase() + "%");
			}
			where.append(" AND t1.TITELINF IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiencondicioninf() != null) {
			where.append(" AND UPPER(t1.TIENCONDICIONINF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTiencondicioninf().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTiencondicioninf().toUpperCase() + "%");
			}
			where.append(" AND t1.TIENCONDICIONINF IS NOT NULL");
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifechaaceptacion() != null) {
			where.append(" AND t1.TIFECHAACEPTACION = ?");
			params.add(tramiteinspeccion.getTifechaaceptacion());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTifechaampli() != null) {
			where.append(" AND t1.TIFECHAAMPLI = ?");
			params.add(tramiteinspeccion.getTifechaampli());
		}
		if (tramiteinspeccion != null && tramiteinspeccion.getTiaccodigo() != null) {
			where.append(" AND UPPER(t1.TIACCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramiteinspeccion.getTiaccodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tramiteinspeccion.getTiaccodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.TIACCODIGO IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @return TramiteInspeccionDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteInspeccionDetalle findUltimoTramiteInspeccionYFase(
			TramiteInspeccionDetalle tramiteInspeccionDetalle) {
		try {
			// TODO: Hacer la query correcta que esta copiada de
			// TramiteInspeccionDao.
			String query = "SELECT tr1.TIESTADOTRAMITE TIESTADOTRAMITE, tr2.FCODIGO FCODIGO, tr2.TRCODIGO TRCODIGO "
					+ "FROM TRAMITE_INSPECCION tr1, TRAMITE tr2 "
					+ "WHERE tr1.TICOTEE = tr2.TRCODIGO AND tr1.TIATCODIGO = ? AND TIFECHAINICIO = (SELECT MAX(TIFECHAINICIO) FROM TRAMITE_INSPECCION tr2 WHERE tr2.TIATCODIGO = ?) AND ROWNUM = 1";
			return (TramiteInspeccionDetalle) this.jdbcTemplate.queryForObject(query,
					new RowMapper<TramiteInspeccionDetalle>() {
						public TramiteInspeccionDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
							return new TramiteInspeccionDetalle(resultSet.getString("FCODIGO"),
									resultSet.getString("TRCODIGO"), resultSet.getString("TIESTADOTRAMITE"));
						}
					}, tramiteInspeccionDetalle.getAtcodigo(), tramiteInspeccionDetalle.getAtcodigo());
		} catch (EmptyResultDataAccessException e) {
			return new TramiteInspeccionDetalle();
		}
	}

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @return TramiteInspeccionDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteInspeccionDetalle findUltimoTramiteInspeccionYFaseNoGenerico(
			TramiteInspeccionDetalle tramiteInspeccionDetalle) {
		try {
			String query = "SELECT tr2.FCODIGO FCODIGO, tr2.TRCODIGO TRCODIGO "
					+ "FROM TRAMITE_INSPECCION tr1, TRAMITE tr2 "
					+ "WHERE tr1.TICOTEE = tr2.TRCODIGO AND tr2.FCODIGO IS NOT NULL AND tr1.TIATCODIGO = ? AND TIFECHAINICIO = (SELECT MAX(TIFECHAINICIO) FROM TRAMITE_INSPECCION tr2, TRAMITE tr3 WHERE tr2.TICOTEE = tr3.TRCODIGO AND tr3.FCODIGO IS NOT NULL AND tr2.TIATCODIGO = ?) AND ROWNUM=1";
			return (TramiteInspeccionDetalle) this.jdbcTemplate.queryForObject(query,
					new RowMapper<TramiteInspeccionDetalle>() {
						public TramiteInspeccionDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
							return new TramiteInspeccionDetalle(resultSet.getString("FCODIGO"),
									resultSet.getString("TRCODIGO"), null);
						}
					}, tramiteInspeccionDetalle.getAtcodigo(), tramiteInspeccionDetalle.getAtcodigo());
		} catch (EmptyResultDataAccessException e) {
			return new TramiteInspeccionDetalle();
		}
	}

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @return TramiteInspeccionDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteInspeccionDetalle findUltimoTramiteInspeccionYFaseNoGenericoNoCierre(
			TramiteInspeccionDetalle tramiteInspeccionDetalle) {
		try {
			String query = "SELECT tr2.FCODIGO FCODIGO, tr2.TRCODIGO TRCODIGO "
					+ "FROM TRAMITE_INSPECCION tr1, TRAMITE tr2 "
					+ "WHERE tr1.TICOTEE = tr2.TRCODIGO AND tr2.FCODIGO IS NOT NULL AND tr1.TICOTEE != ? AND tr1.TIATCODIGO = ? AND TIFECHAINICIO = (SELECT MAX(TIFECHAINICIO) FROM TRAMITE_INSPECCION tr2, TRAMITE tr3 WHERE tr2.TICOTEE = tr3.TRCODIGO AND tr2.TICOTEE != ? AND tr3.FCODIGO IS NOT NULL AND tr2.TIATCODIGO = ?) AND ROWNUM=1";
			return (TramiteInspeccionDetalle) this.jdbcTemplate.queryForObject(query,
					new RowMapper<TramiteInspeccionDetalle>() {
						public TramiteInspeccionDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
							return new TramiteInspeccionDetalle(resultSet.getString("FCODIGO"),
									resultSet.getString("TRCODIGO"), null);
						}
					}, Y41bConstantes.TRAMITE_INSPECCIONES_CIERRE_EXPEDIENTE, tramiteInspeccionDetalle.getAtcodigo(),
					Y41bConstantes.TRAMITE_INSPECCIONES_CIERRE_EXPEDIENTE, tramiteInspeccionDetalle.getAtcodigo());
		} catch (EmptyResultDataAccessException e) {
			return new TramiteInspeccionDetalle();
		}
	}

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * 
	 * @return TramiteInspeccionDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteInspeccionDetalle findUltimoTramiteHechoPorTipoTramiteNoTramitado(
			TramiteInspeccionDetalle tramiteInspeccionDetalle) {
		try {
			String query = "SELECT * FROM (SELECT tr1.TICODIGO TICODIGO " + "FROM TRAMITE_INSPECCION tr1 "
					+ "WHERE tr1.TIATCODIGO=? AND tr1.TICOTEE=? AND tr1.TIESTADOTRAMITE!=? ORDER BY tr1.TIFECHAINICIO DESC) WHERE 1=1 AND ROWNUM=1 ";
			return (TramiteInspeccionDetalle) this.jdbcTemplate.queryForObject(query,
					new RowMapper<TramiteInspeccionDetalle>() {
						public TramiteInspeccionDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
							return new TramiteInspeccionDetalle(resultSet.getString("TICODIGO"));
						}
					}, tramiteInspeccionDetalle.getAtcodigo(), tramiteInspeccionDetalle.getTrcodigo(),
					Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} catch (EmptyResultDataAccessException e) {
			return new TramiteInspeccionDetalle();
		}
	}

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @param origen
	 *            String
	 * 
	 * @return TramiteInspeccionDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteInspeccionDetalle findUltimoTramiteHechoPorTipoTramiteYOrigenNoTramitado(
			TramiteInspeccionDetalle tramiteInspeccionDetalle, String origen) {
		try {
			String query = "SELECT * FROM (SELECT tr1.TICODIGO TICODIGO " + "FROM TRAMITE_INSPECCION tr1 "
					+ "WHERE tr1.TIATCODIGO=? AND tr1.TICOTEE=? AND tr1.TIORIGENALEGACION=? AND tr1.TIESTADOTRAMITE!=? ORDER BY tr1.TIFECHAINICIO DESC) WHERE 1=1 AND ROWNUM=1 ";
			return (TramiteInspeccionDetalle) this.jdbcTemplate.queryForObject(query,
					new RowMapper<TramiteInspeccionDetalle>() {
						public TramiteInspeccionDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
							return new TramiteInspeccionDetalle(resultSet.getString("TICODIGO"));
						}
					}, tramiteInspeccionDetalle.getAtcodigo(), tramiteInspeccionDetalle.getTrcodigo(), origen,
					Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} catch (EmptyResultDataAccessException e) {
			return new TramiteInspeccionDetalle();
		}
	}

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @param destino
	 *            String
	 * 
	 * @return TramiteInspeccionDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteInspeccionDetalle findUltimoTramiteHechoPorTipoTramiteYDestinoTramitado(
			TramiteInspeccionDetalle tramiteInspeccionDetalle, String destino) {
		try {
			String query = "SELECT * FROM (SELECT tr1.TICODIGO TICODIGO " + "FROM TRAMITE_INSPECCION tr1 "
					+ "WHERE tr1.TIATCODIGO=? AND tr1.TICOTEE=? AND tr1.TIDESTINATARIO=? AND tr1.TIESTADOTRAMITE=? ORDER BY tr1.TIFECHAINICIO DESC) WHERE 1=1 AND ROWNUM=1 ";
			return (TramiteInspeccionDetalle) this.jdbcTemplate.queryForObject(query,
					new RowMapper<TramiteInspeccionDetalle>() {
						public TramiteInspeccionDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
							return new TramiteInspeccionDetalle(resultSet.getString("TICODIGO"));
						}
					}, tramiteInspeccionDetalle.getAtcodigo(), tramiteInspeccionDetalle.getTrcodigo(), destino,
					Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} catch (EmptyResultDataAccessException e) {
			return new TramiteInspeccionDetalle();
		}
	}

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * 
	 * @return TramiteInspeccionDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteInspeccionDetalle findTramitePendienteMasAntiguoNoTramitado(
			TramiteInspeccionDetalle tramiteInspeccionDetalle) {
		try {
			String query = "SELECT * FROM (SELECT tr1.TICODIGO TICODIGO " + "FROM TRAMITE_INSPECCION tr1 "
					+ "WHERE tr1.TIATCODIGO=? AND tr1.TIESTADOTRAMITE!=? ORDER BY tr1.TIFECHAINICIO ASC) WHERE 1=1 AND ROWNUM=1 ";
			return (TramiteInspeccionDetalle) this.jdbcTemplate.queryForObject(query,
					new RowMapper<TramiteInspeccionDetalle>() {
						public TramiteInspeccionDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
							return new TramiteInspeccionDetalle(resultSet.getString("TICODIGO"));
						}
					}, tramiteInspeccionDetalle.getAtcodigo(), Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} catch (EmptyResultDataAccessException e) {
			return new TramiteInspeccionDetalle();
		}
	}

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * 
	 * @return TramiteInspeccionDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteInspeccionDetalle findTramitePendienteMasNuevoNoTramitado(
			TramiteInspeccionDetalle tramiteInspeccionDetalle) {
		try {
			String query = "SELECT * FROM (SELECT tr1.TICODIGO TICODIGO " + "FROM TRAMITE_INSPECCION tr1 "
					+ "WHERE tr1.TIATCODIGO=? AND tr1.TIESTADOTRAMITE!=? ORDER BY tr1.TIFECHAINICIO DESC) WHERE 1=1 AND ROWNUM=1 ";
			return (TramiteInspeccionDetalle) this.jdbcTemplate.queryForObject(query,
					new RowMapper<TramiteInspeccionDetalle>() {
						public TramiteInspeccionDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
							return new TramiteInspeccionDetalle(resultSet.getString("TICODIGO"));
						}
					}, tramiteInspeccionDetalle.getAtcodigo(), Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} catch (EmptyResultDataAccessException e) {
			return new TramiteInspeccionDetalle();
		}
	}

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * 
	 * @return TramiteInspeccionDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteInspeccionDetalle findUltimoTramiteInspeccionTramitado(
			TramiteInspeccionDetalle tramiteInspeccionDetalle) {
		try {
			String query = "SELECT * FROM (SELECT tr1.TICODIGO TICODIGO " + "FROM TRAMITE_INSPECCION tr1 "
					+ "WHERE tr1.TIATCODIGO=? AND tr1.TIESTADOTRAMITE=? ORDER BY tr1.TIFECHAINICIO DESC) WHERE 1=1 AND ROWNUM=1 ";
			return (TramiteInspeccionDetalle) this.jdbcTemplate.queryForObject(query,
					new RowMapper<TramiteInspeccionDetalle>() {
						public TramiteInspeccionDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
							return new TramiteInspeccionDetalle(resultSet.getString("TICODIGO"));
						}
					}, tramiteInspeccionDetalle.getAtcodigo(), Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} catch (EmptyResultDataAccessException e) {
			return new TramiteInspeccionDetalle();
		}
	}

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @param origen
	 *            String
	 * 
	 * @return TramiteInspeccionDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteInspeccionDetalle findUltimoTramiteInspeccionPorTipoTramite(
			TramiteInspeccionDetalle tramiteInspeccionDetalle) {
		try {
			String query = "SELECT * FROM (SELECT tr1.TICODIGO TICODIGO " + "FROM TRAMITE_INSPECCION tr1 "
					+ "WHERE tr1.TIATCODIGO=? AND tr1.TICOTEE=? ORDER BY tr1.TIFECHAINICIO DESC) WHERE ROWNUM=1 ";
			return (TramiteInspeccionDetalle) this.jdbcTemplate.queryForObject(query,
					new RowMapper<TramiteInspeccionDetalle>() {
						public TramiteInspeccionDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
							return new TramiteInspeccionDetalle(resultSet.getString("TICODIGO"));
						}
					}, tramiteInspeccionDetalle.getAtcodigo(), tramiteInspeccionDetalle.getTrcodigo());
		} catch (EmptyResultDataAccessException e) {
			return new TramiteInspeccionDetalle();
		}
	}

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	public TramiteInspeccion updateEstadoTramite(TramiteInspeccion tramiteInspeccion) {
		String query = "UPDATE TRAMITE_INSPECCION SET TIESTADOTRAMITE=? WHERE TICODIGO=?";

		this.jdbcTemplate.update(query, tramiteInspeccion.getTiestadotramite(), tramiteInspeccion.getTicodigo());
		return tramiteInspeccion;
	}

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	@Transactional(readOnly = true)
	public TramiteInspeccion findLobTablaTemporal(TramiteInspeccion tramiteInspeccion) {
		try {
			String query = "SELECT TICODIGO, TICOMENTARIO, TIRESUMENRECEPCION "
					+ "FROM TRAMITE_INSPECCION WHERE TICODIGO = ? ";

			return this.jdbcTemplate.queryForObject(query.toString(), new RowMapper<TramiteInspeccion>() {
				public TramiteInspeccion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
					TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();

					tramiteInspeccion.setTicodigo(resultSet.getString("TICODIGO"));
					tramiteInspeccion.setTicomentario(resultSet.getString("TICOMENTARIO"));
					tramiteInspeccion.setTiresumenrecepcion(resultSet.getString("TIRESUMENRECEPCION"));

					return tramiteInspeccion;
				}
			}, tramiteInspeccion.getTicodigo());

		} catch (EmptyResultDataAccessException e) {
			return new TramiteInspeccion();
		}
	}

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	public TramiteInspeccion updateIdNotificacionPlatea(TramiteInspeccion tramiteInspeccion) {
		String query = "UPDATE TRAMITE_INSPECCION SET TIIDNOTIFICACIONPLATEA=? WHERE TICODIGO=?";

		this.jdbcTemplate.update(query, tramiteInspeccion.getTiidnotificacionplatea(), tramiteInspeccion.getTicodigo());
		return tramiteInspeccion;
	}

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	public TramiteInspeccion updateRegistroSalidaPlatea(TramiteInspeccion tramiteInspeccion) {
		String query = "UPDATE TRAMITE_INSPECCION SET TINUMREGISTROSALIDA=?, TIFECHAREGISTROSALIDA=? WHERE TICODIGO=?";

		this.jdbcTemplate.update(query, tramiteInspeccion.getTinumregistrosalida(),
				tramiteInspeccion.getTifecharegistrosalida(), tramiteInspeccion.getTicodigo());
		return tramiteInspeccion;
	}

	/**
	 * Inserts a single row in the NotificacionAcuseRecibo table.
	 * 
	 * @param notificacionAcuseRecibo
	 *            NotificacionAcuseRecibo
	 * @return NotificacionAcuseRecibo
	 */
	public NotificacionAcuseRecibo addNotificacionAcuseRecibo(NotificacionAcuseRecibo notificacionAcuseRecibo) {
		String query = "INSERT INTO NOTIFICACION_ACUSERECIBO (EHIDNOTIFICACIONPLATEA, EHCODIGOACUSE, EHPCODIGO) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, notificacionAcuseRecibo.getEhidnotificacionplatea(),
				notificacionAcuseRecibo.getEhcodigoacuse(), notificacionAcuseRecibo.getEhpcodigo());
		return notificacionAcuseRecibo;
	}

	/**
	 * Finds a List of rows in the TramiteHecho table.
	 * 
	 * @param notificacionComunicacionDetalle
	 *            NotificacionesComunicacionesBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<NotificacionesComunicacionesBusqueda> findAllNotifiComuni(
			NotificacionesComunicacionesBusqueda notificacionComunicacionDetalle, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT T5.ACCOOR||' '||T5.ACNRAN||' '||T5.ACNROR||' '||T4.ATNROR IDTRAMITE, T1.TICODIGO CODEXPEDIENTE, T5.ACCOOR ACCOOR, "
						+ "T4.ATCODIGO ATCODIGO, "
						+ "T5.ACNROR ACNROR, T5.ACNRAN ACNRAN, T4.ATNROR ATNROR, T1.TICOMOEJECUCION TICOMOEJECUCION,"
						+ " T3.MONOMBRE MONOMBRE, T1.TITIPONOTIFICACIONPLATEA TITIPONOTIFICACIONPLATEA, T1.TIIDDESTINATARIO TIIDDESTINATARIO,"
						+ " T2.NIF NIF, " + " T2.NOMBRE ||' '||T2.APELLIDO1||' '||T2.APELLIDO2 AS NOMBREDESTINATARIO, "
						+ " T2.ESNOCO AS NOMBRECOMERCIALDESTINATARIO, "
						+ " T2.NOMBRE_CP NOMBRE_CP, T2.NOMBRE_PROVINCIA NOMBRE_PROVINCIA, "
						+ " T2.NOMBRE_MUNICIPIO NOMBRE_MUNICIPIO, T1.TIFECHAINICIO TIFECHAINICIO, "
						+ " T2.NOMBRE_CALLE||','||T2.NOMBRE_PORTAL AS DIRECCION1, T2.NOMBRE_CP||' '||T2.NOMBRE_LOCALIDAD AS DIRECCION2, "
						+ " T2.EXTRANJERO EXTRANJERO, T2.NOMBRE_LOCALIDAD NOMBRE_LOCALIDAD, T2.NOMBRE_CALLE NOMBRECALLE, T2.NOMBRE_PORTAL NOMBREPORTAL, "
						+ " T2.NOMBRE_PISO NOMBREPISO, T2.NOMBRE_PAIS NOMBREPAIS, T2.DIRECCION_NOCAPV DIRECCIONNOCAPV, T2.DIRECCION_ANTIGUA DIRECCIONANTIGUA, "
						+ " T1.TIASUNTOCOMUNICACION ASUNTO,T9.TIESTADOTRAMITE TIESTADOTRAMITE, T1.TINUMREGISTROSALIDA TINUMREGISTROSALIDA, T1.TISEDE TISEDE, T2.ESCODIGO ESCODIGO, "
						+ " T7.COD_ORG CODORG, T7.NOMBRE_ES NOMBREES, T7.NOMBRE_EU NOMBREEU,  T7.NORA_PROVINCIA_ID NORAPROVINCIAID, T7.NOMBRE_PROVINCIA NOMBREPROVINCIAORG, T7.NORA_MUNICIPIO_ID NORAMUNICIPIOID, T7.NOMBRE_MUNICIPIO NOMBREMUNICIPIOORG, "
						+ " T7.NORA_LOCALIDAD_ID NORALOCALIDADID, T7.NOMBRE_LOCALIDAD NOMBRELOCALIDADORG, T7.NORA_CALLE_ID NORACALLEID, T7.NOMBRE_CALLE NOMBRECALLEORG, T7.NORA_CP_ID NORACPID, T7.NOMBRE_CP NOMBRECPORG, T7.NORA_PORTAL_ID NORAPORTALID, "
						+ " T7.NOMBRE_PORTAL NOMBREPORTALORG, T7.TELEFONO TELEFONOORGANISMO, T7.FAX FAXORGANISMO, T7.EMAIL EMAILORGANISMO, T7.URL WEBORGANISMO, "
						+ " T1.TICOTEE TRCODIGO, T1.TICODIGO TICODIGO, T2.TIPO_INTERVINIENTE TIPOINTERVINIENTE, T3.USUARIOXLNET USUARIOXLNET, T3.PUESTOXLNET PUESTOXLNET, "
						+ " T8.ENVCESTADO ENVCESTADO, T8.ENVCDESERRORES ENVCDESERRORES, T8.ENVCDESERROREU ENVCDESERROREU, T8.ENVC_ID_ENVIO ENVCIDENVIO, T8.ENVCCOD_SIT_CORREOS ENVCCODSITCORREOS, T8.ENVCDES_SIT_CORREOS_ES ENVCDESSITCORREOSES, T8.ENVCDES_SIT_CORREOS_EU ENVCDESSITCORREOSEU, "
						+ " T8.ENVFECHAACTUALIZACION ENVFECHAACTUALIZACION,T8.ENVCCODBARRAS ENVCCODBARRAS,T9.TICODIGO IDTRAMITEACUSERELACIONADO, T9.TIACUSERECIBORECIBIDO "
						+ " FROM TRAMITE_INSPECCION T1, INTERVINIENTES T2, CENSO_MONITOR T3, ACTUACION T4, ACTA T5, ACTDEC T6, ORGANISMO T7, ENVIOS_POR_REMESA T8, TRAMITE_INSPECCION T9 ");

		Map<String, ?> mapaWhere = this.getWhereMapNotifiComunica(notificacionComunicacionDetalle);

		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND T1.TIIDDESTINATARIO=T2.IDINTERVINIENTE AND T1.TICOMOEJECUCION= T3.MOCODIGO "
						+ "AND T1.TIATCODIGO=T4.ATCODIGO AND T4.ATCOAC=T5.ACCODIGO AND T4.ATCODIGO = T6.ADCOAT "
						+ "AND t6.ADCOOR= t7.COD_ORG AND T1.TICODIGO = T8.EHCODIGO(+) "
						+ "AND T1.TICODIGO = T9.TICODIGORELACIONADO(+) AND t9.TICOTEE(+) = '"
						+ Y41bConstantes.TRAMITE_INSPECCIONES_ACUSE_DE_RECIBO + "' ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<NotificacionesComunicacionesBusqueda>) this.jdbcTemplate.query(query.toString(),
				this.rwMapNotifiComunica, params.toArray());
	}

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param notificacionComunicacionDetalle
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllNotifiComuniCount(NotificacionesComunicacionesBusqueda notificacionComunicacionDetalle) {

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM TRAMITE_INSPECCION T1, INTERVINIENTES T2, CENSO_MONITOR T3, ACTUACION T4, ACTA T5, ACTDEC T6 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapNotifiComunica(notificacionComunicacionDetalle);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND T1.TIIDDESTINATARIO=T2.IDINTERVINIENTE AND T1.TICOMOEJECUCION= T3.MOCODIGO "
						+ "AND T1.TIATCODIGO=T4.ATCODIGO AND T4.ATCOAC=T5.ACCODIGO AND T4.ATCODIGO = T6.ADCOAT ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	// CHECKSTYLE:OFF CyclomaticComplexity - Generacin de cdigo de UDA
	private Map<String, ?> getWhereMapNotifiComunica(
			NotificacionesComunicacionesBusqueda notificacionComunicacionDetalle) {

		StringBuilder where = new StringBuilder(TramiteHechoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (notificacionComunicacionDetalle != null) {
			if (notificacionComunicacionDetalle.getRmcodigo() == null) {
				where.append(" AND T1.TIENVREM='");
				where.append(Y41bConstantes.SI);
				where.append("'");

				where.append(" AND T1.TIESTADOTRAMITE='");
				where.append(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
				where.append("'");
				where.append(" AND T1.TICODREM IS NULL ");
			}
			if (notificacionComunicacionDetalle.getRmcodigo() != null) {
				where.append(" AND T1.TICODREM ='");
				where.append(notificacionComunicacionDetalle.getRmcodigo());
				where.append("'");
			}
			if (notificacionComunicacionDetalle.getRmtipo() != null
					&& notificacionComunicacionDetalle.getModoRemesa() != null && notificacionComunicacionDetalle
							.getModoRemesa().equalsIgnoreCase(Y41bConstantes.MODO_POPUP_ALTA)) {
				String tipo = notificacionComunicacionDetalle.getRmtipo();
				if (tipo.contains(Y41bConstantes.TRAMITE_NOTIFICACION)) {
					if (notificacionComunicacionDetalle.isCompatibleAA66()) {
						where.append(" AND (T2.EXTRANJERO = '");
						if (tipo.equalsIgnoreCase(Y41bConstantes.TRAMITE_NOTIFICACION_ELECTRONICA)) {
							where.append(Y41bConstantes.NO);
							where.append("'");
							where.append(" OR T2.NORA_PAIS_ID = '");
							where.append(Y41bConstantes.COD_PAIS_ESTADO);
							where.append("'");
							where.append(" OR T2.NORA_PAIS_ID IS NULL)");
						} else {
							where.append(Y41bConstantes.SI);
							where.append("'");
							where.append(" OR T2.NORA_PAIS_ID <> '");
							where.append(Y41bConstantes.COD_PAIS_ESTADO);
							where.append("')");
						}
					}
					tipo = Y41bConstantes.TRAMITE_INSPECCIONES_NOTIFICACION;
				}

				if (tipo.contains(Y41bConstantes.TRAMITE_COMUNICACION)) {
					tipo = Y41bConstantes.TRAMITE_INSPECCIONES_COMUNICACION;
				}
				where.append(" AND T1.TICOTEE = '");
				where.append(tipo);
				where.append("'");
			}
			if (notificacionComunicacionDetalle.isRmcapv() != null) {
				where.append(" AND T2.NORA_PROVINCIA_ID IN ('48','01','20') ");
			}
			if (notificacionComunicacionDetalle.getRmorganico() != null) {

				// JGREY. 15/12/2016:
				// MANTIS 91389: Cambio / Traslado entre oficinas territoriales

				// Inicio condicion
				where.append(" AND (");

				// 1. Muestra los envios del organismo de busqueda,
				// que no tengan tramite de traslado
				where.append("(T6.ADCOOR = '");
				where.append(notificacionComunicacionDetalle.getRmorganico());
				where.append("'))");
			}
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	private RowMapper<NotificacionesComunicacionesBusqueda> rwMapNotifiComunica = new RowMapper<NotificacionesComunicacionesBusqueda>() {
		public NotificacionesComunicacionesBusqueda mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new NotificacionesComunicacionesBusqueda(resultSet.getString("IDTRAMITE"),
					resultSet.getString("CODEXPEDIENTE"), resultSet.getString("ACCOOR"), resultSet.getString("ACNROR"),
					resultSet.getBigDecimal("ACNRAN"), resultSet.getBigDecimal("ATNROR"),
					resultSet.getDate("TIFECHAINICIO"), resultSet.getString("TINUMREGISTROSALIDA"),
					resultSet.getString("TITIPONOTIFICACIONPLATEA"), resultSet.getString("TICOMOEJECUCION"),
					resultSet.getString("MONOMBRE"), resultSet.getString("TIIDDESTINATARIO"),
					resultSet.getString("NIF"), resultSet.getString("NOMBREDESTINATARIO"),
					resultSet.getString("NOMBRECOMERCIALDESTINATARIO"), resultSet.getString("EXTRANJERO"),
					resultSet.getString("NOMBRE_PROVINCIA"), resultSet.getString("NOMBRE_MUNICIPIO"),
					resultSet.getString("NOMBRE_LOCALIDAD"), resultSet.getString("NOMBRE_CP"),
					resultSet.getString("NOMBRECALLE"), resultSet.getString("NOMBREPORTAL"),
					resultSet.getString("NOMBREPISO"), resultSet.getString("NOMBREPAIS"),
					resultSet.getString("DIRECCIONNOCAPV"), resultSet.getString("DIRECCIONANTIGUA"),
					resultSet.getString("DIRECCION1"), resultSet.getString("DIRECCION2"), resultSet.getString("ASUNTO"),
					resultSet.getString("TIESTADOTRAMITE"), resultSet.getString("TISEDE"),
					resultSet.getString("ESCODIGO"), resultSet.getString("ATCODIGO"), resultSet.getString("CODORG"),
					resultSet.getString("NOMBREES"), resultSet.getString("NOMBREEU"),
					resultSet.getString("NORAPROVINCIAID"), resultSet.getString("NOMBREPROVINCIAORG"),
					resultSet.getString("NORAMUNICIPIOID"), resultSet.getString("NOMBREMUNICIPIOORG"),
					resultSet.getString("NORALOCALIDADID"), resultSet.getString("NOMBRELOCALIDADORG"),
					resultSet.getString("NORACALLEID"), resultSet.getString("NOMBRECALLEORG"),
					resultSet.getString("NORACPID"), resultSet.getString("NOMBRECPORG"),
					resultSet.getString("NORAPORTALID"), resultSet.getString("NOMBREPORTALORG"),
					resultSet.getString("TELEFONOORGANISMO"), resultSet.getString("FAXORGANISMO"),
					resultSet.getString("EMAILORGANISMO"), resultSet.getString("WEBORGANISMO"),
					resultSet.getString("TRCODIGO"), resultSet.getString("TIPOINTERVINIENTE"),
					resultSet.getString("USUARIOXLNET"), resultSet.getString("PUESTOXLNET"),
					resultSet.getString("ENVCESTADO"), resultSet.getString("ENVCDESERRORES"),
					resultSet.getString("ENVCDESERROREU"), resultSet.getInt("ENVCIDENVIO"),
					resultSet.getString("ENVCCODSITCORREOS"), resultSet.getString("ENVCDESSITCORREOSES"),
					resultSet.getString("ENVCDESSITCORREOSEU"), resultSet.getDate("ENVFECHAACTUALIZACION"),
					resultSet.getString("ENVCCODBARRAS"), // j
					resultSet.getString("IDTRAMITEACUSERELACIONADO"), // j
					resultSet.getString("TIACUSERECIBORECIBIDO"));
		}
	};

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho updateRemesa(TramiteHecho tramitehecho) {
		String query = "UPDATE TRAMITE_INSPECCION SET TICODREM=? WHERE TICODIGO=?";

		this.jdbcTemplate.update(query, tramitehecho.getEhcodrem(), tramitehecho.getEhcodigo());
		return tramitehecho;
	}

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param Ehcodigo
	 *            String
	 */
	public void removeRemesaFromTramitesByEhcodigo(String Ehcodigo) {

		String query = "UPDATE TRAMITE_INSPECCION SET TICODREM = NULL WHERE TICODIGO=?";

		this.jdbcTemplate.update(query, Ehcodigo);

	}

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param notifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<NotificacionesComunicacionesBusqueda> findBlobTablaDocumentosHecho(
			NotificacionesComunicacionesBusqueda notifiComuni) {
		try {
			String query = "SELECT T2.TICODREM DHCODREM, T2.TICODIGO DHEHCODIGO , T1.Q5CODOCUMENTO DHCODDOC, T1.Q5DATAFILE DHDATAFILE, NULL DHFECHA, T1.Q5IDDOCUMENTUM Q5IDDOCUMENTUM "
					+ " FROM DOCUMENTO_HECHO T1, TRAMITE_INSPECCION T2, DOC_TRAMITE_HECHO T3 WHERE T1.Q5CODOCUMENTO= T3.CODOCUMENTO AND T2.TICODIGO=T3.EHCODIGO AND T2.TICODREM = ?";

			return (List<NotificacionesComunicacionesBusqueda>) this.jdbcTemplate.query(query.toString(),
					new RowMapper<NotificacionesComunicacionesBusqueda>() {
						public NotificacionesComunicacionesBusqueda mapRow(ResultSet resultSet, int rowNum)
								throws SQLException {
							return new NotificacionesComunicacionesBusqueda(resultSet.getString("DHCODREM"),
									resultSet.getString("DHEHCODIGO"), resultSet.getString("DHCODDOC"),
									resultSet.getBlob("DHDATAFILE"), resultSet.getString("Q5IDDOCUMENTUM"));
						}
					}, notifiComuni.getRmcodigo());

		} catch (EmptyResultDataAccessException e) {
			return null;
		}
	}

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param notifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findSumSizeBlobNotifiComuni(NotificacionesComunicacionesBusqueda notifiComuni) {

		String query = "SELECT SUM(T1.Q5SIZEFILE) TAMANO "
				+ " FROM DOCUMENTO_HECHO T1, TRAMITE_INSPECCION T2, DOC_TRAMITE_HECHO T3 WHERE T1.Q5CODOCUMENTO= T3.CODOCUMENTO AND T2.TICODIGO=T3.EHCODIGO AND T2.TICODREM = ? ";

		List<Object> params = new ArrayList<Object>();
		params.add(notifiComuni.getRmcodigo());

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             excepcion
	 */
	public TramiteInspeccion updateDenegacionTramite(TramiteInspeccion tramiteInspeccion) throws Exception {
		String query = "UPDATE TRAMITE_INSPECCION SET TICOMENTARIO=?,TIESTADOTRAMITE=? WHERE TICODIGO=?";

		this.jdbcTemplate.update(query, tramiteInspeccion.getTicomentario(), tramiteInspeccion.getTiestadotramite(),
				tramiteInspeccion.getTicodigo());
		return tramiteInspeccion;
	}

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	public TramiteInspeccion updateMatarEspera(TramiteInspeccion tramiteInspeccion) {
		String query = "UPDATE TRAMITE_INSPECCION SET TIMATARESPERA=? WHERE TICODIGO=?";

		this.jdbcTemplate.update(query, tramiteInspeccion.getTimatarespera(), tramiteInspeccion.getTicodigo());
		return tramiteInspeccion;
	}

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	public TramiteInspeccion updateAcuseReintentado(TramiteInspeccion tramiteInspeccion) {
		String query = "UPDATE TRAMITE_INSPECCION SET TIACUSEREINTENTADO=? WHERE TICODIGO=?";

		this.jdbcTemplate.update(query, tramiteInspeccion.getTiacusereintentado(), tramiteInspeccion.getTicodigo());
		return tramiteInspeccion;
	}

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	public TramiteInspeccion updateProceedingsIdPlatea(TramiteInspeccion tramiteInspeccion) {
		String query = "UPDATE TRAMITE_INSPECCION SET TIPROCEEDINGSIDPLATEA=? WHERE TICODIGO=?";

		this.jdbcTemplate.update(query, tramiteInspeccion.getTiproceedingsidplatea(), tramiteInspeccion.getTicodigo());
		return tramiteInspeccion;
	}

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	public TramiteInspeccion updateCodigoActa(TramiteInspeccion tramiteInspeccion) {
		String query = "UPDATE TRAMITE_INSPECCION SET TIANCODIGO=? WHERE TIATCODIGO=? AND TIANCODIGO=?";

		this.jdbcTemplate.update(query, tramiteInspeccion.getTiancodigoNuevo(), tramiteInspeccion.getTiatcodigo(),
				tramiteInspeccion.getTiancodigo());
		return tramiteInspeccion;
	}

	/**
	 * Busca todos los tramites ejecutados en un acta sin contar con el
	 * Levantamiento de acta.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTramitadosCount(TramiteInspeccion tramiteInspeccion, boolean todos) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM TRAMITE_INSPECCION t1 WHERE t1.TIACCODIGO = ? AND t1.TIESTADOTRAMITE = ? ");

		List<Object> params = new ArrayList<Object>();
		params.add(tramiteInspeccion.getTiaccodigo());

		if (!todos) {
			params.add(Y41bConstantes.TRAMITE_INSPECCIONES_LEVANTAMIENTO_ACTA);
			query.append(" AND t1.TICOTEE <> ?");
		}

		params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Elimina todos los tramites asociados a un acta.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 */
	@Transactional(readOnly = true)
	public void removeFromActa(TramiteInspeccion tramiteInspeccion) {
		String query = "DELETE FROM TRAMITE_INSPECCION WHERE TIACCODIGO = ?";

		this.jdbcTemplate.update(query, tramiteInspeccion.getTiaccodigo());
	}

	/**
	 * Finds a single row in the tramiteinspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @return TramiteInspeccionDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteInspeccionDetalle findUltimoTramiteHechoPorTipoTramite(
			TramiteInspeccionDetalle tramiteInspeccionDetalle) {
		try {
			String query = "SELECT tr1.TICODIGO TICODIGO, tr1.TIFECHAINICIO, tr1.TIFECHAFIN, tr1.TICOORTRASPASO, tr1.TICOMODESIGNADO "
					+ "FROM TRAMITE_INSPECCION tr1 "
					+ "WHERE TIFECHAINICIO = (SELECT MAX(TIFECHAINICIO) FROM TRAMITE_INSPECCION tr2 WHERE tr2.TIATCODIGO=? AND tr2.TICOTEE=?) AND tr1.TIATCODIGO=? AND ROWNUM=1";
			return (TramiteInspeccionDetalle) this.jdbcTemplate.queryForObject(query,
					new RowMapper<TramiteInspeccionDetalle>() {
						public TramiteInspeccionDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
							TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
							tramiteInspeccionDetalle.setTicodigo(resultSet.getString("TICODIGO"));
							tramiteInspeccionDetalle.setTifechainicio(resultSet.getDate("TIFECHAINICIO"));
							tramiteInspeccionDetalle.setTifechafin(resultSet.getDate("TIFECHAFIN"));
							tramiteInspeccionDetalle.setTicomodesignado(resultSet.getString("TICOMODESIGNADO"));
							tramiteInspeccionDetalle.setTicoortraspaso(resultSet.getString("TICOORTRASPASO"));
							return tramiteInspeccionDetalle;
						}
					}, tramiteInspeccionDetalle.getAtcodigo(), tramiteInspeccionDetalle.getTrcodigo(),
					tramiteInspeccionDetalle.getAtcodigo());
		} catch (EmptyResultDataAccessException e) {
			return new TramiteInspeccionDetalle();
		}
	}

	/**
	 * Finds a single row in the tramiteinspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * 
	 * @return TramiteInspeccionDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteInspeccionDetalle findTramiteRelacionado(TramiteInspeccionDetalle tramiteInspeccionDetalle) {
		try {
			String query = "SELECT tr1.TICODIGO TICODIGO " + "FROM TRAMITE_INSPECCION tr1 "
					+ "WHERE tr1.TIATCODIGO=? AND tr1.TICOTEE=? AND tr1.TICODIGORELACIONADO =?";
			return (TramiteInspeccionDetalle) this.jdbcTemplate.queryForObject(query,
					new RowMapper<TramiteInspeccionDetalle>() {
						public TramiteInspeccionDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
							return new TramiteInspeccionDetalle(resultSet.getString("TICODIGO"));
						}
					}, tramiteInspeccionDetalle.getAtcodigo(), tramiteInspeccionDetalle.getTrcodigo(),
					tramiteInspeccionDetalle.getTicodigo());
		} catch (EmptyResultDataAccessException e) {
			return new TramiteInspeccionDetalle();
		}
	}

	/**
	 * Busca los tramites de Asignacion de responsable de expediente y de
	 * registro de inspeccion de un acta.
	 * 
	 * @param acta
	 *            Acta
	 * @return List<TramiteInspeccion>
	 */
	@Transactional(readOnly = true)
	public List<TramiteInspeccion> findTramitesAperturaPorActa(Acta acta) {
		String query = "SELECT t1.TICODIGO TICODIGO, t1.TIATCODIGO TIATCODIGO, t1.TIACCODIGO TIACCODIGO, t1.TICOTEE TICOTEE, t1.TIFECHAINICIO TIFECHAINICIO, t1.TIFECHAFIN TIFECHAFIN, t1.TICOMOASIGNADO TICOMOASIGNADO, t1.TICOMOEJECUCION TICOMOEJECUCION, t1.TICOMENTARIO TICOMENTARIO, t1.TICOMODESIGNADO TICOMODESIGNADO, t1.TICOALREL TICOALREL, t1.TICOORTRASPASO TICOORTRASPASO, t1.TITELINF2 TITELINF2, t1.TICOMPDIRECCION TICOMPDIRECCION, t1.TIAPE1INF TIAPE1INF, t1.TIAPE2INF, t1.TIFECHAAIP TIFECHAAIP, t1.TIDOCUMENTACIONREQUERIDA TIDOCUMENTACIONREQUERIDA, t1.TIDOCUMENTACIONREQUERIDAE TIDOCUMENTACIONREQUERIDAE, t1.TIDECODIGO TIDECODIGO, t1.TIFECHARESOLUCION TIFECHARESOLUCION, t1.TIFECHARECURSO TIFECHARECURSO, t1.TITIPORECURSO TITIPORECURSO, t1.TIABOGADO TIABOGADO, t1.TIMOTIVORECURSO TIMOTIVORECURSO, t1.TIESTIMACION TIESTIMACION, t1.TIFECHACIERRE TIFECHACIERRE, t1.TIDESTINATARIO TIDESTINATARIO, t1.TIFECHACOMUNICACION TIFECHACOMUNICACION, t1.TITIPOCOMUNICACION TITIPOCOMUNICACION, t1.TITIPONOTIFICACION TITIPONOTIFICACION, t1.TINOTIFICACIONPORACTA TINOTIFICACIONPORACTA, t1.TINUMREGISTROSALIDA TINUMREGISTROSALIDA, t1.TIFECHAREGISTROSALIDA TIFECHAREGISTROSALIDA, t1.TIACUSERECIBO TIACUSERECIBO, t1.TIACUSERECIBORECIBIDO TIACUSERECIBORECIBIDO, t1.TINUMREGISTROENTRADA TINUMREGISTROENTRADA, t1.TIFECHAREGISTROENTRADA TIFECHAREGISTROENTRADA, t1.TIIDNOTIFICACIONPLATEA TIIDNOTIFICACIONPLATEA, t1.TINOMBRETRAMITE TINOMBRETRAMITE, t1.TIIDDESTINATARIO TIIDDESTINATARIO, t1.TIESTADOTRAMITE TIESTADOTRAMITE, t1.TIREQUIEREFIRMA TIREQUIEREFIRMA, t1.TITEXTOCOMUNICACION TITEXTOCOMUNICACION, t1.TITIPONOTIFICACIONPLATEA TITIPONOTIFICACIONPLATEA, t1.TIIDESPERAPLATEA TIIDESPERAPLATEA, t1.TIMATARESPERA TIMATARESPERA, t1.TIASUNTOCOMUNICACION TIASUNTOCOMUNICACION, t1.TIFECHAENVIOBOPVBOE TIFECHAENVIOBOPVBOE, t1.TIFECHAPUBLICACIONBOPV TIFECHAPUBLICACIONBOPV, t1.TIFECHAPUBLICACIONAYTO TIFECHAPUBLICACIONAYTO, t1.TISEDE TISEDE, t1.TIFECHALIMITE TIFECHALIMITE, t1.TICODREM TICODREM, t1.TIENVREM TIENVREM, t1.TIFCODIGO TIFCODIGO, t1.TIIDMAILORIGEN TIIDMAILORIGEN, t1.TIMAILORIGEN TIMAILORIGEN, t1.TIIDMAILDESTINO TIIDMAILDESTINO, t1.TIMAILDESTINO TIMAILDESTINO, t1.TIPROCEEDINGSIDPLATEA TIPROCEEDINGSIDPLATEA, t1.TIACUSEREINTENTADO TIACUSEREINTENTADO, t1.TIAUTOMATICO TIAUTOMATICO, t1.TIORIGENALEGACION TIORIGENALEGACION, t1.TIANCODIGO TIANCODIGO, t1.TITIPACTUA TITIPACTUA, t1.TIRESPUESTARECEPCION TIRESPUESTARECEPCION, t1.TIRESUMENRECEPCION TIRESUMENRECEPCION, t1.TIFECHAREDALERTA TIFECHAREDALERTA, t1.TIINCLUSIREDALERTA TIINCLUSIREDALERTA, t1.TIMOTIVOREDALERTA TIMOTIVOREDALERTA, t1.TIJUSTIFICACIONINFRACCION TIJUSTIFICACIONINFRACCION, t1.TIFECHAENVLAB TIFECHAENVLAB, t1.TICODMUESTRA TICODMUESTRA, t1.TILACODIGO TILACODIGO, t1.TIDETANA TIDETANA, t1.TIFECHARESENS TIFECHARESENS, t1.TICODINFENSAY TICODINFENSAY, t1.TIRESUDICTAM TIRESUDICTAM, t1.TICONSTATACION TICONSTATACION, t1.TIFECHADESIN TIFECHADESIN, t1.TINUMDESIN TINUMDESIN,t1.TINUMIN TINUMIN, t1.TIDESTINODESIN TIDESTINODESIN, t1.TIDESTRUCCIONINSITU TIDESTRUCCIONINSITU, t1.TIEMPRESAGEST TIEMPRESAGEST, t1.TINUMRECUPE TINUMRECUPE, t1.TINUMADESTRUIR TINUMADESTRUIR, t1.TINUMADEVOLVER TINUMADEVOLVER, t1.TIFECHAEMIINF TIFECHAEMIINF, t1.TIHORAINICIOEMIINF TIHORAINICIOEMIINF, t1.TIHORAFININF TIHORAFININF, t1.TIDNIINF TIDNIINF, t1.TINOMBREINF TINOMBREINF, t1.TINORA_PROVINCIA_ID TINORAPROVINCIAID, t1.TINOMBRE_PROVINCIA TINOMBREPROVINCIA, t1.TINORA_MUNICIPIO_ID TINORAMUNICIPIOID, t1.TINOMBRE_MUNICIPIO TINOMBREMUNICIPIO, t1.TINORA_LOCALIDAD_ID TINORALOCALIDADID, t1.TINOMBRE_LOCALIDAD TINOMBRELOCALIDAD, t1.TINORA_CALLE_ID TINORACALLEID, t1.TINOMBRE_CALLE TINOMBRECALLE, t1.TINORA_CP_ID TINORACPID, t1.TINOMBRE_CP TINOMBRECP, t1.TINORA_PORTAL_ID TINORAPORTALID, t1.TINOMBRE_PORTAL TINOMBREPORTAL, t1.TINOMBRE_PISO TINOMBREPISO, t1.TIDIRECCION_NOCAPV TIDIRECCIONNOCAPV, t1.TIEXTRANJERO TIEXTRANJERO, t1.TINORA_PAIS_ID TINORAPAISID, t1.TINOMBRE_PAIS TINOMBREPAIS, t1.TITELINF TITELINF, t1.TIENCONDICIONINF TIENCONDICIONINF, t1.TIINFORME TIINFORME, t1.TIVALORACION TIVALORACION, t1.TIFECHAACEPTACION TIFECHAACEPTACION, t1.TIFECHAAMPLI TIFECHAAMPLI, t1.TIMOTIVOAMPLI TIMOTIVOAMPLI, t1.TIFECALTA TIFECALTA, t1.TIFECMODIF TIFECMODIF, t1.TICOCR TICOCR, t1.TILIGADOPROTOCOLO TILIGADOPROTOCOLO, t1.TIISTELEMATICO  TIISTELEMATICO, t1.TIISSIR TIISSIR,t1.TIISSIRCONNUMREGENTORI TIISSIRCONNUMREGENTORI, t1.TICOCMREL TICOCMREL, t1.TICOPG TICOPG, t1.TIEXCLUIRCIERRE TIEXCLUIRCIERRE, t1.TIARCHIVAR TIARCHIVAR, t2.TICODIGO TRAMINSTICODIGO, t2.TIATCODIGO TRAMINSTIATCODIGO,t2.TIACCODIGO TRAMINSTIACCODIGO, t2.TICOTEE TRAMINSTICOTEE, t2.TIFECHAINICIO TRAMINSTIFECHAINICIO, t2.TIFECHAFIN TRAMINSTIFECHAFIN, t2.TICOMOASIGNADO TRAMINSTICOMOASIGNADO, t2.TICOMOEJECUCION TRAMINSTICOMOEJECUCION, t2.TICOMENTARIO TRAMINSTICOMENTARIO, t2.TICOMODESIGNADO TRAMINSTICOMODESIGNADO, t2.TIDOCUMENTACIONREQUERIDA TRAMINSTIDOCUREQUERIDA, t2.TIDOCUMENTACIONREQUERIDAE TRAMINSTIDOCUREQUERIDAE, t2.TIDECODIGO TRAMINSTIDECODIGO, t2.TIFECHARESOLUCION TRAMINSTIFECHARESOLUCION, t2.TIFECHARECURSO TRAMINSTIFECHARECURSO, t2.TITIPORECURSO TRAMINSTITIPORECURSO, t2.TIABOGADO TRAMINSTIABOGADO, t2.TIMOTIVORECURSO TRAMINSTIMOTIVORECURSO, t2.TIESTIMACION TRAMINSTIESTIMACION, t2.TIFECHACIERRE TRAMINSTIFECHACIERRE, t2.TIDESTINATARIO TRAMINSTIDESTINATARIO, t2.TIFECHACOMUNICACION TRAMINSTIFECHACOMUNICACION, t2.TITIPOCOMUNICACION TRAMINSTITIPOCOMUNICACION, t2.TITIPONOTIFICACION TRAMINSTITIPONOTIFICACION, t2.TINOTIFICACIONPORACTA TRAMINSTINOTIFICACIONPORACTA, t2.TINUMREGISTROSALIDA TRAMINSTINUMREGISTROSALIDA, t2.TIFECHAREGISTROSALIDA TRAMINSTIFECHAREGSALIDA, t2.TIACUSERECIBO TRAMINSTIACUSERECIBO, t2.TIACUSERECIBORECIBIDO TRAMINSTIACUSERECRECIBIDO, t2.TINUMREGISTROENTRADA TRAMINSTINUMREGISTROENTRADA, t2.TIFECHAREGISTROENTRADA TRAMINSTIFECHAREGENTRADA, t2.TIIDNOTIFICACIONPLATEA TRAMINSTIIDNOTIFPLATEA, t2.TINOMBRETRAMITE TRAMINSTINOMBRETRAMITE, t2.TIIDDESTINATARIO TRAMINSTIIDDESTINATARIO, t2.TIESTADOTRAMITE TRAMINSTIESTADOTRAMITE, t2.TIREQUIEREFIRMA TRAMINSTIREQUIEREFIRMA, t2.TITEXTOCOMUNICACION TRAMINSTITEXTOCOMUNICACION, t2.TITIPONOTIFICACIONPLATEA TRAMINSTITIPONOTIFPLATEA, t2.TIIDESPERAPLATEA TRAMINSTIIDESPERAPLATEA, t2.TIMATARESPERA TRAMINSTIMATARESPERA, t2.TIASUNTOCOMUNICACION TRAMINSTIASUNTOCOMUNICACION, t2.TIFECHAENVIOBOPVBOE TRAMINSTIFECHAENVIOBOPVBOE, t2.TIFECHAPUBLICACIONBOPV TRAMINSTIFECHAPUBBOPV, t2.TIFECHAPUBLICACIONAYTO TRAMINSTIFECHAPUBAYTO, t2.TISEDE TRAMINSTISEDE, t2.TIFECHALIMITE TRAMINSTIFECHALIMITE, t2.TICODREM TRAMINSTICODREM, t2.TIENVREM TRAMINSTIENVREM, t2.TIFCODIGO TRAMINSTIFCODIGO, t2.TIIDMAILORIGEN TRAMINSTIIDMAILORIGEN, t2.TIMAILORIGEN TRAMINSTIMAILORIGEN, t2.TIIDMAILDESTINO TRAMINSTIIDMAILDESTINO, t2.TIMAILDESTINO TRAMINSTIMAILDESTINO, t2.TIPROCEEDINGSIDPLATEA TRAMINSTIPROCEEDINGSIDPLATEA, t2.TIACUSEREINTENTADO TRAMINSTIACUSEREINTENTADO, t2.TIAUTOMATICO TRAMINSTIAUTOMATICO, t2.TIORIGENALEGACION TRAMINSTIORIGENALEGACION, t2.TIANCODIGO TRAMINSTIANCODIGO, t2.TITIPACTUA TRAMINSTITIPACTUA, t2.TIRESPUESTARECEPCION TRAMINSTIRESPUESTARECEPCION, t2.TIRESUMENRECEPCION TRAMINSTIRESUMENRECEPCION, t2.TIFECHAREDALERTA TRAMINSTIFECHAREDALERTA, t2.TIINCLUSIREDALERTA TRAMINSTIINCLUSIREDALERTA, t2.TIMOTIVOREDALERTA TRAMINSTIMOTIVOREDALERTA, t2.TIJUSTIFICACIONINFRACCION TRAMINSTIJUSTIFINFRACCION, t2.TIFECHAENVLAB TRAMINSTIFECHAENVLAB, t2.TICODMUESTRA TRAMINSTICODMUESTRA, t2.TILACODIGO TRAMINSTILACODIGO, t2.TIDETANA TRAMINSTIDETANA, t2.TIFECHARESENS TRAMINSTIFECHARESENS, t2.TICODINFENSAY TRAMINSTICODINFENSAY, t2.TIRESUDICTAM TRAMINSTIRESUDICTAM, t2.TICONSTATACION TRAMINSTICONSTATACION, t2.TIFECHADESIN TRAMINSTIFECHADESIN, t2.TINUMDESIN TRAMINSTINUMDESIN,t2.TINUMIN TRAMINSTINUMIN, t2.TIDESTINODESIN TRAMINSTIDESTINODESIN, t2.TIDESTRUCCIONINSITU TRAMINSTIDESTRUCCIONINSITU, t2.TIEMPRESAGEST TRAMINSTIEMPRESAGEST, t2.TINUMRECUPE TRAMINSTINUMRECUPE, t2.TINUMADESTRUIR TRAMINSTINUMADESTRUIR, t2.TINUMADEVOLVER TRAMINSTINUMADEVOLVER, t2.TIFECHAEMIINF TRAMINSTIFECHAEMIINF, t2.TIHORAINICIOEMIINF TRAMINSTIHORAINICIOEMIINF, t2.TIHORAFININF TRAMINSTIHORAFININF, t2.TIDNIINF TRAMINSTIDNIINF, t2.TINOMBREINF TRAMINSTINOMBREINF, t2.TINORA_PROVINCIA_ID TRAMINSTINORAPROVINCIAID, t2.TINOMBRE_PROVINCIA TRAMINSTINOMBREPROVINCIA, t2.TINORA_MUNICIPIO_ID TRAMINSTINORAMUNICIPIOID, t2.TINOMBRE_MUNICIPIO TRAMINSTINOMBREMUNICIPIO, t2.TINORA_LOCALIDAD_ID TRAMINSTINORALOCALIDADID, t2.TINOMBRE_LOCALIDAD TRAMINSTINOMBRELOCALIDAD, t2.TINORA_CALLE_ID TRAMINSTINORACALLEID, t2.TINOMBRE_CALLE TRAMINSTINOMBRECALLE, t2.TINORA_CP_ID TRAMINSTINORACPID, t2.TINOMBRE_CP TRAMINSTINOMBRECP, t2.TINORA_PORTAL_ID TRAMINSTINORAPORTALID, t2.TINOMBRE_PORTAL TRAMINSTINOMBREPORTAL, t2.TINOMBRE_PISO TRAMINSTINOMBREPISO, t2.TIDIRECCION_NOCAPV TRAMINSTIDIRECCIONNOCAPV, t2.TIEXTRANJERO TRAMINSTIEXTRANJERO, t2.TINORA_PAIS_ID TRAMINSTINORAPAISID, t2.TINOMBRE_PAIS TRAMINSTINOMBREPAIS, t2.TITELINF TRAMINSTITELINF, t2.TIENCONDICIONINF TRAMINSTIENCONDICIONINF, t2.TIINFORME TRAMINSTIINFORME, t2.TIVALORACION TRAMINSTIVALORACION, t2.TIFECHAACEPTACION TRAMINSTIFECHAACEPTACION, t2.TIFECHAAMPLI TRAMINSTIFECHAAMPLI, t2.TIMOTIVOAMPLI TRAMINSTIMOTIVOAMPLI, t2.TICODIGORELACIONADO TRAMINSTICODIGORELACIONADO, t2.TICOORTRASPASO TRAMINSTICOORTRASPASO, t2.TITELINF2 TRAMINSTITELINF2, t2.TICOMPDIRECCION TRAMINSTICOMPDIRECCION, t2.TIAPE1INF TRAMINSTIAPE1INF, t2.TIAPE2INF TRAMINSTIAPE2INF, t2.TIFECHAAIP TRAMINSTIFECHAAIP, t2.TIFECALTA TRAMINSTIFECALTA, t2.TIFECMODIF TRAMINSTIFECMODIF FROM TRAMITE_INSPECCION t1, TRAMITE_INSPECCION t2, ACTUACION t3 WHERE t1.TICODIGORELACIONADO = t2.TICODIGO(+) AND t1.TIATCODIGO = t3.ATCODIGO AND (( t1.ticotee = ? AND t1.TIESTADOTRAMITE = ? ) OR t1.TICOTEE = ?) AND t3.ATCOAC = ?";

		List<Object> params = new ArrayList<Object>();
		params.add(Y41bConstantes.TRAMITE_INSPECCIONES_ASIGNACION_RESPONSABLE_EXPEDIENTE);
		params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		params.add(Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_INSPECCION);
		params.add(acta.getAccodigo());

		return (List<TramiteInspeccion>) this.jdbcTemplate.query(query, this.rwMap, params.toArray());
	}

	/**
	 * Busca los tramites de Asignacion de responsable de expediente y de
	 * registro de inspeccion de un acta.
	 * 
	 * @param acta
	 *            Acta
	 * @return List<TramiteInspeccion>
	 */
	@Transactional(readOnly = true)
	public List<TramiteInspeccion> findTramitesAperturaPorActuacion(Actuacion actuacion) {
		String query = "SELECT t1.TICODIGO TICODIGO, t1.TIATCODIGO TIATCODIGO, t1.TIACCODIGO TIACCODIGO, t1.TICOTEE TICOTEE, t1.TIFECHAINICIO TIFECHAINICIO, t1.TIFECHAFIN TIFECHAFIN, t1.TICOMOASIGNADO TICOMOASIGNADO, t1.TICOMOEJECUCION TICOMOEJECUCION, t1.TICOMENTARIO TICOMENTARIO, t1.TICOMODESIGNADO TICOMODESIGNADO, t1.TICOALREL TICOALREL, t1.TICOORTRASPASO TICOORTRASPASO, t1.TITELINF2 TITELINF2, t1.TICOMPDIRECCION TICOMPDIRECCION, t1.TIAPE1INF TIAPE1INF, t1.TIAPE2INF, t1.TIFECHAAIP TIFECHAAIP, t1.TIDOCUMENTACIONREQUERIDA TIDOCUMENTACIONREQUERIDA, t1.TIDOCUMENTACIONREQUERIDAE TIDOCUMENTACIONREQUERIDAE, t1.TIDECODIGO TIDECODIGO, t1.TIFECHARESOLUCION TIFECHARESOLUCION, t1.TIFECHARECURSO TIFECHARECURSO, t1.TITIPORECURSO TITIPORECURSO, t1.TIABOGADO TIABOGADO, t1.TIMOTIVORECURSO TIMOTIVORECURSO, t1.TIESTIMACION TIESTIMACION, t1.TIFECHACIERRE TIFECHACIERRE, t1.TIDESTINATARIO TIDESTINATARIO, t1.TIFECHACOMUNICACION TIFECHACOMUNICACION, t1.TITIPOCOMUNICACION TITIPOCOMUNICACION, t1.TITIPONOTIFICACION TITIPONOTIFICACION, t1.TINOTIFICACIONPORACTA TINOTIFICACIONPORACTA, t1.TINUMREGISTROSALIDA TINUMREGISTROSALIDA, t1.TIFECHAREGISTROSALIDA TIFECHAREGISTROSALIDA, t1.TIACUSERECIBO TIACUSERECIBO, t1.TIACUSERECIBORECIBIDO TIACUSERECIBORECIBIDO, t1.TINUMREGISTROENTRADA TINUMREGISTROENTRADA, t1.TIFECHAREGISTROENTRADA TIFECHAREGISTROENTRADA, t1.TIIDNOTIFICACIONPLATEA TIIDNOTIFICACIONPLATEA, t1.TINOMBRETRAMITE TINOMBRETRAMITE, t1.TIIDDESTINATARIO TIIDDESTINATARIO, t1.TIESTADOTRAMITE TIESTADOTRAMITE, t1.TIREQUIEREFIRMA TIREQUIEREFIRMA, t1.TITEXTOCOMUNICACION TITEXTOCOMUNICACION, t1.TITIPONOTIFICACIONPLATEA TITIPONOTIFICACIONPLATEA, t1.TIIDESPERAPLATEA TIIDESPERAPLATEA, t1.TIMATARESPERA TIMATARESPERA, t1.TIASUNTOCOMUNICACION TIASUNTOCOMUNICACION, t1.TIFECHAENVIOBOPVBOE TIFECHAENVIOBOPVBOE, t1.TIFECHAPUBLICACIONBOPV TIFECHAPUBLICACIONBOPV, t1.TIFECHAPUBLICACIONAYTO TIFECHAPUBLICACIONAYTO, t1.TISEDE TISEDE, t1.TIFECHALIMITE TIFECHALIMITE, t1.TICODREM TICODREM, t1.TIENVREM TIENVREM, t1.TIFCODIGO TIFCODIGO, t1.TIIDMAILORIGEN TIIDMAILORIGEN, t1.TIMAILORIGEN TIMAILORIGEN, t1.TIIDMAILDESTINO TIIDMAILDESTINO, t1.TIMAILDESTINO TIMAILDESTINO, t1.TIPROCEEDINGSIDPLATEA TIPROCEEDINGSIDPLATEA, t1.TIACUSEREINTENTADO TIACUSEREINTENTADO, t1.TIAUTOMATICO TIAUTOMATICO, t1.TIORIGENALEGACION TIORIGENALEGACION, t1.TIANCODIGO TIANCODIGO, t1.TITIPACTUA TITIPACTUA, t1.TIRESPUESTARECEPCION TIRESPUESTARECEPCION, t1.TIRESUMENRECEPCION TIRESUMENRECEPCION, t1.TIFECHAREDALERTA TIFECHAREDALERTA, t1.TIINCLUSIREDALERTA TIINCLUSIREDALERTA, t1.TIMOTIVOREDALERTA TIMOTIVOREDALERTA, t1.TIJUSTIFICACIONINFRACCION TIJUSTIFICACIONINFRACCION, t1.TIFECHAENVLAB TIFECHAENVLAB, t1.TICODMUESTRA TICODMUESTRA, t1.TILACODIGO TILACODIGO, t1.TIDETANA TIDETANA, t1.TIFECHARESENS TIFECHARESENS, t1.TICODINFENSAY TICODINFENSAY, t1.TIRESUDICTAM TIRESUDICTAM, t1.TICONSTATACION TICONSTATACION, t1.TIFECHADESIN TIFECHADESIN, t1.TINUMDESIN TINUMDESIN,t1.TINUMIN TINUMIN, t1.TIDESTINODESIN TIDESTINODESIN, t1.TIDESTRUCCIONINSITU TIDESTRUCCIONINSITU, t1.TIEMPRESAGEST TIEMPRESAGEST, t1.TINUMRECUPE TINUMRECUPE, t1.TINUMADESTRUIR TINUMADESTRUIR, t1.TINUMADEVOLVER TINUMADEVOLVER, t1.TIFECHAEMIINF TIFECHAEMIINF, t1.TIHORAINICIOEMIINF TIHORAINICIOEMIINF, t1.TIHORAFININF TIHORAFININF, t1.TIDNIINF TIDNIINF, t1.TINOMBREINF TINOMBREINF, t1.TINORA_PROVINCIA_ID TINORAPROVINCIAID, t1.TINOMBRE_PROVINCIA TINOMBREPROVINCIA, t1.TINORA_MUNICIPIO_ID TINORAMUNICIPIOID, t1.TINOMBRE_MUNICIPIO TINOMBREMUNICIPIO, t1.TINORA_LOCALIDAD_ID TINORALOCALIDADID, t1.TINOMBRE_LOCALIDAD TINOMBRELOCALIDAD, t1.TINORA_CALLE_ID TINORACALLEID, t1.TINOMBRE_CALLE TINOMBRECALLE, t1.TINORA_CP_ID TINORACPID, t1.TINOMBRE_CP TINOMBRECP, t1.TINORA_PORTAL_ID TINORAPORTALID, t1.TINOMBRE_PORTAL TINOMBREPORTAL, t1.TINOMBRE_PISO TINOMBREPISO, t1.TIDIRECCION_NOCAPV TIDIRECCIONNOCAPV, t1.TIEXTRANJERO TIEXTRANJERO, t1.TINORA_PAIS_ID TINORAPAISID, t1.TINOMBRE_PAIS TINOMBREPAIS, t1.TITELINF TITELINF, t1.TIENCONDICIONINF TIENCONDICIONINF, t1.TIINFORME TIINFORME, t1.TIVALORACION TIVALORACION, t1.TIFECHAACEPTACION TIFECHAACEPTACION, t1.TIFECHAAMPLI TIFECHAAMPLI, t1.TIMOTIVOAMPLI TIMOTIVOAMPLI, t1.TIFECALTA TIFECALTA, t1.TIFECMODIF TIFECMODIF, t1.TICOCR TICOCR, t1.TILIGADOPROTOCOLO TILIGADOPROTOCOLO, t1.TIISTELEMATICO  TIISTELEMATICO, t1.TIISSIR TIISSIR, t1.TIISSIRCONNUMREGENTORI TIISSIRCONNUMREGENTORI,t1.TICOCMREL TICOCMREL, t1.TICOPG TICOPG, t1.TIEXCLUIRCIERRE TIEXCLUIRCIERRE, t1.TIARCHIVAR TIARCHIVAR, t2.TICODIGO TRAMINSTICODIGO, t2.TIATCODIGO TRAMINSTIATCODIGO,t2.TIACCODIGO TRAMINSTIACCODIGO, t2.TICOTEE TRAMINSTICOTEE, t2.TIFECHAINICIO TRAMINSTIFECHAINICIO, t2.TIFECHAFIN TRAMINSTIFECHAFIN, t2.TICOMOASIGNADO TRAMINSTICOMOASIGNADO, t2.TICOMOEJECUCION TRAMINSTICOMOEJECUCION, t2.TICOMENTARIO TRAMINSTICOMENTARIO, t2.TICOMODESIGNADO TRAMINSTICOMODESIGNADO, t2.TIDOCUMENTACIONREQUERIDA TRAMINSTIDOCUREQUERIDA, t2.TIDOCUMENTACIONREQUERIDAE TRAMINSTIDOCUREQUERIDAE, t2.TIDECODIGO TRAMINSTIDECODIGO, t2.TIFECHARESOLUCION TRAMINSTIFECHARESOLUCION, t2.TIFECHARECURSO TRAMINSTIFECHARECURSO, t2.TITIPORECURSO TRAMINSTITIPORECURSO, t2.TIABOGADO TRAMINSTIABOGADO, t2.TIMOTIVORECURSO TRAMINSTIMOTIVORECURSO, t2.TIESTIMACION TRAMINSTIESTIMACION, t2.TIFECHACIERRE TRAMINSTIFECHACIERRE, t2.TIDESTINATARIO TRAMINSTIDESTINATARIO, t2.TIFECHACOMUNICACION TRAMINSTIFECHACOMUNICACION, t2.TITIPOCOMUNICACION TRAMINSTITIPOCOMUNICACION, t2.TITIPONOTIFICACION TRAMINSTITIPONOTIFICACION, t2.TINOTIFICACIONPORACTA TRAMINSTINOTIFICACIONPORACTA, t2.TINUMREGISTROSALIDA TRAMINSTINUMREGISTROSALIDA, t2.TIFECHAREGISTROSALIDA TRAMINSTIFECHAREGSALIDA, t2.TIACUSERECIBO TRAMINSTIACUSERECIBO, t2.TIACUSERECIBORECIBIDO TRAMINSTIACUSERECRECIBIDO, t2.TINUMREGISTROENTRADA TRAMINSTINUMREGISTROENTRADA, t2.TIFECHAREGISTROENTRADA TRAMINSTIFECHAREGENTRADA, t2.TIIDNOTIFICACIONPLATEA TRAMINSTIIDNOTIFPLATEA, t2.TINOMBRETRAMITE TRAMINSTINOMBRETRAMITE, t2.TIIDDESTINATARIO TRAMINSTIIDDESTINATARIO, t2.TIESTADOTRAMITE TRAMINSTIESTADOTRAMITE, t2.TIREQUIEREFIRMA TRAMINSTIREQUIEREFIRMA, t2.TITEXTOCOMUNICACION TRAMINSTITEXTOCOMUNICACION, t2.TITIPONOTIFICACIONPLATEA TRAMINSTITIPONOTIFPLATEA, t2.TIIDESPERAPLATEA TRAMINSTIIDESPERAPLATEA, t2.TIMATARESPERA TRAMINSTIMATARESPERA, t2.TIASUNTOCOMUNICACION TRAMINSTIASUNTOCOMUNICACION, t2.TIFECHAENVIOBOPVBOE TRAMINSTIFECHAENVIOBOPVBOE, t2.TIFECHAPUBLICACIONBOPV TRAMINSTIFECHAPUBBOPV, t2.TIFECHAPUBLICACIONAYTO TRAMINSTIFECHAPUBAYTO, t2.TISEDE TRAMINSTISEDE, t2.TIFECHALIMITE TRAMINSTIFECHALIMITE, t2.TICODREM TRAMINSTICODREM, t2.TIENVREM TRAMINSTIENVREM, t2.TIFCODIGO TRAMINSTIFCODIGO, t2.TIIDMAILORIGEN TRAMINSTIIDMAILORIGEN, t2.TIMAILORIGEN TRAMINSTIMAILORIGEN, t2.TIIDMAILDESTINO TRAMINSTIIDMAILDESTINO, t2.TIMAILDESTINO TRAMINSTIMAILDESTINO, t2.TIPROCEEDINGSIDPLATEA TRAMINSTIPROCEEDINGSIDPLATEA, t2.TIACUSEREINTENTADO TRAMINSTIACUSEREINTENTADO, t2.TIAUTOMATICO TRAMINSTIAUTOMATICO, t2.TIORIGENALEGACION TRAMINSTIORIGENALEGACION, t2.TIANCODIGO TRAMINSTIANCODIGO, t2.TITIPACTUA TRAMINSTITIPACTUA, t2.TIRESPUESTARECEPCION TRAMINSTIRESPUESTARECEPCION, t2.TIRESUMENRECEPCION TRAMINSTIRESUMENRECEPCION, t2.TIFECHAREDALERTA TRAMINSTIFECHAREDALERTA, t2.TIINCLUSIREDALERTA TRAMINSTIINCLUSIREDALERTA, t2.TIMOTIVOREDALERTA TRAMINSTIMOTIVOREDALERTA, t2.TIJUSTIFICACIONINFRACCION TRAMINSTIJUSTIFINFRACCION, t2.TIFECHAENVLAB TRAMINSTIFECHAENVLAB, t2.TICODMUESTRA TRAMINSTICODMUESTRA, t2.TILACODIGO TRAMINSTILACODIGO, t2.TIDETANA TRAMINSTIDETANA, t2.TIFECHARESENS TRAMINSTIFECHARESENS, t2.TICODINFENSAY TRAMINSTICODINFENSAY, t2.TIRESUDICTAM TRAMINSTIRESUDICTAM, t2.TICONSTATACION TRAMINSTICONSTATACION, t2.TIFECHADESIN TRAMINSTIFECHADESIN, t2.TINUMDESIN TRAMINSTINUMDESIN,t2.TINUMIN TRAMINSTINUMIN, t2.TIDESTINODESIN TRAMINSTIDESTINODESIN, t2.TIDESTRUCCIONINSITU TRAMINSTIDESTRUCCIONINSITU, t2.TIEMPRESAGEST TRAMINSTIEMPRESAGEST, t2.TINUMRECUPE TRAMINSTINUMRECUPE, t2.TINUMADESTRUIR TRAMINSTINUMADESTRUIR, t2.TINUMADEVOLVER TRAMINSTINUMADEVOLVER, t2.TIFECHAEMIINF TRAMINSTIFECHAEMIINF, t2.TIHORAINICIOEMIINF TRAMINSTIHORAINICIOEMIINF, t2.TIHORAFININF TRAMINSTIHORAFININF, t2.TIDNIINF TRAMINSTIDNIINF, t2.TINOMBREINF TRAMINSTINOMBREINF, t2.TINORA_PROVINCIA_ID TRAMINSTINORAPROVINCIAID, t2.TINOMBRE_PROVINCIA TRAMINSTINOMBREPROVINCIA, t2.TINORA_MUNICIPIO_ID TRAMINSTINORAMUNICIPIOID, t2.TINOMBRE_MUNICIPIO TRAMINSTINOMBREMUNICIPIO, t2.TINORA_LOCALIDAD_ID TRAMINSTINORALOCALIDADID, t2.TINOMBRE_LOCALIDAD TRAMINSTINOMBRELOCALIDAD, t2.TINORA_CALLE_ID TRAMINSTINORACALLEID, t2.TINOMBRE_CALLE TRAMINSTINOMBRECALLE, t2.TINORA_CP_ID TRAMINSTINORACPID, t2.TINOMBRE_CP TRAMINSTINOMBRECP, t2.TINORA_PORTAL_ID TRAMINSTINORAPORTALID, t2.TINOMBRE_PORTAL TRAMINSTINOMBREPORTAL, t2.TINOMBRE_PISO TRAMINSTINOMBREPISO, t2.TIDIRECCION_NOCAPV TRAMINSTIDIRECCIONNOCAPV, t2.TIEXTRANJERO TRAMINSTIEXTRANJERO, t2.TINORA_PAIS_ID TRAMINSTINORAPAISID, t2.TINOMBRE_PAIS TRAMINSTINOMBREPAIS, t2.TITELINF TRAMINSTITELINF, t2.TIENCONDICIONINF TRAMINSTIENCONDICIONINF, t2.TIINFORME TRAMINSTIINFORME, t2.TIVALORACION TRAMINSTIVALORACION, t2.TIFECHAACEPTACION TRAMINSTIFECHAACEPTACION, t2.TIFECHAAMPLI TRAMINSTIFECHAAMPLI, t2.TIMOTIVOAMPLI TRAMINSTIMOTIVOAMPLI, t2.TICODIGORELACIONADO TRAMINSTICODIGORELACIONADO, t2.TICOORTRASPASO TRAMINSTICOORTRASPASO, t2.TITELINF2 TRAMINSTITELINF2, t2.TICOMPDIRECCION TRAMINSTICOMPDIRECCION, t2.TIAPE1INF TRAMINSTIAPE1INF, t2.TIAPE2INF TRAMINSTIAPE2INF, t2.TIFECHAAIP TRAMINSTIFECHAAIP, t2.TIFECALTA TRAMINSTIFECALTA, t2.TIFECMODIF TRAMINSTIFECMODIF FROM TRAMITE_INSPECCION t1, TRAMITE_INSPECCION t2, ACTUACION t3 WHERE t1.TICODIGORELACIONADO = t2.TICODIGO(+) AND t1.TIATCODIGO = t3.ATCODIGO AND (t1.TICOTEE = ? OR t1.TICOTEE = ?) AND t3.ATCODIGO = ?";

		List<Object> params = new ArrayList<Object>();
		params.add(Y41bConstantes.TRAMITE_INSPECCIONES_ASIGNACION_RESPONSABLE_EXPEDIENTE);
		params.add(Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_INSPECCION);
		params.add(actuacion.getAtcodigo());

		return (List<TramiteInspeccion>) this.jdbcTemplate.query(query, this.rwMap, params.toArray());
	}

	/**
	 * Busca el tramite de registro de inspeccion de un acta.
	 * 
	 * @param acta
	 *            Acta
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findTramiteRegistroInspeccionPorActaCount(Acta acta) {
		String query = "SELECT COUNT(1) FROM TRAMITE_INSPECCION t1, ACTUACION t2 WHERE t1.TIATCODIGO = t2.ATCODIGO AND t1.TICOTEE = ? AND t2.ATCOAC = ?";

		List<Object> params = new ArrayList<Object>();
		params.add(Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_INSPECCION);
		params.add(acta.getAccodigo());

		return this.jdbcTemplate.queryForLong(query, params.toArray());
	}

	/**
	 * Busca el tramite de registro de inspeccion de una actuacion.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findTramiteRegistroInspeccionPorActuacionCount(Actuacion actuacion) {
		String query = "SELECT COUNT(1) FROM TRAMITE_INSPECCION t1, ACTUACION t2 WHERE t1.TIATCODIGO = t2.ATCODIGO AND t1.TICOTEE = ? AND t2.ATCODIGO = ?";

		List<Object> params = new ArrayList<Object>();
		params.add(Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_INSPECCION);
		params.add(actuacion.getAtcodigo());

		return this.jdbcTemplate.queryForLong(query, params.toArray());
	}

	/**
	 * Get a New PK (Esperas).
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewEsperaPK() {

		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer("SELECT L21VNQ00.NEXTVAL FROM  DUAL ");
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Completa acuse recibo.
	 * 
	 * @param tramiteinspeccionAcuse
	 *            the tramitehecho acuse
	 * @param situacionNotificacion
	 *            the situacion notificacion
	 * @param deliveredNotificationInfo
	 *            the delivered notification info
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             the exception
	 */
	public TramiteInspeccion completaAcuseRecibo(TramiteInspeccion tramiteinspeccionAcuse, String situacionNotificacion,
			DeliveredNotificationInfo deliveredNotificationInfo) throws Exception {

		tramiteinspeccionAcuse.setTifechafin(new Date());

		tramiteinspeccionAcuse.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		tramiteinspeccionAcuse.setTiacusereciborecibido(situacionNotificacion);
		if (Y41bUtils.isFilled(deliveredNotificationInfo.getDeliveryTimestamp())) {
			try {
				SimpleDateFormat formatterAcuseRecibo = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
				Date dateAcuseRecibo = formatterAcuseRecibo.parse(deliveredNotificationInfo.getDeliveryTimestamp());
				tramiteinspeccionAcuse.setTiacuserecibo(dateAcuseRecibo);
			} catch (Exception e) {
				// Si falla el parseo meto la fecha de hoy
				tramiteinspeccionAcuse.setTiacuserecibo(new Date());
			}
		} else {
			tramiteinspeccionAcuse.setTiacuserecibo(new Date());
		}
		this.update(tramiteinspeccionAcuse);
		return tramiteinspeccionAcuse;
	}

	/**
	 * Counts rows in the tramiteinspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTramiteRegistroInspeccionTramitadoCount(TramiteInspeccionDetalle tramiteInspeccionDetalle) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.TICOTEE= t2.TRCODIGO(+) AND t1.TICOMOASIGNADO= t3ASIGNADO.MOCODIGO(+) AND t1.TICOMOEJECUCION= t3EJECUCION.MOCODIGO(+) AND t1.TIATCODIGO= t4.ATCODIGO(+) AND t2.FCODIGO = t5.FCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM TRAMITE_INSPECCION t1 ,TRAMITE t2 ,CENSO_MONITOR t3ASIGNADO,CENSO_MONITOR t3EJECUCION ,ACTUACION t4, FASE t5 ");

		where.append(" AND t4.ATCODIGO = ?");
		params.add(tramiteInspeccionDetalle.getAtcodigo());

		where.append(" AND t1.TICOTEE = ?");
		params.add(Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_INSPECCION);

		where.append(" AND t1.TIFECHAFIN IS NOT NULL ");

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the tramiteinspeccion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTramiteAsignacionResponsableInspeccionTramitadoCount(Actuacion actuacion) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.TICOTEE= t2.TRCODIGO(+) AND t1.TICOMOASIGNADO= t3ASIGNADO.MOCODIGO(+) AND t1.TICOMOEJECUCION= t3EJECUCION.MOCODIGO(+) AND t1.TIATCODIGO= t4.ATCODIGO(+) AND t2.FCODIGO = t5.FCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM TRAMITE_INSPECCION t1 ,TRAMITE t2 ,CENSO_MONITOR t3ASIGNADO,CENSO_MONITOR t3EJECUCION ,ACTUACION t4, FASE t5 ");

		if (actuacion != null && actuacion.getAtcopg() != null) {
			where.append(" AND t4.ATCOPG = ?");
			params.add(actuacion.getAtcopg());
		}

		if (actuacion != null && actuacion.getAtcocr() != null) {
			where.append(" AND t4.ATCOCR = ?");
			params.add(actuacion.getAtcocr());
		}

		if (actuacion != null && actuacion.getAtidcomunicacionsoivre() != null) {
			where.append(" AND t4.ATIDCOMUNICACIONSOIVRE = ?");
			params.add(actuacion.getAtidcomunicacionsoivre());
		}

		if (actuacion != null && actuacion.getAtcodigo() != null) {
			where.append(" AND t1.TIATCODIGO = ?");
			params.add(actuacion.getAtcodigo());
		}

		where.append(" AND t1.TICOTEE = ?");
		params.add(Y41bConstantes.TRAMITE_INSPECCIONES_ASIGNACION_RESPONSABLE_EXPEDIENTE);

		where.append(" AND t1.TIFECHAFIN IS NOT NULL ");

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalleKnet
	 *            TramiteHechoDetalleKnet
	 * @return TramiteHechoDetalleKnet
	 */
	@Transactional(readOnly = true)
	public TramiteHechoDetalleKnet findTramiteHecho(TramiteHechoDetalleKnet tramiteHechoDetalleKnet) {
		String query = "SELECT  t1.TICODIGO TICODIGO,t1.TIFECHAFIN TIFECHAFIN, t1.TICOTEE TRCODIGO,t2.TRNOMBRE TRNOMBRE,t2.TRNOMBREE TRNOMBREE,t2.TRBAJA TRBAJA, t3.MOCODIGO MOCODIGO,t3.MONOMBRE MONOMBRE,t3.MOCOOR MOCOOR, t3.MOCOEM MOCOEM, t4.ATCODIGO ATCODIGO, t6.COD_ORG CODORG, t6.NOMBRE_ES NOMBREES, t6.NOMBRE_EU NOMBREEU "
				+ "FROM TRAMITE_INSPECCION t1 ,TRAMITE t2 ,CENSO_MONITOR t3 ,ACTUACION t4, ORGANISMO t6  "
				+ "WHERE 1=1 AND t1.TICOTEE= t2.TRCODIGO(+) AND t1.TICOMOEJECUCION= t3.MOCODIGO(+) AND t1.TIATCODIGO= t4.ATCODIGO(+) AND t1.TICOORTRASPASO= t6.COD_ORG(+) AND t1.TICODIGO = ? ";
		return (TramiteHechoDetalleKnet) this.jdbcTemplate.queryForObject(query,
				new RowMapper<TramiteHechoDetalleKnet>() {
					public TramiteHechoDetalleKnet mapRow(ResultSet resultSet, int rowNum) throws SQLException {

						return new TramiteHechoDetalleKnet(resultSet.getString("TICODIGO"),
								resultSet.getDate("TIFECHAFIN"), null, null, null, null, null, null, null, null, null,
								resultSet.getString("TRCODIGO"), resultSet.getString("TRNOMBRE"),
								resultSet.getString("TRNOMBREE"), resultSet.getDate("TRBAJA"),
								resultSet.getString("MOCODIGO"), resultSet.getString("MOCOOR"),
								resultSet.getString("MONOMBRE"), resultSet.getString("MOCOEM"),
								resultSet.getString("ATCODIGO"), null, null, null, null, null, null, null, null, null,
								resultSet.getString("CODORG"), resultSet.getString("NOMBREES"),
								resultSet.getString("NOMBREEU"), null, null);
					}
				}, tramiteHechoDetalleKnet.getEhcodigo());
	}

	/**
	 * Counts rows in the tramiteinspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTramiteAsociadoActaTramitadoCount(TramiteInspeccionDetalle tramiteInspeccionDetalle) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM TRAMITE_INSPECCION t1 ");

		where.append(" AND t1.TIATCODIGO = ?");
		params.add(tramiteInspeccionDetalle.getAtcodigo());

		where.append(" AND t1.TIACCODIGO = ?");
		params.add(tramiteInspeccionDetalle.getTiaccodigo());

		where.append(" AND t1.TICOTEE != ?");
		params.add(Y41bConstantes.TRAMITE_INSPECCIONES_LEVANTAMIENTO_ACTA);

		where.append(" AND t1.TIFECHAFIN IS NOT NULL ");

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the tramiteinspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTramiteCodMuestraCount(TramiteInspeccion tramiteInspeccion) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM TRAMITE_INSPECCION t1 ");

		where.append(" AND t1.TIATCODIGO = ?");
		params.add(tramiteInspeccion.getTiatcodigo());

		where.append(" AND t1.TICODMUESTRA = ?");
		params.add(tramiteInspeccion.getTicodmuestra());

		where.append(" AND t1.TIFECHAFIN IS NOT NULL ");

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generacion de codigo de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
