package com.ejie.y41b.dao;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.horizontalSystemOfNotification.xml.DeliveredNotificationInfoDocument.DeliveredNotificationInfo;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Acta;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.NotificacionAcuseRecibo;
import com.ejie.y41b.model.NotificacionesComunicacionesBusqueda;
import com.ejie.y41b.model.TramiteHecho;
import com.ejie.y41b.model.TramiteHechoDetalleKnet;
import com.ejie.y41b.model.TramiteInspeccion;
import com.ejie.y41b.model.TramiteInspeccionDetalle;

/**
 * TramiteInspeccionDao  
 * 
 *  
 */

public interface TramiteInspeccionDao {

	/**
	 * Counts rows in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @return Long
	 */
	public Long findAllTramiteRegistroDecisionTramitadoCount(TramiteInspeccionDetalle tramiteInspeccionDetalle);

	/**
	 * Inserts a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteinspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             excepcion
	 */
	TramiteInspeccion add(TramiteInspeccion tramiteinspeccion) throws Exception;

	/**
	 * Inserts a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteinspeccion
	 *            Pagination
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             excepcion
	 */
	public TramiteInspeccion addMasiva(TramiteInspeccion tramiteinspeccion) throws Exception;

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteinspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             excepcion
	 */
	TramiteInspeccion update(TramiteInspeccion tramiteinspeccion) throws Exception;

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	public TramiteInspeccion updateFechaInicio(TramiteInspeccion tramiteInspeccion);

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	public TramiteInspeccion updateFechaLimite(TramiteInspeccion tramiteInspeccion);

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	public TramiteInspeccion updateInstructor(TramiteInspeccion tramiteInspeccion);

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	public TramiteInspeccion updateReabrirTramite(TramiteInspeccion tramiteInspeccion);

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	public TramiteInspeccion updateCodigoActa(TramiteInspeccion tramiteInspeccion);

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	public TramiteInspeccion updateTramitarTramite(TramiteInspeccion tramiteInspeccion);

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteinspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	TramiteInspeccion find(TramiteInspeccion tramiteinspeccion);

	/**
	 * Deletes a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteinspeccion
	 *            TramiteInspeccion
	 * @return
	 */
	void remove(TramiteInspeccion tramiteinspeccion);

	/**
	 * Removes a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteinspeccion
	 *            Pagination
	 * @return
	 */
	public void removeAllTramitesExpediente(TramiteInspeccion tramiteinspeccion);

	/**
	 * Removes a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteinspeccion
	 *            TramiteInspeccion
	 * @return
	 */
	public void removeTramiteCierreSinTramitarExpediente(TramiteInspeccion tramiteinspeccion);

	/**
	 * Finds a List of rows in the TramiteInspeccion table.
	 * 
	 * @param tramiteinspeccion
	 *            TramiteInspeccion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<TramiteInspeccion> findAll(TramiteInspeccion tramiteinspeccion, Pagination pagination);

	/**
	 * Counts rows in the TramiteInspeccion table.
	 * 
	 * @param tramiteinspeccion
	 *            TramiteInspeccion
	 * @return Long
	 */
	Long findAllCount(TramiteInspeccion tramiteinspeccion);

	/**
	 * Finds rows in the TramiteInspeccion table using like.
	 * 
	 * @param tramiteinspeccion
	 *            TramiteInspeccion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<TramiteInspeccion> findAllLike(TramiteInspeccion tramiteinspeccion, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the TramiteInspeccion table using like.
	 * 
	 * @param tramiteinspeccion
	 *            TramiteInspeccion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(TramiteInspeccion tramiteinspeccion, Boolean startsWith);

	/**
	 * Finds a List of rows in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TramiteInspeccionDetalle> findAllTramiteInspeccionPendientes(
			TramiteInspeccionDetalle tramiteInspeccionDetalle, Pagination pagination);

	/**
	 * Finds a List of rows in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TramiteInspeccion> findAllTramiteInspeccionATramitarautomaticamente(TramiteInspeccion tramiteInspeccion,
			Pagination pagination);

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @return TramiteInspeccionDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteInspeccionDetalle findUltimoTramiteInspeccionYFase(TramiteInspeccionDetalle tramiteInspeccionDetalle);

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @return TramiteInspeccionDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteInspeccionDetalle findUltimoTramiteInspeccionYFaseNoGenerico(
			TramiteInspeccionDetalle tramiteInspeccionDetalle);

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @return TramiteInspeccionDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteInspeccionDetalle findUltimoTramiteInspeccionYFaseNoGenericoNoCierre(
			TramiteInspeccionDetalle tramiteInspeccionDetalle);

	/**
	 * Finds a List of rows in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	List<TramiteInspeccionDetalle> findAllTramiteInspeccion(TramiteInspeccionDetalle tramiteInspeccionDetalle,
			Pagination pagination);

	/**
	 * Count of rows in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @return List
	 */
	@Transactional(readOnly = true)
	public Long findAllTramiteInspeccionCount(TramiteInspeccionDetalle tramiteInspeccionDetalle);

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @return TramiteInspeccionDetalle
	 */
	@Transactional(readOnly = true)
	TramiteInspeccionDetalle findUltimaFase(TramiteInspeccionDetalle tramiteInspeccionDetalle);

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	TramiteInspeccion updateEstadoTramite(TramiteInspeccion tramiteInspeccion);

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	@Transactional(readOnly = true)
	TramiteInspeccion findLobTablaTemporal(TramiteInspeccion tramiteInspeccion);

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	public TramiteInspeccion updateIdNotificacionPlatea(TramiteInspeccion tramiteInspeccion);

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	public TramiteInspeccion updateRegistroSalidaPlatea(TramiteInspeccion tramiteInspeccion);

	/**
	 * Inserts a single row in the NotificacionAcuseRecibo table.
	 * 
	 * @param notificacionAcuseRecibo
	 *            NotificacionAcuseRecibo
	 * @return NotificacionAcuseRecibo
	 */
	public NotificacionAcuseRecibo addNotificacionAcuseRecibo(NotificacionAcuseRecibo notificacionAcuseRecibo);

	/**
	 * Finds a List of rows in the TramiteHecho table.
	 * 
	 * @param notificacionComunicacionDetalle
	 *            NotificacionesComunicacionesBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<NotificacionesComunicacionesBusqueda> findAllNotifiComuni(
			NotificacionesComunicacionesBusqueda notificacionComunicacionDetalle, Pagination pagination);

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param notificacionComunicacionDetalle
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	public Long findAllNotifiComuniCount(NotificacionesComunicacionesBusqueda notificacionComunicacionDetalle);

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho updateRemesa(TramiteHecho tramitehecho);

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param Ehcodigo
	 *            String
	 */
	public void removeRemesaFromTramitesByEhcodigo(String Ehcodigo);

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param notifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return List
	 */
	public List<NotificacionesComunicacionesBusqueda> findBlobTablaDocumentosHecho(
			NotificacionesComunicacionesBusqueda notifiComuni);

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param notifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	public Long findSumSizeBlobNotifiComuni(NotificacionesComunicacionesBusqueda notifiComuni);

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             excepcion
	 */
	public TramiteInspeccion updateDenegacionTramite(TramiteInspeccion tramiteInspeccion) throws Exception;

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	public TramiteInspeccion updateMatarEspera(TramiteInspeccion tramiteInspeccion);

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	public TramiteInspeccion updateAcuseReintentado(TramiteInspeccion tramiteInspeccion);

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	public TramiteInspeccion updateProceedingsIdPlatea(TramiteInspeccion tramiteInspeccion);

	/**
	 * Busca todos los tramites ejecutados en un acta sin contar con el
	 * Levantamiento de acta.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @param todos
	 *            boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTramitadosCount(TramiteInspeccion tramiteInspeccion, boolean todos);

	/**
	 * Elimina todos los tramites asociados a un acta.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 */
	@Transactional(readOnly = true)
	public void removeFromActa(TramiteInspeccion tramiteInspeccion);

	/**
	 * Finds a single row in the tramiteinspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @return TramiteInspeccionDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteInspeccionDetalle findUltimoTramiteHechoPorTipoTramite(
			TramiteInspeccionDetalle tramiteInspeccionDetalle);

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * 
	 * @return TramiteInspeccionDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteInspeccionDetalle findUltimoTramiteHechoPorTipoTramiteNoTramitado(
			TramiteInspeccionDetalle tramiteInspeccionDetalle);

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @param origen
	 *            String
	 * 
	 * @return TramiteInspeccionDetalle
	 */
	public TramiteInspeccionDetalle findUltimoTramiteHechoPorTipoTramiteYOrigenNoTramitado(
			TramiteInspeccionDetalle tramiteInspeccionDetalle, String origen);

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @param destino
	 *            String
	 * 
	 * @return TramiteInspeccionDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteInspeccionDetalle findUltimoTramiteHechoPorTipoTramiteYDestinoTramitado(
			TramiteInspeccionDetalle tramiteInspeccionDetalle, String destino);

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * 
	 * @return TramiteInspeccionDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteInspeccionDetalle findUltimoTramiteInspeccionPorTipoTramite(
			TramiteInspeccionDetalle tramiteInspeccionDetalle);

	/**
	 * Busca los tramites de Asignacion de responsable de expediente y de
	 * registro de inspeccion de un acta.
	 * 
	 * @param acta
	 *            Acta
	 * @return List<TramiteInspeccion>
	 */
	@Transactional(readOnly = true)
	public List<TramiteInspeccion> findTramitesAperturaPorActa(Acta acta);

	/**
	 * Busca los tramites de Asignacion de responsable de expediente y de
	 * registro de inspeccion de un acta.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return List<TramiteInspeccion>
	 */
	@Transactional(readOnly = true)
	public List<TramiteInspeccion> findTramitesAperturaPorActuacion(Actuacion actuacion);

	/**
	 * Busca el tramite de registro de inspeccion de un acta.
	 * 
	 * @param acta
	 *            Acta
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findTramiteRegistroInspeccionPorActaCount(Acta acta);

	/**
	 * Busca el tramite de registro de inspeccion de una actuacion.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findTramiteRegistroInspeccionPorActuacionCount(Actuacion actuacion);

	/**
	 * Get a New PK (Esperas).
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewEsperaPK();

	/**
	 * Completa acuse recibo.
	 * 
	 * @param tramiteinspeccionAcuse
	 *            the tramitehecho acuse
	 * @param situacionNotificacion
	 *            the situacion notificacion
	 * @param deliveredNotificationInfo
	 *            the delivered notification info
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             the exception
	 */
	public TramiteInspeccion completaAcuseRecibo(TramiteInspeccion tramiteinspeccionAcuse, String situacionNotificacion,
			DeliveredNotificationInfo deliveredNotificationInfo) throws Exception;

	/**
	 * Counts rows in the tramiteinspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @return Long
	 */
	public Long findAllTramiteRegistroInspeccionTramitadoCount(TramiteInspeccionDetalle tramiteInspeccionDetalle);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalleKnet
	 *            TramiteHechoDetalleKnet
	 * @return TramiteHechoDetalleKnet
	 */
	public TramiteHechoDetalleKnet findTramiteHecho(TramiteHechoDetalleKnet tramiteHechoDetalleKnet);

	/**
	 * Counts rows in the tramiteinspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @return Long
	 */
	public Long findAllTramiteAsociadoActaTramitadoCount(TramiteInspeccionDetalle tramiteInspeccionDetalle);

	/**
	 * Counts rows in the tramiteinspeccion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTramiteAsignacionResponsableInspeccionTramitadoCount(Actuacion actuacion);

	/**
	 * Counts rows in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTramiteEmisionInformeProtocoloTramitadoCount(TramiteInspeccionDetalle tramiteInspeccionDetalle);

	/**
	 * Finds a single row in the tramiteinspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * 
	 * @return TramiteInspeccionDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteInspeccionDetalle findTramiteRelacionado(TramiteInspeccionDetalle tramiteInspeccionDetalle);

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * 
	 * @return TramiteInspeccionDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteInspeccionDetalle findTramitePendienteMasAntiguoNoTramitado(
			TramiteInspeccionDetalle tramiteInspeccionDetalle);

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * 
	 * @return TramiteInspeccionDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteInspeccionDetalle findUltimoTramiteInspeccionTramitado(
			TramiteInspeccionDetalle tramiteInspeccionDetalle);

	/**
	 * Counts rows in the tramiteinspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTramiteCodMuestraCount(TramiteInspeccion tramiteInspeccion);

	/**
	 * Finds a List of rows in the TramiteInspeccion table.
	 * 
	 * @param tramiteinspeccion
	 *            TramiteInspeccion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TramiteInspeccion> findAllTramitesPendientesPorTipo(TramiteInspeccion tramiteinspeccion,
			Pagination pagination);

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * 
	 * @return TramiteInspeccionDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteInspeccionDetalle findTramitePendienteMasNuevoNoTramitado(
			TramiteInspeccionDetalle tramiteInspeccionDetalle);

	/**
	 * Counts rows in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTramiteResultadoEnsayosNoTramitadoCount(TramiteInspeccionDetalle tramiteInspeccionDetalle);
}
