package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.horizontalSystemOfNotification.xml.DeliveredNotificationInfoDocument.DeliveredNotificationInfo;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.NotificacionAcuseRecibo;
import com.ejie.y41b.model.NotificacionesComunicacionesBusqueda;
import com.ejie.y41b.model.PlantillaTramiteHechoDetalle;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteHecho;
import com.ejie.y41b.model.TramiteHechoDetalle;
import com.ejie.y41b.model.TramiteHechoDetalleKnet;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * TramiteHechoDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class TramiteHechoDaoImpl implements TramiteHechoDao {

	private static final String SELECT_TRAMITE_HECHO = "SELECT t1.EHCODIGO EHCODIGO, t1.EHCOTEE EHCOTEE, t1.EHFECHA EHFECHA, t1.EHHORA EHHORA, t1.EHCODPOR EHCODPOR, t1.EHCODPDE EHCODPDE, t1.EHCOHD EHCOHD, t1.EHCOZS EHCOZS, t1.EHCOMO EHCOMO, t1.EHCIVIHE EHCIVIHE, t1.EHCOEH EHCOEH, t1.EHACUSE EHACUSE, t1.EHENVIOMAIL EHENVIOMAIL, t1.EHDIREMAIL EHDIREMAIL, t1.EHCOORTRASPASO EHCOORTRASPASO, t1.EHCOACTUA EHCOACTUA, t1.EHFECHAINICIO EHFECHAINICIO, t1.EHFECHAFIN EHFECHAFIN, t1.EHCOMOEJECUCION EHCOMOEJECUCION, t1.EHCOSC EHCOSC, t1.EHRESPUESTA EHRESPUESTA, t1.EHFECHAMEDIACION EHFECHAMEDIACION, t1.EHHORAMEDIACION EHHORAMEDIACION, t1.EHFECHAENVIOCONVOCATORIA EHFECHAENVIOCONVOCATORIA, t1.EHFECHAREALIZACION EHFECHAREALIZACION, t1.EHHORAREALIZACION EHHORAREALIZACION, t1.EHFECHACONCILIACION EHFECHACONCILIACION, t1.EHFECHAFIRMAACUERDO EHFECHAFIRMAACUERDO, t1.EHPLAZOINSPECCION EHPLAZOINSPECCION, t1.INCODIGO INCODIGO, t1.EHRESPUESTATRASPASO EHRESPUESTATRASPASO, t1.EHDECODIGO EHDECODIGO, t1.EHFECHARESOLUCION EHFECHARESOLUCION, t1.EHFECHARECURSO EHFECHARECURSO, t1.EHTIPORECURSO EHTIPORECURSO, t1.EHABOGADO EHABOGADO, t1.EHESTIMACION EHESTIMACION, t1.EHFECHACIERRE EHFECHACIERRE, t1.EHDESTINATARIO EHDESTINATARIO, t1.EHFECHACOMUNICACION EHFECHACOMUNICACION, t1.EHTIPOCOMUNICACION EHTIPOCOMUNICACION, t1.EHTIPONOTIFICACION EHTIPONOTIFICACION, t1.EHNUMREGISTROSALIDA EHNUMREGISTROSALIDA, t1.EHACUSERECIBO EHACUSERECIBO, t1.EHACUSERECIBORECIBIDO EHACUSERECIBORECIBIDO, t1.EHNUMREGISTROENTRADA EHNUMREGISTROENTRADA, t1.EHIDNOTIFICACIONPLATEA EHIDNOTIFICACIONPLATEA, t1.EHNOMBRETRAMITE EHNOMBRETRAMITE, t1.EHNRTEL1 EHNRTEL1, t1.EHNRTEL2 EHNRTEL2, t1.EHNRTEL3 EHNRTEL3, t1.EHIDDESTINATARIO EHIDDESTINATARIO, t1.EHCOMOASIGNADO EHCOMOASIGNADO, t1.EHFECHAREGISTROSALIDA EHFECHAREGISTROSALIDA, t1.EHFECHAREGISTROENTRADA EHFECHAREGISTROENTRADA, t1.EHESTADOTRAMITE EHESTADOTRAMITE, t1.EHCOMODESIGNADO EHCOMODESIGNADO, t1.EHREQUIEREFIRMA EHREQUIEREFIRMA, t1.EHTIPONOTIFICACIONPLATEA EHTIPONOTIFICACIONPLATEA, t1.EHIDESPERAPLATEA EHIDESPERAPLATEA, t1.EHMATARESPERA EHMATARESPERA, t1.EHFECHAPUBLICACIONBOPV EHFECHAPUBLICACIONBOPV, t1.EHFECHAPUBLICACIONAYTO EHFECHAPUBLICACIONAYTO, t1.EHTIPOMEDIACION EHTIPOMEDIACION, t1.EHORIGENALEGACION EHORIGENALEGACION, t1.EHASUNTOCOMUNICACION EHASUNTOCOMUNICACION, t1.EHSEDE EHSEDE, t1.EHHORAMEDIACIONINICIO EHHORAMEDIACIONINICIO, t1.EHHORAMEDIACIONFIN EHHORAMEDIACIONFIN, t1.EHCODREM EHCODREM, t1.EHENVREM EHENVREM, t1.EHIDMAILORIGEN EHIDMAILORIGEN,t1.EHMAILORIGEN EHMAILORIGEN,t1.EHIDMAILDESTINO EHIDMAILDESTINO,t1.EHMAILDESTINO EHMAILDESTINO, t1.EHFECHAENVIOBOPVBOE EHFECHAENVIOBOPVBOE, t1.EHPROCEEDINGSIDPLATEA EHPROCEEDINGSIDPLATEA, t1.EHFCODIGO EHFCODIGO, t1.EHSIGUIENTESTRAMITES EHSIGUIENTESTRAMITES, t1.EHTEXTOACUERDO EHTEXTOACUERDO, t1.EHINSTRUCINSPECC EHINSTRUCINSPECC, t1.EHMOTIVORECHAZO EHMOTIVORECHAZO, t1.EHMOTIVORECURSO EHMOTIVORECURSO, t1.EHRESUMENALEGACION EHRESUMENALEGACION, t1.EHRESUMENMEDIACION EHRESUMENMEDIACION, t1.EHTEXTOCOMUNICACION EHTEXTOCOMUNICACION, t1.EHINTERVINIENTES EHINTERVINIENTES, t1.EHJUSTIFICACIONINFRACCION EHJUSTIFICACIONINFRACCION, t1.EHDOCUMENTACIONREQUERIDA EHDOCUMENTACIONREQUERIDA, t1.EHDOCUMENTACIONREQUERIDAE EHDOCUMENTACIONREQUERIDAE, t1.EHRESUMENCOLABSOL EHRESUMENCOLABSOL, t1.EHRESUMENCOLABRESP EHRESUMENCOLABRESP, t1.EHACUSEREINTENTADO EHACUSEREINTENTADO, t2.EHCODIGO TRAMHECHOEHCODIGO, t2.EHCOTEE TRAMHECHOEHCOTEE, t2.EHFECHA TRAMHECHOEHFECHA, t2.EHHORA TRAMHECHOEHHORA, t2.EHCODPOR TRAMHECHOEHCODPOR, t2.EHCODPDE TRAMHECHOEHCODPDE, t2.EHCOHD TRAMHECHOEHCOHD, t2.EHCOZS TRAMHECHOEHCOZS, t2.EHCOMO TRAMHECHOEHCOMO, t2.EHCIVIHE TRAMHECHOEHCIVIHE, t2.EHCOEH TRAMHECHOEHCOEH, t2.EHACUSE TRAMHECHOEHACUSE, t2.EHENVIOMAIL TRAMHECHOEHENVIOMAIL, t2.EHDIREMAIL TRAMHECHOEHDIREMAIL, t2.EHCOORTRASPASO TRAMHECHOEHCOORTRASPASO, t2.EHCOACTUA TRAMHECHOEHCOACTUA, t2.EHFECHAINICIO TRAMHECHOEHFECHAINICIO, t2.EHFECHAFIN TRAMHECHOEHFECHAFIN, t2.EHCOMOEJECUCION TRAMHECHOEHCOMOEJECUCION, t2.EHCOSC TRAMHECHOEHCOSC, t2.EHRESPUESTA TRAMHECHOEHRESPUESTA, t2.EHFECHAMEDIACION TRAMHECHOEHFECHAMEDIACION, t2.EHHORAMEDIACION TRAMHECHOEHHORAMEDIACION, t2.EHFECHAENVIOCONVOCATORIA TRAMHECHOEHFECHAENVIOCONVO, t2.EHFECHAREALIZACION TRAMHECHOEHFECHAREALIZACION, t2.EHHORAREALIZACION TRAMHECHOEHHORAREALIZACION, t2.EHFECHACONCILIACION TRAMHECHOEHFECHACONCILIACION, t2.EHFECHAFIRMAACUERDO TRAMHECHOEHFECHAFIRMAACUERDO, t2.EHPLAZOINSPECCION TRAMHECHOEHPLAZOINSPECCION, t2.INCODIGO TRAMITEHECHOINCODIGO, t2.EHRESPUESTATRASPASO TRAMHECHOEHRESPUESTATRASPASO, t2.EHDECODIGO TRAMHECHOEHDECODIGO, t2.EHFECHARESOLUCION TRAMHECHOEHFECHARESOLUCION, t2.EHFECHARECURSO TRAMHECHOEHFECHARECURSO, t2.EHTIPORECURSO TRAMHECHOEHTIPORECURSO, t2.EHABOGADO TRAMHECHOEHABOGADO, t2.EHESTIMACION TRAMHECHOEHESTIMACION, t2.EHFECHACIERRE TRAMHECHOEHFECHACIERRE, t2.EHDESTINATARIO TRAMHECHOEHDESTINATARIO, t2.EHFECHACOMUNICACION TRAMHECHOEHFECHACOMUNICACION, t2.EHTIPOCOMUNICACION TRAMHECHOEHTIPOCOMUNICACION, t2.EHTIPONOTIFICACION TRAMHECHOEHTIPONOTIFICACION, t2.EHNUMREGISTROSALIDA TRAMHECHOEHNUMREGISTROSALIDA, t2.EHACUSERECIBO TRAMHECHOEHACUSERECIBO, t2.EHACUSERECIBORECIBIDO TRAMHECHOEHACUSERECIBORECIBIDO, t2.EHNUMREGISTROENTRADA TRAMHECHOEHNUMREGISTROENTRADA, t2.EHIDNOTIFICACIONPLATEA TRAMHECHOEHIDNOTIFPLATEA, t2.EHNOMBRETRAMITE TRAMHECHOEHNOMBRETRAMITE, t2.EHNRTEL1 TRAMHECHOEHNRTEL1, t2.EHNRTEL2 TRAMHECHOEHNRTEL2, t2.EHNRTEL3 TRAMHECHOEHNRTEL3, t2.EHIDDESTINATARIO TRAMHECHOEHIDDESTINATARIO, t2.EHCOMOASIGNADO TRAMHECHOEHCOMOASIGNADO, t2.EHFECHAREGISTROSALIDA TRAMHECHOEHFECHAREGISTROSALIDA, t2.EHFECHAREGISTROENTRADA TRAMHECHOEHHFECHAREGENTRADA, t2.EHESTADOTRAMITE TRAMHECHOEHESTADOTRAMITE, t2.EHCODIGORELACIONADO TRAMHECHOEHCODIGORELACIONADO, t2.EHCOMODESIGNADO TRAMHECHOEHCOMODESIGNADO,t2.EHREQUIEREFIRMA TRAMHECHOEHREQUIEREFIRMA, t2.EHTIPONOTIFICACIONPLATEA TRAMHECHOEHTIPONOTIFICACIONPL, t2.EHIDESPERAPLATEA TRAMHECHOEHIDESPERAPLATEA, t2.EHMATARESPERA TRAMHECHOEHMATARESPERA, t2.EHFECHAPUBLICACIONBOPV TRAMHECHOEHFECHAPUBLBOPV, t2.EHFECHAPUBLICACIONAYTO TRAMHECHOEHFECHAPUBLAYTO, t2.EHTIPOMEDIACION TRAMHECHOEHTIPOMEDIACION, t2.EHORIGENALEGACION TRAMHECHOEHORIGENALEGACION, t2.EHASUNTOCOMUNICACION TRAMHECHOEHASUNTOCOMUNICACION, t2.EHSEDE TRAMHECHOEHSEDE, t2.EHHORAMEDIACIONINICIO TRAMHECHOEHHORAMEDIACIONINICIO, t2.EHHORAMEDIACIONFIN TRAMHECHOEHHORAMEDIACIONFIN, t2.EHCODREM TRAMHECHOEHCODREM, t2.EHENVREM TRAMHECHOEHENVREM, t2.EHIDMAILORIGEN TRAMHECHOEHIDMAILORIGEN,t2.EHMAILORIGEN TRAMHECHOEHMAILORIGEN,t2.EHIDMAILDESTINO TRAMHECHOEHIDMAILDESTINO,t2.EHMAILDESTINO TRAMHECHOEHMAILDESTINO, t2.EHFECHAENVIOBOPVBOE TRAMHECHOEHFECHAENVIOBOPVBOE, t1.EHFECCOLABSOL EHFECCOLABSOL, t1.EHCODMOTIVOCOLABSOL EHCODMOTIVOCOLABSOL, t1.EHIDORGANISMOCOLABSOL EHIDORGANISMOCOLABSOL, t1.EHFECCOLABRESP EHFECCOLABRESP, t1.EHRESPUESTACOLABRESP EHRESPUESTACOLABRESP, t1.EHAUTOMATICO EHAUTOMATICO, t1.EHRESUMENINS EHRESUMENINS, t1.EHACEPTACIONINS EHACEPTACIONINS, t1.EHMOTIVOINS EHMOTIVOINS, t1.EHCODINS EHCODINS, t1.EHISTELEMATICO EHISTELEMATICO, t1.EHISSIR EHISSIR,t1.EHISSIRCONNUMREGENTORI EHISSIRCONNUMREGENTORI,t1.EHISWEBSINCERTIFICADO EHISWEBSINCERTIFICADO, t1.EHCOORINSPECCION EHCOORINSPECCION, t1.EHEXCLUIRCIERRE EHEXCLUIRCIERRE, t1.EHFECHASOLAMPLIACIONPLAZO EHFECHASOLAMPLIACIONPLAZO, t1.EHACEPTACIONPLAZO EHACEPTACIONPLAZO, t1.EHPLAZOCONCEDIDO EHPLAZOCONCEDIDO, t1.EHIDUNIDADDIR3 EHIDUNIDADDIR3, t1.EHAPERCIBIMIENTOES EHAPERCIBIMIENTOES, t1.EHAPERCIBIMIENTOEU EHAPERCIBIMIENTOEU ";

	private JdbcTemplate jdbcTemplate;

	private static final Logger logger = LoggerFactory.getLogger(TramiteHechoDaoImpl.class);

	private RowMapper<TramiteHecho> rwMap = new RowMapper<TramiteHecho>() {
		public TramiteHecho mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new TramiteHecho(resultSet.getString("EHCODIGO"), resultSet.getString("EHCOTEE"),
					resultSet.getDate("EHFECHA"), resultSet.getString("EHHORA"), resultSet.getString("EHCODPOR"),
					resultSet.getString("EHCODPDE"), null, resultSet.getString("EHCOHD"), resultSet.getString("EHCOZS"),
					resultSet.getString("EHCOMO"), resultSet.getBigDecimal("EHCIVIHE"), resultSet.getString("EHCOEH"),
					resultSet.getDate("EHACUSE"), resultSet.getString("EHENVIOMAIL"), resultSet.getString("EHDIREMAIL"),
					resultSet.getString("EHCOORTRASPASO"), resultSet.getString("EHCOACTUA"),
					resultSet.getTimestamp("EHFECHAINICIO"), resultSet.getTimestamp("EHFECHAFIN"),
					resultSet.getString("EHCOMOEJECUCION"), resultSet.getString("EHCOSC"),
					resultSet.getString("EHRESPUESTA"), resultSet.getDate("EHFECHAMEDIACION"),
					resultSet.getString("EHHORAMEDIACION"), resultSet.getDate("EHFECHAENVIOCONVOCATORIA"),
					resultSet.getDate("EHFECHAREALIZACION"), resultSet.getString("EHHORAREALIZACION"),
					resultSet.getDate("EHFECHACONCILIACION"), resultSet.getDate("EHFECHAFIRMAACUERDO"),
					resultSet.getDate("EHPLAZOINSPECCION"), resultSet.getString("INCODIGO"),
					resultSet.getString("EHRESPUESTATRASPASO"), resultSet.getString("EHDECODIGO"),
					resultSet.getDate("EHFECHARESOLUCION"), resultSet.getDate("EHFECHARECURSO"),
					resultSet.getString("EHTIPORECURSO"), resultSet.getString("EHABOGADO"),
					resultSet.getString("EHESTIMACION"), resultSet.getDate("EHFECHACIERRE"),
					resultSet.getString("EHDESTINATARIO"), resultSet.getDate("EHFECHACOMUNICACION"),
					resultSet.getString("EHTIPOCOMUNICACION"), resultSet.getString("EHTIPONOTIFICACION"),
					resultSet.getString("EHNUMREGISTROSALIDA"), resultSet.getDate("EHACUSERECIBO"),
					resultSet.getString("EHACUSERECIBORECIBIDO"), resultSet.getString("EHNUMREGISTROENTRADA"),
					resultSet.getString("EHIDNOTIFICACIONPLATEA"), resultSet.getString("EHNOMBRETRAMITE"),
					resultSet.getString("EHNRTEL1"), resultSet.getString("EHNRTEL2"), resultSet.getString("EHNRTEL3"),
					resultSet.getString("EHIDDESTINATARIO"), resultSet.getString("EHCOMOASIGNADO"),
					resultSet.getDate("EHFECHAREGISTROSALIDA"), resultSet.getDate("EHFECHAREGISTROENTRADA"),
					resultSet.getString("EHESTADOTRAMITE"), resultSet.getClob("EHSIGUIENTESTRAMITES"),
					resultSet.getClob("EHTEXTOACUERDO"), resultSet.getClob("EHINSTRUCINSPECC"),
					resultSet.getClob("EHMOTIVORECHAZO"), resultSet.getClob("EHMOTIVORECURSO"),
					resultSet.getString("EHCOMODESIGNADO"), resultSet.getString("EHREQUIEREFIRMA"),
					resultSet.getClob("EHRESUMENALEGACION"), resultSet.getClob("EHRESUMENMEDIACION"),
					resultSet.getClob("EHTEXTOCOMUNICACION"), resultSet.getString("EHTIPONOTIFICACIONPLATEA"),
					resultSet.getString("EHIDESPERAPLATEA"), resultSet.getString("EHMATARESPERA"),
					resultSet.getDate("EHFECHAPUBLICACIONBOPV"), resultSet.getDate("EHFECHAPUBLICACIONAYTO"),
					resultSet.getDate("EHFECHAENVIOBOPVBOE"), resultSet.getClob("EHINTERVINIENTES"),
					resultSet.getString("EHTIPOMEDIACION"), resultSet.getString("EHORIGENALEGACION"),
					resultSet.getString("EHASUNTOCOMUNICACION"), resultSet.getString("EHSEDE"),
					resultSet.getString("EHHORAMEDIACIONINICIO"), resultSet.getString("EHHORAMEDIACIONFIN"),
					resultSet.getClob("EHJUSTIFICACIONINFRACCION"), resultSet.getString("EHCODREM"),
					resultSet.getString("EHENVREM"),

					resultSet.getString("EHIDMAILORIGEN"), resultSet.getString("EHMAILORIGEN"),
					resultSet.getString("EHIDMAILDESTINO"), resultSet.getString("EHMAILDESTINO"),

					resultSet.getDate("EHFECCOLABSOL"), resultSet.getString("EHCODMOTIVOCOLABSOL"),
					resultSet.getString("EHIDORGANISMOCOLABSOL"), resultSet.getClob("EHRESUMENCOLABSOL"),

					resultSet.getDate("EHFECCOLABRESP"), resultSet.getString("EHRESPUESTACOLABRESP"),
					resultSet.getClob("EHRESUMENCOLABRESP"), resultSet.getString("EHPROCEEDINGSIDPLATEA"),
					resultSet.getString("EHFCODIGO"), resultSet.getClob("EHDOCUMENTACIONREQUERIDA"),
					resultSet.getClob("EHDOCUMENTACIONREQUERIDAE"), resultSet.getString("EHACUSEREINTENTADO"),
					resultSet.getString("EHAUTOMATICO"), resultSet.getString("EHRESUMENINS"),
					resultSet.getString("EHACEPTACIONINS"), resultSet.getString("EHMOTIVOINS"),
					resultSet.getString("EHCODINS"), resultSet.getString("EHISTELEMATICO"),
					resultSet.getString("EHISSIR"), resultSet.getString("EHISSIRCONNUMREGENTORI"),
					resultSet.getString("EHISWEBSINCERTIFICADO"), resultSet.getString("EHCOORINSPECCION"),
					resultSet.getString("EHEXCLUIRCIERRE"), resultSet.getDate("EHFECHASOLAMPLIACIONPLAZO"),
					resultSet.getString("EHACEPTACIONPLAZO"), resultSet.getString("EHPLAZOCONCEDIDO"),
					resultSet.getString("EHIDUNIDADDIR3"), resultSet.getClob("EHAPERCIBIMIENTOES"),
					resultSet.getClob("EHAPERCIBIMIENTOEU"),
					new TramiteHecho(resultSet.getString("TRAMHECHOEHCODIGO"), resultSet.getString("TRAMHECHOEHCOTEE"),
							resultSet.getDate("TRAMHECHOEHFECHA"), resultSet.getString("TRAMHECHOEHHORA"),
							resultSet.getString("TRAMHECHOEHCODPOR"), resultSet.getString("TRAMHECHOEHCODPDE"), null,
							resultSet.getString("TRAMHECHOEHCOHD"), resultSet.getString("TRAMHECHOEHCOZS"),
							resultSet.getString("TRAMHECHOEHCOMO"), resultSet.getBigDecimal("TRAMHECHOEHCIVIHE"),
							resultSet.getString("TRAMHECHOEHCOEH"), resultSet.getDate("TRAMHECHOEHACUSE"),
							resultSet.getString("TRAMHECHOEHENVIOMAIL"), resultSet.getString("TRAMHECHOEHDIREMAIL"),
							resultSet.getString("TRAMHECHOEHCOORTRASPASO"), resultSet.getString("TRAMHECHOEHCOACTUA"),
							resultSet.getDate("TRAMHECHOEHFECHAINICIO"), resultSet.getDate("TRAMHECHOEHFECHAFIN"),
							resultSet.getString("TRAMHECHOEHCOMOEJECUCION"), resultSet.getString("TRAMHECHOEHCOSC"),
							resultSet.getString("TRAMHECHOEHRESPUESTA"), resultSet.getDate("TRAMHECHOEHFECHAMEDIACION"),
							resultSet.getString("TRAMHECHOEHHORAMEDIACION"),
							resultSet.getDate("TRAMHECHOEHFECHAENVIOCONVO"),
							resultSet.getDate("TRAMHECHOEHFECHAREALIZACION"),
							resultSet.getString("TRAMHECHOEHHORAREALIZACION"),
							resultSet.getDate("TRAMHECHOEHFECHACONCILIACION"),
							resultSet.getDate("TRAMHECHOEHFECHAFIRMAACUERDO"),
							resultSet.getDate("TRAMHECHOEHPLAZOINSPECCION"),
							resultSet.getString("TramiteHechoINCODIGO"),
							resultSet.getString("TRAMHECHOEHRESPUESTATRASPASO"),
							resultSet.getString("TRAMHECHOEHDECODIGO"), resultSet.getDate("TRAMHECHOEHFECHARESOLUCION"),
							resultSet.getDate("TRAMHECHOEHFECHARECURSO"), resultSet.getString("TRAMHECHOEHTIPORECURSO"),
							resultSet.getString("TRAMHECHOEHABOGADO"), resultSet.getString("TRAMHECHOEHESTIMACION"),
							resultSet.getDate("TRAMHECHOEHFECHACIERRE"), resultSet.getString("TRAMHECHOEHDESTINATARIO"),
							resultSet.getDate("TRAMHECHOEHFECHACOMUNICACION"),
							resultSet.getString("TRAMHECHOEHTIPOCOMUNICACION"),
							resultSet.getString("TRAMHECHOEHTIPONOTIFICACION"),
							resultSet.getString("TRAMHECHOEHNUMREGISTROSALIDA"),
							resultSet.getDate("TRAMHECHOEHACUSERECIBO"),
							resultSet.getString("TRAMHECHOEHACUSERECIBORECIBIDO"),
							resultSet.getString("TRAMHECHOEHNUMREGISTROENTRADA"),
							resultSet.getString("TRAMHECHOEHIDNOTIFPLATEA"),
							resultSet.getString("TRAMHECHOEHNOMBRETRAMITE"), resultSet.getString("TRAMHECHOEHNRTEL1"),
							resultSet.getString("TRAMHECHOEHNRTEL2"), resultSet.getString("TRAMHECHOEHNRTEL3"),
							resultSet.getString("TRAMHECHOEHIDDESTINATARIO"),
							resultSet.getString("TRAMHECHOEHCOMOASIGNADO"),
							resultSet.getDate("TRAMHECHOEHFECHAREGISTROSALIDA"),
							resultSet.getDate("TRAMHECHOEHHFECHAREGENTRADA"),
							resultSet.getString("TRAMHECHOEHESTADOTRAMITE"), null, null, null, null, null,
							resultSet.getString("TRAMHECHOEHCOMODESIGNADO"),
							resultSet.getString("TRAMHECHOEHREQUIEREFIRMA"), null, null, null,
							resultSet.getString("TRAMHECHOEHTIPONOTIFICACIONPL"),
							resultSet.getString("TRAMHECHOEHIDESPERAPLATEA"),
							resultSet.getString("TRAMHECHOEHMATARESPERA"),
							resultSet.getDate("TRAMHECHOEHFECHAPUBLBOPV"),
							resultSet.getDate("TRAMHECHOEHFECHAPUBLAYTO"),
							resultSet.getDate("TRAMHECHOEHFECHAENVIOBOPVBOE"), null,
							resultSet.getString("TRAMHECHOEHTIPOMEDIACION"),
							resultSet.getString("TRAMHECHOEHORIGENALEGACION"),
							resultSet.getString("TRAMHECHOEHASUNTOCOMUNICACION"),
							resultSet.getString("TRAMHECHOEHSEDE"),
							resultSet.getString("TRAMHECHOEHHORAMEDIACIONINICIO"),
							resultSet.getString("TRAMHECHOEHHORAMEDIACIONFIN"), null,
							resultSet.getString("TRAMHECHOEHCODREM"), resultSet.getString("TRAMHECHOEHENVREM"),

							resultSet.getString("TRAMHECHOEHIDMAILORIGEN"),
							resultSet.getString("TRAMHECHOEHMAILORIGEN"),
							resultSet.getString("TRAMHECHOEHIDMAILDESTINO"),
							resultSet.getString("TRAMHECHOEHMAILDESTINO"),

							resultSet.getDate("EHFECCOLABSOL"), resultSet.getString("EHCODMOTIVOCOLABSOL"),
							resultSet.getString("EHIDORGANISMOCOLABSOL"), null,

							resultSet.getDate("EHFECCOLABRESP"), resultSet.getString("EHRESPUESTACOLABRESP"), null,
							null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null,
							new TramiteHecho(resultSet.getString("TRAMHECHOEHASUNTOCOMUNICACION"), null, null, null,
									null, null, null, null, null, null, null, null, null, null, null, null, null, null,
									null, null, null, null, null, null, null, null, null, null, null, null, null, null,
									null, null, null, null, null, null, null, null, null, null, null, null, null, null,
									null, null, null, null, null, null, null, null, null, null, null, null, null, null,
									null, null, null, null, null, null, null, null, null, null, null, null, null, null,
									null, null, null, null, null, null, null, null, null, null, null, null, null, null,
									null, null, null, null, null, null, null, null, null, null, null, null, null, null,
									null, null, null, null, null, null, null, null, null, null, null, null, null, null,
									new TramiteHecho())));
		}
	};

	private RowMapper<NotificacionAcuseRecibo> rwMapNotificacionAcuseRecibo = new RowMapper<NotificacionAcuseRecibo>() {
		public NotificacionAcuseRecibo mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new NotificacionAcuseRecibo(resultSet.getString("EHIDNOTIFICACIONPLATEA"),
					resultSet.getString("EHCODIGOACUSE"), resultSet.getString("EHPCODIGO"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho add(TramiteHecho tramitehecho) {
		// String query =
		String query = "INSERT INTO TRAMITE_HECHO (EHCODIGO, EHCODIGORELACIONADO, EHCOTEE, EHFECHA, EHHORA, EHCODPOR, EHCODPDE, EHTEXTO, EHCOHD, EHCOZS, EHCOMO, EHCIVIHE, EHCOEH, EHACUSE, EHENVIOMAIL, EHDIREMAIL, EHCOORTRASPASO, EHCOACTUA, EHFECHAINICIO, EHFECHAFIN, EHCOMOEJECUCION, EHCOSC, EHRESPUESTA, EHFECHAMEDIACION, EHHORAMEDIACION, EHFECHAENVIOCONVOCATORIA, EHFECHAREALIZACION, EHHORAREALIZACION, EHFECHACONCILIACION, EHFECHAFIRMAACUERDO, EHPLAZOINSPECCION, INCODIGO, EHRESPUESTATRASPASO, EHDECODIGO, EHFECHARESOLUCION, EHFECHARECURSO, EHTIPORECURSO, EHABOGADO, EHESTIMACION, EHFECHACIERRE, EHDESTINATARIO, EHFECHACOMUNICACION, EHTIPOCOMUNICACION, EHTIPONOTIFICACION, EHNUMREGISTROSALIDA, EHACUSERECIBO, EHACUSERECIBORECIBIDO, EHNUMREGISTROENTRADA, EHIDNOTIFICACIONPLATEA, EHNOMBRETRAMITE, EHNRTEL1, EHNRTEL2, EHNRTEL3, EHIDDESTINATARIO, EHCOMOASIGNADO, EHFECHAREGISTROSALIDA, EHFECHAREGISTROENTRADA, EHESTADOTRAMITE, EHSIGUIENTESTRAMITES, EHTEXTOACUERDO, EHINSTRUCINSPECC, EHMOTIVORECHAZO, EHMOTIVORECURSO, EHCOMODESIGNADO,EHREQUIEREFIRMA,EHRESUMENALEGACION,EHRESUMENMEDIACION,EHTEXTOCOMUNICACION,EHTIPONOTIFICACIONPLATEA,EHIDESPERAPLATEA,EHMATARESPERA,EHFECHAPUBLICACIONBOPV,EHFECHAPUBLICACIONAYTO,EHINTERVINIENTES,EHTIPOMEDIACION,EHORIGENALEGACION,EHASUNTOCOMUNICACION,EHSEDE,EHFECHALIMITE,EHHORAMEDIACIONINICIO,EHHORAMEDIACIONFIN,EHJUSTIFICACIONINFRACCION,EHCODREM,EHENVREM,EHFCODIGO, EHIDMAILORIGEN,EHMAILORIGEN,EHIDMAILDESTINO,EHMAILDESTINO, EHFECHAENVIOBOPVBOE, EHDOCUMENTACIONREQUERIDA, EHDOCUMENTACIONREQUERIDAE, EHFECCOLABSOL, EHCODMOTIVOCOLABSOL, EHIDORGANISMOCOLABSOL, EHRESUMENCOLABSOL, EHFECCOLABRESP, EHRESPUESTACOLABRESP, EHRESUMENCOLABRESP, EHAUTOMATICO, EHRESUMENINS, EHACEPTACIONINS, EHMOTIVOINS, EHCODINS, EHISTELEMATICO, EHISSIR,EHISSIRCONNUMREGENTORI,EHCOORINSPECCION, EHEXCLUIRCIERRE, EHFECHASOLAMPLIACIONPLAZO, EHACEPTACIONPLAZO, EHPLAZOCONCEDIDO, EHIDUNIDADDIR3, EHAPERCIBIMIENTOES, EHAPERCIBIMIENTOEU) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		Object getTramiteHechoEhcodigoAux = null;
		if (tramitehecho.getTramiteHecho() != null && tramitehecho.getTramiteHecho().getEhcodigo() != null) {
			getTramiteHechoEhcodigoAux = tramitehecho.getTramiteHecho().getEhcodigo();
		}
		this.jdbcTemplate.update(query, tramitehecho.getEhcodigo(), getTramiteHechoEhcodigoAux,
				tramitehecho.getEhcotee(), tramitehecho.getEhfecha(), tramitehecho.getEhhora(),
				tramitehecho.getEhcodpor(), tramitehecho.getEhcodpde(), tramitehecho.getEhtexto(),
				tramitehecho.getEhcohd(), tramitehecho.getEhcozs(), tramitehecho.getEhcomo(),
				tramitehecho.getEhcivihe(), tramitehecho.getEhcoeh(), tramitehecho.getEhacuse(),
				tramitehecho.getEhenviomail(), tramitehecho.getEhdiremail(), tramitehecho.getEhcoortraspaso(),
				tramitehecho.getEhcoactua(), tramitehecho.getEhfechainicio(), tramitehecho.getEhfechafin(),
				tramitehecho.getEhcomoejecucion(), tramitehecho.getEhcosc(), tramitehecho.getEhrespuesta(),
				tramitehecho.getEhfechamediacion(), tramitehecho.getEhhoramediacion(),
				tramitehecho.getEhfechaenvioconvocatoria(), tramitehecho.getEhfecharealizacion(),
				tramitehecho.getEhhorarealizacion(), tramitehecho.getEhfechaconciliacion(),
				tramitehecho.getEhfechafirmaacuerdo(), tramitehecho.getEhplazoinspeccion(), tramitehecho.getIncodigo(),
				tramitehecho.getEhrespuestatraspaso(), tramitehecho.getEhdecodigo(),
				tramitehecho.getEhfecharesolucion(), tramitehecho.getEhfecharecurso(), tramitehecho.getEhtiporecurso(),
				tramitehecho.getEhabogado(), tramitehecho.getEhestimacion(), tramitehecho.getEhfechacierre(),
				tramitehecho.getEhdestinatario(), tramitehecho.getEhfechacomunicacion(),
				tramitehecho.getEhtipocomunicacion(), tramitehecho.getEhtiponotificacion(),
				tramitehecho.getEhnumregistrosalida(), tramitehecho.getEhacuserecibo(),
				tramitehecho.getEhacusereciborecibido(), tramitehecho.getEhnumregistroentrada(),
				tramitehecho.getEhidnotificacionplatea(), tramitehecho.getEhnombretramite(), tramitehecho.getEhnrtel1(),
				tramitehecho.getEhnrtel2(), tramitehecho.getEhnrtel3(), tramitehecho.getEhiddestinatario(),
				tramitehecho.getEhcomoasignado(), tramitehecho.getEhfecharegistrosalida(),
				tramitehecho.getEhfecharegistroentrada(), tramitehecho.getEhestadotramite(),
				Y41bUtils.clobToString(tramitehecho.getEhsiguientestramites()),
				Y41bUtils.clobToString(tramitehecho.getEhtextoacuerdo()),
				Y41bUtils.clobToString(tramitehecho.getEhinstrucinspecc()),
				Y41bUtils.clobToString(tramitehecho.getEhmotivorechazo()),
				Y41bUtils.clobToString(tramitehecho.getEhmotivorecurso()), tramitehecho.getEhcomodesignado(),
				tramitehecho.getEhrequierefirma(), Y41bUtils.clobToString(tramitehecho.getEhresumenalegacion()),
				Y41bUtils.clobToString(tramitehecho.getEhresumenmediacion()),
				Y41bUtils.clobToString(tramitehecho.getEhtextocomunicacion()),
				tramitehecho.getEhtiponotificacionplatea(), tramitehecho.getEhidesperaplatea(),
				tramitehecho.getEhmatarespera(), tramitehecho.getEhfechapublicacionbopv(),
				tramitehecho.getEhfechapublicacionayto(), Y41bUtils.clobToString(tramitehecho.getEhintervinientes()),
				tramitehecho.getEhtipomediacion(), tramitehecho.getEhorigenalegacion(),
				tramitehecho.getEhasuntocomunicacion(), tramitehecho.getEhsede(), tramitehecho.getEhfechalimite(),
				tramitehecho.getEhhoramediacioninicio(), tramitehecho.getEhhoramediacionfin(),
				Y41bUtils.clobToString(tramitehecho.getEhjustificacioninfraccion()), tramitehecho.getEhcodrem(),
				tramitehecho.getEhenvrem(), tramitehecho.getEhfcodigo(), tramitehecho.getEhidmailorigen(),
				tramitehecho.getEhmailorigen(), tramitehecho.getEhidmaildestino(), tramitehecho.getEhmaildestino(),
				tramitehecho.getEhfechaEnvioBOPVBOE(),
				Y41bUtils.clobToString(tramitehecho.getEhdocumentacionrequerida()),
				Y41bUtils.clobToString(tramitehecho.getEhdocumentacionrequeridae()), tramitehecho.getEhfeccolabsol(),
				tramitehecho.getEhcodmotivocolabsol(), tramitehecho.getEhidorganismocolabsol(),
				Y41bUtils.clobToString(tramitehecho.getEhresumencolabsol()), tramitehecho.getEhfeccolabresp(),
				tramitehecho.getEhrespuestacolabresp(), Y41bUtils.clobToString(tramitehecho.getEhresumencolabresp()),
				tramitehecho.getEhautomatico(), tramitehecho.getEhresumenins(), tramitehecho.getEhaceptacionins(),
				tramitehecho.getEhmotivoins(), tramitehecho.getEhcodins(), tramitehecho.getEhistelematico(),
				tramitehecho.getEhissir(), tramitehecho.getEhissirconnumregentori(), tramitehecho.getEhcoorinspeccion(),
				tramitehecho.getEhexcluircierre(), tramitehecho.getEhfechasolampliacionplazo(),
				tramitehecho.getEhaceptacionplazo(), tramitehecho.getEhplazoconcedido(),
				tramitehecho.getEhidunidaddir3(), Y41bUtils.clobToString(tramitehecho.getEhapercibimientoes()),
				Y41bUtils.clobToString(tramitehecho.getEhapercibimientoeu()));
		return tramitehecho;
	}

	/**
	 * Inserts a single row in the NotificacionAcuseRecibo table.
	 * 
	 * @param notificacionAcuseRecibo
	 *            NotificacionAcuseRecibo
	 * @return NotificacionAcuseRecibo
	 */
	public NotificacionAcuseRecibo addNotificacionAcuseRecibo(NotificacionAcuseRecibo notificacionAcuseRecibo) {
		String query = "INSERT INTO NOTIFICACION_ACUSERECIBO (EHIDNOTIFICACIONPLATEA, EHCODIGOACUSE, EHPCODIGO) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, notificacionAcuseRecibo.getEhidnotificacionplatea(),
				notificacionAcuseRecibo.getEhcodigoacuse(), notificacionAcuseRecibo.getEhpcodigo());
		return notificacionAcuseRecibo;
	}

	// IMPORTANTE - No pueden incorporarse NUNCA a la UPDATE los siguientes
	// campos (ya que dejarian de funcionar cosas relacionadas):
	// - EHMATARESPERA
	// - EHIDESPERAPLATEA
	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho update(TramiteHecho tramitehecho) {
		String query = "UPDATE TRAMITE_HECHO SET EHCOTEE=?, EHFECHA=?, EHHORA=?, EHCODPOR=?, EHCODPDE=?, EHTEXTO=?, EHCOHD=?, EHCOZS=?, EHCOMO=?, EHCIVIHE=?, EHCOEH=?, EHACUSE=?, EHENVIOMAIL=?, EHDIREMAIL=?, EHCOORTRASPASO=?, EHCOACTUA=?, EHFECHAFIN=?, EHCOMOEJECUCION=?, EHCOSC=?, EHRESPUESTA=?, EHFECHAMEDIACION=?, EHHORAMEDIACION=?, EHFECHAENVIOCONVOCATORIA=?, EHFECHAREALIZACION=?, EHHORAREALIZACION=?, EHFECHACONCILIACION=?, EHFECHAFIRMAACUERDO=?, EHPLAZOINSPECCION=?, INCODIGO=?, EHRESPUESTATRASPASO=?, EHDECODIGO=?, EHFECHARESOLUCION=?, EHFECHARECURSO=?, EHTIPORECURSO=?, EHABOGADO=?, EHESTIMACION=?, EHFECHACIERRE=?, EHDESTINATARIO=?, EHFECHACOMUNICACION=?, EHTIPOCOMUNICACION=?, EHTIPONOTIFICACION=?, EHNUMREGISTROSALIDA=?, EHACUSERECIBO=?, EHACUSERECIBORECIBIDO=?, EHNUMREGISTROENTRADA=?, EHIDNOTIFICACIONPLATEA=?, EHNOMBRETRAMITE=?, EHNRTEL1=?, EHNRTEL2=?, EHNRTEL3=?, EHIDDESTINATARIO=?, EHCOMOASIGNADO=?, EHFECHAREGISTROSALIDA=?, EHFECHAREGISTROENTRADA=?, EHESTADOTRAMITE=?, EHSIGUIENTESTRAMITES=?, EHTEXTOACUERDO=?, EHINSTRUCINSPECC=?, EHMOTIVORECHAZO=?, EHMOTIVORECURSO=?, EHCOMODESIGNADO=?,EHREQUIEREFIRMA=?,EHRESUMENALEGACION=?,EHRESUMENMEDIACION=?,EHTEXTOCOMUNICACION=?,EHTIPONOTIFICACIONPLATEA=?,EHFECHAPUBLICACIONBOPV=?,EHFECHAPUBLICACIONAYTO=?,EHINTERVINIENTES=?,EHTIPOMEDIACION=?,EHORIGENALEGACION=?,EHASUNTOCOMUNICACION=?,EHSEDE=?,EHFECHALIMITE=?,EHHORAMEDIACIONINICIO=?,EHHORAMEDIACIONFIN=?,EHJUSTIFICACIONINFRACCION=?, EHCODREM=?, EHENVREM=?, EHIDMAILORIGEN=?,EHMAILORIGEN=?,EHIDMAILDESTINO=?,EHMAILDESTINO=?,EHFECHAENVIOBOPVBOE=?, EHDOCUMENTACIONREQUERIDA=?, EHDOCUMENTACIONREQUERIDAE=?, EHFECCOLABSOL=?, EHCODMOTIVOCOLABSOL=?, EHIDORGANISMOCOLABSOL=?, EHRESUMENCOLABSOL=?, EHFECCOLABRESP=?, EHRESPUESTACOLABRESP=?, EHRESUMENCOLABRESP=?, EHRESUMENINS=?, EHACEPTACIONINS=?, EHMOTIVOINS=?, EHCODINS=?, EHCOORINSPECCION=?, EHEXCLUIRCIERRE=?, EHFECHASOLAMPLIACIONPLAZO=?, EHACEPTACIONPLAZO=?, EHPLAZOCONCEDIDO=?, EHIDUNIDADDIR3=?, EHAPERCIBIMIENTOES=?, EHAPERCIBIMIENTOEU=? WHERE EHCODIGO=?";

		this.jdbcTemplate.update(query, tramitehecho.getEhcotee(), tramitehecho.getEhfecha(), tramitehecho.getEhhora(),
				tramitehecho.getEhcodpor(), tramitehecho.getEhcodpde(), tramitehecho.getEhtexto(),
				tramitehecho.getEhcohd(), tramitehecho.getEhcozs(), tramitehecho.getEhcomo(),
				tramitehecho.getEhcivihe(), tramitehecho.getEhcoeh(), tramitehecho.getEhacuse(),
				tramitehecho.getEhenviomail(), tramitehecho.getEhdiremail(), tramitehecho.getEhcoortraspaso(),
				tramitehecho.getEhcoactua(), tramitehecho.getEhfechafin(), tramitehecho.getEhcomoejecucion(),
				tramitehecho.getEhcosc(), tramitehecho.getEhrespuesta(), tramitehecho.getEhfechamediacion(),
				tramitehecho.getEhhoramediacion(), tramitehecho.getEhfechaenvioconvocatoria(),
				tramitehecho.getEhfecharealizacion(), tramitehecho.getEhhorarealizacion(),
				tramitehecho.getEhfechaconciliacion(), tramitehecho.getEhfechafirmaacuerdo(),
				tramitehecho.getEhplazoinspeccion(), tramitehecho.getIncodigo(), tramitehecho.getEhrespuestatraspaso(),
				tramitehecho.getEhdecodigo(), tramitehecho.getEhfecharesolucion(), tramitehecho.getEhfecharecurso(),
				tramitehecho.getEhtiporecurso(), tramitehecho.getEhabogado(), tramitehecho.getEhestimacion(),
				tramitehecho.getEhfechacierre(), tramitehecho.getEhdestinatario(),
				tramitehecho.getEhfechacomunicacion(), tramitehecho.getEhtipocomunicacion(),
				tramitehecho.getEhtiponotificacion(), tramitehecho.getEhnumregistrosalida(),
				tramitehecho.getEhacuserecibo(), tramitehecho.getEhacusereciborecibido(),
				tramitehecho.getEhnumregistroentrada(), tramitehecho.getEhidnotificacionplatea(),
				tramitehecho.getEhnombretramite(), tramitehecho.getEhnrtel1(), tramitehecho.getEhnrtel2(),
				tramitehecho.getEhnrtel3(), tramitehecho.getEhiddestinatario(), tramitehecho.getEhcomoasignado(),
				tramitehecho.getEhfecharegistrosalida(), tramitehecho.getEhfecharegistroentrada(),
				tramitehecho.getEhestadotramite(), Y41bUtils.clobToString(tramitehecho.getEhsiguientestramites()),
				Y41bUtils.clobToString(tramitehecho.getEhtextoacuerdo()),
				Y41bUtils.clobToString(tramitehecho.getEhinstrucinspecc()),
				Y41bUtils.clobToString(tramitehecho.getEhmotivorechazo()),
				Y41bUtils.clobToString(tramitehecho.getEhmotivorecurso()), tramitehecho.getEhcomodesignado(),
				tramitehecho.getEhrequierefirma(), Y41bUtils.clobToString(tramitehecho.getEhresumenalegacion()),
				Y41bUtils.clobToString(tramitehecho.getEhresumenmediacion()),
				Y41bUtils.clobToString(tramitehecho.getEhtextocomunicacion()),
				tramitehecho.getEhtiponotificacionplatea(), tramitehecho.getEhfechapublicacionbopv(),
				tramitehecho.getEhfechapublicacionayto(), Y41bUtils.clobToString(tramitehecho.getEhintervinientes()),
				tramitehecho.getEhtipomediacion(), tramitehecho.getEhorigenalegacion(),
				tramitehecho.getEhasuntocomunicacion(), tramitehecho.getEhsede(), tramitehecho.getEhfechalimite(),
				tramitehecho.getEhhoramediacioninicio(), tramitehecho.getEhhoramediacionfin(),
				Y41bUtils.clobToString(tramitehecho.getEhjustificacioninfraccion()), tramitehecho.getEhcodrem(),
				tramitehecho.getEhenvrem(), tramitehecho.getEhidmailorigen(), tramitehecho.getEhmailorigen(),
				tramitehecho.getEhidmaildestino(), tramitehecho.getEhmaildestino(),
				tramitehecho.getEhfechaEnvioBOPVBOE(),
				Y41bUtils.clobToString(tramitehecho.getEhdocumentacionrequerida()),
				Y41bUtils.clobToString(tramitehecho.getEhdocumentacionrequeridae()), tramitehecho.getEhfeccolabsol(),
				tramitehecho.getEhcodmotivocolabsol(), tramitehecho.getEhidorganismocolabsol(),
				Y41bUtils.clobToString(tramitehecho.getEhresumencolabsol()), tramitehecho.getEhfeccolabresp(),
				tramitehecho.getEhrespuestacolabresp(), Y41bUtils.clobToString(tramitehecho.getEhresumencolabresp()),
				tramitehecho.getEhresumenins(), tramitehecho.getEhaceptacionins(), tramitehecho.getEhmotivoins(),
				tramitehecho.getEhcodins(), tramitehecho.getEhcoorinspeccion(), tramitehecho.getEhexcluircierre(),
				tramitehecho.getEhfechasolampliacionplazo(), tramitehecho.getEhaceptacionplazo(),
				tramitehecho.getEhplazoconcedido(), tramitehecho.getEhidunidaddir3(),
				Y41bUtils.clobToString(tramitehecho.getEhapercibimientoes()),
				Y41bUtils.clobToString(tramitehecho.getEhapercibimientoeu()), tramitehecho.getEhcodigo());
		return tramitehecho;
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho updateIdNotificacionPlatea(TramiteHecho tramitehecho) {
		String query = "UPDATE TRAMITE_HECHO SET EHIDNOTIFICACIONPLATEA=? WHERE EHCODIGO=?";

		this.jdbcTemplate.update(query, tramitehecho.getEhidnotificacionplatea(), tramitehecho.getEhcodigo());
		return tramitehecho;
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho updateProceedingsIdPlatea(TramiteHecho tramitehecho) {
		String query = "UPDATE TRAMITE_HECHO SET EHPROCEEDINGSIDPLATEA=? WHERE EHCODIGO=?";

		this.jdbcTemplate.update(query, tramitehecho.getEhproceedingsidplatea(), tramitehecho.getEhcodigo());
		return tramitehecho;
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho updateRegistroSalidaPlatea(TramiteHecho tramitehecho) {
		String query = "UPDATE TRAMITE_HECHO SET EHNUMREGISTROSALIDA=?, EHFECHAREGISTROSALIDA=? WHERE EHCODIGO=?";

		this.jdbcTemplate.update(query, tramitehecho.getEhnumregistrosalida(), tramitehecho.getEhfecharegistrosalida(),
				tramitehecho.getEhcodigo());
		return tramitehecho;
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho updateMatarEspera(TramiteHecho tramitehecho) {
		String query = "UPDATE TRAMITE_HECHO SET EHMATARESPERA=? WHERE EHCODIGO=?";

		this.jdbcTemplate.update(query, tramitehecho.getEhmatarespera(), tramitehecho.getEhcodigo());
		return tramitehecho;
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho updateAcuseReintentado(TramiteHecho tramitehecho) {
		String query = "UPDATE TRAMITE_HECHO SET EHACUSEREINTENTADO=? WHERE EHCODIGO=?";

		this.jdbcTemplate.update(query, tramitehecho.getEhacusereintentado(), tramitehecho.getEhcodigo());
		return tramitehecho;
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho updateEstadoTramite(TramiteHecho tramitehecho) {
		String query = "UPDATE TRAMITE_HECHO SET EHESTADOTRAMITE=? WHERE EHCODIGO=?";

		this.jdbcTemplate.update(query, tramitehecho.getEhestadotramite(), tramitehecho.getEhcodigo());
		return tramitehecho;
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho updateReabrirTramite(TramiteHecho tramitehecho) {
		String query = "UPDATE TRAMITE_HECHO SET EHESTADOTRAMITE=?, EHFECHAFIN=null, EHCOMOEJECUCION=null WHERE EHCODIGO=?";

		this.jdbcTemplate.update(query, tramitehecho.getEhestadotramite(), tramitehecho.getEhcodigo());
		return tramitehecho;
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho updateFechaInicio(TramiteHecho tramitehecho) {
		String query = "UPDATE TRAMITE_HECHO SET EHFECHAINICIO=? WHERE EHCODIGO=?";

		this.jdbcTemplate.update(query, tramitehecho.getEhfechainicio(), tramitehecho.getEhcodigo());
		return tramitehecho;
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho updateFechaLimite(TramiteHecho tramitehecho) {
		String query = "UPDATE TRAMITE_HECHO SET EHFECHALIMITE=? WHERE EHCODIGO=?";

		this.jdbcTemplate.update(query, tramitehecho.getEhfechalimite(), tramitehecho.getEhcodigo());
		return tramitehecho;
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho updateInstructor(TramiteHecho tramitehecho) {
		String query = "UPDATE TRAMITE_HECHO SET EHCOMO=?,EHCOMOASIGNADO=? WHERE EHCODIGO=?";

		this.jdbcTemplate.update(query, tramitehecho.getEhcomo(), tramitehecho.getEhcomoasignado(),
				tramitehecho.getEhcodigo());
		return tramitehecho;
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho updateDenegacionTramite(TramiteHecho tramitehecho) {
		String query = "UPDATE TRAMITE_HECHO SET EHTEXTO=?,EHESTADOTRAMITE=? WHERE EHCODIGO=?";

		this.jdbcTemplate.update(query, tramitehecho.getEhtexto(), tramitehecho.getEhestadotramite(),
				tramitehecho.getEhcodigo());
		return tramitehecho;
	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	@Transactional(readOnly = true)
	public TramiteHecho find(TramiteHecho tramitehecho) {
		try {
			String query = SELECT_TRAMITE_HECHO
					+ " FROM TRAMITE_HECHO t1 , TRAMITE_HECHO t2  WHERE t1.EHCODIGO = ?   AND t1.EHCODIGORELACIONADO= t2.EHCODIGO(+)";

			List<TramiteHecho> tramitehechoList = this.jdbcTemplate.query(query, this.rwMap,
					tramitehecho.getEhcodigo());
			return (TramiteHecho) DataAccessUtils.uniqueResult(tramitehechoList);
		} catch (EmptyResultDataAccessException e) {
			return new TramiteHecho();
		}
	}

	/**
	 * Finds a single row in the NotificacionAcuseRecibo table.
	 * 
	 * @param notificacionAcuseRecibo
	 *            NotificacionAcuseRecibo
	 * @return NotificacionAcuseRecibo
	 */
	@Transactional(readOnly = true)
	public NotificacionAcuseRecibo findNotificacionAcuseRecibo(NotificacionAcuseRecibo notificacionAcuseRecibo) {
		String query = "SELECT EHIDNOTIFICACIONPLATEA EHIDNOTIFICACIONPLATEA, EHCODIGOACUSE EHCODIGOACUSE, EHPCODIGO EHPCODIGO FROM NOTIFICACION_ACUSERECIBO WHERE EHIDNOTIFICACIONPLATEA = ?";

		List<NotificacionAcuseRecibo> notificacionAcuseReciboList = this.jdbcTemplate.query(query,
				this.rwMapNotificacionAcuseRecibo, notificacionAcuseRecibo.getEhidnotificacionplatea());
		return (NotificacionAcuseRecibo) DataAccessUtils.uniqueResult(notificacionAcuseReciboList);
	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	@Transactional(readOnly = true)
	public TramiteHecho findLobTablaTemporal(TramiteHecho tramitehecho) {
		try {
			String query = "SELECT EHCODIGO, EHTEXTO " + "FROM TRAMITE_HECHO  " + "WHERE EHCODIGO = ? ";
			return (TramiteHecho) this.jdbcTemplate.queryForObject(query, new RowMapper<TramiteHecho>() {
				public TramiteHecho mapRow(ResultSet resultSet, int rowNum) throws SQLException {
					return new TramiteHecho(resultSet.getString("EHCODIGO"), resultSet.getString("EHTEXTO"));
				}
			}, tramitehecho.getEhcodigo());
		} catch (EmptyResultDataAccessException e) {
			return new TramiteHecho();
		}
	}

	/**
	 * Removes a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return
	 */
	public void remove(TramiteHecho tramitehecho) {
		String query = "DELETE FROM TRAMITE_HECHO WHERE EHCODIGO=?";
		this.jdbcTemplate.update(query, tramitehecho.getEhcodigo());
	}

	/**
	 * Removes a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return
	 */
	public void removeTramitesExpediente(TramiteHecho tramitehecho) {
		String query = "DELETE FROM TRAMITE_HECHO WHERE EHCOHD=?";
		this.jdbcTemplate.update(query, tramitehecho.getEhcohd());
	}

	/**
	 * Removes a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return
	 */
	public void removeTramiteCierreSinTramitarExpediente(TramiteHecho tramitehecho) {
		String query = "DELETE FROM TRAMITE_HECHO WHERE EHCOHD=? AND EHCOTEE=? AND EHFECHAFIN IS NULL";
		this.jdbcTemplate.update(query, tramitehecho.getEhcohd(), Y41bConstantes.TRAMITE_CIERRE_EXPEDIENTE);
	}

	/**
	 * Finds a List of rows in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TramiteHecho> findAll(TramiteHecho tramitehecho, Pagination pagination) {
		StringBuilder query = new StringBuilder(SELECT_TRAMITE_HECHO);
		query.append(" FROM TRAMITE_HECHO t1 ,TRAMITE_HECHO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tramitehecho);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.EHCODIGORELACIONADO= t2.EHCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<TramiteHecho>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(TramiteHecho tramitehecho) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM TRAMITE_HECHO t1 , TRAMITE_HECHO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tramitehecho);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.EHCODIGORELACIONADO= t2.EHCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the TramiteHecho table using like.
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TramiteHecho> findAllLike(TramiteHecho tramitehecho, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(SELECT_TRAMITE_HECHO);
		query.append(" FROM TRAMITE_HECHO t1 ,TRAMITE_HECHO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tramitehecho, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.EHCODIGORELACIONADO= t2.EHCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<TramiteHecho>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the TramiteHecho table using like.
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(TramiteHecho tramitehecho, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM TRAMITE_HECHO t1 ,TRAMITE_HECHO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tramitehecho, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.EHCODIGORELACIONADO= t2.EHCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TramiteHecho entity
	 * 
	 * @param tramitehecho
	 *            TramiteHecho Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(TramiteHecho tramitehecho) {

		StringBuilder where = new StringBuilder(TramiteHechoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tramitehecho != null && tramitehecho.getEhcodigo() != null) {
			where.append(" AND t1.EHCODIGO = ?");
			params.add(tramitehecho.getEhcodigo());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhcodigo() != null) {
			where.append(" AND t2.EHCODIGO = ?");
			params.add(tramitehecho.getTramiteHecho().getEhcodigo());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getTramiteHecho().getEhcodigo() != null) {
			where.append(" AND t2.EHCODIGORELACIONADO = ?");
			params.add(tramitehecho.getTramiteHecho().getTramiteHecho().getEhcodigo());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhcotee() != null) {
			where.append(" AND t2.EHCOTEE = ?");
			params.add(tramitehecho.getTramiteHecho().getEhcotee());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfecha() != null) {
			where.append(" AND t2.EHFECHA = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfecha());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhhora() != null) {
			where.append(" AND t2.EHHORA = ?");
			params.add(tramitehecho.getTramiteHecho().getEhhora());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhcodpor() != null) {
			where.append(" AND t2.EHCODPOR = ?");
			params.add(tramitehecho.getTramiteHecho().getEhcodpor());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhcodpde() != null) {
			where.append(" AND t2.EHCODPDE = ?");
			params.add(tramitehecho.getTramiteHecho().getEhcodpde());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhtexto() != null) {
			where.append(" AND t2.EHTEXTO = ?");
			params.add(tramitehecho.getTramiteHecho().getEhtexto());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhcohd() != null) {
			where.append(" AND t2.EHCOHD = ?");
			params.add(tramitehecho.getTramiteHecho().getEhcohd());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhcozs() != null) {
			where.append(" AND t2.EHCOZS = ?");
			params.add(tramitehecho.getTramiteHecho().getEhcozs());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhcomo() != null) {
			where.append(" AND t2.EHCOMO = ?");
			params.add(tramitehecho.getTramiteHecho().getEhcomo());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhcivihe() != null) {
			where.append(" AND t2.EHCIVIHE = ?");
			params.add(tramitehecho.getTramiteHecho().getEhcivihe());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhcoeh() != null) {
			where.append(" AND t2.EHCOEH = ?");
			params.add(tramitehecho.getTramiteHecho().getEhcoeh());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhacuse() != null) {
			where.append(" AND t2.EHACUSE = ?");
			params.add(tramitehecho.getTramiteHecho().getEhacuse());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhenviomail() != null) {
			where.append(" AND t2.EHENVIOMAIL = ?");
			params.add(tramitehecho.getTramiteHecho().getEhenviomail());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhdiremail() != null) {
			where.append(" AND t2.EHDIREMAIL = ?");
			params.add(tramitehecho.getTramiteHecho().getEhdiremail());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhcoortraspaso() != null) {
			where.append(" AND t2.EHCOORTRASPASO = ?");
			params.add(tramitehecho.getTramiteHecho().getEhcoortraspaso());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhcoactua() != null) {
			where.append(" AND t2.EHCOACTUA = ?");
			params.add(tramitehecho.getTramiteHecho().getEhcoactua());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfechainicio() != null) {
			where.append(" AND t2.EHFECHAINICIO = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfechainicio());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfechafin() != null) {
			where.append(" AND t2.EHFECHAFIN = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfechafin());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhcomoejecucion() != null) {
			where.append(" AND t2.EHCOMOEJECUCION = ?");
			params.add(tramitehecho.getTramiteHecho().getEhcomoejecucion());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhcosc() != null) {
			where.append(" AND t2.EHCOSC = ?");
			params.add(tramitehecho.getTramiteHecho().getEhcosc());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhrespuesta() != null) {
			where.append(" AND t2.EHRESPUESTA = ?");
			params.add(tramitehecho.getTramiteHecho().getEhrespuesta());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfechamediacion() != null) {
			where.append(" AND t2.EHFECHAMEDIACION = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfechamediacion());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhhoramediacion() != null) {
			where.append(" AND t2.EHHORAMEDIACION = ?");
			params.add(tramitehecho.getTramiteHecho().getEhhoramediacion());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfechaenvioconvocatoria() != null) {
			where.append(" AND t2.EHFECHAENVIOCONVOCATORIA = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfechaenvioconvocatoria());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfecharealizacion() != null) {
			where.append(" AND t2.EHFECHAREALIZACION = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfecharealizacion());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhhorarealizacion() != null) {
			where.append(" AND t2.EHHORAREALIZACION = ?");
			params.add(tramitehecho.getTramiteHecho().getEhhorarealizacion());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfechaconciliacion() != null) {
			where.append(" AND t2.EHFECHACONCILIACION = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfechaconciliacion());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfechafirmaacuerdo() != null) {
			where.append(" AND t2.EHFECHAFIRMAACUERDO = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfechafirmaacuerdo());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhplazoinspeccion() != null) {
			where.append(" AND t2.EHPLAZOINSPECCION = ?");
			params.add(tramitehecho.getTramiteHecho().getEhplazoinspeccion());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getIncodigo() != null) {
			where.append(" AND t2.INCODIGO = ?");
			params.add(tramitehecho.getTramiteHecho().getIncodigo());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhrespuestatraspaso() != null) {
			where.append(" AND t2.EHRESPUESTATRASPASO = ?");
			params.add(tramitehecho.getTramiteHecho().getEhrespuestatraspaso());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhdecodigo() != null) {
			where.append(" AND t2.EHDECODIGO = ?");
			params.add(tramitehecho.getTramiteHecho().getEhdecodigo());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfecharesolucion() != null) {
			where.append(" AND t2.EHFECHARESOLUCION = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfecharesolucion());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfecharecurso() != null) {
			where.append(" AND t2.EHFECHARECURSO = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfecharecurso());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhtiporecurso() != null) {
			where.append(" AND t2.EHTIPORECURSO = ?");
			params.add(tramitehecho.getTramiteHecho().getEhtiporecurso());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhabogado() != null) {
			where.append(" AND t2.EHABOGADO = ?");
			params.add(tramitehecho.getTramiteHecho().getEhabogado());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhestimacion() != null) {
			where.append(" AND t2.EHESTIMACION = ?");
			params.add(tramitehecho.getTramiteHecho().getEhestimacion());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfechacierre() != null) {
			where.append(" AND t2.EHFECHACIERRE = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfechacierre());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhdestinatario() != null) {
			where.append(" AND t2.EHDESTINATARIO = ?");
			params.add(tramitehecho.getTramiteHecho().getEhdestinatario());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfechacomunicacion() != null) {
			where.append(" AND t2.EHFECHACOMUNICACION = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfechacomunicacion());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhtipocomunicacion() != null) {
			where.append(" AND t2.EHTIPOCOMUNICACION = ?");
			params.add(tramitehecho.getTramiteHecho().getEhtipocomunicacion());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhtiponotificacion() != null) {
			where.append(" AND t2.EHTIPONOTIFICACION = ?");
			params.add(tramitehecho.getTramiteHecho().getEhtiponotificacion());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhnumregistrosalida() != null) {
			where.append(" AND t2.EHNUMREGISTROSALIDA = ?");
			params.add(tramitehecho.getTramiteHecho().getEhnumregistrosalida());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhacuserecibo() != null) {
			where.append(" AND t2.EHACUSERECIBO = ?");
			params.add(tramitehecho.getTramiteHecho().getEhacuserecibo());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhacusereciborecibido() != null) {
			where.append(" AND t2.EHACUSERECIBORECIBIDO = ?");
			params.add(tramitehecho.getTramiteHecho().getEhacusereciborecibido());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhnumregistroentrada() != null) {
			where.append(" AND t2.EHNUMREGISTROENTRADA = ?");
			params.add(tramitehecho.getTramiteHecho().getEhnumregistroentrada());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhidnotificacionplatea() != null) {
			where.append(" AND t2.EHIDNOTIFICACIONPLATEA = ?");
			params.add(tramitehecho.getTramiteHecho().getEhidnotificacionplatea());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhnombretramite() != null) {
			where.append(" AND t2.EHNOMBRETRAMITE = ?");
			params.add(tramitehecho.getTramiteHecho().getEhnombretramite());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhnrtel1() != null) {
			where.append(" AND t2.EHNRTEL1 = ?");
			params.add(tramitehecho.getTramiteHecho().getEhnrtel1());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhnrtel2() != null) {
			where.append(" AND t2.EHNRTEL2 = ?");
			params.add(tramitehecho.getTramiteHecho().getEhnrtel2());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhnrtel3() != null) {
			where.append(" AND t2.EHNRTEL3 = ?");
			params.add(tramitehecho.getTramiteHecho().getEhnrtel3());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhiddestinatario() != null) {
			where.append(" AND t2.EHIDDESTINATARIO = ?");
			params.add(tramitehecho.getTramiteHecho().getEhiddestinatario());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhcomoasignado() != null) {
			where.append(" AND t2.EHCOMOASIGNADO = ?");
			params.add(tramitehecho.getTramiteHecho().getEhcomoasignado());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfecharegistrosalida() != null) {
			where.append(" AND t2.EHFECHAREGISTROSALIDA = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfecharegistrosalida());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfecharegistroentrada() != null) {
			where.append(" AND t2.EHFECHAREGISTROENTRADA = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfecharegistroentrada());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhestadotramite() != null) {
			where.append(" AND t2.EHESTADOTRAMITE = ?");
			params.add(tramitehecho.getTramiteHecho().getEhestadotramite());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfechapublicacionbopv() != null) {
			where.append(" AND t2.EHFECHAPUBLICACIONBOPV = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfechapublicacionbopv());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfechapublicacionayto() != null) {
			where.append(" AND t2.EHFECHAPUBLICACIONAYTO = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfechapublicacionayto());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhtipomediacion() != null) {
			where.append(" AND t2.EHTIPOMEDIACION = ?");
			params.add(tramitehecho.getTramiteHecho().getEhtipomediacion());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhorigenalegacion() != null) {
			where.append(" AND t2.EHORIGENALEGACION = ?");
			params.add(tramitehecho.getTramiteHecho().getEhorigenalegacion());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhasuntocomunicacion() != null) {
			where.append(" AND t2.EHASUNTOCOMUNICACION = ?");
			params.add(tramitehecho.getTramiteHecho().getEhasuntocomunicacion());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhcodrem() != null) {
			where.append(" AND t2.EHCODREM = ?");
			params.add(tramitehecho.getTramiteHecho().getEhcodrem());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhenvrem() != null) {
			where.append(" AND t2.EHENVREM = ?");
			params.add(tramitehecho.getTramiteHecho().getEhenvrem());
		}
		if (tramitehecho != null && tramitehecho.getEhcotee() != null) {
			where.append(" AND t1.EHCOTEE = ?");
			params.add(tramitehecho.getEhcotee());
		}
		if (tramitehecho != null && tramitehecho.getEhfecha() != null) {
			where.append(" AND t1.EHFECHA = ?");
			params.add(tramitehecho.getEhfecha());
		}
		if (tramitehecho != null && tramitehecho.getEhhora() != null) {
			where.append(" AND t1.EHHORA = ?");
			params.add(tramitehecho.getEhhora());
		}
		if (tramitehecho != null && tramitehecho.getEhcodpor() != null) {
			where.append(" AND t1.EHCODPOR = ?");
			params.add(tramitehecho.getEhcodpor());
		}
		if (tramitehecho != null && tramitehecho.getEhcodpde() != null) {
			where.append(" AND t1.EHCODPDE = ?");
			params.add(tramitehecho.getEhcodpde());
		}
		if (tramitehecho != null && tramitehecho.getEhtexto() != null) {
			where.append(" AND t1.EHTEXTO = ?");
			params.add(tramitehecho.getEhtexto());
		}
		if (tramitehecho != null && tramitehecho.getEhcohd() != null) {
			where.append(" AND t1.EHCOHD = ?");
			params.add(tramitehecho.getEhcohd());
		}
		if (tramitehecho != null && tramitehecho.getEhcozs() != null) {
			where.append(" AND t1.EHCOZS = ?");
			params.add(tramitehecho.getEhcozs());
		}
		if (tramitehecho != null && tramitehecho.getEhcomo() != null) {
			where.append(" AND t1.EHCOMO = ?");
			params.add(tramitehecho.getEhcomo());
		}
		if (tramitehecho != null && tramitehecho.getEhcivihe() != null) {
			where.append(" AND t1.EHCIVIHE = ?");
			params.add(tramitehecho.getEhcivihe());
		}
		if (tramitehecho != null && tramitehecho.getEhcoeh() != null) {
			where.append(" AND t1.EHCOEH = ?");
			params.add(tramitehecho.getEhcoeh());
		}
		if (tramitehecho != null && tramitehecho.getEhacuse() != null) {
			where.append(" AND t1.EHACUSE = ?");
			params.add(tramitehecho.getEhacuse());
		}
		if (tramitehecho != null && tramitehecho.getEhenviomail() != null) {
			where.append(" AND t1.EHENVIOMAIL = ?");
			params.add(tramitehecho.getEhenviomail());
		}
		if (tramitehecho != null && tramitehecho.getEhdiremail() != null) {
			where.append(" AND t1.EHDIREMAIL = ?");
			params.add(tramitehecho.getEhdiremail());
		}
		if (tramitehecho != null && tramitehecho.getEhcoortraspaso() != null) {
			where.append(" AND t1.EHCOORTRASPASO = ?");
			params.add(tramitehecho.getEhcoortraspaso());
		}
		if (tramitehecho != null && tramitehecho.getEhcoactua() != null) {
			where.append(" AND t1.EHCOACTUA = ?");
			params.add(tramitehecho.getEhcoactua());
		}
		if (tramitehecho != null && tramitehecho.getEhfechainicio() != null) {
			where.append(" AND t1.EHFECHAINICIO = ?");
			params.add(tramitehecho.getEhfechainicio());
		}
		if (tramitehecho != null && tramitehecho.getEhfechafin() != null) {
			where.append(" AND t1.EHFECHAFIN = ?");
			params.add(tramitehecho.getEhfechafin());
		}
		if (tramitehecho != null && tramitehecho.getEhcomoejecucion() != null) {
			where.append(" AND t1.EHCOMOEJECUCION = ?");
			params.add(tramitehecho.getEhcomoejecucion());
		}
		if (tramitehecho != null && tramitehecho.getEhcosc() != null) {
			where.append(" AND t1.EHCOSC = ?");
			params.add(tramitehecho.getEhcosc());
		}
		if (tramitehecho != null && tramitehecho.getEhrespuesta() != null) {
			where.append(" AND t1.EHRESPUESTA = ?");
			params.add(tramitehecho.getEhrespuesta());
		}
		if (tramitehecho != null && tramitehecho.getEhfechamediacion() != null) {
			where.append(" AND t1.EHFECHAMEDIACION = ?");
			params.add(tramitehecho.getEhfechamediacion());
		}
		if (tramitehecho != null && tramitehecho.getEhhoramediacion() != null) {
			where.append(" AND t1.EHHORAMEDIACION = ?");
			params.add(tramitehecho.getEhhoramediacion());
		}
		if (tramitehecho != null && tramitehecho.getEhfechaenvioconvocatoria() != null) {
			where.append(" AND t1.EHFECHAENVIOCONVOCATORIA = ?");
			params.add(tramitehecho.getEhfechaenvioconvocatoria());
		}
		if (tramitehecho != null && tramitehecho.getEhfecharealizacion() != null) {
			where.append(" AND t1.EHFECHAREALIZACION = ?");
			params.add(tramitehecho.getEhfecharealizacion());
		}
		if (tramitehecho != null && tramitehecho.getEhhorarealizacion() != null) {
			where.append(" AND t1.EHHORAREALIZACION = ?");
			params.add(tramitehecho.getEhhorarealizacion());
		}
		if (tramitehecho != null && tramitehecho.getEhfechaconciliacion() != null) {
			where.append(" AND t1.EHFECHACONCILIACION = ?");
			params.add(tramitehecho.getEhfechaconciliacion());
		}
		if (tramitehecho != null && tramitehecho.getEhfechafirmaacuerdo() != null) {
			where.append(" AND t1.EHFECHAFIRMAACUERDO = ?");
			params.add(tramitehecho.getEhfechafirmaacuerdo());
		}
		if (tramitehecho != null && tramitehecho.getEhplazoinspeccion() != null) {
			where.append(" AND t1.EHPLAZOINSPECCION = ?");
			params.add(tramitehecho.getEhplazoinspeccion());
		}
		if (tramitehecho != null && tramitehecho.getIncodigo() != null) {
			where.append(" AND t1.INCODIGO = ?");
			params.add(tramitehecho.getIncodigo());
		}
		if (tramitehecho != null && tramitehecho.getEhrespuestatraspaso() != null) {
			where.append(" AND t1.EHRESPUESTATRASPASO = ?");
			params.add(tramitehecho.getEhrespuestatraspaso());
		}
		if (tramitehecho != null && tramitehecho.getEhdecodigo() != null) {
			where.append(" AND t1.EHDECODIGO = ?");
			params.add(tramitehecho.getEhdecodigo());
		}
		if (tramitehecho != null && tramitehecho.getEhfecharesolucion() != null) {
			where.append(" AND t1.EHFECHARESOLUCION = ?");
			params.add(tramitehecho.getEhfecharesolucion());
		}
		if (tramitehecho != null && tramitehecho.getEhfecharecurso() != null) {
			where.append(" AND t1.EHFECHARECURSO = ?");
			params.add(tramitehecho.getEhfecharecurso());
		}
		if (tramitehecho != null && tramitehecho.getEhtiporecurso() != null) {
			where.append(" AND t1.EHTIPORECURSO = ?");
			params.add(tramitehecho.getEhtiporecurso());
		}
		if (tramitehecho != null && tramitehecho.getEhabogado() != null) {
			where.append(" AND t1.EHABOGADO = ?");
			params.add(tramitehecho.getEhabogado());
		}
		if (tramitehecho != null && tramitehecho.getEhestimacion() != null) {
			where.append(" AND t1.EHESTIMACION = ?");
			params.add(tramitehecho.getEhestimacion());
		}
		if (tramitehecho != null && tramitehecho.getEhfechacierre() != null) {
			where.append(" AND t1.EHFECHACIERRE = ?");
			params.add(tramitehecho.getEhfechacierre());
		}
		if (tramitehecho != null && tramitehecho.getEhdestinatario() != null) {
			where.append(" AND t1.EHDESTINATARIO = ?");
			params.add(tramitehecho.getEhdestinatario());
		}
		if (tramitehecho != null && tramitehecho.getEhfechacomunicacion() != null) {
			where.append(" AND t1.EHFECHACOMUNICACION = ?");
			params.add(tramitehecho.getEhfechacomunicacion());
		}
		if (tramitehecho != null && tramitehecho.getEhtipocomunicacion() != null) {
			where.append(" AND t1.EHTIPOCOMUNICACION = ?");
			params.add(tramitehecho.getEhtipocomunicacion());
		}
		if (tramitehecho != null && tramitehecho.getEhtiponotificacion() != null) {
			where.append(" AND t1.EHTIPONOTIFICACION = ?");
			params.add(tramitehecho.getEhtiponotificacion());
		}
		if (tramitehecho != null && tramitehecho.getEhnumregistrosalida() != null) {
			where.append(" AND t1.EHNUMREGISTROSALIDA = ?");
			params.add(tramitehecho.getEhnumregistrosalida());
		}
		if (tramitehecho != null && tramitehecho.getEhacuserecibo() != null) {
			where.append(" AND t1.EHACUSERECIBO = ?");
			params.add(tramitehecho.getEhacuserecibo());
		}
		if (tramitehecho != null && tramitehecho.getEhacusereciborecibido() != null) {
			where.append(" AND t1.EHACUSERECIBORECIBIDO = ?");
			params.add(tramitehecho.getEhacusereciborecibido());
		}
		if (tramitehecho != null && tramitehecho.getEhnumregistroentrada() != null) {
			where.append(" AND t1.EHNUMREGISTROENTRADA = ?");
			params.add(tramitehecho.getEhnumregistroentrada());
		}
		if (tramitehecho != null && tramitehecho.getEhidnotificacionplatea() != null) {
			where.append(" AND t1.EHIDNOTIFICACIONPLATEA = ?");
			params.add(tramitehecho.getEhidnotificacionplatea());
		}
		if (tramitehecho != null && tramitehecho.getEhnombretramite() != null) {
			where.append(" AND t1.EHNOMBRETRAMITE = ?");
			params.add(tramitehecho.getEhnombretramite());
		}
		if (tramitehecho != null && tramitehecho.getEhnrtel1() != null) {
			where.append(" AND t1.EHNRTEL1 = ?");
			params.add(tramitehecho.getEhnrtel1());
		}
		if (tramitehecho != null && tramitehecho.getEhnrtel2() != null) {
			where.append(" AND t1.EHNRTEL2 = ?");
			params.add(tramitehecho.getEhnrtel2());
		}
		if (tramitehecho != null && tramitehecho.getEhnrtel3() != null) {
			where.append(" AND t1.EHNRTEL3 = ?");
			params.add(tramitehecho.getEhnrtel3());
		}
		if (tramitehecho != null && tramitehecho.getEhiddestinatario() != null) {
			where.append(" AND t1.EHIDDESTINATARIO = ?");
			params.add(tramitehecho.getEhiddestinatario());
		}
		if (tramitehecho != null && tramitehecho.getEhcomoasignado() != null) {
			where.append(" AND t1.EHCOMOASIGNADO = ?");
			params.add(tramitehecho.getEhcomoasignado());
		}
		if (tramitehecho != null && tramitehecho.getEhfecharegistrosalida() != null) {
			where.append(" AND t1.EHFECHAREGISTROSALIDA = ?");
			params.add(tramitehecho.getEhfecharegistrosalida());
		}
		if (tramitehecho != null && tramitehecho.getEhfecharegistroentrada() != null) {
			where.append(" AND t1.EHFECHAREGISTROENTRADA = ?");
			params.add(tramitehecho.getEhfecharegistroentrada());
		}
		if (tramitehecho != null && tramitehecho.getEhestadotramite() != null) {
			where.append(" AND t1.EHESTADOTRAMITE = ?");
			params.add(tramitehecho.getEhestadotramite());
		}
		if (tramitehecho != null && tramitehecho.getEhfechapublicacionbopv() != null) {
			where.append(" AND t1.EHFECHAPUBLICACIONBOPV = ?");
			params.add(tramitehecho.getEhfechapublicacionbopv());
		}
		if (tramitehecho != null && tramitehecho.getEhfechapublicacionayto() != null) {
			where.append(" AND t1.EHFECHAPUBLICACIONAYTO = ?");
			params.add(tramitehecho.getEhfechapublicacionayto());
		}
		if (tramitehecho != null && tramitehecho.getEhtipomediacion() != null) {
			where.append(" AND t1.EHTIPOMEDIACION = ?");
			params.add(tramitehecho.getEhtipomediacion());
		}
		if (tramitehecho != null && tramitehecho.getEhorigenalegacion() != null) {
			where.append(" AND t1.EHORIGENALEGACION = ?");
			params.add(tramitehecho.getEhorigenalegacion());
		}
		if (tramitehecho != null && tramitehecho.getEhasuntocomunicacion() != null) {
			where.append(" AND t1.EHASUNTOCOMUNICACION = ?");
			params.add(tramitehecho.getEhasuntocomunicacion());
		}
		if (tramitehecho != null && tramitehecho.getEhtiponotificacionplatea() != null) {
			where.append(" AND t1.EHTIPONOTIFICACIONPLATEA = ?");
			params.add(tramitehecho.getEhtiponotificacionplatea());
		}
		if (tramitehecho != null && tramitehecho.getEhidesperaplatea() != null) {
			where.append(" AND t1.EHIDESPERAPLATEA = ?");
			params.add(tramitehecho.getEhidesperaplatea());
		}
		if (tramitehecho != null && tramitehecho.getEhmatarespera() != null) {
			where.append(" AND t1.EHMATARESPERA = ?");
			params.add(tramitehecho.getEhmatarespera());
		}
		if (tramitehecho != null && tramitehecho.getEhhoramediacioninicio() != null) {
			where.append(" AND t1.EHHORAMEDIACIONINICIO = ?");
			params.add(tramitehecho.getEhhoramediacioninicio());
		}
		if (tramitehecho != null && tramitehecho.getEhhoramediacionfin() != null) {
			where.append(" AND t1.EHHORAMEDIACIONFIN = ?");
			params.add(tramitehecho.getEhhoramediacionfin());
		}
		if (tramitehecho != null && tramitehecho.getEhcodrem() != null) {
			where.append(" AND t1.EHCODREM = ?");
			params.add(tramitehecho.getEhcodrem());
		}
		if (tramitehecho != null && tramitehecho.getEhenvrem() != null) {
			where.append(" AND t1.EHENVREM = ?");
			params.add(tramitehecho.getEhenvrem());
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TramiteHecho entity
	 * 
	 * @param tramitehecho
	 *            TramiteHecho Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(TramiteHecho tramitehecho, Boolean startsWith) {

		StringBuilder where = new StringBuilder(TramiteHechoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tramitehecho != null && tramitehecho.getEhcodigo() != null) {
			where.append(" AND UPPER(t1.EHCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.EHCODIGO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhcodigo() != null) {
			where.append(" AND t2.EHCODIGO = ?");
			params.add(tramitehecho.getTramiteHecho().getEhcodigo());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getTramiteHecho().getEhcodigo() != null) {
			where.append(" AND UPPER(t2.EHCODIGORELACIONADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getTramiteHecho().getEhcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getTramiteHecho().getEhcodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.EHCODIGORELACIONADO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhcotee() != null) {
			where.append(" AND UPPER(t2.EHCOTEE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhcotee().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhcotee().toUpperCase() + "%");
			}
			where.append(" AND t2.EHCOTEE IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfecha() != null) {
			where.append(" AND t2.EHFECHA = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfecha());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhhora() != null) {
			where.append(" AND UPPER(t2.EHHORA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhhora().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhhora().toUpperCase() + "%");
			}
			where.append(" AND t2.EHHORA IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhcodpor() != null) {
			where.append(" AND UPPER(t2.EHCODPOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhcodpor().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhcodpor().toUpperCase() + "%");
			}
			where.append(" AND t2.EHCODPOR IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhcodpde() != null) {
			where.append(" AND UPPER(t2.EHCODPDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhcodpde().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhcodpde().toUpperCase() + "%");
			}
			where.append(" AND t2.EHCODPDE IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhtexto() != null) {
			where.append(" AND UPPER(t2.EHTEXTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhtexto().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhtexto().toUpperCase() + "%");
			}
			where.append(" AND t2.EHTEXTO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhcohd() != null) {
			where.append(" AND UPPER(t2.EHCOHD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhcohd().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhcohd().toUpperCase() + "%");
			}
			where.append(" AND t2.EHCOHD IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhcozs() != null) {
			where.append(" AND UPPER(t2.EHCOZS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhcozs().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhcozs().toUpperCase() + "%");
			}
			where.append(" AND t2.EHCOZS IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhcomo() != null) {
			where.append(" AND UPPER(t2.EHCOMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhcomo().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhcomo().toUpperCase() + "%");
			}
			where.append(" AND t2.EHCOMO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhcivihe() != null) {
			where.append(" AND t2.EHCIVIHE = ?");
			params.add(tramitehecho.getTramiteHecho().getEhcivihe());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhcoeh() != null) {
			where.append(" AND UPPER(t2.EHCOEH) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhcoeh().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhcoeh().toUpperCase() + "%");
			}
			where.append(" AND t2.EHCOEH IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhacuse() != null) {
			where.append(" AND t2.EHACUSE = ?");
			params.add(tramitehecho.getTramiteHecho().getEhacuse());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhenviomail() != null) {
			where.append(" AND UPPER(t2.EHENVIOMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhenviomail().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhenviomail().toUpperCase() + "%");
			}
			where.append(" AND t2.EHENVIOMAIL IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhdiremail() != null) {
			where.append(" AND UPPER(t2.EHDIREMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhdiremail().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhdiremail().toUpperCase() + "%");
			}
			where.append(" AND t2.EHDIREMAIL IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhcoortraspaso() != null) {
			where.append(" AND UPPER(t2.EHCOORTRASPASO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhcoortraspaso().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhcoortraspaso().toUpperCase() + "%");
			}
			where.append(" AND t2.EHCOORTRASPASO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhcoactua() != null) {
			where.append(" AND UPPER(t2.EHCOACTUA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhcoactua().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhcoactua().toUpperCase() + "%");
			}
			where.append(" AND t2.EHCOACTUA IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfechainicio() != null) {
			where.append(" AND t2.EHFECHAINICIO = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfechainicio());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfechafin() != null) {
			where.append(" AND t2.EHFECHAFIN = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfechafin());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhcomoejecucion() != null) {
			where.append(" AND UPPER(t2.EHCOMOEJECUCION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhcomoejecucion().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhcomoejecucion().toUpperCase() + "%");
			}
			where.append(" AND t2.EHCOMOEJECUCION IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhcosc() != null) {
			where.append(" AND UPPER(t2.EHCOSC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhcosc().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhcosc().toUpperCase() + "%");
			}
			where.append(" AND t2.EHCOSC IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhrespuesta() != null) {
			where.append(" AND UPPER(t2.EHRESPUESTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhrespuesta().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhrespuesta().toUpperCase() + "%");
			}
			where.append(" AND t2.EHRESPUESTA IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfechamediacion() != null) {
			where.append(" AND t2.EHFECHAMEDIACION = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfechamediacion());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhhoramediacion() != null) {
			where.append(" AND UPPER(t2.EHHORAMEDIACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhhoramediacion().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhhoramediacion().toUpperCase() + "%");
			}
			where.append(" AND t2.EHHORAMEDIACION IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfechaenvioconvocatoria() != null) {
			where.append(" AND t2.EHFECHAENVIOCONVOCATORIA = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfechaenvioconvocatoria());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfecharealizacion() != null) {
			where.append(" AND t2.EHFECHAREALIZACION = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfecharealizacion());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhhorarealizacion() != null) {
			where.append(" AND UPPER(t2.EHHORAREALIZACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhhorarealizacion().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhhorarealizacion().toUpperCase() + "%");
			}
			where.append(" AND t2.EHHORAREALIZACION IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfechaconciliacion() != null) {
			where.append(" AND t2.EHFECHACONCILIACION = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfechaconciliacion());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfechafirmaacuerdo() != null) {
			where.append(" AND t2.EHFECHAFIRMAACUERDO = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfechafirmaacuerdo());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhplazoinspeccion() != null) {
			where.append(" AND t2.EHPLAZOINSPECCION = ?");
			params.add(tramitehecho.getTramiteHecho().getEhplazoinspeccion());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getIncodigo() != null) {
			where.append(" AND UPPER(t2.INCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getIncodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getIncodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.INCODIGO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhrespuestatraspaso() != null) {
			where.append(" AND UPPER(t2.EHRESPUESTATRASPASO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhrespuestatraspaso().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhrespuestatraspaso().toUpperCase() + "%");
			}
			where.append(" AND t2.EHRESPUESTATRASPASO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhdecodigo() != null) {
			where.append(" AND UPPER(t2.EHDECODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhdecodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhdecodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.EHDECODIGO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfecharesolucion() != null) {
			where.append(" AND t2.EHFECHARESOLUCION = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfecharesolucion());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfecharecurso() != null) {
			where.append(" AND t2.EHFECHARECURSO = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfecharecurso());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhtiporecurso() != null) {
			where.append(" AND t2.EHTIPORECURSO = ?");
			params.add(tramitehecho.getTramiteHecho().getEhtiporecurso());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhabogado() != null) {
			where.append(" AND UPPER(t2.EHABOGADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhabogado().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhabogado().toUpperCase() + "%");
			}
			where.append(" AND t2.EHABOGADO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhestimacion() != null) {
			where.append(" AND UPPER(t2.EHESTIMACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhestimacion().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhestimacion().toUpperCase() + "%");
			}
			where.append(" AND t2.EHESTIMACION IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfechacierre() != null) {
			where.append(" AND t2.EHFECHACIERRE = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfechacierre());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhdestinatario() != null) {
			where.append(" AND UPPER(t2.EHDESTINATARIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhdestinatario().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhdestinatario().toUpperCase() + "%");
			}
			where.append(" AND t2.EHDESTINATARIO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfechacomunicacion() != null) {
			where.append(" AND t2.EHFECHACOMUNICACION = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfechacomunicacion());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhtipocomunicacion() != null) {
			where.append(" AND UPPER(t2.EHTIPOCOMUNICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhtipocomunicacion().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhtipocomunicacion().toUpperCase() + "%");
			}
			where.append(" AND t2.EHTIPOCOMUNICACION IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhtiponotificacion() != null) {
			where.append(" AND UPPER(t2.EHTIPONOTIFICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhtiponotificacion().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhtiponotificacion().toUpperCase() + "%");
			}
			where.append(" AND t2.EHTIPONOTIFICACION IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhnumregistrosalida() != null) {
			where.append(" AND UPPER(t2.EHNUMREGISTROSALIDA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhnumregistrosalida().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhnumregistrosalida().toUpperCase() + "%");
			}
			where.append(" AND t2.EHNUMREGISTROSALIDA IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhacuserecibo() != null) {
			where.append(" AND t2.EHACUSERECIBO = ?");
			params.add(tramitehecho.getTramiteHecho().getEhacuserecibo());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhacusereciborecibido() != null) {
			where.append(" AND UPPER(t2.EHACUSERECIBORECIBIDO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhacusereciborecibido().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhacusereciborecibido().toUpperCase() + "%");
			}
			where.append(" AND t2.EHACUSERECIBORECIBIDO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhnumregistroentrada() != null) {
			where.append(" AND UPPER(t2.EHNUMREGISTROENTRADA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhnumregistroentrada().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhnumregistroentrada().toUpperCase() + "%");
			}
			where.append(" AND t2.EHNUMREGISTROENTRADA IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhidnotificacionplatea() != null) {
			where.append(" AND UPPER(t2.EHIDNOTIFICACIONPLATEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhidnotificacionplatea().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhidnotificacionplatea().toUpperCase() + "%");
			}
			where.append(" AND t2.EHIDNOTIFICACIONPLATEA IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhnombretramite() != null) {
			where.append(" AND UPPER(t2.EHNOMBRETRAMITE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhnombretramite().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhnombretramite().toUpperCase() + "%");
			}
			where.append(" AND t2.EHNOMBRETRAMITE IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhnrtel1() != null) {
			where.append(" AND UPPER(t2.EHNRTEL1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhnrtel1().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhnrtel1().toUpperCase() + "%");
			}
			where.append(" AND t2.EHNRTEL1 IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhnrtel2() != null) {
			where.append(" AND UPPER(t2.EHNRTEL2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhnrtel2().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhnrtel2().toUpperCase() + "%");
			}
			where.append(" AND t2.EHNRTEL2 IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhnrtel3() != null) {
			where.append(" AND UPPER(t2.EHNRTEL3) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhnrtel3().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhnrtel3().toUpperCase() + "%");
			}
			where.append(" AND t2.EHNRTEL3 IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhiddestinatario() != null) {
			where.append(" AND UPPER(t2.EHIDDESTINATARIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhiddestinatario().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhiddestinatario().toUpperCase() + "%");
			}
			where.append(" AND t2.EHIDDESTINATARIO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhcomoasignado() != null) {
			where.append(" AND UPPER(t2.EHCOMOASIGNADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhcomoasignado().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhcomoasignado().toUpperCase() + "%");
			}
			where.append(" AND t2.EHCOMOASIGNADO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfecharegistrosalida() != null) {
			where.append(" AND t2.EHFECHAREGISTROSALIDA = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfecharegistrosalida());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfecharegistroentrada() != null) {
			where.append(" AND t2.EHFECHAREGISTROENTRADA = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfecharegistroentrada());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhestadotramite() != null) {
			where.append(" AND UPPER(t2.EHESTADOTRAMITE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhestadotramite().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhestadotramite().toUpperCase() + "%");
			}
			where.append(" AND t2.EHESTADOTRAMITE IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfechapublicacionbopv() != null) {
			where.append(" AND t2.EHFECHAPUBLICACIONBOPV = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfechapublicacionbopv());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhfechapublicacionayto() != null) {
			where.append(" AND t2.EHFECHAPUBLICACIONAYTO = ?");
			params.add(tramitehecho.getTramiteHecho().getEhfechapublicacionayto());
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhtipomediacion() != null) {
			where.append(" AND UPPER(t2.EHTIPOMEDIACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhtipomediacion().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhtipomediacion().toUpperCase() + "%");
			}
			where.append(" AND t2.EHTIPOMEDIACION IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhorigenalegacion() != null) {
			where.append(" AND UPPER(t2.EHORIGENALEGACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhorigenalegacion().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhorigenalegacion().toUpperCase() + "%");
			}
			where.append(" AND t2.EHORIGENALEGACION IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhasuntocomunicacion() != null) {
			where.append(" AND UPPER(t2.EHASUNTOCOMUNICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhasuntocomunicacion().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhasuntocomunicacion().toUpperCase() + "%");
			}
			where.append(" AND t2.EHASUNTOCOMUNICACION IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhcodrem() != null) {
			where.append(" AND UPPER(t2.EHCODREM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhcodrem().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhcodrem().toUpperCase() + "%");
			}
			where.append(" AND t2.EHCODREM IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhenvrem() != null) {
			where.append(" AND UPPER(t2.EHENVREM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhenvrem().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhenvrem().toUpperCase() + "%");
			}
			where.append(" AND t2.EHENVREM IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhcotee() != null) {
			where.append(" AND UPPER(t1.EHCOTEE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhcotee().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhcotee().toUpperCase() + "%");
			}
			where.append(" AND t1.EHCOTEE IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhfecha() != null) {
			where.append(" AND t1.EHFECHA = ?");
			params.add(tramitehecho.getEhfecha());
		}
		if (tramitehecho != null && tramitehecho.getEhhora() != null) {
			where.append(" AND UPPER(t1.EHHORA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhhora().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhhora().toUpperCase() + "%");
			}
			where.append(" AND t1.EHHORA IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhcodpor() != null) {
			where.append(" AND UPPER(t1.EHCODPOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhcodpor().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhcodpor().toUpperCase() + "%");
			}
			where.append(" AND t1.EHCODPOR IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhcodpde() != null) {
			where.append(" AND UPPER(t1.EHCODPDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhcodpde().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhcodpde().toUpperCase() + "%");
			}
			where.append(" AND t1.EHCODPDE IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhtexto() != null) {
			where.append(" AND UPPER(t1.EHTEXTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhtexto().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhtexto().toUpperCase() + "%");
			}
			where.append(" AND t1.EHTEXTO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhcohd() != null) {
			where.append(" AND UPPER(t1.EHCOHD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhcohd().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhcohd().toUpperCase() + "%");
			}
			where.append(" AND t1.EHCOHD IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhcozs() != null) {
			where.append(" AND UPPER(t1.EHCOZS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhcozs().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhcozs().toUpperCase() + "%");
			}
			where.append(" AND t1.EHCOZS IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhcomo() != null) {
			where.append(" AND UPPER(t1.EHCOMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhcomo().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhcomo().toUpperCase() + "%");
			}
			where.append(" AND t1.EHCOMO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhcivihe() != null) {
			where.append(" AND t1.EHCIVIHE = ?");
			params.add(tramitehecho.getEhcivihe());
		}
		if (tramitehecho != null && tramitehecho.getEhcoeh() != null) {
			where.append(" AND UPPER(t1.EHCOEH) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhcoeh().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhcoeh().toUpperCase() + "%");
			}
			where.append(" AND t1.EHCOEH IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhacuse() != null) {
			where.append(" AND t1.EHACUSE = ?");
			params.add(tramitehecho.getEhacuse());
		}
		if (tramitehecho != null && tramitehecho.getEhenviomail() != null) {
			where.append(" AND UPPER(t1.EHENVIOMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhenviomail().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhenviomail().toUpperCase() + "%");
			}
			where.append(" AND t1.EHENVIOMAIL IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhdiremail() != null) {
			where.append(" AND UPPER(t1.EHDIREMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhdiremail().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhdiremail().toUpperCase() + "%");
			}
			where.append(" AND t1.EHDIREMAIL IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhcoortraspaso() != null) {
			where.append(" AND UPPER(t1.EHCOORTRASPASO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhcoortraspaso().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhcoortraspaso().toUpperCase() + "%");
			}
			where.append(" AND t1.EHCOORTRASPASO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhcoactua() != null) {
			where.append(" AND UPPER(t1.EHCOACTUA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhcoactua().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhcoactua().toUpperCase() + "%");
			}
			where.append(" AND t1.EHCOACTUA IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhfechainicio() != null) {
			where.append(" AND t1.EHFECHAINICIO = ?");
			params.add(tramitehecho.getEhfechainicio());
		}
		if (tramitehecho != null && tramitehecho.getEhfechafin() != null) {
			where.append(" AND t1.EHFECHAFIN = ?");
			params.add(tramitehecho.getEhfechafin());
		}
		if (tramitehecho != null && tramitehecho.getEhcomoejecucion() != null) {
			where.append(" AND UPPER(t1.EHCOMOEJECUCION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhcomoejecucion().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhcomoejecucion().toUpperCase() + "%");
			}
			where.append(" AND t1.EHCOMOEJECUCION IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhcosc() != null) {
			where.append(" AND UPPER(t1.EHCOSC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhcosc().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhcosc().toUpperCase() + "%");
			}
			where.append(" AND t1.EHCOSC IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhrespuesta() != null) {
			where.append(" AND UPPER(t1.EHRESPUESTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhrespuesta().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhrespuesta().toUpperCase() + "%");
			}
			where.append(" AND t1.EHRESPUESTA IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhfechamediacion() != null) {
			where.append(" AND t1.EHFECHAMEDIACION = ?");
			params.add(tramitehecho.getEhfechamediacion());
		}
		if (tramitehecho != null && tramitehecho.getEhhoramediacion() != null) {
			where.append(" AND UPPER(t1.EHHORAMEDIACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhhoramediacion().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhhoramediacion().toUpperCase() + "%");
			}
			where.append(" AND t1.EHHORAMEDIACION IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhfechaenvioconvocatoria() != null) {
			where.append(" AND t1.EHFECHAENVIOCONVOCATORIA = ?");
			params.add(tramitehecho.getEhfechaenvioconvocatoria());
		}
		if (tramitehecho != null && tramitehecho.getEhfecharealizacion() != null) {
			where.append(" AND t1.EHFECHAREALIZACION = ?");
			params.add(tramitehecho.getEhfecharealizacion());
		}
		if (tramitehecho != null && tramitehecho.getEhhorarealizacion() != null) {
			where.append(" AND UPPER(t1.EHHORAREALIZACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhhorarealizacion().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhhorarealizacion().toUpperCase() + "%");
			}
			where.append(" AND t1.EHHORAREALIZACION IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhfechaconciliacion() != null) {
			where.append(" AND t1.EHFECHACONCILIACION = ?");
			params.add(tramitehecho.getEhfechaconciliacion());
		}
		if (tramitehecho != null && tramitehecho.getEhfechafirmaacuerdo() != null) {
			where.append(" AND t1.EHFECHAFIRMAACUERDO = ?");
			params.add(tramitehecho.getEhfechafirmaacuerdo());
		}
		if (tramitehecho != null && tramitehecho.getEhplazoinspeccion() != null) {
			where.append(" AND t1.EHPLAZOINSPECCION = ?");
			params.add(tramitehecho.getEhplazoinspeccion());
		}
		if (tramitehecho != null && tramitehecho.getIncodigo() != null) {
			where.append(" AND UPPER(t1.INCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getIncodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getIncodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.INCODIGO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhrespuestatraspaso() != null) {
			where.append(" AND UPPER(t1.EHRESPUESTATRASPASO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhrespuestatraspaso().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhrespuestatraspaso().toUpperCase() + "%");
			}
			where.append(" AND t1.EHRESPUESTATRASPASO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhdecodigo() != null) {
			where.append(" AND UPPER(t1.EHDECODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhdecodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhdecodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.EHDECODIGO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhfecharesolucion() != null) {
			where.append(" AND t1.EHFECHARESOLUCION = ?");
			params.add(tramitehecho.getEhfecharesolucion());
		}
		if (tramitehecho != null && tramitehecho.getEhfecharecurso() != null) {
			where.append(" AND t1.EHFECHARECURSO = ?");
			params.add(tramitehecho.getEhfecharecurso());
		}
		if (tramitehecho != null && tramitehecho.getEhtiporecurso() != null) {
			where.append(" AND t1.EHTIPORECURSO = ?");
			params.add(tramitehecho.getEhtiporecurso());
		}
		if (tramitehecho != null && tramitehecho.getEhabogado() != null) {
			where.append(" AND UPPER(t1.EHABOGADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhabogado().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhabogado().toUpperCase() + "%");
			}
			where.append(" AND t1.EHABOGADO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhestimacion() != null) {
			where.append(" AND UPPER(t1.EHESTIMACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhestimacion().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhestimacion().toUpperCase() + "%");
			}
			where.append(" AND t1.EHESTIMACION IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhfechacierre() != null) {
			where.append(" AND t1.EHFECHACIERRE = ?");
			params.add(tramitehecho.getEhfechacierre());
		}
		if (tramitehecho != null && tramitehecho.getEhdestinatario() != null) {
			where.append(" AND UPPER(t1.EHDESTINATARIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhdestinatario().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhdestinatario().toUpperCase() + "%");
			}
			where.append(" AND t1.EHDESTINATARIO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhfechacomunicacion() != null) {
			where.append(" AND t1.EHFECHACOMUNICACION = ?");
			params.add(tramitehecho.getEhfechacomunicacion());
		}
		if (tramitehecho != null && tramitehecho.getEhtipocomunicacion() != null) {
			where.append(" AND UPPER(t1.EHTIPOCOMUNICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhtipocomunicacion().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhtipocomunicacion().toUpperCase() + "%");
			}
			where.append(" AND t1.EHTIPOCOMUNICACION IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhtiponotificacion() != null) {
			where.append(" AND UPPER(t1.EHTIPONOTIFICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhtiponotificacion().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhtiponotificacion().toUpperCase() + "%");
			}
			where.append(" AND t1.EHTIPONOTIFICACION IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhnumregistrosalida() != null) {
			where.append(" AND UPPER(t1.EHNUMREGISTROSALIDA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhnumregistrosalida().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhnumregistrosalida().toUpperCase() + "%");
			}
			where.append(" AND t1.EHNUMREGISTROSALIDA IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhacuserecibo() != null) {
			where.append(" AND t1.EHACUSERECIBO = ?");
			params.add(tramitehecho.getEhacuserecibo());
		}
		if (tramitehecho != null && tramitehecho.getEhacusereciborecibido() != null) {
			where.append(" AND UPPER(t1.EHACUSERECIBORECIBIDO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhacusereciborecibido().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhacusereciborecibido().toUpperCase() + "%");
			}
			where.append(" AND t1.EHACUSERECIBORECIBIDO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhnumregistroentrada() != null) {
			where.append(" AND UPPER(t1.EHNUMREGISTROENTRADA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhnumregistroentrada().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhnumregistroentrada().toUpperCase() + "%");
			}
			where.append(" AND t1.EHNUMREGISTROENTRADA IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhidnotificacionplatea() != null) {
			where.append(" AND UPPER(t1.EHIDNOTIFICACIONPLATEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhidnotificacionplatea().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhidnotificacionplatea().toUpperCase() + "%");
			}
			where.append(" AND t1.EHIDNOTIFICACIONPLATEA IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhnombretramite() != null) {
			where.append(" AND UPPER(t1.EHNOMBRETRAMITE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhnombretramite().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhnombretramite().toUpperCase() + "%");
			}
			where.append(" AND t1.EHNOMBRETRAMITE IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhnrtel1() != null) {
			where.append(" AND UPPER(t1.EHNRTEL1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhnrtel1().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhnrtel1().toUpperCase() + "%");
			}
			where.append(" AND t1.EHNRTEL1 IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhnrtel2() != null) {
			where.append(" AND UPPER(t1.EHNRTEL2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhnrtel2().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhnrtel2().toUpperCase() + "%");
			}
			where.append(" AND t1.EHNRTEL2 IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhnrtel3() != null) {
			where.append(" AND UPPER(t1.EHNRTEL3) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhnrtel3().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhnrtel3().toUpperCase() + "%");
			}
			where.append(" AND t1.EHNRTEL3 IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhiddestinatario() != null) {
			where.append(" AND UPPER(t1.EHIDDESTINATARIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhiddestinatario().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhiddestinatario().toUpperCase() + "%");
			}
			where.append(" AND t1.EHIDDESTINATARIO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhcomoasignado() != null) {
			where.append(" AND UPPER(t1.EHCOMOASIGNADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhcomoasignado().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhcomoasignado().toUpperCase() + "%");
			}
			where.append(" AND t1.EHCOMOASIGNADO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhfecharegistrosalida() != null) {
			where.append(" AND t1.EHFECHAREGISTROSALIDA = ?");
			params.add(tramitehecho.getEhfecharegistrosalida());
		}
		if (tramitehecho != null && tramitehecho.getEhfecharegistroentrada() != null) {
			where.append(" AND t1.EHFECHAREGISTROENTRADA = ?");
			params.add(tramitehecho.getEhfecharegistroentrada());
		}
		if (tramitehecho != null && tramitehecho.getEhestadotramite() != null) {
			where.append(" AND UPPER(t1.EHESTADOTRAMITE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhestadotramite().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhestadotramite().toUpperCase() + "%");
			}
			where.append(" AND t1.EHESTADOTRAMITE IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhfechapublicacionbopv() != null) {
			where.append(" AND t1.EHFECHAPUBLICACIONBOPV = ?");
			params.add(tramitehecho.getEhfechapublicacionbopv());
		}
		if (tramitehecho != null && tramitehecho.getEhfechapublicacionayto() != null) {
			where.append(" AND t1.EHFECHAPUBLICACIONAYTO = ?");
			params.add(tramitehecho.getEhfechapublicacionayto());
		}
		if (tramitehecho != null && tramitehecho.getEhtipomediacion() != null) {
			where.append(" AND UPPER(t1.EHTIPOMEDIACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhtipomediacion().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhtipomediacion().toUpperCase() + "%");
			}
			where.append(" AND t1.EHTIPOMEDIACION IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhorigenalegacion() != null) {
			where.append(" AND UPPER(t1.EHORIGENALEGACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhorigenalegacion().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhorigenalegacion().toUpperCase() + "%");
			}
			where.append(" AND t1.EHORIGENALEGACION IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhasuntocomunicacion() != null) {
			where.append(" AND UPPER(t1.EHASUNTOCOMUNICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhasuntocomunicacion().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhasuntocomunicacion().toUpperCase() + "%");
			}
			where.append(" AND t1.EHASUNTOCOMUNICACION IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhcodrem() != null) {
			where.append(" AND UPPER(t1.EHCODREM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhcodrem().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhcodrem().toUpperCase() + "%");
			}
			where.append(" AND t1.EHCODREM IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhenvrem() != null) {
			where.append(" AND UPPER(t1.EHENVREM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getEhenvrem().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getEhenvrem().toUpperCase() + "%");
			}
			where.append(" AND t1.EHENVREM IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhtiponotificacionplatea() != null) {
			where.append(" AND UPPER(t2.EHTIPONOTIFICACIONPLATEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhtiponotificacionplatea().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhtiponotificacionplatea().toUpperCase() + "%");
			}
			where.append(" AND t2.EHTIPONOTIFICACIONPLATEA IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhidesperaplatea() != null) {
			where.append(" AND UPPER(t2.EHIDESPERAPLATEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhidesperaplatea().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhidesperaplatea().toUpperCase() + "%");
			}
			where.append(" AND t2.EHIDESPERAPLATEA IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
				&& tramitehecho.getTramiteHecho().getEhmatarespera() != null) {
			where.append(" AND UPPER(t2.EHMATARESPERA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhmatarespera().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhmatarespera().toUpperCase() + "%");
			}
			where.append(" AND t2.EHMATARESPERA IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhhoramediacioninicio() != null
				&& tramitehecho.getTramiteHecho().getEhhoramediacioninicio() != null) {
			where.append(" AND UPPER(t2.EHHORAMEDIACIONINICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhhoramediacioninicio().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhhoramediacioninicio().toUpperCase() + "%");
			}
			where.append(" AND t2.EHHORAMEDIACIONINICIO IS NOT NULL");
		}
		if (tramitehecho != null && tramitehecho.getEhhoramediacionfin() != null
				&& tramitehecho.getTramiteHecho().getEhhoramediacionfin() != null) {
			where.append(" AND UPPER(t2.EHHORAMEDIACIONFIN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramitehecho.getTramiteHecho().getEhhoramediacionfin().toUpperCase() + "%");
			} else {
				params.add("%" + tramitehecho.getTramiteHecho().getEhhoramediacionfin().toUpperCase() + "%");
			}
			where.append(" AND t2.EHHORAMEDIACIONFIN IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Finds a List of rows in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TramiteHechoDetalle> findAllTramiteHecho(TramiteHechoDetalle tramiteHechoDetalle,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.EHCOTEE= t2.TRCODIGO(+) AND t1.EHCOMO= t3ASIGNADO.MOCODIGO(+) AND t1.EHCOMOEJECUCION= t3EJECUCION.MOCODIGO(+) AND t1.EHCOHD= t4.HDCODIGO(+) AND t2.FCODIGO = t5.FCODIGO(+) AND t1.EHFCODIGO = t6.FCODIGO(+)	AND t1.EHCODIGORELACIONADO = t7.EHCODIGO(+) AND t1.EHDECODIGO= t8.DECODIGO(+) AND t1.EHIDDESTINATARIO=t9.IDINTERVINIENTE(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT t1.EHCODIGO EHCODIGO, t1.EHISTELEMATICO EHISTELEMATICO, t1.EHISSIR EHISSIR, t1.EHISSIRCONNUMREGENTORI EHISSIRCONNUMREGENTORI,t1.EHISWEBSINCERTIFICADO EHISWEBSINCERTIFICADO, t4.HDCODIGO HDCODIGO, DECODE(t6.FCODIGO,null,t5.FCODIGO,t6.FCODIGO)  FCODIGO, DECODE(t6.FNOMBRE,null,t5.FNOMBRE,t6.FNOMBRE) FNOMBRE, DECODE(t6.FNOMBREE,null,t5.FNOMBREE,t6.FNOMBREE) FNOMBREE, t1.EHCOTEE TRCODIGO, DECODE(t2.TRCODIGO, 'K25',t1.EHNOMBRETRAMITE,t2.TRNOMBRE) TRNOMBRE, DECODE(t2.TRCODIGO, 'K25',t1.EHNOMBRETRAMITE,t2.TRNOMBREE) TRNOMBREE, DECODE(t1.EHFECHAINICIO,null,t1.EHFECHA,t1.EHFECHAINICIO) EHFECHAINICIO, DECODE(t1.EHFECHAINICIO,null,t1.EHFECHA,t1.EHFECHAFIN) EHFECHAFIN, t1.EHFECHA EHFECHA, t1.EHHORA EHHORA, DECODE(t3EJECUCION.MOCODIGO,null,t3ASIGNADO.MOCODIGO,t3EJECUCION.MOCODIGO) MOCODIGO,DECODE(t3EJECUCION.MONOMBRE,null,t3ASIGNADO.MONOMBRE,t3EJECUCION.MONOMBRE) MONOMBRE, DECODE(t1.EHFECHAINICIO,null,'T',t1.EHESTADOTRAMITE) EHESTADOTRAMITE, t1.EHACUSERECIBORECIBIDO EHACUSERECIBORECIBIDO, t1.EHFECHAENVIOBOPVBOE EHFECHAENVIOBOPVBOE, t7.ENVCDES_SIT_CORREOS_ES ENVCDESSITCORREOSES, t7.ENVCDES_SIT_CORREOS_EU ENVCDESSITCORREOSEU, t1.EHPROCEEDINGSIDPLATEA EHPROCEEDINGSIDPLATEA, t8.DECODIGO DECODIGO, t8.DENOMBRE DENOMBRE, t8.DENOMBREE DENOMBREE, DECODE(t1.EHORIGENALEGACION,null,t1.EHDESTINATARIO,t1.EHORIGENALEGACION) ORIGENDESTINO, t1.EHIDDESTINATARIO, t1.EHACUSEREINTENTADO EHACUSEREINTENTADO, t9.NOMBRE || ' ' || t9.APELLIDO1 || ' ' || t9.APELLIDO2 NOMDESTINATARIO, t9.TIPO_INTERVINIENTE TIPOINTERVINIENTE "
						+ "FROM TRAMITE_HECHO t1 ,TRAMITE t2 ,CENSO_MONITOR t3ASIGNADO,CENSO_MONITOR t3EJECUCION ,HECHO_DENUNCIADO t4, FASE t5, FASE t6, ENVIOS_POR_REMESA t7, DECISION t8, INTERVINIENTES t9  ");

		if (tramiteHechoDetalle != null && tramiteHechoDetalle.getHdcodigo() != null) {
			where.append(" AND t4.HDCODIGO = ?");
			params.add(tramiteHechoDetalle.getHdcodigo());
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<TramiteHechoDetalle>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<TramiteHechoDetalle>() {
					public TramiteHechoDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new TramiteHechoDetalle(resultSet.getString("EHCODIGO"), resultSet.getString("HDCODIGO"),
								resultSet.getString("FCODIGO"), resultSet.getString("FNOMBRE"),
								resultSet.getString("FNOMBREE"), resultSet.getString("TRCODIGO"),
								resultSet.getString("TRNOMBRE"), resultSet.getString("TRNOMBREE"),
								resultSet.getTimestamp("EHFECHAINICIO"), resultSet.getTimestamp("EHFECHAFIN"),
								resultSet.getDate("EHFECHA"), resultSet.getString("EHHORA"), null, null, null,
								resultSet.getString("MOCODIGO"), resultSet.getString("MONOMBRE"),
								resultSet.getString("EHESTADOTRAMITE"), null, null, null, null, null, null, null,
								resultSet.getString("EHACUSERECIBORECIBIDO"), resultSet.getDate("EHFECHAENVIOBOPVBOE"),
								resultSet.getString("ENVCDESSITCORREOSES"), resultSet.getString("ENVCDESSITCORREOSEU"),
								null, resultSet.getString("EHPROCEEDINGSIDPLATEA"), resultSet.getString("DECODIGO"),
								resultSet.getString("DENOMBRE"), resultSet.getString("DENOMBREE"),
								resultSet.getString("ORIGENDESTINO"), resultSet.getString("NOMDESTINATARIO"),
								resultSet.getString("TIPOINTERVINIENTE"), resultSet.getString("EHACUSEREINTENTADO"),
								resultSet.getString("EHISTELEMATICO"), resultSet.getString("EHISSIR"),
								resultSet.getString("EHISSIRCONNUMREGENTORI"),
								resultSet.getString("EHISWEBSINCERTIFICADO"));
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTramiteHechoCount(TramiteHechoDetalle tramiteHechoDetalle) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.EHCOTEE= t2.TRCODIGO(+) AND t1.EHCOMO= t3ASIGNADO.MOCODIGO(+) AND t1.EHCOMOEJECUCION= t3EJECUCION.MOCODIGO(+) AND t1.EHCOHD= t4.HDCODIGO(+) AND t2.FCODIGO = t5.FCODIGO(+) AND t1.EHFCODIGO = t6.FCODIGO(+) AND t1.EHCODIGORELACIONADO = t7.EHCODIGO(+)  AND t1.EHDECODIGO= t8.DECODIGO(+) AND t1.EHIDDESTINATARIO=t9.IDINTERVINIENTE(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM TRAMITE_HECHO t1 ,TRAMITE t2 ,CENSO_MONITOR t3ASIGNADO,CENSO_MONITOR t3EJECUCION ,HECHO_DENUNCIADO t4, FASE t5, FASE t6, ENVIOS_POR_REMESA t7, DECISION t8, INTERVINIENTES t9 ");

		if (tramiteHechoDetalle != null && tramiteHechoDetalle.getHdcodigo() != null) {
			where.append(" AND t4.HDCODIGO = ?");
			params.add(tramiteHechoDetalle.getHdcodigo());
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a List of rows in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TramiteHechoDetalle> findAllTramiteHechoPendientes(TramiteHechoDetalle tramiteHechoDetalle,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.EHCOTEE= t2.TRCODIGO(+) AND t1.EHCOMOASIGNADO= t3ASIGNADO.MOCODIGO(+) AND t1.EHCOMOEJECUCION= t3EJECUCION.MOCODIGO(+) AND t1.EHCOHD= t4.HDCODIGO(+) AND t2.FCODIGO = t5.FCODIGO(+)	");

		StringBuffer query = new StringBuffer(
				"SELECT t1.EHCODIGO EHCODIGO, t1.EHISTELEMATICO EHISTELEMATICO,t1.EHISWEBSINCERTIFICADO EHISWEBSINCERTIFICADO, t4.HDCODIGO HDCODIGO, t5.FCODIGO FCODIGO, t5.FNOMBRE FNOMBRE, t5.FNOMBREE FNOMBREE, t2.TRCODIGO TRCODIGO, DECODE(t2.TRCODIGO, 'K25',t1.EHNOMBRETRAMITE,t2.TRNOMBRE) TRNOMBRE, DECODE(t2.TRCODIGO, 'K25',t1.EHNOMBRETRAMITE,t2.TRNOMBREE) TRNOMBREE, DECODE(t1.EHFECHAINICIO,null,t1.EHFECHA,t1.EHFECHAINICIO) EHFECHAINICIO, DECODE(t1.EHFECHAINICIO,null,t1.EHFECHA,t1.EHFECHAFIN) EHFECHAFIN, t1.EHFECHA EHFECHA, t1.EHHORA EHHORA, DECODE(t3EJECUCION.MOCODIGO,null,t3ASIGNADO.MOCODIGO,t3EJECUCION.MOCODIGO) MOCODIGO,DECODE(t3EJECUCION.MONOMBRE,null,t3ASIGNADO.MONOMBRE,t3EJECUCION.MONOMBRE) MONOMBRE, DECODE(t1.EHFECHAINICIO,null,'T',t1.EHESTADOTRAMITE) EHESTADOTRAMITE "
						+ "FROM TRAMITE_HECHO t1 ,TRAMITE t2 ,CENSO_MONITOR t3ASIGNADO,CENSO_MONITOR t3EJECUCION ,HECHO_DENUNCIADO t4, FASE t5 ");

		if (tramiteHechoDetalle != null && tramiteHechoDetalle.getHdcodigo() != null) {
			where.append(" AND t4.HDCODIGO = ?");
			params.add(tramiteHechoDetalle.getHdcodigo());
		}

		where.append(" AND t1.EHFECHAINICIO IS NOT NULL AND t1.EHFECHAFIN IS NULL ");

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<TramiteHechoDetalle>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<TramiteHechoDetalle>() {
					public TramiteHechoDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new TramiteHechoDetalle(resultSet.getString("EHCODIGO"), resultSet.getString("HDCODIGO"),
								resultSet.getString("FCODIGO"), resultSet.getString("FNOMBRE"),
								resultSet.getString("FNOMBREE"), resultSet.getString("TRCODIGO"),
								resultSet.getString("TRNOMBRE"), resultSet.getString("TRNOMBREE"),
								resultSet.getDate("EHFECHAINICIO"), resultSet.getDate("EHFECHAFIN"),
								resultSet.getDate("EHFECHA"), resultSet.getString("EHHORA"), null, null, null,
								resultSet.getString("MOCODIGO"), resultSet.getString("MONOMBRE"),
								resultSet.getString("EHESTADOTRAMITE"), null, null, null, null, null, null, null, null,
								null, null, null, null, null, null, null, null, null, null, null, null,
								resultSet.getString("EHISTELEMATICO"), null, null,
								resultSet.getString("EHISWEBSINCERTIFICADO"));
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTramiteHechoPendientesCount(TramiteHechoDetalle tramiteHechoDetalle) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.EHCOTEE= t2.TRCODIGO(+) AND t1.EHCOMOASIGNADO= t3ASIGNADO.MOCODIGO(+) AND t1.EHCOMOEJECUCION= t3EJECUCION.MOCODIGO(+) AND t1.EHCOHD= t4.HDCODIGO(+) AND t2.FCODIGO = t5.FCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM TRAMITE_HECHO t1 ,TRAMITE t2 ,CENSO_MONITOR t3ASIGNADO,CENSO_MONITOR t3EJECUCION ,HECHO_DENUNCIADO t4, FASE t5 ");

		if (tramiteHechoDetalle != null && tramiteHechoDetalle.getHdcodigo() != null) {
			where.append(" AND t4.HDCODIGO = ?");
			params.add(tramiteHechoDetalle.getHdcodigo());
		}

		where.append(" AND t1.EHFECHAINICIO IS NOT NULL AND t1.EHFECHAFIN IS NULL ");

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTramiteDecisionPropuestaSancionCount(TramiteHechoDetalle tramiteHechoDetalle) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.EHCOTEE= t2.TRCODIGO(+) AND t1.EHCOMOASIGNADO= t3ASIGNADO.MOCODIGO(+) AND t1.EHCOMOEJECUCION= t3EJECUCION.MOCODIGO(+) AND t1.EHCOHD= t4.HDCODIGO(+) AND t2.FCODIGO = t5.FCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM TRAMITE_HECHO t1 ,TRAMITE t2 ,CENSO_MONITOR t3ASIGNADO,CENSO_MONITOR t3EJECUCION ,HECHO_DENUNCIADO t4, FASE t5 ");

		where.append(" AND t4.HDCODIGO = ?");
		params.add(tramiteHechoDetalle.getHdcodigo());

		where.append(" AND t1.EHCOTEE = ?");
		params.add(Y41bConstantes.TRAMITE_REGISTRO_DECISION);

		where.append(" AND (t1.EHDECODIGO = ? ");
		params.add(Y41bConstantes.DECISION_PROPUESTA_SAN_DENUNCIA);

		where.append(" OR t1.EHDECODIGO = ? ");
		params.add(Y41bConstantes.DECISION_PROPUESTA_SAN_QUEJA);

		where.append(" OR t1.EHDECODIGO = ?) ");
		params.add(Y41bConstantes.DECISION_PROPUESTA_SAN_RECLAMACION);

		where.append(" AND t1.EHFECHAFIN IS NOT NULL ");

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTramiteAsignacionInstructorTramitadoCount(TramiteHechoDetalle tramiteHechoDetalle) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.EHCOTEE= t2.TRCODIGO(+) AND t1.EHCOMOASIGNADO= t3ASIGNADO.MOCODIGO(+) AND t1.EHCOMOEJECUCION= t3EJECUCION.MOCODIGO(+) AND t1.EHCOHD= t4.HDCODIGO(+) AND t2.FCODIGO = t5.FCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM TRAMITE_HECHO t1 ,TRAMITE t2 ,CENSO_MONITOR t3ASIGNADO,CENSO_MONITOR t3EJECUCION ,HECHO_DENUNCIADO t4, FASE t5 ");

		where.append(" AND t4.HDCODIGO = ?");
		params.add(tramiteHechoDetalle.getHdcodigo());

		where.append(" AND t1.EHCOTEE = ?");
		params.add(Y41bConstantes.TRAMITE_ASIGNACION_INSTRUCTOR);

		where.append(" AND t1.EHFECHAFIN IS NOT NULL ");

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllInicioTramitacionCount(TramiteHechoDetalle tramiteHechoDetalle) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.EHCOTEE= t2.TRCODIGO(+) AND t1.EHCOMOASIGNADO= t3ASIGNADO.MOCODIGO(+) AND t1.EHCOMOEJECUCION= t3EJECUCION.MOCODIGO(+) AND t1.EHCOHD= t4.HDCODIGO(+) AND t2.FCODIGO = t5.FCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM TRAMITE_HECHO t1 ,TRAMITE t2 ,CENSO_MONITOR t3ASIGNADO,CENSO_MONITOR t3EJECUCION ,HECHO_DENUNCIADO t4, FASE t5 ");

		where.append(" AND t4.HDCODIGO = ?");
		params.add(tramiteHechoDetalle.getHdcodigo());

		where.append(" AND t1.EHCOTEE != ?");
		params.add(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD);

		where.append(" AND t1.EHCOTEE != ?");
		params.add(Y41bConstantes.TRAMITE_ASIGNACION_INSTRUCTOR);

		where.append(" AND t1.EHCOTEE != ?");
		params.add(Y41bConstantes.TRAMITE_RECEPCION_TRASLADO);

		where.append(" AND t2.PCODIGO = ?");
		params.add(Y41bConstantes.TIPO_PROC_SOLICITUDES);

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTramiteRegistroSolicitudTramitadoCount(TramiteHechoDetalle tramiteHechoDetalle) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.EHCOTEE= t2.TRCODIGO(+) AND t1.EHCOMOASIGNADO= t3ASIGNADO.MOCODIGO(+) AND t1.EHCOMOEJECUCION= t3EJECUCION.MOCODIGO(+) AND t1.EHCOHD= t4.HDCODIGO(+) AND t2.FCODIGO = t5.FCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM TRAMITE_HECHO t1 ,TRAMITE t2 ,CENSO_MONITOR t3ASIGNADO,CENSO_MONITOR t3EJECUCION ,HECHO_DENUNCIADO t4, FASE t5 ");

		where.append(" AND t4.HDCODIGO = ?");
		params.add(tramiteHechoDetalle.getHdcodigo());

		where.append(" AND t1.EHCOTEE = ?");
		params.add(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD);

		where.append(" AND t1.EHFECHAFIN IS NOT NULL ");

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTramiteRegistroDecisionTramitadoCount(TramiteHechoDetalle tramiteHechoDetalle) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.EHCOTEE= t2.TRCODIGO(+) AND t1.EHCOMOASIGNADO= t3ASIGNADO.MOCODIGO(+) AND t1.EHCOMOEJECUCION= t3EJECUCION.MOCODIGO(+) AND t1.EHCOHD= t4.HDCODIGO(+) AND t2.FCODIGO = t5.FCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM TRAMITE_HECHO t1 ,TRAMITE t2 ,CENSO_MONITOR t3ASIGNADO,CENSO_MONITOR t3EJECUCION ,HECHO_DENUNCIADO t4, FASE t5 ");

		where.append(" AND t4.HDCODIGO = ?");
		params.add(tramiteHechoDetalle.getHdcodigo());

		where.append(" AND t1.EHCOTEE = ?");
		params.add(Y41bConstantes.TRAMITE_REGISTRO_DECISION);

		where.append(" AND t1.EHFECHAFIN IS NOT NULL ");

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTramiteRecepcionTrasladoTramitadoCount(TramiteHechoDetalle tramiteHechoDetalle) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.EHCOTEE= t2.TRCODIGO(+) AND t1.EHCOMOASIGNADO= t3ASIGNADO.MOCODIGO(+) AND t1.EHCOMOEJECUCION= t3EJECUCION.MOCODIGO(+) AND t1.EHCOHD= t4.HDCODIGO(+) AND t2.FCODIGO = t5.FCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM TRAMITE_HECHO t1 ,TRAMITE t2 ,CENSO_MONITOR t3ASIGNADO,CENSO_MONITOR t3EJECUCION ,HECHO_DENUNCIADO t4, FASE t5 ");

		where.append(" AND t4.HDCODIGO = ?");
		params.add(tramiteHechoDetalle.getHdcodigo());

		where.append(" AND t1.EHCOTEE = ?");
		params.add(Y41bConstantes.TRAMITE_RECEPCION_TRASLADO);

		where.append(" AND t1.EHFECHAFIN IS NOT NULL ");

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTramiteAsignacionInstructorSinTramitarCount(TramiteHechoDetalle tramiteHechoDetalle) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.EHCOTEE= t2.TRCODIGO(+) AND t1.EHCOMOASIGNADO= t3ASIGNADO.MOCODIGO(+) AND t1.EHCOMOEJECUCION= t3EJECUCION.MOCODIGO(+) AND t1.EHCOHD= t4.HDCODIGO(+) AND t2.FCODIGO = t5.FCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM TRAMITE_HECHO t1 ,TRAMITE t2 ,CENSO_MONITOR t3ASIGNADO,CENSO_MONITOR t3EJECUCION ,HECHO_DENUNCIADO t4, FASE t5 ");

		where.append(" AND t4.HDCODIGO = ?");
		params.add(tramiteHechoDetalle.getHdcodigo());

		where.append(" AND t1.EHCOTEE = ?");
		params.add(Y41bConstantes.TRAMITE_ASIGNACION_INSTRUCTOR);

		where.append(" AND t1.EHFECHAFIN IS NULL ");

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param plantillaTramiteHechoDetalle
	 *            PlantillaTramiteHechoDetalle
	 * @return PlantillaTramiteHechoDetalle
	 */
	@Transactional(readOnly = true)
	public PlantillaTramiteHechoDetalle findPlantillaTramiteHecho(
			PlantillaTramiteHechoDetalle plantillaTramiteHechoDetalle) {

		String query = "SELECT t1.DECODIGO DECODIGO, t1.DECOOR DECOOR, t1.DENRAN DENRAN, t1.DENROR DENROR, t1.DEFEDE DEFEDE,t1.DEFERE DEFERE, t2.HDCODIGO HDCODIGO, t2.HDNROR HDNROR, "
				+ "t3.ESCODIGO ESCODIGO, t3.NOMBRE ESNOMBRE, t3.NIF ESNIF, t3.ESNOCO ESNOCO, t3.INADAR ESINADAR, t3.NORA_PROVINCIA_ID ESNORAPROVINCIAID, "
				+ "t3.NOMBRE_PROVINCIA ESNOMBREPROVINCIA, t3.NORA_MUNICIPIO_ID ESNORAMUNICIPIOID, t3.NOMBRE_MUNICIPIO ESNOMBREMUNICIPIO, t3.NORA_LOCALIDAD_ID ESNORALOCALIDADID, "
				+ "t3.NOMBRE_LOCALIDAD ESNOMBRELOCALIDAD, t3.NORA_CALLE_ID ESNORACALLEID, t3.NOMBRE_CALLE ESNOMBRECALLE, t3.NORA_CP_ID ESNORACPID, t3.NOMBRE_CP ESNOMBRECP, "
				+ "t3.NORA_PORTAL_ID ESNORAPORTALID, t3.NOMBRE_PORTAL ESNOMBREPORTAL, t3.NOMBRE_PISO ESNOMBREPISO, '' ESNOLO, '' ESNODIR, '' ESNRCOPO, t3.DIRECCION_NOCAPV ESDIRECCION_NOCAPV, "
				+ "t3.NORA_PAIS_ID ESNORAPAISID, t3.NOMBRE_PAIS ESNOMBRE_PAIS, "
				+ "t3.NRTEL ESNRTEL, t3.NRTEL2 ESNRTEL2, t3.COEM ESCOEM, "
				+ "t4.DTCODIGO DTCODIGO, t4.NOMBRE || ' ' || NVL(t4.APELLIDO1,'') || ' ' || NVL(t4.APELLIDO2,'') DTNOMBRE, t4.NIF DTNIF, t4.NORA_PROVINCIA_ID DTNORAPROVINCIAID, "
				+ "t4.NOMBRE_PROVINCIA DTNOMBREPROVINCIA, t4.NORA_MUNICIPIO_ID DTNORAMUNICIPIOID, t4.NOMBRE_MUNICIPIO DTNOMBREMUNICIPIO, "
				+ "t4.NORA_LOCALIDAD_ID DTNORALOCALIDADID, t4.NOMBRE_LOCALIDAD DTNOMBRELOCALIDAD, t4.NORA_CALLE_ID DTNORACALLEID, t4.NOMBRE_CALLE DTNOMBRECALLE, "
				+ "t4.NORA_CP_ID DTNORACPID, t4.NOMBRE_CP DTNOMBRECP, t4.NORA_PORTAL_ID DTNORAPORTALID, t4.NOMBRE_PORTAL DTNOMBREPORTAL, t4.NOMBRE_PISO DTNOMBREPISO, '' DTNOLO, '' DTNODIR, '' DTNRCOPO, t4.DIRECCION_NOCAPV DTDIRECCION_NOCAPV, "
				+ "t4.NORA_PAIS_ID DTNORAPAISID, t4.NOMBRE_PAIS DTNOMBRE_PAIS, "
				+ "t4.NRTEL DTNRTEL, t4.NRTEL2 DTNRTEL2, t4.COEM DTTECOEM, "
				+ "t6.COD_ORG CODORG, t6.NOMBRE_ES NOMBREES, t6.NOMBRE_EU NOMBREEU,  t6.NORA_PROVINCIA_ID NORAPROVINCIAID, t6.NOMBRE_PROVINCIA NOMBREPROVINCIA, t6.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t6.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, "
				+ "t6.NORA_LOCALIDAD_ID NORALOCALIDADID, t6.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t6.NORA_CALLE_ID NORACALLEID, t6.NOMBRE_CALLE NOMBRECALLE, t6.NORA_CP_ID NORACPID, t6.NOMBRE_CP NOMBRECP, t6.NORA_PORTAL_ID NORAPORTALID, "
				+ "t6.NOMBRE_PORTAL NOMBREPORTAL, t6.TELEFONO TELEFONOORGANISMO, t6.FAX FAXORGANISMO, t6.EMAIL EMAILORGANISMO, t6.URL WEBORGANISMO, "
				+ "t7.MOCODIGO MOCODIGO, t7.MONOMBRE MONOMBRE,  t2.HDFEHD HDFEHD, t2.HDCAPTSO HDCAPTSO, t2.HDTESO HDTESO, t8.TSRNOMBRE TSRNOMBRE,t8.TSRNOMBREE TSRNOMBREE "
				+ "FROM DENUNCIA t1 ,HECHO_DENUNCIADO t2,INTERVINIENTES t3, INTERVINIENTES t4, DECISION_HECHO t5, ORGANISMO t6, CENSO_MONITOR t7, TIPO_RECLAMACION t8 "
				+ "WHERE 1=1 AND t1.DECODIGO= t2.HDCODE(+)  AND t2.HDCODIGO= t3.HDCODIGO(+) AND t3.TIPO_INTERVINIENTE(+)='D' "
				+ "AND t2.HDCODIGO= t4.HDCODIGO(+) AND t4.TIPO_INTERVINIENTE(+)='I' AND t2.HDCODIGO = t5.HCCOHD AND t5.HCCOOR= t6.COD_ORG AND t2.HDCOMO = t7.MOCODIGO(+) AND t2.HDCOTSR = t8.TSRCODIGO(+) AND t2.HDCODIGO = ? ";

		return (PlantillaTramiteHechoDetalle) this.jdbcTemplate.queryForObject(query,
				new RowMapper<PlantillaTramiteHechoDetalle>() {
					public PlantillaTramiteHechoDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {

						return new PlantillaTramiteHechoDetalle(resultSet.getString("DECODIGO"),
								resultSet.getString("DECOOR"), resultSet.getBigDecimal("DENRAN"),
								resultSet.getBigDecimal("DENROR"), resultSet.getString("HDCODIGO"),
								resultSet.getBigDecimal("HDNROR"), resultSet.getString("DTCODIGO"),
								resultSet.getString("DTNOMBRE"), resultSet.getString("DTNIF"),
								resultSet.getString("DTNORAPROVINCIAID"), resultSet.getString("DTNOMBREPROVINCIA"),
								resultSet.getString("DTNORAMUNICIPIOID"), resultSet.getString("DTNOMBREMUNICIPIO"),
								resultSet.getString("DTNORALOCALIDADID"), resultSet.getString("DTNOMBRELOCALIDAD"),
								resultSet.getString("DTNORACALLEID"), resultSet.getString("DTNOMBRECALLE"),
								resultSet.getString("DTNORACPID"), resultSet.getString("DTNOMBRECP"),
								resultSet.getString("DTNORAPORTALID"), resultSet.getString("DTNOMBREPORTAL"),
								resultSet.getString("DTNOMBREPISO"), resultSet.getString("DTNOLO"),
								resultSet.getString("DTNODIR"), resultSet.getString("DTNRCOPO"),
								resultSet.getString("DTDIRECCION_NOCAPV"), resultSet.getString("DTNORAPAISID"),
								resultSet.getString("DTNOMBRE_PAIS"), resultSet.getString("DTNRTEL"),
								resultSet.getString("DTNRTEL2"), resultSet.getString("DTTECOEM"),
								resultSet.getString("ESCODIGO"), resultSet.getString("ESNOMBRE"),
								resultSet.getString("ESNIF"), resultSet.getString("ESNOCO"),
								resultSet.getString("ESINADAR"), resultSet.getString("ESNORAPROVINCIAID"),
								resultSet.getString("ESNOMBREPROVINCIA"), resultSet.getString("ESNORAMUNICIPIOID"),
								resultSet.getString("ESNOMBREMUNICIPIO"), resultSet.getString("ESNORALOCALIDADID"),
								resultSet.getString("ESNOMBRELOCALIDAD"), resultSet.getString("ESNORACALLEID"),
								resultSet.getString("ESNOMBRECALLE"), resultSet.getString("ESNORACPID"),
								resultSet.getString("ESNOMBRECP"), resultSet.getString("ESNORAPORTALID"),
								resultSet.getString("ESNOMBREPORTAL"), resultSet.getString("ESNOMBREPISO"),
								resultSet.getString("ESNOLO"), resultSet.getString("ESNODIR"),
								resultSet.getString("ESNRCOPO"), resultSet.getString("ESDIRECCION_NOCAPV"),
								resultSet.getString("ESNORAPAISID"), resultSet.getString("ESNOMBRE_PAIS"),
								resultSet.getString("ESNRTEL"), resultSet.getString("ESNRTEL2"),
								resultSet.getString("ESCOEM"), resultSet.getString("CODORG"),
								resultSet.getString("NOMBREES"), resultSet.getString("NOMBREEU"),
								resultSet.getString("NORAPROVINCIAID"), resultSet.getString("NOMBREPROVINCIA"),
								resultSet.getString("NORAMUNICIPIOID"), resultSet.getString("NOMBREMUNICIPIO"),
								resultSet.getString("NORALOCALIDADID"), resultSet.getString("NOMBRELOCALIDAD"),
								resultSet.getString("NORACALLEID"), resultSet.getString("NOMBRECALLE"),
								resultSet.getString("NORACPID"), resultSet.getString("NOMBRECP"),
								resultSet.getString("NORAPORTALID"), resultSet.getString("NOMBREPORTAL"),
								resultSet.getString("TELEFONOORGANISMO"), resultSet.getString("FAXORGANISMO"),
								resultSet.getString("EMAILORGANISMO"), resultSet.getString("WEBORGANISMO"), null, null,
								null, null, null, null, null, null, null, null, null, null, null, null, null, null,
								null, resultSet.getDate("DEFEDE"), resultSet.getDate("DEFERE"),
								resultSet.getString("MOCODIGO"), resultSet.getString("MONOMBRE"),
								resultSet.getDate("HDFEHD"), resultSet.getBigDecimal("HDCAPTSO"),
								resultSet.getString("HDTESO"), resultSet.getString("TSRNOMBRE"),
								resultSet.getString("TSRNOMBREE"));
					}
				}, plantillaTramiteHechoDetalle.getHdcodigo());
	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TramiteHechoDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteHechoDetalle findUltimoTramiteHechoPorTipoTramite(TramiteHechoDetalle tramiteHechoDetalle) {
		try {
			String query = "SELECT tr1.EHCODIGO EHCODIGO, tr1.EHFECHA EHFECHA, tr1.EHFECHAINICIO, tr1.EHFECHAFIN, tr1.EHCOORTRASPASO, tr1.EHIDORGANISMOCOLABSOL, tr1.EHCOMODESIGNADO "
					+ "FROM TRAMITE_HECHO tr1 "
					+ "WHERE tr1.EHCOHD = ? AND tr1.EHCOTEE = ? AND EHFECHA = (SELECT MAX(EHFECHA) FROM TRAMITE_HECHO tr2 WHERE tr2.EHCOHD=? AND tr2.EHCOTEE=? ) AND NVL(EHHORA, 0) = (SELECT NVL(MAX(EHHORA), 0) FROM TRAMITE_HECHO tr3 WHERE tr1.EHFECHA = tr3.EHFECHA AND tr3.EHCOHD=? AND tr3.EHCOTEE=?) AND ROWNUM=1";
			return (TramiteHechoDetalle) this.jdbcTemplate.queryForObject(query, new RowMapper<TramiteHechoDetalle>() {
				public TramiteHechoDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
					return new TramiteHechoDetalle(resultSet.getString("EHCODIGO"), null, null, null, null, null, null,
							null, resultSet.getDate("EHFECHAINICIO"), resultSet.getDate("EHFECHAFIN"),
							resultSet.getDate("EHFECHA"), null, null, resultSet.getString("EHCOORTRASPASO"), null,
							resultSet.getString("EHCOMODESIGNADO"), null, null, null, null, null, null, null, null,
							null, null, null, null, null, resultSet.getString("EHIDORGANISMOCOLABSOL"), null, null,
							null, null, null, null, null, null, null, null, null, null);
				}
			}, tramiteHechoDetalle.getHdcodigo(), tramiteHechoDetalle.getTrcodigo(), tramiteHechoDetalle.getHdcodigo(),
					tramiteHechoDetalle.getTrcodigo(), tramiteHechoDetalle.getHdcodigo(),
					tramiteHechoDetalle.getTrcodigo());
		} catch (EmptyResultDataAccessException e) {
			return new TramiteHechoDetalle();
		}
	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TramiteHechoDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteHechoDetalle findUltimoTramiteHechoPorTipoTramiteTramitado(TramiteHechoDetalle tramiteHechoDetalle) {
		try {
			String query = "SELECT tr1.EHCODIGO EHCODIGO, tr1.EHFECHA EHFECHA, tr1.EHFECHAINICIO, tr1.EHFECHAFIN, tr1.EHCOORTRASPASO, tr1.EHIDORGANISMOCOLABSOL, tr1.EHCOMODESIGNADO "
					+ "FROM TRAMITE_HECHO tr1 "
					+ "WHERE tr1.EHCOHD=? AND tr1.EHCOTEE=? AND tr1.EHESTADOTRAMITE=? AND EHFECHA = (SELECT MAX(EHFECHA) FROM TRAMITE_HECHO tr2 WHERE tr2.EHCOHD=? AND tr2.EHCOTEE=? AND tr2.EHESTADOTRAMITE=?) AND NVL(EHHORA, 0) = (SELECT NVL(MAX(EHHORA), 0) FROM TRAMITE_HECHO tr3 WHERE tr1.EHFECHA = tr3.EHFECHA AND tr3.EHCOHD=? AND tr3.EHCOTEE=? AND tr3.EHESTADOTRAMITE=?) AND ROWNUM=1";
			return (TramiteHechoDetalle) this.jdbcTemplate.queryForObject(query, new RowMapper<TramiteHechoDetalle>() {
				public TramiteHechoDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
					return new TramiteHechoDetalle(resultSet.getString("EHCODIGO"), null, null, null, null, null, null,
							null, resultSet.getDate("EHFECHAINICIO"), resultSet.getDate("EHFECHAFIN"),
							resultSet.getDate("EHFECHA"), null, null, resultSet.getString("EHCOORTRASPASO"), null,
							resultSet.getString("EHCOMODESIGNADO"), null, null, null, null, null, null, null, null,
							null, null, null, null, null, resultSet.getString("EHIDORGANISMOCOLABSOL"), null, null,
							null, null, null, null, null, null, null, null, null, null);
				}
			}, tramiteHechoDetalle.getHdcodigo(), tramiteHechoDetalle.getTrcodigo(),
					Y41bConstantes.ESTADO_TRAMITE_TRAMITADO, tramiteHechoDetalle.getHdcodigo(),
					tramiteHechoDetalle.getTrcodigo(), Y41bConstantes.ESTADO_TRAMITE_TRAMITADO,
					tramiteHechoDetalle.getHdcodigo(), tramiteHechoDetalle.getTrcodigo(),
					Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} catch (EmptyResultDataAccessException e) {
			return new TramiteHechoDetalle();
		}
	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TramiteHechoDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteHechoDetalle findUltimoTramiteHechoPorTipoTramiteNoTramitado(
			TramiteHechoDetalle tramiteHechoDetalle) {
		try {
			String query = "SELECT tr1.EHCODIGO EHCODIGO, tr1.EHFECHA EHFECHA, tr1.EHFECHAINICIO, tr1.EHFECHAFIN, tr1.EHCOORTRASPASO, tr1.EHIDORGANISMOCOLABSOL, tr1.EHCOMODESIGNADO "
					+ "FROM TRAMITE_HECHO tr1 "
					+ "WHERE tr1.EHCOHD=? AND tr1.EHCOTEE=? AND tr1.EHESTADOTRAMITE!=? AND EHFECHA = (SELECT MAX(EHFECHA) FROM TRAMITE_HECHO tr2 WHERE tr2.EHCOHD=? AND tr2.EHCOTEE=? AND tr2.EHESTADOTRAMITE!=?) AND NVL(EHHORA, 0) = (SELECT NVL(MAX(EHHORA), 0) FROM TRAMITE_HECHO tr3 WHERE tr1.EHFECHA = tr3.EHFECHA AND tr3.EHCOHD=? AND tr3.EHCOTEE=? AND tr3.EHESTADOTRAMITE!=?) AND ROWNUM=1";
			return (TramiteHechoDetalle) this.jdbcTemplate.queryForObject(query, new RowMapper<TramiteHechoDetalle>() {
				public TramiteHechoDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
					return new TramiteHechoDetalle(resultSet.getString("EHCODIGO"), null, null, null, null, null, null,
							null, resultSet.getDate("EHFECHAINICIO"), resultSet.getDate("EHFECHAFIN"),
							resultSet.getDate("EHFECHA"), null, null, resultSet.getString("EHCOORTRASPASO"), null,
							resultSet.getString("EHCOMODESIGNADO"), null, null, null, null, null, null, null, null,
							null, null, null, null, null, resultSet.getString("EHIDORGANISMOCOLABSOL"), null, null,
							null, null, null, null, null, null, null, null, null, null);
				}
			}, tramiteHechoDetalle.getHdcodigo(), tramiteHechoDetalle.getTrcodigo(),
					Y41bConstantes.ESTADO_TRAMITE_TRAMITADO, tramiteHechoDetalle.getHdcodigo(),
					tramiteHechoDetalle.getTrcodigo(), Y41bConstantes.ESTADO_TRAMITE_TRAMITADO,
					tramiteHechoDetalle.getHdcodigo(), tramiteHechoDetalle.getTrcodigo(),
					Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} catch (EmptyResultDataAccessException e) {
			return new TramiteHechoDetalle();
		}
	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @param origen
	 *            String
	 * 
	 * @return TramiteHechoDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteHechoDetalle findUltimoTramiteHechoPorTipoTramiteYOrigen(TramiteHechoDetalle tramiteHechoDetalle,
			String origen) {
		try {
			String query = "SELECT tr1.EHCODIGO EHCODIGO, tr1.EHFECHA EHFECHA, tr1.EHCODIGORELACIONADO "
					+ "FROM TRAMITE_HECHO tr1 "
					+ "WHERE tr1.EHCOHD=? AND tr1.EHCOTEE=? AND tr1.EHORIGENALEGACION =? AND EHFECHA = (SELECT MAX(EHFECHA) FROM TRAMITE_HECHO tr2 WHERE tr2.EHCOHD=? AND tr2.EHCOTEE=? AND tr2.EHORIGENALEGACION =?) AND NVL(EHHORA, 0) = (SELECT NVL(MAX(EHHORA), 0) FROM TRAMITE_HECHO tr3 WHERE tr1.EHFECHA = tr3.EHFECHA AND tr3.EHCOHD=? AND tr3.EHCOTEE=? AND tr3.EHORIGENALEGACION =?)  AND ROWNUM=1 ";
			return (TramiteHechoDetalle) this.jdbcTemplate.queryForObject(query, new RowMapper<TramiteHechoDetalle>() {
				public TramiteHechoDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
					return new TramiteHechoDetalle(resultSet.getString("EHCODIGO"), null, null, null, null, null, null,
							null, null, null, resultSet.getDate("EHFECHA"), null, null, null,
							resultSet.getString("EHCODIGORELACIONADO"), null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null);
				}
			}, tramiteHechoDetalle.getHdcodigo(), tramiteHechoDetalle.getTrcodigo(), origen,
					tramiteHechoDetalle.getHdcodigo(), tramiteHechoDetalle.getTrcodigo(), origen,
					tramiteHechoDetalle.getHdcodigo(), tramiteHechoDetalle.getTrcodigo(), origen);
		} catch (EmptyResultDataAccessException e) {
			return new TramiteHechoDetalle();
		}
	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @param origen
	 *            String
	 * 
	 * @return TramiteHechoDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteHechoDetalle findUltimoTramiteHechoPorTipoTramiteYOrigenNoTramitado(
			TramiteHechoDetalle tramiteHechoDetalle, String origen) {
		try {
			String query = "SELECT tr1.EHCODIGO EHCODIGO, tr1.EHFECHA EHFECHA, tr1.EHCODIGORELACIONADO "
					+ "FROM TRAMITE_HECHO tr1 "
					+ "WHERE tr1.EHCOHD=? AND tr1.EHCOTEE=? AND tr1.EHORIGENALEGACION=? AND tr1.EHESTADOTRAMITE!=? AND EHFECHA = (SELECT MAX(EHFECHA) FROM TRAMITE_HECHO tr2 WHERE tr2.EHCOHD=? AND tr2.EHCOTEE=? AND tr2.EHORIGENALEGACION=? AND tr2.EHESTADOTRAMITE!=?) AND NVL(EHHORA, 0) = (SELECT NVL(MAX(EHHORA), 0) FROM TRAMITE_HECHO tr3 WHERE tr1.EHFECHA = tr3.EHFECHA AND tr3.EHCOHD=? AND tr3.EHCOTEE=? AND tr3.EHORIGENALEGACION =? AND tr3.EHESTADOTRAMITE!=?) AND ROWNUM=1 ";
			return (TramiteHechoDetalle) this.jdbcTemplate.queryForObject(query, new RowMapper<TramiteHechoDetalle>() {
				public TramiteHechoDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
					return new TramiteHechoDetalle(resultSet.getString("EHCODIGO"), null, null, null, null, null, null,
							null, null, null, resultSet.getDate("EHFECHA"), null, null, null,
							resultSet.getString("EHCODIGORELACIONADO"), null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null);
				}
			}, tramiteHechoDetalle.getHdcodigo(), tramiteHechoDetalle.getTrcodigo(), origen,
					Y41bConstantes.ESTADO_TRAMITE_TRAMITADO, tramiteHechoDetalle.getHdcodigo(),
					tramiteHechoDetalle.getTrcodigo(), origen, Y41bConstantes.ESTADO_TRAMITE_TRAMITADO,
					tramiteHechoDetalle.getHdcodigo(), tramiteHechoDetalle.getTrcodigo(), origen,
					Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} catch (EmptyResultDataAccessException e) {
			return new TramiteHechoDetalle();
		}
	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * 
	 * @return TramiteHechoDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteHechoDetalle findTramiteRelacionado(TramiteHechoDetalle tramiteHechoDetalle) {
		try {
			String query = "SELECT tr1.EHCODIGO EHCODIGO, tr1.EHFECHA EHFECHA " + "FROM TRAMITE_HECHO tr1 "
					+ "WHERE tr1.EHCOHD=? AND tr1.EHCOTEE=? AND tr1.EHCODIGORELACIONADO =?";
			return (TramiteHechoDetalle) this.jdbcTemplate.queryForObject(query, new RowMapper<TramiteHechoDetalle>() {
				public TramiteHechoDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
					return new TramiteHechoDetalle(resultSet.getString("EHCODIGO"), null, null, null, null, null, null,
							null, null, null, resultSet.getDate("EHFECHA"), null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null);
				}
			}, tramiteHechoDetalle.getHdcodigo(), tramiteHechoDetalle.getTrcodigo(), tramiteHechoDetalle.getEhcodigo());
		} catch (EmptyResultDataAccessException e) {
			return new TramiteHechoDetalle();
		}
	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TramiteHechoDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteHechoDetalle findUltimoTramiteHechoYFase(TramiteHechoDetalle tramiteHechoDetalle) {
		try {
			String query = "SELECT tr1.EHESTADOTRAMITE EHESTADOTRAMITE, tr2.FCODIGO FCODIGO, tr2.TRCODIGO TRCODIGO "
					+ "FROM TRAMITE_HECHO tr1, TRAMITE tr2 "
					+ "WHERE tr1.EHCOTEE = tr2.TRCODIGO AND tr1.EHCOHD=? AND EHFECHA = (SELECT MAX(EHFECHA) FROM TRAMITE_HECHO tr2 WHERE tr2.EHCOHD=? ) AND NVL(EHHORA, 0) = (SELECT NVL(MAX(EHHORA), 0) FROM TRAMITE_HECHO tr3 WHERE tr1.EHFECHA = tr3.EHFECHA AND tr3.EHCOHD=?) AND ROWNUM=1";
			return (TramiteHechoDetalle) this.jdbcTemplate.queryForObject(query, new RowMapper<TramiteHechoDetalle>() {
				public TramiteHechoDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
					return new TramiteHechoDetalle(null, null, resultSet.getString("FCODIGO"), null, null,
							resultSet.getString("TRCODIGO"), null, null, null, null, null, null, null, null, null, null,
							null, resultSet.getString("EHESTADOTRAMITE"), null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
							null, null);
				}
			}, tramiteHechoDetalle.getHdcodigo(), tramiteHechoDetalle.getHdcodigo(), tramiteHechoDetalle.getHdcodigo());
		} catch (EmptyResultDataAccessException e) {
			return new TramiteHechoDetalle();
		}
	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TramiteHechoDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteHechoDetalle findUltimoTramiteHechoYFaseNoGenerico(TramiteHechoDetalle tramiteHechoDetalle) {
		try {
			String query = "SELECT tr2.FCODIGO FCODIGO, tr2.TRCODIGO TRCODIGO " + "FROM TRAMITE_HECHO tr1, TRAMITE tr2 "
					+ "WHERE tr1.EHCOTEE = tr2.TRCODIGO AND tr2.FCODIGO IS NOT NULL AND tr1.EHCOHD=? AND EHFECHA = (SELECT MAX(EHFECHA) FROM TRAMITE_HECHO tr2, TRAMITE tr3 WHERE tr2.EHCOTEE = tr3.TRCODIGO AND tr3.FCODIGO IS NOT NULL AND tr2.EHCOHD=? ) AND NVL(EHHORA, 0) = (SELECT NVL(MAX(EHHORA), 0) FROM TRAMITE_HECHO tr3, TRAMITE tr4 WHERE tr3.EHCOTEE = tr4.TRCODIGO AND tr4.FCODIGO IS NOT NULL AND tr1.EHFECHA = tr3.EHFECHA AND tr3.EHCOHD=?) AND ROWNUM=1";
			return (TramiteHechoDetalle) this.jdbcTemplate.queryForObject(query, new RowMapper<TramiteHechoDetalle>() {
				public TramiteHechoDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
					return new TramiteHechoDetalle(null, null, resultSet.getString("FCODIGO"), null, null,
							resultSet.getString("TRCODIGO"), null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null);
				}
			}, tramiteHechoDetalle.getHdcodigo(), tramiteHechoDetalle.getHdcodigo(), tramiteHechoDetalle.getHdcodigo());
		} catch (EmptyResultDataAccessException e) {
			return new TramiteHechoDetalle();
		}
	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TramiteHechoDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteHechoDetalle findUltimoTramiteHechoYFaseNoGenericoNoCierre(TramiteHechoDetalle tramiteHechoDetalle) {
		try {
			String query = "SELECT tr2.FCODIGO FCODIGO, tr2.TRCODIGO TRCODIGO " + "FROM TRAMITE_HECHO tr1, TRAMITE tr2 "
					+ "WHERE tr1.EHCOTEE = tr2.TRCODIGO AND tr2.FCODIGO IS NOT NULL AND tr1.EHCOTEE!=? AND tr1.EHCOHD=? AND EHFECHA = (SELECT MAX(EHFECHA) FROM TRAMITE_HECHO tr2, TRAMITE tr3 WHERE tr2.EHCOTEE = tr3.TRCODIGO AND tr2.EHCOTEE!=? AND tr3.FCODIGO IS NOT NULL AND tr2.EHCOHD=? ) AND NVL(EHHORA, 0) = (SELECT NVL(MAX(EHHORA), 0) FROM TRAMITE_HECHO tr3, TRAMITE tr4 WHERE tr3.EHCOTEE = tr4.TRCODIGO AND tr3.EHCOTEE!=? AND tr4.FCODIGO IS NOT NULL AND tr1.EHFECHA = tr3.EHFECHA AND tr3.EHCOHD=?) AND ROWNUM=1";
			return (TramiteHechoDetalle) this.jdbcTemplate.queryForObject(query, new RowMapper<TramiteHechoDetalle>() {
				public TramiteHechoDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
					return new TramiteHechoDetalle(null, null, resultSet.getString("FCODIGO"), null, null,
							resultSet.getString("TRCODIGO"), null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null);
				}
			}, Y41bConstantes.TRAMITE_CIERRE_EXPEDIENTE, tramiteHechoDetalle.getHdcodigo(),
					Y41bConstantes.TRAMITE_CIERRE_EXPEDIENTE, tramiteHechoDetalle.getHdcodigo(),
					Y41bConstantes.TRAMITE_CIERRE_EXPEDIENTE, tramiteHechoDetalle.getHdcodigo());
		} catch (EmptyResultDataAccessException e) {
			return new TramiteHechoDetalle();
		}
	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TramiteHechoDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteHechoDetalle findUltimaFase(TramiteHechoDetalle tramiteHechoDetalle) {
		String query = "select FNOMBRE, FNOMBREE FROM(SELECT tr3.FNOMBRE FNOMBRE, tr3.FNOMBREE FNOMBREE FROM TRAMITE_HECHO tr1, TRAMITE tr2, FASE tr3 WHERE tr1.EHCOTEE = tr2.TRCODIGO AND tr2.FCODIGO = tr3.FCODIGO(+) AND tr2.FCODIGO IS NOT NULL AND tr1.EHCOHD=? AND EHFECHA <= (SELECT EHFECHA FROM TRAMITE_HECHO tr2 WHERE tr2.EHCODIGO=? ) AND EHHORA <= (SELECT EHHORA FROM TRAMITE_HECHO tr2 WHERE tr2.EHCODIGO=? ) ORDER BY EHFECHA DESC, EHHORA DESC) WHERE ROWNUM=1 ";
		// String query =
		// "SELECT FNOMBRE, FNOMBREE FROM (SELECT tr3.FNOMBRE FNOMBRE,
		// tr3.FNOMBREE FNOMBREE FROM TRAMITE_HECHO tr1, TRAMITE tr2, FASE tr3
		// WHERE tr1.EHCOTEE = tr2.TRCODIGO AND tr2.FCODIGO = tr3.FCODIGO(+) AND
		// tr2.FCODIGO IS NOT NULL AND tr1.EHCOHD = ? AND tr1.EHHORA <= (SELECT
		// EHHORA FROM TRAMITE_HECHO tr4 WHERE tr4.EHCODIGO=? AND tr4.EHFECHA =
		// (SELECT EHFECHA FROM TRAMITE_HECHO tr5 WHERE tr5.EHCODIGO=? )) ORDER
		// BY EHFECHA DESC, EHHORA DESC) WHERE ROWNUM=1 ";
		return (TramiteHechoDetalle) this.jdbcTemplate.queryForObject(query, new RowMapper<TramiteHechoDetalle>() {
			public TramiteHechoDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new TramiteHechoDetalle(null, null, null, resultSet.getString("FNOMBRE"),
						resultSet.getString("FNOMBREE"), null, null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null, null, null);
			}
		}, tramiteHechoDetalle.getHdcodigo(), tramiteHechoDetalle.getEhcodigo(), tramiteHechoDetalle.getEhcodigo());
	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	@Transactional(readOnly = true)
	public TramiteHecho findUltimoTramite(TramiteHecho tramitehecho) {
		String query = SELECT_TRAMITE_HECHO
				+ " FROM TRAMITE_HECHO t1 , TRAMITE_HECHO t2  WHERE t1.EHCODIGORELACIONADO= t2.EHCODIGO(+) AND t1.EHCOHD=? AND t1.EHFECHA = (SELECT MAX(EHFECHA) FROM TRAMITE_HECHO tr2 WHERE tr2.EHCOHD=? ) AND NVL(t1.EHHORA, 0) = (SELECT NVL(MAX(EHHORA), 0) FROM TRAMITE_HECHO tr3 WHERE t1.EHFECHA = tr3.EHFECHA AND tr3.EHCOHD=?) AND ROWNUM=1";

		List<TramiteHecho> tramitehechoList = this.jdbcTemplate.query(query, this.rwMap, tramitehecho.getEhcohd(),
				tramitehecho.getEhcohd(), tramitehecho.getEhcohd());
		return (TramiteHecho) DataAccessUtils.uniqueResult(tramitehechoList);
	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalleKnet
	 *            TramiteHechoDetalleKnet
	 * @return TramiteHechoDetalleKnet
	 */
	@Transactional(readOnly = true)
	public TramiteHechoDetalleKnet findTramiteHecho(TramiteHechoDetalleKnet tramiteHechoDetalleKnet) {
		String query = "SELECT  t1.EHCODIGO EHCODIGO,t1.EHFECHA EHFECHA,t1.EHHORA EHHORA,t1.EHCODPOR EHCODPOR,t1.EHCODPDE EHCODPDE, t1.EHCOZS EHCOZS,t1.EHCIVIHE EHCIVIHE,t1.EHACUSE EHACUSE,t1.EHENVIOMAIL EHENVIOMAIL,t1.EHDIREMAIL EHDIREMAIL, t1.EHCOTEE TRCODIGO,t2.TRNOMBRE TRNOMBRE,t2.TRNOMBREE TRNOMBREE,t2.TRBAJA TRBAJA, t3.MOCODIGO MOCODIGO,t3.MONOMBRE MONOMBRE,t3.MOCOOR MOCOOR, t3.MOCOEM MOCOEM, t4.HDCODIGO HDCODIGO, t6.COD_ORG CODORG, t6.NOMBRE_ES NOMBREES, t6.NOMBRE_EU NOMBREEU "
				+ "FROM TRAMITE_HECHO t1 ,TRAMITE t2 ,CENSO_MONITOR t3 ,HECHO_DENUNCIADO t4, ORGANISMO t6  "
				+ "WHERE 1=1 AND t1.EHCOTEE= t2.TRCODIGO(+) AND t1.EHCOMO= t3.MOCODIGO(+) AND t1.EHCOHD= t4.HDCODIGO(+) AND t1.EHCOORTRASPASO= t6.COD_ORG(+) AND t1.EHCODIGO = ? ";
		return (TramiteHechoDetalleKnet) this.jdbcTemplate.queryForObject(query,
				new RowMapper<TramiteHechoDetalleKnet>() {
					public TramiteHechoDetalleKnet mapRow(ResultSet resultSet, int rowNum) throws SQLException {

						return new TramiteHechoDetalleKnet(resultSet.getString("EHCODIGO"),
								resultSet.getDate("EHFECHA"), resultSet.getString("EHHORA"),
								resultSet.getString("EHCODPOR"), resultSet.getString("EHCODPDE"), null,
								resultSet.getString("EHCOZS"), resultSet.getBigDecimal("EHCIVIHE"),
								resultSet.getDate("EHACUSE"), resultSet.getString("EHENVIOMAIL"),
								resultSet.getString("EHDIREMAIL"), resultSet.getString("TRCODIGO"),
								resultSet.getString("TRNOMBRE"), resultSet.getString("TRNOMBREE"),
								resultSet.getDate("TRBAJA"), resultSet.getString("MOCODIGO"),
								resultSet.getString("MOCOOR"), resultSet.getString("MONOMBRE"),
								resultSet.getString("MOCOEM"), resultSet.getString("HDCODIGO"), null, null, null, null,
								null, null, null, null, null, resultSet.getString("CODORG"),
								resultSet.getString("NOMBREES"), resultSet.getString("NOMBREEU"), null, null);
					}
				}, tramiteHechoDetalleKnet.getEhcodigo());
	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalleKnet
	 *            TramiteHechoDetalleKnet
	 * @return TramiteHechoDetalleKnet
	 */
	@Transactional(readOnly = true)
	public TramiteHechoDetalleKnet findLobTablaTemporal(TramiteHechoDetalleKnet tramiteHechoDetalleKnet) {
		String query = "SELECT EHCODIGO, EHTEXTO " + "FROM TRAMITE_HECHO  " + "WHERE EHCODIGO = ? ";
		return (TramiteHechoDetalleKnet) this.jdbcTemplate.queryForObject(query,
				new RowMapper<TramiteHechoDetalleKnet>() {
					public TramiteHechoDetalleKnet mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new TramiteHechoDetalleKnet(resultSet.getString("EHCODIGO"), null, null, null, null,
								resultSet.getString("EHTEXTO"), null, null, null, null, null, null, null, null, null,
								null, null, null, null, null, null, null, null, null, null, null, null, null, null,
								null, null, null, null, null);
					}
				}, tramiteHechoDetalleKnet.getEhcodigo());
	}

	/**
	 * Completa acuse recibo.
	 * 
	 * @param tramitehechoAcuse
	 *            the tramitehecho acuse
	 * @param situacionNotificacion
	 *            the situacion notificacion
	 * @param deliveredNotificationInfo
	 *            the delivered notification info
	 * @return the tramite hecho
	 * @throws Exception
	 *             the exception
	 */
	public TramiteHecho completaAcuseRecibo(TramiteHecho tramitehechoAcuse, String situacionNotificacion,
			DeliveredNotificationInfo deliveredNotificationInfo) throws Exception {

		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, new Locale(Y41bConstantes.CASTELLANO));
		tramitehechoAcuse.setEhfecha(todayWithZeroTime);
		String ehhora = null;
		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		tramitehechoAcuse.setEhhora(ehhora);
		tramitehechoAcuse.setEhfechafin(new Date());

		tramitehechoAcuse.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		tramitehechoAcuse.setEhacusereciborecibido(situacionNotificacion);
		if (Y41bUtils.isFilled(deliveredNotificationInfo.getDeliveryTimestamp())) {
			try {
				SimpleDateFormat formatterAcuseRecibo = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
				Date dateAcuseRecibo = formatterAcuseRecibo.parse(deliveredNotificationInfo.getDeliveryTimestamp());
				tramitehechoAcuse.setEhacuserecibo(dateAcuseRecibo);
			} catch (Exception e) {
				logger.error("Error producido al parsear la fecha del acuse: ", e);
				// Si falla el parseo meto la fecha de hoy
				tramitehechoAcuse.setEhacuserecibo(todayWithZeroTime);
			}
		} else {
			tramitehechoAcuse.setEhacuserecibo(todayWithZeroTime);
		}
		this.update(tramitehechoAcuse);
		return tramitehechoAcuse;
	}

	/**
	 * Finds a List of rows in the TramiteHecho table.
	 * 
	 * @param notificacionComunicacionDetalle
	 *            NotificacionesComunicacionesBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<NotificacionesComunicacionesBusqueda> findAllNotifiComuni(
			NotificacionesComunicacionesBusqueda notificacionComunicacionDetalle, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT T5.DECOOR||' '||T5.DENRAN||' '||T5.DENROR||' '||T4.HDNROR IDTRAMITE, T1.EHCODIGO CODEXPEDIENTE, T5.DECOOR DECOOR, "
						+ "T4.HDCODIGO HDCODIGO, "
						+ "T5.DENROR DENROR, T5.DENRAN DENRAN, T4.HDNROR HDNROR, T1.EHCOMOEJECUCION EHCOMOEJECUCION,"
						+ " T3.MONOMBRE MONOMBRE, T1.EHTIPONOTIFICACIONPLATEA EHTIPONOTIFICACIONPLATEA, T1.EHIDDESTINATARIO EHIDDESTINATARIO,"
						+ " T2.NIF NIF, " + " T2.NOMBRE ||' '||T2.APELLIDO1||' '||T2.APELLIDO2 AS NOMBREDESTINATARIO, "
						+ " T2.ESNOCO AS NOMBRECOMERCIALDESTINATARIO, "
						+ " T2.NOMBRE_CP NOMBRE_CP, T2.NOMBRE_PROVINCIA NOMBRE_PROVINCIA, "
						+ " T2.NOMBRE_MUNICIPIO NOMBRE_MUNICIPIO, T1.EHFECHAINICIO EHFECHAINICIO, "
						+ " T2.NOMBRE_CALLE||','||T2.NOMBRE_PORTAL AS DIRECCION1, T2.NOMBRE_CP||' '||T2.NOMBRE_LOCALIDAD AS DIRECCION2, "
						+ " T2.EXTRANJERO EXTRANJERO, T2.NOMBRE_LOCALIDAD NOMBRE_LOCALIDAD, T2.NOMBRE_CALLE NOMBRECALLE, T2.NOMBRE_PORTAL NOMBREPORTAL, "
						+ " T2.NOMBRE_PISO NOMBREPISO, T2.NOMBRE_PAIS NOMBREPAIS, T2.DIRECCION_NOCAPV DIRECCIONNOCAPV, T2.DIRECCION_ANTIGUA DIRECCIONANTIGUA, "
						+ " T1.EHASUNTOCOMUNICACION ASUNTO,T9.EHESTADOTRAMITE EHESTADOTRAMITE, T1.EHNUMREGISTROSALIDA EHNUMREGISTROSALIDA, T1.EHSEDE EHSEDE, T2.ESCODIGO ESCODIGO, "
						+ " T7.COD_ORG CODORG, T7.NOMBRE_ES NOMBREES, T7.NOMBRE_EU NOMBREEU,  T7.NORA_PROVINCIA_ID NORAPROVINCIAID, T7.NOMBRE_PROVINCIA NOMBREPROVINCIAORG, T7.NORA_MUNICIPIO_ID NORAMUNICIPIOID, T7.NOMBRE_MUNICIPIO NOMBREMUNICIPIOORG, "
						+ " T7.NORA_LOCALIDAD_ID NORALOCALIDADID, T7.NOMBRE_LOCALIDAD NOMBRELOCALIDADORG, T7.NORA_CALLE_ID NORACALLEID, T7.NOMBRE_CALLE NOMBRECALLEORG, T7.NORA_CP_ID NORACPID, T7.NOMBRE_CP NOMBRECPORG, T7.NORA_PORTAL_ID NORAPORTALID, "
						+ " T7.NOMBRE_PORTAL NOMBREPORTALORG, T7.TELEFONO TELEFONOORGANISMO, T7.FAX FAXORGANISMO, T7.EMAIL EMAILORGANISMO, T7.URL WEBORGANISMO, "
						+ " T1.EHCOTEE TRCODIGO, T1.EHCODIGO EHCODIGO, T2.TIPO_INTERVINIENTE TIPOINTERVINIENTE, T3.USUARIOXLNET USUARIOXLNET, T3.PUESTOXLNET PUESTOXLNET, "
						+ " T8.ENVCESTADO ENVCESTADO, T8.ENVCDESERRORES ENVCDESERRORES, T8.ENVCDESERROREU ENVCDESERROREU, T8.ENVC_ID_ENVIO ENVCIDENVIO, T8.ENVCCOD_SIT_CORREOS ENVCCODSITCORREOS, T8.ENVCDES_SIT_CORREOS_ES ENVCDESSITCORREOSES, T8.ENVCDES_SIT_CORREOS_EU ENVCDESSITCORREOSEU, "
						+ " T8.ENVFECHAACTUALIZACION ENVFECHAACTUALIZACION,T8.ENVCCODBARRAS ENVCCODBARRAS,T9.EHCODIGO IDTRAMITEACUSERELACIONADO, T9.EHACUSERECIBORECIBIDO "
						+ " FROM TRAMITE_HECHO T1, INTERVINIENTES T2, CENSO_MONITOR T3, HECHO_DENUNCIADO T4, DENUNCIA T5, DECISION_HECHO T6, ORGANISMO T7, ENVIOS_POR_REMESA T8, TRAMITE_HECHO T9 ");

		Map<String, ?> mapaWhere = this.getWhereMapNotifiComunica(notificacionComunicacionDetalle);

		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND T1.EHIDDESTINATARIO=T2.IDINTERVINIENTE AND T1.EHCOMOEJECUCION= T3.MOCODIGO "
						+ "AND T1.EHCOHD=T4.HDCODIGO AND T4.HDCODE=T5.DECODIGO AND T4.HDCODIGO = T6.HCCOHD "
						+ "AND t6.HCCOOR= t7.COD_ORG AND T1.EHCODIGO = T8.EHCODIGO(+) "
						+ "AND T1.EHCODIGO = T9.EHCODIGORELACIONADO(+) AND t9.EHCOTEE(+) = '"
						+ Y41bConstantes.TRAMITE_ACUSE_RECIBO + "' ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<NotificacionesComunicacionesBusqueda>) this.jdbcTemplate.query(query.toString(),
				this.rwMapNotifiComunica, params.toArray());
	}

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param notificacionComunicacionDetalle
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllNotifiComuniCount(NotificacionesComunicacionesBusqueda notificacionComunicacionDetalle) {

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM TRAMITE_HECHO T1, INTERVINIENTES T2, CENSO_MONITOR T3, HECHO_DENUNCIADO T4, DENUNCIA T5, DECISION_HECHO T6 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapNotifiComunica(notificacionComunicacionDetalle);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND T1.EHIDDESTINATARIO=T2.IDINTERVINIENTE AND T1.EHCOMOEJECUCION= T3.MOCODIGO "
						+ "AND T1.EHCOHD=T4.HDCODIGO AND T4.HDCODE=T5.DECODIGO AND T4.HDCODIGO = T6.HCCOHD ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	public void removeRemesaFromTramites(String codRemesa) {

		String query = "UPDATE TRAMITE_HECHO SET ehcodrem = NULL WHERE ehcodrem=?";

		this.jdbcTemplate.update(query, codRemesa);

	}

	public void removeRemesaFromTramitesByEhcodigo(String Ehcodigo) {

		String query = "UPDATE TRAMITE_HECHO SET ehcodrem = NULL WHERE EHCODIGO=?";

		this.jdbcTemplate.update(query, Ehcodigo);

	}

	// CHECKSTYLE:OFF CyclomaticComplexity - Generacin de cdigo de UDA
	private Map<String, ?> getWhereMapNotifiComunica(
			NotificacionesComunicacionesBusqueda notificacionComunicacionDetalle) {

		StringBuilder where = new StringBuilder(TramiteHechoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (notificacionComunicacionDetalle != null) {
			if (notificacionComunicacionDetalle.getRmcodigo() == null) {
				where.append(" AND T1.EHENVREM='");
				where.append(Y41bConstantes.SI);
				where.append("'");

				where.append(" AND T1.EHESTADOTRAMITE='");
				where.append(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
				where.append("'");
				where.append(" AND T1.EHCODREM IS NULL ");
			}
			if (notificacionComunicacionDetalle.getRmcodigo() != null) {
				where.append(" AND T1.EHCODREM ='");
				where.append(notificacionComunicacionDetalle.getRmcodigo());
				where.append("'");
			}
			if (notificacionComunicacionDetalle.getRmtipo() != null
					&& notificacionComunicacionDetalle.getModoRemesa() != null && notificacionComunicacionDetalle
							.getModoRemesa().equalsIgnoreCase(Y41bConstantes.MODO_POPUP_ALTA)) {
				String tipo = notificacionComunicacionDetalle.getRmtipo();
				if (tipo.contains(Y41bConstantes.TRAMITE_NOTIFICACION)) {
					if (notificacionComunicacionDetalle.isCompatibleAA66()) {
						where.append(" AND (T2.EXTRANJERO = '");
						if (tipo.equalsIgnoreCase(Y41bConstantes.TRAMITE_NOTIFICACION_ELECTRONICA)) {
							where.append(Y41bConstantes.NO);
							where.append("'");
							where.append(" OR T2.NORA_PAIS_ID = '");
							where.append(Y41bConstantes.COD_PAIS_ESTADO);
							where.append("'");
							where.append(" OR T2.NORA_PAIS_ID IS NULL)");
						} else {
							where.append(Y41bConstantes.SI);
							where.append("'");
							where.append(" OR T2.NORA_PAIS_ID <> '");
							where.append(Y41bConstantes.COD_PAIS_ESTADO);
							where.append("')");
						}
					}
					tipo = Y41bConstantes.TRAMITE_NOTIFICACION;
				}
				where.append(" AND T1.EHCOTEE = '");
				where.append(tipo);
				where.append("'");
			}
			if (notificacionComunicacionDetalle.isRmcapv() != null) {
				where.append(" AND T2.NORA_PROVINCIA_ID IN ('48','01','20') ");
			}
			if (notificacionComunicacionDetalle.getRmorganico() != null) {

				// JGREY. 15/12/2016:
				// MANTIS 91389: Cambio / Traslado entre oficinas territoriales

				// Inicio condicion
				where.append(" AND (");

				// 1. Muestra los envios del organismo de busqueda,
				// que no tengan tramite de traslado
				where.append("(T6.HCCOOR = '");
				where.append(notificacionComunicacionDetalle.getRmorganico());
				where.append("' AND ");
				where.append(
						" (SELECT TRASLADO.IHCOORDT FROM TRASLADO WHERE TRASLADO.IHCOEH = T1.EHCODIGORELACIONADO) is null");
				//
				where.append(") OR (");

				// 2. Muestra los envios del organismo de busqueda, excepto si
				// dicho organismo es un destino de un traslado
				where.append("T6.HCCOOR = '");
				where.append(notificacionComunicacionDetalle.getRmorganico());
				where.append("' AND '");
				where.append(notificacionComunicacionDetalle.getRmorganico());
				where.append(
						"' <> (SELECT TRASLADO.IHCOORDT FROM TRASLADO WHERE TRASLADO.IHCOEH = T1.EHCODIGORELACIONADO)");
				//
				where.append(") OR (");

				// 3. Muestra los envios del organismo de busqueda, si son
				// origen de un traslado
				where.append("'");
				where.append(notificacionComunicacionDetalle.getRmorganico());
				where.append(
						"' = (SELECT TRASLADO.IHCOOROR FROM TRASLADO WHERE TRASLADO.IHCOEH = T1.EHCODIGORELACIONADO) ");
				//
				where.append(")");

				// Fin condicion
				where.append(") ");
			}
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	private RowMapper<NotificacionesComunicacionesBusqueda> rwMapNotifiComunica = new RowMapper<NotificacionesComunicacionesBusqueda>() {
		public NotificacionesComunicacionesBusqueda mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new NotificacionesComunicacionesBusqueda(resultSet.getString("IDTRAMITE"),
					resultSet.getString("CODEXPEDIENTE"), resultSet.getString("DECOOR"), resultSet.getString("DENROR"),
					resultSet.getBigDecimal("DENRAN"), resultSet.getBigDecimal("HDNROR"),
					resultSet.getDate("EHFECHAINICIO"), resultSet.getString("EHNUMREGISTROSALIDA"),
					resultSet.getString("EHTIPONOTIFICACIONPLATEA"), resultSet.getString("EHCOMOEJECUCION"),
					resultSet.getString("MONOMBRE"), resultSet.getString("EHIDDESTINATARIO"),
					resultSet.getString("NIF"), resultSet.getString("NOMBREDESTINATARIO"),
					resultSet.getString("NOMBRECOMERCIALDESTINATARIO"), resultSet.getString("EXTRANJERO"),
					resultSet.getString("NOMBRE_PROVINCIA"), resultSet.getString("NOMBRE_MUNICIPIO"),
					resultSet.getString("NOMBRE_LOCALIDAD"), resultSet.getString("NOMBRE_CP"),
					resultSet.getString("NOMBRECALLE"), resultSet.getString("NOMBREPORTAL"),
					resultSet.getString("NOMBREPISO"), resultSet.getString("NOMBREPAIS"),
					resultSet.getString("DIRECCIONNOCAPV"), resultSet.getString("DIRECCIONANTIGUA"),
					resultSet.getString("DIRECCION1"), resultSet.getString("DIRECCION2"), resultSet.getString("ASUNTO"),
					resultSet.getString("EHESTADOTRAMITE"), resultSet.getString("EHSEDE"),
					resultSet.getString("ESCODIGO"), resultSet.getString("HDCODIGO"), resultSet.getString("CODORG"),
					resultSet.getString("NOMBREES"), resultSet.getString("NOMBREEU"),
					resultSet.getString("NORAPROVINCIAID"), resultSet.getString("NOMBREPROVINCIAORG"),
					resultSet.getString("NORAMUNICIPIOID"), resultSet.getString("NOMBREMUNICIPIOORG"),
					resultSet.getString("NORALOCALIDADID"), resultSet.getString("NOMBRELOCALIDADORG"),
					resultSet.getString("NORACALLEID"), resultSet.getString("NOMBRECALLEORG"),
					resultSet.getString("NORACPID"), resultSet.getString("NOMBRECPORG"),
					resultSet.getString("NORAPORTALID"), resultSet.getString("NOMBREPORTALORG"),
					resultSet.getString("TELEFONOORGANISMO"), resultSet.getString("FAXORGANISMO"),
					resultSet.getString("EMAILORGANISMO"), resultSet.getString("WEBORGANISMO"),
					resultSet.getString("TRCODIGO"), resultSet.getString("TIPOINTERVINIENTE"),
					resultSet.getString("USUARIOXLNET"), resultSet.getString("PUESTOXLNET"),
					resultSet.getString("ENVCESTADO"), resultSet.getString("ENVCDESERRORES"),
					resultSet.getString("ENVCDESERROREU"), resultSet.getInt("ENVCIDENVIO"),
					resultSet.getString("ENVCCODSITCORREOS"), resultSet.getString("ENVCDESSITCORREOSES"),
					resultSet.getString("ENVCDESSITCORREOSEU"), resultSet.getDate("ENVFECHAACTUALIZACION"),
					resultSet.getString("ENVCCODBARRAS"), // j
					resultSet.getString("IDTRAMITEACUSERELACIONADO"), // j
					resultSet.getString("EHACUSERECIBORECIBIDO"));
		}
	};

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho updateRemesa(TramiteHecho tramitehecho) {
		String query = "UPDATE TRAMITE_HECHO SET EHCODREM=? WHERE EHCODIGO=?";

		this.jdbcTemplate.update(query, tramitehecho.getEhcodrem(), tramitehecho.getEhcodigo());
		return tramitehecho;
	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	@Transactional(readOnly = true)
	public List<NotificacionesComunicacionesBusqueda> findBlobTablaDocumentosHecho(
			NotificacionesComunicacionesBusqueda notifiComuni) {
		try {
			String query = "SELECT T2.EHCODREM DHCODREM, T2.EHCODIGO DHEHCODIGO , T1.Q5CODOCUMENTO DHCODDOC, T1.Q5DATAFILE DHDATAFILE, NULL DHFECHA, T1.Q5IDDOCUMENTUM Q5IDDOCUMENTUM "
					+ " FROM DOCUMENTO_HECHO T1, TRAMITE_HECHO T2, DOC_TRAMITE_HECHO T3 WHERE T1.Q5CODOCUMENTO= T3.CODOCUMENTO AND T2.EHCODIGO=T3.EHCODIGO AND T2.EHCODREM = ?";

			return (List<NotificacionesComunicacionesBusqueda>) this.jdbcTemplate.query(query.toString(),
					new RowMapper<NotificacionesComunicacionesBusqueda>() {
						public NotificacionesComunicacionesBusqueda mapRow(ResultSet resultSet, int rowNum)
								throws SQLException {
							return new NotificacionesComunicacionesBusqueda(resultSet.getString("DHCODREM"),
									resultSet.getString("DHEHCODIGO"), resultSet.getString("DHCODDOC"),
									resultSet.getBlob("DHDATAFILE"), resultSet.getString("Q5IDDOCUMENTUM"));
						}
					}, notifiComuni.getRmcodigo());

		} catch (EmptyResultDataAccessException e) {
			return null;
		}
	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param notifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findSumSizeBlobNotifiComuni(NotificacionesComunicacionesBusqueda notifiComuni) {

		String query = "SELECT SUM(T1.Q5SIZEFILE) TAMANO "
				+ " FROM DOCUMENTO_HECHO T1, TRAMITE_HECHO T2, DOC_TRAMITE_HECHO T3 WHERE T1.Q5CODOCUMENTO= T3.CODOCUMENTO AND T2.EHCODIGO=T3.EHCODIGO AND T2.EHCODREM = ?";

		List<Object> params = new ArrayList<Object>();
		params.add(notifiComuni.getRmcodigo());

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Get a New PK (Esperas).
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewEsperaPK() {

		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer("SELECT L2118Q00.NEXTVAL FROM  DUAL ");
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds row in the TramiteHecho table.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	public TramiteHecho findTramiteRegistroSolicitud(TramiteHecho tramiteHecho) {
		try {
			String query = SELECT_TRAMITE_HECHO
					+ " FROM TRAMITE_HECHO t1 , TRAMITE_HECHO t2 WHERE t1.EHCODIGORELACIONADO= t2.EHCODIGO(+) AND t1.EHCOHD = ? AND t1.EHCOTEE = ? ";

			return this.jdbcTemplate.queryForObject(query, this.rwMap, tramiteHecho.getEhcohd(),
					tramiteHecho.getEhcotee());

		} catch (EmptyResultDataAccessException e) {
			return new TramiteHecho();
		}

	}

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllSegundaMediacionCount(TramiteHecho tramiteHecho) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM TRAMITE_HECHO t1 ");

		where.append(" AND t1.EHCOHD = ?");
		params.add(tramiteHecho.getEhcohd());

		where.append(" AND t1.EHCOTEE = ?");
		params.add(Y41bConstantes.TRAMITE_SEGUNDA_MEDIACION);

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
}
