package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.horizontalSystemOfNotification.xml.DeliveredNotificationInfoDocument.DeliveredNotificationInfo;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.NotificacionAcuseRecibo;
import com.ejie.y41b.model.NotificacionesComunicacionesBusqueda;
import com.ejie.y41b.model.PlantillaTramiteHechoDetalle;
import com.ejie.y41b.model.TramiteHecho;
import com.ejie.y41b.model.TramiteHechoDetalle;
import com.ejie.y41b.model.TramiteHechoDetalleKnet;

/**
 * TramiteHechoDao  
 * 
 *  
 */

public interface TramiteHechoDao {

	/**
	 * Inserts a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	TramiteHecho add(TramiteHecho tramitehecho);

	/**
	 * Inserts a single row in the NotificacionAcuseRecibo table.
	 * 
	 * @param notificacionAcuseRecibo
	 *            NotificacionAcuseRecibo
	 * @return NotificacionAcuseRecibo
	 */
	NotificacionAcuseRecibo addNotificacionAcuseRecibo(NotificacionAcuseRecibo notificacionAcuseRecibo);

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	TramiteHecho update(TramiteHecho tramitehecho);

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho updateIdNotificacionPlatea(TramiteHecho tramitehecho);

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho updateProceedingsIdPlatea(TramiteHecho tramitehecho);

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho updateAcuseReintentado(TramiteHecho tramitehecho);

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho updateRegistroSalidaPlatea(TramiteHecho tramitehecho);

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho updateMatarEspera(TramiteHecho tramitehecho);

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho updateEstadoTramite(TramiteHecho tramitehecho);

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho updateFechaInicio(TramiteHecho tramitehecho);

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho updateFechaLimite(TramiteHecho tramitehecho);

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho updateInstructor(TramiteHecho tramitehecho);

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho updateReabrirTramite(TramiteHecho tramitehecho);

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho updateDenegacionTramite(TramiteHecho tramitehecho);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	TramiteHecho find(TramiteHecho tramitehecho);

	/**
	 * Finds a single row in the NotificacionAcuseRecibo table.
	 * 
	 * @param notificacionAcuseRecibo
	 *            NotificacionAcuseRecibo
	 * @return NotificacionAcuseRecibo
	 */
	NotificacionAcuseRecibo findNotificacionAcuseRecibo(NotificacionAcuseRecibo notificacionAcuseRecibo);

	/**
	 * Deletes a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @return
	 */
	void remove(TramiteHecho tramitehecho);

	/**
	 * Removes a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return
	 */
	public void removeTramitesExpediente(TramiteHecho tramitehecho);

	/**
	 * Removes a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return
	 */
	public void removeTramiteCierreSinTramitarExpediente(TramiteHecho tramitehecho);

	/**
	 * Finds a List of rows in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<TramiteHecho> findAll(TramiteHecho tramitehecho, Pagination pagination);

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @return Long
	 */
	Long findAllCount(TramiteHecho tramitehecho);

	/**
	 * Finds rows in the TramiteHecho table using like.
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<TramiteHecho> findAllLike(TramiteHecho tramitehecho, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the TramiteHecho table using like.
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(TramiteHecho tramitehecho, Boolean startsWith);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	public TramiteHecho findLobTablaTemporal(TramiteHecho tramitehecho);

	/**
	 * Finds a List of rows in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TramiteHechoDetalle> findAllTramiteHecho(TramiteHechoDetalle tramiteHechoDetalle,
			Pagination pagination);

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return Long
	 */
	public Long findAllTramiteHechoCount(TramiteHechoDetalle tramiteHechoDetalle);

	/**
	 * Finds a List of rows in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TramiteHechoDetalle> findAllTramiteHechoPendientes(TramiteHechoDetalle tramiteHechoDetalle,
			Pagination pagination);

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return Long
	 */
	public Long findAllTramiteHechoPendientesCount(TramiteHechoDetalle tramiteHechoDetalle);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param plantillaTramiteHechoDetalle
	 *            PlantillaTramiteHechoDetalle
	 * @return PlantillaTramiteHechoDetalle
	 */
	public PlantillaTramiteHechoDetalle findPlantillaTramiteHecho(
			PlantillaTramiteHechoDetalle plantillaTramiteHechoDetalle);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TramiteHechoDetalle
	 */
	public TramiteHechoDetalle findUltimoTramiteHechoPorTipoTramite(TramiteHechoDetalle tramiteHechoDetalle);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TramiteHechoDetalle
	 */
	public TramiteHechoDetalle findUltimoTramiteHechoPorTipoTramiteNoTramitado(TramiteHechoDetalle tramiteHechoDetalle);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @param origen
	 *            String
	 * @return TramiteHechoDetalle
	 */
	public TramiteHechoDetalle findUltimoTramiteHechoPorTipoTramiteYOrigen(TramiteHechoDetalle tramiteHechoDetalle,
			String origen);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @param origen
	 *            String
	 * 
	 * @return TramiteHechoDetalle
	 */
	public TramiteHechoDetalle findUltimoTramiteHechoPorTipoTramiteYOrigenNoTramitado(
			TramiteHechoDetalle tramiteHechoDetalle, String origen);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TramiteHechoDetalle
	 */
	public TramiteHechoDetalle findTramiteRelacionado(TramiteHechoDetalle tramiteHechoDetalle);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalleKnet
	 *            TramiteHechoDetalleKnet
	 * @return TramiteHechoDetalleKnet
	 */
	TramiteHechoDetalleKnet findTramiteHecho(TramiteHechoDetalleKnet tramiteHechoDetalleKnet);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalleKnet
	 *            TramiteHechoDetalleKnet
	 * @return TramiteHechoDetalleKnet
	 */
	TramiteHechoDetalleKnet findLobTablaTemporal(TramiteHechoDetalleKnet tramiteHechoDetalleKnet);

	/**
	 * Completa acuse recibo.
	 * 
	 * @param tramitehechoAcuse
	 *            the tramitehecho acuse
	 * @param situacionNotificacion
	 *            the situacion notificacion
	 * @param deliveredNotificationInfo
	 *            the delivered notification info
	 * @return the tramite hecho
	 * @throws Exception
	 *             the exception
	 */
	public TramiteHecho completaAcuseRecibo(TramiteHecho tramitehechoAcuse, String situacionNotificacion,
			DeliveredNotificationInfo deliveredNotificationInfo) throws Exception;

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TramiteHechoDetalle
	 */
	public TramiteHechoDetalle findUltimoTramiteHechoYFase(TramiteHechoDetalle tramiteHechoDetalle);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TramiteHechoDetalle
	 */
	public TramiteHechoDetalle findUltimoTramiteHechoYFaseNoGenerico(TramiteHechoDetalle tramiteHechoDetalle);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TramiteHechoDetalle
	 */
	public TramiteHechoDetalle findUltimoTramiteHechoYFaseNoGenericoNoCierre(TramiteHechoDetalle tramiteHechoDetalle);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho findUltimoTramite(TramiteHecho tramitehecho);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TramiteHechoDetalle
	 */
	public TramiteHechoDetalle findUltimaFase(TramiteHechoDetalle tramiteHechoDetalle);

	/**
	 * Finds a List of rows in the TramiteHecho table.
	 * 
	 * @param notificacionComunicacionDetalle
	 *            NotificacionesComunicacionesBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<NotificacionesComunicacionesBusqueda> findAllNotifiComuni(
			NotificacionesComunicacionesBusqueda notificacionComunicacionDetalle, Pagination pagination);

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param notificacionComunicacionDetalle
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	public Long findAllNotifiComuniCount(NotificacionesComunicacionesBusqueda notificacionComunicacionDetalle);

	/**
	 * Desasigna a los tramites la remesa asociada
	 * 
	 * @param codRemesa
	 */
	public void removeRemesaFromTramites(String codRemesa);

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public TramiteHecho updateRemesa(TramiteHecho tramitehecho);

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return Long
	 */
	public Long findAllTramiteDecisionPropuestaSancionCount(TramiteHechoDetalle tramiteHechoDetalle);

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return Long
	 */
	public Long findAllTramiteAsignacionInstructorTramitadoCount(TramiteHechoDetalle tramiteHechoDetalle);

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return Long
	 */
	public Long findAllTramiteRegistroSolicitudTramitadoCount(TramiteHechoDetalle tramiteHechoDetalle);

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return Long
	 */
	public Long findAllTramiteAsignacionInstructorSinTramitarCount(TramiteHechoDetalle tramiteHechoDetalle);

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return Long
	 */
	public Long findAllTramiteRecepcionTrasladoTramitadoCount(TramiteHechoDetalle tramiteHechoDetalle);

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return Long
	 */
	public Long findAllTramiteRegistroDecisionTramitadoCount(TramiteHechoDetalle tramiteHechoDetalle);

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return Long
	 */
	public Long findAllInicioTramitacionCount(TramiteHechoDetalle tramiteHechoDetalle);

	/**
	 * Get a New PK (Esperas).
	 * 
	 * @return Long
	 */
	public Long getNewEsperaPK();

	void removeRemesaFromTramitesByEhcodigo(String codExpediente);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param notifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return List
	 */
	public List<NotificacionesComunicacionesBusqueda> findBlobTablaDocumentosHecho(
			NotificacionesComunicacionesBusqueda notifiComuni);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param notifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	public Long findSumSizeBlobNotifiComuni(NotificacionesComunicacionesBusqueda notifiComuni);

	/**
	 * Finds row in the TramiteHecho table.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	public TramiteHecho findTramiteRegistroSolicitud(TramiteHecho tramiteHecho);

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return Long
	 */
	public Long findAllSegundaMediacionCount(TramiteHecho tramiteHecho);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TramiteHechoDetalle
	 */
	public TramiteHechoDetalle findUltimoTramiteHechoPorTipoTramiteTramitado(TramiteHechoDetalle tramiteHechoDetalle);
}
