package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Fase;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.modulos.Y41bModuloUtils;

/**
 * TramiteDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class TramiteDaoImpl implements TramiteDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Tramite> rwMap = new RowMapper<Tramite>() {
		public Tramite mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Tramite(resultSet.getString("TRCODIGO"),
					resultSet.getString("TRNOMBRE"),
					resultSet.getString("TRNOMBREE"),
					resultSet.getDate("TRBAJA"),
					resultSet.getString("ISKONTSUMONET"),
					resultSet.getString("PCODIGO"),
					resultSet.getString("IDPERFIL"),
					resultSet.getLong("PLAZO"),

					new Fase(resultSet.getString("FaseFCODIGO"), resultSet
							.getString("FaseFNOMBRE"), resultSet
							.getString("FaseFNOMBREE"), resultSet
							.getDate("FaseFBAJA"), new TipoProcedimiento(
							resultSet.getString("FasePCODIGO"), null, null,
							null)));
		}
	};

	private RowMapper<Tramite> rwMapCombo = new RowMapper<Tramite>() {
		public Tramite mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Tramite(resultSet.getString("TRCODIGO"),
					resultSet.getString("TRNOMBRE"),
					resultSet.getString("TRNOMBREE"),
					resultSet.getDate("TRBAJA"),
					resultSet.getString("ISKONTSUMONET"),
					resultSet.getString("PCODIGO"),
					resultSet.getString("IDPERFIL"),
					resultSet.getLong("PLAZO"), null);
		}
	};

	private RowMapper<Tramite> rwMapComboSimple = new RowMapper<Tramite>() {
		public Tramite mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Tramite(resultSet.getString("TRCODIGO"),
					resultSet.getString("TRNOMBRE"),
					resultSet.getString("TRNOMBREE"));
		}
	};

	// private RowMapper<Tramite> rwMapCombo = new RowMapper<Tramite>() {
	// public Tramite mapRow(ResultSet resultSet, int rowNum)
	// throws SQLException {
	// String trcodigo = resultSet.getString("TRCODIGO");
	// String trnombre = resultSet.getString("TRNOMBRE");
	// String trnombree = resultSet.getString("TRNOMBREE");
	//
	// return new Tramite(trcodigo, trnombre, trnombree, null, null, null,
	// null, null);
	// }
	// };

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Pagination
	 * @return Tramite
	 */
	public Tramite add(Tramite tramite) {
		String query = "INSERT INTO TRAMITE (TRCODIGO, FCODIGO, TRNOMBRE, TRNOMBREE, TRBAJA, ISKONTSUMONET, PCODIGO, ID_PERFIL, PLAZO) VALUES (?,?,?,?,?,?,?,?,?)";
		Object getFaseFcodigoAux = null;
		if (tramite.getFase() != null && tramite.getFase().getFcodigo() != null) {
			getFaseFcodigoAux = tramite.getFase().getFcodigo();
		}
		this.jdbcTemplate.update(query, tramite.getTrcodigo(),
				getFaseFcodigoAux, tramite.getTrnombre(),
				tramite.getTrnombree(), tramite.getTrbaja(),
				tramite.getIskontsumonet(), tramite.getPcodigo(),
				tramite.getIdPerfil(), tramite.getPlazo());
		return tramite;
	}

	/**
	 * Updates a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Pagination
	 * @return Tramite
	 */
	public Tramite update(Tramite tramite) {
		String query = "UPDATE TRAMITE SET FCODIGO=?, TRNOMBRE=?, TRNOMBREE=?, TRBAJA=?, ISKONTSUMONET=?, PCODIGO=?, ID_PERFIL=?, PLAZO=? WHERE TRCODIGO=?";
		Object getFaseFcodigoAux = null;
		if (tramite.getFase() != null && tramite.getFase().getFcodigo() != null) {
			getFaseFcodigoAux = tramite.getFase().getFcodigo();
		}
		this.jdbcTemplate.update(query, getFaseFcodigoAux,
				tramite.getTrnombre(), tramite.getTrnombree(),
				tramite.getTrbaja(), tramite.getIskontsumonet(),
				tramite.getPcodigo(), tramite.getIdPerfil(),
				tramite.getPlazo(), tramite.getTrcodigo());
		return tramite;
	}

	/**
	 * Updates a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Pagination
	 * @return Tramite
	 */
	public Tramite updateTramite(Tramite tramite) {
		String query = "UPDATE TRAMITE SET TRNOMBRE=?, TRNOMBREE=?, ID_PERFIL=?, PLAZO=? WHERE TRCODIGO=?";

		this.jdbcTemplate.update(query, tramite.getTrnombre(),
				tramite.getTrnombree(), tramite.getIdPerfil(),
				tramite.getPlazo(), tramite.getTrcodigo());
		return tramite;
	}

	/**
	 * Finds a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Pagination
	 * @return Tramite
	 */
	@Transactional(readOnly = true)
	public Tramite find(Tramite tramite) {
		String query = "SELECT t1.TRCODIGO TRCODIGO, t1.TRNOMBRE TRNOMBRE, t1.TRNOMBREE TRNOMBREE, t1.TRBAJA TRBAJA, t1.ISKONTSUMONET ISKONTSUMONET, t1.PCODIGO PCODIGO, t1.ID_PERFIL IDPERFIL, t1.PLAZO PLAZO, t2.FCODIGO FASEFCODIGO, t2.FNOMBRE FASEFNOMBRE, t2.FNOMBREE FASEFNOMBREE, t2.FBAJA FASEFBAJA, t2.PCODIGO FASEPCODIGO FROM TRAMITE t1 , FASE t2  WHERE t1.TRCODIGO = ?   AND t1.FCODIGO= t2.FCODIGO(+)";

		List<Tramite> tramiteList = this.jdbcTemplate.query(query, this.rwMap,
				tramite.getTrcodigo());
		return (Tramite) DataAccessUtils.uniqueResult(tramiteList);
	}

	/**
	 * Finds a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Pagination
	 * @return Tramite
	 */
	@Transactional(readOnly = true)
	public Tramite findTramiteKontsumoGest(Tramite tramite) {
		try {
			String query = "SELECT t1.TEECODIGO TRCODIGO, t1.TEENOMBRE TRNOMBRE, t1.TEENOMBREE TRNOMBREE FROM TRAMITESKONTSUMOGEST t1  WHERE t1.TEECODIGO = ? ";

			List<Tramite> tramiteList = this.jdbcTemplate.query(query,
					this.rwMapComboSimple, tramite.getTrcodigo());
			return (Tramite) DataAccessUtils.uniqueResult(tramiteList);
		} catch (EmptyResultDataAccessException e) {
			return new Tramite();
		}
	}

	/**
	 * Removes a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Pagination
	 * @return
	 */
	public void remove(Tramite tramite) {
		String query = "DELETE FROM TRAMITE WHERE TRCODIGO=?";
		this.jdbcTemplate.update(query, tramite.getTrcodigo());
	}

	/**
	 * Finds a List of rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tramite> findAll(Tramite tramite, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TRCODIGO TRCODIGO,t1.TRNOMBRE TRNOMBRE,NVL(t1.TRNOMBREE,t1.TRNOMBRE) TRNOMBREE,t1.TRBAJA TRBAJA,t1.ISKONTSUMONET ISKONTSUMONET,t1.PCODIGO PCODIGO,t1.ID_PERFIL IDPERFIL, t1.PLAZO PLAZO,t2.FCODIGO FASEFCODIGO,t2.FNOMBRE FASEFNOMBRE,t2.FNOMBREE FASEFNOMBREE,t2.FBAJA FASEFBAJA,t2.PCODIGO FASEPCODIGO ");
		query.append("FROM TRAMITE t1 ,FASE t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tramite);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.FCODIGO= t2.FCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Tramite>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tramite> findAllSin(Tramite tramite, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TRCODIGO TRCODIGO,t1.TRNOMBRE TRNOMBRE,NVL(t1.TRNOMBREE,t1.TRNOMBRE) TRNOMBREE,t1.TRBAJA TRBAJA,t1.ISKONTSUMONET ISKONTSUMONET,t1.PCODIGO PCODIGO,t1.ID_PERFIL IDPERFIL, t1.PLAZO PLAZO,t2.FCODIGO FASEFCODIGO,t2.FNOMBRE FASEFNOMBRE,t2.FNOMBREE FASEFNOMBREE,t2.FBAJA FASEFBAJA,t2.PCODIGO FASEPCODIGO ");
		query.append("FROM TRAMITE t1 ,FASE t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tramite);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.FCODIGO= t2.FCODIGO(+) AND t1.TRCODIGO<>'K02'");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Tramite>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tramite> findAllTramiteKontsumoGest(Tramite tramite,
			Pagination pagination) {
		String query = "SELECT t1.TEECODIGO TRCODIGO, t1.TEENOMBRE TRNOMBRE, t1.TEENOMBREE TRNOMBREE FROM TRAMITESKONTSUMOGEST t1 ";

		return (List<Tramite>) this.jdbcTemplate.query(query,
				this.rwMapComboSimple);
	}

	/**
	 * Finds a List of rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tramite> findAllActivos(Tramite tramite, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TRCODIGO TRCODIGO,t1.TRNOMBRE TRNOMBRE,NVL(t1.TRNOMBREE,t1.TRNOMBRE) TRNOMBREE,t1.TRBAJA TRBAJA,t1.ISKONTSUMONET ISKONTSUMONET,t1.PCODIGO PCODIGO,t1.ID_PERFIL IDPERFIL, t1.PLAZO PLAZO,t2.FCODIGO FASEFCODIGO,t2.FNOMBRE FASEFNOMBRE,t2.FNOMBREE FASEFNOMBREE,t2.FBAJA FASEFBAJA,t2.PCODIGO FASEPCODIGO ");
		query.append("FROM TRAMITE t1 ,FASE t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tramite);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.FCODIGO= t2.FCODIGO(+) AND t1.TRBAJA IS NULL ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Tramite>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Tramite tramite) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM TRAMITE t1 , FASE t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tramite);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.FCODIGO= t2.FCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Tramite table using like.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tramite> findAllLike(Tramite tramite, Pagination pagination,
			Boolean startsWith) {
		// StringBuilder query = new StringBuilder(
		// "SELECT  t1.TRCODIGO TRCODIGO,t1.TRNOMBRE TRNOMBRE,t1.TRNOMBREE TRNOMBREE,t1.TRBAJA TRBAJA,t1.ISKONTSUMONET ISKONTSUMONET,t1.PCODIGO PCODIGO,t1.ID_PERFIL IDPERFIL,t2.FCODIGO FASEFCODIGO,t2.FNOMBRE FASEFNOMBRE,t2.FNOMBREE FASEFNOMBREE,t2.FBAJA FASEFBAJA,t2.PCODIGO FASEPCODIGO ");
		// query.append("FROM TRAMITE t1 ,FASE t2 ");
		//
		// // Where clause & Params
		// Map<String, ?> mapaWhere = this.getWhereLikeMap(tramite, startsWith);
		// StringBuilder where = new StringBuilder(
		// " WHERE 1=1 AND t1.FCODIGO= t2.FCODIGO(+) ");
		// where.append(mapaWhere.get("query"));
		// query.append(where);
		//
		// List<?> params = (List<?>) mapaWhere.get("params");
		//
		// if (pagination != null) {
		// query = pagination.getPaginationQuery(query);
		// }
		//
		// return (List<Tramite>) this.jdbcTemplate.query(query.toString(),
		// this.rwMap, params.toArray());

		StringBuilder query = new StringBuilder(
				"SELECT  t1.TRCODIGO TRCODIGO,t1.TRNOMBRE TRNOMBRE,NVL(t1.TRNOMBREE,t1.TRNOMBRE) TRNOMBREE,t1.TRBAJA TRBAJA,t1.ISKONTSUMONET ISKONTSUMONET,t1.PCODIGO PCODIGO,t1.ID_PERFIL IDPERFIL, t1.PLAZO PLAZO,t2.FCODIGO FASEFCODIGO,t2.FNOMBRE FASEFNOMBRE,t2.FNOMBREE FASEFNOMBREE,t2.FBAJA FASEFBAJA,t2.PCODIGO FASEPCODIGO ");
		query.append("FROM TRAMITE t1 ,FASE t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tramite, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.FCODIGO= t2.FCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Tramite>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Tramite table using like.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Tramite tramite, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM TRAMITE t1 ,FASE t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tramite, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.FCODIGO= t2.FCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Tramite entity
	 * 
	 * @param tramite
	 *            Tramite Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Tramite tramite) {

		StringBuilder where = new StringBuilder(
				TramiteDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tramite != null && tramite.getTrcodigo() != null) {
			where.append(" AND t1.TRCODIGO = ?");
			params.add(tramite.getTrcodigo());
		}
		if (tramite != null && tramite.getFase() != null
				&& tramite.getFase().getFcodigo() != null) {
			where.append(" AND t2.FCODIGO = ?");
			params.add(tramite.getFase().getFcodigo());
		}
		if (tramite != null && tramite.getFase() != null
				&& tramite.getFase().getFnombre() != null) {
			where.append(" AND t2.FNOMBRE = ?");
			params.add(tramite.getFase().getFnombre());
		}
		if (tramite != null && tramite.getFase() != null
				&& tramite.getFase().getFnombree() != null) {
			where.append(" AND t2.FNOMBREE = ?");
			params.add(tramite.getFase().getFnombree());
		}
		if (tramite != null && tramite.getFase() != null
				&& tramite.getFase().getFbaja() != null) {
			where.append(" AND t2.FBAJA = ?");
			params.add(tramite.getFase().getFbaja());
		}
		/*
		 * if (tramite != null && tramite.getFase() != null &&
		 * tramite.getFase().getPcodigo() != null) {
		 * where.append(" AND t2.PCODIGO = ?");
		 * params.add(tramite.getFase().getPcodigo()); }
		 */
		if (tramite != null && tramite.getTrnombre() != null) {
			where.append(" AND t1.TRNOMBRE = ?");
			params.add(tramite.getTrnombre());
		}
		if (tramite != null && tramite.getTrnombree() != null) {
			where.append(" AND t1.TRNOMBREE = ?");
			params.add(tramite.getTrnombree());
		}
		if (tramite != null && tramite.getTrbaja() != null) {
			where.append(" AND t1.TRBAJA = ?");
			params.add(tramite.getTrbaja());
		}
		if (tramite != null && tramite.getIskontsumonet() != null) {
			where.append(" AND t1.ISKONTSUMONET = ?");
			params.add(tramite.getIskontsumonet());
		}
		if (tramite != null && tramite.getPcodigo() != null) {
			where.append(" AND t1.PCODIGO = ?");
			params.add(tramite.getPcodigo());
		}
		if (tramite != null && tramite.getIdPerfil() != null) {
			where.append(" AND t1.ID_PERFIL = ?");
			params.add(tramite.getIdPerfil());
		}
		if (!Y41bModuloUtils.getInstance().mostrarPagoPericialColegio()) {
			where.append(" AND t1.TRCODIGO<>'"
					+ Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_PERICIAL_COLEGIO
					+ "'");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Tramite entity
	 * 
	 * @param tramite
	 *            Tramite Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Tramite tramite, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				TramiteDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tramite != null && tramite.getTrcodigo() != null) {
			where.append(" AND UPPER(t1.TRCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramite.getTrcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tramite.getTrcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.TRCODIGO IS NOT NULL");
		}
		if (tramite != null && tramite.getFase() != null
				&& tramite.getFase().getFcodigo() != null) {
			where.append(" AND t2.FCODIGO = ?");
			params.add(tramite.getFase().getFcodigo());
		}
		if (tramite != null && tramite.getFase() != null
				&& tramite.getFase().getFnombre() != null) {
			where.append(" AND UPPER(t2.FNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramite.getFase().getFnombre().toUpperCase() + "%");
			} else {
				params.add("%" + tramite.getFase().getFnombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.FNOMBRE IS NOT NULL");
		}
		if (tramite != null && tramite.getFase() != null
				&& tramite.getFase().getFnombree() != null) {
			where.append(" AND UPPER(t2.FNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramite.getFase().getFnombree().toUpperCase() + "%");
			} else {
				params.add("%" + tramite.getFase().getFnombree().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.FNOMBREE IS NOT NULL");
		}
		if (tramite != null && tramite.getFase() != null
				&& tramite.getFase().getFbaja() != null) {
			where.append(" AND t2.FBAJA = ?");
			params.add(tramite.getFase().getFbaja());
		}
		/*
		 * if (tramite != null && tramite.getFase() != null &&
		 * tramite.getFase().getPcodigo() != null) {
		 * where.append(" AND UPPER(t2.PCODIGO) like ? ESCAPE  '\\'"); if
		 * (startsWith) {
		 * params.add(tramite.getFase().getPcodigo().toUpperCase() + "%"); }
		 * else { params.add("%" + tramite.getFase().getPcodigo().toUpperCase()
		 * + "%"); } where.append(" AND t2.PCODIGO IS NOT NULL"); }
		 */
		if (tramite != null && tramite.getTrnombre() != null) {
			where.append(" AND UPPER(t1.TRNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramite.getTrnombre().toUpperCase() + "%");
			} else {
				params.add("%" + tramite.getTrnombre().toUpperCase() + "%");
			}
			where.append(" AND t1.TRNOMBRE IS NOT NULL");
		}
		if (tramite != null && tramite.getTrnombree() != null) {
			where.append(" AND UPPER(t1.TRNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramite.getTrnombree().toUpperCase() + "%");
			} else {
				params.add("%" + tramite.getTrnombree().toUpperCase() + "%");
			}
			where.append(" AND t1.TRNOMBREE IS NOT NULL");
		}
		if (tramite != null && tramite.getTrbaja() != null) {
			where.append(" AND t1.TRBAJA = ?");
			params.add(tramite.getTrbaja());
		}
		if (tramite != null && tramite.getIskontsumonet() != null) {
			where.append(" AND UPPER(t1.ISKONTSUMONET) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramite.getIskontsumonet().toUpperCase() + "%");
			} else {
				params.add("%" + tramite.getIskontsumonet().toUpperCase() + "%");
			}
			where.append(" AND t1.ISKONTSUMONET IS NOT NULL");
		}
		if (tramite != null && tramite.getPcodigo() != null) {
			where.append(" AND UPPER(t1.PCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramite.getPcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tramite.getPcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.PCODIGO IS NOT NULL");
		}
		if (tramite != null && tramite.getIdPerfil() != null) {
			where.append(" AND UPPER(t1.ID_PERFIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tramite.getIdPerfil().toUpperCase() + "%");
			} else {
				params.add("%" + tramite.getIdPerfil().toUpperCase() + "%");
			}
			where.append(" AND t1.ID_PERFIL IS NOT NULL");
		}
		if (!Y41bModuloUtils.getInstance().mostrarPagoPericialColegio()) {
			where.append(" AND t1.TRCODIGO<>'"
					+ Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_PERICIAL_COLEGIO
					+ "'");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds a List of rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tramite> findAllTramitesFase(Tramite tramite,
			Pagination pagination) {

		StringBuilder query = new StringBuilder(
				"SELECT  t1.TRCODIGO TRCODIGO,t1.TRNOMBRE TRNOMBRE,NVL(t1.TRNOMBREE,t1.TRNOMBRE) TRNOMBREE,t1.TRBAJA TRBAJA,t1.ISKONTSUMONET ISKONTSUMONET,t1.PCODIGO PCODIGO,t1.ID_PERFIL IDPERFIL, t1.PLAZO PLAZO ");
		query.append(" FROM TRAMITE t1  ");

		// Where clause & Params

		StringBuilder where = new StringBuilder(" WHERE 1=1 AND T1.PCODIGO ='"
				+ tramite.getPcodigo() + "' AND (T1.FCODIGO IS NULL ");
		if (tramite.getFase() != null && tramite.getFase().getFcodigo() != null) {
			where.append("or T1.FCODIGO = ");
			where.append(tramite.getFase().getFcodigo());
		}
		where.append(")");
		if (!Y41bModuloUtils.getInstance().mostrarPagoPericialColegio()) {
			where.append(" AND t1.TRCODIGO<>'"
					+ Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_PERICIAL_COLEGIO
					+ "'");
		}

		query.append(where);
		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Tramite>) this.jdbcTemplate.query(query.toString(),
				this.rwMapCombo);
	}

	/**
	 * Finds a List of rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @param excodigo
	 *            the excodigo
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tramite> findAllTramitesFaseGenerables(Tramite tramite,
			Pagination pagination, String excodigo) {

		StringBuilder query = new StringBuilder("");
		// Where clause & Params
		if (!Y41bUtils.esNullOCadenaVacia(tramite.getPcodigo())) {
			if (Y41bConstantes.TIPO_PROC_SANCIONES.equals(tramite.getPcodigo())) {
				query.append(this.findAllTramitesFaseGenerablesSAN(tramite,
						excodigo));
			} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(tramite
					.getPcodigo())) {
				query.append(this.findAllTramitesFaseGenerablesARB(tramite,
						excodigo));
			} else {
				query.append("SELECT T1.TRCODIGO AS CODIGO, T1.TRNOMBRE AS TRNOMBRE, NVL(T1.TRNOMBREE,T1.TRNOMBRE) AS TRNOMBREE FROM TRAMITE T1 WHERE 1 = 0");
			}
			if (pagination != null) {
				query = pagination.getPaginationQuery(query);
			}
		} else {
			query.append("SELECT T1.TRCODIGO AS CODIGO, T1.TRNOMBRE AS TRNOMBRE, NVL(T1.TRNOMBREE,T1.TRNOMBRE) AS TRNOMBREE FROM TRAMITE T1 WHERE 1 = 0");
		}

		return (List<Tramite>) this.jdbcTemplate.query(query.toString(),
				this.rwMapComboSimple);
	}

	/**
	 * findAllTramitesFaseGenerablesSAN
	 * 
	 * @param tramite
	 *            Tramite
	 * @param excodigo
	 *            String
	 * @return String
	 */
	private String findAllTramitesFaseGenerablesSAN(Tramite tramite,
			String excodigo) {
		StringBuilder query = new StringBuilder("");
		StringBuilder query1 = new StringBuilder(
				" SELECT T1.TRCODIGO AS TRCODIGO, T1.TRNOMBRE AS TRNOMBRE, NVL(T1.TRNOMBREE,T1.TRNOMBRE) AS TRNOMBREE  "
						+ " FROM TRAMITE T1 "
						+ " WHERE 1=1 AND T1.PCODIGO ='"
						+ tramite.getPcodigo()
						+ "' AND T1.FCODIGO IS NULL AND TRCODIGO NOT IN ("
						+ Y41bConstantes.TRAMITES_SANCIONES_NOGENERABLES + ")");
		// Si la propuesta o la resolucion o el cierren ya existen, no se
		// muestran
		StringBuilder query2 = new StringBuilder(
				"  SELECT T5.TRCODIGO AS TRCODIGO, T5.TRNOMBRE AS TRNOMBRE,NVL(T5.TRNOMBREE,T5.TRNOMBRE) AS TRNOMBREE"
						+ " FROM POSIBLE_TRAMITE T1, SANEXP T2, SANTRAMEXP T3, TRAMITE T4,TRAMITE T5"
						+ " WHERE T2.EXTRENTIDAD = T3.TRID AND T4.TRCODIGO = T3.TRCODIGO AND T3.TRCODIGO = T1.TRPOSIBLECODIGOORIGEN AND T5.TRCODIGO = T1.TRPOSIBLECODIGOSIGUIENTE AND T2.EXCODIGO = '"
						+ excodigo
						+ "' AND NOT EXISTS (SELECT 1 FROM SANTRAMEXP T6 WHERE T6.TRCODIGO=T5.TRCODIGO AND (T6.TRCODIGO='"
						+ Y41bConstantes.TRAMITE_SANCIONES_CIERRE
						+ "' OR T6.TRCODIGO='"
						+ Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION
						+ "' OR T6.TRCODIGO='"
						+ Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION
						+ "') AND T6.TREXCODIGO='" + excodigo + "')");
		// Mostramos el cierre si estamos en fase de resolucin o superior
		// siempre que no exista el tramite en el expediente
		StringBuilder query3 = new StringBuilder(
				"SELECT T5.TRCODIGO AS TRCODIGO,T5.TRNOMBRE AS TRNOMBRE,NVL(T5.TRNOMBREE,T5.TRNOMBRE) AS TRNOMBREE"
						+ " FROM TRAMITE T5 "
						+ " WHERE T5.TRCODIGO = '"
						+ Y41bConstantes.TRAMITE_SANCIONES_CIERRE
						+ "' AND EXISTS(SELECT 1 FROM SANEXP T2 WHERE T2.EXFCODIGO>="
						+ Y41bConstantes.FASE_RESOLUCION_SANCION
						+ " AND T2.EXCODIGO='"
						+ excodigo
						+ "')"
						+ " AND NOT EXISTS (SELECT 1 FROM SANTRAMEXP T2 WHERE T2.TRCODIGO='"
						+ Y41bConstantes.TRAMITE_SANCIONES_CIERRE
						+ "' AND T2.TREXCODIGO='" + excodigo + "')");

		query.append("SELECT TRCODIGO,TRNOMBRE, TRNOMBREE FROM (("
				+ query1.toString() + ") UNION (" + query2.toString()
				+ ") UNION (" + query3.toString() + "))");

		return query.toString();
	}

	/**
	 * findAllTramitesFaseGenerablesARB
	 * 
	 * @param tramite
	 *            Tramite
	 * @param excodigo
	 *            String
	 * @return String
	 */
	private String findAllTramitesFaseGenerablesARB(Tramite tramite,
			String excodigo) {
		StringBuilder query = new StringBuilder("");
		StringBuilder query1 = new StringBuilder(
				" SELECT T1.TRCODIGO AS TRCODIGO, T1.TRNOMBRE AS TRNOMBRE, NVL(T1.TRNOMBREE,T1.TRNOMBRE) AS TRNOMBREE  "
						+ " FROM TRAMITE T1 "
						+ " WHERE 1=1 AND T1.PCODIGO ='"
						+ tramite.getPcodigo()
						+ "' AND T1.FCODIGO IS NULL AND TRCODIGO NOT IN ("
						+ Y41bConstantes.TRAMITES_ARBITRAJE_NOGENERABLES + ")");
		if (!Y41bModuloUtils.getInstance().mostrarPagoPericialColegio()) {
			query1.append(" AND t1.TRCODIGO<>'"
					+ Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_PERICIAL_COLEGIO
					+ "'");
		}
		// Si el cierren ya existen, no se
		// muestran
		StringBuilder query2 = new StringBuilder(
				"  SELECT T5.TRCODIGO AS TRCODIGO, T5.TRNOMBRE AS TRNOMBRE,NVL(T5.TRNOMBREE,T5.TRNOMBRE) AS TRNOMBREE"
						+ " FROM POSIBLE_TRAMITE T1, ARBEXP T2, ARBTRAMEXP T3, TRAMITE T4,TRAMITE T5"
						+ " WHERE T2.EXTRENTIDAD = T3.TRID AND T4.TRCODIGO = T3.TRCODIGO AND T3.TRCODIGO = T1.TRPOSIBLECODIGOORIGEN AND T5.TRCODIGO = T1.TRPOSIBLECODIGOSIGUIENTE AND T2.EXCODIGO = '"
						+ excodigo
						+ "' AND NOT EXISTS (SELECT 1 FROM ARBTRAMEXP T6 WHERE T6.TRCODIGO=T5.TRCODIGO AND (T6.TRCODIGO='"
						+ Y41bConstantes.TRAMITE_ARBITRAJE_CIERRE
						+ "') AND T6.TREXCODIGO='" + excodigo + "')");
		if (!Y41bModuloUtils.getInstance().mostrarPagoPericialColegio()) {
			query2.append(" AND t5.TRCODIGO<>'"
					+ Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_PERICIAL_COLEGIO
					+ "'");
		}
		// Mostramos el cierre si estamos en fase de resolucin o superior
		// siempre que no exista el tramite en el expediente
		StringBuilder query3 = new StringBuilder(
				"SELECT T5.TRCODIGO AS TRCODIGO,T5.TRNOMBRE AS TRNOMBRE,NVL(T5.TRNOMBREE,T5.TRNOMBRE) AS TRNOMBREE"
						+ " FROM TRAMITE T5 "
						+ " WHERE T5.TRCODIGO = '"
						+ Y41bConstantes.TRAMITE_ARBITRAJE_CIERRE
						+ "' AND EXISTS(SELECT 1 FROM ARBEXP T2 WHERE T2.EXFCODIGO>="
						+ Y41bConstantes.FASE_RESOLUCION_ARBITRAJE
						+ " AND T2.EXCODIGO='"
						+ excodigo
						+ "')"
						+ " AND NOT EXISTS (SELECT 1 FROM ARBTRAMEXP T2 WHERE T2.TRCODIGO='"
						+ Y41bConstantes.TRAMITE_ARBITRAJE_CIERRE
						+ "' AND T2.TREXCODIGO='" + excodigo + "')");

		query.append("SELECT TRCODIGO,TRNOMBRE, TRNOMBREE FROM (("
				+ query1.toString() + ") UNION (" + query2.toString()
				+ ") UNION (" + query3.toString() + "))");

		return query.toString();
	}
}
