package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Tramite;

/**
 * TramiteDao  
 * 
 *  
 */

public interface TramiteDao {

	/**
	 * Inserts a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Tramite
	 */
	Tramite add(Tramite tramite);

	/**
	 * Updates a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Tramite
	 */
	Tramite update(Tramite tramite);

	/**
	 * Updates a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Pagination
	 * @return Tramite
	 */
	public Tramite updateTramite(Tramite tramite);

	/**
	 * Finds a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Tramite
	 */
	Tramite find(Tramite tramite);

	/**
	 * Finds a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Pagination
	 * @return Tramite
	 */
	public Tramite findTramiteKontsumoGest(Tramite tramite);

	/**
	 * Deletes a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return
	 */
	void remove(Tramite tramite);

	/**
	 * Finds a List of rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Tramite> findAll(Tramite tramite, Pagination pagination);

	/**
	 * Finds a List of rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Tramite> findAllSin(Tramite tramite, Pagination pagination);

	/**
	 * Finds a List of rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Tramite> findAllTramiteKontsumoGest(Tramite tramite,
			Pagination pagination);

	/**
	 * Finds a List of rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Tramite> findAllActivos(Tramite tramite, Pagination pagination);

	/**
	 * Counts rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Long
	 */
	Long findAllCount(Tramite tramite);

	/**
	 * Finds rows in the Tramite table using like.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Tramite> findAllLike(Tramite tramite, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Tramite table using like.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Tramite tramite, Boolean startsWith);

	/**
	 * Finds a List of rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Tramite> findAllTramitesFase(Tramite tramite, Pagination pagination);

	/**
	 * Finds a List of rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Tramite> findAllTramitesFaseGenerables(Tramite tramite,
			Pagination pagination, String excodigo);
}
