package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Tipsubsana;

/**
 * TipsubsanaDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class TipsubsanaDaoImpl implements TipsubsanaDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Tipsubsana> rwMap = new RowMapper<Tipsubsana>() {
		public Tipsubsana mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Tipsubsana(resultSet.getString("TSID"),
					resultSet.getString("TSDESCES"),
					resultSet.getString("TSDESCEU"),
					resultSet.getBigDecimal("TSORDEN"),
					resultSet.getBigDecimal("TSGRUPO"),
					resultSet.getString("TSTEXTOES"),
					resultSet.getString("TSTEXTOEU"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Tipsubsana table.
	 * 
	 * @param tipsubsana
	 *            Pagination
	 * @return Tipsubsana
	 */
	public Tipsubsana add(Tipsubsana tipsubsana) {
		String query = "INSERT INTO TIPSUBSANA (TSID, TSDESCES, TSDESCEU, TSTEXTOES, TSTEXTOEU, TSORDEN, TSGRUPO) VALUES (?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, tipsubsana.getTsid(),
				tipsubsana.getTsdesces(), tipsubsana.getTsdesceu(),
				tipsubsana.getTstextoes(), tipsubsana.getTstextoeu(),
				tipsubsana.getTsorden(), tipsubsana.getTsgrupo());
		return tipsubsana;
	}

	/**
	 * Updates a single row in the Tipsubsana table.
	 * 
	 * @param tipsubsana
	 *            Pagination
	 * @return Tipsubsana
	 */
	public Tipsubsana update(Tipsubsana tipsubsana) {
		String query = "UPDATE TIPSUBSANA SET TSDESCES=?, TSDESCEU=?, TSTEXTOES=?, TSTEXTOEU=?, TSORDEN=?, TSGRUPO=? WHERE TSID=?";
		this.jdbcTemplate.update(query, tipsubsana.getTsdesces(),
				tipsubsana.getTsdesceu(), tipsubsana.getTstextoes(),
				tipsubsana.getTstextoeu(), tipsubsana.getTsorden(),
				tipsubsana.getTsgrupo(), tipsubsana.getTsid());
		return tipsubsana;
	}

	/**
	 * Finds a single row in the Tipsubsana table.
	 * 
	 * @param tipsubsana
	 *            Pagination
	 * @return Tipsubsana
	 */
	@Transactional(readOnly = true)
	public Tipsubsana find(Tipsubsana tipsubsana) {
		String query = "SELECT t1.TSID TSID, t1.TSDESCES TSDESCES, t1.TSDESCEU TSDESCEU, t1.TSTEXTOES TSTEXTOES, t1.TSTEXTOEU TSTEXTOEU, t1.TSORDEN TSORDEN, t1.TSGRUPO TSGRUPO FROM TIPSUBSANA t1  WHERE t1.TSID = ?  ";

		List<Tipsubsana> tipsubsanaList = this.jdbcTemplate.query(query,
				this.rwMap, tipsubsana.getTsid());
		return (Tipsubsana) DataAccessUtils.uniqueResult(tipsubsanaList);
	}

	/**
	 * Removes a single row in the Tipsubsana table.
	 * 
	 * @param tipsubsana
	 *            Pagination
	 * @return
	 */
	public void remove(Tipsubsana tipsubsana) {
		String query = "DELETE FROM TIPSUBSANA WHERE TSID=?";
		this.jdbcTemplate.update(query, tipsubsana.getTsid());
	}

	/**
	 * Finds a List of rows in the Tipsubsana table.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tipsubsana> findAll(Tipsubsana tipsubsana, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TSID TSID,t1.TSDESCES TSDESCES,t1.TSDESCEU TSDESCEU,t1.TSTEXTOES TSTEXTOES,t1.TSTEXTOEU TSTEXTOEU,t1.TSORDEN TSORDEN,t1.TSGRUPO TSGRUPO ");
		query.append("FROM TIPSUBSANA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tipsubsana);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Tipsubsana>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Tipsubsana table.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Tipsubsana tipsubsana) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM TIPSUBSANA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tipsubsana);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Tipsubsana table using like.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tipsubsana> findAllLike(Tipsubsana tipsubsana,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TSID TSID,t1.TSDESCES TSDESCES,t1.TSDESCEU TSDESCEU,t1.TSTEXTOES TSTEXTOES,t1.TSTEXTOEU TSTEXTOEU,t1.TSORDEN TSORDEN,t1.TSGRUPO TSGRUPO ");
		query.append("FROM TIPSUBSANA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tipsubsana, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Tipsubsana>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Tipsubsana table using like.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Tipsubsana tipsubsana, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM TIPSUBSANA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tipsubsana, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Tipsubsana entity
	 * 
	 * @param tipsubsana
	 *            Tipsubsana Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Tipsubsana tipsubsana) {

		StringBuilder where = new StringBuilder(
				TipsubsanaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tipsubsana != null && tipsubsana.getTsid() != null) {
			where.append(" AND t1.TSID = ?");
			params.add(tipsubsana.getTsid());
		}
		if (tipsubsana != null && tipsubsana.getTsdesces() != null) {
			where.append(" AND t1.TSDESCES = ?");
			params.add(tipsubsana.getTsdesces());
		}
		if (tipsubsana != null && tipsubsana.getTsdesceu() != null) {
			where.append(" AND t1.TSDESCEU = ?");
			params.add(tipsubsana.getTsdesceu());
		}
		if (tipsubsana != null && tipsubsana.getTstextoes() != null) {
			where.append(" AND t1.TSTEXTOES = ?");
			params.add(tipsubsana.getTstextoes());
		}
		if (tipsubsana != null && tipsubsana.getTstextoeu() != null) {
			where.append(" AND t1.TSTEXTOEU = ?");
			params.add(tipsubsana.getTstextoeu());
		}
		if (tipsubsana != null && tipsubsana.getTsorden() != null) {
			where.append(" AND t1.TSORDEN = ?");
			params.add(tipsubsana.getTsorden());
		}
		if (tipsubsana != null && tipsubsana.getTsgrupo() != null) {
			where.append(" AND t1.TSGRUPO = ?");
			params.add(tipsubsana.getTsgrupo());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Tipsubsana entity
	 * 
	 * @param tipsubsana
	 *            Tipsubsana Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Tipsubsana tipsubsana,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				TipsubsanaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tipsubsana != null && tipsubsana.getTsid() != null) {
			where.append(" AND UPPER(t1.TSID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipsubsana.getTsid().toUpperCase() + "%");
			} else {
				params.add("%" + tipsubsana.getTsid().toUpperCase() + "%");
			}
			where.append(" AND t1.TSID IS NOT NULL");
		}
		if (tipsubsana != null && tipsubsana.getTsdesces() != null) {
			where.append(" AND UPPER(t1.TSDESCES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipsubsana.getTsdesces().toUpperCase() + "%");
			} else {
				params.add("%" + tipsubsana.getTsdesces().toUpperCase() + "%");
			}
			where.append(" AND t1.TSDESCES IS NOT NULL");
		}
		if (tipsubsana != null && tipsubsana.getTsdesceu() != null) {
			where.append(" AND UPPER(t1.TSDESCEU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipsubsana.getTsdesceu().toUpperCase() + "%");
			} else {
				params.add("%" + tipsubsana.getTsdesceu().toUpperCase() + "%");
			}
			where.append(" AND t1.TSDESCEU IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * @param trid
	 */
	public List<Tipsubsana> findAllPorTramite(Tipsubsana tipsubsana,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TSID TSID,t1.TSDESCES TSDESCES,t1.TSDESCEU TSDESCEU,t1.TSTEXTOES TSTEXTOES,t1.TSTEXTOEU TSTEXTOEU,t1.TSORDEN TSORDEN,t1.TSGRUPO TSGRUPO ");
		query.append(" FROM TIPSUBSANA t1, ARBTRAMTSUBS t2 ");
		query.append(" WHERE 1=1 AND t1.TSID=t2.XDTSID AND t2.XDTRID=?");
		List<Object> params = new ArrayList<Object>();
		params.add(tipsubsana.getTipsubsanaByTrid());
		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		return (List<Tipsubsana>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());

	}
}
