package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;

import java.util.List;

import com.ejie.y41b.model.Tipsubsana;

/**
 * TipsubsanaDao  
 * 
 *  
 */

public interface TipsubsanaDao {

	/**
	 * Inserts a single row in the Tipsubsana table.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @return Tipsubsana
	 */
	Tipsubsana add(Tipsubsana tipsubsana);

	/**
	 * Updates a single row in the Tipsubsana table.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @return Tipsubsana
	 */
	Tipsubsana update(Tipsubsana tipsubsana);

	/**
	 * Finds a single row in the Tipsubsana table.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @return Tipsubsana
	 */
	Tipsubsana find(Tipsubsana tipsubsana);

	/**
	 * Deletes a single row in the Tipsubsana table.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @return
	 */
	void remove(Tipsubsana tipsubsana);

	/**
	 * Finds a List of rows in the Tipsubsana table.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Tipsubsana> findAll(Tipsubsana tipsubsana, Pagination pagination);

	/**
	 * Counts rows in the Tipsubsana table.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @return Long
	 */
	Long findAllCount(Tipsubsana tipsubsana);

	/**
	 * Finds rows in the Tipsubsana table using like.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Tipsubsana> findAllLike(Tipsubsana tipsubsana, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Tipsubsana table using like.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Tipsubsana tipsubsana, Boolean startsWith);

	/**
	 * @param tipsubsana
	 * @return List<Tipsubsana>
	 */
	List<Tipsubsana> findAllPorTramite(Tipsubsana tipsubsana,
			Pagination pagination);
}
