package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Tiposerrores;

/**
 * TiposerroresDaoImpl  
 *  
 */
 
@Repository
@Transactional
public class TiposerroresDaoImpl implements TiposerroresDao {
    private JdbcTemplate jdbcTemplate;
	private RowMapper<Tiposerrores> rwMap = new RowMapper<Tiposerrores>() {
		public Tiposerrores mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Tiposerrores(
               resultSet.getString("SJCODIGO"), resultSet.getString("SJCONSTANTE"), resultSet.getString("SJTEXTOES"), resultSet.getString("SJTEXTOEU"), resultSet.getString("SJEXPLICACIONES"), resultSet.getString("SJEXPLICACIONEU")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the Tiposerrores table.
     *
     * @param tiposerrores Pagination
     * @return Tiposerrores
     */
	public Tiposerrores add(Tiposerrores tiposerrores) {
    	String query = "INSERT INTO TIPOSERRORES (SJCODIGO, SJCONSTANTE, SJTEXTOES, SJTEXTOEU, SJEXPLICACIONES, SJEXPLICACIONEU) VALUES (?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, tiposerrores.getSjcodigo(), tiposerrores.getSjconstante(), tiposerrores.getSjtextoes(), tiposerrores.getSjtextoeu(), tiposerrores.getSjexplicaciones(), tiposerrores.getSjexplicacioneu());
		return tiposerrores;
	}

    /**
     * Updates a single row in the Tiposerrores table.
     *
     * @param tiposerrores Pagination
     * @return Tiposerrores
     */
    public Tiposerrores update(Tiposerrores tiposerrores) {
		String query = "UPDATE TIPOSERRORES SET SJCONSTANTE=?, SJTEXTOES=?, SJTEXTOEU=?, SJEXPLICACIONES=?, SJEXPLICACIONEU=? WHERE SJCODIGO=?";
		this.jdbcTemplate.update(query, tiposerrores.getSjconstante(), tiposerrores.getSjtextoes(), tiposerrores.getSjtextoeu(), tiposerrores.getSjexplicaciones(), tiposerrores.getSjexplicacioneu(), tiposerrores.getSjcodigo());
		return tiposerrores;
	}

    /**
     * Finds a single row in the Tiposerrores table.
     *
     * @param tiposerrores Pagination
     * @return Tiposerrores
     */
    @Transactional (readOnly = true)
    public Tiposerrores find(Tiposerrores tiposerrores) {
		String query = "SELECT t1.SJCODIGO SJCODIGO, t1.SJCONSTANTE SJCONSTANTE, t1.SJTEXTOES SJTEXTOES, t1.SJTEXTOEU SJTEXTOEU, t1.SJEXPLICACIONES SJEXPLICACIONES, t1.SJEXPLICACIONEU SJEXPLICACIONEU FROM TIPOSERRORES t1  WHERE t1.SJCODIGO = ?  ";
		
		List<Tiposerrores> tiposerroresList = this.jdbcTemplate.query(query, this.rwMap, tiposerrores.getSjcodigo());
		return (Tiposerrores) DataAccessUtils.uniqueResult(tiposerroresList);
    }

    /**
     * Removes a single row in the Tiposerrores table.
     *
     * @param tiposerrores Pagination
     * @return
     */
    public void remove(Tiposerrores tiposerrores) {
		String query = "DELETE FROM TIPOSERRORES WHERE SJCODIGO=?";
		this.jdbcTemplate.update(query, tiposerrores.getSjcodigo());
    }
    
   /**
    * Finds a List of rows in the Tiposerrores table.
    * 
    * @param tiposerrores Tiposerrores
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<Tiposerrores> findAll(Tiposerrores tiposerrores, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.SJCODIGO SJCODIGO,t1.SJCONSTANTE SJCONSTANTE,t1.SJTEXTOES SJTEXTOES,t1.SJTEXTOEU SJTEXTOEU,t1.SJEXPLICACIONES SJEXPLICACIONES,t1.SJEXPLICACIONEU SJEXPLICACIONEU "); 
		query.append("FROM TIPOSERRORES t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tiposerrores); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Tiposerrores>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the Tiposerrores table.
     * 
     * @param tiposerrores Tiposerrores
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Tiposerrores tiposerrores) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM TIPOSERRORES t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tiposerrores); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the Tiposerrores table using like.
     * 
     * @param tiposerrores Tiposerrores
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<Tiposerrores> findAllLike(Tiposerrores tiposerrores, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.SJCODIGO SJCODIGO,t1.SJCONSTANTE SJCONSTANTE,t1.SJTEXTOES SJTEXTOES,t1.SJTEXTOEU SJTEXTOEU,t1.SJEXPLICACIONES SJEXPLICACIONES,t1.SJEXPLICACIONEU SJEXPLICACIONEU "); 
        query.append("FROM TIPOSERRORES t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tiposerrores,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Tiposerrores>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Counts rows in the Tiposerrores table using like.
     * 
     * @param tiposerrores Tiposerrores
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(Tiposerrores tiposerrores, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM TIPOSERRORES t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tiposerrores,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the Tiposerrores entity 
	 * 
	 * @param tiposerrores Tiposerrores
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (Tiposerrores tiposerrores){
		
		StringBuilder where = new StringBuilder(TiposerroresDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tiposerrores  != null  && tiposerrores.getSjcodigo() != null ) {
			where.append(" AND t1.SJCODIGO = ?");
			params.add(tiposerrores.getSjcodigo());
		}
		if (tiposerrores  != null  && tiposerrores.getSjconstante() != null ) {
			where.append(" AND t1.SJCONSTANTE = ?");
			params.add(tiposerrores.getSjconstante());
		}
		if (tiposerrores  != null  && tiposerrores.getSjtextoes() != null ) {
			where.append(" AND t1.SJTEXTOES = ?");
			params.add(tiposerrores.getSjtextoes());
		}
		if (tiposerrores  != null  && tiposerrores.getSjtextoeu() != null ) {
			where.append(" AND t1.SJTEXTOEU = ?");
			params.add(tiposerrores.getSjtextoeu());
		}
		if (tiposerrores  != null  && tiposerrores.getSjexplicaciones() != null ) {
			where.append(" AND t1.SJEXPLICACIONES = ?");
			params.add(tiposerrores.getSjexplicaciones());
		}
		if (tiposerrores  != null  && tiposerrores.getSjexplicacioneu() != null ) {
			where.append(" AND t1.SJEXPLICACIONEU = ?");
			params.add(tiposerrores.getSjexplicacioneu());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the Tiposerrores entity 
	 * 
	 * @param tiposerrores Tiposerrores
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap (Tiposerrores tiposerrores, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(TiposerroresDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tiposerrores  != null  && tiposerrores.getSjcodigo() != null ) {
			where.append(" AND UPPER(t1.SJCODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tiposerrores.getSjcodigo().toUpperCase() +"%");
			}else{
				params.add("%"+tiposerrores.getSjcodigo().toUpperCase() +"%");
			}
			where.append(" AND t1.SJCODIGO IS NOT NULL");
	     }			
		if (tiposerrores  != null  && tiposerrores.getSjconstante() != null ) {
			where.append(" AND UPPER(t1.SJCONSTANTE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tiposerrores.getSjconstante().toUpperCase() +"%");
			}else{
				params.add("%"+tiposerrores.getSjconstante().toUpperCase() +"%");
			}
			where.append(" AND t1.SJCONSTANTE IS NOT NULL");
	     }			
		if (tiposerrores  != null  && tiposerrores.getSjtextoes() != null ) {
			where.append(" AND UPPER(t1.SJTEXTOES) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tiposerrores.getSjtextoes().toUpperCase() +"%");
			}else{
				params.add("%"+tiposerrores.getSjtextoes().toUpperCase() +"%");
			}
			where.append(" AND t1.SJTEXTOES IS NOT NULL");
	     }			
		if (tiposerrores  != null  && tiposerrores.getSjtextoeu() != null ) {
			where.append(" AND UPPER(t1.SJTEXTOEU) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tiposerrores.getSjtextoeu().toUpperCase() +"%");
			}else{
				params.add("%"+tiposerrores.getSjtextoeu().toUpperCase() +"%");
			}
			where.append(" AND t1.SJTEXTOEU IS NOT NULL");
	     }			
		if (tiposerrores  != null  && tiposerrores.getSjexplicaciones() != null ) {
			where.append(" AND UPPER(t1.SJEXPLICACIONES) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tiposerrores.getSjexplicaciones().toUpperCase() +"%");
			}else{
				params.add("%"+tiposerrores.getSjexplicaciones().toUpperCase() +"%");
			}
			where.append(" AND t1.SJEXPLICACIONES IS NOT NULL");
	     }			
		if (tiposerrores  != null  && tiposerrores.getSjexplicacioneu() != null ) {
			where.append(" AND UPPER(t1.SJEXPLICACIONEU) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tiposerrores.getSjexplicacioneu().toUpperCase() +"%");
			}else{
				params.add("%"+tiposerrores.getSjexplicacioneu().toUpperCase() +"%");
			}
			where.append(" AND t1.SJEXPLICACIONEU IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

