package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Tipopronunciamento;

/**
 * TipopronunciamentoDaoImpl  
 *  
 */
 
@Repository
@Transactional
public class TipopronunciamentoDaoImpl implements TipopronunciamentoDao {
    private JdbcTemplate jdbcTemplate;
	private RowMapper<Tipopronunciamento> rwMap = new RowMapper<Tipopronunciamento>() {
		public Tipopronunciamento mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Tipopronunciamento(
               resultSet.getString("TTPCODIGO"), resultSet.getString("TTPNOMBRE")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the Tipopronunciamento table.
     *
     * @param tipopronunciamento Pagination
     * @return Tipopronunciamento
     */
	public Tipopronunciamento add(Tipopronunciamento tipopronunciamento) {
    	String query = "INSERT INTO TIPOPRONUNCIAMENTO (TTPCODIGO, TTPNOMBRE) VALUES (?,?)";
		this.jdbcTemplate.update(query, tipopronunciamento.getTtpcodigo(), tipopronunciamento.getTtpnombre());
		return tipopronunciamento;
	}

    /**
     * Updates a single row in the Tipopronunciamento table.
     *
     * @param tipopronunciamento Pagination
     * @return Tipopronunciamento
     */
    public Tipopronunciamento update(Tipopronunciamento tipopronunciamento) {
		String query = "UPDATE TIPOPRONUNCIAMENTO SET TTPNOMBRE=? WHERE TTPCODIGO=?";
		this.jdbcTemplate.update(query, tipopronunciamento.getTtpnombre(), tipopronunciamento.getTtpcodigo());
		return tipopronunciamento;
	}

    /**
     * Finds a single row in the Tipopronunciamento table.
     *
     * @param tipopronunciamento Pagination
     * @return Tipopronunciamento
     */
    @Transactional (readOnly = true)
    public Tipopronunciamento find(Tipopronunciamento tipopronunciamento) {
		String query = "SELECT t1.TTPCODIGO TTPCODIGO, t1.TTPNOMBRE TTPNOMBRE FROM TIPOPRONUNCIAMENTO t1  WHERE t1.TTPCODIGO = ?  ";
		
		List<Tipopronunciamento> tipopronunciamentoList = this.jdbcTemplate.query(query, this.rwMap, tipopronunciamento.getTtpcodigo());
		return (Tipopronunciamento) DataAccessUtils.uniqueResult(tipopronunciamentoList);
    }

    /**
     * Removes a single row in the Tipopronunciamento table.
     *
     * @param tipopronunciamento Pagination
     * @return
     */
    public void remove(Tipopronunciamento tipopronunciamento) {
		String query = "DELETE FROM TIPOPRONUNCIAMENTO WHERE TTPCODIGO=?";
		this.jdbcTemplate.update(query, tipopronunciamento.getTtpcodigo());
    }
    
   /**
    * Finds a List of rows in the Tipopronunciamento table.
    * 
    * @param tipopronunciamento Tipopronunciamento
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<Tipopronunciamento> findAll(Tipopronunciamento tipopronunciamento, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.TTPCODIGO TTPCODIGO,t1.TTPNOMBRE TTPNOMBRE "); 
		query.append("FROM TIPOPRONUNCIAMENTO t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tipopronunciamento); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Tipopronunciamento>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the Tipopronunciamento table.
     * 
     * @param tipopronunciamento Tipopronunciamento
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Tipopronunciamento tipopronunciamento) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM TIPOPRONUNCIAMENTO t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tipopronunciamento); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the Tipopronunciamento table using like.
     * 
     * @param tipopronunciamento Tipopronunciamento
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<Tipopronunciamento> findAllLike(Tipopronunciamento tipopronunciamento, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.TTPCODIGO TTPCODIGO,t1.TTPNOMBRE TTPNOMBRE "); 
        query.append("FROM TIPOPRONUNCIAMENTO t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tipopronunciamento,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Tipopronunciamento>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Counts rows in the Tipopronunciamento table using like.
     * 
     * @param tipopronunciamento Tipopronunciamento
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(Tipopronunciamento tipopronunciamento, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM TIPOPRONUNCIAMENTO t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tipopronunciamento,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the Tipopronunciamento entity 
	 * 
	 * @param tipopronunciamento Tipopronunciamento
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (Tipopronunciamento tipopronunciamento){
		
		StringBuilder where = new StringBuilder(TipopronunciamentoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tipopronunciamento  != null  && tipopronunciamento.getTtpcodigo() != null ) {
			where.append(" AND t1.TTPCODIGO = ?");
			params.add(tipopronunciamento.getTtpcodigo());
		}
		if (tipopronunciamento  != null  && tipopronunciamento.getTtpnombre() != null ) {
			where.append(" AND t1.TTPNOMBRE = ?");
			params.add(tipopronunciamento.getTtpnombre());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the Tipopronunciamento entity 
	 * 
	 * @param tipopronunciamento Tipopronunciamento
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap (Tipopronunciamento tipopronunciamento, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(TipopronunciamentoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tipopronunciamento  != null  && tipopronunciamento.getTtpcodigo() != null ) {
			where.append(" AND UPPER(t1.TTPCODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipopronunciamento.getTtpcodigo().toUpperCase() +"%");
			}else{
				params.add("%"+tipopronunciamento.getTtpcodigo().toUpperCase() +"%");
			}
			where.append(" AND t1.TTPCODIGO IS NOT NULL");
	     }			
		if (tipopronunciamento  != null  && tipopronunciamento.getTtpnombre() != null ) {
			where.append(" AND UPPER(t1.TTPNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipopronunciamento.getTtpnombre().toUpperCase() +"%");
			}else{
				params.add("%"+tipopronunciamento.getTtpnombre().toUpperCase() +"%");
			}
			where.append(" AND t1.TTPNOMBRE IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

