package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Tipomovimientos;

/**
 * TipomovimientosDaoImpl  
 *  
 */
 
@Repository
@Transactional
public class TipomovimientosDaoImpl implements TipomovimientosDao {
    private JdbcTemplate jdbcTemplate;
	private RowMapper<Tipomovimientos> rwMap = new RowMapper<Tipomovimientos>() {
		public Tipomovimientos mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Tipomovimientos(
               resultSet.getString("SECODIGO"), resultSet.getString("SEDESCES"), resultSet.getString("SEDESCEU")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the Tipomovimientos table.
     *
     * @param tipomovimientos Pagination
     * @return Tipomovimientos
     */
	public Tipomovimientos add(Tipomovimientos tipomovimientos) {
    	String query = "INSERT INTO TIPOMOVIMIENTOS (SECODIGO, SEDESCES, SEDESCEU) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, tipomovimientos.getSecodigo(), tipomovimientos.getSedesces(), tipomovimientos.getSedesceu());
		return tipomovimientos;
	}

    /**
     * Updates a single row in the Tipomovimientos table.
     *
     * @param tipomovimientos Pagination
     * @return Tipomovimientos
     */
    public Tipomovimientos update(Tipomovimientos tipomovimientos) {
		String query = "UPDATE TIPOMOVIMIENTOS SET SEDESCES=?, SEDESCEU=? WHERE SECODIGO=?";
		this.jdbcTemplate.update(query, tipomovimientos.getSedesces(), tipomovimientos.getSedesceu(), tipomovimientos.getSecodigo());
		return tipomovimientos;
	}

    /**
     * Finds a single row in the Tipomovimientos table.
     *
     * @param tipomovimientos Pagination
     * @return Tipomovimientos
     */
    @Transactional (readOnly = true)
    public Tipomovimientos find(Tipomovimientos tipomovimientos) {
		String query = "SELECT t1.SECODIGO SECODIGO, t1.SEDESCES SEDESCES, t1.SEDESCEU SEDESCEU FROM TIPOMOVIMIENTOS t1  WHERE t1.SECODIGO = ?  ";
		
		List<Tipomovimientos> tipomovimientosList = this.jdbcTemplate.query(query, this.rwMap, tipomovimientos.getSecodigo());
		return (Tipomovimientos) DataAccessUtils.uniqueResult(tipomovimientosList);
    }

    /**
     * Removes a single row in the Tipomovimientos table.
     *
     * @param tipomovimientos Pagination
     * @return
     */
    public void remove(Tipomovimientos tipomovimientos) {
		String query = "DELETE FROM TIPOMOVIMIENTOS WHERE SECODIGO=?";
		this.jdbcTemplate.update(query, tipomovimientos.getSecodigo());
    }
    
   /**
    * Finds a List of rows in the Tipomovimientos table.
    * 
    * @param tipomovimientos Tipomovimientos
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<Tipomovimientos> findAll(Tipomovimientos tipomovimientos, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.SECODIGO SECODIGO,t1.SEDESCES SEDESCES,t1.SEDESCEU SEDESCEU "); 
		query.append("FROM TIPOMOVIMIENTOS t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tipomovimientos); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Tipomovimientos>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the Tipomovimientos table.
     * 
     * @param tipomovimientos Tipomovimientos
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Tipomovimientos tipomovimientos) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM TIPOMOVIMIENTOS t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tipomovimientos); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the Tipomovimientos table using like.
     * 
     * @param tipomovimientos Tipomovimientos
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<Tipomovimientos> findAllLike(Tipomovimientos tipomovimientos, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.SECODIGO SECODIGO,t1.SEDESCES SEDESCES,t1.SEDESCEU SEDESCEU "); 
        query.append("FROM TIPOMOVIMIENTOS t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tipomovimientos,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Tipomovimientos>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Counts rows in the Tipomovimientos table using like.
     * 
     * @param tipomovimientos Tipomovimientos
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(Tipomovimientos tipomovimientos, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM TIPOMOVIMIENTOS t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tipomovimientos,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the Tipomovimientos entity 
	 * 
	 * @param tipomovimientos Tipomovimientos
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (Tipomovimientos tipomovimientos){
		
		StringBuilder where = new StringBuilder(TipomovimientosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tipomovimientos  != null  && tipomovimientos.getSecodigo() != null ) {
			where.append(" AND t1.SECODIGO = ?");
			params.add(tipomovimientos.getSecodigo());
		}
		if (tipomovimientos  != null  && tipomovimientos.getSedesces() != null ) {
			where.append(" AND t1.SEDESCES = ?");
			params.add(tipomovimientos.getSedesces());
		}
		if (tipomovimientos  != null  && tipomovimientos.getSedesceu() != null ) {
			where.append(" AND t1.SEDESCEU = ?");
			params.add(tipomovimientos.getSedesceu());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the Tipomovimientos entity 
	 * 
	 * @param tipomovimientos Tipomovimientos
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap (Tipomovimientos tipomovimientos, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(TipomovimientosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tipomovimientos  != null  && tipomovimientos.getSecodigo() != null ) {
			where.append(" AND UPPER(t1.SECODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipomovimientos.getSecodigo().toUpperCase() +"%");
			}else{
				params.add("%"+tipomovimientos.getSecodigo().toUpperCase() +"%");
			}
			where.append(" AND t1.SECODIGO IS NOT NULL");
	     }			
		if (tipomovimientos  != null  && tipomovimientos.getSedesces() != null ) {
			where.append(" AND UPPER(t1.SEDESCES) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipomovimientos.getSedesces().toUpperCase() +"%");
			}else{
				params.add("%"+tipomovimientos.getSedesces().toUpperCase() +"%");
			}
			where.append(" AND t1.SEDESCES IS NOT NULL");
	     }			
		if (tipomovimientos  != null  && tipomovimientos.getSedesceu() != null ) {
			where.append(" AND UPPER(t1.SEDESCEU) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipomovimientos.getSedesceu().toUpperCase() +"%");
			}else{
				params.add("%"+tipomovimientos.getSedesceu().toUpperCase() +"%");
			}
			where.append(" AND t1.SEDESCEU IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

