package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Claseingreso;
import com.ejie.y41b.model.Tipoconceptopago;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * TipoconceptopagoDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class TipoconceptopagoDaoImpl implements TipoconceptopagoDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Tipoconceptopago> rwMap = new RowMapper<Tipoconceptopago>() {
		public Tipoconceptopago mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Tipoconceptopago(resultSet.getString("SCCODIGO"),
					resultSet.getString("SCDESCES"),
					resultSet.getString("SCDESCEU"), new Claseingreso(
							resultSet.getString("CLASEINGRESOSLCODIGO"),
							resultSet.getString("CLASEINGRESOSLDESCES"),
							resultSet.getString("CLASEINGRESOSLDESCEU")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Tipoconceptopago table.
	 * 
	 * @param tipoconceptopago
	 *            Pagination
	 * @return Tipoconceptopago
	 */
	public Tipoconceptopago add(Tipoconceptopago tipoconceptopago) {
		String query = "INSERT INTO TIPOCONCEPTOPAGO (SCCODIGO, SCDESCES, SCDESCEU, SCCLASE) VALUES (?,?,?,?)";
		this.jdbcTemplate.update(query, tipoconceptopago.getSccodigo(),
				tipoconceptopago.getScdesces(), tipoconceptopago.getScdesceu(),
				tipoconceptopago.getClaseingreso().getSlcodigo());
		return tipoconceptopago;
	}

	/**
	 * Updates a single row in the Tipoconceptopago table.
	 * 
	 * @param tipoconceptopago
	 *            Pagination
	 * @return Tipoconceptopago
	 */
	public Tipoconceptopago update(Tipoconceptopago tipoconceptopago) {
		String query = "UPDATE TIPOCONCEPTOPAGO SET SCDESCES=?, SCDESCEU=?, SCCLASE=? WHERE SCCODIGO=?";
		this.jdbcTemplate.update(query, tipoconceptopago.getScdesces(),
				tipoconceptopago.getScdesceu(), tipoconceptopago
						.getClaseingreso().getSlcodigo(), tipoconceptopago
						.getSccodigo());
		return tipoconceptopago;
	}

	/**
	 * Finds a single row in the Tipoconceptopago table.
	 * 
	 * @param tipoconceptopago
	 *            Pagination
	 * @return Tipoconceptopago
	 */
	@Transactional(readOnly = true)
	public Tipoconceptopago find(Tipoconceptopago tipoconceptopago) {
		String query = "SELECT t1.SCCODIGO SCCODIGO, t1.SCDESCES SCDESCES, t1.SCDESCEU SCDESCEU, t2.SLCODIGO CLASEINGRESOSLCODIGO, t2.SLDESCES CLASEINGRESOSLDESCES, t2.SLDESCEU CLASEINGRESOSLDESCEU FROM TIPOCONCEPTOPAGO t1, CLASEINGRESO t2  WHERE t1.SCCLASE=t2.SLCODIGO AND t1.SCCODIGO = ?  ";

		List<Tipoconceptopago> tipoconceptopagoList = this.jdbcTemplate.query(
				query, this.rwMap, tipoconceptopago.getSccodigo());
		return (Tipoconceptopago) DataAccessUtils
				.uniqueResult(tipoconceptopagoList);
	}

	/**
	 * Removes a single row in the Tipoconceptopago table.
	 * 
	 * @param tipoconceptopago
	 *            Pagination
	 * @return
	 */
	public void remove(Tipoconceptopago tipoconceptopago) {
		String query = "DELETE FROM TIPOCONCEPTOPAGO WHERE SCCODIGO=?";
		this.jdbcTemplate.update(query, tipoconceptopago.getSccodigo());
	}

	/**
	 * Finds a List of rows in the Tipoconceptopago table.
	 * 
	 * @param tipoconceptopago
	 *            Tipoconceptopago
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tipoconceptopago> findAll(Tipoconceptopago tipoconceptopago,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.SCCODIGO SCCODIGO,t1.SCDESCES SCDESCES,t1.SCDESCEU SCDESCEU, t1.SCCLASE SCCLASE, t2.SLCODIGO CLASEINGRESOSLCODIGO, t2.SLDESCES CLASEINGRESOSLDESCES, t2.SLDESCEU CLASEINGRESOSLDESCEU FROM TIPOCONCEPTOPAGO t1, CLASEINGRESO t2  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tipoconceptopago);
		StringBuilder where = new StringBuilder(
				" WHERE t1.SCCLASE=t2.SLCODIGO AND 1=1   ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Tipoconceptopago>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Tipoconceptopago table.
	 * 
	 * @param tipoconceptopago
	 *            Tipoconceptopago
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Tipoconceptopago tipoconceptopago) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM TIPOCONCEPTOPAGO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tipoconceptopago);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Tipoconceptopago table using like.
	 * 
	 * @param tipoconceptopago
	 *            Tipoconceptopago
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tipoconceptopago> findAllLike(
			Tipoconceptopago tipoconceptopago, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.SCCODIGO SCCODIGO,t1.SCDESCES SCDESCES,t1.SCDESCEU SCDESCEU, t1.SCCLASE SCCLASE, t2.SLCODIGO CLASEINGRESOSLCODIGO, t2.SLDESCES CLASEINGRESOSLDESCES, t2.SLDESCEU CLASEINGRESOSLDESCEU FROM TIPOCONCEPTOPAGO t1, CLASEINGRESO t2  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tipoconceptopago,
				startsWith);
		StringBuilder where = new StringBuilder(
				"  WHERE t1.SCCLASE=t2.SLCODIGO AND 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Tipoconceptopago>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Tipoconceptopago table using like.
	 * 
	 * @param tipoconceptopago
	 *            Tipoconceptopago
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Tipoconceptopago tipoconceptopago,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM TIPOCONCEPTOPAGO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tipoconceptopago,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Tipoconceptopago entity
	 * 
	 * @param tipoconceptopago
	 *            Tipoconceptopago Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Tipoconceptopago tipoconceptopago) {

		StringBuilder where = new StringBuilder(
				TipoconceptopagoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tipoconceptopago != null && tipoconceptopago.getSccodigo() != null) {
			where.append(" AND t1.SCCODIGO = ?");
			params.add(tipoconceptopago.getSccodigo());
		}
		if (tipoconceptopago != null && tipoconceptopago.getScdesces() != null) {
			where.append(" AND t1.SCDESCES = ?");
			params.add(tipoconceptopago.getScdesces());
		}
		if (tipoconceptopago != null && tipoconceptopago.getScdesceu() != null) {
			where.append(" AND t1.SCDESCEU = ?");
			params.add(tipoconceptopago.getScdesceu());
		}
		if (tipoconceptopago != null
				&& tipoconceptopago.getClaseingreso().getSlcodigo() != null) {
			where.append(" AND t2.SLCODIGO = ?");
			params.add(tipoconceptopago.getClaseingreso().getSlcodigo());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Tipoconceptopago entity
	 * 
	 * @param tipoconceptopago
	 *            Tipoconceptopago Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Tipoconceptopago tipoconceptopago,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				TipoconceptopagoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tipoconceptopago != null && tipoconceptopago.getSccodigo() != null) {
			where.append(" AND UPPER(t1.SCCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoconceptopago.getSccodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tipoconceptopago.getSccodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SCCODIGO IS NOT NULL");
		}
		if (tipoconceptopago != null && tipoconceptopago.getScdesces() != null) {
			where.append(" AND UPPER(t1.SCDESCES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoconceptopago.getScdesces().toUpperCase() + "%");
			} else {
				params.add("%" + tipoconceptopago.getScdesces().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SCDESCES IS NOT NULL");
		}
		if (tipoconceptopago != null && tipoconceptopago.getScdesceu() != null) {
			where.append(" AND UPPER(t1.SCDESCEU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoconceptopago.getScdesceu().toUpperCase() + "%");
			} else {
				params.add("%" + tipoconceptopago.getScdesceu().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SCDESCEU IS NOT NULL");
		}
		if (tipoconceptopago != null
				&& tipoconceptopago.getClaseingreso() != null
				&& tipoconceptopago.getClaseingreso().getSlcodigo() != null) {
			where.append(" AND UPPER(t1.SCCLASE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoconceptopago.getClaseingreso().getSlcodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tipoconceptopago.getClaseingreso().getSlcodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.SCCLASE IS NOT NULL");
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewPK() {
		try {
			List<Object> params = new ArrayList<Object>();

			StringBuffer query = new StringBuffer(
					"SELECT L21SCQ00.NEXTVAL FROM  DUAL ");
			return this.jdbcTemplate.queryForLong(query.toString(),
					params.toArray());
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
