package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.TipoRespuesta;

/**
 * * TipoRespuestaDao  
 * 
 *  
 */

public interface TipoRespuestaDao {

	/**
	 * Inserts a single row in the TipoRespuesta table.
	 * 
	 * @param tiporespuesta
	 *            TipoRespuesta
	 * @return TipoRespuesta
	 */
	TipoRespuesta add(TipoRespuesta tiporespuesta);

	/**
	 * Updates a single row in the TipoRespuesta table.
	 * 
	 * @param tiporespuesta
	 *            TipoRespuesta
	 * @return TipoRespuesta
	 */
	TipoRespuesta update(TipoRespuesta tiporespuesta);

	/**
	 * Finds a single row in the TipoRespuesta table.
	 * 
	 * @param tiporespuesta
	 *            TipoRespuesta
	 * @return TipoRespuesta
	 */
	TipoRespuesta find(TipoRespuesta tiporespuesta);

	/**
	 * Deletes a single row in the TipoRespuesta table.
	 * 
	 * @param tiporespuesta
	 *            TipoRespuesta
	 * @return
	 */
	void remove(TipoRespuesta tiporespuesta);

	/**
	 * Finds a List of rows in the TipoRespuesta table.
	 * 
	 * @param tiporespuesta
	 *            TipoRespuesta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<TipoRespuesta> findAll(TipoRespuesta tiporespuesta,
			Pagination pagination);

	/**
	 * Counts rows in the TipoRespuesta table.
	 * 
	 * @param tiporespuesta
	 *            TipoRespuesta
	 * @return List
	 */
	Long findAllCount(TipoRespuesta tiporespuesta);

	/**
	 * Finds rows in the TipoRespuesta table using like.
	 * 
	 * @param tiporespuesta
	 *            TipoRespuesta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<TipoRespuesta> findAllLike(TipoRespuesta tiporespuesta,
			Pagination pagination, Boolean startsWith);
}
