package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.TipoReclamacion;

/**
 * * TipoReclamacionDao  
 * 
 *  
 */

public interface TipoReclamacionDao {

	/**
	 * Inserts a single row in the TipoReclamacion table.
	 * 
	 * @param tiporeclamacion
	 *            TipoReclamacion
	 * @return TipoReclamacion
	 */
	TipoReclamacion add(TipoReclamacion tiporeclamacion);

	/**
	 * Updates a single row in the TipoReclamacion table.
	 * 
	 * @param tiporeclamacion
	 *            TipoReclamacion
	 * @return TipoReclamacion
	 */
	TipoReclamacion update(TipoReclamacion tiporeclamacion);

	/**
	 * Updates a single row in the TipoReclamacion table.
	 * 
	 * @param tiporeclamacion
	 *            Pagination
	 * @return TipoReclamacion
	 */
	public TipoReclamacion updateFechaBaja(TipoReclamacion tiporeclamacion);

	/**
	 * Finds a single row in the TipoReclamacion table.
	 * 
	 * @param tiporeclamacion
	 *            TipoReclamacion
	 * @return TipoReclamacion
	 */
	TipoReclamacion find(TipoReclamacion tiporeclamacion);

	/**
	 * Deletes a single row in the TipoReclamacion table.
	 * 
	 * @param tiporeclamacion
	 *            TipoReclamacion
	 * @return
	 */
	void remove(TipoReclamacion tiporeclamacion);

	/**
	 * Finds a List of rows in the TipoReclamacion table.
	 * 
	 * @param tiporeclamacion
	 *            TipoReclamacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<TipoReclamacion> findAll(TipoReclamacion tiporeclamacion,
			Pagination pagination);

	/**
	 * Counts rows in the TipoReclamacion table.
	 * 
	 * @param tiporeclamacion
	 *            TipoReclamacion
	 * @return List
	 */
	Long findAllCount(TipoReclamacion tiporeclamacion);

	/**
	 * Finds a List of rows in the TipoReclamacion table.
	 * 
	 * @param tiporeclamacion
	 *            TipoReclamacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TipoReclamacion> findAllAlta(TipoReclamacion tiporeclamacion,
			Pagination pagination);

	/**
	 * Counts rows in the TipoReclamacion table.
	 * 
	 * @param tiporeclamacion
	 *            TipoReclamacion
	 * @return Long
	 */
	public Long findAllAltaCount(TipoReclamacion tiporeclamacion);

	/**
	 * Finds rows in the TipoReclamacion table using like.
	 * 
	 * @param tiporeclamacion
	 *            TipoReclamacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<TipoReclamacion> findAllLike(TipoReclamacion tiporeclamacion,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the TipoReclamacion table.
	 * 
	 * @param tiporeclamacion
	 *            TipoReclamacion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(TipoReclamacion tiporeclamacion,
			Boolean startsWith);
}
