package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.AaccEuskadi;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.utils.modulos.Y41bModuloUtils;

/**
 * TipoProcedimientoDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class TipoProcedimientoDaoImpl implements TipoProcedimientoDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<TipoProcedimiento> rwMap = new RowMapper<TipoProcedimiento>() {
		public TipoProcedimiento mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new TipoProcedimiento(resultSet.getString("PCODIGO"), resultSet.getString("PNOMBRE"),
					resultSet.getString("PNOMBREE"), resultSet.getDate("PBAJA"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the TipoProcedimiento table.
	 * 
	 * @param tipoprocedimiento
	 *            Pagination
	 * @return TipoProcedimiento
	 */
	public TipoProcedimiento add(TipoProcedimiento tipoprocedimiento) {
		String query = "INSERT INTO TIPO_PROCEDIMIENTO (PCODIGO, PNOMBRE, PNOMBREE, PBAJA) VALUES (?,?,?,?)";
		this.jdbcTemplate.update(query, tipoprocedimiento.getPcodigo(), tipoprocedimiento.getPnombre(),
				tipoprocedimiento.getPnombree(), tipoprocedimiento.getPbaja());
		return tipoprocedimiento;
	}

	/**
	 * Updates a single row in the TipoProcedimiento table.
	 * 
	 * @param tipoprocedimiento
	 *            Pagination
	 * @return TipoProcedimiento
	 */
	public TipoProcedimiento update(TipoProcedimiento tipoprocedimiento) {
		String query = "UPDATE TIPO_PROCEDIMIENTO SET PNOMBRE=?, PNOMBREE=?, PBAJA=? WHERE PCODIGO=?";
		this.jdbcTemplate.update(query, tipoprocedimiento.getPnombre(), tipoprocedimiento.getPnombree(),
				tipoprocedimiento.getPbaja(), tipoprocedimiento.getPcodigo());
		return tipoprocedimiento;
	}

	/**
	 * Finds a single row in the TipoProcedimiento table.
	 * 
	 * @param tipoprocedimiento
	 *            Pagination
	 * @return TipoProcedimiento
	 */
	@Transactional(readOnly = true)
	public TipoProcedimiento find(TipoProcedimiento tipoprocedimiento) {
		String query = "SELECT t1.PCODIGO PCODIGO, t1.PNOMBRE PNOMBRE, t1.PNOMBREE PNOMBREE, t1.PBAJA PBAJA FROM TIPO_PROCEDIMIENTO t1  WHERE t1.PCODIGO = ?  ";

		List<TipoProcedimiento> tipoprocedimientoList = this.jdbcTemplate.query(query, this.rwMap,
				tipoprocedimiento.getPcodigo());
		return (TipoProcedimiento) DataAccessUtils.uniqueResult(tipoprocedimientoList);
	}

	/**
	 * Removes a single row in the TipoProcedimiento table.
	 * 
	 * @param tipoprocedimiento
	 *            Pagination
	 * @return
	 */
	public void remove(TipoProcedimiento tipoprocedimiento) {
		String query = "DELETE FROM TIPO_PROCEDIMIENTO WHERE PCODIGO=?";
		this.jdbcTemplate.update(query, tipoprocedimiento.getPcodigo());
	}

	/**
	 * Finds a List of rows in the TipoProcedimiento table.
	 * 
	 * @param tipoprocedimiento
	 *            TipoProcedimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipoProcedimiento> findAll(TipoProcedimiento tipoprocedimiento, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.PCODIGO PCODIGO,t1.PNOMBRE PNOMBRE,NVL(t1.PNOMBREE,t1.PNOMBRE) PNOMBREE,t1.PBAJA PBAJA ");
		query.append("FROM TIPO_PROCEDIMIENTO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapSinRemesa(tipoprocedimiento);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.PCODIGO != 'COM' AND t1.PCODIGO != 'EST' ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<TipoProcedimiento>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the TipoProcedimiento table.
	 * 
	 * @param tipoprocedimiento
	 *            TipoProcedimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipoProcedimiento> findAllConRemesa(TipoProcedimiento tipoprocedimiento, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.PCODIGO PCODIGO,t1.PNOMBRE PNOMBRE,NVL(t1.PNOMBREE,t1.PNOMBRE) PNOMBREE,t1.PBAJA PBAJA ");
		query.append("FROM TIPO_PROCEDIMIENTO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapConRemesa(tipoprocedimiento);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.PCODIGO != 'COM' AND t1.PCODIGO != 'EST' ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<TipoProcedimiento>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the TipoProcedimiento table.
	 * 
	 * @param tipoprocedimiento
	 *            TipoProcedimiento
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(TipoProcedimiento tipoprocedimiento) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM TIPO_PROCEDIMIENTO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapSinRemesa(tipoprocedimiento);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.PCODIGO != 'COM' AND t1.PCODIGO != 'EST' ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the TipoProcedimiento table.
	 * 
	 * @param tipoprocedimiento
	 *            TipoProcedimiento
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCountConRemesa(TipoProcedimiento tipoprocedimiento) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM TIPO_PROCEDIMIENTO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapConRemesa(tipoprocedimiento);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.PCODIGO != 'COM' AND t1.PCODIGO != 'EST' ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the TipoProcedimiento table using like.
	 * 
	 * @param tipoprocedimiento
	 *            TipoProcedimiento
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipoProcedimiento> findAllLike(TipoProcedimiento tipoprocedimiento, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.PCODIGO PCODIGO,t1.PNOMBRE PNOMBRE,NVL(t1.PNOMBREE,t1.PNOMBRE) PNOMBREE,t1.PBAJA PBAJA ");
		query.append("FROM TIPO_PROCEDIMIENTO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapSinRemesa(tipoprocedimiento, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.PCODIGO != 'COM' AND t1.PCODIGO != 'EST' ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<TipoProcedimiento>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the TipoProcedimiento table using like.
	 * 
	 * @param tipoprocedimiento
	 *            TipoProcedimiento
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(TipoProcedimiento tipoprocedimiento, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM TIPO_PROCEDIMIENTO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapSinRemesa(tipoprocedimiento, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.PCODIGO != 'COM' AND t1.PCODIGO != 'EST' ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TipoProcedimiento entity
	 * 
	 * @param tipoprocedimiento
	 *            TipoProcedimiento Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMapSinRemesa(TipoProcedimiento tipoprocedimiento) {

		StringBuilder where = new StringBuilder(TipoProcedimientoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		// Para traer los procedimientos que no sean Remesa
		where.append(obtenerCondicionQuitarRemesas());

		// establecimiento
		where.append(" AND t1.PCODIGO != '").append(Y41bConstantes.TIPO_PROC_ESTABLECIMIENTO).append("'");

		// Adhesiones y arbitraje
		if (!Y41bModuloUtils.getInstance().mostrarAdhesiones()) {
			where.append(" AND t1.PCODIGO != '").append(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA).append("'");
			where.append(" AND t1.PCODIGO != '").append(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA).append("'");
			where.append(" AND t1.PCODIGO != '").append(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD).append("'");
		}
		if (!Y41bModuloUtils.getInstance().mostrarArbitraje()) {
			where.append(" AND t1.PCODIGO != '").append(Y41bConstantes.TIPO_PROC_ARBITRAJE).append("'");
		}
		// GUILLE
		if (!Y41bModuloUtils.getInstance().mostrarControlMercado()) {
			where.append(" AND t1.PCODIGO != '").append(Y41bConstantes.TIPO_PROC_INSPECCIONES).append("'");
		}
		// GUILLE
		if (tipoprocedimiento != null && tipoprocedimiento.getPcodigo() != null) {
			where.append(" AND t1.PCODIGO = ?");
			params.add(tipoprocedimiento.getPcodigo());
		}
		if (tipoprocedimiento != null && tipoprocedimiento.getPnombre() != null) {
			where.append(" AND t1.PNOMBRE = ?");
			params.add(tipoprocedimiento.getPnombre());
		}
		if (tipoprocedimiento != null && tipoprocedimiento.getPnombree() != null) {
			where.append(" AND t1.PNOMBREE = ?");
			params.add(tipoprocedimiento.getPnombree());
		}
		if (tipoprocedimiento != null && tipoprocedimiento.getPbaja() != null) {
			where.append(" AND t1.PBAJA = ?");
			params.add(tipoprocedimiento.getPbaja());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	private String obtenerCondicionQuitarRemesas() {
		return " AND t1.PCODIGO != '" + Y41bConstantes.TIPO_PROC_REMESAS + "' AND t1.PCODIGO != '"
				+ Y41bConstantes.TIPO_PROC_REMESAS_AA66 + "'";
	}

	/*
	 * private String obtenerCondicionQuitarAdhesiones() { return
	 * " AND t1.PCODIGO != '" + Y41bConstantes.TIPO_PROC_ADHESIONES + "'"; }
	 */

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TipoProcedimiento entity
	 * 
	 * @param tipoprocedimiento
	 *            TipoProcedimiento Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMapConRemesa(TipoProcedimiento tipoprocedimiento) {

		StringBuilder where = new StringBuilder(TipoProcedimientoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		// establecimiento
		where.append(" AND t1.PCODIGO != '").append(Y41bConstantes.TIPO_PROC_ESTABLECIMIENTO).append("'");

		// Adhesiones y arbitraje
		if (!Y41bModuloUtils.getInstance().mostrarAdhesiones()) {
			where.append(" AND t1.PCODIGO != '").append(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA).append("'");
			where.append(" AND t1.PCODIGO != '").append(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA).append("'");
			where.append(" AND t1.PCODIGO != '").append(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD).append("'");
		}
		if (!Y41bModuloUtils.getInstance().mostrarArbitraje()) {
			where.append(" AND t1.PCODIGO != '").append(Y41bConstantes.TIPO_PROC_ARBITRAJE).append("'");
		}
		if (tipoprocedimiento != null && tipoprocedimiento.getPcodigo() != null) {
			where.append(" AND t1.PCODIGO = ?");
			params.add(tipoprocedimiento.getPcodigo());
		}
		if (tipoprocedimiento != null && tipoprocedimiento.getPnombre() != null) {
			where.append(" AND t1.PNOMBRE = ?");
			params.add(tipoprocedimiento.getPnombre());
		}
		if (tipoprocedimiento != null && tipoprocedimiento.getPnombree() != null) {
			where.append(" AND t1.PNOMBREE = ?");
			params.add(tipoprocedimiento.getPnombree());
		}
		if (tipoprocedimiento != null && tipoprocedimiento.getPbaja() != null) {
			where.append(" AND t1.PBAJA = ?");
			params.add(tipoprocedimiento.getPbaja());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TipoProcedimiento entity
	 * 
	 * @param tipoprocedimiento
	 *            TipoProcedimiento Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMapSinRemesa(TipoProcedimiento tipoprocedimiento, Boolean startsWith) {

		StringBuilder where = new StringBuilder(TipoProcedimientoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		// Para traer los procedimientos que no sean Remesa
		where.append(obtenerCondicionQuitarRemesas());

		// establecimiento
		where.append(" AND t1.PCODIGO != '").append(Y41bConstantes.TIPO_PROC_ESTABLECIMIENTO).append("'");

		// Adhesiones y arbitraje
		if (!Y41bModuloUtils.getInstance().mostrarAdhesiones()) {
			where.append(" AND t1.PCODIGO != '").append(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA).append("'");
			where.append(" AND t1.PCODIGO != '").append(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA).append("'");
			where.append(" AND t1.PCODIGO != '").append(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD).append("'");
		}
		if (!Y41bModuloUtils.getInstance().mostrarArbitraje()) {
			where.append(" AND t1.PCODIGO != '").append(Y41bConstantes.TIPO_PROC_ARBITRAJE).append("'");
		}

		if (tipoprocedimiento != null && tipoprocedimiento.getPcodigo() != null) {
			where.append(" AND UPPER(t1.PCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoprocedimiento.getPcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tipoprocedimiento.getPcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.PCODIGO IS NOT NULL");
		}
		if (tipoprocedimiento != null && tipoprocedimiento.getPnombre() != null) {
			where.append(" AND UPPER(t1.PNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoprocedimiento.getPnombre().toUpperCase() + "%");
			} else {
				params.add("%" + tipoprocedimiento.getPnombre().toUpperCase() + "%");
			}
			where.append(" AND t1.PNOMBRE IS NOT NULL");
		}
		if (tipoprocedimiento != null && tipoprocedimiento.getPnombree() != null) {
			where.append(" AND UPPER(t1.PNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoprocedimiento.getPnombree().toUpperCase() + "%");
			} else {
				params.add("%" + tipoprocedimiento.getPnombree().toUpperCase() + "%");
			}
			where.append(" AND t1.PNOMBREE IS NOT NULL");
		}
		if (tipoprocedimiento != null && tipoprocedimiento.getPbaja() != null) {
			where.append(" AND t1.PBAJA = ?");
			params.add(tipoprocedimiento.getPbaja());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	// EVOLUTIVO 0150942

	// Debido a la creacion de COM en y41a por el tema de comunicaciones (en un
	// solo paso, tabla de documentos temporales es un campo obligatorio) se
	// introduce la excepcion para que no lo muestre
	@Override
	public List<TipoProcedimiento> findAllCombo(TipoProcedimiento tipoProcedimiento, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.PCODIGO PCODIGO,t1.PNOMBRE PNOMBRE,NVL(t1.PNOMBREE,t1.PNOMBRE) PNOMBREE,t1.PBAJA PBAJA ");
		query.append(
				"FROM TIPO_PROCEDIMIENTO t1 WHERE 1=1 AND t1.PCODIGO != 'REM' AND t1.PCODIGO != 'REM_AA66' AND t1.PCODIGO != 'SAN' AND t1.PCODIGO != 'ADA' AND t1.PCODIGO != 'ADM' AND t1.PCODIGO != 'ADB' AND t1.PCODIGO != 'COM' AND t1.PCODIGO != 'EST' ");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<TipoProcedimiento>) this.jdbcTemplate.query(query.toString(), this.rwMap);
	}
	// EVOLUTIVO 0150942

	/**
	 * Finds a List of rows in the TipoProcedimiento table. Para el combo de
	 * avisos multiple en establecimiento
	 * 
	 * @param tipoprocedimiento
	 *            TipoProcedimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipoProcedimiento> findAllProcAvisos() {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.PCODIGO PCODIGO,t1.PNOMBRE PNOMBRE,NVL(t1.PNOMBREE,t1.PNOMBRE) PNOMBREE,t1.PBAJA PBAJA ");
		query.append("FROM TIPO_PROCEDIMIENTO t1 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder();
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 ");
		where.append(" AND t1.FLAG_AVISOS = ? ");
		params.add(String.valueOf(Y41bConstantes.NUM_1));

		query.append(where);

		return (List<TipoProcedimiento>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

}
