package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.TipoProcedimiento;

/**
 * TipoProcedimientoDao  
 * 
 *  
 */

public interface TipoProcedimientoDao {

	/**
	 * Inserts a single row in the TipoProcedimiento table.
	 * 
	 * @param tipoprocedimiento
	 *            TipoProcedimiento
	 * @return TipoProcedimiento
	 */
	TipoProcedimiento add(TipoProcedimiento tipoprocedimiento);

	/**
	 * Updates a single row in the TipoProcedimiento table.
	 * 
	 * @param tipoprocedimiento
	 *            TipoProcedimiento
	 * @return TipoProcedimiento
	 */
	TipoProcedimiento update(TipoProcedimiento tipoprocedimiento);

	/**
	 * Finds a single row in the TipoProcedimiento table.
	 * 
	 * @param tipoprocedimiento
	 *            TipoProcedimiento
	 * @return TipoProcedimiento
	 */
	TipoProcedimiento find(TipoProcedimiento tipoprocedimiento);

	/**
	 * Deletes a single row in the TipoProcedimiento table.
	 * 
	 * @param tipoprocedimiento
	 *            TipoProcedimiento
	 * @return
	 */
	void remove(TipoProcedimiento tipoprocedimiento);

	/**
	 * Finds a List of rows in the TipoProcedimiento table.
	 * 
	 * @param tipoprocedimiento
	 *            TipoProcedimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<TipoProcedimiento> findAll(TipoProcedimiento tipoprocedimiento, Pagination pagination);

	/**
	 * Finds a List of rows in the TipoProcedimiento table.
	 * 
	 * @param tipoprocedimiento
	 *            TipoProcedimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<TipoProcedimiento> findAllConRemesa(TipoProcedimiento tipoprocedimiento, Pagination pagination);

	/**
	 * Counts rows in the TipoProcedimiento table.
	 * 
	 * @param tipoprocedimiento
	 *            TipoProcedimiento
	 * @return Long
	 */
	Long findAllCount(TipoProcedimiento tipoprocedimiento);

	/**
	 * Counts rows in the TipoProcedimiento table.
	 * 
	 * @param tipoprocedimiento
	 *            TipoProcedimiento
	 * @return Long
	 */
	Long findAllCountConRemesa(TipoProcedimiento tipoprocedimiento);

	/**
	 * Finds rows in the TipoProcedimiento table using like.
	 * 
	 * @param tipoprocedimiento
	 *            TipoProcedimiento
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<TipoProcedimiento> findAllLike(TipoProcedimiento tipoprocedimiento, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the TipoProcedimiento table using like.
	 * 
	 * @param tipoprocedimiento
	 *            TipoProcedimiento
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(TipoProcedimiento tipoprocedimiento, Boolean startsWith);

	// EVOLUTIVO 0150942
	List<TipoProcedimiento> findAllCombo(TipoProcedimiento tipoProcedimiento, Pagination pagination);
	// EVOLUTIVO 0150942

	/**
	 * Finds a List of rows in the TipoProcedimiento table. Para el combo de
	 * avisos multiple en establecimiento
	 * 
	 * @param tipoprocedimiento
	 *            TipoProcedimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<TipoProcedimiento> findAllProcAvisos();
}
