package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.TipoInfraccionAgrupado;

/**
 * TipoInfraccionAgrupadoDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class TipoInfraccionAgrupadoDaoImpl implements TipoInfraccionAgrupadoDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<TipoInfraccionAgrupado> rwMap = new RowMapper<TipoInfraccionAgrupado>() {
		public TipoInfraccionAgrupado mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new TipoInfraccionAgrupado(resultSet.getString("L4CODIGO"),
					resultSet.getString("L4NOMBRE"),
					resultSet.getString("L4NOMBREE"),
					resultSet.getString("L4NOMBREI"),
					resultSet.getString("L4NOMBREF"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the TipoInfraccionAgrupado table.
	 * 
	 * @param tipoinfraccionagrupado
	 *            Pagination
	 * @return TipoInfraccionAgrupado
	 */
	public TipoInfraccionAgrupado add(
			TipoInfraccionAgrupado tipoinfraccionagrupado) {
		String query = "INSERT INTO TIPO_INFRACCION_AGRUPADO (L4CODIGO, L4NOMBRE, L4NOMBREE, L4NOMBREI, L4NOMBREF) VALUES (?,?,?,?,?)";
		this.jdbcTemplate.update(query, tipoinfraccionagrupado.getL4codigo(),
				tipoinfraccionagrupado.getL4nombre(),
				tipoinfraccionagrupado.getL4nombree(),
				tipoinfraccionagrupado.getL4nombrei(),
				tipoinfraccionagrupado.getL4nombref());
		return tipoinfraccionagrupado;
	}

	/**
	 * Updates a single row in the TipoInfraccionAgrupado table.
	 * 
	 * @param tipoinfraccionagrupado
	 *            Pagination
	 * @return TipoInfraccionAgrupado
	 */
	public TipoInfraccionAgrupado update(
			TipoInfraccionAgrupado tipoinfraccionagrupado) {
		String query = "UPDATE TIPO_INFRACCION_AGRUPADO SET L4NOMBRE=?, L4NOMBREE=?, L4NOMBREI=?, L4NOMBREF=? WHERE L4CODIGO=?";
		this.jdbcTemplate.update(query, tipoinfraccionagrupado.getL4nombre(),
				tipoinfraccionagrupado.getL4nombree(),
				tipoinfraccionagrupado.getL4nombrei(),
				tipoinfraccionagrupado.getL4nombref(),
				tipoinfraccionagrupado.getL4codigo());
		return tipoinfraccionagrupado;
	}

	/**
	 * Finds a single row in the TipoInfraccionAgrupado table.
	 * 
	 * @param tipoinfraccionagrupado
	 *            Pagination
	 * @return TipoInfraccionAgrupado
	 */
	@Transactional(readOnly = true)
	public TipoInfraccionAgrupado find(
			TipoInfraccionAgrupado tipoinfraccionagrupado) {
		String query = "SELECT t1.L4CODIGO L4CODIGO, t1.L4NOMBRE L4NOMBRE, t1.L4NOMBREE L4NOMBREE, t1.L4NOMBREI L4NOMBREI, t1.L4NOMBREF L4NOMBREF FROM TIPO_INFRACCION_AGRUPADO t1  WHERE t1.L4CODIGO = ?  ";

		List<TipoInfraccionAgrupado> tipoinfraccionagrupadoList = this.jdbcTemplate
				.query(query, this.rwMap, tipoinfraccionagrupado.getL4codigo());
		return (TipoInfraccionAgrupado) DataAccessUtils
				.uniqueResult(tipoinfraccionagrupadoList);
	}

	/**
	 * Removes a single row in the TipoInfraccionAgrupado table.
	 * 
	 * @param tipoinfraccionagrupado
	 *            Pagination
	 * @return
	 */
	public void remove(TipoInfraccionAgrupado tipoinfraccionagrupado) {
		String query = "DELETE FROM TIPO_INFRACCION_AGRUPADO WHERE L4CODIGO=?";
		this.jdbcTemplate.update(query, tipoinfraccionagrupado.getL4codigo());
	}

	/**
	 * Finds a List of rows in the TipoInfraccionAgrupado table.
	 * 
	 * @param tipoinfraccionagrupado
	 *            TipoInfraccionAgrupado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipoInfraccionAgrupado> findAll(
			TipoInfraccionAgrupado tipoinfraccionagrupado, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.L4CODIGO L4CODIGO,t1.L4NOMBRE L4NOMBRE,NVL(t1.L4NOMBREE,t1.L4NOMBRE) L4NOMBREE,t1.L4NOMBREI L4NOMBREI,t1.L4NOMBREF L4NOMBREF ");
		query.append("FROM TIPO_INFRACCION_AGRUPADO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tipoinfraccionagrupado);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<TipoInfraccionAgrupado>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the TipoInfraccionAgrupado table.
	 * 
	 * @param tipoinfraccionagrupado
	 *            TipoInfraccionAgrupado
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(TipoInfraccionAgrupado tipoinfraccionagrupado) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM TIPO_INFRACCION_AGRUPADO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tipoinfraccionagrupado);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the TipoInfraccionAgrupado table using like.
	 * 
	 * @param tipoinfraccionagrupado
	 *            TipoInfraccionAgrupado
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipoInfraccionAgrupado> findAllLike(
			TipoInfraccionAgrupado tipoinfraccionagrupado,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.L4CODIGO L4CODIGO,t1.L4NOMBRE L4NOMBRE,NVL(t1.L4NOMBREE,t1.L4NOMBRE) L4NOMBREE,t1.L4NOMBREI L4NOMBREI,t1.L4NOMBREF L4NOMBREF ");
		query.append("FROM TIPO_INFRACCION_AGRUPADO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tipoinfraccionagrupado,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<TipoInfraccionAgrupado>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the TipoInfraccionAgrupado table using like.
	 * 
	 * @param tipoinfraccionagrupado
	 *            TipoInfraccionAgrupado
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(TipoInfraccionAgrupado tipoinfraccionagrupado,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM TIPO_INFRACCION_AGRUPADO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tipoinfraccionagrupado,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TipoInfraccionAgrupado entity
	 * 
	 * @param tipoinfraccionagrupado
	 *            TipoInfraccionAgrupado Bean with the criteria values to filter
	 *            by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(
			TipoInfraccionAgrupado tipoinfraccionagrupado) {

		StringBuilder where = new StringBuilder(
				TipoInfraccionAgrupadoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tipoinfraccionagrupado != null
				&& tipoinfraccionagrupado.getL4codigo() != null) {
			where.append(" AND t1.L4CODIGO = ?");
			params.add(tipoinfraccionagrupado.getL4codigo());
		}
		if (tipoinfraccionagrupado != null
				&& tipoinfraccionagrupado.getL4nombre() != null) {
			where.append(" AND t1.L4NOMBRE = ?");
			params.add(tipoinfraccionagrupado.getL4nombre());
		}
		if (tipoinfraccionagrupado != null
				&& tipoinfraccionagrupado.getL4nombree() != null) {
			where.append(" AND t1.L4NOMBREE = ?");
			params.add(tipoinfraccionagrupado.getL4nombree());
		}
		if (tipoinfraccionagrupado != null
				&& tipoinfraccionagrupado.getL4nombrei() != null) {
			where.append(" AND t1.L4NOMBREI = ?");
			params.add(tipoinfraccionagrupado.getL4nombrei());
		}
		if (tipoinfraccionagrupado != null
				&& tipoinfraccionagrupado.getL4nombref() != null) {
			where.append(" AND t1.L4NOMBREF = ?");
			params.add(tipoinfraccionagrupado.getL4nombref());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TipoInfraccionAgrupado entity
	 * 
	 * @param tipoinfraccionagrupado
	 *            TipoInfraccionAgrupado Bean with the criteria values to filter
	 *            by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(
			TipoInfraccionAgrupado tipoinfraccionagrupado, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				TipoInfraccionAgrupadoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tipoinfraccionagrupado != null
				&& tipoinfraccionagrupado.getL4codigo() != null) {
			where.append(" AND UPPER(t1.L4CODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoinfraccionagrupado.getL4codigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tipoinfraccionagrupado.getL4codigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.L4CODIGO IS NOT NULL");
		}
		if (tipoinfraccionagrupado != null
				&& tipoinfraccionagrupado.getL4nombre() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.L4NOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoinfraccionagrupado.getL4nombre().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ tipoinfraccionagrupado.getL4nombre().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.L4NOMBRE IS NOT NULL");
		}
		if (tipoinfraccionagrupado != null
				&& tipoinfraccionagrupado.getL4nombree() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.L4NOMBREE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoinfraccionagrupado.getL4nombree().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ tipoinfraccionagrupado.getL4nombree().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.L4NOMBREE IS NOT NULL");
		}
		if (tipoinfraccionagrupado != null
				&& tipoinfraccionagrupado.getL4nombrei() != null) {
			where.append(" AND UPPER(t1.L4NOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoinfraccionagrupado.getL4nombrei().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tipoinfraccionagrupado.getL4nombrei().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.L4NOMBREI IS NOT NULL");
		}
		if (tipoinfraccionagrupado != null
				&& tipoinfraccionagrupado.getL4nombref() != null) {
			where.append(" AND UPPER(t1.L4NOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoinfraccionagrupado.getL4nombref().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ tipoinfraccionagrupado.getL4nombref().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.L4NOMBREF IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
