package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.TipoDocumento;

/**
 * TipoDocumentoDaoImpl  
 *  
 */
 
@Repository
@Transactional
public class TipoDocumentoDaoImpl implements TipoDocumentoDao {
    private JdbcTemplate jdbcTemplate;
	private RowMapper<TipoDocumento> rwMap = new RowMapper<TipoDocumento>() {
		public TipoDocumento mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new TipoDocumento(
               resultSet.getString("IDTIPODOC"), resultSet.getString("TDNOMBRE"), resultSet.getString("TDNOMBREE")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the TipoDocumento table.
     *
     * @param tipodocumento Pagination
     * @return TipoDocumento
     */
	public TipoDocumento add(TipoDocumento tipodocumento) {
    	String query = "INSERT INTO TIPO_DOCUMENTO (ID_TIPODOC, TDNOMBRE, TDNOMBREE) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, tipodocumento.getIdTipodoc(), tipodocumento.getTdnombre(), tipodocumento.getTdnombree());
		return tipodocumento;
	}

    /**
     * Updates a single row in the TipoDocumento table.
     *
     * @param tipodocumento Pagination
     * @return TipoDocumento
     */
    public TipoDocumento update(TipoDocumento tipodocumento) {
		String query = "UPDATE TIPO_DOCUMENTO SET TDNOMBRE=?, TDNOMBREE=? WHERE ID_TIPODOC=?";
		this.jdbcTemplate.update(query, tipodocumento.getTdnombre(), tipodocumento.getTdnombree(), tipodocumento.getIdTipodoc());
		return tipodocumento;
	}

    /**
     * Finds a single row in the TipoDocumento table.
     *
     * @param tipodocumento Pagination
     * @return TipoDocumento
     */
    @Transactional (readOnly = true)
    public TipoDocumento find(TipoDocumento tipodocumento) {
		String query = "SELECT t1.ID_TIPODOC IDTIPODOC, t1.TDNOMBRE TDNOMBRE, t1.TDNOMBREE TDNOMBREE FROM TIPO_DOCUMENTO t1  WHERE t1.ID_TIPODOC = ?  ";
		
		List<TipoDocumento> tipodocumentoList = this.jdbcTemplate.query(query, this.rwMap, tipodocumento.getIdTipodoc());
		return (TipoDocumento) DataAccessUtils.uniqueResult(tipodocumentoList);
    }

    /**
     * Removes a single row in the TipoDocumento table.
     *
     * @param tipodocumento Pagination
     * @return
     */
    public void remove(TipoDocumento tipodocumento) {
		String query = "DELETE FROM TIPO_DOCUMENTO WHERE ID_TIPODOC=?";
		this.jdbcTemplate.update(query, tipodocumento.getIdTipodoc());
    }
    
   /**
    * Finds a List of rows in the TipoDocumento table.
    * 
    * @param tipodocumento TipoDocumento
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<TipoDocumento> findAll(TipoDocumento tipodocumento, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.ID_TIPODOC IDTIPODOC,t1.TDNOMBRE TDNOMBRE,t1.TDNOMBREE TDNOMBREE "); 
		query.append("FROM TIPO_DOCUMENTO t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tipodocumento); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<TipoDocumento>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the TipoDocumento table.
     * 
     * @param tipodocumento TipoDocumento
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(TipoDocumento tipodocumento) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM TIPO_DOCUMENTO t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tipodocumento); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the TipoDocumento table using like.
     * 
     * @param tipodocumento TipoDocumento
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<TipoDocumento> findAllLike(TipoDocumento tipodocumento, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.ID_TIPODOC IDTIPODOC,t1.TDNOMBRE TDNOMBRE,t1.TDNOMBREE TDNOMBREE "); 
        query.append("FROM TIPO_DOCUMENTO t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tipodocumento,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<TipoDocumento>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Counts rows in the TipoDocumento table using like.
     * 
     * @param tipodocumento TipoDocumento
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(TipoDocumento tipodocumento, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM TIPO_DOCUMENTO t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tipodocumento,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the TipoDocumento entity 
	 * 
	 * @param tipodocumento TipoDocumento
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (TipoDocumento tipodocumento){
		
		StringBuilder where = new StringBuilder(TipoDocumentoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tipodocumento  != null  && tipodocumento.getIdTipodoc() != null ) {
			where.append(" AND t1.ID_TIPODOC = ?");
			params.add(tipodocumento.getIdTipodoc());
		}
		if (tipodocumento  != null  && tipodocumento.getTdnombre() != null ) {
			where.append(" AND t1.TDNOMBRE = ?");
			params.add(tipodocumento.getTdnombre());
		}
		if (tipodocumento  != null  && tipodocumento.getTdnombree() != null ) {
			where.append(" AND t1.TDNOMBREE = ?");
			params.add(tipodocumento.getTdnombree());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the TipoDocumento entity 
	 * 
	 * @param tipodocumento TipoDocumento
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap (TipoDocumento tipodocumento, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(TipoDocumentoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tipodocumento  != null  && tipodocumento.getIdTipodoc() != null ) {
			where.append(" AND UPPER(t1.ID_TIPODOC) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipodocumento.getIdTipodoc().toUpperCase() +"%");
			}else{
				params.add("%"+tipodocumento.getIdTipodoc().toUpperCase() +"%");
			}
			where.append(" AND t1.ID_TIPODOC IS NOT NULL");
	     }			
		if (tipodocumento  != null  && tipodocumento.getTdnombre() != null ) {
			where.append(" AND UPPER(t1.TDNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipodocumento.getTdnombre().toUpperCase() +"%");
			}else{
				params.add("%"+tipodocumento.getTdnombre().toUpperCase() +"%");
			}
			where.append(" AND t1.TDNOMBRE IS NOT NULL");
	     }			
		if (tipodocumento  != null  && tipodocumento.getTdnombree() != null ) {
			where.append(" AND UPPER(t1.TDNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipodocumento.getTdnombree().toUpperCase() +"%");
			}else{
				params.add("%"+tipodocumento.getTdnombree().toUpperCase() +"%");
			}
			where.append(" AND t1.TDNOMBREE IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

