package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.TipoCaracterAlerta;

/**
 * TipoCaracterAlertaDaoImpl  
 *  
 */
 
@Repository
@Transactional
public class TipoCaracterAlertaDaoImpl implements TipoCaracterAlertaDao {
    private JdbcTemplate jdbcTemplate;
	private RowMapper<TipoCaracterAlerta> rwMap = new RowMapper<TipoCaracterAlerta>() {
		public TipoCaracterAlerta mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new TipoCaracterAlerta(
               resultSet.getString("TCACODIGO"), resultSet.getString("TCANOMBRE"), resultSet.getString("TCANOMBREE")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the TipoCaracterAlerta table.
     *
     * @param tipocaracteralerta Pagination
     * @return TipoCaracterAlerta
     */
	public TipoCaracterAlerta add(TipoCaracterAlerta tipocaracteralerta) {
    	String query = "INSERT INTO TIPO_CARACTER_ALERTA (TCACODIGO, TCANOMBRE, TCANOMBREE) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, tipocaracteralerta.getTcacodigo(), tipocaracteralerta.getTcanombre(), tipocaracteralerta.getTcanombree());
		return tipocaracteralerta;
	}

    /**
     * Updates a single row in the TipoCaracterAlerta table.
     *
     * @param tipocaracteralerta Pagination
     * @return TipoCaracterAlerta
     */
    public TipoCaracterAlerta update(TipoCaracterAlerta tipocaracteralerta) {
		String query = "UPDATE TIPO_CARACTER_ALERTA SET TCANOMBRE=?, TCANOMBREE=? WHERE TCACODIGO=?";
		this.jdbcTemplate.update(query, tipocaracteralerta.getTcanombre(), tipocaracteralerta.getTcanombree(), tipocaracteralerta.getTcacodigo());
		return tipocaracteralerta;
	}

    /**
     * Finds a single row in the TipoCaracterAlerta table.
     *
     * @param tipocaracteralerta Pagination
     * @return TipoCaracterAlerta
     */
    @Transactional (readOnly = true)
    public TipoCaracterAlerta find(TipoCaracterAlerta tipocaracteralerta) {
		String query = "SELECT t1.TCACODIGO TCACODIGO, t1.TCANOMBRE TCANOMBRE, t1.TCANOMBREE TCANOMBREE FROM TIPO_CARACTER_ALERTA t1  WHERE t1.TCACODIGO = ?  ";
		
		List<TipoCaracterAlerta> tipocaracteralertaList = this.jdbcTemplate.query(query, this.rwMap, tipocaracteralerta.getTcacodigo());
		return (TipoCaracterAlerta) DataAccessUtils.uniqueResult(tipocaracteralertaList);
    }

    /**
     * Removes a single row in the TipoCaracterAlerta table.
     *
     * @param tipocaracteralerta Pagination
     * @return
     */
    public void remove(TipoCaracterAlerta tipocaracteralerta) {
		String query = "DELETE FROM TIPO_CARACTER_ALERTA WHERE TCACODIGO=?";
		this.jdbcTemplate.update(query, tipocaracteralerta.getTcacodigo());
    }
    
   /**
    * Finds a List of rows in the TipoCaracterAlerta table.
    * 
    * @param tipocaracteralerta TipoCaracterAlerta
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<TipoCaracterAlerta> findAll(TipoCaracterAlerta tipocaracteralerta, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.TCACODIGO TCACODIGO,t1.TCANOMBRE TCANOMBRE,t1.TCANOMBREE TCANOMBREE "); 
		query.append("FROM TIPO_CARACTER_ALERTA t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tipocaracteralerta); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<TipoCaracterAlerta>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the TipoCaracterAlerta table.
     * 
     * @param tipocaracteralerta TipoCaracterAlerta
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(TipoCaracterAlerta tipocaracteralerta) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM TIPO_CARACTER_ALERTA t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tipocaracteralerta); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the TipoCaracterAlerta table using like.
     * 
     * @param tipocaracteralerta TipoCaracterAlerta
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<TipoCaracterAlerta> findAllLike(TipoCaracterAlerta tipocaracteralerta, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.TCACODIGO TCACODIGO,t1.TCANOMBRE TCANOMBRE,t1.TCANOMBREE TCANOMBREE "); 
        query.append("FROM TIPO_CARACTER_ALERTA t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tipocaracteralerta,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<TipoCaracterAlerta>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Counts rows in the TipoCaracterAlerta table using like.
     * 
     * @param tipocaracteralerta TipoCaracterAlerta
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(TipoCaracterAlerta tipocaracteralerta, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM TIPO_CARACTER_ALERTA t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tipocaracteralerta,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the TipoCaracterAlerta entity 
	 * 
	 * @param tipocaracteralerta TipoCaracterAlerta
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (TipoCaracterAlerta tipocaracteralerta){
		
		StringBuilder where = new StringBuilder(TipoCaracterAlertaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tipocaracteralerta  != null  && tipocaracteralerta.getTcacodigo() != null ) {
			where.append(" AND t1.TCACODIGO = ?");
			params.add(tipocaracteralerta.getTcacodigo());
		}
		if (tipocaracteralerta  != null  && tipocaracteralerta.getTcanombre() != null ) {
			where.append(" AND t1.TCANOMBRE = ?");
			params.add(tipocaracteralerta.getTcanombre());
		}
		if (tipocaracteralerta  != null  && tipocaracteralerta.getTcanombree() != null ) {
			where.append(" AND t1.TCANOMBREE = ?");
			params.add(tipocaracteralerta.getTcanombree());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the TipoCaracterAlerta entity 
	 * 
	 * @param tipocaracteralerta TipoCaracterAlerta
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap (TipoCaracterAlerta tipocaracteralerta, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(TipoCaracterAlertaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tipocaracteralerta  != null  && tipocaracteralerta.getTcacodigo() != null ) {
			where.append(" AND UPPER(t1.TCACODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipocaracteralerta.getTcacodigo().toUpperCase() +"%");
			}else{
				params.add("%"+tipocaracteralerta.getTcacodigo().toUpperCase() +"%");
			}
			where.append(" AND t1.TCACODIGO IS NOT NULL");
	     }			
		if (tipocaracteralerta  != null  && tipocaracteralerta.getTcanombre() != null ) {
			where.append(" AND UPPER(t1.TCANOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipocaracteralerta.getTcanombre().toUpperCase() +"%");
			}else{
				params.add("%"+tipocaracteralerta.getTcanombre().toUpperCase() +"%");
			}
			where.append(" AND t1.TCANOMBRE IS NOT NULL");
	     }			
		if (tipocaracteralerta  != null  && tipocaracteralerta.getTcanombree() != null ) {
			where.append(" AND UPPER(t1.TCANOMBREE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tipocaracteralerta.getTcanombree().toUpperCase() +"%");
			}else{
				params.add("%"+tipocaracteralerta.getTcanombree().toUpperCase() +"%");
			}
			where.append(" AND t1.TCANOMBREE IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

