package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.TipoCaracterAlerta;

/**
 * TipoCaracterAlertaDao  
 *  
 */

public interface TipoCaracterAlertaDao {
    
    /**
     * Inserts a single row in the TipoCaracterAlerta table.
     *
     * @param tipocaracteralerta TipoCaracterAlerta
     * @return TipoCaracterAlerta
     */
    TipoCaracterAlerta add(TipoCaracterAlerta tipocaracteralerta);

    /**
     * Updates a single row in the TipoCaracterAlerta table.
     *
     * @param tipocaracteralerta TipoCaracterAlerta
     * @return TipoCaracterAlerta
     */
    TipoCaracterAlerta update(TipoCaracterAlerta tipocaracteralerta);

    /**
     * Finds a single row in the TipoCaracterAlerta table.
     *
     * @param tipocaracteralerta TipoCaracterAlerta
     * @return TipoCaracterAlerta
     */
    TipoCaracterAlerta find(TipoCaracterAlerta tipocaracteralerta);

    /**
     * Deletes a single row in the TipoCaracterAlerta table.
     *
     * @param tipocaracteralerta TipoCaracterAlerta
     * @return 
     */
    void remove(TipoCaracterAlerta tipocaracteralerta);

    /**
     * Finds a List of rows in the TipoCaracterAlerta table.
     *
     * @param tipocaracteralerta TipoCaracterAlerta
     * @param pagination Pagination
     * @return List
     */
    List<TipoCaracterAlerta> findAll(TipoCaracterAlerta tipocaracteralerta, Pagination pagination);

    /**
     * Counts rows in the TipoCaracterAlerta table.
     *
     * @param tipocaracteralerta TipoCaracterAlerta
     * @return Long
     */
    Long findAllCount(TipoCaracterAlerta tipocaracteralerta);
	
	/**
     * Finds rows in the TipoCaracterAlerta table using like.
     *
     * @param tipocaracteralerta TipoCaracterAlerta
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<TipoCaracterAlerta> findAllLike(TipoCaracterAlerta tipocaracteralerta, Pagination pagination, Boolean startsWith);
	
    /**
     * Counts rows in the TipoCaracterAlerta table using like.
     *
     * @param tipocaracteralerta TipoCaracterAlerta
     * @param startsWith Boolean
     * @return Long
     */
    Long findAllLikeCount(TipoCaracterAlerta tipocaracteralerta, Boolean startsWith);
}

