package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.TipReqNormativo;
import com.ejie.y41b.model.Y41bTipoInfraccionTree;

/**
 * * TipReqNormativoDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class TipReqNormativoDaoImpl implements TipReqNormativoDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<TipReqNormativo> rwMap = new RowMapper<TipReqNormativo>() {
		public TipReqNormativo mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new TipReqNormativo(resultSet.getString("TTICODIGO"),
					resultSet.getString("TTINOMBRE"),
					resultSet.getString("TTINOCO"),
					resultSet.getString("TTITEDE"),
					resultSet.getString("TTICOSE"),
					resultSet.getString("TTINOCO2"),
					resultSet.getString("TTIINSEL1"),
					resultSet.getString("TTICOL4"),
					resultSet.getString("TTINOMBREE"),
					resultSet.getString("TTINOMBREI"),
					resultSet.getString("TTINOMBREF"),
					resultSet.getString("TTINOCOE"),
					resultSet.getString("TTINOCOI"),
					resultSet.getString("TTINOCOF"),
					resultSet.getString("TTITEDEE"),
					resultSet.getString("TTITEDEI"),
					resultSet.getString("TTITEDEF"),
					resultSet.getString("TTICODGRUPO"),
					resultSet.getString("TTINOMBREA"),
					resultSet.getString("TTINOCOA"),
					resultSet.getString("TTITEDEA"),
					resultSet.getString("TTICOE7"),
					resultSet.getString("TTICOINC"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the TipReqNormativo table.
	 * 
	 * @param tipreqnormativo
	 *            Pagination
	 * @return TipReqNormativo
	 */
	public TipReqNormativo add(TipReqNormativo tipreqnormativo) {

		String query = "INSERT INTO TIP_REQ_NORMATIVO( TTICODIGO,TTINOMBRE,TTINOCO,TTITEDE,TTICOSE,TTINOCO2,TTIINSEL1,TTICOL4,TTINOMBREE,TTINOMBREI,TTINOMBREF,TTINOCOE,TTINOCOI,TTINOCOF,TTITEDEE,TTITEDEI,TTITEDEF,TTICODGRUPO,TTINOMBREA,TTINOCOA,TTITEDEA,TTICOE7,TTICOINC)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		this.jdbcTemplate.update(query, tipreqnormativo.getTticodigo(),
				tipreqnormativo.getTtinombre(), tipreqnormativo.getTtinoco(),
				tipreqnormativo.getTtitede(), tipreqnormativo.getTticose(),
				tipreqnormativo.getTtinoco2(), tipreqnormativo.getTtiinsel1(),
				tipreqnormativo.getTticol4(), tipreqnormativo.getTtinombree(),
				tipreqnormativo.getTtinombrei(),
				tipreqnormativo.getTtinombref(), tipreqnormativo.getTtinocoe(),
				tipreqnormativo.getTtinocoi(), tipreqnormativo.getTtinocof(),
				tipreqnormativo.getTtitedee(), tipreqnormativo.getTtitedei(),
				tipreqnormativo.getTtitedef(),
				tipreqnormativo.getTticodgrupo(),
				tipreqnormativo.getTtinombrea(), tipreqnormativo.getTtinocoa(),
				tipreqnormativo.getTtitedea(), tipreqnormativo.getTticoe7(),
				tipreqnormativo.getTticoinc());
		return tipreqnormativo;
	}

	/**
	 * Updates a single row in the TipReqNormativo table.
	 * 
	 * @param tipreqnormativo
	 *            Pagination
	 * @return TipReqNormativo
	 */
	public TipReqNormativo update(TipReqNormativo tipreqnormativo) {
		String query = "UPDATE TIP_REQ_NORMATIVO SET TTINOMBRE=?,TTINOCO=?,TTITEDE=?,TTICOSE=?,TTINOCO2=?,TTIINSEL1=?,TTICOL4=?,TTINOMBREE=?,TTINOMBREI=?,TTINOMBREF=?,TTINOCOE=?,TTINOCOI=?,TTINOCOF=?,TTITEDEE=?,TTITEDEI=?,TTITEDEF=?,TTICODGRUPO=?,TTINOMBREA=?,TTINOCOA=?,TTITEDEA=?,TTICOE7=?,TTICOINC=? WHERE TTICODIGO=?";
		this.jdbcTemplate.update(query, tipreqnormativo.getTtinombre(),
				tipreqnormativo.getTtinoco(), tipreqnormativo.getTtitede(),
				tipreqnormativo.getTticose(), tipreqnormativo.getTtinoco2(),
				tipreqnormativo.getTtiinsel1(), tipreqnormativo.getTticol4(),
				tipreqnormativo.getTtinombree(),
				tipreqnormativo.getTtinombrei(),
				tipreqnormativo.getTtinombref(), tipreqnormativo.getTtinocoe(),
				tipreqnormativo.getTtinocoi(), tipreqnormativo.getTtinocof(),
				tipreqnormativo.getTtitedee(), tipreqnormativo.getTtitedei(),
				tipreqnormativo.getTtitedef(),
				tipreqnormativo.getTticodgrupo(),
				tipreqnormativo.getTtinombrea(), tipreqnormativo.getTtinocoa(),
				tipreqnormativo.getTtitedea(), tipreqnormativo.getTticoe7(),
				tipreqnormativo.getTticoinc(), tipreqnormativo.getTticodigo());
		return tipreqnormativo;
	}

	/**
	 * Finds a single row in the TipReqNormativo table.
	 * 
	 * @param tipreqnormativo
	 *            Pagination
	 * @return TipReqNormativo
	 */
	@Transactional(readOnly = true)
	public TipReqNormativo find(TipReqNormativo tipreqnormativo) {
		String query = "SELECT t1.TTICODIGO TTICODIGO, t1.TTINOMBRE TTINOMBRE, t1.TTINOCO TTINOCO, t1.TTITEDE TTITEDE, t1.TTICOSE TTICOSE, t1.TTINOCO2 TTINOCO2, t1.TTIINSEL1 TTIINSEL1, t1.TTICOL4 TTICOL4, t1.TTINOMBREE TTINOMBREE, t1.TTINOMBREI TTINOMBREI, t1.TTINOMBREF TTINOMBREF, t1.TTINOCOE TTINOCOE, t1.TTINOCOI TTINOCOI, t1.TTINOCOF TTINOCOF, t1.TTITEDEE TTITEDEE, t1.TTITEDEI TTITEDEI, t1.TTITEDEF TTITEDEF, t1.TTICODGRUPO TTICODGRUPO, t1.TTINOMBREA TTINOMBREA, t1.TTINOCOA TTINOCOA, t1.TTITEDEA TTITEDEA, t1.TTICOE7 TTICOE7, t1.TTICOINC TTICOINC "
				+ "FROM TIP_REQ_NORMATIVO t1  " + "WHERE t1.TTICODIGO = ?    ";
		return (TipReqNormativo) this.jdbcTemplate.queryForObject(query, rwMap,
				tipreqnormativo.getTticodigo());
	}

	/**
	 * Finds a single row in the TipReqNormativo table.
	 * 
	 * @param tipreqnormativo
	 *            Pagination
	 * @return TipReqNormativo
	 */
	@Transactional(readOnly = true)
	public TipReqNormativo findTipReqNormativoSeleccionable(
			TipReqNormativo tipreqnormativo) {
		String query = "SELECT t1.TTICODIGO TTICODIGO, t1.TTINOMBRE TTINOMBRE, t1.TTINOCO TTINOCO, t1.TTITEDE TTITEDE, t1.TTICOSE TTICOSE, t1.TTINOCO2 TTINOCO2, t1.TTIINSEL1 TTIINSEL1, t1.TTICOL4 TTICOL4, t1.TTINOMBREE TTINOMBREE, t1.TTINOMBREI TTINOMBREI, t1.TTINOMBREF TTINOMBREF, t1.TTINOCOE TTINOCOE, t1.TTINOCOI TTINOCOI, t1.TTINOCOF TTINOCOF, t1.TTITEDEE TTITEDEE, t1.TTITEDEI TTITEDEI, t1.TTITEDEF TTITEDEF, t1.TTICODGRUPO TTICODGRUPO, t1.TTINOMBREA TTINOMBREA, t1.TTINOCOA TTINOCOA, t1.TTITEDEA TTITEDEA, t1.TTICOE7 TTICOE7, t1.TTICOINC TTICOINC "
				+ "FROM TIP_REQ_NORMATIVO t1  "
				+ "WHERE t1.TTICODIGO = ?  AND t1.TTICOSE = ?  ";
		return (TipReqNormativo) this.jdbcTemplate.queryForObject(query, rwMap,
				tipreqnormativo.getTticodigo(),
				Y41bConstantes.ELEMENTO_SELECCIONABLE);
	}

	/**
	 * Finds a single row in the TipReqNormativo table.
	 * 
	 * @param tipreqnormativo
	 *            Pagination
	 * @return TipReqNormativo
	 */
	@Transactional(readOnly = true)
	public TipReqNormativo findReqNormativoSeleccionable(
			TipReqNormativo tipreqnormativo) {
		String query = "SELECT t1.TTICODIGO TTICODIGO, t1.TTINOMBRE TTINOMBRE, t1.TTINOCO TTINOCO, t1.TTITEDE TTITEDE, t1.TTICOSE TTICOSE, t1.TTINOCO2 TTINOCO2, t1.TTIINSEL1 TTIINSEL1, t1.TTICOL4 TTICOL4, t1.TTINOMBREE TTINOMBREE, t1.TTINOMBREI TTINOMBREI, t1.TTINOMBREF TTINOMBREF, t1.TTINOCOE TTINOCOE, t1.TTINOCOI TTINOCOI, t1.TTINOCOF TTINOCOF, t1.TTITEDEE TTITEDEE, t1.TTITEDEI TTITEDEI, t1.TTITEDEF TTITEDEF, t1.TTICODGRUPO TTICODGRUPO, t1.TTINOMBREA TTINOMBREA, t1.TTINOCOA TTINOCOA, t1.TTITEDEA TTITEDEA, t1.TTICOE7 TTICOE7, t1.TTICOINC TTICOINC "
				+ "FROM TIP_REQ_NORMATIVO t1  "
				+ "WHERE t1.TTICODIGO = ?  AND t1.TTICOSE = ?  ";
		return (TipReqNormativo) this.jdbcTemplate.queryForObject(query, rwMap,
				tipreqnormativo.getTticodigo(),
				Y41bConstantes.ELEMENTO_SELECCIONABLE);
	}

	/**
	 * Removes a single row in the TipReqNormativo table.
	 * 
	 * @param tipreqnormativo
	 *            Pagination
	 * @return
	 */
	public void remove(TipReqNormativo tipreqnormativo) {
		String query = "DELETE  FROM TIP_REQ_NORMATIVO WHERE TTICODIGO=?";
		this.jdbcTemplate.update(query, tipreqnormativo.getTticodigo());
	}

	/**
	 * Finds a List of rows in the TipReqNormativo table.
	 * 
	 * @param tipreqnormativo
	 *            TipReqNormativo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipReqNormativo> findAll(TipReqNormativo tipreqnormativo,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.TTICODIGO TTICODIGO,t1.TTINOMBRE TTINOMBRE,t1.TTINOCO TTINOCO,t1.TTITEDE TTITEDE,t1.TTICOSE TTICOSE,t1.TTINOCO2 TTINOCO2,t1.TTIINSEL1 TTIINSEL1,t1.TTICOL4 TTICOL4,t1.TTINOMBREE TTINOMBREE,t1.TTINOMBREI TTINOMBREI,t1.TTINOMBREF TTINOMBREF,t1.TTINOCOE TTINOCOE,t1.TTINOCOI TTINOCOI,t1.TTINOCOF TTINOCOF,t1.TTITEDEE TTITEDEE,t1.TTITEDEI TTITEDEI,t1.TTITEDEF TTITEDEF,t1.TTICODGRUPO TTICODGRUPO,t1.TTINOMBREA TTINOMBREA,t1.TTINOCOA TTINOCOA,t1.TTITEDEA TTITEDEA,t1.TTICOE7 TTICOE7,t1.TTICOINC TTICOINC "
						+ "FROM TIP_REQ_NORMATIVO t1 ");

		if (tipreqnormativo != null && tipreqnormativo.getTticodigo() != null) {
			where.append(" AND t1.TTICODIGO = ?");
			params.add(tipreqnormativo.getTticodigo());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinombre() != null) {
			where.append(" AND t1.TTINOMBRE = ?");
			params.add(tipreqnormativo.getTtinombre());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinoco() != null) {
			where.append(" AND t1.TTINOCO = ?");
			params.add(tipreqnormativo.getTtinoco());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtitede() != null) {
			where.append(" AND t1.TTITEDE = ?");
			params.add(tipreqnormativo.getTtitede());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTticose() != null) {
			where.append(" AND t1.TTICOSE = ?");
			params.add(tipreqnormativo.getTticose());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinoco2() != null) {
			where.append(" AND t1.TTINOCO2 = ?");
			params.add(tipreqnormativo.getTtinoco2());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtiinsel1() != null) {
			where.append(" AND t1.TTIINSEL1 = ?");
			params.add(tipreqnormativo.getTtiinsel1());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTticol4() != null) {
			where.append(" AND t1.TTICOL4 = ?");
			params.add(tipreqnormativo.getTticol4());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinombree() != null) {
			where.append(" AND t1.TTINOMBREE = ?");
			params.add(tipreqnormativo.getTtinombree());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinombrei() != null) {
			where.append(" AND t1.TTINOMBREI = ?");
			params.add(tipreqnormativo.getTtinombrei());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinombref() != null) {
			where.append(" AND t1.TTINOMBREF = ?");
			params.add(tipreqnormativo.getTtinombref());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinocoe() != null) {
			where.append(" AND t1.TTINOCOE = ?");
			params.add(tipreqnormativo.getTtinocoe());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinocoi() != null) {
			where.append(" AND t1.TTINOCOI = ?");
			params.add(tipreqnormativo.getTtinocoi());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinocof() != null) {
			where.append(" AND t1.TTINOCOF = ?");
			params.add(tipreqnormativo.getTtinocof());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtitedee() != null) {
			where.append(" AND t1.TTITEDEE = ?");
			params.add(tipreqnormativo.getTtitedee());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtitedei() != null) {
			where.append(" AND t1.TTITEDEI = ?");
			params.add(tipreqnormativo.getTtitedei());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtitedef() != null) {
			where.append(" AND t1.TTITEDEF = ?");
			params.add(tipreqnormativo.getTtitedef());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTticodgrupo() != null) {
			where.append(" AND t1.TTICODGRUPO = ?");
			params.add(tipreqnormativo.getTticodgrupo());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinombrea() != null) {
			where.append(" AND t1.TTINOMBREA = ?");
			params.add(tipreqnormativo.getTtinombrea());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinocoa() != null) {
			where.append(" AND t1.TTINOCOA = ?");
			params.add(tipreqnormativo.getTtinocoa());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtitedea() != null) {
			where.append(" AND t1.TTITEDEA = ?");
			params.add(tipreqnormativo.getTtitedea());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTticoe7() != null) {
			where.append(" AND t1.TTICOE7 = ?");
			params.add(tipreqnormativo.getTticoe7());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTticoinc() != null) {
			where.append(" AND t1.TTICOINC = ?");
			params.add(tipreqnormativo.getTticoinc());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<TipReqNormativo>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the TipReqNormativo table.
	 * 
	 * @param y41bTipoInfraccionTree
	 *            Y41bTipoInfraccionTree
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Y41bTipoInfraccionTree> findAllTiposInfraccionPadre(
			Y41bTipoInfraccionTree y41bTipoInfraccionTree, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND length(TTICODIGO)=1 ");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.TTICODIGO TTICODIGO,t1.TTINOMBRE TTINOMBRE,t1.TTINOCO TTINOCO,t1.TTITEDE TTITEDE,t1.TTICOSE TTICOSE,t1.TTINOCO2 TTINOCO2,t1.TTIINSEL1 TTIINSEL1,t1.TTICOL4 TTICOL4,t1.TTINOMBREE TTINOMBREE,t1.TTINOMBREI TTINOMBREI,t1.TTINOMBREF TTINOMBREF,t1.TTINOCOE TTINOCOE,t1.TTINOCOI TTINOCOI,t1.TTINOCOF TTINOCOF,t1.TTITEDEE TTITEDEE,t1.TTITEDEI TTITEDEI,t1.TTITEDEF TTITEDEF,t1.TTICODGRUPO TTICODGRUPO,t1.TTINOMBREA TTINOMBREA,t1.TTINOCOA TTINOCOA,t1.TTITEDEA TTITEDEA,t1.TTICOE7 TTICOE7,t1.TTICOINC TTICOINC "
						+ "FROM TIP_REQ_NORMATIVO t1 ");

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Y41bTipoInfraccionTree>) this.jdbcTemplate.query(
				query.toString(), new RowMapper<Y41bTipoInfraccionTree>() {
					public Y41bTipoInfraccionTree mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new Y41bTipoInfraccionTree(resultSet
								.getString("TTICODIGO"), resultSet
								.getString("TTINOMBRE"), resultSet
								.getString("TTINOMBREE"), resultSet
								.getString("TTICOSE"), resultSet
								.getString("TTIINSEL1"));
					}
				}, params.toArray());
	}

	/**
	 * Finds a List of rows in the TipReqNormativo table.
	 * 
	 * @param y41bTipoInfraccionTree
	 *            Y41bTipoInfraccionTree
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Y41bTipoInfraccionTree> findAllChildren(
			Y41bTipoInfraccionTree y41bTipoInfraccionTree, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 ");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.TTICODIGO TTICODIGO,t1.TTINOMBRE TTINOMBRE,t1.TTINOCO TTINOCO,t1.TTITEDE TTITEDE,t1.TTICOSE TTICOSE,t1.TTINOCO2 TTINOCO2,t1.TTIINSEL1 TTIINSEL1,t1.TTICOL4 TTICOL4,t1.TTINOMBREE TTINOMBREE,t1.TTINOMBREI TTINOMBREI,t1.TTINOMBREF TTINOMBREF,t1.TTINOCOE TTINOCOE,t1.TTINOCOI TTINOCOI,t1.TTINOCOF TTINOCOF,t1.TTITEDEE TTITEDEE,t1.TTITEDEI TTITEDEI,t1.TTITEDEF TTITEDEF,t1.TTICODGRUPO TTICODGRUPO,t1.TTINOMBREA TTINOMBREA,t1.TTINOCOA TTINOCOA,t1.TTITEDEA TTITEDEA,t1.TTICOE7 TTICOE7,t1.TTICOINC TTICOINC "
						+ "FROM TIP_REQ_NORMATIVO t1 ");

		where.append(" AND UPPER(t1.TTICODIGO) like ? ESCAPE  '\\'");
		params.add(y41bTipoInfraccionTree.getTticodigo().toUpperCase() + "%");

		where.append(" AND length(TTICODIGO)= DECODE((select count(*) from TIP_REQ_NORMATIVO t2 WHERE 1=1 AND UPPER(t2.TTICODIGO) like ? ESCAPE  '\\' AND length(TTICODIGO)=?),0,?,?)");
		params.add(y41bTipoInfraccionTree.getTticodigo().toUpperCase() + "%");
		int tamanyo = y41bTipoInfraccionTree.getTticodigo().length() + 1;
		params.add(tamanyo);
		params.add(tamanyo + 1);
		params.add(tamanyo);

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Y41bTipoInfraccionTree>) this.jdbcTemplate.query(
				query.toString(), new RowMapper<Y41bTipoInfraccionTree>() {
					public Y41bTipoInfraccionTree mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new Y41bTipoInfraccionTree(resultSet
								.getString("TTICODIGO"), resultSet
								.getString("TTINOMBRE"), resultSet
								.getString("TTINOMBREE"), resultSet
								.getString("TTICOSE"), resultSet
								.getString("TTIINSEL1"));
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the TipReqNormativo table.
	 * 
	 * @param y41bTipoInfraccionTree
	 *            Y41bTipoInfraccionTree
	 * @param tipreqnormativo
	 *            TipReqNormativo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long countTiposInfraccionHijos(
			Y41bTipoInfraccionTree y41bTipoInfraccionTree,
			TipReqNormativo tipreqnormativo, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  TIP_REQ_NORMATIVO t1   ");

		where.append(" AND UPPER(t1.TTICODIGO) like ? ESCAPE  '\\'");
		params.add(y41bTipoInfraccionTree.getTticodigo().toUpperCase() + "%");

		if (tipreqnormativo != null && tipreqnormativo.getTticodigo() != null) {
			where.append(" AND UPPER(t1.TTICODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTticodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTticodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTICODIGO IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinombre() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t1.TTINOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinombre().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ tipreqnormativo.getTtinombre().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.TTINOMBRE IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(t1.TTINOCO),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinombre().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ tipreqnormativo.getTtinombre().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.TTINOCO IS NOT NULL))");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinoco() != null) {
			where.append(" AND UPPER(t1.TTINOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinoco().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinoco().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOCO IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtitede() != null) {
			where.append(" AND UPPER(t1.TTITEDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtitede().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtitede().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTITEDE IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTticose() != null) {
			where.append(" AND t1.TTICOSE = ? ");
			params.add(tipreqnormativo.getTticose());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinoco2() != null) {
			where.append(" AND UPPER(t1.TTINOCO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinoco2().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinoco2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOCO2 IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtiinsel1() != null) {
			where.append(" AND t1.TTIINSEL1 = ? ");
			params.add(tipreqnormativo.getTtiinsel1());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTticol4() != null) {
			where.append(" AND UPPER(t1.TTICOL4) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTticol4().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTticol4().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTICOL4 IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinombree() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t1.TTINOMBREE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinombree().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ tipreqnormativo.getTtinombree().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.TTINOMBREE IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(t1.TTINOCOE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinombree().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ tipreqnormativo.getTtinombree().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.TTINOCOE IS NOT NULL))");

		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinombrei() != null) {
			where.append(" AND UPPER(t1.TTINOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinombrei().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinombrei().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOMBREI IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinombref() != null) {
			where.append(" AND UPPER(t1.TTINOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinombref().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinombref().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOMBREF IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinocoe() != null) {
			where.append(" AND UPPER(t1.TTINOCOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinocoe().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinocoe().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOCOE IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinocoi() != null) {
			where.append(" AND UPPER(t1.TTINOCOI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinocoi().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinocoi().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOCOI IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinocof() != null) {
			where.append(" AND UPPER(t1.TTINOCOF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinocof().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinocof().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOCOF IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtitedee() != null) {
			where.append(" AND UPPER(t1.TTITEDEE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtitedee().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtitedee().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTITEDEE IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtitedei() != null) {
			where.append(" AND UPPER(t1.TTITEDEI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtitedei().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtitedei().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTITEDEI IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtitedef() != null) {
			where.append(" AND UPPER(t1.TTITEDEF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtitedef().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtitedef().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTITEDEF IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTticodgrupo() != null) {
			where.append(" AND UPPER(t1.TTICODGRUPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTticodgrupo().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTticodgrupo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTICODGRUPO IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinombrea() != null) {
			where.append(" AND UPPER(t1.TTINOMBREA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinombrea().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinombrea().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOMBREA IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinocoa() != null) {
			where.append(" AND UPPER(t1.TTINOCOA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinocoa().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinocoa().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOCOA IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtitedea() != null) {
			where.append(" AND UPPER(t1.TTITEDEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtitedea().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtitedea().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTITEDEA IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTticoe7() != null) {
			where.append(" AND UPPER(t1.TTICOE7) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTticoe7().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTticoe7().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTICOE7 IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTticoinc() != null) {
			where.append(" AND UPPER(t1.TTICOINC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTticoinc().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTticoinc().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTICOINC IS NOT NULL");
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the TipReqNormativo table.
	 * 
	 * @param tipreqnormativo
	 *            TipReqNormativo
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(TipReqNormativo tipreqnormativo) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  TIP_REQ_NORMATIVO t1  ");
		if (tipreqnormativo != null && tipreqnormativo.getTticodigo() != null) {
			where.append(" AND t1.TTICODIGO = ?");
			params.add(tipreqnormativo.getTticodigo());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinombre() != null) {
			where.append(" AND t1.TTINOMBRE = ?");
			params.add(tipreqnormativo.getTtinombre());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinoco() != null) {
			where.append(" AND t1.TTINOCO = ?");
			params.add(tipreqnormativo.getTtinoco());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtitede() != null) {
			where.append(" AND t1.TTITEDE = ?");
			params.add(tipreqnormativo.getTtitede());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTticose() != null) {
			where.append(" AND t1.TTICOSE = ?");
			params.add(tipreqnormativo.getTticose());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinoco2() != null) {
			where.append(" AND t1.TTINOCO2 = ?");
			params.add(tipreqnormativo.getTtinoco2());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtiinsel1() != null) {
			where.append(" AND t1.TTIINSEL1 = ?");
			params.add(tipreqnormativo.getTtiinsel1());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTticol4() != null) {
			where.append(" AND t1.TTICOL4 = ?");
			params.add(tipreqnormativo.getTticol4());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinombree() != null) {
			where.append(" AND t1.TTINOMBREE = ?");
			params.add(tipreqnormativo.getTtinombree());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinombrei() != null) {
			where.append(" AND t1.TTINOMBREI = ?");
			params.add(tipreqnormativo.getTtinombrei());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinombref() != null) {
			where.append(" AND t1.TTINOMBREF = ?");
			params.add(tipreqnormativo.getTtinombref());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinocoe() != null) {
			where.append(" AND t1.TTINOCOE = ?");
			params.add(tipreqnormativo.getTtinocoe());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinocoi() != null) {
			where.append(" AND t1.TTINOCOI = ?");
			params.add(tipreqnormativo.getTtinocoi());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinocof() != null) {
			where.append(" AND t1.TTINOCOF = ?");
			params.add(tipreqnormativo.getTtinocof());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtitedee() != null) {
			where.append(" AND t1.TTITEDEE = ?");
			params.add(tipreqnormativo.getTtitedee());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtitedei() != null) {
			where.append(" AND t1.TTITEDEI = ?");
			params.add(tipreqnormativo.getTtitedei());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtitedef() != null) {
			where.append(" AND t1.TTITEDEF = ?");
			params.add(tipreqnormativo.getTtitedef());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTticodgrupo() != null) {
			where.append(" AND t1.TTICODGRUPO = ?");
			params.add(tipreqnormativo.getTticodgrupo());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinombrea() != null) {
			where.append(" AND t1.TTINOMBREA = ?");
			params.add(tipreqnormativo.getTtinombrea());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinocoa() != null) {
			where.append(" AND t1.TTINOCOA = ?");
			params.add(tipreqnormativo.getTtinocoa());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtitedea() != null) {
			where.append(" AND t1.TTITEDEA = ?");
			params.add(tipreqnormativo.getTtitedea());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTticoe7() != null) {
			where.append(" AND t1.TTICOE7 = ?");
			params.add(tipreqnormativo.getTticoe7());
		}
		if (tipreqnormativo != null && tipreqnormativo.getTticoinc() != null) {
			where.append(" AND t1.TTICOINC = ?");
			params.add(tipreqnormativo.getTticoinc());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the TipReqNormativo table using like.
	 * 
	 * @param tipreqnormativo
	 *            TipReqNormativo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipReqNormativo> findAllLike(TipReqNormativo tipreqnormativo,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.TTICODIGO TTICODIGO,t1.TTINOMBRE TTINOMBRE,t1.TTINOCO TTINOCO,t1.TTITEDE TTITEDE,t1.TTICOSE TTICOSE,t1.TTINOCO2 TTINOCO2,t1.TTIINSEL1 TTIINSEL1,t1.TTICOL4 TTICOL4,t1.TTINOMBREE TTINOMBREE,t1.TTINOMBREI TTINOMBREI,t1.TTINOMBREF TTINOMBREF,t1.TTINOCOE TTINOCOE,t1.TTINOCOI TTINOCOI,t1.TTINOCOF TTINOCOF,t1.TTITEDEE TTITEDEE,t1.TTITEDEI TTITEDEI,t1.TTITEDEF TTITEDEF,t1.TTICODGRUPO TTICODGRUPO,t1.TTINOMBREA TTINOMBREA,t1.TTINOCOA TTINOCOA,t1.TTITEDEA TTITEDEA,t1.TTICOE7 TTICOE7,t1.TTICOINC TTICOINC "
						+ "FROM TIP_REQ_NORMATIVO t1 ");

		if (tipreqnormativo != null && tipreqnormativo.getTticodigo() != null) {
			where.append(" AND UPPER(t1.TTICODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTticodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTticodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTICODIGO IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinombre() != null) {
			where.append(" AND UPPER(t1.TTINOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinombre().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOMBRE IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinoco() != null) {
			where.append(" AND UPPER(t1.TTINOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinoco().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinoco().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOCO IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtitede() != null) {
			where.append(" AND UPPER(t1.TTITEDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtitede().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtitede().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTITEDE IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTticose() != null) {
			where.append(" AND UPPER(t1.TTICOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTticose().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTticose().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTICOSE IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinoco2() != null) {
			where.append(" AND UPPER(t1.TTINOCO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinoco2().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinoco2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOCO2 IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtiinsel1() != null) {
			where.append(" AND UPPER(t1.TTIINSEL1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtiinsel1().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtiinsel1().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTIINSEL1 IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTticol4() != null) {
			where.append(" AND UPPER(t1.TTICOL4) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTticol4().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTticol4().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTICOL4 IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinombree() != null) {
			where.append(" AND UPPER(t1.TTINOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinombree().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinombree().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOMBREE IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinombrei() != null) {
			where.append(" AND UPPER(t1.TTINOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinombrei().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinombrei().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOMBREI IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinombref() != null) {
			where.append(" AND UPPER(t1.TTINOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinombref().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinombref().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOMBREF IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinocoe() != null) {
			where.append(" AND UPPER(t1.TTINOCOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinocoe().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinocoe().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOCOE IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinocoi() != null) {
			where.append(" AND UPPER(t1.TTINOCOI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinocoi().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinocoi().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOCOI IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinocof() != null) {
			where.append(" AND UPPER(t1.TTINOCOF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinocof().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinocof().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOCOF IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtitedee() != null) {
			where.append(" AND UPPER(t1.TTITEDEE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtitedee().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtitedee().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTITEDEE IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtitedei() != null) {
			where.append(" AND UPPER(t1.TTITEDEI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtitedei().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtitedei().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTITEDEI IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtitedef() != null) {
			where.append(" AND UPPER(t1.TTITEDEF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtitedef().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtitedef().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTITEDEF IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTticodgrupo() != null) {
			where.append(" AND UPPER(t1.TTICODGRUPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTticodgrupo().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTticodgrupo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTICODGRUPO IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinombrea() != null) {
			where.append(" AND UPPER(t1.TTINOMBREA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinombrea().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinombrea().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOMBREA IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinocoa() != null) {
			where.append(" AND UPPER(t1.TTINOCOA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinocoa().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinocoa().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOCOA IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtitedea() != null) {
			where.append(" AND UPPER(t1.TTITEDEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtitedea().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtitedea().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTITEDEA IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTticoe7() != null) {
			where.append(" AND UPPER(t1.TTICOE7) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTticoe7().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTticoe7().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTICOE7 IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTticoinc() != null) {
			where.append(" AND UPPER(t1.TTICOINC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTticoinc().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTticoinc().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTICOINC IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<TipReqNormativo>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}

	/**
	 * Finds rows in the TipReqNormativo table using like.
	 * 
	 * @param tipreqnormativo
	 *            TipReqNormativo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipReqNormativo> findAllLikeReqNormativo(
			TipReqNormativo tipreqnormativo, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.TTICODIGO TTICODIGO,t1.TTINOMBRE TTINOMBRE,t1.TTINOCO TTINOCO,t1.TTITEDE TTITEDE,t1.TTICOSE TTICOSE,t1.TTINOCO2 TTINOCO2,t1.TTIINSEL1 TTIINSEL1,t1.TTICOL4 TTICOL4,t1.TTINOMBREE TTINOMBREE,t1.TTINOMBREI TTINOMBREI,t1.TTINOMBREF TTINOMBREF,t1.TTINOCOE TTINOCOE,t1.TTINOCOI TTINOCOI,t1.TTINOCOF TTINOCOF,t1.TTITEDEE TTITEDEE,t1.TTITEDEI TTITEDEI,t1.TTITEDEF TTITEDEF,t1.TTICODGRUPO TTICODGRUPO,t1.TTINOMBREA TTINOMBREA,t1.TTINOCOA TTINOCOA,t1.TTITEDEA TTITEDEA,t1.TTICOE7 TTICOE7,t1.TTICOINC TTICOINC "
						+ "FROM TIP_REQ_NORMATIVO t1 ");

		if (tipreqnormativo != null && tipreqnormativo.getTticodigo() != null) {
			where.append(" AND UPPER(t1.TTICODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTticodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTticodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTICODIGO IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinombre() != null) {
			where.append(" AND UPPER(t1.TTINOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinombre().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOMBRE IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinoco() != null) {
			where.append(" AND UPPER(t1.TTINOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinoco().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinoco().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOCO IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtitede() != null) {
			where.append(" AND UPPER(t1.TTITEDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtitede().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtitede().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTITEDE IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTticose() != null) {
			where.append(" AND UPPER(t1.TTICOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTticose().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTticose().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTICOSE IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinoco2() != null) {
			where.append(" AND UPPER(t1.TTINOCO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinoco2().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinoco2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOCO2 IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtiinsel1() != null) {
			where.append(" AND UPPER(t1.TTIINSEL1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtiinsel1().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtiinsel1().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTIINSEL1 IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTticol4() != null) {
			where.append(" AND UPPER(t1.TTICOL4) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTticol4().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTticol4().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTICOL4 IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinombree() != null) {
			where.append(" AND UPPER(t1.TTINOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinombree().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinombree().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOMBREE IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinombrei() != null) {
			where.append(" AND UPPER(t1.TTINOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinombrei().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinombrei().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOMBREI IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinombref() != null) {
			where.append(" AND UPPER(t1.TTINOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinombref().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinombref().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOMBREF IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinocoe() != null) {
			where.append(" AND UPPER(t1.TTINOCOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinocoe().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinocoe().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOCOE IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinocoi() != null) {
			where.append(" AND UPPER(t1.TTINOCOI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinocoi().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinocoi().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOCOI IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinocof() != null) {
			where.append(" AND UPPER(t1.TTINOCOF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinocof().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinocof().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOCOF IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtitedee() != null) {
			where.append(" AND UPPER(t1.TTITEDEE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtitedee().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtitedee().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTITEDEE IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtitedei() != null) {
			where.append(" AND UPPER(t1.TTITEDEI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtitedei().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtitedei().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTITEDEI IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtitedef() != null) {
			where.append(" AND UPPER(t1.TTITEDEF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtitedef().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtitedef().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTITEDEF IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTticodgrupo() != null) {
			where.append(" AND UPPER(t1.TTICODGRUPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTticodgrupo().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTticodgrupo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTICODGRUPO IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinombrea() != null) {
			where.append(" AND UPPER(t1.TTINOMBREA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinombrea().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinombrea().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOMBREA IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinocoa() != null) {
			where.append(" AND UPPER(t1.TTINOCOA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinocoa().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinocoa().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOCOA IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtitedea() != null) {
			where.append(" AND UPPER(t1.TTITEDEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtitedea().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtitedea().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTITEDEA IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTticoe7() != null) {
			where.append(" AND UPPER(t1.TTICOE7) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTticoe7().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTticoe7().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTICOE7 IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTticoinc() != null) {
			where.append(" AND UPPER(t1.TTICOINC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTticoinc().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTticoinc().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTICOINC IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<TipReqNormativo>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}

	/**
	 * Finds rows in the TipReqNormativo table using like.
	 * 
	 * @param tipreqnormativo
	 *            TipReqNormativo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipReqNormativo> findAllArticulos(
			TipReqNormativo tipReqNormativo, Pagination pagination,
			List<String> articulosAniadidos) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE TTICODIGO LIKE 'N0%' ");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.TTICODIGO TTICODIGO,t1.TTINOMBRE TTINOMBRE,t1.TTINOCO TTINOCO,t1.TTITEDE TTITEDE,t1.TTICOSE TTICOSE,t1.TTINOCO2 TTINOCO2,t1.TTIINSEL1 TTIINSEL1,t1.TTICOL4 TTICOL4,t1.TTINOMBREE TTINOMBREE,t1.TTINOMBREI TTINOMBREI,t1.TTINOMBREF TTINOMBREF,t1.TTINOCOE TTINOCOE,t1.TTINOCOI TTINOCOI,t1.TTINOCOF TTINOCOF,t1.TTITEDEE TTITEDEE,t1.TTITEDEI TTITEDEI,t1.TTITEDEF TTITEDEF,t1.TTICODGRUPO TTICODGRUPO,t1.TTINOMBREA TTINOMBREA,t1.TTINOCOA TTINOCOA,t1.TTITEDEA TTITEDEA,t1.TTICOE7 TTICOE7,t1.TTICOINC TTICOINC "
						+ "FROM TIP_REQ_NORMATIVO t1 ");
		if (tipReqNormativo != null && tipReqNormativo.getTtinombre() != null
				&& !tipReqNormativo.getTtinombre().equals("")) {
			where.append(" AND UPPER(t1.TTINOMBRE) like ? ESCAPE  '\\'");
			params.add("%" + tipReqNormativo.getTtinombre().toUpperCase() + "%");
			where.append(" AND t1.TTINOMBRE IS NOT NULL");
		}

		if (articulosAniadidos != null) {
			for (String cod : articulosAniadidos) {
				where.append(" AND t1.TTICODIGO != ?");
				params.add(cod);
			}
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<TipReqNormativo>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}

	/**
	 * Finds rows in the TipReqNormativo table using like.
	 * 
	 * @param tipreqnormativo
	 *            TipReqNormativo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipReqNormativo> findAllMaterias(
			TipReqNormativo tipReqNormativo, Pagination pagination,
			List<String> materiasAniadidas) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE TTICODIGO LIKE 'NM%' ");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.TTICODIGO TTICODIGO,t1.TTINOMBRE TTINOMBRE,t1.TTINOCO TTINOCO,t1.TTITEDE TTITEDE,t1.TTICOSE TTICOSE,t1.TTINOCO2 TTINOCO2,t1.TTIINSEL1 TTIINSEL1,t1.TTICOL4 TTICOL4,t1.TTINOMBREE TTINOMBREE,t1.TTINOMBREI TTINOMBREI,t1.TTINOMBREF TTINOMBREF,t1.TTINOCOE TTINOCOE,t1.TTINOCOI TTINOCOI,t1.TTINOCOF TTINOCOF,t1.TTITEDEE TTITEDEE,t1.TTITEDEI TTITEDEI,t1.TTITEDEF TTITEDEF,t1.TTICODGRUPO TTICODGRUPO,t1.TTINOMBREA TTINOMBREA,t1.TTINOCOA TTINOCOA,t1.TTITEDEA TTITEDEA,t1.TTICOE7 TTICOE7,t1.TTICOINC TTICOINC "
						+ "FROM TIP_REQ_NORMATIVO t1 ");
		if (tipReqNormativo != null && tipReqNormativo.getTtinombre() != null
				&& !tipReqNormativo.getTtinombre().equals("")) {
			where.append(" AND UPPER(t1.TTINOMBRE) like ? ESCAPE  '\\'");
			params.add("%" + tipReqNormativo.getTtinombre().toUpperCase() + "%");
			where.append(" AND t1.TTINOMBRE IS NOT NULL");
		}

		if (materiasAniadidas != null) {
			for (String cod : materiasAniadidas) {
				where.append(" AND t1.TTICODIGO != ?");
				if (cod.contains("~")) {
					params.add(cod.split("~")[0]);
				} else {
					params.add(cod);
				}
			}
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<TipReqNormativo>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the TipReqNormativo table.
	 * 
	 * @param tipreqnormativo
	 *            TipReqNormativo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeReqNormativoCount(TipReqNormativo tipreqnormativo,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  TIP_REQ_NORMATIVO t1  ");
		if (tipreqnormativo != null && tipreqnormativo.getTticodigo() != null) {
			where.append(" AND UPPER(t1.TTICODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTticodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTticodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTICODIGO IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinombre() != null) {
			where.append(" AND UPPER(t1.TTINOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinombre().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOMBRE IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinoco() != null) {
			where.append(" AND UPPER(t1.TTINOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinoco().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinoco().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOCO IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtitede() != null) {
			where.append(" AND UPPER(t1.TTITEDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtitede().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtitede().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTITEDE IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTticose() != null) {
			where.append(" AND UPPER(t1.TTICOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTticose().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTticose().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTICOSE IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinoco2() != null) {
			where.append(" AND UPPER(t1.TTINOCO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinoco2().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinoco2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOCO2 IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtiinsel1() != null) {
			where.append(" AND UPPER(t1.TTIINSEL1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtiinsel1().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtiinsel1().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTIINSEL1 IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTticol4() != null) {
			where.append(" AND UPPER(t1.TTICOL4) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTticol4().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTticol4().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTICOL4 IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinombree() != null) {
			where.append(" AND UPPER(t1.TTINOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinombree().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinombree().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOMBREE IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinombrei() != null) {
			where.append(" AND UPPER(t1.TTINOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinombrei().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinombrei().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOMBREI IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinombref() != null) {
			where.append(" AND UPPER(t1.TTINOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinombref().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinombref().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOMBREF IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinocoe() != null) {
			where.append(" AND UPPER(t1.TTINOCOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinocoe().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinocoe().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOCOE IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinocoi() != null) {
			where.append(" AND UPPER(t1.TTINOCOI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinocoi().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinocoi().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOCOI IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinocof() != null) {
			where.append(" AND UPPER(t1.TTINOCOF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinocof().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinocof().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOCOF IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtitedee() != null) {
			where.append(" AND UPPER(t1.TTITEDEE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtitedee().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtitedee().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTITEDEE IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtitedei() != null) {
			where.append(" AND UPPER(t1.TTITEDEI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtitedei().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtitedei().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTITEDEI IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtitedef() != null) {
			where.append(" AND UPPER(t1.TTITEDEF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtitedef().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtitedef().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTITEDEF IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTticodgrupo() != null) {
			where.append(" AND UPPER(t1.TTICODGRUPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTticodgrupo().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTticodgrupo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTICODGRUPO IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinombrea() != null) {
			where.append(" AND UPPER(t1.TTINOMBREA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinombrea().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinombrea().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOMBREA IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtinocoa() != null) {
			where.append(" AND UPPER(t1.TTINOCOA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtinocoa().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtinocoa().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTINOCOA IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTtitedea() != null) {
			where.append(" AND UPPER(t1.TTITEDEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTtitedea().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTtitedea().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTITEDEA IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTticoe7() != null) {
			where.append(" AND UPPER(t1.TTICOE7) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTticoe7().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTticoe7().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTICOE7 IS NOT NULL");
		}
		if (tipreqnormativo != null && tipreqnormativo.getTticoinc() != null) {
			where.append(" AND UPPER(t1.TTICOINC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipreqnormativo.getTticoinc().toUpperCase() + "%");
			} else {
				params.add("%" + tipreqnormativo.getTticoinc().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TTICOINC IS NOT NULL");
		}
		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	@Transactional(readOnly = true)
	public Long findAllArticulosCount(TipReqNormativo tipReqNormativo,
			List<String> articulosAniadidos) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE TTICODIGO LIKE 'N0%' ");

		if (tipReqNormativo != null && tipReqNormativo.getTtinombre() != null
				&& !tipReqNormativo.getTtinombre().equals("")) {
			where.append(" AND UPPER(t1.TTINOMBRE) like ? ESCAPE  '\\'");
			params.add("%" + tipReqNormativo.getTtinombre().toUpperCase() + "%");
			where.append(" AND t1.TTINOMBRE IS NOT NULL");
		}

		if (articulosAniadidos != null) {
			for (String cod : articulosAniadidos) {
				where.append(" AND t1.TTICODIGO != ?");
				params.add(cod);
			}
		}

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  TIP_REQ_NORMATIVO t1  ");
		if (tipReqNormativo != null && tipReqNormativo.getTtinombre() != null) {
			where.append(" AND UPPER(t1.TTINOMBRE) like ? ESCAPE  '\\'");
			params.add("%" + tipReqNormativo.getTtinombre().toUpperCase() + "%");
			where.append(" AND t1.TTINOMBRE IS NOT NULL");
		}
		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	@Transactional(readOnly = true)
	public Long findAllMateriasCount(TipReqNormativo tipReqNormativo,
			List<String> materiasAniadidas) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE TTICODIGO LIKE 'NM%' ");

		if (tipReqNormativo != null && tipReqNormativo.getTtinombre() != null
				&& !tipReqNormativo.getTtinombre().equals("")) {
			where.append(" AND UPPER(t1.TTINOMBRE) like ? ESCAPE  '\\'");
			params.add("%" + tipReqNormativo.getTtinombre().toUpperCase() + "%");
			where.append(" AND t1.TTINOMBRE IS NOT NULL");
		}

		if (materiasAniadidas != null) {
			for (String cod : materiasAniadidas) {
				where.append(" AND t1.TTICODIGO != ?");
				params.add(cod);
			}
		}

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  TIP_REQ_NORMATIVO t1  ");
		if (tipReqNormativo != null && tipReqNormativo.getTtinombre() != null) {
			where.append(" AND UPPER(t1.TTINOMBRE) like ? ESCAPE  '\\'");
			params.add("%" + tipReqNormativo.getTtinombre().toUpperCase() + "%");
			where.append(" AND t1.TTINOMBRE IS NOT NULL");
		}
		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}
}
