package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.TipReqNormativo;
import com.ejie.y41b.model.Y41bTipoInfraccionTree;

/**
 * * TipReqNormativoDao  
 * 
 *  
 */

public interface TipReqNormativoDao {

	/**
	 * Inserts a single row in the TipReqNormativo table.
	 * 
	 * @param tipreqnormativo
	 *            TipReqNormativo
	 * @return TipReqNormativo
	 */
	TipReqNormativo add(TipReqNormativo tipreqnormativo);

	/**
	 * Updates a single row in the TipReqNormativo table.
	 * 
	 * @param tipreqnormativo
	 *            TipReqNormativo
	 * @return TipReqNormativo
	 */
	TipReqNormativo update(TipReqNormativo tipreqnormativo);

	/**
	 * Finds a single row in the TipReqNormativo table.
	 * 
	 * @param tipreqnormativo
	 *            TipReqNormativo
	 * @return TipReqNormativo
	 */
	TipReqNormativo find(TipReqNormativo tipreqnormativo);

	/**
	 * Finds a single row in the TipReqNormativo table.
	 * 
	 * @param tipreqnormativo
	 *            Pagination
	 * @return TipReqNormativo
	 */
	public TipReqNormativo findTipReqNormativoSeleccionable(
			TipReqNormativo tipreqnormativo);

	/**
	 * Deletes a single row in the TipReqNormativo table.
	 * 
	 * @param tipreqnormativo
	 *            TipReqNormativo
	 * @return
	 */
	void remove(TipReqNormativo tipreqnormativo);

	/**
	 * Finds a List of rows in the TipReqNormativo table.
	 * 
	 * @param tipreqnormativo
	 *            TipReqNormativo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<TipReqNormativo> findAll(TipReqNormativo tipreqnormativo,
			Pagination pagination);

	/**
	 * Finds a List of rows in the TipReqNormativo table.
	 * 
	 * @param y41bTipoInfraccionTree
	 *            Y41bTipoInfraccionTree
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Y41bTipoInfraccionTree> findAllTiposInfraccionPadre(
			Y41bTipoInfraccionTree y41bTipoInfraccionTree, Pagination pagination);

	/**
	 * Finds a List of rows in the TipReqNormativo table.
	 * 
	 * @param y41bTipoInfraccionTree
	 *            Y41bTipoInfraccionTree
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Y41bTipoInfraccionTree> findAllChildren(
			Y41bTipoInfraccionTree y41bTipoInfraccionTree, Pagination pagination);

	/**
	 * Counts rows in the TipReqNormativo table.
	 * 
	 * @param y41bTipoInfraccionTree
	 *            Y41bTipoInfraccionTree
	 * @param tipreqnormativo
	 *            TipReqNormativo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long countTiposInfraccionHijos(
			Y41bTipoInfraccionTree y41bTipoInfraccionTree,
			TipReqNormativo tipreqnormativo, Boolean startsWith);

	/**
	 * Counts rows in the TipReqNormativo table.
	 * 
	 * @param tipreqnormativo
	 *            TipReqNormativo
	 * @return List
	 */
	Long findAllCount(TipReqNormativo tipreqnormativo);

	/**
	 * Finds rows in the TipReqNormativo table using like.
	 * 
	 * @param tipreqnormativo
	 *            TipReqNormativo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<TipReqNormativo> findAllLike(TipReqNormativo tipreqnormativo,
			Pagination pagination, Boolean startsWith);

	/**
	 * Finds rows in the TipReqNormativo table using like.
	 * 
	 * @param tipreqnormativo
	 *            TipReqNormativo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<TipReqNormativo> findAllLikeReqNormativo(
			TipReqNormativo tipreqnormativo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds rows in the TipReqNormativo table using like.
	 * 
	 * @param tipreqnormativo
	 *            TipReqNormativo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<TipReqNormativo> findAllArticulos(TipReqNormativo tipReqNormativo,
			Pagination pagination, List<String> articulosAniadidos);

	/**
	 * Finds rows in the TipReqNormativo table using like.
	 * 
	 * @param tipreqnormativo
	 *            TipReqNormativo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<TipReqNormativo> findAllMaterias(TipReqNormativo tipReqNormativo,
			Pagination pagination, List<String> materiasAniadidas);

	/**
	 * Counts rows in the TipReqNormativo table.
	 * 
	 * @param tipreqnormativo
	 *            TipReqNormativo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeReqNormativoCount(TipReqNormativo tipreqnormativo,
			Boolean startsWith);

	/**
	 * Counts rows in the TipReqNormativo table.
	 * 
	 * @param tipreqnormativo
	 *            TipReqNormativo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllArticulosCount(TipReqNormativo tipReqNormativo,
			List<String> articulosAniadidos);

	/**
	 * Counts rows in the TipReqNormativo table.
	 * 
	 * @param tipreqnormativo
	 *            TipReqNormativo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllMateriasCount(TipReqNormativo tipReqNormativo,
			List<String> materiasAniadidas);
}
