package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Campanha;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.TipProtocolo;

/**
 * TipProtocoloDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class TipProtocoloDaoImpl implements TipProtocoloDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<TipProtocolo> rwMap = new RowMapper<TipProtocolo>() {
		public TipProtocolo mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new TipProtocolo(resultSet.getString("TPCODIGO"), resultSet.getString("TPNOMBRE"),
					resultSet.getString("TPCOTMO"), resultSet.getString("TPESTANDAR"), null);
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the TipProtocolo table.
	 * 
	 * @param tipprotocolo
	 *            Pagination
	 * @return TipProtocolo
	 */
	public TipProtocolo add(TipProtocolo tipprotocolo) {
		String query = "INSERT INTO TIP_PROTOCOLO (TPCODIGO, TPCOCM, TPNOMBRE, TPCOTMO, TPESTANDAR) VALUES (?,?,?,?,?)";
		Object getCampanhaCmcodigoAux = null;
		if (tipprotocolo.getCampanha() != null && tipprotocolo.getCampanha().getCmcodigo() != null) {
			getCampanhaCmcodigoAux = tipprotocolo.getCampanha().getCmcodigo();
		}
		this.jdbcTemplate.update(query, tipprotocolo.getTpcodigo(), getCampanhaCmcodigoAux, tipprotocolo.getTpnombre(),
				tipprotocolo.getTpcotmo(), tipprotocolo.getTpestandar());
		return tipprotocolo;
	}

	/**
	 * Updates a single row in the TipProtocolo table.
	 * 
	 * @param tipprotocolo
	 *            Pagination
	 * @return TipProtocolo
	 */
	public TipProtocolo update(TipProtocolo tipprotocolo) {
		String query = "UPDATE TIP_PROTOCOLO SET TPCOCM=?, TPNOMBRE=?, TPCOTMO=?, TPESTANDAR=? WHERE TPCODIGO=?";
		Object getCampanhaCmcodigoAux = null;
		if (tipprotocolo.getCampanha() != null && tipprotocolo.getCampanha().getCmcodigo() != null) {
			getCampanhaCmcodigoAux = tipprotocolo.getCampanha().getCmcodigo();
		}
		this.jdbcTemplate.update(query, getCampanhaCmcodigoAux, tipprotocolo.getTpnombre(), tipprotocolo.getTpcotmo(),
				tipprotocolo.getTpestandar(), tipprotocolo.getTpcodigo());
		return tipprotocolo;
	}

	/**
	 * Finds a single row in the TipProtocolo table.
	 * 
	 * @param tipprotocolo
	 *            Pagination
	 * @return TipProtocolo
	 */
	@Transactional(readOnly = true)
	public TipProtocolo find(TipProtocolo tipprotocolo) {
		String query = "SELECT t1.TPCODIGO TPCODIGO, t1.TPNOMBRE TPNOMBRE, t1.TPCOTMO TPCOTMO, t1.TPESTANDAR TPESTANDAR, t2.CMCODIGO CAMPANHACMCODIGO, t2.CMNOMBRE CAMPANHACMNOMBRE, t2.CMCOPS CAMPANHACMCOPS, t2.CMNOAR CAMPANHACMNOAR, t2.CMNOPS CAMPANHACMNOPS, t2.CMCOTMO CAMPANHACMCOTMO, t2.CMORIGEN CAMPANHACMORIGEN, t2.CMTIPO CAMPANHACMTIPO, t2.CMCARACTER CAMPANHACMCARACTER, t2.CMFECHAINICIO CAMPANHACMFECHAINICIO, t2.CMFECHACIERRE CAMPANHACMFECHACIERRE, t2.CMACTIVA CAMPANHACMACTIVA FROM TIP_PROTOCOLO t1 , CAMPANHA t2  WHERE t1.TPCODIGO = ?   AND t1.TPCOCM= t2.CMCODIGO(+)";

		List<TipProtocolo> tipprotocoloList = this.jdbcTemplate.query(query, this.rwMap, tipprotocolo.getTpcodigo());
		return (TipProtocolo) DataAccessUtils.uniqueResult(tipprotocoloList);
	}

	/**
	 * Removes a single row in the TipProtocolo table.
	 * 
	 * @param tipprotocolo
	 *            Pagination
	 * @return
	 */
	public void remove(TipProtocolo tipprotocolo) {
		String query = "DELETE FROM TIP_PROTOCOLO WHERE TPCODIGO=?";
		this.jdbcTemplate.update(query, tipprotocolo.getTpcodigo());
	}

	/**
	 * Finds a List of rows in the TipProtocolo table.
	 * 
	 * @param tipprotocolo
	 *            TipProtocolo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipProtocolo> findAll(TipProtocolo tipprotocolo, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TPCODIGO TPCODIGO,t1.TPNOMBRE TPNOMBRE,t1.TPCOTMO TPCOTMO,t1.TPESTANDAR TPESTANDAR,t2.CMCODIGO CAMPANHACMCODIGO,t2.CMNOMBRE CAMPANHACMNOMBRE,t2.CMCOPS CAMPANHACMCOPS,t2.CMNOAR CAMPANHACMNOAR,t2.CMNOPS CAMPANHACMNOPS,t2.CMCOTMO CAMPANHACMCOTMO,t2.CMORIGEN CAMPANHACMORIGEN,t2.CMTIPO CAMPANHACMTIPO, t2.CMCARACTER CAMPANHACMCARACTER,t2.CMFECHAINICIO CAMPANHACMFECHAINICIO,t2.CMFECHACIERRE CAMPANHACMFECHACIERRE,t2.CMACTIVA CAMPANHACMACTIVA ");
		query.append("FROM TIP_PROTOCOLO t1 ,CAMPANHA t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tipprotocolo);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.TPCOCM= t2.CMCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<TipProtocolo>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the TipProtocolo table.
	 * 
	 * @param tipprotocolo
	 *            TipProtocolo
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(TipProtocolo tipprotocolo) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM TIP_PROTOCOLO t1 , CAMPANHA t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tipprotocolo);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.TPCOCM= t2.CMCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the TipProtocolo table using like.
	 * 
	 * @param tipprotocolo
	 *            TipProtocolo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipProtocolo> findAllLike(TipProtocolo tipprotocolo, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.TPCODIGO= t2.TPCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  distinct t1.TPCODIGO TPCODIGO,t1.TPNOMBRE TPNOMBRE,t1.TPCOTMO TPCOTMO, t1.TPESTANDAR TPESTANDAR "
						+ "FROM TIP_PROTOCOLO t1 ,CAMPANHA_TIPOPROTOCOLO t2 ");

		if (tipprotocolo != null && tipprotocolo.getTpcodigo() != null) {
			where.append(" AND UPPER(t1.TPCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipprotocolo.getTpcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tipprotocolo.getTpcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.TPCODIGO IS NOT NULL");
		}
		if (tipprotocolo != null && tipprotocolo.getCampanha() != null
				&& tipprotocolo.getCampanha().getCmcodigo() != null) {
			where.append(" AND t2.CMCODIGO = ?");
			params.add(tipprotocolo.getCampanha().getCmcodigo());
		}
		if (tipprotocolo != null && tipprotocolo.getTpnombre() != null) {
			where.append(" AND UPPER(t1.TPNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipprotocolo.getTpnombre().toUpperCase() + "%");
			} else {
				params.add("%" + tipprotocolo.getTpnombre().toUpperCase() + "%");
			}
			where.append(" AND t1.TPNOMBRE IS NOT NULL");
		}

		if (tipprotocolo != null && tipprotocolo.getTpestandar() != null
				&& tipprotocolo.getTpestandar().equals(Y41bConstantes.VALOR_SI)) {
			where.append(" AND t1.TPESTANDAR = ? ");
			params.add(tipprotocolo.getTpestandar());
		}

		if (tipprotocolo != null && tipprotocolo.getTpestandar() != null
				&& tipprotocolo.getTpestandar().equals(Y41bConstantes.VALOR_NO)) {
			where.append(" AND (t1.TPESTANDAR = ? OR t1.TPESTANDAR IS NULL)");
			params.add(tipprotocolo.getTpestandar());
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<TipProtocolo>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the TipProtocolo table.
	 * 
	 * @param tipprotocolo
	 *            TipProtocolo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(TipProtocolo tipprotocolo, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.TPCODIGO= t2.TPCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(distinct t1.TPCODIGO) FROM  TIP_PROTOCOLO t1   ,  CAMPANHA_TIPOPROTOCOLO t2  ");
		if (tipprotocolo != null && tipprotocolo.getTpcodigo() != null) {
			where.append(" AND UPPER(t1.TPCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipprotocolo.getTpcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tipprotocolo.getTpcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.TPCODIGO IS NOT NULL");
		}
		if (tipprotocolo != null && tipprotocolo.getCampanha() != null
				&& tipprotocolo.getCampanha().getCmcodigo() != null) {
			where.append(" AND t2.CMCODIGO = ?");
			params.add(tipprotocolo.getCampanha().getCmcodigo());
		}
		if (tipprotocolo != null && tipprotocolo.getTpnombre() != null) {
			where.append(" AND UPPER(t1.TPNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipprotocolo.getTpnombre().toUpperCase() + "%");
			} else {
				params.add("%" + tipprotocolo.getTpnombre().toUpperCase() + "%");
			}
			where.append(" AND t1.TPNOMBRE IS NOT NULL");
		}

		if (tipprotocolo != null && tipprotocolo.getTpestandar() != null
				&& tipprotocolo.getTpestandar().equals(Y41bConstantes.VALOR_SI)) {
			where.append(" AND t1.TPESTANDAR = ? ");
			params.add(tipprotocolo.getTpestandar());
		}

		if (tipprotocolo != null && tipprotocolo.getTpestandar() != null
				&& tipprotocolo.getTpestandar().equals(Y41bConstantes.VALOR_NO)) {
			where.append(" AND (t1.TPESTANDAR = ? OR t1.TPESTANDAR IS NULL)");
			params.add(tipprotocolo.getTpestandar());
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TipProtocolo entity
	 * 
	 * @param tipprotocolo
	 *            TipProtocolo Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(TipProtocolo tipprotocolo) {

		StringBuilder where = new StringBuilder(TipProtocoloDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tipprotocolo != null && tipprotocolo.getTpcodigo() != null) {
			where.append(" AND t1.TPCODIGO = ?");
			params.add(tipprotocolo.getTpcodigo());
		}
		if (tipprotocolo != null && tipprotocolo.getCampanha() != null
				&& tipprotocolo.getCampanha().getCmcodigo() != null) {
			where.append(" AND t2.CMCODIGO = ?");
			params.add(tipprotocolo.getCampanha().getCmcodigo());
		}
		if (tipprotocolo != null && tipprotocolo.getCampanha() != null
				&& tipprotocolo.getCampanha().getCmnombre() != null) {
			where.append(" AND t2.CMNOMBRE = ?");
			params.add(tipprotocolo.getCampanha().getCmnombre());
		}
		if (tipprotocolo != null && tipprotocolo.getCampanha() != null
				&& tipprotocolo.getCampanha().getCmcops() != null) {
			where.append(" AND t2.CMCOPS = ?");
			params.add(tipprotocolo.getCampanha().getCmcops());
		}
		if (tipprotocolo != null && tipprotocolo.getCampanha() != null
				&& tipprotocolo.getCampanha().getCmnoar() != null) {
			where.append(" AND t2.CMNOAR = ?");
			params.add(tipprotocolo.getCampanha().getCmnoar());
		}
		if (tipprotocolo != null && tipprotocolo.getCampanha() != null
				&& tipprotocolo.getCampanha().getCmnops() != null) {
			where.append(" AND t2.CMNOPS = ?");
			params.add(tipprotocolo.getCampanha().getCmnops());
		}
		if (tipprotocolo != null && tipprotocolo.getCampanha() != null
				&& tipprotocolo.getCampanha().getCmcotmo() != null) {
			where.append(" AND t2.CMCOTMO = ?");
			params.add(tipprotocolo.getCampanha().getCmcotmo());
		}
		if (tipprotocolo != null && tipprotocolo.getCampanha() != null
				&& tipprotocolo.getCampanha().getCmorigen() != null) {
			where.append(" AND t2.CMORIGEN = ?");
			params.add(tipprotocolo.getCampanha().getCmorigen());
		}
		if (tipprotocolo != null && tipprotocolo.getCampanha() != null
				&& tipprotocolo.getCampanha().getCmtipo() != null) {
			where.append(" AND t2.CMTIPO = ?");
			params.add(tipprotocolo.getCampanha().getCmtipo());
		}
		if (tipprotocolo != null && tipprotocolo.getCampanha() != null
				&& tipprotocolo.getCampanha().getCmfechainicio() != null) {
			where.append(" AND t2.CMFECHAINICIO = ?");
			params.add(tipprotocolo.getCampanha().getCmfechainicio());
		}
		if (tipprotocolo != null && tipprotocolo.getCampanha() != null
				&& tipprotocolo.getCampanha().getCmfechacierre() != null) {
			where.append(" AND t2.CMFECHACIERRE = ?");
			params.add(tipprotocolo.getCampanha().getCmfechacierre());
		}
		if (tipprotocolo != null && tipprotocolo.getCampanha() != null
				&& tipprotocolo.getCampanha().getCmactiva() != null) {
			where.append(" AND t2.CMACTIVA = ?");
			params.add(tipprotocolo.getCampanha().getCmactiva());
		}
		if (tipprotocolo != null && tipprotocolo.getTpnombre() != null) {
			where.append(" AND t1.TPNOMBRE = ?");
			params.add(tipprotocolo.getTpnombre());
		}
		if (tipprotocolo != null && tipprotocolo.getTpcotmo() != null) {
			where.append(" AND t1.TPCOTMO = ?");
			params.add(tipprotocolo.getTpcotmo());
		}
		if (tipprotocolo != null && tipprotocolo.getTpestandar() != null) {
			where.append(" AND t1.TPESTANDAR = ?");
			params.add(tipprotocolo.getTpestandar());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Inserts a single row in the CampanhaTipoprotocolo table.
	 * 
	 * @param tipprotocolo
	 *            TipProtocolo
	 * @return TipProtocolo
	 */
	public TipProtocolo addCampanhaTipoprotocolo(TipProtocolo tipprotocolo) {
		String query = "INSERT INTO L21TTT00 " + "( TPCODIGO,CMCODIGO) " + " values (?, ?)";

		List<Campanha> auxiliarCampanha = tipprotocolo.getCampanhas();
		Iterator<Campanha> it = auxiliarCampanha.iterator();
		while (it.hasNext()) {
			Campanha campanha = (Campanha) it.next();
			this.jdbcTemplate.update(query, tipprotocolo.getTpcodigo(), campanha.getCmcodigo());
		}
		return tipprotocolo;
	}

	/**
	 * Deletes a single row in the CampanhaTipoprotocolo table.
	 * 
	 * @param tipprotocolo
	 *            TipProtocolo
	 * @return
	 */
	public void removeCampanhaTipoprotocolo(TipProtocolo tipprotocolo) {
		String query = "DELETE  FROM L21TTT00 " + " WHERE TPCODIGO=? AND CMCODIGO=?";
		List<Campanha> auxiliarCampanha = tipprotocolo.getCampanhas();
		Iterator<Campanha> it = auxiliarCampanha.iterator();
		while (it.hasNext()) {
			Campanha campanha = (Campanha) it.next();
			this.jdbcTemplate.update(query, tipprotocolo.getTpcodigo(), campanha.getCmcodigo());
		}
	}

	/**
	 * Find a single row in the findCampanhaTipoprotocolo Many To Many
	 * relationship.
	 * 
	 * @param tipprotocolo
	 *            TipProtocolo
	 * @param campanha
	 *            Campanha
	 * @param pagination
	 *            Pagination
	 * @return TipProtocolo
	 */
	@Transactional(readOnly = true)
	public TipProtocolo findCampanhaTipoprotocolo(TipProtocolo tipprotocolo, Campanha campanha, Pagination pagination) {

		StringBuilder where = new StringBuilder(TipProtocoloDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		where.append("where t1.CMCODIGO = t2.CMCODIGO AND t1.TPCODIGO=?");

		params.add(tipprotocolo.getTpcodigo());

		if (campanha.getCmcodigo() != null) {
			where.append(" AND t2.CMCODIGO = ?");
			params.add(campanha.getCmcodigo());
		}
		if (campanha.getCmnombre() != null) {
			where.append(" AND t2.CMNOMBRE = ?");
			params.add(campanha.getCmnombre());
		}
		if (campanha.getCmcops() != null) {
			where.append(" AND t2.CMCOPS = ?");
			params.add(campanha.getCmcops());
		}
		if (campanha.getCmnoar() != null) {
			where.append(" AND t2.CMNOAR = ?");
			params.add(campanha.getCmnoar());
		}
		if (campanha.getCmnops() != null) {
			where.append(" AND t2.CMNOPS = ?");
			params.add(campanha.getCmnops());
		}
		if (campanha.getCmcotmo() != null) {
			where.append(" AND t2.CMCOTMO = ?");
			params.add(campanha.getCmcotmo());
		}
		if (campanha.getCmorigen() != null) {
			where.append(" AND t2.CMORIGEN = ?");
			params.add(campanha.getCmorigen());
		}
		if (campanha.getCmtipo() != null) {
			where.append(" AND t2.CMTIPO = ?");
			params.add(campanha.getCmtipo());
		}
		if (campanha.getCmfechainicio() != null) {
			where.append(" AND t2.CMFECHAINICIO = ?");
			params.add(campanha.getCmfechainicio());
		}
		if (campanha.getCmfechacierre() != null) {
			where.append(" AND t2.CMFECHACIERRE = ?");
			params.add(campanha.getCmfechacierre());
		}
		if (campanha.getCmactiva() != null) {
			where.append(" AND t2.CMACTIVA = ?");
			params.add(campanha.getCmactiva());
		}

		StringBuilder query = new StringBuilder(
				"SELECT t2.Cmcodigo CMCODIGO, t2.CMNOMBRE CMNOMBRE, t2.CMCOPS CMCOPS, t2.CMNOAR CMNOAR, t2.CMNOPS CMNOPS, t2.CMCOTMO CMCOTMO, t2.CMORIGEN CMORIGEN, t2.CMTIPO CMTIPO, t2.CMCARACTER CMCARACTER, t2.CMFECHAINICIO CMFECHAINICIO, t2.CMFECHACIERRE CMFECHACIERRE, t2.CMACTIVA CMACTIVA FROM L21ttt00 t1,L2110T00 t2  ");
		query.append(where);

		StringBuilder order = new StringBuilder(TipProtocoloDaoImpl.STRING_BUILDER_INIT);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" order by " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuilder(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		List<Campanha> listaHijo = this.jdbcTemplate.query(query.toString(), new RowMapper<Campanha>() {
			public Campanha mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new Campanha(resultSet.getString("CMCODIGO"), resultSet.getString("CMNOMBRE"),
						resultSet.getString("CMCOPS"), resultSet.getString("CMNOAR"), resultSet.getString("CMNOPS"),
						resultSet.getString("CMCOTMO"), resultSet.getString("CMORIGEN"), resultSet.getString("CMTIPO"),
						resultSet.getString("CMCARACTER"), resultSet.getDate("CMFECHAINICIO"),
						resultSet.getDate("CMFECHACIERRE"), resultSet.getString("CMACTIVA"), null, null, null, null,
						null, null, null, null, null, null);
			}
		}, params.toArray());
		tipprotocolo.setCampanhas(listaHijo);
		return tipprotocolo;
	}

	/**
	 * Counts rows in the CampanhaTipoprotocolo table.
	 * 
	 * @param tipprotocolo
	 *            TipProtocolo
	 * @param campanha
	 *            Campanha
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findCampanhaTipoprotocoloCount(TipProtocolo tipprotocolo, Campanha campanha) {

		StringBuilder where = new StringBuilder(TipProtocoloDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();
		where.append("where t1.CMCODIGO = t2.CMCODIGO AND t1.TPCODIGO=?");

		params.add(tipprotocolo.getTpcodigo());

		if (campanha.getCmcodigo() != null) {
			where.append(" AND t2.CMCODIGO = ?");
			params.add(campanha.getCmcodigo());
		}
		if (campanha.getCmnombre() != null) {
			where.append(" AND t2.CMNOMBRE = ?");
			params.add(campanha.getCmnombre());
		}
		if (campanha.getCmcops() != null) {
			where.append(" AND t2.CMCOPS = ?");
			params.add(campanha.getCmcops());
		}
		if (campanha.getCmnoar() != null) {
			where.append(" AND t2.CMNOAR = ?");
			params.add(campanha.getCmnoar());
		}
		if (campanha.getCmnops() != null) {
			where.append(" AND t2.CMNOPS = ?");
			params.add(campanha.getCmnops());
		}
		if (campanha.getCmcotmo() != null) {
			where.append(" AND t2.CMCOTMO = ?");
			params.add(campanha.getCmcotmo());
		}
		if (campanha.getCmorigen() != null) {
			where.append(" AND t2.CMORIGEN = ?");
			params.add(campanha.getCmorigen());
		}
		if (campanha.getCmtipo() != null) {
			where.append(" AND t2.CMTIPO = ?");
			params.add(campanha.getCmtipo());
		}
		if (campanha.getCmfechainicio() != null) {
			where.append(" AND t2.CMFECHAINICIO = ?");
			params.add(campanha.getCmfechainicio());
		}
		if (campanha.getCmfechacierre() != null) {
			where.append(" AND t2.CMFECHACIERRE = ?");
			params.add(campanha.getCmfechacierre());
		}
		if (campanha.getCmactiva() != null) {
			where.append(" AND t2.CMACTIVA = ?");
			params.add(campanha.getCmactiva());
		}

		StringBuilder query = new StringBuilder("SELECT count(1) FROM L21ttt00 t1,L2110T00 t2  ");
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
}
